#!/usr/bin/env python
# -*- coding: utf-8 -*-

from distutils.core import setup
setup(
  name = 'tablebase',         # How you named your package folder (MyLib)
  version = '0.4',      # Start with a small number and increase it with every change you make
  license='MIT',        # Chose a license from here: https://help.github.com/articles/licensing-a-repository
  description = 'To make tables in python as easy as printing to the console',   # Give a short description about your library
  author = 'Maximilian Lange',                   # Type in your name
  author_email = 'maxhlange@gmail.com',      # Type in your E-Mail
  url = 'https://github.com/sasmlange/tablebase',   # Provide either the link to your github or to your website
  download_url = 'https://github.com/sasmlange/tablebase/blob/d9ab86d4cab0508e97cdf0157e41addbc43f8783/dist/tablebase-0.1.0.tar.gz',    # I explain this later on
  keywords = ['Table', 'CSV'],   # Keywords that define your package best
  install_requires=[            # I get to this in a second
          'termcolor',
  ],
  classifiers=[
    'Development Status :: 3 - Alpha',      # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
    'Intended Audience :: Developers',      # Define that your audience are developers
    'Topic :: Software Development :: Build Tools',
    'License :: OSI Approved :: MIT License',   # Again, pick a license
    'Programming Language :: Python :: 3.7',
    'Programming Language :: Python :: 3.8',
    'Programming Language :: Python :: 3.9',
  ],
)

setup(
      name='termcolor',
      version='0.4',
      description='To make tables in python as easy as printing to the console',
      long_description="To make tables in python as easy as printing to the console",
      author='Maximilian Lange',
      license='MIT',
      author_email='maxhlange@gmail.com',
      url='https://pypi.org/project/tablebase/',
      py_modules=['tablebase'],
      classifiers=[
          'Development Status :: 5 - Production/Stable',
          'Environment :: Console',
          'Intended Audience :: Developers',
          'License :: OSI Approved :: MIT License',
          'Operating System :: OS Independent',
          'Programming Language :: Python',
          'Topic :: Terminals'
          ]
      )