# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TenantParameters(Model):
    """Configuration options for creating new tenant.

    All required parameters must be populated in order to send to Azure.

    :param tenant_id: The tenant identifier
    :type tenant_id: str
    :param issuer_seed: Issuer seed used for deterministic DID generation.
     If omitted, a random DID/Key is generated.
    :type issuer_seed: str
    :param name: Required. The tenant name
    :type name: str
    :param image_url: URL of tenant profile image
    :type image_url: str
    :param network_id: Ledger network identifier.
     Default value is Sovrin Staging (sovrin-staging).
    :type network_id: str
    :param endorser_type: Possible values include: 'Shared', 'Dedicated',
     'Delegated'
    :type endorser_type: str or ~provider.models.enum
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'issuer_seed': {'key': 'issuerSeed', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'image_url': {'key': 'imageUrl', 'type': 'str'},
        'network_id': {'key': 'networkId', 'type': 'str'},
        'endorser_type': {'key': 'endorserType', 'type': 'str'},
    }

    def __init__(self, *, name: str, tenant_id: str=None, issuer_seed: str=None, image_url: str=None, network_id: str=None, endorser_type=None, **kwargs) -> None:
        super(TenantParameters, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.issuer_seed = issuer_seed
        self.name = name
        self.image_url = image_url
        self.network_id = network_id
        self.endorser_type = endorser_type
