# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TenantParameters(Model):
    """Configuration options for creating new tenant.

    All required parameters must be populated in order to send to Azure.

    :param tenant_id: The tenant identifier
    :type tenant_id: str
    :param issuer_seed: Issuer seed used for deterministic DID generation.
     If omitted, a random DID/Key is generated.
    :type issuer_seed: str
    :param name: Required. The tenant name
    :type name: str
    :param image_url: URL of tenant profile image
    :type image_url: str
    :param network_id: Ledger network identifier.
     Default value is Sovrin Staging (sovrin-staging).
    :type network_id: str
    :param endorser_type: Possible values include: 'Shared', 'Dedicated',
     'Delegated'
    :type endorser_type: str or ~provider.models.enum
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'issuer_seed': {'key': 'issuerSeed', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'image_url': {'key': 'imageUrl', 'type': 'str'},
        'network_id': {'key': 'networkId', 'type': 'str'},
        'endorser_type': {'key': 'endorserType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TenantParameters, self).__init__(**kwargs)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.issuer_seed = kwargs.get('issuer_seed', None)
        self.name = kwargs.get('name', None)
        self.image_url = kwargs.get('image_url', None)
        self.network_id = kwargs.get('network_id', None)
        self.endorser_type = kwargs.get('endorser_type', None)
