# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IssuerStatusContract(Model):
    """Issuer Status contract.

    :param acceptance_text: Transaction Author Agreement Text
    :type acceptance_text: str
    :param acceptance_version: Transaction Author Agreement version
    :type acceptance_version: str
    :param acceptance_digest: The acceptance digest
    :type acceptance_digest: str
    :param acceptance_time: The acceptance time
    :type acceptance_time: long
    :param require_acceptance: Indicates if user needs to accept the latest
     agreement on the network
    :type require_acceptance: bool
    :param transaction_endorsement: Possible values include: 'Shared',
     'Dedicated', 'Delegated'
    :type transaction_endorsement: str or ~credentials.models.enum
    :param issuer_can_endorse: Indicates if the user has Endorser status
    :type issuer_can_endorse: bool
    """

    _attribute_map = {
        'acceptance_text': {'key': 'acceptanceText', 'type': 'str'},
        'acceptance_version': {'key': 'acceptanceVersion', 'type': 'str'},
        'acceptance_digest': {'key': 'acceptanceDigest', 'type': 'str'},
        'acceptance_time': {'key': 'acceptanceTime', 'type': 'long'},
        'require_acceptance': {'key': 'requireAcceptance', 'type': 'bool'},
        'transaction_endorsement': {'key': 'transactionEndorsement', 'type': 'str'},
        'issuer_can_endorse': {'key': 'issuerCanEndorse', 'type': 'bool'},
    }

    def __init__(self, *, acceptance_text: str=None, acceptance_version: str=None, acceptance_digest: str=None, acceptance_time: int=None, require_acceptance: bool=None, transaction_endorsement=None, issuer_can_endorse: bool=None, **kwargs) -> None:
        super(IssuerStatusContract, self).__init__(**kwargs)
        self.acceptance_text = acceptance_text
        self.acceptance_version = acceptance_version
        self.acceptance_digest = acceptance_digest
        self.acceptance_time = acceptance_time
        self.require_acceptance = require_acceptance
        self.transaction_endorsement = transaction_endorsement
        self.issuer_can_endorse = issuer_can_endorse
