# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IssuerStatusContract(Model):
    """Issuer Status contract.

    :param acceptance_text: Transaction Author Agreement Text
    :type acceptance_text: str
    :param acceptance_version: Transaction Author Agreement version
    :type acceptance_version: str
    :param acceptance_digest: The acceptance digest
    :type acceptance_digest: str
    :param acceptance_time: The acceptance time
    :type acceptance_time: long
    :param require_acceptance: Indicates if user needs to accept the latest
     agreement on the network
    :type require_acceptance: bool
    :param transaction_endorsement: Possible values include: 'Shared',
     'Dedicated', 'Delegated'
    :type transaction_endorsement: str or ~credentials.models.enum
    :param issuer_can_endorse: Indicates if the user has Endorser status
    :type issuer_can_endorse: bool
    """

    _attribute_map = {
        'acceptance_text': {'key': 'acceptanceText', 'type': 'str'},
        'acceptance_version': {'key': 'acceptanceVersion', 'type': 'str'},
        'acceptance_digest': {'key': 'acceptanceDigest', 'type': 'str'},
        'acceptance_time': {'key': 'acceptanceTime', 'type': 'long'},
        'require_acceptance': {'key': 'requireAcceptance', 'type': 'bool'},
        'transaction_endorsement': {'key': 'transactionEndorsement', 'type': 'str'},
        'issuer_can_endorse': {'key': 'issuerCanEndorse', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(IssuerStatusContract, self).__init__(**kwargs)
        self.acceptance_text = kwargs.get('acceptance_text', None)
        self.acceptance_version = kwargs.get('acceptance_version', None)
        self.acceptance_digest = kwargs.get('acceptance_digest', None)
        self.acceptance_time = kwargs.get('acceptance_time', None)
        self.require_acceptance = kwargs.get('require_acceptance', None)
        self.transaction_endorsement = kwargs.get('transaction_endorsement', None)
        self.issuer_can_endorse = kwargs.get('issuer_can_endorse', None)
