# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class TransactionChargeAuthorization(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'email': 'str',
        'amount': 'int',
        'authorization_code': 'str',
        'reference': 'str',
        'currency': 'str',
        'metadata': 'str',
        'split_code': 'str',
        'subaccount': 'str',
        'transaction_charge': 'str',
        'bearer': 'str',
        'queue': 'bool'
    }

    attribute_map = {
        'email': 'email',
        'amount': 'amount',
        'authorization_code': 'authorization_code',
        'reference': 'reference',
        'currency': 'currency',
        'metadata': 'metadata',
        'split_code': 'split_code',
        'subaccount': 'subaccount',
        'transaction_charge': 'transaction_charge',
        'bearer': 'bearer',
        'queue': 'queue'
    }

    def __init__(self, email=None, amount=None, authorization_code=None, reference=None, currency=None, metadata=None, split_code=None, subaccount=None, transaction_charge=None, bearer=None, queue=None, local_vars_configuration=None):  # noqa: E501
        """TransactionChargeAuthorization - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._email = None
        self._amount = None
        self._authorization_code = None
        self._reference = None
        self._currency = None
        self._metadata = None
        self._split_code = None
        self._subaccount = None
        self._transaction_charge = None
        self._bearer = None
        self._queue = None
        self.discriminator = None

        self.email = email
        self.amount = amount
        self.authorization_code = authorization_code
        if reference is not None:
            self.reference = reference
        if currency is not None:
            self.currency = currency
        if metadata is not None:
            self.metadata = metadata
        if split_code is not None:
            self.split_code = split_code
        if subaccount is not None:
            self.subaccount = subaccount
        if transaction_charge is not None:
            self.transaction_charge = transaction_charge
        if bearer is not None:
            self.bearer = bearer
        if queue is not None:
            self.queue = queue

    @property
    def email(self):
        """Gets the email of this TransactionChargeAuthorization.  # noqa: E501

        Customer's email address  # noqa: E501

        :return: The email of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this TransactionChargeAuthorization.

        Customer's email address  # noqa: E501

        :param email: The email of this TransactionChargeAuthorization.  # noqa: E501
        :type email: str
        """
        if self.local_vars_configuration.client_side_validation and email is None:  # noqa: E501
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def amount(self):
        """Gets the amount of this TransactionChargeAuthorization.  # noqa: E501

        Amount should be in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :return: The amount of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this TransactionChargeAuthorization.

        Amount should be in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :param amount: The amount of this TransactionChargeAuthorization.  # noqa: E501
        :type amount: int
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def authorization_code(self):
        """Gets the authorization_code of this TransactionChargeAuthorization.  # noqa: E501

        Valid authorization code to charge  # noqa: E501

        :return: The authorization_code of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._authorization_code

    @authorization_code.setter
    def authorization_code(self, authorization_code):
        """Sets the authorization_code of this TransactionChargeAuthorization.

        Valid authorization code to charge  # noqa: E501

        :param authorization_code: The authorization_code of this TransactionChargeAuthorization.  # noqa: E501
        :type authorization_code: str
        """
        if self.local_vars_configuration.client_side_validation and authorization_code is None:  # noqa: E501
            raise ValueError("Invalid value for `authorization_code`, must not be `None`")  # noqa: E501

        self._authorization_code = authorization_code

    @property
    def reference(self):
        """Gets the reference of this TransactionChargeAuthorization.  # noqa: E501

        Unique transaction reference. Only -, ., = and alphanumeric characters allowed.  # noqa: E501

        :return: The reference of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this TransactionChargeAuthorization.

        Unique transaction reference. Only -, ., = and alphanumeric characters allowed.  # noqa: E501

        :param reference: The reference of this TransactionChargeAuthorization.  # noqa: E501
        :type reference: str
        """

        self._reference = reference

    @property
    def currency(self):
        """Gets the currency of this TransactionChargeAuthorization.  # noqa: E501

        The transaction currency  # noqa: E501

        :return: The currency of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this TransactionChargeAuthorization.

        The transaction currency  # noqa: E501

        :param currency: The currency of this TransactionChargeAuthorization.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    @property
    def metadata(self):
        """Gets the metadata of this TransactionChargeAuthorization.  # noqa: E501

        Stringified JSON object of custom data  # noqa: E501

        :return: The metadata of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this TransactionChargeAuthorization.

        Stringified JSON object of custom data  # noqa: E501

        :param metadata: The metadata of this TransactionChargeAuthorization.  # noqa: E501
        :type metadata: str
        """

        self._metadata = metadata

    @property
    def split_code(self):
        """Gets the split_code of this TransactionChargeAuthorization.  # noqa: E501

        The split code of the transaction split  # noqa: E501

        :return: The split_code of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._split_code

    @split_code.setter
    def split_code(self, split_code):
        """Sets the split_code of this TransactionChargeAuthorization.

        The split code of the transaction split  # noqa: E501

        :param split_code: The split_code of this TransactionChargeAuthorization.  # noqa: E501
        :type split_code: str
        """

        self._split_code = split_code

    @property
    def subaccount(self):
        """Gets the subaccount of this TransactionChargeAuthorization.  # noqa: E501

        The code for the subaccount that owns the payment  # noqa: E501

        :return: The subaccount of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._subaccount

    @subaccount.setter
    def subaccount(self, subaccount):
        """Sets the subaccount of this TransactionChargeAuthorization.

        The code for the subaccount that owns the payment  # noqa: E501

        :param subaccount: The subaccount of this TransactionChargeAuthorization.  # noqa: E501
        :type subaccount: str
        """

        self._subaccount = subaccount

    @property
    def transaction_charge(self):
        """Gets the transaction_charge of this TransactionChargeAuthorization.  # noqa: E501

        A flat fee to charge the subaccount for a transaction.  This overrides the split percentage set when the subaccount was created  # noqa: E501

        :return: The transaction_charge of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._transaction_charge

    @transaction_charge.setter
    def transaction_charge(self, transaction_charge):
        """Sets the transaction_charge of this TransactionChargeAuthorization.

        A flat fee to charge the subaccount for a transaction.  This overrides the split percentage set when the subaccount was created  # noqa: E501

        :param transaction_charge: The transaction_charge of this TransactionChargeAuthorization.  # noqa: E501
        :type transaction_charge: str
        """

        self._transaction_charge = transaction_charge

    @property
    def bearer(self):
        """Gets the bearer of this TransactionChargeAuthorization.  # noqa: E501

        The beare of the transaction charge  # noqa: E501

        :return: The bearer of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: str
        """
        return self._bearer

    @bearer.setter
    def bearer(self, bearer):
        """Sets the bearer of this TransactionChargeAuthorization.

        The beare of the transaction charge  # noqa: E501

        :param bearer: The bearer of this TransactionChargeAuthorization.  # noqa: E501
        :type bearer: str
        """

        self._bearer = bearer

    @property
    def queue(self):
        """Gets the queue of this TransactionChargeAuthorization.  # noqa: E501

        If you are making a scheduled charge call, it is a good idea to queue them so the processing system does not get overloaded causing transaction processing errors.  # noqa: E501

        :return: The queue of this TransactionChargeAuthorization.  # noqa: E501
        :rtype: bool
        """
        return self._queue

    @queue.setter
    def queue(self, queue):
        """Sets the queue of this TransactionChargeAuthorization.

        If you are making a scheduled charge call, it is a good idea to queue them so the processing system does not get overloaded causing transaction processing errors.  # noqa: E501

        :param queue: The queue of this TransactionChargeAuthorization.  # noqa: E501
        :type queue: bool
        """

        self._queue = queue

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransactionChargeAuthorization):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TransactionChargeAuthorization):
            return True

        return self.to_dict() != other.to_dict()
