# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class SubaccountUpdate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'business_name': 'str',
        'settlement_bank': 'str',
        'account_number': 'str',
        'active': 'bool',
        'percentage_charge': 'float',
        'description': 'str',
        'primary_contact_email': 'str',
        'primary_contact_name': 'str',
        'primary_contact_phone': 'str',
        'metadata': 'str'
    }

    attribute_map = {
        'business_name': 'business_name',
        'settlement_bank': 'settlement_bank',
        'account_number': 'account_number',
        'active': 'active',
        'percentage_charge': 'percentage_charge',
        'description': 'description',
        'primary_contact_email': 'primary_contact_email',
        'primary_contact_name': 'primary_contact_name',
        'primary_contact_phone': 'primary_contact_phone',
        'metadata': 'metadata'
    }

    def __init__(self, business_name=None, settlement_bank=None, account_number=None, active=None, percentage_charge=None, description=None, primary_contact_email=None, primary_contact_name=None, primary_contact_phone=None, metadata=None, local_vars_configuration=None):  # noqa: E501
        """SubaccountUpdate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._business_name = None
        self._settlement_bank = None
        self._account_number = None
        self._active = None
        self._percentage_charge = None
        self._description = None
        self._primary_contact_email = None
        self._primary_contact_name = None
        self._primary_contact_phone = None
        self._metadata = None
        self.discriminator = None

        if business_name is not None:
            self.business_name = business_name
        if settlement_bank is not None:
            self.settlement_bank = settlement_bank
        if account_number is not None:
            self.account_number = account_number
        if active is not None:
            self.active = active
        if percentage_charge is not None:
            self.percentage_charge = percentage_charge
        if description is not None:
            self.description = description
        if primary_contact_email is not None:
            self.primary_contact_email = primary_contact_email
        if primary_contact_name is not None:
            self.primary_contact_name = primary_contact_name
        if primary_contact_phone is not None:
            self.primary_contact_phone = primary_contact_phone
        if metadata is not None:
            self.metadata = metadata

    @property
    def business_name(self):
        """Gets the business_name of this SubaccountUpdate.  # noqa: E501

        Name of business for subaccount  # noqa: E501

        :return: The business_name of this SubaccountUpdate.  # noqa: E501
        :rtype: str
        """
        return self._business_name

    @business_name.setter
    def business_name(self, business_name):
        """Sets the business_name of this SubaccountUpdate.

        Name of business for subaccount  # noqa: E501

        :param business_name: The business_name of this SubaccountUpdate.  # noqa: E501
        :type business_name: str
        """

        self._business_name = business_name

    @property
    def settlement_bank(self):
        """Gets the settlement_bank of this SubaccountUpdate.  # noqa: E501

        Bank code for the bank. You can get the list of Bank Codes by calling the List Banks endpoint.  # noqa: E501

        :return: The settlement_bank of this SubaccountUpdate.  # noqa: E501
        :rtype: str
        """
        return self._settlement_bank

    @settlement_bank.setter
    def settlement_bank(self, settlement_bank):
        """Sets the settlement_bank of this SubaccountUpdate.

        Bank code for the bank. You can get the list of Bank Codes by calling the List Banks endpoint.  # noqa: E501

        :param settlement_bank: The settlement_bank of this SubaccountUpdate.  # noqa: E501
        :type settlement_bank: str
        """

        self._settlement_bank = settlement_bank

    @property
    def account_number(self):
        """Gets the account_number of this SubaccountUpdate.  # noqa: E501

        Bank account number  # noqa: E501

        :return: The account_number of this SubaccountUpdate.  # noqa: E501
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """Sets the account_number of this SubaccountUpdate.

        Bank account number  # noqa: E501

        :param account_number: The account_number of this SubaccountUpdate.  # noqa: E501
        :type account_number: str
        """

        self._account_number = account_number

    @property
    def active(self):
        """Gets the active of this SubaccountUpdate.  # noqa: E501

        Activate or deactivate a subaccount  # noqa: E501

        :return: The active of this SubaccountUpdate.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this SubaccountUpdate.

        Activate or deactivate a subaccount  # noqa: E501

        :param active: The active of this SubaccountUpdate.  # noqa: E501
        :type active: bool
        """

        self._active = active

    @property
    def percentage_charge(self):
        """Gets the percentage_charge of this SubaccountUpdate.  # noqa: E501

        Customer's phone number  # noqa: E501

        :return: The percentage_charge of this SubaccountUpdate.  # noqa: E501
        :rtype: float
        """
        return self._percentage_charge

    @percentage_charge.setter
    def percentage_charge(self, percentage_charge):
        """Sets the percentage_charge of this SubaccountUpdate.

        Customer's phone number  # noqa: E501

        :param percentage_charge: The percentage_charge of this SubaccountUpdate.  # noqa: E501
        :type percentage_charge: float
        """

        self._percentage_charge = percentage_charge

    @property
    def description(self):
        """Gets the description of this SubaccountUpdate.  # noqa: E501

        A description for this subaccount  # noqa: E501

        :return: The description of this SubaccountUpdate.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SubaccountUpdate.

        A description for this subaccount  # noqa: E501

        :param description: The description of this SubaccountUpdate.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def primary_contact_email(self):
        """Gets the primary_contact_email of this SubaccountUpdate.  # noqa: E501

        A contact email for the subaccount  # noqa: E501

        :return: The primary_contact_email of this SubaccountUpdate.  # noqa: E501
        :rtype: str
        """
        return self._primary_contact_email

    @primary_contact_email.setter
    def primary_contact_email(self, primary_contact_email):
        """Sets the primary_contact_email of this SubaccountUpdate.

        A contact email for the subaccount  # noqa: E501

        :param primary_contact_email: The primary_contact_email of this SubaccountUpdate.  # noqa: E501
        :type primary_contact_email: str
        """

        self._primary_contact_email = primary_contact_email

    @property
    def primary_contact_name(self):
        """Gets the primary_contact_name of this SubaccountUpdate.  # noqa: E501

        The name of the contact person for this subaccount  # noqa: E501

        :return: The primary_contact_name of this SubaccountUpdate.  # noqa: E501
        :rtype: str
        """
        return self._primary_contact_name

    @primary_contact_name.setter
    def primary_contact_name(self, primary_contact_name):
        """Sets the primary_contact_name of this SubaccountUpdate.

        The name of the contact person for this subaccount  # noqa: E501

        :param primary_contact_name: The primary_contact_name of this SubaccountUpdate.  # noqa: E501
        :type primary_contact_name: str
        """

        self._primary_contact_name = primary_contact_name

    @property
    def primary_contact_phone(self):
        """Gets the primary_contact_phone of this SubaccountUpdate.  # noqa: E501

        A phone number to call for this subaccount  # noqa: E501

        :return: The primary_contact_phone of this SubaccountUpdate.  # noqa: E501
        :rtype: str
        """
        return self._primary_contact_phone

    @primary_contact_phone.setter
    def primary_contact_phone(self, primary_contact_phone):
        """Sets the primary_contact_phone of this SubaccountUpdate.

        A phone number to call for this subaccount  # noqa: E501

        :param primary_contact_phone: The primary_contact_phone of this SubaccountUpdate.  # noqa: E501
        :type primary_contact_phone: str
        """

        self._primary_contact_phone = primary_contact_phone

    @property
    def metadata(self):
        """Gets the metadata of this SubaccountUpdate.  # noqa: E501

        Stringified JSON object of custom data  # noqa: E501

        :return: The metadata of this SubaccountUpdate.  # noqa: E501
        :rtype: str
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this SubaccountUpdate.

        Stringified JSON object of custom data  # noqa: E501

        :param metadata: The metadata of this SubaccountUpdate.  # noqa: E501
        :type metadata: str
        """

        self._metadata = metadata

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubaccountUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SubaccountUpdate):
            return True

        return self.to_dict() != other.to_dict()
