# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class RefundCreate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'transaction': 'str',
        'amount': 'int',
        'currency': 'str',
        'customer_note': 'str',
        'merchant_note': 'str'
    }

    attribute_map = {
        'transaction': 'transaction',
        'amount': 'amount',
        'currency': 'currency',
        'customer_note': 'customer_note',
        'merchant_note': 'merchant_note'
    }

    def __init__(self, transaction=None, amount=None, currency=None, customer_note=None, merchant_note=None, local_vars_configuration=None):  # noqa: E501
        """RefundCreate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._transaction = None
        self._amount = None
        self._currency = None
        self._customer_note = None
        self._merchant_note = None
        self.discriminator = None

        self.transaction = transaction
        if amount is not None:
            self.amount = amount
        if currency is not None:
            self.currency = currency
        if customer_note is not None:
            self.customer_note = customer_note
        if merchant_note is not None:
            self.merchant_note = merchant_note

    @property
    def transaction(self):
        """Gets the transaction of this RefundCreate.  # noqa: E501

        Transaction reference or id  # noqa: E501

        :return: The transaction of this RefundCreate.  # noqa: E501
        :rtype: str
        """
        return self._transaction

    @transaction.setter
    def transaction(self, transaction):
        """Sets the transaction of this RefundCreate.

        Transaction reference or id  # noqa: E501

        :param transaction: The transaction of this RefundCreate.  # noqa: E501
        :type transaction: str
        """
        if self.local_vars_configuration.client_side_validation and transaction is None:  # noqa: E501
            raise ValueError("Invalid value for `transaction`, must not be `None`")  # noqa: E501

        self._transaction = transaction

    @property
    def amount(self):
        """Gets the amount of this RefundCreate.  # noqa: E501

        Amount ( in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR ) to be refunded to the customer.  Amount cannot be more than the original transaction amount  # noqa: E501

        :return: The amount of this RefundCreate.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this RefundCreate.

        Amount ( in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR ) to be refunded to the customer.  Amount cannot be more than the original transaction amount  # noqa: E501

        :param amount: The amount of this RefundCreate.  # noqa: E501
        :type amount: int
        """

        self._amount = amount

    @property
    def currency(self):
        """Gets the currency of this RefundCreate.  # noqa: E501

        Three-letter ISO currency. Allowed values are NGN, GHS, ZAR or USD  # noqa: E501

        :return: The currency of this RefundCreate.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this RefundCreate.

        Three-letter ISO currency. Allowed values are NGN, GHS, ZAR or USD  # noqa: E501

        :param currency: The currency of this RefundCreate.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    @property
    def customer_note(self):
        """Gets the customer_note of this RefundCreate.  # noqa: E501

        Customer reason  # noqa: E501

        :return: The customer_note of this RefundCreate.  # noqa: E501
        :rtype: str
        """
        return self._customer_note

    @customer_note.setter
    def customer_note(self, customer_note):
        """Sets the customer_note of this RefundCreate.

        Customer reason  # noqa: E501

        :param customer_note: The customer_note of this RefundCreate.  # noqa: E501
        :type customer_note: str
        """

        self._customer_note = customer_note

    @property
    def merchant_note(self):
        """Gets the merchant_note of this RefundCreate.  # noqa: E501

        Merchant reason  # noqa: E501

        :return: The merchant_note of this RefundCreate.  # noqa: E501
        :rtype: str
        """
        return self._merchant_note

    @merchant_note.setter
    def merchant_note(self, merchant_note):
        """Sets the merchant_note of this RefundCreate.

        Merchant reason  # noqa: E501

        :param merchant_note: The merchant_note of this RefundCreate.  # noqa: E501
        :type merchant_note: str
        """

        self._merchant_note = merchant_note

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RefundCreate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RefundCreate):
            return True

        return self.to_dict() != other.to_dict()
