# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class PageUpdate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'amount': 'int',
        'active': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'amount': 'amount',
        'active': 'active'
    }

    def __init__(self, name=None, description=None, amount=None, active=None, local_vars_configuration=None):  # noqa: E501
        """PageUpdate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._amount = None
        self._active = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if amount is not None:
            self.amount = amount
        if active is not None:
            self.active = active

    @property
    def name(self):
        """Gets the name of this PageUpdate.  # noqa: E501

        Name of page  # noqa: E501

        :return: The name of this PageUpdate.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PageUpdate.

        Name of page  # noqa: E501

        :param name: The name of this PageUpdate.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this PageUpdate.  # noqa: E501

        The description of the page  # noqa: E501

        :return: The description of this PageUpdate.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this PageUpdate.

        The description of the page  # noqa: E501

        :param description: The description of this PageUpdate.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def amount(self):
        """Gets the amount of this PageUpdate.  # noqa: E501

        Amount should be in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :return: The amount of this PageUpdate.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this PageUpdate.

        Amount should be in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :param amount: The amount of this PageUpdate.  # noqa: E501
        :type amount: int
        """

        self._amount = amount

    @property
    def active(self):
        """Gets the active of this PageUpdate.  # noqa: E501

        Set to false to deactivate page url  # noqa: E501

        :return: The active of this PageUpdate.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this PageUpdate.

        Set to false to deactivate page url  # noqa: E501

        :param active: The active of this PageUpdate.  # noqa: E501
        :type active: bool
        """

        self._active = active

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PageUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PageUpdate):
            return True

        return self.to_dict() != other.to_dict()
