# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class MobileMoney(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'phone': 'str',
        'provider': 'str'
    }

    attribute_map = {
        'phone': 'phone',
        'provider': 'provider'
    }

    def __init__(self, phone=None, provider=None, local_vars_configuration=None):  # noqa: E501
        """MobileMoney - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._phone = None
        self._provider = None
        self.discriminator = None

        if phone is not None:
            self.phone = phone
        if provider is not None:
            self.provider = provider

    @property
    def phone(self):
        """Gets the phone of this MobileMoney.  # noqa: E501

        Customer's phone number  # noqa: E501

        :return: The phone of this MobileMoney.  # noqa: E501
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """Sets the phone of this MobileMoney.

        Customer's phone number  # noqa: E501

        :param phone: The phone of this MobileMoney.  # noqa: E501
        :type phone: str
        """

        self._phone = phone

    @property
    def provider(self):
        """Gets the provider of this MobileMoney.  # noqa: E501

        The telco provider of customer's phone number. This can be fetched from the List Bank endpoint  # noqa: E501

        :return: The provider of this MobileMoney.  # noqa: E501
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """Sets the provider of this MobileMoney.

        The telco provider of customer's phone number. This can be fetched from the List Bank endpoint  # noqa: E501

        :param provider: The provider of this MobileMoney.  # noqa: E501
        :type provider: str
        """

        self._provider = provider

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MobileMoney):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MobileMoney):
            return True

        return self.to_dict() != other.to_dict()
