# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class DisputeUpdate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'refund_amount': 'str',
        'uploaded_filename': 'str'
    }

    attribute_map = {
        'refund_amount': 'refund_amount',
        'uploaded_filename': 'uploaded_filename'
    }

    def __init__(self, refund_amount=None, uploaded_filename=None, local_vars_configuration=None):  # noqa: E501
        """DisputeUpdate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._refund_amount = None
        self._uploaded_filename = None
        self.discriminator = None

        self.refund_amount = refund_amount
        if uploaded_filename is not None:
            self.uploaded_filename = uploaded_filename

    @property
    def refund_amount(self):
        """Gets the refund_amount of this DisputeUpdate.  # noqa: E501

        The amount to refund, in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :return: The refund_amount of this DisputeUpdate.  # noqa: E501
        :rtype: str
        """
        return self._refund_amount

    @refund_amount.setter
    def refund_amount(self, refund_amount):
        """Sets the refund_amount of this DisputeUpdate.

        The amount to refund, in kobo if currency is NGN, pesewas, if currency is GHS, and cents, if currency is ZAR  # noqa: E501

        :param refund_amount: The refund_amount of this DisputeUpdate.  # noqa: E501
        :type refund_amount: str
        """
        if self.local_vars_configuration.client_side_validation and refund_amount is None:  # noqa: E501
            raise ValueError("Invalid value for `refund_amount`, must not be `None`")  # noqa: E501

        self._refund_amount = refund_amount

    @property
    def uploaded_filename(self):
        """Gets the uploaded_filename of this DisputeUpdate.  # noqa: E501

        Filename of attachment returned via response from the Dispute upload URL  # noqa: E501

        :return: The uploaded_filename of this DisputeUpdate.  # noqa: E501
        :rtype: str
        """
        return self._uploaded_filename

    @uploaded_filename.setter
    def uploaded_filename(self, uploaded_filename):
        """Sets the uploaded_filename of this DisputeUpdate.

        Filename of attachment returned via response from the Dispute upload URL  # noqa: E501

        :param uploaded_filename: The uploaded_filename of this DisputeUpdate.  # noqa: E501
        :type uploaded_filename: str
        """

        self._uploaded_filename = uploaded_filename

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DisputeUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DisputeUpdate):
            return True

        return self.to_dict() != other.to_dict()
