# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class DedicatedVirtualAccountSplit(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_number': 'str',
        'subaccount': 'str',
        'split_code': 'str'
    }

    attribute_map = {
        'account_number': 'account_number',
        'subaccount': 'subaccount',
        'split_code': 'split_code'
    }

    def __init__(self, account_number=None, subaccount=None, split_code=None, local_vars_configuration=None):  # noqa: E501
        """DedicatedVirtualAccountSplit - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._account_number = None
        self._subaccount = None
        self._split_code = None
        self.discriminator = None

        self.account_number = account_number
        if subaccount is not None:
            self.subaccount = subaccount
        if split_code is not None:
            self.split_code = split_code

    @property
    def account_number(self):
        """Gets the account_number of this DedicatedVirtualAccountSplit.  # noqa: E501

        Valid Dedicated virtual account  # noqa: E501

        :return: The account_number of this DedicatedVirtualAccountSplit.  # noqa: E501
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """Sets the account_number of this DedicatedVirtualAccountSplit.

        Valid Dedicated virtual account  # noqa: E501

        :param account_number: The account_number of this DedicatedVirtualAccountSplit.  # noqa: E501
        :type account_number: str
        """
        if self.local_vars_configuration.client_side_validation and account_number is None:  # noqa: E501
            raise ValueError("Invalid value for `account_number`, must not be `None`")  # noqa: E501

        self._account_number = account_number

    @property
    def subaccount(self):
        """Gets the subaccount of this DedicatedVirtualAccountSplit.  # noqa: E501

        Subaccount code of the account you want to split the transaction with  # noqa: E501

        :return: The subaccount of this DedicatedVirtualAccountSplit.  # noqa: E501
        :rtype: str
        """
        return self._subaccount

    @subaccount.setter
    def subaccount(self, subaccount):
        """Sets the subaccount of this DedicatedVirtualAccountSplit.

        Subaccount code of the account you want to split the transaction with  # noqa: E501

        :param subaccount: The subaccount of this DedicatedVirtualAccountSplit.  # noqa: E501
        :type subaccount: str
        """

        self._subaccount = subaccount

    @property
    def split_code(self):
        """Gets the split_code of this DedicatedVirtualAccountSplit.  # noqa: E501

        Split code consisting of the lists of accounts you want to split the transaction with  # noqa: E501

        :return: The split_code of this DedicatedVirtualAccountSplit.  # noqa: E501
        :rtype: str
        """
        return self._split_code

    @split_code.setter
    def split_code(self, split_code):
        """Sets the split_code of this DedicatedVirtualAccountSplit.

        Split code consisting of the lists of accounts you want to split the transaction with  # noqa: E501

        :param split_code: The split_code of this DedicatedVirtualAccountSplit.  # noqa: E501
        :type split_code: str
        """

        self._split_code = split_code

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DedicatedVirtualAccountSplit):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DedicatedVirtualAccountSplit):
            return True

        return self.to_dict() != other.to_dict()
