# coding: utf-8

"""
    Paystack

    The OpenAPI specification of the Paystack API that merchants and developers can harness to build financial solutions in Africa.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: techsupport@paystack.com
"""


import inspect
import pprint
import re  # noqa: F401
import six

from paystack.configuration import Configuration


class ChargeSubmitPin(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pin': 'str',
        'reference': 'str'
    }

    attribute_map = {
        'pin': 'pin',
        'reference': 'reference'
    }

    def __init__(self, pin=None, reference=None, local_vars_configuration=None):  # noqa: E501
        """ChargeSubmitPin - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._pin = None
        self._reference = None
        self.discriminator = None

        self.pin = pin
        self.reference = reference

    @property
    def pin(self):
        """Gets the pin of this ChargeSubmitPin.  # noqa: E501

        Customer's PIN  # noqa: E501

        :return: The pin of this ChargeSubmitPin.  # noqa: E501
        :rtype: str
        """
        return self._pin

    @pin.setter
    def pin(self, pin):
        """Sets the pin of this ChargeSubmitPin.

        Customer's PIN  # noqa: E501

        :param pin: The pin of this ChargeSubmitPin.  # noqa: E501
        :type pin: str
        """
        if self.local_vars_configuration.client_side_validation and pin is None:  # noqa: E501
            raise ValueError("Invalid value for `pin`, must not be `None`")  # noqa: E501

        self._pin = pin

    @property
    def reference(self):
        """Gets the reference of this ChargeSubmitPin.  # noqa: E501

        Transaction reference that requires the PIN  # noqa: E501

        :return: The reference of this ChargeSubmitPin.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this ChargeSubmitPin.

        Transaction reference that requires the PIN  # noqa: E501

        :param reference: The reference of this ChargeSubmitPin.  # noqa: E501
        :type reference: str
        """
        if self.local_vars_configuration.client_side_validation and reference is None:  # noqa: E501
            raise ValueError("Invalid value for `reference`, must not be `None`")  # noqa: E501

        self._reference = reference

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChargeSubmitPin):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChargeSubmitPin):
            return True

        return self.to_dict() != other.to_dict()
