"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Os = exports.Architecture = exports.RunnerVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines desired GitHub Actions runner version.
 */
class RunnerVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * Use the latest version available at the time the runner provider image is built.
     */
    static latest() {
        return new RunnerVersion('latest');
    }
    /**
     * Use a specific version.
     *
     * @see https://github.com/actions/runner/releases
     *
     * @param version GitHub Runner version
     */
    static specific(version) {
        return new RunnerVersion(version);
    }
}
exports.RunnerVersion = RunnerVersion;
_a = JSII_RTTI_SYMBOL_1;
RunnerVersion[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.RunnerVersion", version: "0.4.0" };
/**
 * CPU architecture enum for an image.
 */
class Architecture {
    constructor(name) {
        this.name = name;
    }
    static of(architecture) {
        return new Architecture(architecture);
    }
    /**
    * Checks if the given architecture is the same as this one.
    *
    * @param arch architecture to compare
    */
    is(arch) {
        return arch.name == this.name;
    }
}
exports.Architecture = Architecture;
_b = JSII_RTTI_SYMBOL_1;
Architecture[_b] = { fqn: "@cloudsnorkel/cdk-github-runners.Architecture", version: "0.4.0" };
/**
 * ARM64
 */
Architecture.ARM64 = Architecture.of('ARM64');
/**
 * X86_64
 */
Architecture.X86_64 = Architecture.of('X86_64');
/**
 * OS enum for an image.
 */
class Os {
    constructor(name) {
        this.name = name;
    }
    static of(os) {
        return new Os(os);
    }
    /**
    * Checks if the given OS is the same as this one.
    *
    * @param os OS to compare
    */
    is(os) {
        return os.name == this.name;
    }
}
exports.Os = Os;
_c = JSII_RTTI_SYMBOL_1;
Os[_c] = { fqn: "@cloudsnorkel/cdk-github-runners.Os", version: "0.4.0" };
/**
* Linux
*/
Os.LINUX = Os.of('Linux');
/**
* Windows
*/
Os.WINDOWS = Os.of('Windows');
//# sourceMappingURL=data:application/json;base64,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