"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEnabled = exports.disable = exports.warn = exports.error = exports.info = exports.verbose = exports.debug = exports.ICON = void 0;
const chalk = require("chalk");
const common_1 = require("./common");
exports.ICON = "👾"; //'✨';
// disable logs if running inside a test
let enabled = common_1.IS_TEST_RUN ? false : true;
function log(isError, color, ...text) {
    // errors are always emitted, even if logs are disabled
    if (!enabled && !isError) {
        return;
    }
    console.error(`${exports.ICON} ${color(...text)}`);
}
function debug(...text) {
    if (process.env.DEBUG) {
        log(false, chalk.gray, ...text);
    }
}
exports.debug = debug;
function verbose(...text) {
    log(false, chalk.white, ...text);
}
exports.verbose = verbose;
function info(...text) {
    log(false, chalk.cyan, ...text);
}
exports.info = info;
function error(...text) {
    log(true, chalk.red, ...text);
}
exports.error = error;
function warn(...text) {
    log(false, chalk.yellow, ...text);
}
exports.warn = warn;
function disable() {
    enabled = false;
}
exports.disable = disable;
function isEnabled() {
    return enabled;
}
exports.isEnabled = isEnabled;
//# sourceMappingURL=data:application/json;base64,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