"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var zen_observable_ts_1 = tslib_1.__importDefault(require("zen-observable-ts"));
var Logger_1 = require("../Logger");
var logger = new Logger_1.ConsoleLogger('Reachability', 'DEBUG');
var ReachabilityNavigator = /** @class */ (function () {
    function ReachabilityNavigator() {
    }
    ReachabilityNavigator.prototype.networkMonitor = function (netInfo) {
        /**
         * Here netinfo refers to @react-native-community/netinfo
         * This is needed in React Native to enable network detection
         * We do not import it in Core so that Apps that do not use DataStore
         * Do not need to install and link this dependency
         * When using Reachability in React Native, pass NetInfo as a param to networkMonitor
         */
        if (!(netInfo && netInfo.addEventListener)) {
            throw new Error('NetInfo must be passed to networkMonitor to enable reachability in React Native');
        }
        return new zen_observable_ts_1.default(function (observer) {
            logger.log('subscribing to reachability in React Native');
            var unsubscribe = netInfo.addEventListener(function (_a) {
                var isInternetReachable = _a.isInternetReachable;
                // `isInternetReachable` can sometimes be `null` initially, so we want
                // to make sure it is a boolean first before sending it to the observer.
                if (typeof isInternetReachable === 'boolean') {
                    var online = isInternetReachable;
                    logger.log('Notifying reachability change', online);
                    observer.next({ online: online });
                }
            });
            return function () {
                unsubscribe();
            };
        });
    };
    return ReachabilityNavigator;
}());
exports.default = ReachabilityNavigator;
//# sourceMappingURL=Reachability.native.js.map