"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
var async_storage_1 = tslib_1.__importDefault(require("@react-native-async-storage/async-storage"));
var MEMORY_KEY_PREFIX = '@MemoryStorage:';
var dataMemory = {};
/** @class */
var MemoryStorage = /** @class */ (function () {
    function MemoryStorage() {
    }
    /**
     * This is used to set a specific item in storage
     * @param {string} key - the key for the item
     * @param {object} value - the value
     * @returns {string} value that was set
     */
    MemoryStorage.setItem = function (key, value) {
        if (value) {
            async_storage_1.default.setItem(MEMORY_KEY_PREFIX + key, value);
            dataMemory[key] = value;
            return dataMemory[key];
        }
    };
    /**
     * This is used to get a specific key from storage
     * @param {string} key - the key for the item
     * This is used to clear the storage
     * @returns {string} the data item
     */
    MemoryStorage.getItem = function (key) {
        return Object.prototype.hasOwnProperty.call(dataMemory, key)
            ? dataMemory[key]
            : undefined;
    };
    /**
     * This is used to remove an item from storage
     * @param {string} key - the key being set
     * @returns {string} value - value that was deleted
     */
    MemoryStorage.removeItem = function (key) {
        async_storage_1.default.removeItem(MEMORY_KEY_PREFIX + key);
        return delete dataMemory[key];
    };
    /**
     * This is used to clear the storage
     * @returns {string} nothing
     */
    MemoryStorage.clear = function () {
        dataMemory = {};
        return dataMemory;
    };
    /**
     * Will sync the MemoryStorage data from AsyncStorage to storageWindow MemoryStorage
     * @returns {void}
     */
    MemoryStorage.sync = function () {
        if (!MemoryStorage.syncPromise) {
            MemoryStorage.syncPromise = new Promise(function (res, rej) {
                async_storage_1.default.getAllKeys(function (errKeys, keys) {
                    if (errKeys)
                        rej(errKeys);
                    var memoryKeys = keys.filter(function (key) {
                        return key.startsWith(MEMORY_KEY_PREFIX);
                    });
                    async_storage_1.default.multiGet(memoryKeys, function (err, stores) {
                        if (err)
                            rej(err);
                        stores.map(function (result, index, store) {
                            var key = store[index][0];
                            var value = store[index][1];
                            var memoryKey = key.replace(MEMORY_KEY_PREFIX, '');
                            dataMemory[memoryKey] = value;
                        });
                        res();
                    });
                });
            });
        }
        return MemoryStorage.syncPromise;
    };
    MemoryStorage.syncPromise = null;
    return MemoryStorage;
}());
var StorageHelper = /** @class */ (function () {
    /**
     * This is used to get a storage object
     * @returns {object} the storage
     */
    function StorageHelper() {
        this.storageWindow = MemoryStorage;
    }
    /**
     * This is used to return the storage
     * @returns {object} the storage
     */
    StorageHelper.prototype.getStorage = function () {
        return this.storageWindow;
    };
    return StorageHelper;
}());
exports.StorageHelper = StorageHelper;
//# sourceMappingURL=reactnative.js.map