"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
var obj = {};
exports.setState = function (state) {
    obj.oauth_state = state;
};
exports.getState = function () {
    var oauth_state = obj.oauth_state;
    obj.oauth_state = undefined;
    return oauth_state;
};
exports.setPKCE = function (private_key) {
    obj.ouath_pkce_key = private_key;
};
exports.getPKCE = function () {
    var ouath_pkce_key = obj.ouath_pkce_key;
    obj.ouath_pkce_key = undefined;
    return ouath_pkce_key;
};
exports.clearAll = function () {
    obj.ouath_pkce_key = undefined;
    obj.oauth_state = undefined;
};
//# sourceMappingURL=oauthStorage.native.js.map