"""
Auto-generated on 2017-08-16T19:33:17.120453
"""

from .value_set import ValueSet


class OncAdministrativeSex(ValueSet):
    """

    Clinical Focus: Gender identity restricted to only Male and Female used in administrative situations requiring a restriction to these two categories.
    Data Element Scope: Gender
    Inclusion Criteria: Male and Female only.
    Exclusion Criteria: Any gender identity that is not male or female.
    """

    OID = '2.16.840.1.113762.1.4.1'
    VALUE_SET_NAME = 'ONC Administrative Sex'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ADMINISTRATIVEGENDER = {'F', 'M'}


class Pci(ValueSet):
    """

    Clinical Focus: This grouping value set contains procedures used to define percutaneous coronary intervention (PCI).
    Data Element Scope: The intent of this data element is to identify patients who had percutaneous coronary intervention (PCI) during an episode of acute myocardial infarction. Using the Quality Data Model, this particular element would map to the Procedure, Performed datatype.
    Inclusion Criteria: Include codes that identify patients receiving percutaneous coronary intervention (PCI). This is a grouping of ICD10PCS and SNOMEDCT codes.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1045.67'
    VALUE_SET_NAME = 'PCI'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10PCS = {
        '0270346', '027034Z', '0270356', '027035Z', '0270366', '027036Z', '0270376', '027037Z',
        '02703D6', '02703DZ', '02703E6', '02703EZ', '02703F6', '02703FZ', '02703G6', '02703GZ',
        '02703T6', '02703TZ', '02703Z6', '02703ZZ', '0270446', '027044Z', '0270456', '027045Z',
        '0270466', '027046Z', '0270476', '027047Z', '02704D6', '02704DZ', '02704E6', '02704EZ',
        '02704F6', '02704FZ', '02704G6', '02704GZ', '02704T6', '02704TZ', '02704Z6', '02704ZZ',
        '0271346', '027134Z', '0271356', '027135Z', '0271366', '027136Z', '0271376', '027137Z',
        '02713D6', '02713DZ', '02713E6', '02713EZ', '02713F6', '02713FZ', '02713G6', '02713GZ',
        '02713T6', '02713TZ', '02713Z6', '02713ZZ', '0271446', '027144Z', '0271456', '027145Z',
        '0271466', '027146Z', '0271476', '027147Z', '02714D6', '02714DZ', '02714E6', '02714EZ',
        '02714F6', '02714FZ', '02714G6', '02714GZ', '02714T6', '02714TZ', '02714Z6', '02714ZZ',
        '0272346', '027234Z', '0272356', '027235Z', '0272366', '027236Z', '0272376', '027237Z',
        '02723D6', '02723DZ', '02723E6', '02723EZ', '02723F6', '02723FZ', '02723G6', '02723GZ',
        '02723T6', '02723TZ', '02723Z6', '02723ZZ', '0272446', '027244Z', '0272456', '027245Z',
        '0272466', '027246Z', '0272476', '027247Z', '02724D6', '02724DZ', '02724E6', '02724EZ',
        '02724F6', '02724FZ', '02724G6', '02724GZ', '02724T6', '02724TZ', '02724Z6', '02724ZZ',
        '0273346', '027334Z', '0273356', '027335Z', '0273366', '027336Z', '0273376', '027337Z',
        '02733D6', '02733DZ', '02733E6', '02733EZ', '02733F6', '02733FZ', '02733G6', '02733GZ',
        '02733T6', '02733TZ', '02733Z6', '02733ZZ', '0273446', '027344Z', '0273456', '027345Z',
        '0273466', '027346Z', '0273476', '027347Z', '02734D6', '02734DZ', '02734E6', '02734EZ',
        '02734F6', '02734FZ', '02734G6', '02734GZ', '02734T6', '02734TZ', '02734Z6', '02734ZZ'
    }

    SNOMEDCT = {
        '11101003', '175066001', '36969009', '397193006', '397431004', '414089002', '415070008',
        '428488008', '429499003', '429639007', '429809004', '609153008', '609154002', '68466008',
        '698740005', '707828002', '85053006'
    }


class Hypercholesterolemia(ValueSet):
    """

    Clinical Focus: This value set is designed to capture that the patient has a diagnosis, past or present, of hypercholesterolemia.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: Included are diagnoses of hypercholesterolemia.
    Exclusion Criteria: Other diagnoses not related or used to identify patients with hypercholesterolemia are excluded.
    """

    OID = '2.16.840.1.113762.1.4.1047.100'
    VALUE_SET_NAME = 'Hypercholesterolemia'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'E7800', 'E7801'}

    ICD9CM = {'2720'}

    SNOMEDCT = {
        '13644009', '238076009', '238077000', '238078005', '238079002', '238082007', '267432004',
        '398036000', '398796005', '403829002', '403830007', '403831006', '414416008'
    }


class Rhabdomyolysis(ValueSet):
    """

    Clinical Focus: The set of values is intended to capture the diagnosis or condition of Rhabdomyolysis.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: Only the diagnosis of Rhabdomyolysis is included.
    Exclusion Criteria: Excludes any other diagnoses not related to Rhabdomyolysis.
    """

    OID = '2.16.840.1.113762.1.4.1047.102'
    VALUE_SET_NAME = 'Rhabdomyolysis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'M6282', 'T796XXA', 'T796XXD', 'T796XXS'}

    SNOMEDCT = {'23697004', '240125008', '240131006', '240132004', '72960004'}


class LowIntensityStatinTherapy(ValueSet):
    """

    Clinical Focus: The intent of this value set is to incorporate low intensity statin medications as defined by the 2013 ACC/AHA guideline.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by medication codes.
    Inclusion Criteria: Low intensity statin therapy is included in this set of values.
    Exclusion Criteria: Any other intensity of statin therapy is excluded.
    """

    OID = '2.16.840.1.113762.1.4.1047.107'
    VALUE_SET_NAME = 'Low intensity statin therapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '197903', '197904', '310404', '310405', '312962', '314231', '433848', '433849', '476345',
        '757702', '861643', '904458', '904467'
    }


class AtherosclerosisAndPeripheralArterialDisease(ValueSet):
    """

    Clinical Focus: This set of values is intended to capture that a patient has a diagnosis, condition, or disorder of Atherosclerosis or Peripheral Arterial Disease (PAD).
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: Conditions that indicate arterial blood flow is restricted putting patients at higher risk for heart disease are included.
    Exclusion Criteria: Other vascular conditions that are not diagnosed as part of Atherosclerosis and Peripheral Artery Disease are excluded.
    """

    OID = '2.16.840.1.113762.1.4.1047.21'
    VALUE_SET_NAME = 'Atherosclerosis and Peripheral Arterial Disease'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'E0851', 'E0852', 'E0951', 'E0952', 'I2510', 'I25110', 'I25111', 'I25118', 'I25119',
        'I25700', 'I25701', 'I25708', 'I25709', 'I25710', 'I25711', 'I25718', 'I25719', 'I25720',
        'I25721', 'I25728', 'I25729', 'I25730', 'I25731', 'I25738', 'I25739', 'I25750', 'I25751',
        'I25758', 'I25759', 'I25760', 'I25761', 'I25768', 'I25769', 'I25790', 'I25791', 'I25798',
        'I25799', 'I25810', 'I25811', 'I25812', 'I2583', 'I2584', 'I2589', 'I672', 'I700', 'I701',
        'I70201', 'I70202', 'I70203', 'I70208', 'I70209', 'I70211', 'I70212', 'I70213', 'I70218',
        'I70219', 'I70221', 'I70222', 'I70223', 'I70228', 'I70229', 'I70231', 'I70232', 'I70233',
        'I70234', 'I70235', 'I70238', 'I70239', 'I70241', 'I70242', 'I70243', 'I70244', 'I70245',
        'I70248', 'I70249', 'I7025', 'I70261', 'I70262', 'I70263', 'I70268', 'I70269', 'I70291',
        'I70292', 'I70293', 'I70298', 'I70299', 'I70301', 'I70302', 'I70303', 'I70308', 'I70309',
        'I70311', 'I70312', 'I70313', 'I70318', 'I70319', 'I70321', 'I70322', 'I70323', 'I70328',
        'I70329', 'I70331', 'I70332', 'I70333', 'I70334', 'I70335', 'I70338', 'I70339', 'I70341',
        'I70342', 'I70343', 'I70344', 'I70345', 'I70348', 'I70349', 'I7035', 'I70361', 'I70362',
        'I70363', 'I70368', 'I70369', 'I70391', 'I70392', 'I70393', 'I70398', 'I70399', 'I70401',
        'I70402', 'I70403', 'I70408', 'I70409', 'I70411', 'I70412', 'I70413', 'I70418', 'I70419',
        'I70421', 'I70422', 'I70423', 'I70428', 'I70429', 'I70431', 'I70432', 'I70433', 'I70434',
        'I70435', 'I70438', 'I70439', 'I70441', 'I70442', 'I70443', 'I70444', 'I70445', 'I70448',
        'I70449', 'I7045', 'I70461', 'I70462', 'I70463', 'I70468', 'I70469', 'I70491', 'I70492',
        'I70493', 'I70498', 'I70499', 'I70501', 'I70502', 'I70503', 'I70508', 'I70509', 'I70511',
        'I70512', 'I70513', 'I70518', 'I70519', 'I70521', 'I70522', 'I70523', 'I70528', 'I70529',
        'I70531', 'I70532', 'I70533', 'I70534', 'I70535', 'I70538', 'I70539', 'I70541', 'I70542',
        'I70543', 'I70544', 'I70545', 'I70548', 'I70549', 'I7055', 'I70561', 'I70562', 'I70563',
        'I70568', 'I70569', 'I70591', 'I70592', 'I70593', 'I70598', 'I70599', 'I70601', 'I70602',
        'I70603', 'I70608', 'I70609', 'I70611', 'I70612', 'I70613', 'I70618', 'I70619', 'I70621',
        'I70622', 'I70623', 'I70628', 'I70629', 'I70631', 'I70632', 'I70633', 'I70634', 'I70635',
        'I70638', 'I70639', 'I70641', 'I70642', 'I70643', 'I70644', 'I70645', 'I70648', 'I70649',
        'I7065', 'I70661', 'I70662', 'I70663', 'I70668', 'I70669', 'I70691', 'I70692', 'I70693',
        'I70698', 'I70699', 'I70701', 'I70702', 'I70703', 'I70708', 'I70709', 'I70711', 'I70712',
        'I70713', 'I70718', 'I70719', 'I70721', 'I70722', 'I70723', 'I70728', 'I70729', 'I70731',
        'I70732', 'I70733', 'I70734', 'I70735', 'I70738', 'I70739', 'I70741', 'I70742', 'I70743',
        'I70744', 'I70745', 'I70748', 'I70749', 'I7075', 'I70761', 'I70762', 'I70763', 'I70768',
        'I70769', 'I70791', 'I70792', 'I70793', 'I70798', 'I70799', 'I708', 'I7090', 'I7091',
        'I7092'
    }

    ICD9CM = {
        '41400', '41401', '41402', '41403', '41404', '41405', '41406', '41407', '4143', '4144',
        '4370', '4400', '4401', '44020', '44021', '44022', '44023', '44024', '44029', '44030',
        '44031', '44032', '4404', '4408', '4409'
    }

    SNOMEDCT = {
        '127014009', '13954005', '145891000119104', '149841000119109', '233955003', '233956002',
        '238793001', '238794007', '284871000119105', '284881000119108', '300920004', '39823006',
        '399957001', '413838009', '421365002', '421895002', '422166005', '429768000', '441574008',
        '442439008', '442693003', '442701004', '442735001', '443502000', '45281005',
        '5111000119102', '51274000', '55382008', '5561000119107', '63491006', '709584004',
        '709585003', '8001000119106', '81817003'
    }


class LiverDisease(ValueSet):
    """

    Clinical Focus: The focus of this value set is to capture a diagnosis of liver disease. The original intent of this value set is to capture liver disease that would indicate that a statin medication may not be appropriate.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: This value set includes chronic and acute liver conditions that may represent the liver is failing. Examples of conditions include, but are not limited to the following: alcoholic liver damage, cirrhosis, hepatitis C and E, and liver necrosis.
    Exclusion Criteria: This value set does not contain Hepatitis A and Hepatitis B.
    """

    OID = '2.16.840.1.113762.1.4.1047.42'
    VALUE_SET_NAME = 'Liver Disease'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'B170', 'B1710', 'B1711', 'B172', 'B178', 'B179', 'B182', 'B188', 'B189', 'B190', 'B1920',
        'B1921', 'B199', 'K700', 'K7010', 'K7011', 'K702', 'K7030', 'K7031', 'K7040', 'K7041',
        'K709', 'K710', 'K7110', 'K7111', 'K712', 'K713', 'K714', 'K7150', 'K7151', 'K716', 'K717',
        'K718', 'K719', 'K7200', 'K7201', 'K7210', 'K7211', 'K7290', 'K7291', 'K730', 'K731',
        'K732', 'K738', 'K739', 'K740', 'K741', 'K742', 'K743', 'K744', 'K745', 'K7460', 'K7469',
        'K754', 'O98411', 'O98412', 'O98413', 'O98419'
    }

    ICD9CM = {
        '07041', '07042', '07043', '07044', '07049', '07051', '07052', '07053', '07054', '07059',
        '0706', '07070', '07071', '570', '5710', '5712', '5713', '57140', '57141', '57142',
        '57149', '5715', '5716', '5718', '5719', '5724', '5728'
    }

    SNOMEDCT = {
        '10295004', '10759111000119102', '10759151000119101', '109819003', '111896003',
        '123717006', '128302006', '16069000', '186628001', '186634008', '197268000', '197270009',
        '197271008', '197279005', '197284004', '197286002', '197352008', '197359004', '197360009',
        '197361008', '199203001', '19943007', '206372007', '235865005', '235866006', '235867002',
        '235868007', '235869004', '235870003', '235875008', '235876009', '235889003', '266468003',
        '276668008', '278929008', '307757001', '31005002', '328383001', '347891000119103',
        '370889009', '3738000', '37871000', '397575003', '406584008', '406585009', '408335007',
        '41309000', '41889008', '420054005', '425413006', '435091000124105', '435101000124104',
        '450880008', '4846001', '4896000', '50325005', '50711007', '51292008', '57412004',
        '58282009', '59927004', '60037002', '62216007', '66870002', '702969000', '703866000',
        '707341005', '708198006', '72445008', '76783007', '79720007', '831000119103', '89789003',
        '95556007', '9953008'
    }


class CerebrovascularDiseaseStrokeTia(ValueSet):
    """

    Clinical Focus: This value set includes stroke and high risk diagnoses associated with stroke, including TIA and generalized ischemic cerebrovascular disease, which would indicate a patient has Atherosclerotic Cardiovascular Disease (ASCVD) in relation to a cerebrovascular event.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: Includes ASCVD diagnoses of cerebrovascular origin.
    Exclusion Criteria: Excludes any other ASCVD diagnoses not related to cerebrovascular disease, stroke, or TIA.
    """

    OID = '2.16.840.1.113762.1.4.1047.44'
    VALUE_SET_NAME = 'Cerebrovascular disease, Stroke, TIA'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'G450', 'G451', 'G452', 'G458', 'G459', 'G460', 'G461', 'G462', 'G463', 'G464', 'G465',
        'G466', 'G467', 'G468', 'I6300', 'I63011', 'I63012', 'I63013', 'I63019', 'I6302', 'I63031',
        'I63032', 'I63033', 'I63039', 'I6309', 'I6310', 'I63111', 'I63112', 'I63113', 'I63119',
        'I6312', 'I63131', 'I63132', 'I63133', 'I63139', 'I6319', 'I6320', 'I63211', 'I63212',
        'I63213', 'I63219', 'I6322', 'I63231', 'I63232', 'I63233', 'I63239', 'I6329', 'I6330',
        'I63311', 'I63312', 'I63313', 'I63319', 'I63321', 'I63322', 'I63323', 'I63329', 'I63331',
        'I63332', 'I63333', 'I63339', 'I63341', 'I63342', 'I63343', 'I63349', 'I6339', 'I6340',
        'I63411', 'I63412', 'I63413', 'I63419', 'I63421', 'I63422', 'I63423', 'I63429', 'I63431',
        'I63432', 'I63433', 'I63439', 'I63441', 'I63442', 'I63443', 'I63449', 'I6349', 'I6350',
        'I63511', 'I63512', 'I63513', 'I63519', 'I63521', 'I63522', 'I63523', 'I63529', 'I63531',
        'I63532', 'I63533', 'I63539', 'I63541', 'I63542', 'I63543', 'I63549', 'I6359', 'I636',
        'I638', 'I639', 'I6900', 'I69010', 'I69011', 'I69012', 'I69013', 'I69014', 'I69015',
        'I69018', 'I69019', 'I69020', 'I69021', 'I69022', 'I69023', 'I69028', 'I69031', 'I69032',
        'I69033', 'I69034', 'I69039', 'I69041', 'I69042', 'I69043', 'I69044', 'I69049', 'I69051',
        'I69052', 'I69053', 'I69054', 'I69059', 'I69061', 'I69062', 'I69063', 'I69064', 'I69065',
        'I69069', 'I69090', 'I69091', 'I69092', 'I69093', 'I69098', 'I6910', 'I69110', 'I69111',
        'I69112', 'I69113', 'I69114', 'I69115', 'I69118', 'I69119', 'I69120', 'I69121', 'I69122',
        'I69123', 'I69128', 'I69131', 'I69132', 'I69133', 'I69134', 'I69139', 'I69141', 'I69142',
        'I69143', 'I69144', 'I69149', 'I69151', 'I69152', 'I69153', 'I69154', 'I69159', 'I69161',
        'I69162', 'I69163', 'I69164', 'I69165', 'I69169', 'I69190', 'I69191', 'I69192', 'I69193',
        'I69198', 'I6920', 'I69210', 'I69211', 'I69212', 'I69213', 'I69214', 'I69215', 'I69218',
        'I69219', 'I69220', 'I69221', 'I69222', 'I69223', 'I69228', 'I69231', 'I69232', 'I69233',
        'I69234', 'I69239', 'I69241', 'I69242', 'I69243', 'I69244', 'I69249', 'I69251', 'I69252',
        'I69253', 'I69254', 'I69259', 'I69261', 'I69262', 'I69263', 'I69264', 'I69265', 'I69269',
        'I69290', 'I69291', 'I69292', 'I69293', 'I69298', 'I6930', 'I69310', 'I69311', 'I69312',
        'I69313', 'I69314', 'I69315', 'I69318', 'I69319', 'I69320', 'I69321', 'I69322', 'I69323',
        'I69328', 'I69331', 'I69332', 'I69333', 'I69334', 'I69339', 'I69341', 'I69342', 'I69343',
        'I69344', 'I69349', 'I69351', 'I69352', 'I69353', 'I69354', 'I69359', 'I69361', 'I69362',
        'I69363', 'I69364', 'I69365', 'I69369', 'I69390', 'I69391', 'I69392', 'I69393', 'I69398',
        'I6980', 'I69810', 'I69811', 'I69812', 'I69813', 'I69814', 'I69815', 'I69818', 'I69819',
        'I69820', 'I69821', 'I69822', 'I69831', 'I69832', 'I69833', 'I69834', 'I69839', 'I69841',
        'I69842', 'I69843', 'I69844', 'I69849', 'I69863', 'I69864', 'I69865', 'I69869', 'I69890',
        'I69892', 'I69893', 'I69898', 'I6990', 'I69910', 'I69911', 'I69912', 'I69913', 'I69914',
        'I69915', 'I69918', 'I69919', 'I69920', 'I69921', 'I69922', 'I69923', 'I69928', 'I69931',
        'I69932', 'I69933', 'I69934', 'I69939', 'I69941', 'I69942', 'I69943', 'I69944', 'I69949',
        'I69990', 'I69991', 'I69992', 'I69993', 'I69998', 'Z8673'
    }

    ICD9CM = {
        '43300', '43301', '43310', '43311', '43320', '43321', '43330', '43331', '43380', '43381',
        '43390', '43391', '43400', '43401', '43410', '43411', '43490', '43491', '4350', '4351',
        '4353', '4358', '4359', '436', '4371', '4380', '43810', '43811', '43812', '43813', '43814',
        '43819', '43820', '43821', '43822', '43830', '43831', '43832', '43840', '43841', '43842',
        '43850', '43851', '43852', '43853', '4386', '4387', '43881', '43882', '43883', '43884',
        '43885', '43889', '4389', 'V1254'
    }

    SNOMEDCT = {
        '102831000119104', '103761000119107', '108691000119102', '111297002', '111298007',
        '116288000', '133981000119106', '133991000119109', '134771000119108', '137991000119103',
        '140281000119108', '140911000119109', '140921000119102', '145741000119101',
        '148871000119109', '149821000119103', '161511000', '18761000119108', '192813004',
        '195185009', '195186005', '195189003', '195190007', '195212005', '195213000', '195230003',
        '195239002', '195243003', '20059004', '230690007', '230693009', '230694003', '230695002',
        '230696001', '230698000', '230706003', '230707007', '230708002', '230713003', '230714009',
        '230715005', '230738008', '23671000119107', '25133001', '26021000119107', '266257000',
        '275434003', '275526006', '276219001', '281240008', '288723005', '29941000119105',
        '302909007', '307766002', '307767006', '33301000119105', '33331000119103',
        '34191000119104', '361000119103', '371040005', '371041009', '373606000', '390936003',
        '40161000119102', '413102000', '413758000', '422504002', '425642008', '425882004',
        '426033005', '426788002', '426983002', '427065003', '427296003', '427432001', '428668000',
        '430947007', '430959006', '432504007', '433183000', '433891000124100', '433911000124103',
        '433931000124109', '433941000124104', '433951000124102', '433961000124100',
        '433971000124107', '434141000124103', '434151000124101', '434961000124102',
        '434991000124105', '441526008', '441529001', '441630004', '441735003', '441759008',
        '441887006', '441894009', '441960006', '441991000', '442024001', '442097001', '442181008',
        '442212003', '442617003', '442668000', '442676003', '442733008', '443929000',
        '46421000119102', '48601000119107', '5571000124103', '57981008', '62914000', '703163006',
        '705128004', '705130002', '87551000119101', '91601000119109', '92341000119107', '95457000',
        '9901000119100', '99451000119105'
    }


class IschemicHeartDiseaseOrCoronaryOcclusionRuptureOrThrombosis(ValueSet):
    """

    Clinical Focus: The intent of this set of values is to capture ischemic heart disease and  associated diagnoses as related to Atherosclerotic Cardiovascular Disease (ASCVD).
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: Included are acute and chronic forms of ischemic heart disease as well as coronary occlusion, thrombosis, or rupture that can be related to ASCVD.
    Exclusion Criteria: Excluded are acute coronary occlusion related directly to myocardial infarction and myocardial ischemia.
    """

    OID = '2.16.840.1.113762.1.4.1047.46'
    VALUE_SET_NAME = 'Ischemic heart disease or coronary occlusion, rupture, or thrombosis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'I230', 'I231', 'I232', 'I233', 'I234', 'I235', 'I236', 'I238', 'I240', 'I248', 'I249',
        'I255', 'I256', 'I2582', 'I2589', 'I259'
    }

    ICD9CM = {'4110', '4111', '41181', '41189', '4142', '4148', '4149'}

    SNOMEDCT = {
        '10365005', '123641001', '123642008', '194821006', '194862000', '194863005', '194865003',
        '194867006', '194868001', '210078001', '233823002', '233846000', '233847009', '233860003',
        '233889001', '28248000', '28931004', '315026000', '398274000', '408546009', '413439005',
        '413838009', '413844008', '414545008', '414795007', '421327009', '428196007', '457592003',
        '46109009', '461417000', '473393007', '52674009', '56276002', '63739005', '697976003',
        '703328007', '703330009', '712866001', '713405002', '78741000119103'
    }


class StableAndUnstableAngina(ValueSet):
    """

    Clinical Focus: The intent of this set of values is to capture the diagnosis of angina.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: Included are stable and unstable angina, pre and post infarction angina, angina decubitus, intermediate coronary syndrome, other unspecified angina or sequelae of myocardial infarction, and other forms of angina pectoris.
    Exclusion Criteria: Excluded is any form of angina that does not define Atherosclerotic Cardiovascular Disease (ASCVD).
    """

    OID = '2.16.840.1.113762.1.4.1047.47'
    VALUE_SET_NAME = 'Stable and Unstable Angina'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'I200', 'I201', 'I208', 'I209', 'I237'}

    ICD9CM = {'4110', '4111', '4130', '4139', '42979'}

    SNOMEDCT = {'194828000', '233819005', '233821000', '314116003', '4557003', '59021001'}


class Breastfeeding(ValueSet):
    """

    Clinical Focus: The intent of this value set is to capture that a patient is planning to or actively breastfeeding.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by diagnosis codes.
    Inclusion Criteria: Included are codes to indicate lactation and the actual finding or intention of breastfeeding or nursing.
    Exclusion Criteria: Excluded are codes that would not indicate the possibility of breastfeeding.
    """

    OID = '2.16.840.1.113762.1.4.1047.73'
    VALUE_SET_NAME = 'Breastfeeding'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'O9103', 'O9113', 'O9123', 'O9203', 'O9213', 'O925', 'O9270', 'O9279', 'Z391'}

    SNOMEDCT = {
        '169643005', '169745008', '169750002', '199004', '200416006', '200418007', '200419004',
        '200420005', '200430001', '225604004', '247415009', '289084000', '290122005', '290124006',
        '290126008', '58219009', '69840006', '82374005'
    }


class OutpatientEncountersForPreventiveCare(ValueSet):
    """

    Clinical Focus: The intent of this value set is to capture outpatient encounters.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by encounter codes.
    Inclusion Criteria: Included are evaluation and management of a new or established patient through an encounter for annual visit, preventative evaluation, follow-up, or periodic re-evaluations that would occur in the outpatient setting.
    Exclusion Criteria: Any encounters that do not meet the inclusion criteria are excluded.
    """

    OID = '2.16.840.1.113762.1.4.1047.9'
    VALUE_SET_NAME = 'Outpatient Encounters for Preventive Care'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '108219001', '108220007', '108221006', '108224003', '14736009', '185349003', '185389009',
        '270427003', '270430005', '281036007', '30346009', '308335008', '37894004', '390906007',
        '410187005', '78318003', '86013001', '90526000'
    }


class HighIntensityStatinTherapy(ValueSet):
    """

    Clinical Focus: The intent of this value set is to incorporate high intensity statin medications as defined by the 2013 ACC/AHA guideline.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by medication codes.
    Inclusion Criteria: High intensity statin therapy is included in this set of values.
    Exclusion Criteria: Any other intensity of statin therapy is excluded.
    """

    OID = '2.16.840.1.113762.1.4.1047.97'
    VALUE_SET_NAME = 'High intensity statin therapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1422096', '1422099', '259255', '404011', '404013', '476351', '597984', '597990', '597993',
        '617311', '757705', '859419', '859751'
    }


class ModerateIntensityStatinTherapy(ValueSet):
    """

    Clinical Focus: The intent of this value set is to incorporate moderate intensity statin medications as defined by the 2013 ACC/AHA guideline.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by medication codes.
    Inclusion Criteria: Moderate intensity statin therapy is included in this set of values.
    Exclusion Criteria: Any other intensity of statin therapy is excluded.
    """

    OID = '2.16.840.1.113762.1.4.1047.98'
    VALUE_SET_NAME = 'Moderate intensity statin therapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1422086', '1422093', '197905', '198211', '200345', '310405', '312961', '359731', '359732',
        '360507', '476349', '476350', '597967', '597971', '597974', '597977', '597980', '597987',
        '617310', '617312', '757703', '757704', '859424', '859747', '861648', '861652', '904475',
        '904481'
    }


class DeliveryProcedure(ValueSet):
    """

    Clinical Focus: This set of values contain codes commonly used in the outpatient setting to identify patients who had a live birth or delivery.
    Data Element Scope: The intent of this data element is identify patients who had a live birth or delivery.  Using the Quality Data Model, this particular element would map to the "Procedure, Performed" element.
    Inclusion Criteria: The codes used in this value set can be reasonably used to identify patients who had a live birth or delivery.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113762.1.4.1078.5'
    VALUE_SET_NAME = 'Delivery - Procedure'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '59400', '59409', '59410', '59510', '59514', '59515', '59610', '59612', '59614', '59618',
        '59620', '59622'
    }

    ICD10PCS = {
        '10D00Z0', '10D00Z1', '10D00Z2', '10D07Z3', '10D07Z4', '10D07Z5', '10D07Z6', '10D07Z7',
        '10D07Z8', '10D17ZZ', '10D18ZZ', '10D27ZZ', '10D28ZZ', '10E0XZZ'
    }

    SNOMEDCT = {
        '10745001', '11466000', '14119008', '15413009', '16819009', '177128002', '177141003',
        '177142005', '177143000', '177152009', '177157003', '177158008', '177161009', '177162002',
        '177164001', '177167008', '177168003', '177170007', '177173009', '177174003', '177175002',
        '177176001', '177179008', '177180006', '177181005', '177184002', '177203002', '17860005',
        '18625004', '19390001', '22633006', '236973005', '236974004', '236975003', '236976002',
        '236977006', '236978001', '236985002', '236986001', '236989008', '237311001', '25296001',
        '25828002', '26313002', '265639000', '274130007', '275168001', '275169009', '287976008',
        '29613008', '302382009', '302383004', '30476003', '306727001', '359940006', '359943008',
        '384729004', '38479009', '386622003', '387711001', '398307005', '40219000', '416055001',
        '417121007', '45718005', '54973000', '5556001', '57271003', '61586001', '62508004',
        '69162008', '69422002', '71166009', '72492007', '84195007', '85403009', '89053004',
        '89346004', '89849000', '90438006'
    }


class FaceToFaceInteractionNoEd(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113762.1.4.1080.1'
    VALUE_SET_NAME = 'Face to Face Interaction - No ED'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '185349003', '185463005', '185465003', '19681004', '207195004', '270427003', '270430005',
        '308335008', '390906007', '406547006', '439708006', '90526000'
    }


class HospiceCareAmbulatory(ValueSet):
    """

    Clinical Focus: Patients receiving hospice care outside of hospital or long term care facility.
    Data Element Scope: The intent of this value set is to identify all patients receiving hospice care outside of hospital or long term care facility .  Using the quality data model this maps to "Intervention, Order" and "Procedure, Order".
    Inclusion Criteria: All hospice care concepts should be included.
    Exclusion Criteria: Do not include concepts for palliative care or comfort measures.
    """

    OID = '2.16.840.1.113762.1.4.1108.15'
    VALUE_SET_NAME = 'Hospice care ambulatory'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'385763009', '385765002'}


class InjectionLeuprolideAcetate(ValueSet):
    """

    Clinical Focus: HCPCS J code for custom use to attach continuous code indicating equal to or 12 months of intended use.  This is for use with urology specific criteria.
    Data Element Scope: The intent of this data element is to include androgen deprivation therapy for equal to or greater than 12 months.  This would be done as a J1950, cont code (custom code, non-billable).
    Inclusion Criteria: J1950,cont
    Exclusion Criteria: J code other than J1950,cont
    """

    OID = '2.16.840.1.113762.1.4.1151.16'
    VALUE_SET_NAME = 'Injection Leuprolide Acetate'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    HCPCS = {'J1950'}


class DexaDualEnergyXrayAbsorptiometryBoneDensityForUrologyCare(ValueSet):
    """

    Clinical Focus: Xray studies to determine bone density.
    Data Element Scope: The intent of this data element is to identify patients with low bone mineral density
    Inclusion Criteria: 1 or more axial sites, axial skeleton (hips, pelvis, spine) or 1 or more appendicular skeleton sites (radius, wrist, heel)
    Exclusion Criteria: Study other than DEXA
    """

    OID = '2.16.840.1.113762.1.4.1151.38'
    VALUE_SET_NAME = 'DEXA Dual Energy Xray Absorptiometry, Bone Density for Urology Care'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'38265-5', '38268-9'}


class AndrogenDeprivationTherapyForUrologyCare(ValueSet):
    """

    Clinical Focus: Androgen deprivation therapy as identified for UrologyCare
    Data Element Scope: This data element is to list androgen deprivation therapy for urology care for prostate cancer.
    Inclusion Criteria: Androgen deprivation therapy medications
    Exclusion Criteria: Medications that are not androgen deprivation therapy
    """

    OID = '2.16.840.1.113762.1.4.1151.48'
    VALUE_SET_NAME = 'Androgen deprivation therapy for Urology Care'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1115257', '1115447', '1115454', '1115457', '1115462', '1115467', '1115469', '1115472',
        '284986', '310592', '545835', '752884', '752889', '752894', '752899', '828749', '828751',
        '905053', '905062'
    }


class CarotidIntervention(ValueSet):
    """

    Clinical Focus: This set of values identifies patients who have undergone a carotid artery surgical procedure.
    Data Element Scope: Appropriate for use with data elements in QDM Categories or Attributes represented by procedure codes.
    Inclusion Criteria: Included are codes that represent carotid intervention surgical procedures.
    Exclusion Criteria: Excluded are codes that would not indicate a carotid intervention has been surgically performed.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.204'
    VALUE_SET_NAME = 'Carotid Intervention'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10PCS = {
        '031H09G', '031H09J', '031H0AG', '031H0AJ', '031H0JG', '031H0JJ', '031H0KG', '031H0KJ',
        '031H0ZG', '031H0ZJ', '031J09G', '031J09K', '031J0AG', '031J0AK', '031J0JG', '031J0JK',
        '031J0KG', '031J0KK', '031J0ZG', '031J0ZK', '031K09J', '031K0AJ', '031K0JJ', '031K0KJ',
        '031K0ZJ', '031L09K', '031L0AK', '031L0JK', '031L0KK', '031L0ZK', '031M09J', '031M0AJ',
        '031M0JJ', '031M0KJ', '031M0ZJ', '031N09K', '031N0AK', '031N0JK', '031N0KK', '031N0ZK',
        '035H0ZZ', '035H3ZZ', '035H4ZZ', '035J0ZZ', '035J3ZZ', '035J4ZZ', '035K0ZZ', '035K3ZZ',
        '035K4ZZ', '035L0ZZ', '035L3ZZ', '035L4ZZ', '035M0ZZ', '035M3ZZ', '035M4ZZ', '035N0ZZ',
        '035N3ZZ', '035N4ZZ', '037H04Z', '037H0DZ', '037H0ZZ', '037H34Z', '037H3DZ', '037H3ZZ',
        '037H44Z', '037H4DZ', '037H4ZZ', '037J04Z', '037J0DZ', '037J0ZZ', '037J34Z', '037J3DZ',
        '037J3ZZ', '037J44Z', '037J4DZ', '037J4ZZ', '037K04Z', '037K0DZ', '037K0ZZ', '037K34Z',
        '037K3DZ', '037K3ZZ', '037K44Z', '037K4DZ', '037K4ZZ', '037L04Z', '037L0DZ', '037L0ZZ',
        '037L34Z', '037L3DZ', '037L3ZZ', '037L44Z', '037L4DZ', '037L4ZZ', '037M04Z', '037M0DZ',
        '037M0ZZ', '037M34Z', '037M3DZ', '037M3ZZ', '037M44Z', '037M4DZ', '037M4ZZ', '037N04Z',
        '037N0DZ', '037N0ZZ', '037N34Z', '037N3DZ', '037N3ZZ', '037N44Z', '037N4DZ', '037N4ZZ',
        '039H00Z', '039H0ZX', '039H0ZZ', '039H30Z', '039H3ZX', '039H3ZZ', '039H40Z', '039H4ZX',
        '039H4ZZ', '039J00Z', '039J0ZX', '039J0ZZ', '039J30Z', '039J3ZX', '039J3ZZ', '039J40Z',
        '039J4ZX', '039J4ZZ', '039K00Z', '039K0ZX', '039K0ZZ', '039K30Z', '039K3ZX', '039K3ZZ',
        '039K40Z', '039K4ZX', '039K4ZZ', '039L00Z', '039L0ZX', '039L0ZZ', '039L30Z', '039L3ZX',
        '039L3ZZ', '039L40Z', '039L4ZX', '039L4ZZ', '039M00Z', '039M0ZX', '039M0ZZ', '039M30Z',
        '039M3ZX', '039M3ZZ', '039M40Z', '039M4ZX', '039M4ZZ', '039N00Z', '039N0ZX', '039N0ZZ',
        '039N30Z', '039N3ZX', '039N3ZZ', '039N40Z', '039N4ZX', '039N4ZZ', '03BH0ZX', '03BH0ZZ',
        '03BH3ZX', '03BH3ZZ', '03BH4ZX', '03BH4ZZ', '03BJ0ZX', '03BJ0ZZ', '03BJ3ZX', '03BJ3ZZ',
        '03BJ4ZX', '03BJ4ZZ', '03BK0ZX', '03BK0ZZ', '03BK3ZX', '03BK3ZZ', '03BK4ZX', '03BK4ZZ',
        '03BL0ZX', '03BL0ZZ', '03BL3ZX', '03BL3ZZ', '03BL4ZX', '03BL4ZZ', '03BM0ZX', '03BM0ZZ',
        '03BM3ZX', '03BM3ZZ', '03BM4ZX', '03BM4ZZ', '03BN0ZX', '03BN0ZZ', '03BN3ZX', '03BN3ZZ',
        '03BN4ZX', '03BN4ZZ', '03CH0ZZ', '03CH3ZZ', '03CH4ZZ', '03CJ0ZZ', '03CJ3ZZ', '03CJ4ZZ',
        '03CK0ZZ', '03CK3ZZ', '03CK4ZZ', '03CL0ZZ', '03CL3ZZ', '03CL4ZZ', '03CM0ZZ', '03CM3ZZ',
        '03CM4ZZ', '03CN0ZZ', '03CN3ZZ', '03CN4ZZ', '03HH03Z', '03HH0DZ', '03HH33Z', '03HH3DZ',
        '03HH43Z', '03HH4DZ', '03HJ03Z', '03HJ0DZ', '03HJ33Z', '03HJ3DZ', '03HJ43Z', '03HJ4DZ',
        '03HK03Z', '03HK0DZ', '03HK0MZ', '03HK33Z', '03HK3DZ', '03HK3MZ', '03HK43Z', '03HK4DZ',
        '03HK4MZ', '03HL03Z', '03HL0DZ', '03HL0MZ', '03HL33Z', '03HL3DZ', '03HL3MZ', '03HL43Z',
        '03HL4DZ', '03HL4MZ', '03HM03Z', '03HM0DZ', '03HM33Z', '03HM3DZ', '03HM43Z', '03HM4DZ',
        '03HN03Z', '03HN0DZ', '03HN33Z', '03HN3DZ', '03HN43Z', '03HN4DZ', '03LH0BZ', '03LH0CZ',
        '03LH0DZ', '03LH0ZZ', '03LH3BZ', '03LH3CZ', '03LH3DZ', '03LH3ZZ', '03LH4BZ', '03LH4CZ',
        '03LH4DZ', '03LH4ZZ', '03LJ0BZ', '03LJ0CZ', '03LJ0DZ', '03LJ0ZZ', '03LJ3BZ', '03LJ3CZ',
        '03LJ3DZ', '03LJ3ZZ', '03LJ4BZ', '03LJ4CZ', '03LJ4DZ', '03LJ4ZZ', '03LK0BZ', '03LK0CZ',
        '03LK0DZ', '03LK0ZZ', '03LK3BZ', '03LK3CZ', '03LK3DZ', '03LK3ZZ', '03LK4BZ', '03LK4CZ',
        '03LK4DZ', '03LK4ZZ', '03LL0BZ', '03LL0CZ', '03LL0DZ', '03LL0ZZ', '03LL3BZ', '03LL3CZ',
        '03LL3DZ', '03LL3ZZ', '03LL4BZ', '03LL4CZ', '03LL4DZ', '03LL4ZZ', '03LM0BZ', '03LM0CZ',
        '03LM0DZ', '03LM0ZZ', '03LM3BZ', '03LM3CZ', '03LM3DZ', '03LM3ZZ', '03LM4BZ', '03LM4CZ',
        '03LM4DZ', '03LM4ZZ', '03LN0BZ', '03LN0CZ', '03LN0DZ', '03LN0ZZ', '03LN3BZ', '03LN3CZ',
        '03LN3DZ', '03LN3ZZ', '03LN4BZ', '03LN4CZ', '03LN4DZ', '03LN4ZZ', '03NH0ZZ', '03NH3ZZ',
        '03NH4ZZ', '03NJ0ZZ', '03NJ3ZZ', '03NJ4ZZ', '03NK0ZZ', '03NK3ZZ', '03NK4ZZ', '03NL0ZZ',
        '03NL3ZZ', '03NL4ZZ', '03NM0ZZ', '03NM3ZZ', '03NM4ZZ', '03NN0ZZ', '03NN3ZZ', '03NN4ZZ',
        '03QH0ZZ', '03QH3ZZ', '03QH4ZZ', '03QJ0ZZ', '03QJ3ZZ', '03QJ4ZZ', '03QK0ZZ', '03QK3ZZ',
        '03QK4ZZ', '03QL0ZZ', '03QL3ZZ', '03QL4ZZ', '03QM0ZZ', '03QM3ZZ', '03QM4ZZ', '03QN0ZZ',
        '03QN3ZZ', '03QN4ZZ', '03RH07Z', '03RH0JZ', '03RH0KZ', '03RH47Z', '03RH4JZ', '03RH4KZ',
        '03RJ07Z', '03RJ0JZ', '03RJ0KZ', '03RJ47Z', '03RJ4JZ', '03RJ4KZ', '03RK07Z', '03RK0JZ',
        '03RK0KZ', '03RK47Z', '03RK4JZ', '03RK4KZ', '03RL07Z', '03RL0JZ', '03RL0KZ', '03RL47Z',
        '03RL4JZ', '03RL4KZ', '03RM07Z', '03RM0JZ', '03RM0KZ', '03RM47Z', '03RM4JZ', '03RM4KZ',
        '03RN07Z', '03RN0JZ', '03RN0KZ', '03RN47Z', '03RN4JZ', '03RN4KZ', '03SH0ZZ', '03SH3ZZ',
        '03SH4ZZ', '03SJ0ZZ', '03SJ3ZZ', '03SJ4ZZ', '03SK0ZZ', '03SK3ZZ', '03SK4ZZ', '03SL0ZZ',
        '03SL3ZZ', '03SL4ZZ', '03SM0ZZ', '03SM3ZZ', '03SM4ZZ', '03SN0ZZ', '03SN3ZZ', '03SN4ZZ',
        '03UH07Z', '03UH0JZ', '03UH0KZ', '03UH37Z', '03UH3JZ', '03UH3KZ', '03UH47Z', '03UH4JZ',
        '03UH4KZ', '03UJ07Z', '03UJ0JZ', '03UJ0KZ', '03UJ37Z', '03UJ3JZ', '03UJ3KZ', '03UJ47Z',
        '03UJ4JZ', '03UJ4KZ', '03UK07Z', '03UK0JZ', '03UK0KZ', '03UK37Z', '03UK3JZ', '03UK3KZ',
        '03UK47Z', '03UK4JZ', '03UK4KZ', '03UL07Z', '03UL0JZ', '03UL0KZ', '03UL37Z', '03UL3JZ',
        '03UL3KZ', '03UL47Z', '03UL4JZ', '03UL4KZ', '03UM07Z', '03UM0JZ', '03UM0KZ', '03UM37Z',
        '03UM3JZ', '03UM3KZ', '03UM47Z', '03UM4JZ', '03UM4KZ', '03UN07Z', '03UN0JZ', '03UN0KZ',
        '03UN37Z', '03UN3JZ', '03UN3KZ', '03UN47Z', '03UN4JZ', '03UN4KZ', '03VH0BZ', '03VH0CZ',
        '03VH0DZ', '03VH0ZZ', '03VH3BZ', '03VH3CZ', '03VH3DZ', '03VH3ZZ', '03VH4BZ', '03VH4CZ',
        '03VH4DZ', '03VH4ZZ', '03VJ0BZ', '03VJ0CZ', '03VJ0DZ', '03VJ0ZZ', '03VJ3BZ', '03VJ3CZ',
        '03VJ3DZ', '03VJ3ZZ', '03VJ4BZ', '03VJ4CZ', '03VJ4DZ', '03VJ4ZZ', '03VK0BZ', '03VK0CZ',
        '03VK0DZ', '03VK0ZZ', '03VK3BZ', '03VK3CZ', '03VK3DZ', '03VK3ZZ', '03VK4BZ', '03VK4CZ',
        '03VK4DZ', '03VK4ZZ', '03VL0BZ', '03VL0CZ', '03VL0DZ', '03VL0ZZ', '03VL3BZ', '03VL3CZ',
        '03VL3DZ', '03VL3ZZ', '03VL4BZ', '03VL4CZ', '03VL4DZ', '03VL4ZZ', '03VM0BZ', '03VM0CZ',
        '03VM0DZ', '03VM0ZZ', '03VM3BZ', '03VM3CZ', '03VM3DZ', '03VM3ZZ', '03VM4BZ', '03VM4CZ',
        '03VM4DZ', '03VM4ZZ', '03VN0BZ', '03VN0CZ', '03VN0DZ', '03VN0ZZ', '03VN3BZ', '03VN3CZ',
        '03VN3DZ', '03VN3ZZ', '03VN4BZ', '03VN4CZ', '03VN4DZ', '03VN4ZZ', '0G560ZZ', '0G563ZZ',
        '0G564ZZ', '0G570ZZ', '0G573ZZ', '0G574ZZ', '0G580ZZ', '0G583ZZ', '0G584ZZ', '0G9600Z',
        '0G960ZX', '0G960ZZ', '0G9630Z', '0G963ZX', '0G963ZZ', '0G9640Z', '0G964ZX', '0G964ZZ',
        '0G9700Z', '0G970ZX', '0G970ZZ', '0G9730Z', '0G973ZX', '0G973ZZ', '0G9740Z', '0G974ZX',
        '0G974ZZ', '0G9800Z', '0G980ZX', '0G980ZZ', '0G9830Z', '0G983ZX', '0G983ZZ', '0G9840Z',
        '0G984ZX', '0G984ZZ', '0GB60ZX', '0GB60ZZ', '0GB63ZX', '0GB63ZZ', '0GB64ZX', '0GB64ZZ',
        '0GB70ZX', '0GB70ZZ', '0GB73ZX', '0GB73ZZ', '0GB74ZX', '0GB74ZZ', '0GB80ZX', '0GB80ZZ',
        '0GB83ZX', '0GB83ZZ', '0GB84ZX', '0GB84ZZ', '0GC60ZZ', '0GC63ZZ', '0GC64ZZ', '0GC70ZZ',
        '0GC73ZZ', '0GC74ZZ', '0GC80ZZ', '0GC83ZZ', '0GC84ZZ', '0GN60ZZ', '0GN63ZZ', '0GN64ZZ',
        '0GN70ZZ', '0GN73ZZ', '0GN74ZZ', '0GN80ZZ', '0GN83ZZ', '0GN84ZZ', '0GQ60ZZ', '0GQ63ZZ',
        '0GQ64ZZ', '0GQ70ZZ', '0GQ73ZZ', '0GQ74ZZ', '0GQ80ZZ', '0GQ83ZZ', '0GQ84ZZ', '0GT60ZZ',
        '0GT64ZZ', '0GT70ZZ', '0GT74ZZ', '0GT80ZZ', '0GT84ZZ', 'B3060ZZ', 'B3061ZZ', 'B306YZZ',
        'B3070ZZ', 'B3071ZZ', 'B307YZZ', 'B3080ZZ', 'B3081ZZ', 'B308YZZ', 'B3160ZZ', 'B3161ZZ',
        'B316YZZ', 'B3170ZZ', 'B3171ZZ', 'B317YZZ', 'B3180ZZ', 'B3181ZZ', 'B318YZZ'
    }

    ICD9CM = {
        '0061', '0062', '0063', '0064', '0065', '3802', '3812', '3822', '3830', '3831', '3832',
        '3842', '3922', '3928', '8841'
    }

    SNOMEDCT = {
        '112823003', '15023006', '175363002', '175364008', '175365009', '175367001', '175373000',
        '175374006', '175376008', '175379001', '175380003', '175398004', '18674003', '209760000',
        '22928005', '233259003', '233260008', '233296007', '233297003', '233298008', '233405004',
        '241219006', '25007007', '276949008', '276950008', '276951007', '287606009', '302053004',
        '303161001', '31573003', '34214004', '39887009', '405326004', '405379009', '405407008',
        '405408003', '405409006', '405411002', '405412009', '405415006', '417884003', '418405008',
        '418838006', '419014003', '420026003', '420046008', '420171008', '425611003', '427486009',
        '428802000', '429287007', '431515004', '431519005', '431535003', '431659001', '432039002',
        '432785007', '433056003', '433061001', '433591001', '433683001', '433690006', '433711000',
        '433734009', '434159001', '434378006', '434433007', '43628009', '438615003', '440221006',
        '440453000', '440518005', '449242004', '46912008', '51382002', '53412000', '55493009',
        '59012002', '59109003', '66951008', '74720005', '75538004', '79507006', '80102005',
        '80104006', '87314005', '90931006', '9339002'
    }


class DischargedToHealthCareFacilityForHospiceCare(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent the discharge of a patient to a health care facility for hospice care.
    Data Element Scope: The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular  inpatient encounter. This particular value set intends to identify patients who where discharged to a health care facility for hospice care. Using the Quality Data Model, this particular value set is used with the Attribute of "Discharge status" used with the "Encounter" category.
    Inclusion Criteria: Only SNOMED CT codes representing  health care facilities for hospice care  should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.207'
    VALUE_SET_NAME = 'Discharged to Health Care Facility for Hospice Care'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428371000124100'}


class DischargedToHomeForHospiceCare(ValueSet):
    """

    Clinical Focus: This set of values contains procedures used to represent the discharge of a patient to home for hospice care.
    Data Element Scope: The intent of this data element is to identify the final place or setting to which the patient was discharged on the day of discharge from a particular  inpatient encounter. This particular value set intends to identify patients who where discharged to home for hospice care.  Using the Quality Data Model, this particular value set is used with the Attribute of "Discharge status" used with the "Encounter" category.
    Inclusion Criteria: Only SNOMED CT codes representing discharge to home for hospice care should be included.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.209'
    VALUE_SET_NAME = 'Discharged to Home for Hospice Care'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428361000124107'}


class StatinAllergen(ValueSet):
    """

    Clinical Focus: Identifies patients with an allergy to statin medications.
    Data Element Scope: Statin Allergens as structured in RXNORM
    Inclusion Criteria: Only includes codes that use the IN term type for statins.
    Exclusion Criteria: Does not include non-statin medications.
    """

    OID = '2.16.840.1.113883.3.117.1.7.1.423'
    VALUE_SET_NAME = 'Statin Allergen'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'301542', '36567', '41127', '42463', '6472', '83367', '861634'}


class BhConditionInvolvingBipolarDisorder(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1504'
    VALUE_SET_NAME = 'BH Condition Involving Bipolar Disorder'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'F3010', 'F3011', 'F3012', 'F3013', 'F302', 'F303', 'F308', 'F309', 'F310', 'F3110',
        'F3111', 'F3112', 'F3113', 'F312', 'F3130', 'F3131', 'F3132', 'F314', 'F315', 'F3160',
        'F3161', 'F3162', 'F3163', 'F3164', 'F3170', 'F3171', 'F3173', 'F3175', 'F3177', 'F3181',
        'F3189', 'F319', 'F340', 'F3489'
    }

    SNOMEDCT = {
        '10875004', '10981006', '1196001', '13313007', '13581000', '13746004', '14495005',
        '1499003', '162004', '16295005', '16506000', '17782008', '191583000', '191584006',
        '191586008', '191590005', '191592002', '191593007', '191595000', '191618007', '191620005',
        '191621009', '191623007', '191627008', '191629006', '191630001', '191632009', '191636007',
        '191638008', '191639000', '191641004', '191658009', '192362008', '19300006', '20960007',
        '21900002', '22407005', '231444002', '231494001', '231495000', '231496004', '26203008',
        '26530004', '268619003', '28663008', '28884001', '29929003', '30520009', '30687003',
        '31446002', '33380008', '34315001', '35481005', '35722002', '35846004', '36583000',
        '371596008', '371599001', '371600003', '371604007', '40926005', '41552001', '41832009',
        '41932008', '43568002', '43769008', '4441000', '45479006', '46229002', '48937005',
        '49468007', '49512000', '51637008', '53049002', '53607008', '54761006', '55516002',
        '5703000', '59617007', '61403008', '63249007', '64731001', '65042007', '66631006',
        '67002003', '68569003', '70546001', '71294008', '71984005', '73471000', '74686005',
        '75360000', '75752004', '76105009', '78269000', '78640000', '79584002', '81319007',
        '82998009', '83225003', '85248005', '86058007', '87203005', '87950005', '9340000'
    }


class BhConditionInvolvingUnipolarDepression(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1505'
    VALUE_SET_NAME = 'BH Condition Involving Unipolar Depression'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'F320', 'F321', 'F322', 'F323', 'F324', 'F3281', 'F3289', 'F329', 'F330', 'F331', 'F332',
        'F333', 'F3340', 'F3341', 'F338', 'F339', 'F341'
    }

    SNOMEDCT = {
        '14183003', '15193003', '15639000', '18818009', '191610000', '191611001', '191613003',
        '19527009', '20250007', '25922000', '2618002', '268621008', '28475009', '30605009',
        '319768000', '320751009', '33078009', '33135002', '33736005', '35489007', '36474008',
        '36923009', '370143000', '38694004', '39809009', '40379007', '42810003', '42925002',
        '430852001', '46244001', '60099002', '63412003', '63778009', '66344007', '68019004',
        '69392006', '70747007', '71336009', '73867007', '75084000', '76441001', '77911002',
        '78667006', '79298009', '832007', '87512008'
    }


class BhElectroconvulsiveTherapy(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1533'
    VALUE_SET_NAME = 'BH Electroconvulsive Therapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90870'}

    ICD10PCS = {'GZB0ZZZ', 'GZB1ZZZ', 'GZB2ZZZ', 'GZB3ZZZ', 'GZB4ZZZ'}

    SNOMEDCT = {
        '11075005', '231079005', '231080008', '23835007', '284468008', '313019002', '313020008'
    }


class BhAssessmentForAlcoholOrOtherDrugs(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1604'
    VALUE_SET_NAME = 'BH Assessment for Alcohol or Other Drugs'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99408', '99409'}

    HCPCS = {'H0001', 'H0049'}

    SNOMEDCT = {
        '105355005', '117251007', '171208001', '252170002', '273347006', '408942001', '408946003',
        '428211000124100'
    }


class BhCounselingForDepression(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.1616'
    VALUE_SET_NAME = 'BH Counseling for Depression'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428201000124103'}


class BhMedicalOrPsychiatricConsultation(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.1257.1.1652'
    VALUE_SET_NAME = 'BH Medical or psychiatric consultation'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99241', '99242', '99243', '99244', '99245'}

    ICD9CM = {'8906', '8907', '8908', '8909'}

    SNOMEDCT = {
        '17436001', '183654001', '185211000', '185387006', '185389009', '30346009', '371883000',
        '37894004', '390906007', '40274000', '86013001', '90526000'
    }


class BhMoodStabilizerMedication(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.950'
    VALUE_SET_NAME = 'BH Mood Stabilizer Medication'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1006801', '151226', '197535', '197536', '198075', '198076', '198077', '198078', '199888',
        '199889', '199890', '205315', '205316', '283536', '309374', '312136', '312137', '312138',
        '312325', '429212', '476177', '476179', '721773', '848722', '848728', '848732', '848736',
        '848740', '848744', '848748', '859824', '996921'
    }


class BhAntidepressantMedication(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.972'
    VALUE_SET_NAME = 'BH Antidepressant Medication'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1000048', '1000054', '1000058', '1000064', '1000070', '1000076', '1000091', '1000097',
        '104837', '1098649', '1098666', '1098670', '1098674', '1098678', '1099288', '1099292',
        '1099296', '1099300', '1099304', '1099316', '1190110', '1232585', '1298857', '1298861',
        '1298870', '1738483', '1738495', '1738503', '1738511', '1738515', '1738519', '1738523',
        '1738527', '197363', '197364', '197365', '197366', '197889', '197890', '197891', '197892',
        '197893', '198045', '198046', '198047', '199283', '199324', '199461', '199462', '199484',
        '199485', '199487', '199488', '199761', '199820', '200371', '245373', '246588', '248642',
        '251200', '283406', '283407', '283485', '283672', '309313', '309314', '310384', '310385',
        '310386', '311355', '311725', '311726', '312036', '312241', '312242', '312243', '312244',
        '312347', '312938', '312940', '312941', '313447', '313496', '313497', '313498', '313499',
        '313580', '313581', '313582', '313583', '313584', '313585', '313586', '313989', '313990',
        '313995', '314111', '314199', '314277', '317136', '349332', '351249', '351250', '351285',
        '403969', '403970', '403971', '403972', '476809', '562790', '562791', '562815', '596926',
        '596930', '596934', '608328', '636664', '721787', '730440', '730441', '730442', '746073',
        '749153', '756059', '790264', '790288', '794947', '803293', '808744', '808748', '808751',
        '808753', '833135', '833141', '833144', '833147', '835564', '835568', '835572', '835577',
        '835589', '835591', '835593', '846386', '856364', '856369', '856373', '856377', '856706',
        '856720', '856762', '856769', '856773', '856783', '856792', '856797', '856825', '856834',
        '856840', '856845', '856853', '857291', '857296', '857297', '857301', '857305', '857315',
        '859186', '859190', '859193', '861064', '865206', '865210', '865214', '898697', '898704',
        '903873', '903879', '903884', '903887', '903891', '905168', '905172', '966787', '966793',
        '993503', '993518', '993536', '993541', '993550', '993557', '993567', '993681', '993687',
        '993691'
    }


class BhOutpatientPsychotherapy(ValueSet):
    """

    Clinical Focus: Under development
    Data Element Scope: Under development
    Inclusion Criteria: Under development
    Exclusion Criteria: Under development
    """

    OID = '2.16.840.1.113883.3.1257.1.973'
    VALUE_SET_NAME = 'BH Outpatient Psychotherapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90791', '90792', '90832', '90834', '90837'}

    ICD10PCS = {
        'GZ50ZZZ', 'GZ51ZZZ', 'GZ52ZZZ', 'GZ53ZZZ', 'GZ54ZZZ', 'GZ55ZZZ', 'GZ56ZZZ', 'GZ58ZZZ',
        'GZ59ZZZ', 'GZ72ZZZ', 'GZHZZZZ'
    }

    SNOMEDCT = {'108313002', '183382003', '183383008', '75516001', '76168009'}


class BhOutpatientEncounter(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1.49'
    VALUE_SET_NAME = 'BH Outpatient encounter'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99241',
        '99242', '99243', '99244', '99245'
    }

    SNOMEDCT = {
        '17436001', '183654001', '185211000', '185387006', '185389009', '30346009', '371883000',
        '37894004', '390906007', '40274000', '86013001', '90526000'
    }


class OfficeVisit(ValueSet):
    """

    Clinical Focus: This value set indentifies patients who have had an office or other outpatient visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1005'
    VALUE_SET_NAME = 'Office Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215'}


class OutpatientConsultation(ValueSet):
    """

    Clinical Focus: This value set indentifies patients who have had an outpatient interaction at an office with a member of their medical care team.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1040'
    VALUE_SET_NAME = 'Outpatient Consultation'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99241', '99242', '99243', '99244', '99245'}


class PreventiveCareServicesInitialOfficeVisit18AndUp(ValueSet):
    """

    Clinical Focus: This value set indentifies patients over the age of 18 who have had an initial preventive care office visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive preventive medicine reevaluation and management of an individual over the age of 18.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1115'
    VALUE_SET_NAME = 'Preventive Care Services-Initial Office Visit, 18 and Up'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99385', '99386', '99387'}


class PreventiveCareServicesEstablishedOfficeVisit18AndUp(ValueSet):
    """

    Clinical Focus: This value set indentifies patients over the age of 18 who have had an established preventive care office visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive preventive medicine reevaluation and management of an individual over the age of 18.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1125'
    VALUE_SET_NAME = 'Preventive Care Services - Established Office Visit, 18 and Up'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99395', '99396', '99397'}


class OphthalmologicOutpatientVisit(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.11.1206'
    VALUE_SET_NAME = 'Ophthalmologic Outpatient Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'92002', '92004', '92012', '92014'}


class OfficeVisit_1001(ValueSet):
    """

    Clinical Focus: This value set identifies patients who have had an office or other outpatient visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1001'
    VALUE_SET_NAME = 'Office Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215'}


class HospitalObservationCareInitial(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1002'
    VALUE_SET_NAME = 'Hospital Observation Care - Initial'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99218', '99219', '99220'}


class HospitalInpatientVisitInitial(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1004'
    VALUE_SET_NAME = 'Hospital Inpatient Visit - Initial'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99221', '99222', '99223'}


class DischargeServicesHospitalInpatientSameDayDischarge(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1006'
    VALUE_SET_NAME = 'Discharge Services - Hospital Inpatient Same Day Discharge'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99234', '99235', '99236'}


class DischargeServicesHospitalInpatient(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1007'
    VALUE_SET_NAME = 'Discharge Services - Hospital Inpatient'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99238', '99239'}


class OutpatientConsultation_1008(ValueSet):
    """

    Clinical Focus: This value set indentifies patients who have had an outpatient interaction at an office with a member of their medical care team.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive history, evaluation, and management of a patient in an office or outpatient facility. Patient can be presenting with problems that are minor to high severity.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1008'
    VALUE_SET_NAME = 'Outpatient Consultation'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99241', '99242', '99243', '99244', '99245'}


class EmergencyDepartmentVisit(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1010'
    VALUE_SET_NAME = 'Emergency Department Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99281', '99282', '99283', '99284', '99285'}


class NursingFacilityVisit(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1012'
    VALUE_SET_NAME = 'Nursing Facility Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99304', '99305', '99306', '99307', '99308', '99309', '99310'}


class DischargeServicesNursingFacility(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1013'
    VALUE_SET_NAME = 'Discharge Services - Nursing Facility'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99315', '99316'}


class CareServicesInLongTermResidentialFacility(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1014'
    VALUE_SET_NAME = 'Care Services in Long-Term Residential Facility'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99324', '99325', '99326', '99327', '99328', '99334', '99335', '99336', '99337'}


class HomeHealthcareServices(ValueSet):
    """

    Clinical Focus: This value set identifies patients who have had a home health visit by a provider for the evaluation or management of a new or existing patient.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Include all home visits for the evaluation and management of a new or established patient.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1016'
    VALUE_SET_NAME = 'Home Healthcare Services'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99341', '99342', '99343', '99344', '99345', '99347', '99348', '99349', '99350'}


class PreventiveCareInitialOfficeVisit0To17(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1022'
    VALUE_SET_NAME = 'Preventive Care- Initial Office Visit, 0 to 17'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99381', '99382', '99383', '99384'}


class PreventiveCareServicesInitialOfficeVisit18AndUp_1023(ValueSet):
    """

    Clinical Focus: This value set identifies patients over the age of 18 who have had an initial preventive care office visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive preventive medicine reevaluation and management of an individual over the age of 18.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1023'
    VALUE_SET_NAME = 'Preventive Care Services-Initial Office Visit, 18 and Up'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99385', '99386', '99387'}


class PreventiveCareEstablishedOfficeVisit0To17(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1024'
    VALUE_SET_NAME = 'Preventive Care - Established Office Visit, 0 to 17'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99391', '99392', '99393', '99394'}


class PreventiveCareServicesEstablishedOfficeVisit18AndUp_1025(ValueSet):
    """

    Clinical Focus: This value set identifies patients over the age of 18 who have had an established preventive care office visit.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes comprehensive preventive medicine reevaluation and management of an individual over the age of 18.
    Exclusion Criteria: Excludes non-office visits, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1025'
    VALUE_SET_NAME = 'Preventive Care Services - Established Office Visit, 18 and Up'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99395', '99396', '99397'}


class PreventiveCareServicesIndividualCounseling(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1026'
    VALUE_SET_NAME = 'Preventive Care Services-Individual Counseling'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99401', '99402', '99403', '99404'}


class PreventiveCareServicesGroupCounseling(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1027'
    VALUE_SET_NAME = 'Preventive Care Services - Group Counseling'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99411', '99412'}


class PreventiveCareServicesOther(ValueSet):
    """

    Clinical Focus: This value set identifies patients who patients who had an unlisted preventive medicine service.  Inclusion: Includes unlisted preventive medicine services
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes unlisted preventive medicine services.
    Exclusion Criteria: Excludes visits that are not performed in-person, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1030'
    VALUE_SET_NAME = 'Preventive Care Services - Other'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99420', '99429'}


class TelehealthServices(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1031'
    VALUE_SET_NAME = 'Telehealth Services'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'98966', '98967', '98968', '98969', '99441', '99442', '99443', '99444'}


class DischargeServicesObservationCare(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1039'
    VALUE_SET_NAME = 'Discharge Services- Observation Care'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99217'}


class Referral(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1046'
    VALUE_SET_NAME = 'Referral'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '103696004', '103697008', '103699006', '103704003', '183515008', '183517000', '183528001',
        '183529009', '183530004', '183541002', '183555005', '183557002', '183561008', '183567007',
        '183569005', '183591003', '183878008', '183879000', '183880002', '183881003', '183882005',
        '183884006', '183885007', '183886008', '183887004', '183888009', '183889001', '183890005',
        '183891009', '183892002', '183893007', '183894001', '183895000', '183896004', '183897008',
        '183899006', '183900001', '183901002', '183902009', '183903004', '183904005', '183905006',
        '183906007', '183907003', '183908008', '183909000', '183910005', '183911009', '183913007',
        '183914001', '183915000', '183916004', '266747000', '274410002', '306241009', '306242002',
        '306243007', '306245000', '306247008', '306250006', '306252003', '306253008', '306254002',
        '306255001', '306256000', '306257009', '306258004', '306259007', '306260002', '306261003',
        '306262005', '306263000', '306264006', '306265007', '306266008', '306267004', '306268009',
        '306269001', '306270000', '306271001', '306272008', '306273003', '306274009', '306275005',
        '306276006', '306277002', '306278007', '306279004', '306280001', '306281002', '306282009',
        '306284005', '306285006', '306286007', '306287003', '306288008', '306289000', '306290009',
        '306291008', '306293006', '306294000', '306295004', '306296003', '306297007', '306298002',
        '306299005', '306300002', '306301003', '306302005', '306303000', '306304006', '306305007',
        '306306008', '306307004', '306308009', '306309001', '306310006', '306311005', '306312003',
        '306313008', '306314002', '306315001', '306316000', '306317009', '306318004', '306320001',
        '306338003', '306341007', '306342000', '306343005', '306351008', '306352001', '306353006',
        '306354000', '306355004', '306356003', '306357007', '306358002', '306359005', '306360000',
        '306361001', '306736002', '307063001', '307777008', '308439003', '308447003', '308449000',
        '308450000', '308451001', '308452008', '308453003', '308454009', '308455005', '308456006',
        '308459004', '308465004', '308469005', '308470006', '308471005', '308472003', '308473008',
        '308474002', '308475001', '308476000', '308477009', '308478004', '308479007', '308480005',
        '308481009', '308482002', '308483007', '308484001', '308485000', '309046007', '309623006',
        '309626003', '309627007', '309629005', '310515004', '312487009', '312488004', '401266006',
        '406158007', '406159004', '408285001', '415277000', '416116000', '416999007', '425971006',
        '428441000124100', '428451000124103', '428461000124101', '428471000124108',
        '428481000124106', '428491000124109', '428541000124104', '429365000', '433151006',
        '448761000124106', '448771000124104', '54395008', '698563003', '698599008', '703974003',
        '703975002', '703976001', '716634006'
    }


class FaceToFaceInteraction(ValueSet):
    """

    Clinical Focus: This value set indentifies patients who have had a face-to-face interaction with a member of their medical care team.
    Data Element Scope: This value set was intended to map to the QDM data type of encounter.
    Inclusion Criteria: Includes both initial and follow up visits. Includes home visits, inpatient and outpatient visits, and nursing facility visits.
    Exclusion Criteria: Excludes visits that are not performed in-person, including telehealth services.
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1048'
    VALUE_SET_NAME = 'Face-to-Face Interaction'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class TelephoneManagement(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1053'
    VALUE_SET_NAME = 'Telephone Management'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'98966', '98967', '98968'}


class BehavioralHealthFollowUpVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1054'
    VALUE_SET_NAME = 'Behavioral Health Follow-up Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '96150', '96151', '96152', '96153', '96154', '98960', '98961', '98962', '99078', '99510'
    }


class PsychotherapyAndPharmacologicManagement(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1055'
    VALUE_SET_NAME = 'Psychotherapy and Pharmacologic Management'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90845', '90847', '90849', '90853', '90875', '90876'}


class BloodPressureVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1056'
    VALUE_SET_NAME = 'Blood Pressure Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99241',
        '99242', '99243', '99244', '99245', '99304', '99305', '99306', '99307', '99308', '99309',
        '99310', '99324', '99325', '99326', '99327', '99328', '99334', '99335', '99336', '99337',
        '99341', '99342', '99343', '99344', '99345', '99347', '99348', '99349', '99350', '99385',
        '99386', '99387', '99395', '99396', '99397'
    }

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class DetoxificationVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1059'
    VALUE_SET_NAME = 'Detoxification Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '182969009', '20093000', '23915005', '266707007', '310653000', '414054004', '414056002',
        '56876005', '61480009', '64297001', '67516001', '87106005'
    }


class InpatientEncounter(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1060'
    VALUE_SET_NAME = 'Inpatient Encounter'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '10378005', '112689000', '112690009', '1505002', '15584006', '18083007', '183452005',
        '183455007', '183457004', '183458009', '183459001', '183460006', '183461005', '183462003',
        '183463008', '183464002', '183465001', '183466000', '183467009', '183468004', '183469007',
        '183470008', '183471007', '183472000', '183473005', '183474004', '183475003', '183476002',
        '183477006', '183478001', '183481006', '183497001', '19951005', '2252009', '23473000',
        '25986004', '2876009', '304568006', '305337004', '305338009', '305339001', '305340004',
        '305341000', '305342007', '305343002', '305344008', '305345009', '305346005', '305347001',
        '305348006', '313385005', '3241000175106', '32485007', '36723004', '405614004',
        '408489005', '408501008', '416683003', '417005', '432621000124105', '432661000124104',
        '442281000124108', '448381000124100', '448421000124105', '448431000124108',
        '448441000124103', '448851000124103', '4563007', '45702004', '47348005', '48183000',
        '50699000', '51032003', '51501005', '52748007', '55402005', '60059000', '63551005',
        '65043002', '699122005', '699245006', '70755000', '71290004', '73607007', '74857009',
        '76464004', '78680009', '81672003', '82942009', '8715000'
    }


class AmbulatoryedVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1061'
    VALUE_SET_NAME = 'Ambulatory/ED Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99217',
        '99218', '99219', '99220', '99241', '99242', '99243', '99244', '99245', '99281', '99282',
        '99283', '99284', '99285', '99341', '99342', '99343', '99344', '99345', '99347', '99348',
        '99349', '99350', '99381', '99382', '99383', '99384', '99385', '99386', '99387', '99391',
        '99392', '99393', '99394', '99395', '99396', '99397', '99401', '99402', '99403', '99404',
        '99411', '99412', '99420', '99429', '99455', '99456'
    }

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class AdultOutpatientVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1065'
    VALUE_SET_NAME = 'Adult Outpatient Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99241',
        '99242', '99243', '99244', '99245', '99341', '99342', '99343', '99344', '99345', '99347',
        '99348', '99349', '99350', '99385', '99386', '99387', '99395', '99396', '99397'
    }

    HCPCS = {'G0438', 'G0439'}

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class AudiologyVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1066'
    VALUE_SET_NAME = 'Audiology Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'92540', '92541', '92542', '92548'}


class PostoperativeVisit(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1070'
    VALUE_SET_NAME = 'Postoperative Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'99024'}


class OsteopathicOrChiropracticManipulativeTreatment(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.101.12.1076'
    VALUE_SET_NAME = 'Osteopathic or Chiropractic Manipulative Treatment'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'98925', '98926', '98927', '98928', '98929', '98940', '98941', '98942'}


class AcutePharyngitis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1011'
    VALUE_SET_NAME = 'Acute Pharyngitis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'J020', 'J028', 'J029'}

    SNOMEDCT = {
        '1532007', '195655000', '195656004', '195657008', '195658003', '195659006', '195660001',
        '195662009', '232399005', '232400003', '363746003', '40766000', '43878008', '58031004'
    }


class AcuteTonsillitis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1012'
    VALUE_SET_NAME = 'Acute Tonsillitis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'J0300', 'J0301', 'J0380', 'J0381', 'J0390', 'J0391'}

    SNOMEDCT = {
        '10629271000119107', '17741008', '195666007', '195667003', '195668008', '195669000',
        '195670004', '195671000', '195672007', '195673002', '195676005', '195677001', '302911003'
    }


class CompetingConditionsForRespiratoryConditions(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1017'
    VALUE_SET_NAME = 'Competing Conditions for Respiratory Conditions'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'A000', 'A001', 'A009', 'A0100', 'A0101', 'A0102', 'A0103', 'A0104', 'A0105', 'A0109',
        'A011', 'A012', 'A013', 'A014', 'A020', 'A021', 'A0220', 'A0221', 'A0222', 'A0223',
        'A0224', 'A0225', 'A0229', 'A028', 'A029', 'A030', 'A031', 'A032', 'A033', 'A038', 'A039',
        'A040', 'A041', 'A042', 'A043', 'A044', 'A045', 'A046', 'A047', 'A048', 'A049', 'A050',
        'A051', 'A052', 'A053', 'A054', 'A055', 'A058', 'A059', 'A060', 'A061', 'A062', 'A063',
        'A064', 'A065', 'A066', 'A067', 'A0681', 'A0682', 'A0689', 'A069', 'A070', 'A071', 'A072',
        'A073', 'A074', 'A078', 'A079', 'A080', 'A0811', 'A0819', 'A082', 'A0831', 'A0832',
        'A0839', 'A084', 'A088', 'A09', 'A3700', 'A3701', 'A3710', 'A3711', 'A3780', 'A3781',
        'A3790', 'A3791', 'A440', 'A441', 'A448', 'A449', 'A499', 'A5001', 'A5002', 'A5003',
        'A5004', 'A5005', 'A5006', 'A5007', 'A5008', 'A5009', 'A501', 'A502', 'A5030', 'A5031',
        'A5032', 'A5039', 'A5040', 'A5041', 'A5042', 'A5043', 'A5044', 'A5045', 'A5049', 'A5051',
        'A5052', 'A5053', 'A5054', 'A5055', 'A5056', 'A5057', 'A5059', 'A506', 'A507', 'A509',
        'A510', 'A511', 'A512', 'A5131', 'A5132', 'A5139', 'A5141', 'A5142', 'A5143', 'A5144',
        'A5145', 'A5146', 'A5149', 'A515', 'A519', 'A5200', 'A5201', 'A5202', 'A5203', 'A5204',
        'A5205', 'A5206', 'A5209', 'A5210', 'A5211', 'A5212', 'A5213', 'A5214', 'A5215', 'A5216',
        'A5217', 'A5219', 'A522', 'A523', 'A5271', 'A5272', 'A5273', 'A5274', 'A5275', 'A5276',
        'A5277', 'A5278', 'A5279', 'A528', 'A529', 'A530', 'A539', 'A5400', 'A5401', 'A5402',
        'A5403', 'A5409', 'A541', 'A5421', 'A5422', 'A5423', 'A5424', 'A5429', 'A5430', 'A5431',
        'A5432', 'A5433', 'A5439', 'A5440', 'A5441', 'A5442', 'A5443', 'A5449', 'A545', 'A546',
        'A5481', 'A5482', 'A5483', 'A5484', 'A5485', 'A5486', 'A5489', 'A549', 'A55', 'A5600',
        'A5601', 'A5602', 'A5609', 'A5611', 'A5619', 'A562', 'A563', 'A564', 'A568', 'A57', 'A58',
        'A5900', 'A5901', 'A5902', 'A5903', 'A5909', 'A598', 'A599', 'A630', 'A638', 'A64', 'A690',
        'A691', 'A6920', 'A6921', 'A6922', 'A6923', 'A6929', 'B600', 'B608', 'B64', 'B781',
        'B9689', 'E832', 'H66001', 'H66002', 'H66003', 'H66004', 'H66005', 'H66006', 'H66007',
        'H66009', 'H66011', 'H66012', 'H66013', 'H66014', 'H66015', 'H66016', 'H66017', 'H66019',
        'H6610', 'H6611', 'H6612', 'H6613', 'H6620', 'H6621', 'H6622', 'H6623', 'H663X1', 'H663X2',
        'H663X3', 'H663X9', 'H6640', 'H6641', 'H6642', 'H6643', 'H6690', 'H6691', 'H6692', 'H6693',
        'H671', 'H672', 'H673', 'H679', 'H70001', 'H70002', 'H70003', 'H70009', 'H70011', 'H70012',
        'H70013', 'H70019', 'H70091', 'H70092', 'H70093', 'H70099', 'H7010', 'H7011', 'H7012',
        'H7013', 'H70201', 'H70202', 'H70203', 'H70209', 'H70211', 'H70212', 'H70213', 'H70219',
        'H70221', 'H70222', 'H70223', 'H70229', 'H70811', 'H70812', 'H70813', 'H70819', 'H70891',
        'H70892', 'H70893', 'H70899', 'H7090', 'H7091', 'H7092', 'H7093', 'H9500', 'H9501',
        'H9502', 'H9503', 'H95111', 'H95112', 'H95113', 'H95119', 'H95121', 'H95122', 'H95123',
        'H95129', 'H95131', 'H95132', 'H95133', 'H95139', 'H95191', 'H95192', 'H95193', 'H95199',
        'H9521', 'H9522', 'H9531', 'H9532', 'H9541', 'H9542', 'H95811', 'H95812', 'H95813',
        'H95819', 'H9588', 'H9589', 'J0100', 'J0101', 'J0110', 'J0111', 'J0120', 'J0121', 'J0130',
        'J0131', 'J0140', 'J0141', 'J0180', 'J0181', 'J0190', 'J0191', 'J020', 'J028', 'J029',
        'J0300', 'J0301', 'J0380', 'J0381', 'J0390', 'J0391', 'J0410', 'J0411', 'J042', 'J050',
        'J0510', 'J0511', 'J13', 'J14', 'J150', 'J151', 'J1520', 'J15211', 'J15212', 'J1529',
        'J153', 'J154', 'J155', 'J156', 'J157', 'J158', 'J159', 'J160', 'J168', 'J17', 'J180',
        'J181', 'J188', 'J189', 'J200', 'J201', 'J202', 'J320', 'J321', 'J322', 'J323', 'J324',
        'J328', 'J329', 'J3501', 'J3502', 'J3503', 'J351', 'J352', 'J353', 'J358', 'J359', 'J387',
        'J390', 'J391', 'J392', 'J398', 'J399', 'K122', 'L0100', 'L0101', 'L0102', 'L0103',
        'L0109', 'L011', 'L03011', 'L03012', 'L03019', 'L03021', 'L03022', 'L03029', 'L03031',
        'L03032', 'L03039', 'L03041', 'L03042', 'L03049', 'L03111', 'L03112', 'L03113', 'L03114',
        'L03115', 'L03116', 'L03119', 'L03121', 'L03122', 'L03123', 'L03124', 'L03125', 'L03126',
        'L03129', 'L03211', 'L03212', 'L03221', 'L03222', 'L03311', 'L03312', 'L03313', 'L03314',
        'L03315', 'L03316', 'L03317', 'L03319', 'L03321', 'L03322', 'L03323', 'L03324', 'L03325',
        'L03326', 'L03327', 'L03329', 'L03811', 'L03818', 'L03891', 'L03898', 'L0390', 'L0391',
        'L040', 'L041', 'L042', 'L043', 'L048', 'L049', 'L080', 'L081', 'L0881', 'L0882', 'L0889',
        'L089', 'L88', 'L928', 'L980', 'L983', 'M4620', 'M4621', 'M4622', 'M4623', 'M4624',
        'M4625', 'M4626', 'M4627', 'M4628', 'M4630', 'M4631', 'M4632', 'M4633', 'M4634', 'M4635',
        'M4636', 'M4637', 'M4638', 'M4639', 'M8900', 'M89011', 'M89012', 'M89019', 'M89021',
        'M89022', 'M89029', 'M89031', 'M89032', 'M89039', 'M89041', 'M89042', 'M89049', 'M89051',
        'M89052', 'M89059', 'M89061', 'M89062', 'M89069', 'M89071', 'M89072', 'M89079', 'M8908',
        'M8909', 'M89121', 'M89122', 'M89123', 'M89124', 'M89125', 'M89126', 'M89127', 'M89128',
        'M89129', 'M89131', 'M89132', 'M89133', 'M89134', 'M89138', 'M89139', 'M89151', 'M89152',
        'M89153', 'M89154', 'M89155', 'M89156', 'M89157', 'M89158', 'M89159', 'M89160', 'M89161',
        'M89162', 'M89163', 'M89164', 'M89165', 'M89166', 'M89167', 'M89168', 'M89169', 'M8918',
        'M8920', 'M89211', 'M89212', 'M89219', 'M89221', 'M89222', 'M89229', 'M89231', 'M89232',
        'M89233', 'M89234', 'M89239', 'M89241', 'M89242', 'M89249', 'M89251', 'M89252', 'M89259',
        'M89261', 'M89262', 'M89263', 'M89264', 'M89269', 'M89271', 'M89272', 'M89279', 'M8928',
        'M8929', 'M8930', 'M89311', 'M89312', 'M89319', 'M89321', 'M89322', 'M89329', 'M89331',
        'M89332', 'M89333', 'M89334', 'M89339', 'M89341', 'M89342', 'M89349', 'M89351', 'M89352',
        'M89359', 'M89361', 'M89362', 'M89363', 'M89364', 'M89369', 'M89371', 'M89372', 'M89379',
        'M8938', 'M8939', 'M8940', 'M89411', 'M89412', 'M89419', 'M89421', 'M89422', 'M89429',
        'M89431', 'M89432', 'M89439', 'M89441', 'M89442', 'M89449', 'M89451', 'M89452', 'M89459',
        'M89461', 'M89462', 'M89469', 'M89471', 'M89472', 'M89479', 'M8948', 'M8949', 'M8950',
        'M89511', 'M89512', 'M89519', 'M89521', 'M89522', 'M89529', 'M89531', 'M89532', 'M89539',
        'M89541', 'M89542', 'M89549', 'M89551', 'M89552', 'M89559', 'M89561', 'M89562', 'M89569',
        'M89571', 'M89572', 'M89579', 'M8958', 'M8959', 'M8960', 'M89611', 'M89612', 'M89619',
        'M89621', 'M89622', 'M89629', 'M89631', 'M89632', 'M89639', 'M89641', 'M89642', 'M89649',
        'M89651', 'M89652', 'M89659', 'M89661', 'M89662', 'M89669', 'M89671', 'M89672', 'M89679',
        'M8968', 'M8969', 'M8970', 'M89711', 'M89712', 'M89719', 'M89721', 'M89722', 'M89729',
        'M89731', 'M89732', 'M89739', 'M89741', 'M89742', 'M89749', 'M89751', 'M89752', 'M89759',
        'M89761', 'M89762', 'M89769', 'M89771', 'M89772', 'M89779', 'M8978', 'M8979', 'M898X0',
        'M898X1', 'M898X2', 'M898X3', 'M898X4', 'M898X5', 'M898X6', 'M898X7', 'M898X8', 'M898X9',
        'M899', 'M9080', 'M90811', 'M90812', 'M90819', 'M90821', 'M90822', 'M90829', 'M90831',
        'M90832', 'M90839', 'M90841', 'M90842', 'M90849', 'M90851', 'M90852', 'M90859', 'M90861',
        'M90862', 'M90869', 'M90871', 'M90872', 'M90879', 'M9088', 'M9089', 'N10', 'N110', 'N111',
        'N118', 'N119', 'N12', 'N136', 'N151', 'N16', 'N2884', 'N2885', 'N2886', 'N3000', 'N3001',
        'N3010', 'N3011', 'N3020', 'N3021', 'N3030', 'N3031', 'N3040', 'N3041', 'N3080', 'N3081',
        'N3090', 'N3091', 'N390', 'N410', 'N411', 'N412', 'N413', 'N414', 'N418', 'N419', 'N7001',
        'N7002', 'N7003', 'N7011', 'N7012', 'N7013', 'N7091', 'N7092', 'N7093', 'N710', 'N711',
        'N719', 'N72', 'N730', 'N731', 'N732', 'N733', 'N734', 'N735', 'N736', 'N738', 'N739',
        'N74', 'N750', 'N751', 'N758', 'N759', 'N760', 'N761', 'N762', 'N763', 'N764', 'N765',
        'N766', 'N7681', 'N7689', 'N770', 'N771'
    }

    SNOMEDCT = {
        '102452004', '102453009', '102455002', '10321002', '10345003', '10351008', '105628008',
        '105629000', '105977003', '10625271000119109', '10625431000119105', '10625551000119103',
        '10625711000119105', '10628231000119100', '10628271000119102', '10628311000119102',
        '10628351000119101', '10629271000119107', '10631911000119108', '10631951000119109',
        '10632591000119103', '10632631000119103', '10633111000119105', '10633151000119106',
        '10633351000119109', '10633391000119104', '10633671000119105', '10633711000119109',
        '10633791000119100', '10633831000119106', '10633871000119109', '10633911000119107',
        '10633951000119108', '10679007', '10809006', '1082721000119101', '1082981000119100',
        '1083101000119102', '1083111000119104', '1083691000119103', '1084271000119103',
        '1086191000119101', '1086241000119101', '1088221000119108', '1088231000119106',
        '1088821000119109', '1089661000119108', '1090731000119101', '1090831000119108',
        '1091431000119103', '1092271000119106', '109242000', '109243005', '109244004', '109245003',
        '109246002', '109247006', '1092951000119106', '109327001', '109328006', '109329003',
        '109330008', '109331007', '109332000', '109362006', '109602002', '109603007', '109604001',
        '109611002', '109612009', '109631003', '109686002', '109687006', '109688001', '109689009',
        '109781001', '109782008', '109783003', '109784009', '109792000', '109802000', '109810004',
        '109811000', '10982004', '109867008', '109909008', '109910003', '1107004', '111183001',
        '111184007', '111274000', '111275004', '11134001', '111367007', '111409009', '111414008',
        '111418006', '111538005', '111806005', '111807001', '111816002', '111819009', '111839008',
        '111843007', '111900000', '111911008', '111912001', '111938001', '111939009', '11251000',
        '11338007', '11461005', '1156003', '11648002', '11840006', '11906007', '12062007',
        '12115003', '12232008', '123587001', '123588006', '123589003', '123590007', '123591006',
        '123592004', '123611003', '123613000', '12366661000119100', '12373006', '123754002',
        '123755001', '123951002', '12463005', '124691000119101', '12713001', '127217009',
        '128045006', '1282001', '128220004', '128222007', '128276007', '128277003', '128278008',
        '128279000', '128280002', '128281003', '128282005', '128711000119106', '12890007',
        '129128006', '129452008', '129458007', '129563009', '129670002', '13095005', '13125003',
        '13177009', '13272007', '13285005', '13301002', '13310005', '13386009', '13680009',
        '13731006', '13802001', '14053009', '1415005', '14248008', '14255005', '14343001',
        '14405000', '14488001', '14800001', '14948001', '15033003', '151004', '15170009',
        '1532007', '15363000', '15607007', '15628003', '15697361000119100', '15697441000119106',
        '15697481000119101', '15697521000119101', '15805002', '15865061000119102',
        '15866491000119109', '15866531000119109', '15916831000119102', '15981911000119105',
        '15981951000119106', '15981991000119101', '16005551000119105', '16005591000119100',
        '16036000', '16070004', '16119006', '16300007', '16311000119108', '16486000', '16594005',
        '17133001', '172001', '17305005', '17354003', '17357005', '17716001', '17732003',
        '17741008', '179101003', '18081009', '18099001', '181007', '186090001', '186105003',
        '186116005', '186136006', '186137002', '186138007', '186150001', '186156007', '186242002',
        '186342000', '186431008', '186537009', '186675001', '186729003', '186731007', '186825001',
        '186826000', '186833000', '186842007', '186846005', '186847001', '186850003', '186854007',
        '186861006', '186863009', '186867005', '186868000', '186875004', '186877007', '186878002',
        '186899004', '186903006', '186915005', '186931002', '186939000', '186946009', '187017007',
        '187042003', '188463006', '18900005', '189312004', '192008', '19206003', '19213003',
        '19240003', '192647003', '19272000', '19284003', '19290004', '19360008', '19372002',
        '193786000', '194005002', '194281003', '194282005', '194286008', '194287004', '194288009',
        '194289001', '194290005', '194339007', '19457002', '19471005', '194907008', '194947001',
        '195655000', '195656004', '195657008', '195658003', '195659006', '195660001', '195662009',
        '195666007', '195667003', '195668008', '195669000', '195670004', '195671000', '195672007',
        '195673002', '195676005', '195677001', '195717003', '195719000', '195720006', '195721005',
        '195722003', '195725001', '195726000', '195727009', '195728004', '195729007', '195756009',
        '195798007', '195811008', '195812001', '195813006', '195836002', '195878008', '195881003',
        '195886008', '195888009', '195889001', '195896004', '195902009', '195920000', '196067009',
        '196107009', '196108004', '196109007', '196112005', '196339009', '196341005', '196538002',
        '197162007', '197163002', '197172005', '197176008', '197177004', '197178009', '197179001',
        '197180003', '197305002', '197324004', '197325003', '197326002', '197327006', '197328001',
        '197329009', '197330004', '197347003', '197348008', '197757004', '197760006', '197761005',
        '197762003', '197763008', '197764002', '197768004', '197769007', '197770008', '197834003',
        '197837005', '197845000', '197848003', '197849006', '197850006', '197853008', '197926005',
        '197927001', '197928006', '197963001', '197964007', '197965008', '197966009', '197967000',
        '197968005', '198130006', '198133008', '198135001', '198136000', '198137009', '198138004',
        '198141008', '198142001', '198143006', '198156004', '198159006', '198160001', '198161002',
        '198175009', '198176005', '198179003', '198180000', '198182008', '198183003', '198184009',
        '198185005', '198186006', '198188007', '198189004', '198199009', '198203009', '198206001',
        '198212006', '198216009', '198217000', '198218005', '198219002', '198220008', '198227006',
        '198230004', '198231000', '198235009', '198236005', '198241002', '198242009', '198824009',
        '19905009', '199111004', '199154009', '199156006', '199157002', '199158007', '199159004',
        '199161008', '199163006', '199164000', '199165004', '199166003', '199205008', '199206009',
        '200181000', '200182007', '200185009', '200187001', '20025003', '200628009', '200630006',
        '200638004', '200645004', '200648002', '200649005', '200650005', '200651009', '200652002',
        '200655000', '200656004', '200657008', '200658003', '200659006', '200660001', '200661002',
        '200662009', '200663004', '200666007', '200667003', '200668008', '200669000', '200670004',
        '200674008', '200676005', '200678006', '200679003', '200680000', '200681001', '200682008',
        '200686006', '200687002', '200697006', '200698001', '200699009', '200700005', '200704001',
        '200705000', '200706004', '200707008', '200708003', '200709006', '200718008', '200722003',
        '200744008', '200751004', '200755008', '202933002', '203157008', '203158003', '203159006',
        '203193005', '203194004', '203195003', '203196002', '203197006', '203198001', '203199009',
        '203200007', '203201006', '203202004', '203221007', '203222000', '203226002', '203233002',
        '203241002', '203256006', '203257002', '203258007', '203259004', '203260009', '203296008',
        '203297004', '203298009', '203299001', '203300009', '20547008', '205717001', '206358003',
        '20735004', '207615004', '208545005', '20932005', '20943002', '21060003', '21061004',
        '21092002', '21186006', '212438008', '21523006', '21711003', '21780009', '21955004',
        '220145006', '222008', '22386003', '22399000', '22475001', '22557000', '22754005',
        '22775002', '230150008', '230152000', '230182006', '230216007', '230402000', '230563005',
        '230605007', '230735006', '23160005', '23166004', '231796003', '231802001', '231858009',
        '232212002', '232214001', '232215000', '232251007', '232260004', '232268006', '232269003',
        '232270002', '232271003', '232313005', '232314004', '232363000', '232367004', '232391008',
        '232393006', '232394000', '232395004', '232397007', '232399005', '232400003', '232417005',
        '232420002', '232432003', '232433008', '23259007', '233598009', '233599001', '233600003',
        '233601004', '233604007', '233606009', '233607000', '233608005', '233609002', '233613009',
        '233617005', '233618000', '233620002', '233621003', '233622005', '233623000', '233624006',
        '233625007', '233713004', '233728004', '233730002', '233731003', '233785003', '233849007',
        '234017002', '234091000', '234093002', '234096005', '23502006', '235032001', '235062007',
        '235064008', '235065009', '23550005', '235726002', '235747003', '235748008', '235749000',
        '235774002', '235795007', '235861001', '235863003', '235984009', '235994004', '235995003',
        '235996002', '235997006', '236063005', '236066002', '236302005', '236373001', '236376009',
        '236377000', '236378005', '236379002', '23640001', '236620008', '236622000', '236623005',
        '236624004', '236625003', '236626002', '236627006', '236628001', '236629009', '236630004',
        '236672003', '236673008', '236682002', '236683007', '236687008', '236689006', '236702008',
        '236703003', '236704009', '236706006', '236766009', '236772009', '237037006', '237038001',
        '237039009', '237040006', '237042003', '237043008', '237044002', '237045001', '237046000',
        '237051006', '237069002', '237083000', '237084006', '237085007', '237091009', '237093007',
        '237094001', '237095000', '237096004', '237097008', '237103001', '237104007', '237106009',
        '237124006', '237446005', '237447001', '23754003', '238374001', '238375000', '238376004',
        '238377008', '238381008', '238386003', '238387007', '238388002', '238391002', '238395006',
        '238396007', '238398008', '238401006', '238404003', '238405002', '238406001', '238419002',
        '2385003', '23884004', '238921004', '238931006', '238985006', '2390000', '239162003',
        '2396006', '23975003', '240039005', '240349003', '240350003', '240351004', '240352006',
        '240353001', '240354007', '240355008', '240356009', '240357000', '240365002', '240367005',
        '240368000', '240369008', '240370009', '240371008', '240372001', '240374000', '240375004',
        '240414006', '240444009', '240452007', '240453002', '240455009', '240456005', '240457001',
        '240458006', '240547000', '240552005', '240553000', '240554006', '240555007', '240556008',
        '240557004', '240558009', '240560006', '240562003', '240563008', '240564002', '240565001',
        '240566000', '240567009', '240568004', '240569007', '240571007', '240572000', '240573005',
        '240574004', '240575003', '240576002', '240577006', '240578001', '240579009', '240581006',
        '240582004', '240584003', '240589008', '240602008', '240603003', '240604009', '240635003',
        '240668005', '240669002', '240670001', '240671002', '240721007', '240736005', '240780005',
        '240802005', '24232008', '24288004', '24347001', '24520005', '24557004', '246956006',
        '247517004', '24789006', '24868007', '249458000', '249463001', '251331003', '2523007',
        '25764005', '26039008', '26135000', '262461007', '26249004', '26330000', '26466000',
        '26535009', '266071000', '266077001', '266078006', '266079003', '266123003', '266125005',
        '266126006', '266127002', '266128007', '266130009', '266133006', '266136003', '266138002',
        '266160004', '266162007', '266337001', '266350000', '266439004', '266463007', '26650005',
        '266564004', '266581008', '267759006', '267777001', '267778006', '267779003', '267780000',
        '267783003', '26883000', '270490007', '27174002', '272006008', '272262003', '27278006',
        '274080003', '274081004', '274109003', '27420004', '27438001', '27460003', '275376007',
        '275412000', '275433009', '275441009', '275495004', '27561001', '27648007', '276677001',
        '276679003', '276700005', '27681008', '276877003', '27767004', '277678003', '277869007',
        '27787003', '278037002', '278038007', '278068003', '27836007', '278480000', '278481001',
        '278486006', '278516003', '27858009', '27916005', '279499002', '280483007', '280486004',
        '281801000009108', '28198007', '283876006', '283877002', '28438004', '28572009',
        '28593007', '28653000', '286870008', '286977005', '286985001', '287000004', '287001000',
        '287002007', '28709001', '28783002', '289510007', '29608009', '297139009', '29864006',
        '29909004', '30080002', '300999006', '301000005', '301001009', '301002002', '301003007',
        '301004001', '301010001', '301011002', '301012009', '301013004', '30168008', '301706005',
        '301710008', '301711007', '301769001', '301771001', '301802001', '301824001', '301990003',
        '30239003', '302813001', '302911003', '3038009', '30406004', '30493003', '30584002',
        '3059002', '30635002', '307230004', '307231000', '307310000', '307423008', '307424002',
        '307425001', '307426000', '307534009', '30800001', '30806007', '308119005', '30833006',
        '308660004', '308661000', '308906005', '309083007', '309254003', '31015008', '3110003',
        '31137003', '312088007', '312099009', '312108008', '312109000', '312124009', '31218002',
        '312342009', '312371005', '312400008', '312422001', '312934004', '312955002', '31302006',
        '31309002', '313352002', '31354001', '31412003', '314213003', '314630009', '31474007',
        '314840009', '314978007', '315596001', '315597005', '31561003', '315826004', '316841006',
        '31999004', '32021005', '32038009', '32141002', '32263004', '32286006', '32298001',
        '32527003', '32580004', '32582007', '32636009', '32701000', '32735002', '32801008',
        '328488009', '32923006', '329489009', '33028007', '33134003', '3321001', '33261009',
        '333501000119103', '335846001', '33655002', '33781009', '339111000119109', '33924006',
        '33937009', '34020007', '34242002', '344861000119102', '34543006', '34790005',
        '348111000119104', '348561000119109', '349001000119106', '349011000119109',
        '349021000119102', '349031000119104', '349041000119108', '349051000119105',
        '349141000119107', '34997001', '3502005', '35037009', '3507004', '35168006', '35246005',
        '35255008', '35339003', '35377009', '35526001', '35542008', '35585004', '35708002',
        '35742006', '35876006', '3589003', '35923002', '35958000', '359613008', '359662008',
        '35974005', '359749002', '359751003', '360425009', '360595002', '36139001', '36188001',
        '36276008', '36281004', '3633001', '363746003', '36529003', '36616006', '36689008',
        '366941000119107', '36699003', '367171000119100', '36742000', '367504009',
        '367661000119102', '367671000119108', '36789003', '368371000119102', '36857002',
        '368971000119101', '368991000119100', '369001000119100', '369011000119102', '37028008',
        '370518000', '37098000', '371061003', '371237000', '371318006', '37133005', '371423007',
        '37223007', '373135009', '373611003', '37430004', '37610005', '37649008', '37754005',
        '37830006', '37936001', '37948003', '38099005', '38176009', '38217004', '385093006',
        '38523005', '38541002', '386034005', '38699009', '387665005', '387681000', '387682007',
        '387754006', '38822007', '388602007', '388604008', '38898003', '388982007', '388983002',
        '38961000', '38976008', '39085002', '390897008', '39120007', '39172002', '39341005',
        '396284006', '396285007', '396286008', '39747007', '397810006', '398319002', '398570005',
        '399095008', '399102002', '399183005', '3999002', '40055000', '4009004', '40113007',
        '40149008', '4016003', '4022007', '402201001', '402314003', '402375009', '402437008',
        '402715000', '402797009', '402825002', '402828000', '402890001', '402896007', '402927009',
        '402928004', '402929007', '402930002', '402931003', '402935007', '402939001', '402940004',
        '402941000', '402942007', '402943002', '402944008', '402945009', '402946005', '402947001',
        '402949003', '402950003', '402951004', '402957000', '402958005', '403475002', '403477005',
        '403478000', '403479008', '403480006', '403482003', '403565003', '403702001', '403961004',
        '404174000', '40458008', '404907009', '405547004', '405548009', '405554005', '405562002',
        '405635002', '405950009', '405951008', '40635000', '406563003', '406581000', '406617004',
        '406618009', '407523005', '40766000', '407671000', '4082005', '408386002', '408679000',
        '408680002', '408682005', '409648008', '409662001', '409664000', '409665004', '409778008',
        '410470003', '410472006', '410473001', '410474007', '410475008', '410478005', '41174002',
        '41207000', '41269000', '41381004', '414529006', '414530001', '415125002', '41545003',
        '415724006', '41582007', '415822001', '416205001', '41700004', '417484006', '41789000',
        '418103007', '41910004', '419468003', '41954005', '419760006', '420544002', '420687005',
        '420787001', '420910002', '421047005', '421224000', '421454008', '421508002', '421671002',
        '422747000', '4232007', '423322005', '42338000', '423590009', '424551004', '42522007',
        '425464007', '425548001', '425562008', '425996009', '426121003', '426135001', '426137009',
        '426165006', '426247003', '426507006', '426637005', '426696003', '42680007', '426836003',
        '426874006', '427307004', '42746002', '427537009', '42770003', '427786008', '427787004',
        '427788009', '427909005', '428015005', '428091000', '428193004', '428230005', '428252001',
        '428780000', '428874003', '429437003', '429553003', '429767005', '430065009', '430395005',
        '430402003', '430404002', '430616003', '43114002', '431189009', '431231008', '431238002',
        '431261000', '431262007', '431308006', '431309003', '431467003', '4316006', '431709001',
        '431737008', '4324001', '432481004', '432992007', '435141000124102', '435201000124109',
        '43522000', '4359001', '43636000', '43830008', '43878008', '441590008', '441658007',
        '441942006', '442094008', '442506007', '443769009', '44412000', '444150000', '44428005',
        '444646006', '444760002', '444820005', '444834005', '445063003', '445096001', '445130008',
        '445152004', '445323009', '445470006', '445506004', '44568006', '445918001', '446122002',
        '446292002', '446328009', '446543007', '446642005', '446672004', '446752000', '446754004',
        '446755003', '446756002', '446926000', '446988001', '447004005', '447044003', '447045002',
        '447102007', '447222001', '447282003', '447353001', '447354007', '447372001', '447386002',
        '447399004', '447402003', '44743006', '4483005', '44897000', '449671007', '449702005',
        '449710006', '449711005', '449717009', '449825003', '45022008', '450421000124105',
        '45058001', '450761000124106', '450991000124101', '45312009', '45377007', '45629003',
        '45816000', '46235002', '46442004', '46536000', '46689006', '46699001', '46799006',
        '46876003', '46970008', '47132003', '47493003', '47698002', '47756005', '47941007',
        '48036004', '48142003', '48153009', '48277006', '48278001', '4834000', '48503007',
        '48573006', '48631008', '48982009', '49249007', '49258000', '49298003', '49308005',
        '49558004', '49810002', '49908003', '49923008', '5028002', '50528008', '50675000',
        '5075002', '50804000', '5085001', '5093001', '50970007', '51030006', '51036000',
        '51152000', '51209006', '51211002', '51254007', '51530003', '51613008', '51707007',
        '51928006', '51960003', '52123000', '52190008', '52404001', '52414005', '52441000',
        '52478002', '52979002', '53084003', '53098006', '53116008', '53200002', '53277000',
        '53396004', '53502009', '53529004', '53664003', '53991003', '54026009', '54069001',
        '54084005', '54138003', '54274001', '54275000', '54287007', '54389007', '54672007',
        '54825009', '55023005', '55069005', '55083007', '55184003', '55399009', '55551005',
        '55679008', '55768006', '56118002', '56321006', '56351000', '56644003', '56728002',
        '56937005', '57027007', '57468008', '57540006', '57593007', '57702005', '57725006',
        '58031004', '58056005', '58196009', '58227000', '58392004', '58763001', '58890000',
        '58945008', '58949002', '58964002', '59211000', '59221008', '59233003', '59307008',
        '59475000', '59530001', '59532009', '59707005', '59721007', '59883002', '59934002',
        '59967003', '60130002', '60165002', '6033008', '60335002', '60350006', '60485005',
        '60528006', '60540006', '60777000', '60867007', '60893000', '60967006', '61048000',
        '6136003', '61500009', '61612001', '61711004', '61884008', '6212009', '62199007',
        '62207008', '62224002', '62248006', '62394006', '6267005', '62819009', '62837005',
        '6284004', '62861003', '63064000', '63140003', '63144007', '63302006', '63375009',
        '63475008', '63530007', '63627007', '63650001', '63751007', '63870005', '63922003',
        '64102008', '64150007', '64366002', '64369009', '64375000', '64479007', '64532005',
        '64576003', '64667001', '64703005', '64740002', '64880000', '64917006', '64956000',
        '65049003', '65095005', '65127006', '65295003', '65363002', '65967008', '65974003',
        '65984002', '66011008', '66160001', '66281009', '66429007', '66622006', '66887000',
        '66898004', '66918004', '67125004', '67167008', '67277002', '67391006', '67525007',
        '67624004', '67667007', '67685000', '67832005', '67878002', '67915005', '6815003',
        '68226007', '68272006', '68389001', '68409003', '68566005', '68640004', '68764005',
        '68843000', '6887003', '69430001', '69588003', '69595007', '69643006', '69651009',
        '69810009', '70036007', '700372006', '70120007', '702715008', '70385007', '7063008',
        '70637004', '7066000', '70718000', '70759006', '7079009', '70880006', '71085009',
        '71255007', '713084008', '713251003', '71332006', '713453003', '713454009', '713544008',
        '713546005', '713570009', '7138005', '713886006', '71392009', '715065007', '715507005',
        '716860005', '717231003', '71746008', '718373005', '71906005', '71926009', '72083004',
        '72102005', '72204002', '72222004', '72249004', '72369006', '7253006', '72605008',
        '72656004', '7272006', '72815004', '72899006', '72934000', '72940007', '73237007',
        '7329003', '73345000', '73414003', '73452002', '736004', '73806001', '73908004',
        '73962000', '73970005', '7415003', '74181004', '74372003', '74445007', '7448003',
        '74578003', '74598008', '74945001', '75100008', '75119003', '75299005', '75375008',
        '7548000', '75498004', '75530006', '75548002', '75570004', '75585005', '75632007',
        '75817003', '75947000', '75993002', '76035004', '76047005', '76090006', '76126009',
        '76151005', '76272004', '76366001', '7640004', '76549002', '76623002', '76653009',
        '7678002', '76782002', '76802005', '77028001', '77054009', '77106003', '77116006',
        '77360001', '77863005', '77919000', '77939001', '78182002', '78420004', '78620007',
        '78623009', '78973009', '78996009', '7910003', '79216009', '79411002', '79560005',
        '80388004', '80437003', '80600003', '80604007', '80640009', '80645004', '80770009',
        '81020007', '8107007', '81096007', '81125004', '81164001', '81339006', '81521003',
        '81598001', '82053000', '82126001', '82127005', '82323002', '82355002', '8258000',
        '82670009', '827006', '82770004', '82930004', '82959004', '83271005', '83412009',
        '83774001', '83883001', '8414002', '84194006', '84233008', '84261000119106', '84414000',
        '84490005', '84681008', '84724007', '84753008', '84889008', '85051008', '8519009',
        '85224001', '8549006', '85495007', '8555001', '85791004', '85857008', '85884009',
        '85904008', '86028001', '86070006', '86279000', '8628002', '86443005', '86479002',
        '86615009', '86709000', '87073000', '87117006', '8725005', '87282003', '87318008',
        '87665008', '87696004', '8771003', '87728001', '8776008', '87815001', '88027004',
        '88157006', '88220006', '88361008', '8838005', '88547002', '88813005', '88850006',
        '88943008', '88981003', '8912009', '89194009', '8954007', '89637003', '89933001',
        '90206003', '90271007', '9091006', '90979004', '91038008', '91155009', '91195006',
        '91541006', '91554004', '91669008', '91862002', '9241004', '9516007', '95220008',
        '9557000', '95593001', '95679004', '95746006', '95806007', '95811009', '95886009',
        '95889002', '96171000119103', '9713002', '987007', '9941009'
    }


class UpperRespiratoryInfection(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.102.12.1022'
    VALUE_SET_NAME = 'Upper Respiratory Infection'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'J00', 'J060', 'J069'}

    SNOMEDCT = {
        '195708003', '281794004', '54150009', '54398005', '55355000', '78337007', '82272006'
    }


class Diabetes(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1001'
    VALUE_SET_NAME = 'Diabetes'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'E1010', 'E1011', 'E1021', 'E1022', 'E1029', 'E10311', 'E10319', 'E10321', 'E103211',
        'E103212', 'E103213', 'E103219', 'E10329', 'E103291', 'E103292', 'E103293', 'E103299',
        'E10331', 'E103311', 'E103312', 'E103313', 'E103319', 'E10339', 'E103391', 'E103392',
        'E103393', 'E103399', 'E10341', 'E103411', 'E103412', 'E103413', 'E103419', 'E10349',
        'E103491', 'E103492', 'E103493', 'E103499', 'E10351', 'E103511', 'E103512', 'E103513',
        'E103519', 'E103521', 'E103522', 'E103523', 'E103529', 'E103531', 'E103532', 'E103533',
        'E103539', 'E103541', 'E103542', 'E103543', 'E103549', 'E103551', 'E103552', 'E103553',
        'E103559', 'E10359', 'E103591', 'E103592', 'E103593', 'E103599', 'E1036', 'E1037X1',
        'E1037X2', 'E1037X3', 'E1037X9', 'E1039', 'E1040', 'E1041', 'E1042', 'E1043', 'E1044',
        'E1049', 'E1051', 'E1052', 'E1059', 'E10610', 'E10618', 'E10620', 'E10621', 'E10622',
        'E10628', 'E10630', 'E10638', 'E10641', 'E10649', 'E1065', 'E1069', 'E108', 'E109',
        'E1100', 'E1101', 'E1121', 'E1122', 'E1129', 'E11311', 'E11319', 'E11321', 'E113211',
        'E113212', 'E113213', 'E113219', 'E11329', 'E113291', 'E113292', 'E113293', 'E113299',
        'E11331', 'E113311', 'E113312', 'E113313', 'E113319', 'E11339', 'E113391', 'E113392',
        'E113393', 'E113399', 'E11341', 'E113411', 'E113412', 'E113413', 'E113419', 'E11349',
        'E113491', 'E113492', 'E113493', 'E113499', 'E11351', 'E113511', 'E113512', 'E113513',
        'E113519', 'E113521', 'E113522', 'E113523', 'E113529', 'E113531', 'E113532', 'E113533',
        'E113539', 'E113541', 'E113542', 'E113543', 'E113549', 'E113551', 'E113552', 'E113553',
        'E113559', 'E11359', 'E113591', 'E113592', 'E113593', 'E113599', 'E1136', 'E1137X1',
        'E1137X2', 'E1137X3', 'E1137X9', 'E1139', 'E1140', 'E1141', 'E1142', 'E1143', 'E1144',
        'E1149', 'E1151', 'E1152', 'E1159', 'E11610', 'E11618', 'E11620', 'E11621', 'E11622',
        'E11628', 'E11630', 'E11638', 'E11641', 'E11649', 'E1165', 'E1169', 'E118', 'E119',
        'E1300', 'E1301', 'E1310', 'E1311', 'E1321', 'E1322', 'E1329', 'E13311', 'E13319',
        'E13321', 'E133211', 'E133212', 'E133213', 'E133219', 'E13329', 'E133291', 'E133292',
        'E133293', 'E133299', 'E13331', 'E133311', 'E133312', 'E133313', 'E133319', 'E13339',
        'E133391', 'E133392', 'E133393', 'E133399', 'E13341', 'E133411', 'E133412', 'E133413',
        'E133419', 'E13349', 'E133491', 'E133492', 'E133493', 'E133499', 'E13351', 'E133511',
        'E133512', 'E133513', 'E133519', 'E133521', 'E133522', 'E133523', 'E133529', 'E133531',
        'E133532', 'E133533', 'E133539', 'E133541', 'E133542', 'E133543', 'E133549', 'E133551',
        'E133552', 'E133553', 'E133559', 'E13359', 'E133591', 'E133592', 'E133593', 'E133599',
        'E1336', 'E1337X1', 'E1337X2', 'E1337X3', 'E1337X9', 'E1339', 'E1340', 'E1341', 'E1342',
        'E1343', 'E1344', 'E1349', 'E1351', 'E1352', 'E1359', 'E13610', 'E13618', 'E13620',
        'E13621', 'E13622', 'E13628', 'E13630', 'E13638', 'E13641', 'E13649', 'E1365', 'E1369',
        'E138', 'E139', 'O24011', 'O24012', 'O24013', 'O24019', 'O2402', 'O2403', 'O24111',
        'O24112', 'O24113', 'O24119', 'O2412', 'O2413', 'O24311', 'O24312', 'O24313', 'O24319',
        'O2432', 'O2433', 'O24811', 'O24812', 'O24813', 'O24819', 'O2482', 'O2483'
    }

    ICD9CM = {
        '25000', '25001', '25002', '25003', '25010', '25011', '25012', '25013', '25020', '25021',
        '25022', '25023', '25030', '25031', '25032', '25033', '25040', '25041', '25042', '25043',
        '25050', '25051', '25052', '25053', '25060', '25061', '25062', '25063', '25070', '25071',
        '25072', '25073', '25080', '25081', '25082', '25083', '25090', '25091', '25092', '25093',
        '3572', '36201', '36202', '36203', '36204', '36205', '36206', '36207', '36641', '64800',
        '64801', '64802', '64803', '64804'
    }

    SNOMEDCT = {
        '105401000119101', '106281000119103', '10754881000119104', '111552007', '1481000119100',
        '190330002', '190331003', '190368000', '190369008', '190372001', '190389009', '190390000',
        '190406000', '190407009', '190410002', '190411003', '190412005', '199223000', '199225007',
        '199226008', '199227004', '199228009', '199229001', '199230006', '199231005', '23045005',
        '237599002', '237600004', '237618001', '237627000', '28032008', '31321000119102',
        '313435000', '313436004', '314771006', '314772004', '314893005', '314894004', '314902007',
        '314903002', '314904008', '359642000', '426705001', '427089005', '42954008', '44054006',
        '445260006', '46635009', '4783006', '51002006', '57886004', '59079001', '5969009',
        '609563008', '609564002', '609566000', '609567009', '609568004', '609569007', '709147009',
        '716362006', '71791000119104', '75524006', '75682002', '76751001', '81531005', '91352004',
        '9859006'
    }


class VisualExamOfFoot(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1013'
    VALUE_SET_NAME = 'Visual Exam of Foot'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'401191002'}


class SensoryExamOfFoot(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1014'
    VALUE_SET_NAME = 'Sensory Exam of Foot'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'134388005'}


class PulseExamOfFoot(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.103.12.1015'
    VALUE_SET_NAME = 'Pulse Exam of Foot'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'91161007'}


class AcuteMyocardialInfarction(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1001'
    VALUE_SET_NAME = 'Acute Myocardial Infarction'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'I2101', 'I2102', 'I2109', 'I2111', 'I2119', 'I2121', 'I2129', 'I213', 'I214'}

    SNOMEDCT = {
        '10273003', '15990001', '17531000119105', '194802003', '194809007', '23311000119105',
        '233825009', '233826005', '233827001', '233828006', '233829003', '233830008', '233831007',
        '233832000', '233833005', '233834004', '233835003', '233836002', '233837006', '233838001',
        '282006', '285981000119103', '285991000119100', '30277009', '304914007', '307140009',
        '401303003', '401314000', '52035003', '54329005', '57054005', '58612006', '59063002',
        '62695002', '64627002', '65547006', '70211005', '70422006', '70998009', '73795002',
        '76593002', '79009004'
    }


class CoronaryArteryBypassGraft(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1002'
    VALUE_SET_NAME = 'Coronary Artery Bypass Graft'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '33510', '33511', '33512', '33513', '33514', '33516', '33517', '33518', '33519', '33521',
        '33522', '33523', '33533', '33534', '33535', '33536'
    }

    HCPCS = {'S2205', 'S2206', 'S2207', 'S2208', 'S2209'}

    SNOMEDCT = {
        '10190003', '10326007', '119564002', '119565001', '14323007', '175007008', '175008003',
        '175009006', '175011002', '175021005', '175022003', '175024002', '175025001', '175026000',
        '175029007', '175030002', '175031003', '175032005', '175033000', '175045009', '175047001',
        '175048006', '175050003', '232717009', '232719007', '232720001', '232721002', '232722009',
        '232723004', '232724005', '265481001', '275215001', '275216000', '275252001', '275253006',
        '29819009', '30670000', '309814006', '3546002', '359597003', '359601003', '39202005',
        '39724006', '414088005', '418551006', '418824004', '419132001', '48431000', '67166004',
        '74371005', '82247006', '90487008'
    }


class IschemicVascularDisease(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1003'
    VALUE_SET_NAME = 'Ischemic Vascular Disease'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'I200', 'I208', 'I209', 'I240', 'I248', 'I249', 'I2510', 'I25110', 'I25111', 'I25118',
        'I25119', 'I255', 'I256', 'I25700', 'I25701', 'I25708', 'I25709', 'I25710', 'I25711',
        'I25718', 'I25719', 'I25720', 'I25721', 'I25728', 'I25729', 'I25730', 'I25731', 'I25738',
        'I25739', 'I25750', 'I25751', 'I25758', 'I25759', 'I25760', 'I25761', 'I25768', 'I25769',
        'I25790', 'I25791', 'I25798', 'I25799', 'I25810', 'I25811', 'I25812', 'I2582', 'I2583',
        'I2584', 'I2589', 'I259', 'I6320', 'I63211', 'I63212', 'I63219', 'I6322', 'I63231',
        'I63232', 'I63239', 'I6329', 'I6350', 'I63511', 'I63512', 'I63519', 'I63521', 'I63522',
        'I63529', 'I63531', 'I63532', 'I63539', 'I63541', 'I63542', 'I63549', 'I6359', 'I6501',
        'I6502', 'I6503', 'I6509', 'I651', 'I6521', 'I6522', 'I6523', 'I6529', 'I658', 'I659',
        'I6601', 'I6602', 'I6603', 'I6609', 'I6611', 'I6612', 'I6613', 'I6619', 'I6621', 'I6622',
        'I6623', 'I6629', 'I663', 'I668', 'I669', 'I672', 'I701', 'I70201', 'I70202', 'I70203',
        'I70208', 'I70209', 'I70211', 'I70212', 'I70213', 'I70218', 'I70219', 'I70221', 'I70222',
        'I70223', 'I70228', 'I70229', 'I70231', 'I70232', 'I70233', 'I70234', 'I70235', 'I70238',
        'I70239', 'I70241', 'I70242', 'I70243', 'I70244', 'I70245', 'I70248', 'I70249', 'I7025',
        'I70261', 'I70262', 'I70263', 'I70268', 'I70269', 'I70291', 'I70292', 'I70293', 'I70298',
        'I70299', 'I70301', 'I70302', 'I70303', 'I70308', 'I70309', 'I70311', 'I70312', 'I70313',
        'I70318', 'I70319', 'I70321', 'I70322', 'I70323', 'I70328', 'I70329', 'I70331', 'I70332',
        'I70333', 'I70334', 'I70335', 'I70338', 'I70339', 'I70341', 'I70342', 'I70343', 'I70344',
        'I70345', 'I70348', 'I70349', 'I7035', 'I70361', 'I70362', 'I70363', 'I70368', 'I70369',
        'I70391', 'I70392', 'I70393', 'I70398', 'I70399', 'I70401', 'I70402', 'I70403', 'I70408',
        'I70409', 'I70411', 'I70412', 'I70413', 'I70418', 'I70419', 'I70421', 'I70422', 'I70423',
        'I70428', 'I70429', 'I70431', 'I70432', 'I70433', 'I70434', 'I70435', 'I70438', 'I70439',
        'I70441', 'I70442', 'I70443', 'I70444', 'I70445', 'I70448', 'I70449', 'I7045', 'I70461',
        'I70462', 'I70463', 'I70468', 'I70469', 'I70491', 'I70492', 'I70493', 'I70498', 'I70499',
        'I70501', 'I70502', 'I70503', 'I70508', 'I70509', 'I70511', 'I70512', 'I70513', 'I70518',
        'I70519', 'I70521', 'I70522', 'I70523', 'I70528', 'I70529', 'I70531', 'I70532', 'I70533',
        'I70534', 'I70535', 'I70538', 'I70539', 'I70541', 'I70542', 'I70543', 'I70544', 'I70545',
        'I70548', 'I70549', 'I7055', 'I70561', 'I70562', 'I70563', 'I70568', 'I70569', 'I70591',
        'I70592', 'I70593', 'I70598', 'I70599', 'I70601', 'I70602', 'I70603', 'I70608', 'I70609',
        'I70611', 'I70612', 'I70613', 'I70618', 'I70619', 'I70621', 'I70622', 'I70623', 'I70628',
        'I70629', 'I70631', 'I70632', 'I70633', 'I70634', 'I70635', 'I70638', 'I70639', 'I70641',
        'I70642', 'I70643', 'I70644', 'I70645', 'I70648', 'I70649', 'I7065', 'I70661', 'I70662',
        'I70663', 'I70668', 'I70669', 'I70691', 'I70692', 'I70693', 'I70698', 'I70699', 'I70701',
        'I70702', 'I70703', 'I70708', 'I70709', 'I70711', 'I70712', 'I70713', 'I70718', 'I70719',
        'I70721', 'I70722', 'I70723', 'I70728', 'I70729', 'I70731', 'I70732', 'I70733', 'I70734',
        'I70735', 'I70738', 'I70739', 'I70741', 'I70742', 'I70743', 'I70744', 'I70745', 'I70748',
        'I70749', 'I7075', 'I70761', 'I70762', 'I70763', 'I70768', 'I70769', 'I70791', 'I70792',
        'I70793', 'I70798', 'I70799', 'I7092', 'I75011', 'I75012', 'I75013', 'I75019', 'I75021',
        'I75022', 'I75023', 'I75029', 'I7581', 'I7589'
    }

    ICD9CM = {
        '4110', '4111', '41181', '41189', '4130', '4139', '41400', '41401', '41402', '41403',
        '41404', '41405', '41406', '41407', '4142', '4143', '4144', '4148', '4149', '4292',
        '43300', '43301', '43310', '43311', '43320', '43321', '43330', '43331', '43380', '43381',
        '43390', '43391', '43400', '43401', '43410', '43411', '43490', '43491', '4370', '4400',
        '4401', '44020', '44021', '44022', '44023', '44024', '44029', '44030', '44031', '44032',
        '4404', '4408', '4409', '44401', '44409', '44501', '44502', '44581', '44589'
    }

    SNOMEDCT = {
        '1055001', '109381003', '111291001', '111296006', '111298007', '111299004', '123641001',
        '123642008', '129573006', '145891000119104', '14977000', '149821000119103',
        '1641000119107', '19057007', '194823009', '194828000', '194842008', '194843003',
        '194849004', '195182007', '195183002', '195185009', '195186005', '195189003', '195190007',
        '195200006', '195206000', '195230003', '195231004', '195232006', '195233001', '195234007',
        '195235008', '195236009', '195254008', '195317001', '195318006', '195319003', '195320009',
        '195321008', '195323006', '195324000', '195325004', '195326003', '195327007', '195335005',
        '195336006', '195337002', '195340002', '195341003', '195342005', '195343000', '20059004',
        '21000119103', '21470009', '21631000119105', '225566008', '230692004', '230693009',
        '230694003', '230695002', '230698000', '230699008', '230700009', '230701008', '230702001',
        '230703006', '230704000', '230706003', '230707007', '230708002', '230716006', '233817007',
        '233819005', '233821000', '233823002', '233844002', '233955003', '233956002', '233958001',
        '233959009', '233960004', '233961000', '233962007', '233964008', '233970002', '233972005',
        '233973000', '233974006', '236120009', '23687008', '251024009', '25106000', '266253001',
        '266254007', '266262004', '266263009', '26900001', '274101000', '276219001', '280871000',
        '281091000', '284871000119105', '284881000119108', '285141000119106', '285151000119108',
        '285161000119105', '285171000119104', '285191000119103', '285201000119100', '286959000',
        '287731003', '28790007', '297136002', '297138001', '297141005', '29899005', '300917007',
        '300920004', '300995000', '301755001', '302728008', '302904002', '302910002', '302930003',
        '307363008', '307406004', '307407008', '307408003', '307409006', '307766002', '307767006',
        '312375001', '312378004', '312822006', '314116003', '315025001', '315348000', '35928006',
        '361132001', '361133006', '363340006', '371039008', '371041009', '371803003', '371804009',
        '371805005', '371806006', '371807002', '371808007', '371809004', '371810009', '371811008',
        '371812001', '37943007', '394659003', '39823006', '40276003', '402861007', '408546009',
        '408665008', '413102000', '41334000', '413439005', '413444003', '413552002', '413758000',
        '413838009', '413844008', '414545008', '414795007', '420006002', '425527003', '426107000',
        '426651005', '427296003', '427567003', '428196007', '428507003', '429245005', '429559004',
        '429673002', '429811000124106', '429821000124103', '429831000124100', '429841000124105',
        '429851000124107', '429861000124109', '430721000124101', '430731000124103',
        '430781000124102', '430831000124106', '430841000124101', '430851000124104',
        '430861000124102', '431391000124106', '431401000124108', '431411000124106',
        '431421000124103', '431431000124100', '431466007', '432083006', '432504007',
        '433821000124102', '433891000124100', '433901000124101', '433911000124103',
        '433931000124109', '433941000124104', '433951000124102', '433961000124100',
        '434151000124101', '434821000124104', '434831000124101', '434881000124100',
        '434891000124102', '434951000124104', '434961000124102', '434991000124105',
        '435271000124103', '435281000124100', '436021000124100', '436031000124102',
        '436041000124107', '436781000124104', '437911000124106', '441574008', '442224005',
        '442240008', '442421004', '442439008', '442693003', '442701004', '442735001', '443502000',
        '443971004', '444855007', '444856008', '446712002', '45281005', '4557003', '48601002',
        '49176002', '50808002', '51274000', '51677000', '52674009', '53741008', '5431000124100',
        '5441000124105', '5451000124107', '54519002', '5461000124109', '54687002', '5534004',
        '55382008', '5581000124100', '5601000124105', '57357009', '59021001', '59062007',
        '60989005', '61490001', '63739005', '64586002', '64775002', '65084004', '65198009',
        '66189004', '6661000119101', '67682002', '67992007', '69742007', '71444005', '72092001',
        '73192008', '75543006', '791000119109', '8001000119106', '80383008', '80606009',
        '81817003', '85284003', '87343002', '88174006', '89323001', '90520006', '92517006',
        '95458005', '95459002', '95580006', '9901000119100', '99451000119105'
    }


class PercutaneousCoronaryInterventions(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1010'
    VALUE_SET_NAME = 'Percutaneous Coronary Interventions'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'92920', '92924', '92928', '92933', '92937', '92941', '92943'}

    HCPCS = {'C9600', 'C9602', 'C9604', 'C9606', 'C9607'}

    SNOMEDCT = {
        '11101003', '15256002', '175066001', '232727003', '232728008', '232729000', '397193006',
        '397431004', '414089002', '414509005', '415070008', '428488008', '429499003', '429639007',
        '429809004', '431759005', '609152003', '609153008', '609154002', '698740005', '75761004',
        '80762004', '85053006', '91338001'
    }


class EssentialHypertension(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.104.12.1011'
    VALUE_SET_NAME = 'Essential Hypertension'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'I10'}

    ICD9CM = {'4010', '4011', '4019'}

    SNOMEDCT = {
        '10725009', '1201005', '276789009', '371125006', '429457004', '46481004', '48146000',
        '56218007', '59621000', '59720008', '65518004', '78975002'
    }


class MentalHealthDiagnoses(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.105.12.1004'
    VALUE_SET_NAME = 'Mental Health Diagnoses'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'F0390', 'F0391', 'F200', 'F201', 'F202', 'F203', 'F205', 'F2081', 'F2089', 'F209', 'F21',
        'F22', 'F23', 'F24', 'F250', 'F251', 'F258', 'F259', 'F28', 'F29', 'F3010', 'F3011',
        'F3012', 'F3013', 'F302', 'F303', 'F304', 'F308', 'F309', 'F310', 'F3110', 'F3111',
        'F3112', 'F3113', 'F312', 'F3130', 'F3131', 'F3132', 'F314', 'F315', 'F3160', 'F3161',
        'F3162', 'F3163', 'F3164', 'F3170', 'F3171', 'F3172', 'F3173', 'F3174', 'F3175', 'F3176',
        'F3177', 'F3178', 'F3181', 'F3189', 'F319', 'F320', 'F321', 'F322', 'F323', 'F324', 'F325',
        'F3289', 'F329', 'F330', 'F331', 'F332', 'F333', 'F3340', 'F3341', 'F3342', 'F338', 'F339',
        'F340', 'F341', 'F348', 'F349', 'F39', 'F4000', 'F4001', 'F4002', 'F4010', 'F4011',
        'F40210', 'F40218', 'F40220', 'F40228', 'F40230', 'F40231', 'F40232', 'F40233', 'F40240',
        'F40241', 'F40242', 'F40243', 'F40248', 'F40290', 'F40291', 'F40298', 'F408', 'F409',
        'F410', 'F411', 'F413', 'F418', 'F419', 'F42', 'F430', 'F4310', 'F4311', 'F4312', 'F4320',
        'F4321', 'F4322', 'F4323', 'F4324', 'F4325', 'F4329', 'F438', 'F439', 'F440', 'F441',
        'F442', 'F444', 'F445', 'F446', 'F447', 'F4481', 'F4489', 'F449', 'F450', 'F451', 'F4520',
        'F4521', 'F4522', 'F4529', 'F4541', 'F4542', 'F458', 'F459', 'F481', 'F482', 'F488',
        'F489', 'F5000', 'F5001', 'F5002', 'F502', 'F508', 'F509', 'F5101', 'F5102', 'F5103',
        'F5104', 'F5105', 'F5109', 'F5111', 'F5112', 'F5113', 'F5119', 'F513', 'F514', 'F515',
        'F518', 'F519', 'F520', 'F521', 'F5221', 'F5222', 'F5231', 'F5232', 'F524', 'F525', 'F526',
        'F528', 'F529', 'F53', 'F59', 'F600', 'F601', 'F602', 'F603', 'F604', 'F605', 'F606',
        'F607', 'F6081', 'F6089', 'F609', 'F630', 'F631', 'F632', 'F633', 'F6381', 'F6389', 'F639',
        'F641', 'F642', 'F648', 'F649', 'F650', 'F651', 'F652', 'F653', 'F654', 'F6550', 'F6551',
        'F6552', 'F6581', 'F6589', 'F659', 'F66', 'F6810', 'F6811', 'F6812', 'F6813', 'F688',
        'F69', 'F800', 'F801', 'F802', 'F804', 'F8081', 'F8089', 'F809', 'F810', 'F812', 'F8181',
        'F8189', 'F819', 'F82', 'F840', 'F842', 'F843', 'F845', 'F848', 'F849', 'F88', 'F89',
        'F900', 'F901', 'F902', 'F908', 'F909', 'F910', 'F911', 'F912', 'F913', 'F918', 'F919',
        'F930', 'F938', 'F939', 'F940', 'F941', 'F942', 'F948', 'F949', 'F950', 'F951', 'F952',
        'F958', 'F959', 'F980', 'F981', 'F9821', 'F9829', 'F983', 'F984', 'F985', 'F988', 'F989',
        'F99'
    }

    SNOMEDCT = {
        '10007009', '10278007', '10327003', '10349009', '10586006', '106013002', '106014008',
        '106015009', '106021000119105', '10760421000119102', '10783000', '10811121000119102',
        '10811161000119107', '10875004', '109006', '109478007', '109805003', '10981006',
        '109896009', '109897000', '109898005', '109899002', '109900007', '109901006', '11061003',
        '111475002', '111476001', '111477005', '111479008', '111480006', '111482003', '111483008',
        '111484002', '111485001', '111486000', '111487009', '111490003', '111491004', '111492006',
        '1145003', '11806006', '11941006', '1196001', '12348006', '126943008', '128293007',
        '129104009', '12939007', '129602009', '129604005', '129606007', '12969000',
        '130121000119104', '133091000119105', '133121000119109', '13313007', '13438001',
        '13581000', '13601005', '13670005', '13746004', '1376001', '1380006', '1383008',
        '14070001', '14077003', '14144000', '14183003', '14291003', '14495005', '14784000',
        '1499003', '15193003', '15277004', '153071000119108', '15639000', '15662003', '15840001',
        '1591000119103', '15945005', '15977008', '162004', '162218007', '162313000', '162702000',
        '162722001', '16295005', '16506000', '16805009', '1686006', '16966009', '16990005',
        '17155009', '17226007', '17262008', '17496003', '17782008', '17961008', '18003009',
        '18085000', '1816003', '18186001', '18193002', '18260003', '18393005', '18478005',
        '18491000119109', '1855002', '18573003', '18653004', '18689007', '187921002', '18818009',
        '18941000', '191447007', '191449005', '191451009', '191452002', '191454001', '191455000',
        '191457008', '191458003', '191459006', '191461002', '191463004', '191464005', '191465006',
        '191466007', '191471000', '191475009', '191476005', '191477001', '191478006', '191480000',
        '191483003', '191484009', '191485005', '191486006', '191492000', '191493005', '191494004',
        '191495003', '191496002', '191499009', '191501001', '191502008', '191503003', '191504009',
        '191505005', '191507002', '191508007', '191509004', '191510009', '191511008', '191512001',
        '191519005', '191525009', '191526005', '191527001', '191530008', '191531007', '191536002',
        '191537006', '191538001', '191539009', '191540006', '191542003', '191547009', '191548004',
        '191554003', '191555002', '191559008', '191561004', '191564007', '191565008', '191567000',
        '191569002', '191570001', '191571002', '191572009', '191574005', '191577003', '191583000',
        '191584006', '191586008', '191588009', '191590005', '191592002', '191593007', '191595000',
        '191597008', '191601008', '191602001', '191604000', '191606003', '191610000', '191611001',
        '191613003', '191615005', '191616006', '191618007', '191620005', '191621009', '191623007',
        '191625000', '191627008', '191629006', '191630001', '191632009', '191634005', '191636007',
        '191638008', '191639000', '191641004', '191643001', '191659001', '191667009', '191668004',
        '191670008', '191672000', '191676002', '191678001', '191680007', '191687005', '191689008',
        '191690004', '191692007', '191693002', '191696005', '191697001', '191713008', '191714002',
        '191722009', '191724005', '191725006', '191726007', '191736004', '191737008', '191738003',
        '191753006', '191765005', '191766006', '191772006', '191773001', '191774007', '191787001',
        '191811004', '191812006', '191813001', '191928000', '191952007', '191966002', '191983006',
        '191990001', '192014006', '192016008', '192017004', '192037000', '192038005', '192039002',
        '192041001', '192042008', '192044009', '192046006', '192049004', '192051000', '192052007',
        '192054008', '192056005', '192057001', '192058006', '192061007', '192063005', '192064004',
        '192065003', '192069009', '192072002', '192073007', '192079006', '192080009', '192097003',
        '192099000', '192108001', '192110004', '192122001', '192123006', '192127007', '192131001',
        '192132008', '192136006', '192147004', '192362008', '192523000', '192527004', '192562009',
        '192575009', '192611004', '192616009', '192631000', '19300006', '193756007', '19445006',
        '19480005', '19527009', '1973000', '197480006', '19766004', '19922006', '199257008',
        '199259006', '199260001', '199261002', '199262009', '20010003', '20250007', '20385005',
        '20876004', '20960007', '21000000', '21061000119107', '21071000119101', '21586000',
        '21634003', '21897009', '21900002', '22121000', '22230001', '22381000119105', '22407005',
        '22419002', '225040001', '22641000119109', '229025005', '229621000', '229622007',
        '229623002', '229625009', '229631007', '229632000', '229683000', '229698003', '229699006',
        '229700007', '229701006', '229715008', '229721007', '229729009', '229733002', '229734008',
        '229736005', '229738006', '229740001', '229741002', '229742009', '229743004', '229744005',
        '229745006', '229748008', '22981000119106', '230282000', '230285003', '230286002',
        '230287006', '230288001', '230289009', '230290000', '230334008', '230335009', '230336005',
        '230338006', '230438007', '230455006', '2312009', '231437006', '231438001', '231439009',
        '231440006', '231442003', '231443008', '231444002', '231445001', '231446000', '231448004',
        '231449007', '231450007', '231451006', '231452004', '231453009', '231454003', '231455002',
        '231456001', '231457005', '231458000', '231459008', '231467000', '23148009', '231485007',
        '231487004', '231489001', '231494001', '231496004', '231499006', '231500002', '231504006',
        '231509001', '231515001', '231516000', '231517009', '231520001', '231521002', '231522009',
        '231523004', '231524005', '231525006', '231526007', '231527003', '231528008', '231530005',
        '231532002', '231535000', '231536004', '231537008', '231538003', '231539006', '231540008',
        '231541007', '231542000', '232059000', '233690008', '23560001', '23601000119102',
        '23645006', '237350002', '237351003', '237352005', '23741000119105', '23772009',
        '238110009', '238959007', '238960002', '238961003', '238965007', '238966008', '238967004',
        '238972008', '238973003', '238974009', '238975005', '238976006', '238977002', '238978007',
        '238979004', '2403008', '24121004', '24125008', '24315006', '247803002', '247804008',
        '24781009', '25029006', '251000119105', '25501002', '25766007', '25772007', '25922000',
        '25971005', '26025008', '261000119107', '2618002', '26203008', '26453000', '26472000',
        '26516009', '26530004', '26665006', '26714005', '267320004', '268612007', '268617001',
        '268619003', '268620009', '268621008', '268622001', '268624000', '268633003', '268634009',
        '268650001', '268658008', '268662002', '268664001', '268666004', '268667008', '268668003',
        '268669006', '268672004', '268673009', '268715000', '268724009', '268727002', '268734000',
        '268738002', '270291000119109', '270901009', '270902002', '270903007', '270905000',
        '271000119101', '271428004', '271952001', '27387000', '274948002', '274950005',
        '274952002', '274953007', '27544004', '275473003', '275474009', '276296007', '276297003',
        '276300008', '27720003', '2776000', '278506006', '278508007', '278852008', '278853003',
        '278857002', '27956007', '279611005', '280032002', '280375000', '280377008', '280378003',
        '280943007', '280945000', '280949006', '280982009', '280983004', '280984005', '280986007',
        '280994000', '281000119103', '281004', '2815001', '28357009', '28368009', '28475009',
        '28663008', '28676002', '286933003', '288271000119103', '288421000119100',
        '288511000119108', '28857002', '288631000119104', '28864000', '288751000119101',
        '28884001', '29212009', '29599000', '29657007', '29733004', '29929003', '30059008',
        '300706003', '30077003', '301643003', '302507002', '30310000', '30336007', '30491001',
        '30509009', '30520009', '30605009', '30687003', '307417003', '30871003', '309279000',
        '30935000', '310202009', '31027006', '310495003', '310496002', '310497006', '310814007',
        '311173003', '31177006', '312098001', '312936002', '31297008', '312991009', '313182004',
        '313224008', '313426007', '31358003', '31373002', '313915006', '31446002', '3158007',
        '31611000', '31648009', '31658008', '31715000', '31781004', '317816007', '318784009',
        '319768000', '32009006', '320751009', '32174002', '32358001', '32388005', '32410009',
        '32552001', '32721004', '32875003', '32880007', '3298001', '33078009', '33135002',
        '33323008', '33380008', '33449004', '33693007', '33736005', '33871004', '33982008',
        '34116005', '34315001', '34485008', '34938008', '3503000', '35218008', '35252006',
        '35253001', '3530005', '35481005', '35489007', '35607004', '35722002', '357705009',
        '35827000', '35846004', '35919005', '359661001', '36039004', '36158005', '36217008',
        '36262007', '36474008', '36583000', '36622002', '367515004', '36923009', '36943003',
        '370143000', '371024007', '371026009', '371596008', '371599001', '371600003', '371604007',
        '371631005', '37331004', '373618009', '37739004', '37746008', '37868008', '37872007',
        '37941009', '38295006', '38328002', '38368003', '38547003', '386701004', '386810004',
        '386820009', '386821008', '386822001', '386823006', '386824000', '386825004', '38694004',
        '39003006', '391099000', '3914008', '39465007', '39610001', '397803000', '397923000',
        '398066007', '39807006', '39809009', '39951000119105', '39951001', '40083003', '402732001',
        '402733006', '402735004', '403170002', '403590001', '403593004', '403594005', '403595006',
        '40379007', '404906000', '40568001', '40571009', '406506008', '40673001', '408856003',
        '408857007', '408858002', '40926005', '40987004', '41021005', '41083005', '412787009',
        '414673004', '41524005', '41526007', '41552001', '416073003', '416340002', '416714005',
        '417143004', '417360004', '41832009', '41836007', '420614009', '420774007', '421023003',
        '421529006', '422437002', '42344001', '425390006', '425914008', '425919003', '42594001',
        '426174008', '426881004', '427145007', '427469003', '427975003', '428007007',
        '428051000124108', '42810003', '428351000124105', '42868002', '428687006', '428703001',
        '42925002', '429571005', '429672007', '429998004', '4306003', '430744005', '430751001',
        '430771000124100', '430852001', '430909002', '43150009', '432091002', '434451000124105',
        '43497001', '434971000124109', '43568002', '436001000124105', '43614003', '43769008',
        '439960005', '44031002', '44124003', '441704009', '441711008', '441716003', '441719005',
        '441833000', '442057004', '442243005', '442245003', '442314000', '442351006', '443735008',
        '44376007', '443919007', '4441000', '44433009', '444613000', '446175003', '446180007',
        '44966003', '450714000', '45479006', '45677003', '45912004', '45924006', '45994004',
        '46023009', '46206005', '46229002', '46244001', '46372006', '46432001', '46721000',
        '46762006', '46975003', '472981000', '473020005', '473452003', '473456000', '473457009',
        '47372000', '47447001', '47505003', '47664006', '47916000', '48046002', '48309007',
        '48500005', '48589009', '48826008', '48937005', '4926007', '49271002', '4932002',
        '49468007', '49481000', '4949009', '49512000', '49564006', '4997005', '50026000',
        '50299009', '50320000', '50705009', '50722006', '50878001', '50933003', '5095008',
        '50983008', '51133006', '51239001', '51443000', '51493001', '5158005', '51637008',
        '51771007', '51928006', '52448006', '52702003', '52824009', '52866005', '52910006',
        '52954000', '53049002', '53050002', '53467004', '53607008', '53936005', '53956006',
        '54319003', '54417002', '5444000', '54587008', '5464005', '54761006', '5507002', '5509004',
        '5510009', '55341008', '55516002', '55668003', '55728007', '55736003', '55967005',
        '56034001', '56095002', '5619004', '56194001', '56267009', '56573006', '56576003',
        '56627002', '5664002', '56641006', '568005', '56882008', '5703000', '57194009', '57588009',
        '57715001', '58214004', '58329000', '58349009', '58535001', '58647003', '58703003',
        '58855008', '59174009', '59216005', '59252009', '59394009', '59617007', '59645001',
        '59651006', '59923000', '600009', '60099002', '60103007', '60123008', '609225004',
        '61104008', '61144001', '61157009', '61180001', '61212007', '61403008', '61569007',
        '61771000119106', '61831009', '61901004', '62211000119103', '62221000119105',
        '62231000119108', '62239001', '62351001', '62491004', '62792007', '63181006', '63204009',
        '63249007', '63393005', '63412003', '6348008', '63649001', '63701002', '63778009',
        '63835008', '63909006', '63983005', '64060000', '64165008', '64731001', '64905009',
        '65042007', '65064003', '65410009', '66307007', '66344007', '66347000', '66381006',
        '66590003', '66631006', '66936004', '67002003', '67123006', '67195008', '67227000',
        '68019004', '68569003', '68618008', '68890003', '68963006', '68995007', '69322001',
        '69361009', '69392006', '69479009', '69482004', '698624003', '698625002', '698626001',
        '698687007', '698693004', '698696007', '698697003', '698698008', '698700004', '698701000',
        '698725008', '698726009', '698781002', '698947004', '698948009', '698951002', '698952009',
        '698957003', '699241002', '70043001', '7025000', '702528003', '702732007', '70328006',
        '7052005', '70546001', '70655008', '70691001', '70747007', '708037001', '70814008',
        '70922000', '70932007', '70936005', '71103003', '712823008', '712824002', '712850003',
        '712884004', '71294008', '71328000', '71336009', '713488003', '713844000', '715737004',
        '715924009', '71787009', '71959007', '71961003', '71984005', '7200002', '72366004',
        '72861004', '7291006', '73097000', '73462009', '73471000', '73867007', '7397008',
        '74007000', '74010007', '74142004', '74266001', '7461003', '74686005', '74732009',
        '74791000', '74850006', '74934004', '75084000', '75122001', '75360000', '75752004',
        '75837004', '76105009', '76236006', '76441001', '76566000', '76812003', '76868007',
        '77355000', '77383003', '77475008', '77486005', '77675002', '77815007', '77911002',
        '7794004', '78004001', '78269000', '78358001', '78640000', '78667006', '79204003',
        '79298009', '79341000119107', '79524000', '79578000', '79584002', '79842004', '79866005',
        '80711002', '80868005', '81319007', '81463002', '8185002', '81903006', '82096005',
        '82218004', '82339009', '82415003', '82494000', '82636008', '82738004', '82959004',
        '82998009', '83168008', '832007', '83225003', '83253003', '83367009', '83458005',
        '83501007', '83631006', '83746006', '83890006', '84002002', '84466009', '84760002',
        '84788008', '84984002', '85061001', '8511007', '8522006', '85248005', '85561006',
        '85821003', '85861002', '86058007', '8635005', '87132004', '87203005', '87414006',
        '87512008', '87798009', '87950005', '87991007', '8837000', '88740003', '88845000',
        '88939009', '88975006', '89016005', '89248000', '89381000119107', '89391000119105',
        '89415002', '89451009', '89501000119108', '89618007', '899001', '89948007', '89989005',
        '90099008', '90755006', '90790003', '9083002', '9167000', '92501000119101', '9340000',
        '9345005', '93461009', '94921000119107', '95635002', '95636001', '95637005', '9674006',
        '9760005'
    }


class MajorDepression(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.105.12.1007'
    VALUE_SET_NAME = 'Major Depression'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'F320', 'F321', 'F322', 'F323', 'F324', 'F329', 'F330', 'F331', 'F332', 'F333', 'F3341',
        'F339'
    }

    SNOMEDCT = {
        '14183003', '15193003', '15639000', '18818009', '191601008', '191602001', '191604000',
        '191610000', '191611001', '191613003', '20250007', '231499006', '251000119105', '25922000',
        '2618002', '268620009', '268621008', '274948002', '281000119103', '28475009', '300706003',
        '30605009', '319768000', '320751009', '321717001', '33078009', '33135002', '33736005',
        '36474008', '36923009', '370143000', '38694004', '39809009', '40379007', '42925002',
        '430852001', '450714000', '60099002', '63778009', '66344007', '69392006', '70747007',
        '71336009', '73867007', '75084000', '76441001', '77911002', '79298009', '832007',
        '87512008'
    }


class AlcoholAndDrugDependence(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1001'
    VALUE_SET_NAME = 'Alcohol and Drug Dependence'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'F1010', 'F10120', 'F10121', 'F10129', 'F1014', 'F10150', 'F10151', 'F10159', 'F10180',
        'F10181', 'F10182', 'F10188', 'F1019', 'F1020', 'F10220', 'F10221', 'F10229', 'F10230',
        'F10231', 'F10232', 'F10239', 'F1024', 'F10250', 'F10251', 'F10259', 'F1026', 'F1027',
        'F10280', 'F10281', 'F10282', 'F10288', 'F1029', 'F1110', 'F11120', 'F11121', 'F11122',
        'F11129', 'F1114', 'F11150', 'F11151', 'F11159', 'F11181', 'F11182', 'F11188', 'F1119',
        'F1120', 'F11220', 'F11221', 'F11222', 'F11229', 'F1123', 'F1124', 'F11250', 'F11251',
        'F11259', 'F11281', 'F11282', 'F11288', 'F1129', 'F1210', 'F12120', 'F12121', 'F12122',
        'F12129', 'F12150', 'F12151', 'F12159', 'F12180', 'F12188', 'F1219', 'F1220', 'F12220',
        'F12221', 'F12222', 'F12229', 'F12250', 'F12251', 'F12259', 'F12280', 'F12288', 'F1229',
        'F1310', 'F13120', 'F13121', 'F13129', 'F1314', 'F13150', 'F13151', 'F13159', 'F13180',
        'F13181', 'F13182', 'F13188', 'F1319', 'F1320', 'F13220', 'F13221', 'F13229', 'F13230',
        'F13231', 'F13232', 'F13239', 'F1324', 'F13250', 'F13251', 'F13259', 'F1326', 'F1327',
        'F13280', 'F13281', 'F13282', 'F13288', 'F1329', 'F1410', 'F14120', 'F14121', 'F14122',
        'F14129', 'F1414', 'F14150', 'F14151', 'F14159', 'F14180', 'F14181', 'F14182', 'F14188',
        'F1419', 'F1420', 'F14220', 'F14221', 'F14222', 'F14229', 'F1423', 'F1424', 'F14250',
        'F14251', 'F14259', 'F14280', 'F14281', 'F14282', 'F14288', 'F1429', 'F1510', 'F15120',
        'F15121', 'F15122', 'F15129', 'F1514', 'F15150', 'F15151', 'F15159', 'F15180', 'F15181',
        'F15182', 'F15188', 'F1519', 'F1520', 'F15220', 'F15221', 'F15222', 'F15229', 'F1523',
        'F1524', 'F15250', 'F15251', 'F15259', 'F15280', 'F15281', 'F15282', 'F15288', 'F1529',
        'F1610', 'F16120', 'F16121', 'F16122', 'F16129', 'F1614', 'F16150', 'F16151', 'F16159',
        'F16180', 'F16183', 'F16188', 'F1619', 'F1620', 'F16220', 'F16221', 'F16229', 'F1624',
        'F16250', 'F16251', 'F16259', 'F16280', 'F16283', 'F16288', 'F1629', 'F1810', 'F18120',
        'F18121', 'F18129', 'F1814', 'F18150', 'F18151', 'F18159', 'F1817', 'F18180', 'F18188',
        'F1819', 'F1820', 'F18220', 'F18221', 'F18229', 'F1824', 'F18250', 'F18251', 'F18259',
        'F1827', 'F18280', 'F18288', 'F1829', 'F1910', 'F19120', 'F19121', 'F19122', 'F19129',
        'F1914', 'F19150', 'F19151', 'F19159', 'F1916', 'F1917', 'F19180', 'F19181', 'F19182',
        'F19188', 'F1919', 'F1920', 'F19220', 'F19221', 'F19222', 'F19229', 'F19230', 'F19231',
        'F19232', 'F19239', 'F1924', 'F19250', 'F19251', 'F19259', 'F1926', 'F1927', 'F19280',
        'F19281', 'F19282', 'F19288', 'F1929'
    }

    SNOMEDCT = {
        '10028000', '10327003', '10741871000119101', '10755041000119100', '10755161000119102',
        '1081000119105', '110281001', '11061003', '111479008', '111480006', '11387009',
        '125851000119106', '1383008', '145101000119102', '145841000119107', '14784000', '15167005',
        '15277004', '153491000119103', '153501000119105', '1686006', '18653004', '18689007',
        '191471000', '191475009', '191476005', '191477001', '191478006', '191480000', '191483003',
        '191484009', '191485005', '191486006', '191492000', '191493005', '191494004', '191495003',
        '191496002', '191802004', '191804003', '191805002', '191811004', '191812006', '191816009',
        '191819002', '191820008', '191825003', '191826002', '191829009', '191831000', '191832007',
        '191837001', '191838006', '191843004', '191844005', '191849000', '191850000', '191853003',
        '191855005', '191856006', '191865004', '191867007', '191868002', '191871005', '191873008',
        '191874002', '191877009', '191928000', '19303008', '19445006', '1973000', '199252002',
        '199253007', '199254001', '199255000', '20385005', '20876004', '21000000', '21647008',
        '21831000119109', '21841000119100', '230334008', '230443000', '231451006', '231458000',
        '231459008', '231461004', '231462006', '231467000', '231468005', '231469002', '231470001',
        '231472009', '231473004', '231474005', '231475006', '231477003', '231478008', '231479000',
        '231480002', '231481003', '231482005', '236751006', '237228001', '2403008', '25508008',
        '26416006', '26714005', '267206008', '268640002', '268641003', '268727002', '275471001',
        '27956007', '280982009', '280983004', '280984005', '280986007', '281004', '28368009',
        '284591009', '288281000119100', '28864000', '29212009', '29733004', '301643003',
        '302507002', '30310000', '304605000', '30491001', '30871003', '309279000', '310202009',
        '311173003', '312098001', '312936002', '313915006', '31715000', '31956009', '32009006',
        '32358001', '32552001', '32875003', '33845003', '33871004', '34938008', '361150008',
        '361151007', '363101005', '37331004', '37344009', '38247002', '39003006', '396344000',
        '39807006', '39951001', '403590001', '40571009', '41083005', '416073003', '416714005',
        '417143004', '417360004', '42344001', '425339005', '425533007', '425885002', '426001001',
        '426095000', '426590003', '426873000', '427205009', '427229002', '427327003', '427975003',
        '428219007', '428370001', '429001000124103', '429299000', '429672007', '429692000',
        '43497001', '434971000124109', '441527004', '441681009', '442351006', '442406005',
        '445273005', '46721000', '46975003', '47664006', '4863002', '5002000', '50026000',
        '50320000', '50722006', '50933003', '50983008', '51339003', '51443000', '51493001',
        '52866005', '53050002', '53936005', '5444000', '55967005', '5602001', '56194001',
        '57588009', '58727001', '59651006', '61104008', '61144001', '6348008', '63649001',
        '63983005', '64386003', '6525002', '66214007', '66590003', '69482004', '699449003',
        '70328006', '70340006', '703845008', '703849002', '7052005', '70655008', '7071007',
        '70932007', '71328000', '7200002', '73097000', '74851005', '74934004', '75122001',
        '75544000', '77355000', '7761000119106', '78267003', '78358001', '79578000', '80868005',
        '82339009', '83168008', '83367009', '84758004', '85005007', '85561006', '8635005',
        '87132004', '8837000', '89451009', '90755006', '90790003', '91388009', '95635002',
        '95661003', '95918004', '9769006'
    }


class IvDrugAbuse(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1003'
    VALUE_SET_NAME = 'IV Drug Abuse'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'F1110', 'F11120', 'F11121', 'F11122', 'F11129', 'F1114', 'F11150', 'F11151', 'F11159',
        'F11181', 'F11182', 'F11188', 'F1119', 'F1120', 'F1121', 'F11220', 'F11221', 'F11222',
        'F11229', 'F1123', 'F1124', 'F11250', 'F11251', 'F11259', 'F11281', 'F11282', 'F11288',
        'F1129', 'F1310', 'F13120', 'F13121', 'F13129', 'F1314', 'F13150', 'F13151', 'F13159',
        'F13180', 'F13181', 'F13182', 'F13188', 'F1319', 'F1320', 'F1321', 'F13220', 'F13221',
        'F13229', 'F13230', 'F13231', 'F13232', 'F13239', 'F1324', 'F13250', 'F13251', 'F13259',
        'F1326', 'F1327', 'F13280', 'F13281', 'F13282', 'F13288', 'F1329', 'F1410', 'F14120',
        'F14121', 'F14122', 'F14129', 'F1414', 'F14150', 'F14151', 'F14159', 'F14180', 'F14181',
        'F14182', 'F14188', 'F1419', 'F1420', 'F1421', 'F14220', 'F14221', 'F14222', 'F14229',
        'F1423', 'F1424', 'F14250', 'F14251', 'F14259', 'F14280', 'F14281', 'F14282', 'F14288',
        'F1429', 'F1510', 'F15120', 'F15121', 'F15122', 'F15129', 'F1514', 'F15150', 'F15151',
        'F15159', 'F15180', 'F15181', 'F15182', 'F15188', 'F1519', 'F1520', 'F1521', 'F15220',
        'F15221', 'F15222', 'F15229', 'F1523', 'F1524', 'F15250', 'F15251', 'F15259', 'F15280',
        'F15281', 'F15282', 'F15288', 'F1529'
    }

    SNOMEDCT = {
        '1081000119105', '191819002', '191820008', '191821007', '191825003', '191826002',
        '191827006', '191831000', '191832007', '191833002', '191843004', '191844005', '191845006',
        '191905001', '191906000', '191907009', '191909007', '191912005', '191913000', '191914006',
        '191916008', '191918009', '191919001', '191920007', '191924003', '191925002', '21647008',
        '231461004', '231462006', '231470001', '231472009', '231473004', '231474005', '231475006',
        '231477003', '231478008', '231479000', '231480002', '268640002', '268647004', '268648009',
        '31956009', '414874007', '426001001', '426873000', '427205009', '427327003', '429692000',
        '5602001', '64386003', '75544000', '78267003', '84758004'
    }


class SubstanceAbuse(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1004'
    VALUE_SET_NAME = 'Substance Abuse'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'F1010', 'F10120', 'F10121', 'F10129', 'F1014', 'F10150', 'F10151', 'F10159', 'F10180',
        'F10181', 'F10182', 'F10188', 'F1019', 'F1020', 'F1021', 'F10220', 'F10221', 'F10229',
        'F10230', 'F10231', 'F10232', 'F10239', 'F1024', 'F10250', 'F10251', 'F10259', 'F1026',
        'F1027', 'F10280', 'F10281', 'F10282', 'F10288', 'F1029', 'F10920', 'F10921', 'F10929',
        'F1094', 'F10950', 'F10951', 'F10959', 'F1096', 'F1097', 'F10980', 'F10981', 'F10982',
        'F10988', 'F1099', 'F1110', 'F11120', 'F11121', 'F11122', 'F11129', 'F1114', 'F11150',
        'F11151', 'F11159', 'F11181', 'F11182', 'F11188', 'F1119', 'F1120', 'F1121', 'F11220',
        'F11221', 'F11222', 'F11229', 'F1123', 'F1124', 'F11250', 'F11251', 'F11259', 'F11281',
        'F11282', 'F11288', 'F1129', 'F1190', 'F11920', 'F11921', 'F11922', 'F11929', 'F1193',
        'F1194', 'F11950', 'F11951', 'F11959', 'F11981', 'F11982', 'F11988', 'F1199', 'F1210',
        'F12120', 'F12121', 'F12122', 'F12129', 'F12150', 'F12151', 'F12159', 'F12180', 'F12188',
        'F1219', 'F1220', 'F1221', 'F12220', 'F12221', 'F12222', 'F12229', 'F12250', 'F12251',
        'F12259', 'F12280', 'F12288', 'F1229', 'F1290', 'F12920', 'F12921', 'F12922', 'F12929',
        'F12950', 'F12951', 'F12959', 'F12980', 'F12988', 'F1299', 'F1310', 'F13120', 'F13121',
        'F13129', 'F1314', 'F13150', 'F13151', 'F13159', 'F13180', 'F13181', 'F13182', 'F13188',
        'F1319', 'F1320', 'F1321', 'F13220', 'F13221', 'F13229', 'F13230', 'F13231', 'F13232',
        'F13239', 'F1324', 'F13250', 'F13251', 'F13259', 'F1326', 'F1327', 'F13280', 'F13281',
        'F13282', 'F13288', 'F1329', 'F1390', 'F13920', 'F13921', 'F13929', 'F13930', 'F13931',
        'F13932', 'F13939', 'F1394', 'F13950', 'F13951', 'F13959', 'F1396', 'F1397', 'F13980',
        'F13981', 'F13982', 'F13988', 'F1399', 'F1410', 'F14120', 'F14121', 'F14122', 'F14129',
        'F1414', 'F14150', 'F14151', 'F14159', 'F14180', 'F14181', 'F14182', 'F14188', 'F1419',
        'F1420', 'F1421', 'F14220', 'F14221', 'F14222', 'F14229', 'F1423', 'F1424', 'F14250',
        'F14251', 'F14259', 'F14280', 'F14281', 'F14282', 'F14288', 'F1429', 'F1490', 'F14920',
        'F14921', 'F14922', 'F14929', 'F1494', 'F14950', 'F14951', 'F14959', 'F14980', 'F14981',
        'F14982', 'F14988', 'F1499', 'F1510', 'F15120', 'F15121', 'F15122', 'F15129', 'F1514',
        'F15150', 'F15151', 'F15159', 'F15180', 'F15181', 'F15182', 'F15188', 'F1519', 'F1520',
        'F1521', 'F15220', 'F15221', 'F15222', 'F15229', 'F1523', 'F1524', 'F15250', 'F15251',
        'F15259', 'F15280', 'F15281', 'F15282', 'F15288', 'F1529', 'F1590', 'F15920', 'F15921',
        'F15922', 'F15929', 'F1593', 'F1594', 'F15950', 'F15951', 'F15959', 'F15980', 'F15981',
        'F15982', 'F15988', 'F1599', 'F1610', 'F16120', 'F16121', 'F16122', 'F16129', 'F1614',
        'F16150', 'F16151', 'F16159', 'F16180', 'F16183', 'F16188', 'F1619', 'F1620', 'F1621',
        'F16220', 'F16221', 'F16229', 'F1624', 'F16250', 'F16251', 'F16259', 'F16280', 'F16283',
        'F16288', 'F1629', 'F1690', 'F16920', 'F16921', 'F16929', 'F1694', 'F16950', 'F16951',
        'F16959', 'F16980', 'F16983', 'F16988', 'F1699', 'F1810', 'F18120', 'F18121', 'F18129',
        'F1814', 'F18150', 'F18151', 'F18159', 'F1817', 'F18180', 'F18188', 'F1819', 'F1820',
        'F1821', 'F18220', 'F18221', 'F18229', 'F1824', 'F18250', 'F18251', 'F18259', 'F1827',
        'F18280', 'F18288', 'F1829', 'F1890', 'F18920', 'F18921', 'F18929', 'F1894', 'F18950',
        'F18951', 'F18959', 'F1897', 'F18980', 'F18988', 'F1899', 'F1910', 'F19120', 'F19121',
        'F19122', 'F19129', 'F1914', 'F19150', 'F19151', 'F19159', 'F1916', 'F1917', 'F19180',
        'F19181', 'F19182', 'F19188', 'F1919', 'F1920', 'F1921', 'F19220', 'F19221', 'F19222',
        'F19229', 'F19230', 'F19231', 'F19232', 'F19239', 'F1924', 'F19250', 'F19251', 'F19259',
        'F1926', 'F1927', 'F19280', 'F19281', 'F19282', 'F19288', 'F1929', 'F1990', 'F19920',
        'F19921', 'F19922', 'F19929', 'F19930', 'F19931', 'F19932', 'F19939', 'F1994', 'F19950',
        'F19951', 'F19959', 'F1996', 'F1997', 'F19980', 'F19981', 'F19982', 'F19988', 'F1999'
    }

    SNOMEDCT = {
        '1081000119105', '110281001', '144981000119109', '145101000119102', '145841000119107',
        '1461000119109', '1471000119103', '15167005', '153501000119105', '191882002', '191883007',
        '191884001', '191891003', '191893000', '191894006', '191895007', '191899001', '191900006',
        '191901005', '191905001', '191906000', '191907009', '191909007', '191912005', '191913000',
        '191914006', '191916008', '191918009', '191919001', '191920007', '191924003', '191925002',
        '191928000', '191930003', '191931004', '191932006', '191934007', '191936009', '191937000',
        '191938005', '231458000', '231459008', '231461004', '231462006', '248119008', '26416006',
        '268645007', '268646008', '268647004', '268648009', '280982009', '280983004', '280984005',
        '280985006', '280986007', '284591009', '288281000119100', '304605000', '34111000119108',
        '37344009', '414874007', '425533007', '425885002', '426095000', '426590003', '427205009',
        '427229002', '428561000124100', '429001000124103', '429692000', '441527004', '445273005',
        '49540005', '5602001', '64386003', '6525002', '66214007', '70340006', '7071007',
        '713775002', '74851005', '78267003', '84758004', '91388009', '9769006'
    }


class AlcoholAndDrugDependenceTreatment(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.106.12.1005'
    VALUE_SET_NAME = 'Alcohol and Drug Dependence Treatment'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '171047005', '20093000', '23915005', '24165007', '266707007', '310653000', '313071005',
        '370881007', '370884004', '385989002', '386448003', '386449006', '386450006', '386451005',
        '408933008', '408934002', '408935001', '408936000', '408941008', '408942001', '408943006',
        '408944000', '408945004', '408947007', '408948002', '410419007', '413473000', '423416000',
        '424148004', '424407005', '424589009', '426928008', '429291000124102', '56876005',
        '60112009', '707166002'
    }


class MalignantNeoplasmOfColon(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1001'
    VALUE_SET_NAME = 'Malignant Neoplasm of Colon'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'C180', 'C181', 'C182', 'C183', 'C184', 'C185', 'C186', 'C187', 'C188', 'C189', 'C19',
        'C20', 'C212', 'C218', 'C785', 'C7A021', 'C7A022', 'C7A023', 'C7A024', 'C7A025', 'C7A026'
    }

    ICD9CM = {
        '1530', '1531', '1532', '1533', '1534', '1535', '1536', '1537', '1538', '1539', '1540',
        '1541', '1975'
    }

    SNOMEDCT = {
        '109838007', '123721000119108', '1701000119104', '187757001', '187758006', '269533000',
        '269544008', '285312008', '285611007', '301756000', '312111009', '312112002', '312113007',
        '312114001', '312115000', '314965007', '315058005', '363406005', '363407001', '363408006',
        '363409003', '363410008', '363412000', '363413005', '363414004', '363510005', '425178004',
        '449218003', '93683002', '93761005', '93771007', '93826009', '93980002', '94006002',
        '94072004', '94105000', '94179005', '94260004', '94271003', '94328005', '94509004',
        '94538001', '94604000', '94643001'
    }


class MalignantNeoplasmOfLymphaticAndHematopoieticTissue(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1009'
    VALUE_SET_NAME = 'Malignant Neoplasm of Lymphatic and Hematopoietic Tissue'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'C220', 'C221', 'C222', 'C223', 'C224', 'C227', 'C228', 'C229', 'C23', 'C240', 'C241',
        'C248', 'C249', 'C250', 'C251', 'C252', 'C253', 'C254', 'C257', 'C258', 'C259', 'C460',
        'C461', 'C462', 'C463', 'C464', 'C4650', 'C4651', 'C4652', 'C467', 'C469', 'C7B01',
        'C7B02', 'C8100', 'C8101', 'C8102', 'C8103', 'C8104', 'C8105', 'C8106', 'C8107', 'C8108',
        'C8109', 'C8110', 'C8111', 'C8112', 'C8113', 'C8114', 'C8115', 'C8116', 'C8117', 'C8118',
        'C8119', 'C8120', 'C8121', 'C8122', 'C8123', 'C8124', 'C8125', 'C8126', 'C8127', 'C8128',
        'C8129', 'C8130', 'C8131', 'C8132', 'C8133', 'C8134', 'C8135', 'C8136', 'C8137', 'C8138',
        'C8139', 'C8140', 'C8141', 'C8142', 'C8143', 'C8144', 'C8145', 'C8146', 'C8147', 'C8148',
        'C8149', 'C8170', 'C8171', 'C8172', 'C8173', 'C8174', 'C8175', 'C8176', 'C8177', 'C8178',
        'C8179', 'C8190', 'C8191', 'C8192', 'C8193', 'C8194', 'C8195', 'C8196', 'C8197', 'C8198',
        'C8199', 'C8200', 'C8201', 'C8202', 'C8203', 'C8204', 'C8205', 'C8206', 'C8207', 'C8208',
        'C8209', 'C8210', 'C8211', 'C8212', 'C8213', 'C8214', 'C8215', 'C8216', 'C8217', 'C8218',
        'C8219', 'C8220', 'C8221', 'C8222', 'C8223', 'C8224', 'C8225', 'C8226', 'C8227', 'C8228',
        'C8229', 'C8230', 'C8231', 'C8232', 'C8233', 'C8234', 'C8235', 'C8236', 'C8237', 'C8238',
        'C8239', 'C8240', 'C8241', 'C8242', 'C8243', 'C8244', 'C8245', 'C8246', 'C8247', 'C8248',
        'C8249', 'C8250', 'C8251', 'C8252', 'C8253', 'C8254', 'C8255', 'C8256', 'C8257', 'C8258',
        'C8259', 'C8260', 'C8261', 'C8262', 'C8263', 'C8264', 'C8265', 'C8266', 'C8267', 'C8268',
        'C8269', 'C8280', 'C8281', 'C8282', 'C8283', 'C8284', 'C8285', 'C8286', 'C8287', 'C8288',
        'C8289', 'C8290', 'C8291', 'C8292', 'C8293', 'C8294', 'C8295', 'C8296', 'C8297', 'C8298',
        'C8299', 'C8300', 'C8301', 'C8302', 'C8303', 'C8304', 'C8305', 'C8306', 'C8307', 'C8308',
        'C8309', 'C8310', 'C8311', 'C8312', 'C8313', 'C8314', 'C8315', 'C8316', 'C8317', 'C8318',
        'C8319', 'C8330', 'C8331', 'C8332', 'C8333', 'C8334', 'C8335', 'C8336', 'C8337', 'C8338',
        'C8339', 'C8350', 'C8351', 'C8352', 'C8353', 'C8354', 'C8355', 'C8356', 'C8357', 'C8358',
        'C8359', 'C8370', 'C8371', 'C8372', 'C8373', 'C8374', 'C8375', 'C8376', 'C8377', 'C8378',
        'C8379', 'C8380', 'C8381', 'C8382', 'C8383', 'C8384', 'C8385', 'C8386', 'C8387', 'C8388',
        'C8389', 'C8390', 'C8391', 'C8392', 'C8393', 'C8394', 'C8395', 'C8396', 'C8397', 'C8398',
        'C8399', 'C8400', 'C8401', 'C8402', 'C8403', 'C8404', 'C8405', 'C8406', 'C8407', 'C8408',
        'C8409', 'C8410', 'C8411', 'C8412', 'C8413', 'C8414', 'C8415', 'C8416', 'C8417', 'C8418',
        'C8419', 'C8440', 'C8441', 'C8442', 'C8443', 'C8444', 'C8445', 'C8446', 'C8447', 'C8448',
        'C8449', 'C8460', 'C8461', 'C8462', 'C8463', 'C8464', 'C8465', 'C8466', 'C8467', 'C8468',
        'C8469', 'C8470', 'C8471', 'C8472', 'C8473', 'C8474', 'C8475', 'C8476', 'C8477', 'C8478',
        'C8479', 'C8490', 'C8491', 'C8492', 'C8493', 'C8494', 'C8495', 'C8496', 'C8497', 'C8498',
        'C8499', 'C84A0', 'C84A1', 'C84A2', 'C84A3', 'C84A4', 'C84A5', 'C84A6', 'C84A7', 'C84A8',
        'C84A9', 'C84Z0', 'C84Z1', 'C84Z2', 'C84Z3', 'C84Z4', 'C84Z5', 'C84Z6', 'C84Z7', 'C84Z8',
        'C84Z9', 'C8510', 'C8511', 'C8512', 'C8513', 'C8514', 'C8515', 'C8516', 'C8517', 'C8518',
        'C8519', 'C8520', 'C8521', 'C8522', 'C8523', 'C8524', 'C8525', 'C8526', 'C8527', 'C8528',
        'C8529', 'C8580', 'C8581', 'C8582', 'C8583', 'C8584', 'C8585', 'C8586', 'C8587', 'C8588',
        'C8589', 'C8590', 'C8591', 'C8592', 'C8593', 'C8594', 'C8595', 'C8596', 'C8597', 'C8598',
        'C8599', 'C860', 'C861', 'C862', 'C863', 'C864', 'C865', 'C866', 'C882', 'C883', 'C884',
        'C888', 'C889', 'C9000', 'C9001', 'C9002', 'C9010', 'C9011', 'C9012', 'C9020', 'C9021',
        'C9022', 'C9030', 'C9031', 'C9032', 'C9100', 'C9101', 'C9102', 'C9110', 'C9111', 'C9112',
        'C9130', 'C9131', 'C9132', 'C9140', 'C9141', 'C9142', 'C9150', 'C9151', 'C9152', 'C9160',
        'C9161', 'C9162', 'C9190', 'C9191', 'C9192', 'C91A0', 'C91A1', 'C91A2', 'C91Z0', 'C91Z1',
        'C91Z2', 'C9200', 'C9201', 'C9202', 'C9210', 'C9211', 'C9212', 'C9220', 'C9221', 'C9222',
        'C9230', 'C9231', 'C9232', 'C9240', 'C9241', 'C9242', 'C9250', 'C9251', 'C9252', 'C9260',
        'C9261', 'C9262', 'C9290', 'C9291', 'C9292', 'C92A0', 'C92A1', 'C92A2', 'C92Z0', 'C92Z1',
        'C92Z2', 'C9300', 'C9301', 'C9302', 'C9310', 'C9311', 'C9312', 'C9330', 'C9331', 'C9332',
        'C9390', 'C9391', 'C9392', 'C93Z0', 'C93Z1', 'C93Z2', 'C9400', 'C9401', 'C9402', 'C9420',
        'C9421', 'C9422', 'C9430', 'C9431', 'C9432', 'C9480', 'C9481', 'C9482', 'C9500', 'C9501',
        'C9502', 'C9510', 'C9511', 'C9512', 'C9590', 'C9591', 'C9592', 'C960', 'C962', 'C964',
        'C965', 'C966', 'C969', 'C96A', 'C96Z'
    }

    SNOMEDCT = {
        '109391009', '109962001', '109964000', '109965004', '109966003', '109967007', '109968002',
        '109969005', '109970006', '109971005', '109972003', '109975001', '109976000', '109977009',
        '109978004', '109979007', '109980005', '109988003', '109989006', '110002002', '110004001',
        '110005000', '110006004', '110007008', '116711000119103', '116741000119104',
        '116811000119106', '116821000119104', '117061000119101', '117091000119108',
        '117111000119100', '118599009', '118600007', '118601006', '118602004', '118605002',
        '118606001', '118607005', '118608000', '118609008', '118610003', '118611004', '118612006',
        '118613001', '118614007', '118615008', '118618005', '122511000119103', '127070008',
        '127213008', '127214002', '127220001', '127225006', '128874001', '128875000', '129000002',
        '133751000119102', '187822008', '188487008', '188489006', '188492005', '188493000',
        '188498009', '188500005', '188501009', '188502002', '188503007', '188504001', '188505000',
        '188506004', '188507008', '188510001', '188511002', '188512009', '188513004', '188514005',
        '188515006', '188516007', '188517003', '188524002', '188526000', '188529007', '188531003',
        '188534006', '188536008', '188537004', '188538009', '188541000', '188544008', '188547001',
        '188548006', '188551004', '188554007', '188558005', '188559002', '188562004', '188565002',
        '188566001', '188567005', '188568000', '188569008', '188570009', '188572001', '188575004',
        '188576003', '188577007', '188578002', '188579005', '188580008', '188582000', '188585003',
        '188586002', '188587006', '188589009', '188590000', '188591001', '188592008', '188593003',
        '188609000', '188612002', '188613007', '188627002', '188630009', '188631008', '188632001',
        '188633006', '188634000', '188635004', '188637007', '188640007', '188641006', '188642004',
        '188645002', '188648000', '188649008', '188651007', '188660004', '188662007', '188663002',
        '188664008', '188665009', '188666005', '188667001', '188668006', '188669003', '188718006',
        '188725004', '188726003', '188728002', '188729005', '188732008', '188733003', '188734009',
        '188736006', '188737002', '188738007', '188741003', '188744006', '188745007', '188746008',
        '188748009', '188754005', '188768003', '188770007', '189509003', '190030009', '190955000',
        '232075002', '236512004', '236513009', '239147000', '254792006', '255101006', '269475001',
        '269476000', '276815004', '276836002', '277473004', '277474005', '277545003', '277549009',
        '277550009', '277551008', '277567002', '277568007', '277569004', '277570003', '277571004',
        '277572006', '277573001', '277574007', '277575008', '277577000', '277580004', '277587001',
        '277589003', '277597005', '277601005', '277602003', '277604002', '277606000', '277609007',
        '277610002', '277611003', '277612005', '277613000', '277614006', '277615007', '277616008',
        '277617004', '277618009', '277619001', '277626001', '277627005', '277637000', '277642008',
        '277643003', '277651000', '277653002', '277654008', '277664004', '278051002', '278052009',
        '278189009', '278453007', '285420006', '285421005', '285422003', '285423008', '285424002',
        '285426000', '285428004', '285769009', '285776004', '285839005', '302841002', '302855005',
        '302856006', '303017006', '303055001', '303056000', '303057009', '307340003', '307341004',
        '307592006', '307617006', '307622006', '307633009', '307634003', '307635002', '307650006',
        '307651005', '308121000', '313427003', '359631009', '359640008', '359648001', '371012000',
        '371134001', '373168002', '397008008', '397009000', '397011009', '397013007', '397015000',
        '398623004', '400001003', '400122007', '402880009', '402881008', '402882001', '404106004',
        '404107008', '404108003', '404109006', '404110001', '404111002', '404112009', '404113004',
        '404114005', '404115006', '404116007', '404117003', '404118008', '404119000', '404121005',
        '404122003', '404123008', '404124002', '404127009', '404128004', '404129007', '404132005',
        '404133000', '404134006', '404135007', '404136008', '404137004', '404138009', '404139001',
        '404140004', '404142007', '404143002', '404144008', '404147001', '404148006', '404149003',
        '404150003', '404151004', '404152006', '404153001', '404154007', '404155008', '404157000',
        '404160007', '404169008', '413389003', '413441006', '413442004', '413537009', '413587002',
        '413656006', '413842007', '413843002', '413847001', '414166008', '414780005', '414785000',
        '414791003', '414825006', '415110002', '415112005', '415285009', '415286005', '415287001',
        '420302007', '420519005', '420788006', '420890002', '421246008', '421283008', '421418009',
        '421696004', '421835000', '422052002', '422172005', '422853008', '423294001', '425657001',
        '425688002', '425749006', '425869007', '425941003', '426071002', '426124006', '426217000',
        '426248008', '426336007', '426370008', '426642002', '426885008', '427056005', '427141003',
        '427642009', '427658007', '430338009', '440422002', '441313008', '441559006', '441962003',
        '442537007', '443487006', '444597005', '444910004', '444911000', '445105005', '445227008',
        '445269007', '445406001', '445448008', '445738007', '446643000', '447100004', '447596005',
        '447656001', '447658000', '447766003', '447805007', '447806008', '447989004', '448212009',
        '448213004', '448217003', '448220006', '448231003', '448254007', '448269008', '448317000',
        '448319002', '448354009', '448371005', '448372003', '448376000', '448384001', '448386004',
        '448387008', '448447004', '448465000', '448468003', '448560008', '448561007', '448607004',
        '448609001', '448663003', '448666006', '448672006', '448709005', '448738008', '448774004',
        '448865007', '448867004', '448995000', '449058008', '449059000', '449063007', '449065000',
        '449108003', '449173006', '449176003', '449177007', '449216004', '449217008', '449219006',
        '449220000', '449221001', '449222008', '449292003', '449307001', '449318001', '449386007',
        '449418000', '449419008', '450521000124109', '61291000119103', '61301000119102',
        '61311000119104', '61321000119106', '713325002', '713483007', '713516007', '713718006',
        '713897006', '714251006', '714463003', '715664005', '715950008', '716788007', '718195003',
        '718200007', '84811000119107', '84831000119102', '91855006', '91856007', '91857003',
        '91858008', '91860005', '91861009', '92508006', '92509003', '92510008', '92511007',
        '92512000', '92513005', '92515003', '92516002', '92811003', '92812005', '92813000',
        '92814006', '92818009', '93133006', '93134000', '93135004', '93136003', '93137007',
        '93138002', '93139005', '93140007', '93141006', '93143009', '93144003', '93145002',
        '93146001', '93147005', '93148000', '93149008', '93151007', '93152000', '93169003',
        '93182006', '93183001', '93184007', '93185008', '93186009', '93187000', '93188005',
        '93189002', '93190006', '93191005', '93192003', '93193008', '93194002', '93195001',
        '93196000', '93197009', '93198004', '93199007', '93200005', '93201009', '93202002',
        '93203007', '93204001', '93205000', '93206004', '93207008', '93208003', '93451002',
        '93487009', '93488004', '93489007', '93492006', '93493001', '93494007', '93495008',
        '93496009', '93497000', '93498005', '93500006', '93501005', '93505001', '93506000',
        '93507009', '93509007', '93510002', '93514006', '93515007', '93516008', '93518009',
        '93519001', '93520007', '93521006', '93522004', '93523009', '93524003', '93525002',
        '93526001', '93527005', '93528000', '93530003', '93531004', '93532006', '93533001',
        '93534007', '93536009', '93537000', '93541001', '93542008', '93543003', '93545005',
        '93546006', '93547002', '93548007', '93549004', '93550004', '93551000', '93552007',
        '93554008', '93555009', '93720005', '94071006', '94148006', '94686001', '94687005',
        '94688000', '94690004', '94707004', '94708009', '94709001', '94710006', '94711005',
        '94712003', '94714002', '94715001', '94716000', '94718004', '94719007', '95186006',
        '95187002', '95188007', '95192000', '95193005', '95194004', '95209008', '95210003',
        '95224004', '95225003', '95226002', '95230004', '95231000', '95260009', '95261008',
        '95263006', '95264000'
    }


class AllCancer(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1011'
    VALUE_SET_NAME = 'All Cancer'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'C000', 'C001', 'C002', 'C003', 'C004', 'C005', 'C006', 'C008', 'C009', 'C01', 'C020',
        'C021', 'C022', 'C023', 'C024', 'C028', 'C029', 'C030', 'C031', 'C039', 'C040', 'C041',
        'C048', 'C049', 'C050', 'C051', 'C052', 'C058', 'C059', 'C060', 'C061', 'C062', 'C0680',
        'C0689', 'C069', 'C07', 'C080', 'C081', 'C089', 'C090', 'C091', 'C098', 'C099', 'C100',
        'C101', 'C102', 'C103', 'C104', 'C108', 'C109', 'C110', 'C111', 'C112', 'C113', 'C118',
        'C119', 'C12', 'C130', 'C131', 'C132', 'C138', 'C139', 'C140', 'C142', 'C148', 'C153',
        'C154', 'C155', 'C158', 'C159', 'C160', 'C161', 'C162', 'C163', 'C164', 'C165', 'C166',
        'C168', 'C169', 'C170', 'C171', 'C172', 'C173', 'C178', 'C179', 'C180', 'C181', 'C182',
        'C183', 'C184', 'C185', 'C186', 'C187', 'C188', 'C189', 'C19', 'C20', 'C212', 'C218',
        'C220', 'C221', 'C222', 'C223', 'C224', 'C227', 'C228', 'C229', 'C23', 'C240', 'C241',
        'C248', 'C249', 'C250', 'C251', 'C252', 'C253', 'C254', 'C257', 'C258', 'C259', 'C260',
        'C261', 'C269', 'C300', 'C301', 'C310', 'C311', 'C312', 'C313', 'C318', 'C319', 'C320',
        'C321', 'C322', 'C323', 'C328', 'C329', 'C33', 'C3400', 'C3401', 'C3402', 'C3410', 'C3411',
        'C3412', 'C342', 'C3430', 'C3431', 'C3432', 'C3480', 'C3481', 'C3482', 'C3490', 'C3491',
        'C3492', 'C37', 'C380', 'C381', 'C382', 'C383', 'C384', 'C388', 'C390', 'C399', 'C4000',
        'C4001', 'C4002', 'C4010', 'C4011', 'C4012', 'C4020', 'C4021', 'C4022', 'C4030', 'C4031',
        'C4032', 'C4080', 'C4081', 'C4082', 'C4090', 'C4091', 'C4092', 'C410', 'C411', 'C412',
        'C413', 'C414', 'C419', 'C430', 'C4310', 'C4311', 'C4312', 'C4320', 'C4321', 'C4322',
        'C4330', 'C4331', 'C4339', 'C434', 'C4351', 'C4352', 'C4359', 'C4360', 'C4361', 'C4362',
        'C4370', 'C4371', 'C4372', 'C438', 'C439', 'C4400', 'C4401', 'C4402', 'C4409', 'C44101',
        'C44102', 'C44109', 'C44111', 'C44112', 'C44119', 'C44121', 'C44122', 'C44129', 'C44191',
        'C44192', 'C44199', 'C44201', 'C44202', 'C44209', 'C44211', 'C44212', 'C44219', 'C44221',
        'C44222', 'C44229', 'C44291', 'C44292', 'C44299', 'C44300', 'C44301', 'C44309', 'C44310',
        'C44311', 'C44319', 'C44320', 'C44321', 'C44329', 'C44390', 'C44391', 'C44399', 'C4440',
        'C4441', 'C4442', 'C4449', 'C44500', 'C44501', 'C44509', 'C44510', 'C44511', 'C44519',
        'C44520', 'C44521', 'C44529', 'C44590', 'C44591', 'C44599', 'C44601', 'C44602', 'C44609',
        'C44611', 'C44612', 'C44619', 'C44621', 'C44622', 'C44629', 'C44691', 'C44692', 'C44699',
        'C44701', 'C44702', 'C44709', 'C44711', 'C44712', 'C44719', 'C44721', 'C44722', 'C44729',
        'C44791', 'C44792', 'C44799', 'C4480', 'C4481', 'C4482', 'C4489', 'C4490', 'C4491',
        'C4492', 'C4499', 'C450', 'C451', 'C452', 'C457', 'C459', 'C460', 'C461', 'C462', 'C463',
        'C464', 'C4650', 'C4651', 'C4652', 'C467', 'C469', 'C470', 'C4710', 'C4711', 'C4712',
        'C4720', 'C4721', 'C4722', 'C473', 'C474', 'C475', 'C476', 'C478', 'C479', 'C480', 'C481',
        'C482', 'C488', 'C490', 'C4910', 'C4911', 'C4912', 'C4920', 'C4921', 'C4922', 'C493',
        'C494', 'C495', 'C496', 'C498', 'C499', 'C49A0', 'C49A1', 'C49A2', 'C49A3', 'C49A4',
        'C49A5', 'C49A9', 'C4A0', 'C4A10', 'C4A11', 'C4A12', 'C4A20', 'C4A21', 'C4A22', 'C4A30',
        'C4A31', 'C4A39', 'C4A4', 'C4A51', 'C4A52', 'C4A59', 'C4A60', 'C4A61', 'C4A62', 'C4A70',
        'C4A71', 'C4A72', 'C4A8', 'C4A9', 'C50011', 'C50012', 'C50019', 'C50021', 'C50022',
        'C50029', 'C50111', 'C50112', 'C50119', 'C50121', 'C50122', 'C50129', 'C50211', 'C50212',
        'C50219', 'C50221', 'C50222', 'C50229', 'C50311', 'C50312', 'C50319', 'C50321', 'C50322',
        'C50329', 'C50411', 'C50412', 'C50419', 'C50421', 'C50422', 'C50429', 'C50511', 'C50512',
        'C50519', 'C50521', 'C50522', 'C50529', 'C50611', 'C50612', 'C50619', 'C50621', 'C50622',
        'C50629', 'C50811', 'C50812', 'C50819', 'C50821', 'C50822', 'C50829', 'C50911', 'C50912',
        'C50919', 'C50921', 'C50922', 'C50929', 'C510', 'C511', 'C512', 'C518', 'C519', 'C52',
        'C530', 'C531', 'C538', 'C539', 'C540', 'C541', 'C542', 'C543', 'C548', 'C549', 'C55',
        'C561', 'C562', 'C569', 'C5700', 'C5701', 'C5702', 'C5710', 'C5711', 'C5712', 'C5720',
        'C5721', 'C5722', 'C573', 'C574', 'C577', 'C578', 'C579', 'C58', 'C600', 'C601', 'C602',
        'C608', 'C609', 'C61', 'C6200', 'C6201', 'C6202', 'C6210', 'C6211', 'C6212', 'C6290',
        'C6291', 'C6292', 'C6300', 'C6301', 'C6302', 'C6310', 'C6311', 'C6312', 'C632', 'C637',
        'C638', 'C639', 'C641', 'C642', 'C649', 'C651', 'C652', 'C659', 'C661', 'C662', 'C669',
        'C670', 'C671', 'C672', 'C673', 'C674', 'C675', 'C676', 'C677', 'C678', 'C679', 'C680',
        'C681', 'C688', 'C689', 'C6900', 'C6901', 'C6902', 'C6910', 'C6911', 'C6912', 'C6920',
        'C6921', 'C6922', 'C6930', 'C6931', 'C6932', 'C6940', 'C6941', 'C6942', 'C6950', 'C6951',
        'C6952', 'C6960', 'C6961', 'C6962', 'C6980', 'C6981', 'C6982', 'C6990', 'C6991', 'C6992',
        'C700', 'C701', 'C709', 'C710', 'C711', 'C712', 'C713', 'C714', 'C715', 'C716', 'C717',
        'C718', 'C719', 'C720', 'C721', 'C7220', 'C7221', 'C7222', 'C7230', 'C7231', 'C7232',
        'C7240', 'C7241', 'C7242', 'C7250', 'C7259', 'C729', 'C73', 'C7400', 'C7401', 'C7402',
        'C7410', 'C7411', 'C7412', 'C7490', 'C7491', 'C7492', 'C750', 'C751', 'C752', 'C753',
        'C754', 'C755', 'C758', 'C759', 'C760', 'C761', 'C762', 'C763', 'C7640', 'C7641', 'C7642',
        'C7650', 'C7651', 'C7652', 'C768', 'C770', 'C771', 'C772', 'C773', 'C774', 'C775', 'C778',
        'C779', 'C7800', 'C7801', 'C7802', 'C781', 'C782', 'C7830', 'C7839', 'C784', 'C785',
        'C786', 'C787', 'C7880', 'C7889', 'C7900', 'C7901', 'C7902', 'C7910', 'C7911', 'C7919',
        'C792', 'C7931', 'C7932', 'C7940', 'C7949', 'C7951', 'C7952', 'C7960', 'C7961', 'C7962',
        'C7970', 'C7971', 'C7972', 'C7981', 'C7982', 'C7989', 'C799', 'C7A00', 'C7A010', 'C7A011',
        'C7A012', 'C7A019', 'C7A020', 'C7A021', 'C7A022', 'C7A023', 'C7A024', 'C7A025', 'C7A026',
        'C7A029', 'C7A090', 'C7A091', 'C7A092', 'C7A093', 'C7A094', 'C7A095', 'C7A096', 'C7A098',
        'C7A1', 'C7A8', 'C7B00', 'C7B01', 'C7B02', 'C7B03', 'C7B04', 'C7B09', 'C7B1', 'C7B8',
        'C800', 'C801', 'C802', 'C8100', 'C8101', 'C8102', 'C8103', 'C8104', 'C8105', 'C8106',
        'C8107', 'C8108', 'C8109', 'C8110', 'C8111', 'C8112', 'C8113', 'C8114', 'C8115', 'C8116',
        'C8117', 'C8118', 'C8119', 'C8120', 'C8121', 'C8122', 'C8123', 'C8124', 'C8125', 'C8126',
        'C8127', 'C8128', 'C8129', 'C8130', 'C8131', 'C8132', 'C8133', 'C8134', 'C8135', 'C8136',
        'C8137', 'C8138', 'C8139', 'C8140', 'C8141', 'C8142', 'C8143', 'C8144', 'C8145', 'C8146',
        'C8147', 'C8148', 'C8149', 'C8170', 'C8171', 'C8172', 'C8173', 'C8174', 'C8175', 'C8176',
        'C8177', 'C8178', 'C8179', 'C8190', 'C8191', 'C8192', 'C8193', 'C8194', 'C8195', 'C8196',
        'C8197', 'C8198', 'C8199', 'C8200', 'C8201', 'C8202', 'C8203', 'C8204', 'C8205', 'C8206',
        'C8207', 'C8208', 'C8209', 'C8210', 'C8211', 'C8212', 'C8213', 'C8214', 'C8215', 'C8216',
        'C8217', 'C8218', 'C8219', 'C8220', 'C8221', 'C8222', 'C8223', 'C8224', 'C8225', 'C8226',
        'C8227', 'C8228', 'C8229', 'C8230', 'C8231', 'C8232', 'C8233', 'C8234', 'C8235', 'C8236',
        'C8237', 'C8238', 'C8239', 'C8240', 'C8241', 'C8242', 'C8243', 'C8244', 'C8245', 'C8246',
        'C8247', 'C8248', 'C8249', 'C8250', 'C8251', 'C8252', 'C8253', 'C8254', 'C8255', 'C8256',
        'C8257', 'C8258', 'C8259', 'C8260', 'C8261', 'C8262', 'C8263', 'C8264', 'C8265', 'C8266',
        'C8267', 'C8268', 'C8269', 'C8280', 'C8281', 'C8282', 'C8283', 'C8284', 'C8285', 'C8286',
        'C8287', 'C8288', 'C8289', 'C8290', 'C8291', 'C8292', 'C8293', 'C8294', 'C8295', 'C8296',
        'C8297', 'C8298', 'C8299', 'C8300', 'C8301', 'C8302', 'C8303', 'C8304', 'C8305', 'C8306',
        'C8307', 'C8308', 'C8309', 'C8310', 'C8311', 'C8312', 'C8313', 'C8314', 'C8315', 'C8316',
        'C8317', 'C8318', 'C8319', 'C8330', 'C8331', 'C8332', 'C8333', 'C8334', 'C8335', 'C8336',
        'C8337', 'C8338', 'C8339', 'C8350', 'C8351', 'C8352', 'C8353', 'C8354', 'C8355', 'C8356',
        'C8357', 'C8358', 'C8359', 'C8370', 'C8371', 'C8372', 'C8373', 'C8374', 'C8375', 'C8376',
        'C8377', 'C8378', 'C8379', 'C8380', 'C8381', 'C8382', 'C8383', 'C8384', 'C8385', 'C8386',
        'C8387', 'C8388', 'C8389', 'C8390', 'C8391', 'C8392', 'C8393', 'C8394', 'C8395', 'C8396',
        'C8397', 'C8398', 'C8399', 'C8400', 'C8401', 'C8402', 'C8403', 'C8404', 'C8405', 'C8406',
        'C8407', 'C8408', 'C8409', 'C8410', 'C8411', 'C8412', 'C8413', 'C8414', 'C8415', 'C8416',
        'C8417', 'C8418', 'C8419', 'C8440', 'C8441', 'C8442', 'C8443', 'C8444', 'C8445', 'C8446',
        'C8447', 'C8448', 'C8449', 'C8460', 'C8461', 'C8462', 'C8463', 'C8464', 'C8465', 'C8466',
        'C8467', 'C8468', 'C8469', 'C8470', 'C8471', 'C8472', 'C8473', 'C8474', 'C8475', 'C8476',
        'C8477', 'C8478', 'C8479', 'C8490', 'C8491', 'C8492', 'C8493', 'C8494', 'C8495', 'C8496',
        'C8497', 'C8498', 'C8499', 'C84A0', 'C84A1', 'C84A2', 'C84A3', 'C84A4', 'C84A5', 'C84A6',
        'C84A7', 'C84A8', 'C84A9', 'C84Z0', 'C84Z1', 'C84Z2', 'C84Z3', 'C84Z4', 'C84Z5', 'C84Z6',
        'C84Z7', 'C84Z8', 'C84Z9', 'C8510', 'C8511', 'C8512', 'C8513', 'C8514', 'C8515', 'C8516',
        'C8517', 'C8518', 'C8519', 'C8520', 'C8521', 'C8522', 'C8523', 'C8524', 'C8525', 'C8526',
        'C8527', 'C8528', 'C8529', 'C8580', 'C8581', 'C8582', 'C8583', 'C8584', 'C8585', 'C8586',
        'C8587', 'C8588', 'C8589', 'C8590', 'C8591', 'C8592', 'C8593', 'C8594', 'C8595', 'C8596',
        'C8597', 'C8598', 'C8599', 'C860', 'C861', 'C862', 'C863', 'C864', 'C865', 'C866', 'C882',
        'C883', 'C884', 'C888', 'C889', 'C9000', 'C9001', 'C9002', 'C9010', 'C9011', 'C9012',
        'C9020', 'C9021', 'C9022', 'C9030', 'C9031', 'C9032', 'C9100', 'C9101', 'C9102', 'C9110',
        'C9111', 'C9112', 'C9130', 'C9131', 'C9132', 'C9140', 'C9141', 'C9142', 'C9150', 'C9151',
        'C9152', 'C9160', 'C9161', 'C9162', 'C9190', 'C9191', 'C9192', 'C91A0', 'C91A1', 'C91A2',
        'C91Z0', 'C91Z1', 'C91Z2', 'C9200', 'C9201', 'C9202', 'C9210', 'C9211', 'C9212', 'C9220',
        'C9221', 'C9222', 'C9230', 'C9231', 'C9232', 'C9240', 'C9241', 'C9242', 'C9250', 'C9251',
        'C9252', 'C9260', 'C9261', 'C9262', 'C9290', 'C9291', 'C9292', 'C92A0', 'C92A1', 'C92A2',
        'C92Z0', 'C92Z1', 'C92Z2', 'C9300', 'C9301', 'C9302', 'C9310', 'C9311', 'C9312', 'C9330',
        'C9331', 'C9332', 'C9390', 'C9391', 'C9392', 'C93Z0', 'C93Z1', 'C93Z2', 'C9400', 'C9401',
        'C9402', 'C9420', 'C9421', 'C9422', 'C9430', 'C9431', 'C9432', 'C9440', 'C9441', 'C9442',
        'C946', 'C9480', 'C9481', 'C9482', 'C9500', 'C9501', 'C9502', 'C9510', 'C9511', 'C9512',
        'C9590', 'C9591', 'C9592', 'C960', 'C962', 'C964', 'C965', 'C966', 'C969', 'C96A', 'C96Z',
        'D030', 'D0310', 'D0311', 'D0312', 'D0320', 'D0321', 'D0322', 'D0330', 'D0339', 'D034',
        'D0351', 'D0352', 'D0359', 'D0360', 'D0361', 'D0362', 'D0370', 'D0371', 'D0372', 'D038',
        'D039', 'D47Z2', 'D49511', 'D49512', 'D49519', 'D4959'
    }

    ICD9CM = {
        '1400', '1401', '1403', '1404', '1405', '1406', '1408', '1409', '1410', '1411', '1412',
        '1413', '1414', '1415', '1416', '1418', '1419', '1420', '1421', '1422', '1428', '1429',
        '1430', '1431', '1438', '1439', '1440', '1441', '1448', '1449', '1450', '1451', '1452',
        '1453', '1454', '1455', '1456', '1458', '1459', '1460', '1461', '1462', '1463', '1464',
        '1465', '1466', '1467', '1468', '1469', '1470', '1471', '1472', '1473', '1478', '1479',
        '1480', '1481', '1482', '1483', '1488', '1489', '1490', '1491', '1498', '1499', '1500',
        '1501', '1502', '1503', '1504', '1505', '1508', '1509', '1510', '1511', '1512', '1513',
        '1514', '1515', '1516', '1518', '1519', '1520', '1521', '1522', '1523', '1528', '1529',
        '1530', '1531', '1532', '1533', '1534', '1535', '1536', '1537', '1538', '1539', '1540',
        '1541', '1548', '1550', '1551', '1552', '1560', '1561', '1562', '1568', '1569', '1570',
        '1571', '1572', '1573', '1574', '1578', '1579', '1580', '1588', '1589', '1590', '1591',
        '1598', '1599', '1600', '1601', '1602', '1603', '1604', '1605', '1608', '1609', '1610',
        '1611', '1612', '1613', '1618', '1619', '1620', '1622', '1623', '1624', '1625', '1628',
        '1629', '1630', '1631', '1638', '1639', '1640', '1641', '1642', '1643', '1648', '1649',
        '1650', '1658', '1659', '1700', '1701', '1702', '1703', '1704', '1705', '1706', '1707',
        '1708', '1709', '1710', '1712', '1713', '1714', '1715', '1716', '1717', '1718', '1719',
        '1720', '1721', '1722', '1723', '1724', '1725', '1726', '1727', '1728', '1729', '17300',
        '17301', '17302', '17309', '17310', '17311', '17312', '17319', '17320', '17321', '17322',
        '17329', '17330', '17331', '17332', '17339', '17340', '17341', '17342', '17349', '17350',
        '17351', '17352', '17359', '17360', '17361', '17362', '17369', '17370', '17371', '17372',
        '17379', '17380', '17381', '17382', '17389', '17390', '17391', '17392', '17399', '1740',
        '1741', '1742', '1743', '1744', '1745', '1746', '1748', '1749', '1750', '1759', '1760',
        '1761', '1762', '1763', '1764', '1765', '1768', '1769', '179', '1800', '1801', '1808',
        '1809', '181', '1820', '1821', '1828', '1830', '1832', '1833', '1834', '1835', '1838',
        '1839', '1840', '1841', '1842', '1843', '1844', '1848', '1849', '185', '1860', '1869',
        '1871', '1872', '1873', '1874', '1875', '1876', '1877', '1878', '1879', '1880', '1881',
        '1882', '1883', '1884', '1885', '1886', '1887', '1888', '1889', '1890', '1891', '1892',
        '1893', '1894', '1898', '1899', '1900', '1901', '1902', '1903', '1904', '1905', '1906',
        '1907', '1908', '1909', '1910', '1911', '1912', '1913', '1914', '1915', '1916', '1917',
        '1918', '1919', '1920', '1921', '1922', '1923', '1928', '1929', '1940', '1941', '1943',
        '1944', '1945', '1946', '1948', '1949', '1950', '1951', '1952', '1953', '1954', '1955',
        '1958', '1960', '1961', '1962', '1963', '1965', '1966', '1968', '1969', '1975', '20000',
        '20001', '20002', '20003', '20004', '20005', '20006', '20007', '20008', '20010', '20011',
        '20012', '20013', '20014', '20015', '20016', '20017', '20018', '20020', '20021', '20022',
        '20023', '20024', '20025', '20026', '20027', '20028', '20030', '20031', '20032', '20033',
        '20034', '20035', '20036', '20037', '20038', '20040', '20041', '20042', '20043', '20044',
        '20045', '20046', '20047', '20048', '20050', '20051', '20052', '20053', '20054', '20055',
        '20056', '20057', '20058', '20060', '20061', '20062', '20063', '20064', '20065', '20066',
        '20067', '20068', '20070', '20071', '20072', '20073', '20074', '20075', '20076', '20077',
        '20078', '20080', '20081', '20082', '20083', '20084', '20085', '20086', '20087', '20088',
        '20100', '20101', '20102', '20103', '20104', '20105', '20106', '20107', '20108', '20110',
        '20111', '20112', '20113', '20114', '20115', '20116', '20117', '20118', '20120', '20121',
        '20122', '20123', '20124', '20125', '20126', '20127', '20128', '20140', '20141', '20142',
        '20143', '20144', '20145', '20146', '20147', '20148', '20150', '20151', '20152', '20153',
        '20154', '20155', '20156', '20157', '20158', '20160', '20161', '20162', '20163', '20164',
        '20165', '20166', '20167', '20168', '20170', '20171', '20172', '20173', '20174', '20175',
        '20176', '20177', '20178', '20190', '20191', '20192', '20193', '20194', '20195', '20196',
        '20197', '20198', '20200', '20201', '20202', '20203', '20204', '20205', '20206', '20207',
        '20208', '20210', '20211', '20212', '20213', '20214', '20215', '20216', '20217', '20218',
        '20220', '20221', '20222', '20223', '20224', '20225', '20226', '20227', '20228', '20230',
        '20231', '20232', '20233', '20234', '20235', '20236', '20237', '20238', '20240', '20241',
        '20242', '20243', '20244', '20245', '20246', '20247', '20248', '20250', '20251', '20252',
        '20253', '20254', '20255', '20256', '20257', '20258', '20260', '20261', '20262', '20263',
        '20264', '20265', '20266', '20267', '20268', '20270', '20271', '20272', '20273', '20274',
        '20275', '20276', '20277', '20278', '20280', '20281', '20282', '20283', '20284', '20285',
        '20286', '20287', '20288', '20290', '20291', '20292', '20293', '20294', '20295', '20296',
        '20297', '20298', '20300', '20301', '20302', '20310', '20311', '20312', '20380', '20381',
        '20382', '20400', '20401', '20410', '20411', '20420', '20421', '20480', '20481', '20490',
        '20491', '20500', '20501', '20510', '20511', '20520', '20521', '20530', '20531', '20580',
        '20581', '20590', '20591', '20600', '20601', '20610', '20611', '20620', '20621', '20680',
        '20681', '20690', '20691', '20700', '20701', '20710', '20711', '20720', '20721', '20780',
        '20781', '20800', '20801', '20810', '20811', '20820', '20821', '20880', '20881', '20890'
    }

    SNOMEDCT = {
        '109267002', '109348004', '109350007', '109351006', '109365008', '109366009', '109367000',
        '109368005', '109369002', '109370001', '109371002', '109374005', '109383000', '109384006',
        '109388009', '109390005', '109391009', '109822001', '109823006', '109824000', '109828002',
        '109830000', '109831001', '109832008', '109835005', '109836006', '109838007', '109839004',
        '109840002', '109851002', '109853004', '109854005', '109855006', '109856007', '109857003',
        '109858008', '109870007', '109874003', '109875002', '109876001', '109878000', '109879008',
        '109880006', '109882003', '109886000', '109911004', '109912006', '109915008', '109941002',
        '109948008', '109951001', '109962001', '109964000', '109965004', '109966003', '109967007',
        '109968002', '109969005', '109970006', '109971005', '109972003', '109975001', '109976000',
        '109977009', '109978004', '109979007', '109980005', '109988003', '109989006', '110002002',
        '110004001', '110005000', '110006004', '110007008', '110013004', '116711000119103',
        '116741000119104', '116811000119106', '116821000119104', '117061000119101',
        '117091000119108', '117111000119100', '118599009', '118600007', '118601006', '118602004',
        '118605002', '118606001', '118607005', '118608000', '118609008', '118610003', '118611004',
        '118612006', '118613001', '118614007', '118615008', '118618005', '122511000119103',
        '123721000119108', '123842006', '126948004', '127070008', '127213008', '127214002',
        '127220001', '127225006', '128874001', '128875000', '129000002', '13048006',
        '133751000119102', '134312002', '1701000119104', '187601000', '187604008', '187606005',
        '187608006', '187613005', '187614004', '187622006', '187624007', '187631006', '187634003',
        '187635002', '187637005', '187640005', '187641009', '187644001', '187652003', '187653008',
        '187658004', '187659007', '187660002', '187661003', '187662005', '187666008', '187675005',
        '187681002', '187682009', '187683004', '187685006', '187688008', '187692001', '187693006',
        '187694000', '187697007', '187698002', '187700006', '187701005', '187702003', '187708004',
        '187709007', '187716008', '187722004', '187723009', '187724003', '187725002', '187726001',
        '187727005', '187732006', '187733001', '187734007', '187736009', '187738005', '187740000',
        '187741001', '187742008', '187757001', '187758006', '187786003', '187794005', '187801002',
        '187803004', '187807003', '187808008', '187809000', '187810005', '187811009', '187814001',
        '187822008', '187829004', '187830009', '187831008', '187833006', '187834000', '187835004',
        '187836003', '187838002', '187841006', '187842004', '187843009', '187844003', '187845002',
        '187846001', '187853005', '187854004', '187857006', '187861000', '187862007', '187864008',
        '187865009', '187866005', '187868006', '187869003', '187870002', '187881004', '187900002',
        '187903000', '187906008', '187916000', '187917009', '187918004', '187920001', '187925006',
        '187926007', '187927003', '187929000', '187932002', '187937008', '187938003', '187939006',
        '187940008', '187941007', '187942000', '187943005', '187944004', '187945003', '187946002',
        '187947006', '187948001', '187949009', '187950009', '187952001', '187956003', '187957007',
        '187967002', '187968007', '187969004', '187970003', '187972006', '187973001', '187974007',
        '187975008', '187976009', '187977000', '187978005', '187988006', '188010006', '188013008',
        '188030005', '188033007', '188049009', '188071004', '188072006', '188095002', '188107002',
        '188147009', '188151006', '188152004', '188153009', '188154003', '188155002', '188156001',
        '188159008', '188176007', '188177003', '188180002', '188183000', '188184006', '188189001',
        '188190005', '188191009', '188192002', '188193007', '188195000', '188196004', '188198003',
        '188204000', '188209005', '188219004', '188220005', '188230001', '188234005', '188235006',
        '188239000', '188240003', '188241004', '188242006', '188243001', '188244007', '188245008',
        '188247000', '188250002', '188251003', '188252005', '188253000', '188256008', '188261005',
        '188263008', '188264002', '188265001', '188266000', '188268004', '188269007', '188272000',
        '188273005', '188274004', '188280007', '188281006', '188282004', '188283009', '188285002',
        '188286001', '188287005', '188289008', '188290004', '188292007', '188293002', '188295009',
        '188296005', '188297001', '188298006', '188301005', '188302003', '188308004', '188312005',
        '188313000', '188315007', '188317004', '188318009', '188319001', '188325002', '188339002',
        '188340000', '188361007', '188487008', '188489006', '188492005', '188493000', '188498009',
        '188500005', '188501009', '188502002', '188503007', '188504001', '188505000', '188506004',
        '188507008', '188510001', '188511002', '188512009', '188513004', '188514005', '188515006',
        '188516007', '188517003', '188524002', '188526000', '188529007', '188531003', '188534006',
        '188536008', '188537004', '188538009', '188541000', '188544008', '188547001', '188548006',
        '188551004', '188554007', '188558005', '188559002', '188562004', '188565002', '188566001',
        '188567005', '188568000', '188569008', '188570009', '188572001', '188575004', '188576003',
        '188577007', '188578002', '188579005', '188580008', '188582000', '188585003', '188586002',
        '188587006', '188589009', '188590000', '188591001', '188592008', '188593003', '188609000',
        '188612002', '188613007', '188627002', '188630009', '188631008', '188632001', '188633006',
        '188634000', '188635004', '188637007', '188640007', '188641006', '188642004', '188645002',
        '188648000', '188649008', '188651007', '188660004', '188662007', '188663002', '188664008',
        '188665009', '188666005', '188667001', '188668006', '188669003', '188718006', '188725004',
        '188726003', '188728002', '188729005', '188732008', '188733003', '188734009', '188736006',
        '188737002', '188738007', '188741003', '188744006', '188745007', '188746008', '188748009',
        '188754005', '188768003', '188770007', '189164002', '189397006', '189406008', '189509003',
        '190030009', '190955000', '22288000', '223003', '230156002', '231829006', '231830001',
        '231831002', '231832009', '231833004', '231834005', '231835006', '232075002', '233854003',
        '233855002', '235686008', '236512004', '236513009', '237719001', '237795006', '239132009',
        '239147000', '240163000', '241861008', '252991009', '253003009', '254389005', '254390001',
        '254393004', '254398008', '254402004', '254404003', '254408000', '254412006', '254417000',
        '254423005', '254424004', '254425003', '254427006', '254431000', '254434008', '254435009',
        '254437001', '254441002', '254445006', '254450000', '254454009', '254457002', '254459004',
        '254462001', '254465004', '254466003', '254478004', '254481009', '254484001', '254501009',
        '254503007', '254509006', '254513004', '254517003', '254520006', '254526000', '254530002',
        '254535007', '254539001', '254543002', '254547001', '254549003', '254551004', '254553001',
        '254555008', '254557000', '254559002', '254561006', '254563009', '254567005', '254570009',
        '254574000', '254586002', '254609000', '254611009', '254612002', '254613007', '254615000',
        '254619006', '254620000', '254621001', '254622008', '254625005', '254626006', '254627002',
        '254628007', '254629004', '254630009', '254631008', '254632001', '254633006', '254634000',
        '254635004', '254637007', '254638002', '254641006', '254643009', '254644003', '254645002',
        '254730000', '254731001', '254732008', '254733003', '254734009', '254792006', '254849005',
        '254850005', '254851009', '254852002', '254856004', '254860001', '254861002', '254863004',
        '254864005', '254866007', '254867003', '254868008', '254869000', '254870004', '254871000',
        '254872007', '254874008', '254876005', '254877001', '254878006', '254883003', '254886006',
        '254887002', '254888007', '254889004', '254893005', '254894004', '254900004', '254901000',
        '254904008', '254908006', '254909003', '254912000', '254915003', '254916002', '254917006',
        '254918001', '254919009', '254920003', '254921004', '254922006', '254923001', '254934003',
        '254936001', '254937005', '254938000', '254940005', '254941009', '254944001', '254945000',
        '254946004', '254947008', '254948003', '254950006', '254951005', '254953008', '254954002',
        '254955001', '254956000', '254957009', '254958004', '254959007', '254960002', '254961003',
        '254962005', '254963000', '254964006', '254965007', '254966008', '254968009', '254969001',
        '254972008', '254973003', '254974009', '254975005', '254976006', '254978007', '254979004',
        '254987003', '254988008', '254989000', '254990009', '254993006', '254994000', '254995004',
        '254996003', '254997007', '254998002', '254999005', '255000005', '255003007', '255004001',
        '255008003', '255012009', '255015006', '255016007', '255017003', '255021005', '255028004',
        '255029007', '255030002', '255031003', '255032005', '255034006', '255035007', '255037004',
        '255044008', '255067005', '255070009', '255071008', '255072001', '255074000', '255075004',
        '255076003', '255078002', '255083005', '255084004', '255090000', '255091001', '255101006',
        '255108000', '255109008', '255110003', '255111004', '255112006', '255114007', '255115008',
        '255119002', '255121007', '255123005', '264906008', '269459004', '269460009', '269462001',
        '269463006', '269464000', '269467007', '269468002', '269475001', '269476000', '269515006',
        '269516007', '269533000', '269544008', '269581007', '271568003', '271943005', '274084007',
        '274085008', '274087000', '275394001', '275395000', '275396004', '275397008', '275399006',
        '275490009', '276419004', '276420005', '276751004', '276803003', '276804009', '276808007',
        '276809004', '276810009', '276811008', '276815004', '276821000', '276826005', '276827001',
        '276828006', '276829003', '276836002', '276852004', '276860003', '276870001', '276871002',
        '276872009', '276876007', '276952000', '276953005', '276954004', '276962007', '276968006',
        '276975007', '277456001', '277461004', '277473004', '277474005', '277505007', '277507004',
        '277508009', '277523004', '277526007', '277527003', '277530005', '277545003', '277549009',
        '277550009', '277551008', '277567002', '277568007', '277569004', '277570003', '277571004',
        '277572006', '277573001', '277574007', '277575008', '277577000', '277580004', '277587001',
        '277589003', '277597005', '277601005', '277602003', '277604002', '277606000', '277609007',
        '277610002', '277611003', '277612005', '277613000', '277614006', '277615007', '277616008',
        '277617004', '277618009', '277619001', '277626001', '277627005', '277637000', '277642008',
        '277643003', '277651000', '277653002', '277654008', '277664004', '277782009', '278024000',
        '278042005', '278043000', '278044006', '278046008', '278051002', '278052009', '278055006',
        '278057003', '278060005', '278189009', '278453007', '278491007', '280116003', '280959007',
        '28122003', '281560004', '281561000', '281562007', '281563002', '281566005', '281702006',
        '285307007', '285308002', '285309005', '285310000', '285311001', '285312008', '285420006',
        '285421005', '285422003', '285423008', '285424002', '285426000', '285428004', '285432005',
        '285598005', '285603002', '285604008', '285605009', '285606005', '285607001', '285608006',
        '285611007', '285616002', '285618001', '285619009', '285634003', '285635002', '285636001',
        '285637005', '285639008', '285640005', '285641009', '285642002', '285643007', '285644001',
        '285769009', '285776004', '285836003', '285838002', '285839005', '286889008', '286890004',
        '286900008', '300988009', '301756000', '302815008', '302820008', '302823005', '302824004',
        '302826002', '302837001', '302841002', '302849000', '302855005', '302856006', '303012000',
        '303017006', '303055001', '303056000', '303057009', '303194003', '303201005', '30664006',
        '307216009', '307340003', '307341004', '307502000', '307576001', '307592006', '307601000',
        '307603002', '307604008', '307605009', '307606005', '307607001', '307608006', '307609003',
        '307617006', '307618001', '307622006', '307633009', '307634003', '307635002', '307649006',
        '307650006', '307651005', '308006', '308121000', '309245001', '310599006', '312111009',
        '312112002', '312113007', '312114001', '312115000', '312949007', '313248004', '313249007',
        '313353007', '313354001', '313355000', '313356004', '313357008', '313427003', '313428008',
        '313429000', '31383003', '314191009', '314408000', '314418005', '314419002', '314947008',
        '314951005', '314952003', '314953008', '314954002', '314960002', '314961003', '314965007',
        '314967004', '314968009', '314969001', '314970000', '314973003', '314976006', '315058005',
        '359631009', '359640008', '359648001', '359782004', '359785002', '359987004', '363348004',
        '363349007', '363352004', '363354003', '363355002', '363358000', '363359008', '363360003',
        '363365008', '363370001', '363372009', '363373004', '363374005', '363375006', '363376007',
        '363377003', '363378008', '363379000', '363380002', '363381003', '363382005', '363383000',
        '363384006', '363385007', '363386008', '363387004', '363388009', '363389001', '363390005',
        '363391009', '363392002', '363393007', '363394001', '363395000', '363397008', '363398003',
        '363399006', '363400004', '363401000', '363402007', '363403002', '363406005', '363407001',
        '363408006', '363409003', '363410008', '363412000', '363413005', '363414004', '363417006',
        '363421004', '363422006', '363423001', '363424007', '363425008', '363426009', '363427000',
        '363428005', '363429002', '363430007', '363431006', '363432004', '363433009', '363434003',
        '363435002', '363436001', '363437005', '363438000', '363443007', '363444001', '363445000',
        '363446004', '363447008', '363449006', '363451005', '363452003', '363453008', '363454002',
        '363456000', '363457009', '363458004', '363459007', '363460002', '363461003', '363462005',
        '363463000', '363464006', '363465007', '363466008', '363467004', '363468009', '363469001',
        '363470000', '363471001', '363473003', '363474009', '363475005', '363476006', '363478007',
        '363481002', '363482009', '363483004', '363485006', '363486007', '363487003', '363488008',
        '363490009', '363491008', '363492001', '363493006', '363494000', '363497007', '363498002',
        '363502009', '363506007', '363507003', '363510005', '363514001', '363515000', '363516004',
        '363517008', '363518003', '369463005', '369464004', '369465003', '369466002', '369467006',
        '369468001', '369469009', '369470005', '369471009', '369472002', '369475000', '369476004',
        '369477008', '369478003', '369479006', '369480009', '369481008', '369482001', '369484000',
        '369485004', '369486003', '369487007', '369489005', '369490001', '369491002', '369492009',
        '369493004', '369494005', '369495006', '369496007', '369497003', '369498008', '369499000',
        '369500009', '369501008', '369502001', '369503006', '369504000', '369505004', '369506003',
        '369512008', '369513003', '369515005', '369516006', '369517002', '369518007', '369519004',
        '369520005', '369522002', '369524001', '369525000', '369526004', '369527008', '369528003',
        '369529006', '369531002', '369532009', '369533004', '369534005', '369537003', '369538008',
        '369539000', '369540003', '369541004', '369547000', '369548005', '369549002', '369550002',
        '369551003', '369552005', '369559001', '369566000', '369567009', '369574004', '369575003',
        '369576002', '369577006', '369578001', '369579009', '369580007', '370967009', '370987005',
        '371012000', '371134001', '371962007', '371963002', '371964008', '371965009', '371966005',
        '371967001', '371968006', '371969003', '371971003', '371972005', '371973000', '371974006',
        '371975007', '371976008', '371978009', '371979001', '371980003', '371981004', '371982006',
        '371983001', '371984007', '371986009', '371987000', '371988005', '371989002', '371990006',
        '371991005', '371993008', '371994002', '371995001', '371996000', '371997009', '371998004',
        '371999007', '372000001', '372001002', '372002009', '372004005', '372005006', '372006007',
        '372008008', '372009000', '372013007', '372014001', '372015000', '372016004', '372017008',
        '372018003', '372019006', '372020000', '372021001', '372022008', '372024009', '372025005',
        '372026006', '372027002', '372028007', '372030009', '372062007', '372064008', '372065009',
        '372097009', '372098004', '372099007', '372100004', '372103002', '372104008', '372105009',
        '372106005', '372107001', '372108006', '372110008', '372111007', '372112000', '372113005',
        '372115003', '372116002', '372120003', '372121004', '372131006', '372133009', '372135002',
        '372136001', '372138000', '372141009', '372143007', '373168002', '373627005', '385478001',
        '388871003', '396198006', '397008008', '397009000', '397011009', '397013007', '397015000',
        '398623004', '398679002', '398768004', '398831006', '399068003', '399326009', '399490008',
        '399590005', '399660006', '399967006', '400001003', '400092004', '400118002', '400122007',
        '401312001', '401313006', '402494003', '402495002', '402496001', '402503002', '402504008',
        '402505009', '402506005', '402507001', '402515003', '402819001', '402880009', '402881008',
        '402882001', '403467008', '403468003', '403714009', '403889000', '403919005', '403926005',
        '403950007', '404090003', '404094007', '404106004', '404107008', '404108003', '404109006',
        '404110001', '404111002', '404112009', '404113004', '404114005', '404115006', '404116007',
        '404117003', '404118008', '404119000', '404121005', '404122003', '404123008', '404124002',
        '404127009', '404128004', '404129007', '404132005', '404133000', '404134006', '404135007',
        '404136008', '404137004', '404138009', '404139001', '404140004', '404142007', '404143002',
        '404144008', '404147001', '404148006', '404149003', '404150003', '404151004', '404152006',
        '404153001', '404154007', '404155008', '404157000', '404160007', '404169008', '404653000',
        '404662003', '404664002', '405546008', '405822008', '405945003', '408642003', '408644002',
        '408647009', '408648004', '408649007', '413389003', '413441006', '413442004', '4135001',
        '413537009', '413587002', '413656006', '413842007', '413843002', '413847001', '414166008',
        '414250001', '414626005', '414666009', '414676007', '414780005', '414785000', '414791003',
        '414825006', '414950005', '415110002', '415112005', '415285009', '415286005', '415287001',
        '415653001', '416274001', '416351002', '416510003', '416712009', '416753001', '416842003',
        '416901002', '417417007', '417554000', '417619001', '418134006', '418372008', '419052002',
        '419240004', '419317000', '419327006', '419842002', '419889000', '420302007', '420519005',
        '420788006', '420835009', '420890002', '421246008', '421249001', '421283008', '421418009',
        '421696004', '421835000', '422052002', '422172005', '422541001', '422691006', '422758009',
        '422782004', '422833009', '422853008', '422886007', '422968005', '423005002', '423032007',
        '423038006', '423050000', '423106003', '423121009', '423158009', '423189008', '423195009',
        '423278008', '423280002', '423294001', '423295000', '423424005', '423425006', '423447006',
        '423464009', '423468007', '423494003', '423600008', '423607006', '423615009', '423619003',
        '423627007', '423673009', '423691004', '423708008', '423973006', '423987006', '424132000',
        '424151006', '424260006', '424276002', '424302003', '424334007', '424408000', '424422000',
        '424487008', '424549003', '424779008', '424849005', '424887002', '424938000', '424970000',
        '425048006', '425066001', '425127006', '425178004', '425225007', '425230006', '425231005',
        '425376008', '425657001', '425688002', '425749006', '425869007', '425941003', '426071002',
        '426124006', '426191007', '426217000', '426248008', '426336007', '426370008', '426642002',
        '426885008', '426964009', '427038005', '427056005', '427141003', '427492003', '427642009',
        '427658007', '428061005', '428100006', '428281000', '428753007', '428960009', '428964000',
        '428965004', '429033009', '429408002', '429565004', '430338009', '430621000', '432082001',
        '433067002', '438946002', '439478008', '440173001', '440397000', '440422002', '440501006',
        '440525003', '440527006', '441313008', '441559006', '441962003', '442537007', '443487006',
        '444545003', '444597005', '444869007', '444910004', '444911000', '445105005', '445227008',
        '445269007', '445406001', '445448008', '445513004', '445736006', '445738007', '446022000',
        '446076000', '446124001', '446593006', '446643000', '446710005', '446711009', '446887007',
        '446945009', '447100004', '447266004', '447389009', '447390000', '447596005', '447656001',
        '447658000', '447705002', '447707005', '447708000', '447711004', '447712006', '447738006',
        '447757002', '447766003', '447768002', '447781009', '447782002', '447783007', '447784001',
        '447785000', '447800002', '447805007', '447806008', '447949005', '447989004', '448148000',
        '448212009', '448213004', '448214005', '448215006', '448216007', '448217003', '448218008',
        '448220006', '448221005', '448229007', '448231003', '448233000', '448248006', '448250003',
        '448254007', '448258005', '448259002', '448269008', '448273006', '448298007', '448299004',
        '448300007', '448315008', '448317000', '448319002', '448354009', '448371005', '448372003',
        '448376000', '448377009', '448378004', '448384001', '448386004', '448387008', '448388003',
        '448401007', '448408001', '448435005', '448436006', '448447004', '448449001', '448450001',
        '448451002', '448465000', '448468003', '448509007', '448555009', '448558006', '448560008',
        '448561007', '448607004', '448609001', '448663003', '448665005', '448666006', '448668007',
        '448669004', '448670003', '448672006', '448674007', '448709005', '448710000', '448712008',
        '448738008', '448774004', '448775003', '448776002', '448863000', '448864006', '448865007',
        '448867004', '448868009', '448911008', '448952004', '448954003', '448989001', '448990005',
        '448993007', '448995000', '449034009', '449053004', '449054005', '449055006', '449058008',
        '449059000', '449063007', '449065000', '449066004', '449067008', '449073009', '449075002',
        '449077005', '449097000', '449100005', '449101009', '449108003', '449153001', '449156009',
        '449173006', '449176003', '449177007', '449206007', '449207003', '449208008', '449216004',
        '449217008', '449218003', '449219006', '449220000', '449221001', '449222008', '449223003',
        '449224009', '449248000', '449253005', '449254004', '449259009', '449260004', '449267001',
        '449268006', '449269003', '449292003', '449294002', '449295001', '449307001', '449308006',
        '449309003', '449318001', '449377002', '449386007', '449416001', '449417005', '449418000',
        '449419008', '449420002', '449421003', '449472007', '449487002', '449497006', '449578008',
        '449628003', '449636007', '449637003', '450521000124109', '46724008', '53132006',
        '61291000119103', '61301000119102', '61311000119104', '61321000119106', '61530001',
        '61808009', '6331000', '64862009', '67944007', '7021009', '713325002', '713483007',
        '713516007', '713718006', '713897006', '714251006', '714463003', '715664005', '715950008',
        '716788007', '718195003', '718200007', '76564002', '8090002', '80914001', '81021006',
        '84811000119107', '84831000119102', '91855006', '91856007', '91857003', '91858008',
        '91860005', '91861009', '92087008', '92508006', '92509003', '92510008', '92511007',
        '92512000', '92513005', '92515003', '92516002', '92752000', '92793008', '92811003',
        '92812005', '92813000', '92814006', '92818009', '93133006', '93134000', '93135004',
        '93136003', '93137007', '93138002', '93139005', '93140007', '93141006', '93143009',
        '93144003', '93145002', '93146001', '93147005', '93148000', '93149008', '93151007',
        '93152000', '93169003', '93182006', '93183001', '93184007', '93185008', '93186009',
        '93187000', '93188005', '93189002', '93190006', '93191005', '93192003', '93193008',
        '93194002', '93195001', '93196000', '93197009', '93198004', '93199007', '93200005',
        '93201009', '93202002', '93203007', '93204001', '93205000', '93206004', '93207008',
        '93208003', '93209006', '93210001', '93211002', '93213004', '93214005', '93215006',
        '93216007', '93217003', '93218008', '93219000', '93220006', '93221005', '93222003',
        '93223008', '93224002', '93225001', '93226000', '93227009', '93228004', '93229007',
        '93230002', '93451002', '93487009', '93488004', '93489007', '93492006', '93493001',
        '93494007', '93495008', '93496009', '93497000', '93498005', '93500006', '93501005',
        '93505001', '93506000', '93507009', '93509007', '93510002', '93514006', '93515007',
        '93516008', '93518009', '93519001', '93520007', '93521006', '93522004', '93523009',
        '93524003', '93525002', '93526001', '93527005', '93528000', '93530003', '93531004',
        '93532006', '93533001', '93534007', '93536009', '93537000', '93541001', '93542008',
        '93543003', '93545005', '93546006', '93547002', '93548007', '93549004', '93550004',
        '93551000', '93552007', '93554008', '93555009', '93636004', '93637008', '93638003',
        '93640008', '93641007', '93642000', '93643005', '93644004', '93645003', '93646002',
        '93647006', '93648001', '93649009', '93650009', '93651008', '93652001', '93653006',
        '93654000', '93655004', '93659005', '93661001', '93662008', '93665005', '93667002',
        '93669004', '93670003', '93671004', '93672006', '93674007', '93676009', '93680004',
        '93683002', '93684008', '93687001', '93689003', '93692004', '93710000', '93716006',
        '93717002', '93720005', '93721009', '93722002', '93723007', '93724001', '93725000',
        '93726004', '93727008', '93728003', '93729006', '93730001', '93731002', '93732009',
        '93733004', '93734005', '93737003', '93738008', '93739000', '93741004', '93742006',
        '93744007', '93745008', '93746009', '93747000', '93748005', '93749002', '93753000',
        '93754006', '93755007', '93756008', '93757004', '93760006', '93761005', '93764002',
        '93766000', '93768004', '93769007', '93771007', '93772000', '93773005', '93775003',
        '93776002', '93778001', '93779009', '93781006', '93782004', '93783009', '93784003',
        '93786001', '93787005', '93788000', '93789008', '93796005', '93797001', '93798006',
        '93799003', '93800004', '93802007', '93806005', '93807001', '93808006', '93809003',
        '93812000', '93816002', '93818001', '93820003', '93825008', '93826009', '93827000',
        '93829002', '93830007', '93831006', '93833009', '93835002', '93836001', '93837005',
        '93841009', '93842002', '93843007', '93844001', '93845000', '93848003', '93849006',
        '93850006', '93851005', '93857009', '93858004', '93860002', '93861003', '93862005',
        '93864006', '93865007', '93867004', '93868009', '93871001', '93872008', '93874009',
        '93876006', '93879004', '93880001', '93882009', '93883004', '93885006', '93886007',
        '93887003', '93888008', '93889000', '93891008', '93892001', '93893006', '93894000',
        '93898002', '93910009', '93915004', '93916003', '93917007', '93918002', '93920004',
        '93924008', '93927001', '93928006', '93930008', '93931007', '93932000', '93933005',
        '93934004', '93936002', '93942003', '93943008', '93944002', '93945001', '93946000',
        '93947009', '93948004', '93950007', '93951006', '93952004', '93955002', '93957005',
        '93958000', '93959008', '93960003', '93961004', '93962006', '93963001', '93964007',
        '93965008', '93966009', '93967000', '93968005', '93969002', '93970001', '93971002',
        '93974005', '93975006', '93976007', '93977003', '93978008', '93979000', '93980002',
        '93981003', '93982005', '93983000', '93985007', '93986008', '93987004', '93989001',
        '93990005', '93991009', '93992002', '93993007', '93994001', '93996004', '93997008',
        '93998003', '94001007', '94002000', '94003005', '94006002', '94010004', '94014008',
        '94015009', '94020009', '94021008', '94049001', '94051002', '94062002', '94066004',
        '94067008', '94068003', '94069006', '94071006', '94072004', '94073009', '94075002',
        '94076001', '94077005', '94078000', '94080006', '94083008', '94084002', '94085001',
        '94086000', '94087009', '94089007', '94090003', '94094007', '94096009', '94098005',
        '94099002', '94101009', '94102002', '94103007', '94104001', '94105000', '94107008',
        '94109006', '94112009', '94113004', '94115006', '94117003', '94118008', '94120006',
        '94121005', '94122003', '94123008', '94124002', '94125001', '94128004', '94129007',
        '94132005', '94133000', '94134006', '94135007', '94138009', '94139001', '94140004',
        '94142007', '94143002', '94144008', '94145009', '94148006', '94179005', '94260004',
        '94271003', '94328005', '94509004', '94538001', '94604000', '94643001', '94686001',
        '94687005', '94688000', '94690004', '94707004', '94708009', '94709001', '94710006',
        '94711005', '94712003', '94714002', '94715001', '94716000', '94718004', '94719007',
        '94726007', '94745003', '94750009', '95186006', '95187002', '95188007', '95192000',
        '95193005', '95194004', '95209008', '95210003', '95224004', '95225003', '95226002',
        '95230004', '95231000', '95260009', '95261008', '95263006', '95264000', '95413004'
    }


class PapTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1017'
    VALUE_SET_NAME = 'Pap Test'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '10524-7', '18500-9', '19762-4', '19764-0', '19765-7', '19766-5', '19774-9', '33717-0',
        '47527-7', '47528-5'
    }


class Mammography(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1018'
    VALUE_SET_NAME = 'Mammography'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    HCPCS = {'G0202', 'G0204', 'G0206'}

    LOINC = {
        '24604-1', '24605-8', '24606-6', '24610-8', '26175-0', '26176-8', '26177-6', '26287-3',
        '26289-9', '26291-5', '26346-7', '26347-5', '26348-3', '26349-1', '26350-9', '26351-7',
        '36319-2', '36625-2', '36626-0', '36627-8', '36642-7', '36962-9', '37005-6', '37006-4',
        '37016-3', '37017-1', '37028-8', '37029-6', '37030-4', '37037-9', '37038-7', '37052-8',
        '37053-6', '37539-4', '37542-8', '37543-6', '37551-9', '37552-7', '37553-5', '37554-3',
        '37768-9', '37769-7', '37770-5', '37771-3', '37772-1', '37773-9', '37774-7', '37775-4',
        '38067-5', '38070-9', '38071-7', '38072-5', '38090-7', '38091-5', '38807-4', '38820-7',
        '38854-6', '38855-3', '39150-8', '39152-4', '39153-2', '39154-0', '42168-5', '42169-3',
        '42174-3', '42415-0', '42416-8', '46335-6', '46336-4', '46337-2', '46338-0', '46339-8',
        '46342-2', '46350-5', '46351-3', '46354-7', '46355-4', '46356-2', '46380-2', '48475-8',
        '48492-3', '69150-1', '69251-7', '69259-0'
    }


class Colonoscopy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1020'
    VALUE_SET_NAME = 'Colonoscopy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '44388', '44389', '44390', '44391', '44392', '44393', '44394', '44397', '44401', '44402',
        '44403', '44404', '44405', '44406', '44407', '44408', '45355', '45378', '45379', '45380',
        '45381', '45382', '45383', '45384', '45385', '45386', '45387', '45388', '45389', '45390',
        '45391', '45392', '45393', '45398'
    }

    HCPCS = {'G0105', 'G0121'}

    SNOMEDCT = {
        '12350003', '174158000', '174184006', '235150006', '235151005', '25732003', '303587008',
        '310634005', '34264006', '367535003', '427459009', '443998000', '444783004', '446521004',
        '446745002', '447021001', '73761001', '8180007'
    }


class CtColonography(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1038'
    VALUE_SET_NAME = 'CT Colonography'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'74263'}

    SNOMEDCT = {'418714002'}


class FitDna(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.108.12.1039'
    VALUE_SET_NAME = 'FIT DNA'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'77353-1', '77354-9'}


class DiabeticNephropathy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1004'
    VALUE_SET_NAME = 'Diabetic Nephropathy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'E0821', 'E0822', 'E0829', 'E0921', 'E0922', 'E0929', 'E1021', 'E1022', 'E1029', 'E1121',
        'E1122', 'E1129', 'E1321', 'E1322', 'E1329'
    }

    ICD9CM = {'25041', '25042', '25043'}

    SNOMEDCT = {
        '127013003', '236499007', '236500003', '38046004', '401110002', '420514000', '420715001',
        '421305000', '421986006', '445170001', '54181000'
    }


class VascularAccessForDialysis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1011'
    VALUE_SET_NAME = 'Vascular Access for Dialysis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '36147', '36148', '36800', '36810', '36815', '36818', '36819', '36820', '36821', '36831',
        '36832', '36833'
    }

    SNOMEDCT = {
        '180272001', '180277007', '225892009', '22800003', '233468004', '233471007', '233472000',
        '233547003', '238314006', '238315007', '271418008', '34163007', '426340003', '427992007',
        '428118009', '431418000', '431440009', '431781000', '432509002', '432654009', '434435000',
        '438341004', '438342006', '439241008', '439322008', '439349008', '439534001', '443683004',
        '448591002', '449400003', '450865002', '54817007', '61160002', '61740001', '63421002',
        '676002', '69380006', '7459007', '79827002', '80634002'
    }


class KidneyTransplant(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1012'
    VALUE_SET_NAME = 'Kidney Transplant'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'50340', '50360', '50365', '50370', '50380'}

    HCPCS = {'S2065'}

    SNOMEDCT = {
        '175899003', '175901007', '175902000', '236138007', '313030004', '52213001', '70536003',
        '88930008'
    }


class DialysisServices(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1013'
    VALUE_SET_NAME = 'Dialysis Services'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90920', '90921', '90924', '90925', '90935', '90937', '90940', '90945', '90947'}

    HCPCS = {'G0257'}

    SNOMEDCT = {
        '108241001', '10848006', '11932001', '14684005', '180273006', '225230008', '225231007',
        '233575001', '233576000', '233577009', '233578004', '233579007', '233580005', '233581009',
        '233582002', '233583007', '233584001', '233585000', '233586004', '233587008', '233588003',
        '233589006', '233590002', '238316008', '238317004', '238318009', '238319001', '238321006',
        '238322004', '238323009', '265764009', '288182009', '302497006', '34897002', '427053002',
        '428648006', '439278006', '439976001', '57274006', '676002', '67970008', '68341005',
        '71192002', '714749008'
    }


class EsrdMonthlyOutpatientServices(ValueSet):
    """

    Clinical Focus: Under  Development
    Data Element Scope: Under  Development
    Inclusion Criteria: Under  Development
    Exclusion Criteria: Under  Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1014'
    VALUE_SET_NAME = 'ESRD Monthly Outpatient Services'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '90957', '90958', '90959', '90960', '90961', '90962', '90965', '90966', '90969', '90970',
        '90989', '90993', '90997', '90999', '99512'
    }


class OtherServicesRelatedToDialysis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1015'
    VALUE_SET_NAME = 'Other Services Related to Dialysis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '233591003', '251000124108', '311000124103', '3257008', '385970002', '385971003',
        '385973000', '406168002', '73257006'
    }


class DialysisEducation(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1016'
    VALUE_SET_NAME = 'Dialysis Education'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'28812006', '385972005', '59596005', '66402002'}


class HypertensiveChronicKidneyDisease(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1017'
    VALUE_SET_NAME = 'Hypertensive Chronic Kidney Disease'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'I120', 'I129', 'I130', 'I1310', 'I1311', 'I132'}

    ICD9CM = {
        '40301', '40310', '40311', '40390', '40391', '40400', '40401', '40402', '40403', '40410',
        '40411', '40412', '40413', '40490', '40491', '40492', '40493'
    }

    SNOMEDCT = {
        '111438007', '123799005', '123800009', '14973001', '193003', '194774006', '194783001',
        '19769006', '23130000', '28119000', '285831000119108', '285841000119104',
        '286371000119107', '32916005', '38481006', '39018007', '397748008', '427889009',
        '428575007', '473392002', '49220004', '57684003', '62240004', '65443008', '66052004',
        '66610008', '73410007', '78544004', '81363003', '86234004', '90493000'
    }


class GlomerulonephritisAndNephroticSyndrome(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1018'
    VALUE_SET_NAME = 'Glomerulonephritis and Nephrotic Syndrome'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'N000', 'N001', 'N002', 'N003', 'N004', 'N005', 'N006', 'N007', 'N008', 'N009', 'N010',
        'N011', 'N012', 'N013', 'N014', 'N015', 'N016', 'N017', 'N018', 'N019', 'N020', 'N021',
        'N022', 'N023', 'N024', 'N025', 'N026', 'N027', 'N028', 'N029', 'N030', 'N031', 'N032',
        'N033', 'N034', 'N035', 'N036', 'N037', 'N038', 'N039', 'N040', 'N041', 'N042', 'N043',
        'N044', 'N045', 'N046', 'N047', 'N048', 'N049', 'N050', 'N051', 'N052', 'N053', 'N054',
        'N055', 'N056', 'N057', 'N058', 'N059', 'N060', 'N061', 'N062', 'N063', 'N064', 'N065',
        'N066', 'N067', 'N068', 'N069', 'N070', 'N071', 'N072', 'N073', 'N074', 'N075', 'N076',
        'N077', 'N078', 'N079', 'N08', 'N250', 'N251', 'N2581', 'N2589', 'N259'
    }

    ICD9CM = {
        '5804', '58081', '58089', '5809', '5810', '5811', '5812', '5813', '58181', '58189', '5819',
        '5820', '5821', '5822', '5824', '58281', '58289', '5829', '5830', '5831', '5832', '5834',
        '5836', '5837', '58381', '58389', '5839', '5880', '5881', '58881', '58889', '5889'
    }

    SNOMEDCT = {
        '110996009', '111395007', '118951003', '123609007', '123610002', '123752003', '13335004',
        '1426004', '16726004', '1776003', '19351000', '197577008', '197579006', '197580009',
        '197582001', '197584000', '197585004', '197589005', '197590001', '197591002', '197593004',
        '197594005', '197595006', '197596007', '197597003', '197598008', '197599000', '197600002',
        '197601003', '197603000', '197605007', '197607004', '197613008', '197614002', '197616000',
        '197617009', '197618004', '197619007', '197626007', '197628008', '197629000', '197632002',
        '197661001', '197663003', '197664009', '197670003', '197671004', '197679002', '197681000',
        '197682007', '197683002', '197684008', '197685009', '197686005', '197687001', '197688006',
        '197689003', '197690007', '197691006', '197692004', '197693009', '197694003', '197695002',
        '197696001', '197697005', '197699008', '197700009', '197701008', '197702001', '197703006',
        '197704000', '197705004', '197706003', '197707007', '197708002', '197709005', '197712008',
        '197713003', '197714009', '197715005', '197716006', '197717002', '197719004', '197720005',
        '197721009', '197722002', '197723007', '197724001', '197725000', '197738008', '197739000',
        '20917003', '22702000', '234485006', '236380004', '236381000', '236382007', '236383002',
        '236384008', '236385009', '236391006', '236392004', '236393009', '236394003', '236395002',
        '236397005', '236398000', '236399008', '236400001', '236401002', '236402009', '236403004',
        '236404005', '236405006', '236407003', '236409000', '236410005', '236411009', '236412002',
        '236413007', '236414001', '236415000', '236416004', '236417008', '236418003', '236419006',
        '236420000', '236422008', '236437007', '236460004', '236461000', '236463002', '236479001',
        '236480003', '236508005', '236534002', '236535001', '236587002', '236588007', '236589004',
        '236590008', '239932005', '24790002', '253864004', '25821008', '266549004', '276585000',
        '282364005', '309426007', '35546006', '359694003', '36171008', '363234001', '3704008',
        '370494002', '37085009', '38046004', '399190000', '399340005', '40233000', '425384007',
        '425455002', '441815006', '444977005', '445258009', '445388002', '445404003', '446923008',
        '44785005', '48796009', '51055000', '52254009', '52845002', '54181000', '54879000',
        '55652009', '57965003', '58574008', '59479006', '61165007', '61503006', '62240004',
        '63510008', '64168005', '64212008', '68544003', '68779003', '73305009', '75888001',
        '7703001', '77182004', '7724006', '80321008', '81363003', '81475007', '8199003',
        '83866005', '86210009', '90493000'
    }


class UrineProteinTests(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1024'
    VALUE_SET_NAME = 'Urine Protein Tests'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '11218-5', '12842-1', '13705-9', '13801-6', '14585-4', '14956-7', '14957-5', '14958-3',
        '14959-1', '1753-3', '1754-1', '1755-8', '1757-4', '18373-1', '20454-5', '20621-9',
        '21059-1', '21482-5', '26801-1', '27298-9', '2887-8', '2888-6', '2889-4', '2890-2',
        '30000-4', '30001-2', '30003-8', '32209-9', '32294-1', '32551-4', '34366-5', '35663-4',
        '40486-3', '40662-9', '40663-7', '43605-5', '43606-3', '43607-1', '44292-1', '47558-2',
        '49023-5', '50561-0', '50949-7', '53121-0', '53525-2', '53530-2', '53531-0', '53532-8',
        '56553-1', '57369-1', '57735-3', '5804-0', '58448-2', '58992-9', '59159-4', '60678-0',
        '63474-1', '76401-9', '77158-4', '77253-3', '77254-1', '9318-7'
    }


class KidneyFailure(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.109.12.1028'
    VALUE_SET_NAME = 'Kidney Failure'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'N170', 'N171', 'N172', 'N178', 'N179', 'N181', 'N182', 'N183', 'N184', 'N185', 'N186',
        'N189', 'N19'
    }

    ICD9CM = {
        '5845', '5846', '5847', '5848', '5849', '5851', '5852', '5853', '5854', '5855', '5856',
        '5859', '586', '587'
    }

    SNOMEDCT = {
        '129151000119102', '129171000119106', '129181000119109', '140111000119107',
        '140131000119102', '145681000119101', '14669001', '236434000', '236435004', '236436003',
        '284981000119102', '285001000119105', '285861000119100', '285881000119109', '429224003',
        '431855005', '431857002', '433144002', '433146000', '46177005', '700378005', '700379002',
        '711000119100', '721000119107', '731000119105', '90741000119107', '90751000119109',
        '96721000119103', '96731000119100', '96741000119109'
    }


class DtapVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1022'
    VALUE_SET_NAME = 'DTaP Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90698', '90700', '90721', '90723'}

    SNOMEDCT = {
        '170395004', '170396003', '170397007', '170399005', '170400003', '170401004', '170402006',
        '310306005', '310307001', '310308006', '313383003', '390846000', '390865008', '412755006',
        '412756007', '412757003', '412762002', '412763007', '412764001', '414001002', '414259000',
        '414620004', '415507003', '415712004', '428251000124104'
    }


class HepatitisA(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1024'
    VALUE_SET_NAME = 'Hepatitis A'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'B150', 'B159'}

    SNOMEDCT = {
        '111879004', '16060001', '18917003', '206373002', '25102003', '40468003', '424758008',
        '43634002', '79031007'
    }


class HepatitisB(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1025'
    VALUE_SET_NAME = 'Hepatitis B'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'B160', 'B161', 'B162', 'B169', 'B170', 'B180', 'B181', 'B1910', 'B1911'}

    SNOMEDCT = {
        '1116000', '111891008', '13265006', '186624004', '186626002', '186639003', '235864009',
        '235869004', '235871004', '26206000', '29062009', '38662009', '424099008', '424340000',
        '442134007', '442374005', '446698005', '50167007', '53425008', '60498001', '61977001',
        '66071002', '76795007'
    }


class PneumococcalVaccine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1027'
    VALUE_SET_NAME = 'Pneumococcal Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'109', '133', '152', '33'}


class HistoryOfPneumococcalVaccine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1028'
    VALUE_SET_NAME = 'History of Pneumococcal Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'310578008', '473165003'}


class MeaslesMumpsAndRubellaMmrVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1031'
    VALUE_SET_NAME = 'Measles, Mumps and Rubella (MMR) Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90707', '90710'}

    SNOMEDCT = {'170433008', '38598009', '432636005', '433733003'}


class Mumps(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1032'
    VALUE_SET_NAME = 'Mumps'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'B260', 'B261', 'B262', 'B263', 'B2681', 'B2682', 'B2683', 'B2684', 'B2685', 'B2689',
        'B269'
    }

    SNOMEDCT = {
        '10665004', '111870000', '17121006', '235123001', '236771002', '237443002', '240526004',
        '240527008', '240529006', '31524007', '31646008', '36989005', '40099009', '44201003',
        '63462008', '72071001', '74717002', '75548002', '78580004', '89231008', '89764009'
    }


class PneumococcalVaccineAdministered(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1034'
    VALUE_SET_NAME = 'Pneumococcal Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90670', '90732'}

    SNOMEDCT = {'12866006', '394678003'}


class Rubella(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1037'
    VALUE_SET_NAME = 'Rubella'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'B0600', 'B0601', 'B0602', 'B0609', 'B0681', 'B0682', 'B0689', 'B069'}

    SNOMEDCT = {
        '10082001', '1092351000119107', '1092361000119109', '111867004', '111868009', '128191000',
        '13225007', '186567003', '186570004', '192689006', '19431000', '232312000', '240485004',
        '253227001', '302811004', '36653000', '64190005', '79303006', '84611003'
    }


class VaricellaZoster(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1039'
    VALUE_SET_NAME = 'Varicella Zoster'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'B010', 'B0111', 'B0112', 'B012', 'B0181', 'B0189', 'B019', 'B020', 'B021', 'B0221',
        'B0222', 'B0223', 'B0224', 'B0229', 'B0230', 'B0231', 'B0232', 'B0233', 'B0234', 'B0239',
        'B027', 'B028', 'B029'
    }

    SNOMEDCT = {
        '10491005', '10698009', '111859007', '111861003', '15678761000119105', '15678801000119102',
        '186524006', '186525007', '195911009', '21954000', '230176008', '230198004', '230262004',
        '230536009', '232400003', '235059009', '23737006', '240468001', '240470005', '240471009',
        '240472002', '240473007', '240474001', '24059009', '309465005', '36292003', '38907003',
        '397573005', '400020001', '402897003', '402898008', '410500004', '410509003', '421029004',
        '422127002', '422446008', '422471006', '422666006', '423333008', '423628002', '424353002',
        '424435009', '42448002', '424801004', '424941009', '425356002', '426570007', '428633000',
        '4740000', '49183009', '55560002', '713250002', '713733003', '713964006', '715223009',
        '87513003'
    }


class VaricellaZosterVaccineVzvAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1040'
    VALUE_SET_NAME = 'Varicella Zoster Vaccine (VZV) Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90710', '90716'}

    SNOMEDCT = {'425897001', '428502009', '68525005'}


class HepatitisAVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1041'
    VALUE_SET_NAME = 'Hepatitis A Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90633'}

    SNOMEDCT = {'170378007', '170379004', '243789007', '313188000', '313189008'}


class HepatitisBVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1042'
    VALUE_SET_NAME = 'Hepatitis B Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90723', '90740', '90744', '90747', '90748'}

    SNOMEDCT = {
        '116802006', '16584000', '170370000', '170371001', '170372008', '170373003', '170374009',
        '170434002', '170435001', '170436000', '170437009', '312868009', '396456003'
    }


class HaemophilusInfluenzaeTypeBHibVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1043'
    VALUE_SET_NAME = 'Haemophilus Influenzae Type B (HiB) Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90644', '90645', '90646', '90647', '90648', '90698', '90721', '90748'}

    SNOMEDCT = {
        '127787002', '170343007', '170344001', '170345000', '414001002', '414259000', '415507003',
        '415712004'
    }


class InfluenzaVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1044'
    VALUE_SET_NAME = 'Influenza Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90655', '90657', '90661', '90662', '90673', '90685', '90687'}

    SNOMEDCT = {'86198006'}


class InactivatedPolioVaccineIpvAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1045'
    VALUE_SET_NAME = 'Inactivated Polio Vaccine (IPV) Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90698', '90713', '90723'}

    SNOMEDCT = {
        '396456003', '414001002', '414259000', '414619005', '414620004', '415507003', '415712004',
        '416144004', '416591003', '417211006', '417384007', '417615007'
    }


class PneumococcalConjugateVaccineAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1046'
    VALUE_SET_NAME = 'Pneumococcal Conjugate Vaccine Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90669', '90670'}

    SNOMEDCT = {'434751000124102'}


class RotavirusVaccine3DoseScheduleAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1047'
    VALUE_SET_NAME = 'Rotavirus Vaccine (3 dose schedule) Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90680'}


class RotavirusVaccine2DoseScheduleAdministered(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1048'
    VALUE_SET_NAME = 'Rotavirus Vaccine (2 dose schedule) Administered'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90681'}


class GenitalHerpes(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1049'
    VALUE_SET_NAME = 'Genital Herpes'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'A6000', 'A6003', 'A6004', 'A6009'}

    ICD9CM = {'05410', '05411', '05412', '05419'}

    SNOMEDCT = {
        '129670002', '27420004', '278068003', '33839006', '402888002', '402890001', '402894005',
        '402896007', '423391007', '427578006', '439912007', '439913002', '440714005', '59819007'
    }


class LabTestsForSexuallyTransmittedInfections(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1051'
    VALUE_SET_NAME = 'Lab Tests for Sexually Transmitted Infections'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '10705-2', '11083-3', '11084-1', '11481-9', '11597-2', '12222-6', '12223-4', '14499-8',
        '14500-3', '14502-9', '14503-7', '14504-5', '14506-0', '16280-0', '17398-9', '17399-7',
        '17400-3', '17401-1', '17402-9', '17403-7', '17404-5', '17405-2', '17406-0', '17407-8',
        '17408-6', '17409-4', '17410-2', '17411-0', '17412-8', '17723-8', '17724-6', '17725-3',
        '17726-1', '17727-9', '17728-7', '17729-5', '20507-0', '20508-8', '21414-8', '21415-5',
        '21416-3', '21440-3', '21441-1', '22461-8', '22462-6', '22587-0', '22590-4', '22592-0',
        '22594-6', '24110-9', '24111-7', '24312-1', '26009-1', '29311-8', '30167-1', '31147-2',
        '31905-3', '31906-1', '32198-4', '32199-2', '32705-6', '34147-9', '34382-2', '38372-9',
        '40679-3', '40680-1', '42481-2', '43305-2', '43403-5', '44543-7', '44544-5', '44546-0',
        '44547-8', '44549-4', '44550-2', '47236-5', '47237-3', '47238-1', '47387-6', '48560-7',
        '49891-5', '49896-4', '5028-6', '50388-8', '50690-7', '51838-1', '51839-9', '5291-0',
        '5292-8', '53605-2', '53762-1', '53879-3', '5392-6', '53927-0', '5393-4', '5394-2',
        '55299-2', '57032-5', '59263-4', '59264-2', '59420-0', '61372-9', '61373-7', '61374-5',
        '61375-2', '61376-0', '61377-8', '61378-6', '61379-4', '61380-2', '61381-0', '61382-8',
        '61383-6', '61384-4', '61385-1', '61386-9', '61387-7', '61388-5', '61389-3', '61390-1',
        '61391-9', '61392-7', '61393-5', '61394-3', '61395-0', '61396-8', '63464-2', '6487-3',
        '6488-1', '6489-9', '6510-2', '6511-0', '6514-4', '6516-9', '6561-5', '6562-3', '660-1',
        '688-2', '690-8', '69002-4', '691-6', '692-4', '693-2', '698-1', '71431-1', '71793-4',
        '73732-0', '73752-8', '73959-9', '7975-6', '8041-6'
    }


class ChlamydiaScreening(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1052'
    VALUE_SET_NAME = 'Chlamydia Screening'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '14463-4', '14464-2', '14467-5', '14470-9', '14471-7', '14474-1', '14509-4', '14510-2',
        '14513-6', '16600-9', '16601-7', '21189-6', '21190-4', '21191-2', '21192-0', '21613-5',
        '23838-6', '31771-9', '31772-7', '31775-0', '31777-6', '36902-5', '36903-3', '42931-6',
        '43304-5', '43404-3', '43406-8', '44806-8', '44807-6', '45067-6', '45068-4', '45069-2',
        '45070-0', '45074-2', '45076-7', '45078-3', '45080-9', '45084-1', '45091-6', '45095-7',
        '45098-1', '45100-5', '47211-8', '47212-6', '49096-1', '4993-2', '50387-0', '53925-4',
        '53926-2', '557-9', '560-3', '6349-5', '6354-5', '6355-2', '6356-0', '6357-8', '80360-1',
        '80361-9', '80362-7', '80363-5', '80364-3', '80365-0', '80367-6'
    }


class Measles(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1053'
    VALUE_SET_NAME = 'Measles'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'B050', 'B051', 'B052', 'B053', 'B054', 'B0581', 'B0589', 'B059'}

    SNOMEDCT = {
        '111873003', '14189004', '186561002', '186562009', '192685000', '195900001', '233625007',
        '240483006', '240484000', '28463004', '38921001', '406592004', '60013002', '74918002'
    }


class HpvTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.110.12.1059'
    VALUE_SET_NAME = 'HPV Test'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '21440-3', '30167-1', '38372-9', '49896-4', '59263-4', '59264-2', '59420-0', '69002-4',
        '71431-1', '75406-9', '75694-0', '77379-6', '77399-4', '77400-0'
    }


class OtherFemaleReproductiveConditions(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1006'
    VALUE_SET_NAME = 'Other Female Reproductive Conditions'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'A630', 'B977', 'E230', 'E282', 'E2839', 'G4482', 'N881', 'N883', 'N898', 'N930', 'N970',
        'N971', 'N972', 'N978', 'N979', 'R85610', 'R85611', 'R85612', 'R85613', 'R85614', 'R85615',
        'R85616', 'R85618', 'R85619', 'R8581', 'R8582', 'R87610', 'R87611', 'R87612', 'R87613',
        'R87614', 'R87615', 'R87616', 'R87618', 'R87619', 'R87620', 'R87621', 'R87622', 'R87623',
        'R87624', 'R87625', 'R87628', 'R87629', 'T8331XA', 'T8331XD', 'T8331XS', 'T8332XA',
        'T8332XD', 'T8332XS', 'T8339XA', 'T8339XD', 'T8339XS'
    }

    ICD9CM = {
        '07811', '0794', '33982', '6223', '6234', '6267', '6280', '6281', '6282', '6283', '6284',
        '6288', '6289', '79500', '79501', '79502', '79503', '79504', '79505', '79506', '79507',
        '79508', '79509', '79510', '79511', '79512', '79513', '79514', '79515', '79516', '79518',
        '79519', '79670', '79671', '79672', '79673', '79674', '79675', '79676', '79677', '79678',
        '79679', '99632'
    }

    SNOMEDCT = {
        '103010005', '125157000', '168407000', '168472007', '198445009', '198446005', '198448006',
        '198449003', '198450003', '198452006', '198453001', '198456009', '198457000', '198459002',
        '198460007', '198464003', '198465002', '227561004', '237110007', '237139007', '237141008',
        '237142001', '237800001', '240542006', '266609001', '26899006', '286995008', '30238006',
        '30826006', '3160009', '35308000', '373877006', '391147004', '39446004', '395688005',
        '399599006', '414238007', '414239004', '415149004', '415168001', '416030007', '416031006',
        '416033009', '419266001', '426488001', '427547007', '428008002', '428017002', '439776006',
        '439855007', '439856008', '439888000', '439890004', '439891000', '441072002', '441086003',
        '441087007', '441088002', '441094005', '441098008', '441099000', '441114008', '441115009',
        '441219009', '441667007', '4667004', '48880000', '5084002', '52937008', '53821008',
        '58423003', '6303009', '65370002', '65454003', '6738008', '74294009', '80330000',
        '82593008', '84785006', '85078005'
    }


class LabTestsDuringPregnancy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1007'
    VALUE_SET_NAME = 'Lab Tests During Pregnancy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '15019-3', '1832-5', '1834-1', '19171-8', '19176-7', '19177-5', '20403-2', '20404-0',
        '31993-9', '33773-3', '34493-7', '34656-9', '34718-7', '35457-1', '41273-4', '41274-2',
        '42316-0', '43798-8', '45273-0', '45331-6', '45332-4', '46731-6', '46989-0', '48030-1',
        '48039-2', '48781-9', '49246-2', '49318-9', '64088-8', '64094-6'
    }


class DiagnosticStudiesDuringPregnancy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1008'
    VALUE_SET_NAME = 'Diagnostic Studies During Pregnancy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '11615-2', '11616-0', '11617-8', '11618-6', '11619-4', '11620-2', '11621-0', '11622-8',
        '11623-6', '11624-4', '11625-1', '11626-9', '11627-7', '11628-5', '11629-3', '11630-1',
        '11631-9', '11632-7', '11633-5', '11634-3', '11635-0', '11641-8', '11643-4', '11645-9',
        '11647-5', '11649-1', '11651-7', '11654-1', '11656-6', '11660-8', '11661-6', '11662-4',
        '11666-5', '11668-1', '11670-7', '11672-3', '11675-6', '11677-2', '11679-8', '11681-4',
        '11685-5', '11687-1', '11688-9', '11689-7', '11693-9', '11695-4', '11697-0', '11699-6',
        '11701-0', '11703-6', '11705-1', '11707-7', '11709-3', '11711-9', '11713-5', '11715-0',
        '11719-2', '11721-8', '11722-6', '11723-4', '11727-5', '11728-3', '11729-1', '11730-9',
        '11731-7', '11732-5', '11733-3', '11734-1', '11735-8', '11736-6', '11737-4', '11738-2',
        '11739-0', '11740-8', '11741-6', '11742-4', '11743-2', '11744-0', '11745-7', '11746-5',
        '11747-3', '11748-1', '11749-9', '11750-7', '11751-5', '11752-3', '11753-1', '11754-9',
        '11755-6', '11756-4', '11757-2', '11758-0', '11759-8', '11760-6', '11761-4', '11762-2',
        '11763-0', '11764-8', '11765-5', '11766-3', '11767-1', '11768-9', '11775-4', '11777-0',
        '11782-0', '11790-3', '11792-9', '11794-5', '11796-0', '11798-6', '11800-0', '11802-6',
        '11804-2', '11806-7', '11808-3', '11810-9', '11812-5', '11814-1', '11815-8', '11816-6',
        '11817-4', '11818-2', '11819-0', '11820-8', '11821-6', '11822-4', '11823-2', '11824-0',
        '11825-7', '11827-3', '11831-5', '11832-3', '11833-1', '11834-9', '11836-4', '11838-0',
        '11843-0', '11844-8', '11845-5', '11849-7', '11851-3', '11852-1', '11853-9', '11855-4',
        '11860-4', '11861-2', '11862-0', '11863-8', '11864-6', '11866-1', '11868-7', '11871-1',
        '11872-9', '11873-7', '11874-5', '11875-2', '11876-0', '11877-8', '11878-6', '11882-8',
        '11883-6', '11884-4', '11885-1', '11886-9', '11887-7', '11888-5', '11889-3', '11890-1',
        '11891-9', '11892-7', '11893-5', '11894-3', '11895-0', '11896-8', '11897-6', '11898-4',
        '11899-2', '11900-8', '11901-6', '11902-4', '11903-2', '11904-0', '11905-7', '11906-5',
        '11907-3', '11908-1', '11909-9', '11910-7', '11911-5', '11912-3', '11913-1', '11914-9',
        '11915-6', '11916-4', '11917-2', '11918-0', '11919-8', '11920-6', '11921-4', '11922-2',
        '11923-0', '11924-8', '11925-5', '11926-3', '11927-1', '11928-9', '11929-7', '11930-5',
        '11931-3', '11932-1', '11933-9', '11934-7', '11935-4', '11936-2', '11937-0', '11938-8',
        '11939-6', '11940-4', '11941-2', '11942-0', '11943-8', '11944-6', '11945-3', '11946-1',
        '11947-9', '11948-7', '11949-5', '11950-3', '11951-1', '11952-9', '11954-5', '11956-0',
        '11957-8', '11962-8', '11963-6', '11964-4', '11965-1', '11966-9', '11967-7', '11968-5',
        '11969-3', '11970-1', '11971-9', '11972-7', '11973-5', '11974-3', '11975-0', '11978-4',
        '11979-2', '11980-0', '11981-8', '11982-6', '11983-4', '11984-2', '11985-9', '11986-7',
        '11987-5', '11988-3', '11989-1', '11990-9', '11991-7', '11992-5', '11993-3', '11997-4',
        '11999-0', '12003-0', '12004-8', '12005-5', '12009-7', '12012-1', '12018-8', '12019-6',
        '12020-4', '12028-7', '12029-5', '12030-3', '12031-1', '12032-9', '12033-7', '12034-5',
        '12035-2', '12036-0', '12037-8', '12038-6', '12039-4', '12040-2', '12041-0', '12042-8',
        '12043-6', '12047-7', '12048-5', '12049-3', '12050-1', '12051-9', '12052-7', '12053-5',
        '12054-3', '12055-0', '12056-8', '12057-6', '12058-4', '12059-2', '12060-0', '12061-8',
        '12062-6', '12063-4', '12064-2', '12065-9', '12066-7', '12067-5', '12068-3', '12069-1',
        '12070-9', '12071-7', '12072-5', '12073-3', '12074-1', '12075-8', '12076-6', '12077-4',
        '12078-2', '12079-0', '12080-8', '12081-6', '12082-4', '12083-2', '12084-0', '12085-7',
        '12086-5', '12087-3', '12088-1', '12089-9', '12090-7', '12091-5', '12092-3', '12093-1',
        '12094-9', '12095-6', '12096-4', '12097-2', '12098-0', '12099-8', '12100-4', '12101-2',
        '12102-0', '12103-8', '12104-6', '12105-3', '12106-1', '12107-9', '12108-7', '12109-5',
        '12110-3', '12111-1', '12112-9', '12113-7', '12114-5', '12115-2', '12116-0', '12117-8',
        '12118-6', '12119-4', '12120-2', '12121-0', '12122-8', '12123-6', '12124-4', '12125-1',
        '12128-5', '12129-3', '12130-1', '12133-5', '12135-0', '12139-2', '12140-0', '12141-8',
        '12146-7', '12147-5', '12148-3', '12149-1', '12150-9', '12151-7', '12152-5', '12153-3',
        '12154-1', '12155-8', '12162-4', '12163-2', '12166-5', '12167-3', '12168-1', '12169-9',
        '12170-7', '12171-5', '18185-9', '18847-4', '18848-2', '18849-0', '18850-8', '18851-6',
        '21299-3', '24537-3', '30707-4', '30708-2', '33068-8', '33069-6', '33070-4', '33071-2',
        '33072-0', '33073-8', '33074-6', '33075-3', '33076-1', '33077-9', '33078-7', '33079-5',
        '33080-3', '33081-1', '33082-9', '33083-7', '33084-5', '33085-2', '33086-0', '33087-8',
        '33088-6', '33089-4', '33090-2', '33091-0', '33092-8', '33093-6', '33094-4', '33095-1',
        '33096-9', '33097-7', '33098-5', '33099-3', '33100-9', '33101-7', '33102-5', '33103-3',
        '33104-1', '33105-8', '33106-6', '33107-4', '33108-2', '33109-0', '33110-8', '33111-6',
        '33112-4', '33113-2', '33114-0', '33115-7', '33116-5', '33117-3', '33118-1', '33119-9',
        '33120-7', '33121-5', '33122-3', '33123-1', '33124-9', '33125-6', '33126-4', '33127-2',
        '33128-0', '33129-8', '33130-6', '33131-4', '33132-2', '33133-0', '33134-8', '33135-5',
        '33136-3', '33137-1', '33138-9', '33139-7', '33140-5', '33141-3', '33142-1', '33143-9',
        '33144-7', '33145-4', '33146-2', '33147-0', '33148-8', '33149-6', '33150-4', '33151-2',
        '33152-0', '33153-8', '33154-6', '33155-3', '33156-1', '33157-9', '33158-7', '33159-5',
        '33160-3', '33161-1', '33162-9', '33163-7', '33164-5', '33165-2', '33166-0', '33167-8',
        '33168-6', '33169-4', '33170-2', '33172-8', '33173-6', '33174-4', '33175-1', '33176-9',
        '33177-7', '33178-5', '33179-3', '33180-1', '33181-9', '33184-3', '33185-0', '33186-8',
        '33187-6', '33188-4', '33189-2', '33190-0', '33191-8', '33196-7', '33197-5', '33198-3',
        '33199-1', '33537-2', '33538-0', '33539-8', '33540-6', '33541-4', '33542-2', '33543-0',
        '33544-8', '33545-5', '33546-3', '33556-2', '42451-5', '42452-3', '42454-9', '42464-8',
        '42465-5', '42466-3', '42467-1', '42479-6', '49035-9', '49051-6', '49052-4', '49508-5',
        '49513-5', '53655-7', '53656-5', '53657-3', '53658-1', '53659-9', '53660-7', '53667-2',
        '53668-0', '53669-8', '53670-6', '53671-4', '53672-2', '53673-0', '53674-8', '53675-5',
        '53676-3', '53677-1', '53678-9', '53679-7', '53680-5', '53681-3', '53682-1', '53683-9',
        '53684-7', '53685-4', '53686-2', '53687-0', '53688-8', '53689-6', '53690-4', '53691-2',
        '53693-8', '53695-3', '53696-1', '53697-9', '53698-7', '53699-5', '53700-1', '53701-9',
        '57067-1', '60477-7', '69391-1', '69400-0', '72221-5'
    }


class ProceduresDuringPregnancy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1009'
    VALUE_SET_NAME = 'Procedures During Pregnancy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '58970', '58974', '58976', '59000', '59001', '59012', '59015', '59020', '59025', '59030',
        '59050', '59051', '59070', '59072', '59074', '59076', '59100', '59120', '59121', '59130',
        '59135', '59136', '59140', '59150', '59151', '59160', '59200', '59300', '59320', '59325',
        '59350', '59412', '59414', '59430', '59525', '59812', '59820', '59821', '59830', '59840',
        '59841', '59850', '59851', '59852', '59855', '59856', '59857', '59866', '59870', '59871',
        '59897', '59898', '59899'
    }

    SNOMEDCT = {
        '10455003', '10763001', '133875007', '176833006', '176850008', '176852000', '176854004',
        '176928008', '176929000', '176996001', '177037000', '177038005', '177039002', '177042008',
        '177091002', '177100008', '177101007', '177102000', '177106002', '177107006', '177112007',
        '177122001', '177136006', '177212000', '177222006', '17744000', '18302006', '18489003',
        '215192006', '216209009', '233560009', '233561008', '236894009', '236912008', '236913003',
        '236914009', '236915005', '236952005', '236953000', '236954006', '236955007', '236956008',
        '236966000', '236987005', '236988000', '236992007', '236993002', '236994008', '237017007',
        '237025009', '240278000', '240284002', '240285001', '240286000', '240288004', '240289007',
        '240290003', '240291004', '240292006', '24068006', '243773009', '243774003', '259863001',
        '265082003', '265635006', '265642006', '26578004', '274973002', '275222009', '275223004',
        '28107008', '281568006', '281570002', '28379004', '285409006', '285416007', '285417003',
        '285434006', '287954004', '288045002', '288194000', '29682007', '302375005', '302384005',
        '303720006', '309877008', '315308008', '36708009', '386276009', '386277000', '386639001',
        '386641000', '387615001', '387616000', '387673001', '387678005', '387708002', '387709005',
        '387710000', '391896006', '391897002', '391899004', '391998006', '392000009', '398221005',
        '40704000', '408804006', '408805007', '408806008', '408807004', '408808009', '408819007',
        '408840008', '408845003', '41058005', '41059002', '41780001', '425707001', '425939004',
        '426287008', '426737000', '427230007', '427320001', '429613009', '429737004', '43096003',
        '433153009', '440148001', '443005005', '445865006', '445912000', '446135006', '446341008',
        '446934006', '447214008', '447972007', '448543003', '450563004', '45460008', '46681009',
        '5048009', '5191001', '52660002', '56620000', '61893009', '62688006', '63407004',
        '63596003', '65378009', '6708002', '69621003', '700041001', '73341009', '75456002',
        '81130000', '81855008', '82688001', '84275009', '85179000', '85548006', '87431004',
        '87663001', '88144003', '88362001', '90442009', '9221009', '9724000'
    }


class ProceduresInvolvingContraceptiveDevices(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1010'
    VALUE_SET_NAME = 'Procedures Involving Contraceptive Devices'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'11976', '57170', '58300', '58301'}

    HCPCS = {'S4981'}

    SNOMEDCT = {
        '169553002', '176749004', '176839005', '225251006', '225256001', '225257005', '236892008',
        '274042004', '275811000', '301806003', '301807007', '440668008', '442490009', '450836008',
        '46706006', '472837007', '472838002', '58391006', '65200003', '68254000'
    }


class PregnancyTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1011'
    VALUE_SET_NAME = 'Pregnancy Test'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '19080-1', '19180-9', '20415-6', '20994-0', '2106-3', '2107-1', '2110-5', '2111-3',
        '2112-1', '2113-9', '2114-7', '2115-4', '2118-8', '2119-6', '21198-7', '25372-4',
        '25373-2', '34670-0', '45194-8', '55869-2', '55870-0', '56497-1', '80384-1', '80385-8'
    }


class ComplicationsOfPregnancyChildbirthAndThePuerperium(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1012'
    VALUE_SET_NAME = 'Complications of Pregnancy, Childbirth and the Puerperium'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'O000', 'O0000', 'O0001', 'O001', 'O0010', 'O0011', 'O002', 'O0020', 'O0021', 'O008',
        'O0080', 'O0081', 'O009', 'O0090', 'O0091', 'O010', 'O011', 'O019', 'O020', 'O021',
        'O0281', 'O0289', 'O029', 'O030', 'O031', 'O032', 'O0330', 'O0331', 'O0332', 'O0333',
        'O0334', 'O0335', 'O0336', 'O0337', 'O0338', 'O0339', 'O034', 'O035', 'O036', 'O037',
        'O0380', 'O0381', 'O0382', 'O0383', 'O0384', 'O0385', 'O0386', 'O0387', 'O0388', 'O0389',
        'O039', 'O045', 'O046', 'O047', 'O0480', 'O0481', 'O0482', 'O0483', 'O0484', 'O0485',
        'O0486', 'O0487', 'O0488', 'O0489', 'O070', 'O071', 'O072', 'O0730', 'O0731', 'O0732',
        'O0733', 'O0734', 'O0735', 'O0736', 'O0737', 'O0738', 'O0739', 'O074', 'O080', 'O081',
        'O082', 'O083', 'O084', 'O085', 'O086', 'O087', 'O0881', 'O0882', 'O0883', 'O0889', 'O089',
        'O0900', 'O0901', 'O0902', 'O0903', 'O0910', 'O0911', 'O0912', 'O0913', 'O09211', 'O09212',
        'O09213', 'O09219', 'O09291', 'O09292', 'O09293', 'O09299', 'O0930', 'O0931', 'O0932',
        'O0933', 'O0940', 'O0941', 'O0942', 'O0943', 'O09511', 'O09512', 'O09513', 'O09519',
        'O09521', 'O09522', 'O09523', 'O09529', 'O09611', 'O09612', 'O09613', 'O09619', 'O09621',
        'O09622', 'O09623', 'O09629', 'O0970', 'O0971', 'O0972', 'O0973', 'O09811', 'O09812',
        'O09813', 'O09819', 'O09821', 'O09822', 'O09823', 'O09829', 'O09891', 'O09892', 'O09893',
        'O09899', 'O0990', 'O0991', 'O0992', 'O0993', 'O09A', 'O09A0', 'O09A1', 'O09A2', 'O09A3',
        'O10011', 'O10012', 'O10013', 'O10019', 'O1002', 'O1003', 'O10111', 'O10112', 'O10113',
        'O10119', 'O1012', 'O1013', 'O10211', 'O10212', 'O10213', 'O10219', 'O1022', 'O1023',
        'O10311', 'O10312', 'O10313', 'O10319', 'O1032', 'O1033', 'O10411', 'O10412', 'O10413',
        'O10419', 'O1042', 'O1043', 'O10911', 'O10912', 'O10913', 'O10919', 'O1092', 'O1093',
        'O111', 'O112', 'O113', 'O114', 'O115', 'O119', 'O1200', 'O1201', 'O1202', 'O1203',
        'O1204', 'O1205', 'O1210', 'O1211', 'O1212', 'O1213', 'O1214', 'O1215', 'O1220', 'O1221',
        'O1222', 'O1223', 'O1224', 'O1225', 'O131', 'O132', 'O133', 'O134', 'O135', 'O139',
        'O1400', 'O1402', 'O1403', 'O1404', 'O1405', 'O1410', 'O1412', 'O1413', 'O1414', 'O1415',
        'O1420', 'O1422', 'O1423', 'O1424', 'O1425', 'O1490', 'O1492', 'O1493', 'O1494', 'O1495',
        'O1500', 'O1502', 'O1503', 'O151', 'O152', 'O159', 'O161', 'O162', 'O163', 'O164', 'O165',
        'O169', 'O200', 'O208', 'O209', 'O210', 'O211', 'O212', 'O218', 'O219', 'O2200', 'O2201',
        'O2202', 'O2203', 'O2210', 'O2211', 'O2212', 'O2213', 'O2220', 'O2221', 'O2222', 'O2223',
        'O2230', 'O2231', 'O2232', 'O2233', 'O2240', 'O2241', 'O2242', 'O2243', 'O2250', 'O2251',
        'O2252', 'O2253', 'O228X1', 'O228X2', 'O228X3', 'O228X9', 'O2290', 'O2291', 'O2292',
        'O2293', 'O2300', 'O2301', 'O2302', 'O2303', 'O2310', 'O2311', 'O2312', 'O2313', 'O2320',
        'O2321', 'O2322', 'O2323', 'O2330', 'O2331', 'O2332', 'O2333', 'O2340', 'O2341', 'O2342',
        'O2343', 'O23511', 'O23512', 'O23513', 'O23519', 'O23521', 'O23522', 'O23523', 'O23529',
        'O23591', 'O23592', 'O23593', 'O23599', 'O2390', 'O2391', 'O2392', 'O2393', 'O24011',
        'O24012', 'O24013', 'O24019', 'O2402', 'O2403', 'O24111', 'O24112', 'O24113', 'O24119',
        'O2412', 'O2413', 'O24311', 'O24312', 'O24313', 'O24319', 'O2432', 'O2433', 'O24410',
        'O24414', 'O24415', 'O24419', 'O24420', 'O24424', 'O24425', 'O24429', 'O24430', 'O24434',
        'O24435', 'O24439', 'O24811', 'O24812', 'O24813', 'O24819', 'O2482', 'O2483', 'O24911',
        'O24912', 'O24913', 'O24919', 'O2492', 'O2493', 'O2510', 'O2511', 'O2512', 'O2513', 'O252',
        'O253', 'O2600', 'O2601', 'O2602', 'O2603', 'O2610', 'O2611', 'O2612', 'O2613', 'O2620',
        'O2621', 'O2622', 'O2623', 'O2630', 'O2631', 'O2632', 'O2633', 'O2640', 'O2641', 'O2642',
        'O2643', 'O2650', 'O2651', 'O2652', 'O2653', 'O26611', 'O26612', 'O26613', 'O26619',
        'O2662', 'O2663', 'O26711', 'O26712', 'O26713', 'O26719', 'O2672', 'O2673', 'O26811',
        'O26812', 'O26813', 'O26819', 'O26821', 'O26822', 'O26823', 'O26829', 'O26831', 'O26832',
        'O26833', 'O26839', 'O26841', 'O26842', 'O26843', 'O26849', 'O26851', 'O26852', 'O26853',
        'O26859', 'O2686', 'O26872', 'O26873', 'O26879', 'O26891', 'O26892', 'O26893', 'O26899',
        'O2690', 'O2691', 'O2692', 'O2693', 'O280', 'O281', 'O282', 'O283', 'O284', 'O285', 'O288',
        'O289', 'O29011', 'O29012', 'O29013', 'O29019', 'O29021', 'O29022', 'O29023', 'O29029',
        'O29091', 'O29092', 'O29093', 'O29099', 'O29111', 'O29112', 'O29113', 'O29119', 'O29121',
        'O29122', 'O29123', 'O29129', 'O29191', 'O29192', 'O29193', 'O29199', 'O29211', 'O29212',
        'O29213', 'O29219', 'O29291', 'O29292', 'O29293', 'O29299', 'O293X1', 'O293X2', 'O293X3',
        'O293X9', 'O2940', 'O2941', 'O2942', 'O2943', 'O295X1', 'O295X2', 'O295X3', 'O295X9',
        'O2960', 'O2961', 'O2962', 'O2963', 'O298X1', 'O298X2', 'O298X3', 'O298X9', 'O2990',
        'O2991', 'O2992', 'O2993', 'O30001', 'O30002', 'O30003', 'O30009', 'O30011', 'O30012',
        'O30013', 'O30019', 'O30021', 'O30022', 'O30023', 'O30029', 'O30031', 'O30032', 'O30033',
        'O30039', 'O30041', 'O30042', 'O30043', 'O30049', 'O30091', 'O30092', 'O30093', 'O30099',
        'O30101', 'O30102', 'O30103', 'O30109', 'O30111', 'O30112', 'O30113', 'O30119', 'O30121',
        'O30122', 'O30123', 'O30129', 'O30191', 'O30192', 'O30193', 'O30199', 'O30201', 'O30202',
        'O30203', 'O30209', 'O30211', 'O30212', 'O30213', 'O30219', 'O30221', 'O30222', 'O30223',
        'O30229', 'O30291', 'O30292', 'O30293', 'O30299', 'O30801', 'O30802', 'O30803', 'O30809',
        'O30811', 'O30812', 'O30813', 'O30819', 'O30821', 'O30822', 'O30823', 'O30829', 'O30891',
        'O30892', 'O30893', 'O30899', 'O3090', 'O3091', 'O3092', 'O3093', 'O3100X0', 'O3100X1',
        'O3100X2', 'O3100X3', 'O3100X4', 'O3100X5', 'O3100X9', 'O3101X0', 'O3101X1', 'O3101X2',
        'O3101X3', 'O3101X4', 'O3101X5', 'O3101X9', 'O3102X0', 'O3102X1', 'O3102X2', 'O3102X3',
        'O3102X4', 'O3102X5', 'O3102X9', 'O3103X0', 'O3103X1', 'O3103X2', 'O3103X3', 'O3103X4',
        'O3103X5', 'O3103X9', 'O3110X0', 'O3110X1', 'O3110X2', 'O3110X3', 'O3110X4', 'O3110X5',
        'O3110X9', 'O3111X0', 'O3111X1', 'O3111X2', 'O3111X3', 'O3111X4', 'O3111X5', 'O3111X9',
        'O3112X0', 'O3112X1', 'O3112X2', 'O3112X3', 'O3112X4', 'O3112X5', 'O3112X9', 'O3113X0',
        'O3113X1', 'O3113X2', 'O3113X3', 'O3113X4', 'O3113X5', 'O3113X9', 'O3120X0', 'O3120X1',
        'O3120X2', 'O3120X3', 'O3120X4', 'O3120X5', 'O3120X9', 'O3121X0', 'O3121X1', 'O3121X2',
        'O3121X3', 'O3121X4', 'O3121X5', 'O3121X9', 'O3122X0', 'O3122X1', 'O3122X2', 'O3122X3',
        'O3122X4', 'O3122X5', 'O3122X9', 'O3123X0', 'O3123X1', 'O3123X2', 'O3123X3', 'O3123X4',
        'O3123X5', 'O3123X9', 'O3130X0', 'O3130X1', 'O3130X2', 'O3130X3', 'O3130X4', 'O3130X5',
        'O3130X9', 'O3131X0', 'O3131X1', 'O3131X2', 'O3131X3', 'O3131X4', 'O3131X5', 'O3131X9',
        'O3132X0', 'O3132X1', 'O3132X2', 'O3132X3', 'O3132X4', 'O3132X5', 'O3132X9', 'O3133X0',
        'O3133X1', 'O3133X2', 'O3133X3', 'O3133X4', 'O3133X5', 'O3133X9', 'O318X10', 'O318X11',
        'O318X12', 'O318X13', 'O318X14', 'O318X15', 'O318X19', 'O318X20', 'O318X21', 'O318X22',
        'O318X23', 'O318X24', 'O318X25', 'O318X29', 'O318X30', 'O318X31', 'O318X32', 'O318X33',
        'O318X34', 'O318X35', 'O318X39', 'O318X90', 'O318X91', 'O318X92', 'O318X93', 'O318X94',
        'O318X95', 'O318X99', 'O320XX0', 'O320XX1', 'O320XX2', 'O320XX3', 'O320XX4', 'O320XX5',
        'O320XX9', 'O321XX0', 'O321XX1', 'O321XX2', 'O321XX3', 'O321XX4', 'O321XX5', 'O321XX9',
        'O322XX0', 'O322XX1', 'O322XX2', 'O322XX3', 'O322XX4', 'O322XX5', 'O322XX9', 'O323XX0',
        'O323XX1', 'O323XX2', 'O323XX3', 'O323XX4', 'O323XX5', 'O323XX9', 'O324XX0', 'O324XX1',
        'O324XX2', 'O324XX3', 'O324XX4', 'O324XX5', 'O324XX9', 'O326XX0', 'O326XX1', 'O326XX2',
        'O326XX3', 'O326XX4', 'O326XX5', 'O326XX9', 'O328XX0', 'O328XX1', 'O328XX2', 'O328XX3',
        'O328XX4', 'O328XX5', 'O328XX9', 'O329XX0', 'O329XX1', 'O329XX2', 'O329XX3', 'O329XX4',
        'O329XX5', 'O329XX9', 'O330', 'O331', 'O332', 'O333XX0', 'O333XX1', 'O333XX2', 'O333XX3',
        'O333XX4', 'O333XX5', 'O333XX9', 'O334XX0', 'O334XX1', 'O334XX2', 'O334XX3', 'O334XX4',
        'O334XX5', 'O334XX9', 'O335XX0', 'O335XX1', 'O335XX2', 'O335XX3', 'O335XX4', 'O335XX5',
        'O335XX9', 'O336XX0', 'O336XX1', 'O336XX2', 'O336XX3', 'O336XX4', 'O336XX5', 'O336XX9',
        'O337', 'O337XX0', 'O337XX1', 'O337XX2', 'O337XX3', 'O337XX4', 'O337XX5', 'O337XX9',
        'O338', 'O339', 'O3400', 'O3401', 'O3402', 'O3403', 'O3410', 'O3411', 'O3412', 'O3413',
        'O3421', 'O34211', 'O34212', 'O34219', 'O3429', 'O3430', 'O3431', 'O3432', 'O3433',
        'O3440', 'O3441', 'O3442', 'O3443', 'O34511', 'O34512', 'O34513', 'O34519', 'O34521',
        'O34522', 'O34523', 'O34529', 'O34531', 'O34532', 'O34533', 'O34539', 'O34591', 'O34592',
        'O34593', 'O34599', 'O3460', 'O3461', 'O3462', 'O3463', 'O3470', 'O3471', 'O3472', 'O3473',
        'O3480', 'O3481', 'O3482', 'O3483', 'O3490', 'O3491', 'O3492', 'O3493', 'O350XX0',
        'O350XX1', 'O350XX2', 'O350XX3', 'O350XX4', 'O350XX5', 'O350XX9', 'O351XX0', 'O351XX1',
        'O351XX2', 'O351XX3', 'O351XX4', 'O351XX5', 'O351XX9', 'O352XX0', 'O352XX1', 'O352XX2',
        'O352XX3', 'O352XX4', 'O352XX5', 'O352XX9', 'O353XX0', 'O353XX1', 'O353XX2', 'O353XX3',
        'O353XX4', 'O353XX5', 'O353XX9', 'O354XX0', 'O354XX1', 'O354XX2', 'O354XX3', 'O354XX4',
        'O354XX5', 'O354XX9', 'O355XX0', 'O355XX1', 'O355XX2', 'O355XX3', 'O355XX4', 'O355XX5',
        'O355XX9', 'O356XX0', 'O356XX1', 'O356XX2', 'O356XX3', 'O356XX4', 'O356XX5', 'O356XX9',
        'O357XX0', 'O357XX1', 'O357XX2', 'O357XX3', 'O357XX4', 'O357XX5', 'O357XX9', 'O358XX0',
        'O358XX1', 'O358XX2', 'O358XX3', 'O358XX4', 'O358XX5', 'O358XX9', 'O359XX0', 'O359XX1',
        'O359XX2', 'O359XX3', 'O359XX4', 'O359XX5', 'O359XX9', 'O360110', 'O360111', 'O360112',
        'O360113', 'O360114', 'O360115', 'O360119', 'O360120', 'O360121', 'O360122', 'O360123',
        'O360124', 'O360125', 'O360129', 'O360130', 'O360131', 'O360132', 'O360133', 'O360134',
        'O360135', 'O360139', 'O360190', 'O360191', 'O360192', 'O360193', 'O360194', 'O360195',
        'O360199', 'O360910', 'O360911', 'O360912', 'O360913', 'O360914', 'O360915', 'O360919',
        'O360920', 'O360921', 'O360922', 'O360923', 'O360924', 'O360925', 'O360929', 'O360930',
        'O360931', 'O360932', 'O360933', 'O360934', 'O360935', 'O360939', 'O360990', 'O360991',
        'O360992', 'O360993', 'O360994', 'O360995', 'O360999', 'O361110', 'O361111', 'O361112',
        'O361113', 'O361114', 'O361115', 'O361119', 'O361120', 'O361121', 'O361122', 'O361123',
        'O361124', 'O361125', 'O361129', 'O361130', 'O361131', 'O361132', 'O361133', 'O361134',
        'O361135', 'O361139', 'O361190', 'O361191', 'O361192', 'O361193', 'O361194', 'O361195',
        'O361199', 'O361910', 'O361911', 'O361912', 'O361913', 'O361914', 'O361915', 'O361919',
        'O361920', 'O361921', 'O361922', 'O361923', 'O361924', 'O361925', 'O361929', 'O361930',
        'O361931', 'O361932', 'O361933', 'O361934', 'O361935', 'O361939', 'O361990', 'O361991',
        'O361992', 'O361993', 'O361994', 'O361995', 'O361999', 'O3620X0', 'O3620X1', 'O3620X2',
        'O3620X3', 'O3620X4', 'O3620X5', 'O3620X9', 'O3621X0', 'O3621X1', 'O3621X2', 'O3621X3',
        'O3621X4', 'O3621X5', 'O3621X9', 'O3622X0', 'O3622X1', 'O3622X2', 'O3622X3', 'O3622X4',
        'O3622X5', 'O3622X9', 'O3623X0', 'O3623X1', 'O3623X2', 'O3623X3', 'O3623X4', 'O3623X5',
        'O3623X9', 'O364XX0', 'O364XX1', 'O364XX2', 'O364XX3', 'O364XX4', 'O364XX5', 'O364XX9',
        'O365110', 'O365111', 'O365112', 'O365113', 'O365114', 'O365115', 'O365119', 'O365120',
        'O365121', 'O365122', 'O365123', 'O365124', 'O365125', 'O365129', 'O365130', 'O365131',
        'O365132', 'O365133', 'O365134', 'O365135', 'O365139', 'O365190', 'O365191', 'O365192',
        'O365193', 'O365194', 'O365195', 'O365199', 'O365910', 'O365911', 'O365912', 'O365913',
        'O365914', 'O365915', 'O365919', 'O365920', 'O365921', 'O365922', 'O365923', 'O365924',
        'O365925', 'O365929', 'O365930', 'O365931', 'O365932', 'O365933', 'O365934', 'O365935',
        'O365939', 'O365990', 'O365991', 'O365992', 'O365993', 'O365994', 'O365995', 'O365999',
        'O3660X0', 'O3660X1', 'O3660X2', 'O3660X3', 'O3660X4', 'O3660X5', 'O3660X9', 'O3661X0',
        'O3661X1', 'O3661X2', 'O3661X3', 'O3661X4', 'O3661X5', 'O3661X9', 'O3662X0', 'O3662X1',
        'O3662X2', 'O3662X3', 'O3662X4', 'O3662X5', 'O3662X9', 'O3663X0', 'O3663X1', 'O3663X2',
        'O3663X3', 'O3663X4', 'O3663X5', 'O3663X9', 'O3670X0', 'O3670X1', 'O3670X2', 'O3670X3',
        'O3670X4', 'O3670X5', 'O3670X9', 'O3671X0', 'O3671X1', 'O3671X2', 'O3671X3', 'O3671X4',
        'O3671X5', 'O3671X9', 'O3672X0', 'O3672X1', 'O3672X2', 'O3672X3', 'O3672X4', 'O3672X5',
        'O3672X9', 'O3673X0', 'O3673X1', 'O3673X2', 'O3673X3', 'O3673X4', 'O3673X5', 'O3673X9',
        'O3680X0', 'O3680X1', 'O3680X2', 'O3680X3', 'O3680X4', 'O3680X5', 'O3680X9', 'O368120',
        'O368121', 'O368122', 'O368123', 'O368124', 'O368125', 'O368129', 'O368130', 'O368131',
        'O368132', 'O368133', 'O368134', 'O368135', 'O368139', 'O368190', 'O368191', 'O368192',
        'O368193', 'O368194', 'O368195', 'O368199', 'O368210', 'O368211', 'O368212', 'O368213',
        'O368214', 'O368215', 'O368219', 'O368220', 'O368221', 'O368222', 'O368223', 'O368224',
        'O368225', 'O368229', 'O368230', 'O368231', 'O368232', 'O368233', 'O368234', 'O368235',
        'O368239', 'O368290', 'O368291', 'O368292', 'O368293', 'O368294', 'O368295', 'O368299',
        'O368910', 'O368911', 'O368912', 'O368913', 'O368914', 'O368915', 'O368919', 'O368920',
        'O368921', 'O368922', 'O368923', 'O368924', 'O368925', 'O368929', 'O368930', 'O368931',
        'O368932', 'O368933', 'O368934', 'O368935', 'O368939', 'O368990', 'O368991', 'O368992',
        'O368993', 'O368994', 'O368995', 'O368999', 'O3690X0', 'O3690X1', 'O3690X2', 'O3690X3',
        'O3690X4', 'O3690X5', 'O3690X9', 'O3691X0', 'O3691X1', 'O3691X2', 'O3691X3', 'O3691X4',
        'O3691X5', 'O3691X9', 'O3692X0', 'O3692X1', 'O3692X2', 'O3692X3', 'O3692X4', 'O3692X5',
        'O3692X9', 'O3693X0', 'O3693X1', 'O3693X2', 'O3693X3', 'O3693X4', 'O3693X5', 'O3693X9',
        'O401XX0', 'O401XX1', 'O401XX2', 'O401XX3', 'O401XX4', 'O401XX5', 'O401XX9', 'O402XX0',
        'O402XX1', 'O402XX2', 'O402XX3', 'O402XX4', 'O402XX5', 'O402XX9', 'O403XX0', 'O403XX1',
        'O403XX2', 'O403XX3', 'O403XX4', 'O403XX5', 'O403XX9', 'O409XX0', 'O409XX1', 'O409XX2',
        'O409XX3', 'O409XX4', 'O409XX5', 'O409XX9', 'O4100X0', 'O4100X1', 'O4100X2', 'O4100X3',
        'O4100X4', 'O4100X5', 'O4100X9', 'O4101X0', 'O4101X1', 'O4101X2', 'O4101X3', 'O4101X4',
        'O4101X5', 'O4101X9', 'O4102X0', 'O4102X1', 'O4102X2', 'O4102X3', 'O4102X4', 'O4102X5',
        'O4102X9', 'O4103X0', 'O4103X1', 'O4103X2', 'O4103X3', 'O4103X4', 'O4103X5', 'O4103X9',
        'O411010', 'O411011', 'O411012', 'O411013', 'O411014', 'O411015', 'O411019', 'O411020',
        'O411021', 'O411022', 'O411023', 'O411024', 'O411025', 'O411029', 'O411030', 'O411031',
        'O411032', 'O411033', 'O411034', 'O411035', 'O411039', 'O411090', 'O411091', 'O411092',
        'O411093', 'O411094', 'O411095', 'O411099', 'O411210', 'O411211', 'O411212', 'O411213',
        'O411214', 'O411215', 'O411219', 'O411220', 'O411221', 'O411222', 'O411223', 'O411224',
        'O411225', 'O411229', 'O411230', 'O411231', 'O411232', 'O411233', 'O411234', 'O411235',
        'O411239', 'O411290', 'O411291', 'O411292', 'O411293', 'O411294', 'O411295', 'O411299',
        'O411410', 'O411411', 'O411412', 'O411413', 'O411414', 'O411415', 'O411419', 'O411420',
        'O411421', 'O411422', 'O411423', 'O411424', 'O411425', 'O411429', 'O411430', 'O411431',
        'O411432', 'O411433', 'O411434', 'O411435', 'O411439', 'O411490', 'O411491', 'O411492',
        'O411493', 'O411494', 'O411495', 'O411499', 'O418X10', 'O418X11', 'O418X12', 'O418X13',
        'O418X14', 'O418X15', 'O418X19', 'O418X20', 'O418X21', 'O418X22', 'O418X23', 'O418X24',
        'O418X25', 'O418X29', 'O418X30', 'O418X31', 'O418X32', 'O418X33', 'O418X34', 'O418X35',
        'O418X39', 'O418X90', 'O418X91', 'O418X92', 'O418X93', 'O418X94', 'O418X95', 'O418X99',
        'O4190X0', 'O4190X1', 'O4190X2', 'O4190X3', 'O4190X4', 'O4190X5', 'O4190X9', 'O4191X0',
        'O4191X1', 'O4191X2', 'O4191X3', 'O4191X4', 'O4191X5', 'O4191X9', 'O4192X0', 'O4192X1',
        'O4192X2', 'O4192X3', 'O4192X4', 'O4192X5', 'O4192X9', 'O4193X0', 'O4193X1', 'O4193X2',
        'O4193X3', 'O4193X4', 'O4193X5', 'O4193X9', 'O4200', 'O42011', 'O42012', 'O42013',
        'O42019', 'O4202', 'O4210', 'O42111', 'O42112', 'O42113', 'O42119', 'O4212', 'O4290',
        'O42911', 'O42912', 'O42913', 'O42919', 'O4292', 'O43011', 'O43012', 'O43013', 'O43019',
        'O43021', 'O43022', 'O43023', 'O43029', 'O43101', 'O43102', 'O43103', 'O43109', 'O43111',
        'O43112', 'O43113', 'O43119', 'O43121', 'O43122', 'O43123', 'O43129', 'O43191', 'O43192',
        'O43193', 'O43199', 'O43211', 'O43212', 'O43213', 'O43219', 'O43221', 'O43222', 'O43223',
        'O43229', 'O43231', 'O43232', 'O43233', 'O43239', 'O43811', 'O43812', 'O43813', 'O43819',
        'O43891', 'O43892', 'O43893', 'O43899', 'O4390', 'O4391', 'O4392', 'O4393', 'O4400',
        'O4401', 'O4402', 'O4403', 'O4410', 'O4411', 'O4412', 'O4413', 'O4420', 'O4421', 'O4422',
        'O4423', 'O4430', 'O4431', 'O4432', 'O4433', 'O4440', 'O4441', 'O4442', 'O4443', 'O4450',
        'O4451', 'O4452', 'O4453', 'O45001', 'O45002', 'O45003', 'O45009', 'O45011', 'O45012',
        'O45013', 'O45019', 'O45021', 'O45022', 'O45023', 'O45029', 'O45091', 'O45092', 'O45093',
        'O45099', 'O458X1', 'O458X2', 'O458X3', 'O458X9', 'O4590', 'O4591', 'O4592', 'O4593',
        'O46001', 'O46002', 'O46003', 'O46009', 'O46011', 'O46012', 'O46013', 'O46019', 'O46021',
        'O46022', 'O46023', 'O46029', 'O46091', 'O46092', 'O46093', 'O46099', 'O468X1', 'O468X2',
        'O468X3', 'O468X9', 'O4690', 'O4691', 'O4692', 'O4693', 'O4700', 'O4702', 'O4703', 'O471',
        'O479', 'O480', 'O481', 'O6000', 'O6002', 'O6003', 'O6010X0', 'O6010X1', 'O6010X2',
        'O6010X3', 'O6010X4', 'O6010X5', 'O6010X9', 'O6012X0', 'O6012X1', 'O6012X2', 'O6012X3',
        'O6012X4', 'O6012X5', 'O6012X9', 'O6013X0', 'O6013X1', 'O6013X2', 'O6013X3', 'O6013X4',
        'O6013X5', 'O6013X9', 'O6014X0', 'O6014X1', 'O6014X2', 'O6014X3', 'O6014X4', 'O6014X5',
        'O6014X9', 'O6020X0', 'O6020X1', 'O6020X2', 'O6020X3', 'O6020X4', 'O6020X5', 'O6020X9',
        'O6022X0', 'O6022X1', 'O6022X2', 'O6022X3', 'O6022X4', 'O6022X5', 'O6022X9', 'O6023X0',
        'O6023X1', 'O6023X2', 'O6023X3', 'O6023X4', 'O6023X5', 'O6023X9', 'O610', 'O611', 'O618',
        'O619', 'O620', 'O621', 'O622', 'O623', 'O624', 'O628', 'O629', 'O630', 'O631', 'O632',
        'O639', 'O640XX0', 'O640XX1', 'O640XX2', 'O640XX3', 'O640XX4', 'O640XX5', 'O640XX9',
        'O641XX0', 'O641XX1', 'O641XX2', 'O641XX3', 'O641XX4', 'O641XX5', 'O641XX9', 'O642XX0',
        'O642XX1', 'O642XX2', 'O642XX3', 'O642XX4', 'O642XX5', 'O642XX9', 'O643XX0', 'O643XX1',
        'O643XX2', 'O643XX3', 'O643XX4', 'O643XX5', 'O643XX9', 'O644XX0', 'O644XX1', 'O644XX2',
        'O644XX3', 'O644XX4', 'O644XX5', 'O644XX9', 'O645XX0', 'O645XX1', 'O645XX2', 'O645XX3',
        'O645XX4', 'O645XX5', 'O645XX9', 'O648XX0', 'O648XX1', 'O648XX2', 'O648XX3', 'O648XX4',
        'O648XX5', 'O648XX9', 'O649XX0', 'O649XX1', 'O649XX2', 'O649XX3', 'O649XX4', 'O649XX5',
        'O649XX9', 'O650', 'O651', 'O652', 'O653', 'O654', 'O655', 'O658', 'O659', 'O660', 'O661',
        'O662', 'O663', 'O6640', 'O6641', 'O665', 'O666', 'O668', 'O669', 'O670', 'O678', 'O679',
        'O68', 'O690XX0', 'O690XX1', 'O690XX2', 'O690XX3', 'O690XX4', 'O690XX5', 'O690XX9',
        'O691XX0', 'O691XX1', 'O691XX2', 'O691XX3', 'O691XX4', 'O691XX5', 'O691XX9', 'O692XX0',
        'O692XX1', 'O692XX2', 'O692XX3', 'O692XX4', 'O692XX5', 'O692XX9', 'O693XX0', 'O693XX1',
        'O693XX2', 'O693XX3', 'O693XX4', 'O693XX5', 'O693XX9', 'O694XX0', 'O694XX1', 'O694XX2',
        'O694XX3', 'O694XX4', 'O694XX5', 'O694XX9', 'O695XX0', 'O695XX1', 'O695XX2', 'O695XX3',
        'O695XX4', 'O695XX5', 'O695XX9', 'O6981X0', 'O6981X1', 'O6981X2', 'O6981X3', 'O6981X4',
        'O6981X5', 'O6981X9', 'O6982X0', 'O6982X1', 'O6982X2', 'O6982X3', 'O6982X4', 'O6982X5',
        'O6982X9', 'O6989X0', 'O6989X1', 'O6989X2', 'O6989X3', 'O6989X4', 'O6989X5', 'O6989X9',
        'O699XX0', 'O699XX1', 'O699XX2', 'O699XX3', 'O699XX4', 'O699XX5', 'O699XX9', 'O700',
        'O701', 'O702', 'O7020', 'O7021', 'O7022', 'O7023', 'O703', 'O704', 'O709', 'O7100',
        'O7102', 'O7103', 'O711', 'O712', 'O713', 'O714', 'O715', 'O716', 'O717', 'O7181', 'O7182',
        'O7189', 'O719', 'O720', 'O721', 'O722', 'O723', 'O730', 'O731', 'O740', 'O741', 'O742',
        'O743', 'O744', 'O745', 'O746', 'O747', 'O748', 'O749', 'O750', 'O751', 'O752', 'O753',
        'O754', 'O755', 'O7581', 'O7582', 'O7589', 'O759', 'O76', 'O770', 'O771', 'O778', 'O779',
        'O80', 'O82', 'O85', 'O860', 'O8611', 'O8612', 'O8613', 'O8619', 'O8620', 'O8621', 'O8622',
        'O8629', 'O864', 'O8681', 'O8689', 'O870', 'O871', 'O872', 'O873', 'O874', 'O878', 'O879',
        'O88011', 'O88012', 'O88013', 'O88019', 'O8802', 'O8803', 'O88111', 'O88112', 'O88113',
        'O88119', 'O8812', 'O8813', 'O88211', 'O88212', 'O88213', 'O88219', 'O8822', 'O8823',
        'O88311', 'O88312', 'O88313', 'O88319', 'O8832', 'O8833', 'O88811', 'O88812', 'O88813',
        'O88819', 'O8882', 'O8883', 'O8901', 'O8909', 'O891', 'O892', 'O893', 'O894', 'O895',
        'O896', 'O898', 'O899', 'O900', 'O901', 'O902', 'O903', 'O904', 'O905', 'O906', 'O9081',
        'O9089', 'O909', 'O91011', 'O91012', 'O91013', 'O91019', 'O9102', 'O9103', 'O91111',
        'O91112', 'O91113', 'O91119', 'O9112', 'O9113', 'O91211', 'O91212', 'O91213', 'O91219',
        'O9122', 'O9123', 'O92011', 'O92012', 'O92013', 'O92019', 'O9202', 'O9203', 'O92111',
        'O92112', 'O92113', 'O92119', 'O9212', 'O9213', 'O9220', 'O9229', 'O923', 'O924', 'O925',
        'O926', 'O9270', 'O9279', 'O98011', 'O98012', 'O98013', 'O98019', 'O9802', 'O9803',
        'O98111', 'O98112', 'O98113', 'O98119', 'O9812', 'O9813', 'O98211', 'O98212', 'O98213',
        'O98219', 'O9822', 'O9823', 'O98311', 'O98312', 'O98313', 'O98319', 'O9832', 'O9833',
        'O98411', 'O98412', 'O98413', 'O98419', 'O9842', 'O9843', 'O98511', 'O98512', 'O98513',
        'O98519', 'O9852', 'O9853', 'O98611', 'O98612', 'O98613', 'O98619', 'O9862', 'O9863',
        'O98711', 'O98712', 'O98713', 'O98719', 'O9872', 'O9873', 'O98811', 'O98812', 'O98813',
        'O98819', 'O9882', 'O9883', 'O98911', 'O98912', 'O98913', 'O98919', 'O9892', 'O9893',
        'O99011', 'O99012', 'O99013', 'O99019', 'O9902', 'O9903', 'O99111', 'O99112', 'O99113',
        'O99119', 'O9912', 'O9913', 'O99210', 'O99211', 'O99212', 'O99213', 'O99214', 'O99215',
        'O99280', 'O99281', 'O99282', 'O99283', 'O99284', 'O99285', 'O99310', 'O99311', 'O99312',
        'O99313', 'O99314', 'O99315', 'O99320', 'O99321', 'O99322', 'O99323', 'O99324', 'O99325',
        'O99330', 'O99331', 'O99332', 'O99333', 'O99334', 'O99335', 'O99340', 'O99341', 'O99342',
        'O99343', 'O99344', 'O99345', 'O99350', 'O99351', 'O99352', 'O99353', 'O99354', 'O99355',
        'O99411', 'O99412', 'O99413', 'O99419', 'O9942', 'O9943', 'O99511', 'O99512', 'O99513',
        'O99519', 'O9952', 'O9953', 'O99611', 'O99612', 'O99613', 'O99619', 'O9962', 'O9963',
        'O99711', 'O99712', 'O99713', 'O99719', 'O9972', 'O9973', 'O99810', 'O99814', 'O99815',
        'O99820', 'O99824', 'O99825', 'O99830', 'O99834', 'O99835', 'O99840', 'O99841', 'O99842',
        'O99843', 'O99844', 'O99845', 'O9989', 'O9A111', 'O9A112', 'O9A113', 'O9A119', 'O9A12',
        'O9A13', 'O9A211', 'O9A212', 'O9A213', 'O9A219', 'O9A22', 'O9A23', 'O9A311', 'O9A312',
        'O9A313', 'O9A319', 'O9A32', 'O9A33', 'O9A411', 'O9A412', 'O9A413', 'O9A419', 'O9A42',
        'O9A43', 'O9A511', 'O9A512', 'O9A513', 'O9A519', 'O9A52', 'O9A53', 'Z0371', 'Z0372',
        'Z0373', 'Z0374', 'Z0375', 'Z0379', 'Z331', 'Z332', 'Z333', 'Z3400', 'Z3401', 'Z3402',
        'Z3403', 'Z3480', 'Z3481', 'Z3482', 'Z3483', 'Z3490', 'Z3491', 'Z3492', 'Z3493', 'Z36'
    }

    ICD9CM = {
        '630', '6310', '6318', '632', '63300', '63301', '63310', '63311', '63320', '63321',
        '63380', '63381', '63390', '63391', '63400', '63401', '63402', '63410', '63411', '63412',
        '63420', '63421', '63422', '63430', '63431', '63432', '63440', '63441', '63442', '63450',
        '63451', '63452', '63460', '63461', '63462', '63470', '63471', '63472', '63480', '63481',
        '63482', '63490', '63491', '63492', '63500', '63501', '63502', '63510', '63511', '63512',
        '63520', '63521', '63522', '63530', '63531', '63532', '63540', '63541', '63542', '63550',
        '63551', '63552', '63560', '63561', '63562', '63570', '63571', '63572', '63580', '63581',
        '63582', '63590', '63591', '63592', '63600', '63601', '63602', '63610', '63611', '63612',
        '63620', '63621', '63622', '63630', '63631', '63632', '63640', '63641', '63642', '63650',
        '63651', '63652', '63660', '63661', '63662', '63670', '63671', '63672', '63680', '63681',
        '63682', '63690', '63691', '63692', '63700', '63701', '63702', '63710', '63711', '63712',
        '63720', '63721', '63722', '63730', '63731', '63732', '63740', '63741', '63742', '63750',
        '63751', '63752', '63760', '63761', '63762', '63770', '63771', '63772', '63780', '63781',
        '63782', '63790', '63791', '63792', '6380', '6381', '6382', '6383', '6384', '6385', '6386',
        '6387', '6388', '6389', '6390', '6391', '6392', '6393', '6394', '6395', '6396', '6398',
        '6399', '64000', '64001', '64003', '64080', '64081', '64083', '64090', '64091', '64093',
        '64100', '64101', '64103', '64110', '64111', '64113', '64120', '64121', '64123', '64130',
        '64131', '64133', '64180', '64181', '64183', '64190', '64191', '64193', '64200', '64201',
        '64202', '64203', '64204', '64210', '64211', '64212', '64213', '64214', '64220', '64221',
        '64222', '64223', '64224', '64230', '64231', '64232', '64233', '64234', '64240', '64241',
        '64242', '64243', '64244', '64250', '64251', '64252', '64253', '64254', '64260', '64261',
        '64262', '64263', '64264', '64270', '64271', '64272', '64273', '64274', '64290', '64291',
        '64292', '64293', '64294', '64300', '64301', '64303', '64310', '64311', '64313', '64320',
        '64321', '64323', '64380', '64381', '64383', '64390', '64391', '64393', '64400', '64403',
        '64410', '64413', '64420', '64421', '64510', '64511', '64513', '64520', '64521', '64523',
        '64600', '64601', '64603', '64610', '64611', '64612', '64613', '64614', '64620', '64621',
        '64622', '64623', '64624', '64630', '64631', '64633', '64640', '64641', '64642', '64643',
        '64644', '64650', '64651', '64652', '64653', '64654', '64660', '64661', '64662', '64663',
        '64664', '64670', '64671', '64673', '64680', '64681', '64682', '64683', '64684', '64690',
        '64691', '64693', '64700', '64701', '64702', '64703', '64704', '64710', '64711', '64712',
        '64713', '64714', '64720', '64721', '64722', '64723', '64724', '64730', '64731', '64732',
        '64733', '64734', '64740', '64741', '64742', '64743', '64744', '64750', '64751', '64752',
        '64753', '64754', '64760', '64761', '64762', '64763', '64764', '64780', '64781', '64782',
        '64783', '64784', '64790', '64791', '64792', '64793', '64794', '64800', '64801', '64802',
        '64803', '64804', '64810', '64811', '64812', '64813', '64814', '64820', '64821', '64822',
        '64823', '64824', '64830', '64831', '64832', '64833', '64834', '64840', '64841', '64842',
        '64843', '64844', '64850', '64851', '64852', '64853', '64854', '64860', '64861', '64862',
        '64863', '64864', '64870', '64871', '64872', '64873', '64874', '64880', '64881', '64882',
        '64883', '64884', '64890', '64891', '64892', '64893', '64894', '64900', '64901', '64902',
        '64903', '64904', '64910', '64911', '64912', '64913', '64914', '64920', '64921', '64922',
        '64923', '64924', '64930', '64931', '64932', '64933', '64934', '64940', '64941', '64942',
        '64943', '64944', '64950', '64951', '64953', '64960', '64961', '64962', '64963', '64964',
        '64970', '64971', '64973', '64981', '64982', '650', '65100', '65101', '65103', '65110',
        '65111', '65113', '65120', '65121', '65123', '65130', '65131', '65133', '65140', '65141',
        '65143', '65150', '65151', '65153', '65160', '65161', '65163', '65170', '65171', '65173',
        '65180', '65181', '65183', '65190', '65191', '65193', '65200', '65201', '65203', '65210',
        '65211', '65213', '65220', '65221', '65223', '65230', '65231', '65233', '65240', '65241',
        '65243', '65250', '65251', '65253', '65260', '65261', '65263', '65270', '65271', '65273',
        '65280', '65281', '65283', '65290', '65291', '65293', '65300', '65301', '65303', '65310',
        '65311', '65313', '65320', '65321', '65323', '65330', '65331', '65333', '65340', '65341',
        '65343', '65350', '65351', '65353', '65360', '65361', '65363', '65370', '65371', '65373',
        '65380', '65381', '65383', '65390', '65391', '65393', '65400', '65401', '65402', '65403',
        '65404', '65410', '65411', '65412', '65413', '65414', '65420', '65421', '65423', '65430',
        '65431', '65432', '65433', '65434', '65440', '65441', '65442', '65443', '65444', '65450',
        '65451', '65452', '65453', '65454', '65460', '65461', '65462', '65463', '65464', '65470',
        '65471', '65472', '65473', '65474', '65480', '65481', '65482', '65483', '65484', '65490',
        '65491', '65492', '65493', '65494', '65500', '65501', '65503', '65510', '65511', '65513',
        '65520', '65521', '65523', '65530', '65531', '65533', '65540', '65541', '65543', '65550',
        '65551', '65553', '65560', '65561', '65563', '65570', '65571', '65573', '65580', '65581',
        '65583', '65590', '65591', '65593', '65600', '65601', '65603', '65610', '65611', '65613',
        '65620', '65621', '65623', '65630', '65631', '65633', '65640', '65641', '65643', '65650',
        '65651', '65653', '65660', '65661', '65663', '65670', '65671', '65673', '65680', '65681',
        '65683', '65690', '65691', '65693', '65700', '65701', '65703', '65800', '65801', '65803',
        '65810', '65811', '65813', '65820', '65821', '65823', '65830', '65831', '65833', '65840',
        '65841', '65843', '65880', '65881', '65883', '65890', '65891', '65893', '65900', '65901',
        '65903', '65910', '65911', '65913', '65920', '65921', '65923', '65930', '65931', '65933',
        '65940', '65941', '65943', '65950', '65951', '65953', '65960', '65961', '65963', '65970',
        '65971', '65973', '65980', '65981', '65983', '65990', '65991', '65993', '66000', '66001',
        '66003', '66010', '66011', '66013', '66020', '66021', '66023', '66030', '66031', '66033',
        '66040', '66041', '66043', '66050', '66051', '66053', '66060', '66061', '66063', '66070',
        '66071', '66073', '66080', '66081', '66083', '66090', '66091', '66093', '66100', '66101',
        '66103', '66110', '66111', '66113', '66120', '66121', '66123', '66130', '66131', '66133',
        '66140', '66141', '66143', '66190', '66191', '66193', '66200', '66201', '66203', '66210',
        '66211', '66213', '66220', '66221', '66223', '66230', '66231', '66233', '66300', '66301',
        '66303', '66310', '66311', '66313', '66320', '66321', '66323', '66330', '66331', '66333',
        '66340', '66341', '66343', '66350', '66351', '66353', '66360', '66361', '66363', '66380',
        '66381', '66383', '66390', '66391', '66393', '66400', '66401', '66404', '66410', '66411',
        '66414', '66420', '66421', '66424', '66430', '66431', '66434', '66440', '66441', '66444',
        '66450', '66451', '66454', '66460', '66461', '66464', '66480', '66481', '66484', '66490',
        '66491', '66494', '66500', '66501', '66503', '66510', '66511', '66520', '66522', '66524',
        '66530', '66531', '66534', '66540', '66541', '66544', '66550', '66551', '66554', '66560',
        '66561', '66564', '66570', '66571', '66572', '66574', '66580', '66581', '66582', '66583',
        '66584', '66590', '66591', '66592', '66593', '66594', '66600', '66602', '66604', '66610',
        '66612', '66614', '66620', '66622', '66624', '66630', '66632', '66634', '66700', '66702',
        '66704', '66710', '66712', '66714', '66800', '66801', '66802', '66803', '66804', '66810',
        '66811', '66812', '66813', '66814', '66820', '66821', '66822', '66823', '66824', '66880',
        '66881', '66882', '66883', '66884', '66890', '66891', '66892', '66893', '66894', '66900',
        '66901', '66902', '66903', '66904', '66910', '66911', '66912', '66913', '66914', '66920',
        '66921', '66922', '66923', '66924', '66930', '66932', '66934', '66940', '66941', '66942',
        '66943', '66944', '66950', '66951', '66960', '66961', '66970', '66971', '66980', '66981',
        '66982', '66983', '66984', '66990', '66991', '66992', '66993', '66994', '67000', '67002',
        '67004', '67100', '67101', '67102', '67103', '67104', '67110', '67111', '67112', '67113',
        '67114', '67120', '67121', '67122', '67123', '67124', '67130', '67131', '67133', '67140',
        '67142', '67144', '67150', '67151', '67152', '67153', '67154', '67180', '67181', '67182',
        '67183', '67184', '67190', '67191', '67192', '67193', '67194', '67200', '67202', '67204',
        '67300', '67301', '67302', '67303', '67304', '67310', '67311', '67312', '67313', '67314',
        '67320', '67321', '67322', '67323', '67324', '67330', '67331', '67332', '67333', '67334',
        '67380', '67381', '67382', '67383', '67384', '67400', '67401', '67402', '67403', '67404',
        '67410', '67412', '67414', '67420', '67422', '67424', '67430', '67432', '67434', '67440',
        '67442', '67444', '67450', '67451', '67452', '67453', '67454', '67480', '67482', '67484',
        '67490', '67492', '67494', '67500', '67501', '67502', '67503', '67504', '67510', '67511',
        '67512', '67513', '67514', '67520', '67521', '67522', '67523', '67524', '67580', '67581',
        '67582', '67583', '67584', '67590', '67591', '67592', '67593', '67594', '67600', '67601',
        '67602', '67603', '67604', '67610', '67611', '67612', '67613', '67614', '67620', '67621',
        '67622', '67623', '67624', '67630', '67631', '67632', '67633', '67634', '67640', '67641',
        '67642', '67643', '67644', '67650', '67651', '67652', '67653', '67654', '67660', '67661',
        '67662', '67663', '67664', '67680', '67681', '67682', '67683', '67684', '67690', '67691',
        '67692', '67693', '67694', '677', '67800', '67801', '67803', '67810', '67811', '67813',
        '67900', '67901', '67902', '67903', '67904', '67910', '67911', '67912', '67913', '67914'
    }

    SNOMEDCT = {
        '10058006', '10217006', '102872000', '102873005', '102875003', '102876002', '106004004',
        '106007006', '106008001', '106009009', '106010004', '10853001', '111451002', '111452009',
        '111453004', '111454005', '111458008', '11209007', '1125006', '11454006', '11687002',
        '11942004', '12062007', '126941005', '127365008', '127366009', '127367000', '127368005',
        '127369002', '127370001', '127371002', '127372009', '127373004', '127374005', '128077009',
        '13010001', '1343000', '13842006', '14331002', '14418008', '14918004', '15394000',
        '15504009', '1639007', '16574001', '16950007', '169560008', '169561007', '169562000',
        '169563005', '169564004', '169565003', '169566002', '169567006', '169568001', '17263003',
        '17285009', '17433009', '17618008', '17787002', '178280004', '18260003', '18606002',
        '18909006', '1938002', '19729005', '198332009', '198347000', '198609003', '198617006',
        '198620003', '198624007', '198626009', '198627000', '198903000', '198905007', '198906008',
        '198917009', '198918004', '198920001', '198922009', '198923004', '198925006', '198927003',
        '198928008', '198949009', '198951008', '198952001', '198953006', '198954000', '198965005',
        '198966006', '198967002', '198968007', '198983002', '198984008', '198985009', '198986005',
        '198997005', '198999008', '199000005', '199002002', '199003007', '199006004', '199049003',
        '199063009', '199064003', '199093003', '199094009', '199095005', '199096006', '199099004',
        '199100007', '199101006', '199102004', '199106001', '199107005', '199108000', '199109008',
        '199110003', '199111004', '199112006', '199127006', '199128001', '199129009', '199130004',
        '199139003', '199153003', '199154009', '199156006', '199157002', '199158007', '199159004',
        '199161008', '199163006', '199164000', '199165004', '199166003', '199175001', '199178004',
        '199179007', '199180005', '199181009', '199183007', '199185000', '199186004', '199187008',
        '199188003', '199192005', '199193000', '199194006', '199195007', '199203001', '199205008',
        '199293005', '199294004', '199295003', '199296002', '199305006', '199446000', '199461004',
        '199463001', '199464007', '199466009', '199468005', '199469002', '199470001', '199471002',
        '199511005', '199512003', '199513008', '199514002', '199595002', '199596001', '199597005',
        '199710008', '199711007', '199715003', '199719009', '199732004', '199745000', '199774009',
        '199775005', '199783004', '199784005', '199819004', '199821009', '199824001', '199825000',
        '199833004', '199834005', '199838008', '199839000', '199847000', '199848005', '199857004',
        '199858009', '199860006', '199862003', '199863008', '199869007', '199870008', '199874004',
        '199875003', '199880007', '199881006', '199889008', '199890004', '199895009', '199896005',
        '199916005', '199917001', '199925004', '199926003', '199930000', '199931001', '199934009',
        '199935005', '199958008', '199960005', '199961009', '199964001', '199965000', '199969006',
        '199970007', '199972004', '199974003', '199975002', '199977005', '199979008', '199980006',
        '199990003', '199991004', '199993001', '199997000', '200025008', '200030007', '200031006',
        '200046004', '200049006', '200050006', '200051005', '200052003', '200054002', '200056000',
        '200057009', '200058004', '200059007', '200061003', '200063000', '200064006', '200065007',
        '200066008', '200068009', '200069001', '200070000', '200075005', '200077002', '200078007',
        '200099005', '200100002', '200101003', '200102005', '200105007', '200106008', '200107004',
        '200108009', '200111005', '200112003', '200113008', '200114002', '200117009', '200118004',
        '200125006', '200164009', '200173001', '200181000', '200182007', '200185009', '200187001',
        '200190007', '200191006', '200195002', '200196001', '200204002', '200206000', '200207009',
        '200208004', '200209007', '200215007', '200216008', '200217004', '200218009', '200222004',
        '200224003', '200226001', '200227005', '200237000', '200238005', '200249004', '200251000',
        '200252007', '200253002', '200254008', '200277008', '200280009', '200281008', '200284000',
        '200286003', '200288002', '200289005', '200290001', '200291002', '200294005', '200295006',
        '200296007', '200297003', '200299000', '200301007', '200302000', '200303005', '200304004',
        '200308001', '200309009', '200310004', '200311000', '200330000', '200331001', '200332008',
        '200333003', '200337002', '200338007', '200342005', '200343000', '201134009', '204470001',
        '206070006', '206112008', '206113003', '206114009', '206115005', '206116006', '206117002',
        '206118007', '206121009', '206122002', '206123007', '206134005', '206137003', '206138008',
        '206146009', '206148005', '206149002', '206242003', '206244002', '20625004', '20845005',
        '20932005', '20956009', '21504004', '21987001', '22271007', '22399000', '2261009',
        '22846003', '23171006', '234058009', '23508005', '237186006', '237188007', '237189004',
        '237190008', '237198001', '237202004', '237206001', '237209008', '237233002', '237238006',
        '237239003', '237240001', '237241002', '237242009', '237244005', '237253003', '237254009',
        '237260009', '237261008', '237262001', '237270006', '237271005', '237272003', '237273008',
        '237274002', '237275001', '237276000', '237277009', '237279007', '237281009', '237282002',
        '237286004', '237305004', '237306003', '237307007', '237309005', '237310000', '237321009',
        '237325000', '237327008', '237328003', '237329006', '237336007', '237337003', '237338008',
        '237342006', '237343001', '237345008', '237346009', '237347000', '237348005', '237349002',
        '237350002', '237351003', '237352005', '238820002', '23885003', '239101008', '239102001',
        '239103006', '239104000', '239105004', '23960006', '24042004', '24082006', '24258008',
        '24342007', '24699006', '248985009', '249189006', '249196008', '249218000', '249219008',
        '249220002', '25053000', '25113000', '25825004', '26158002', '26528001', '267197003',
        '267199000', '267204006', '267257007', '267265005', '267266006', '267268007', '267271004',
        '267272006', '267276009', '267280004', '267282007', '267283002', '267284008', '267317007',
        '267340006', '267350007', '26840006', '26850007', '268809007', '268812005', '268813000',
        '268863005', '268864004', '268865003', '27015006', '270498000', '270500004', '27075004',
        '27214003', '27215002', '27388005', '273982004', '274117006', '274126009', '275412000',
        '275429002', '275434003', '276462003', '276881003', '27696007', '279225001', '280732008',
        '281307002', '282020008', '2858002', '28773001', '288208001', '288250001', '289311005',
        '289312003', '29057008', '290653008', '291665000', '29399001', '29847008', '300927001',
        '302929008', '302945005', '307632004', '308133005', '308134004', '308135003', '308136002',
        '308137006', '308140006', '308187004', '30850008', '31026002', '310592002', '310594001',
        '312977003', '312988009', '312989001', '312990005', '314204000', '31481000', '31516002',
        '31563000', '31601007', '32999002', '33058001', '33627001', '34150001', '34242002',
        '34262005', '34327003', '34801009', '34842007', '34981006', '35255008', '35347003',
        '35656003', '35882009', '361095003', '361096002', '36497006', '36697001', '37139009',
        '371607000', '373680009', '37618003', '38010008', '38534008', '387692004', '387696001',
        '387699008', '387700009', '38905006', '392280004', '396544001', '397752008', '397952002',
        '398019008', '398254007', '398262004', '399031001', '400170001', '40125005', '40193008',
        '402836009', '403528000', '405256006', '405733001', '405736009', '40609001', '41114007',
        '415810004', '41587001', '417426005', '41991004', '42537006', '42599006', '427139004',
        '428017002', '428165003', '428230005', '428252001', '428707000', '430881000', '430883002',
        '43715006', '442478007', '443460007', '44622003', '44772007', '44918005', '45307008',
        '46311005', '46502006', '46764007', '46894009', '47200007', '47236005', '47780009',
        '47821001', '4787007', '48194001', '48287005', '4907004', '49177006', '49279000',
        '49561003', '49815007', '5010004', '50258003', '51154004', '51495008', '51519001',
        '51920004', '52700006', '52772002', '53419009', '53443007', '54212005', '54449002',
        '54679003', '54844002', '55565007', '55581002', '5626004', '56272000', '56313000',
        '57220000', '5740008', '57630001', '57759005', '58532003', '58703003', '59136001',
        '59466002', '59795007', '5984000', '60000008', '60601008', '61007003', '61714007',
        '62023000', '62129004', '62131008', '6234006', '62377009', '62410004', '62583006',
        '62657007', '63040001', '63795001', '6383007', '64171002', '64229006', '64646001',
        '64954002', '65409004', '65727000', '6594005', '66119008', '66294006', '6636004',
        '66844003', '67229002', '67359005', '67486009', '682004', '6825008', '6867004', '6891008',
        '69270005', '69532007', '70068004', '70603007', '70964000', '71612002', '7245003',
        '7266006', '72892002', '73972002', '75022004', '7504005', '75836008', '75933004',
        '76012002', '76751001', '76771005', '77206006', '77259008', '77278008', '77386006',
        '77563000', '7768008', '78408007', '79179003', '79222000', '79290002', '79414005',
        '79586000', '79668009', '79748007', '79839005', '80002007', '80113008', '80856001',
        '81448000', '81557008', '81677009', '82634006', '82661006', '83074005', '83094001',
        '83916000', '8393005', '84007008', '84216001', '84693004', '85542007', '86081009',
        '86256001', '87038002', '87043009', '87383005', '87605005', '87814002', '88178009',
        '88697005', '88887003', '89244003', '89700002', '90009001', '90532005', '90968009',
        '9107002', '91957002', '9279009', '9293002', '9442009', '95212006', '95605009', '9899009'
    }


class MaternalPostPartumDepressionCare(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1013'
    VALUE_SET_NAME = 'Maternal Post Partum Depression Care'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428231000124106'}


class MaternalPostPartumDepressionScreening(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1014'
    VALUE_SET_NAME = 'Maternal Post Partum Depression Screening'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428221000124108'}


class DeliveryLiveBirths(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.111.12.1015'
    VALUE_SET_NAME = 'Delivery Live Births'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '59400', '59409', '59410', '59412', '59414', '59425', '59426', '59430', '59510', '59514',
        '59515', '59525', '59610', '59612', '59614', '59618', '59620', '59622'
    }

    SNOMEDCT = {
        '10745001', '11466000', '14119008', '15413009', '16819009', '177141003', '177142005',
        '177143000', '177152009', '177157003', '177158008', '177161009', '177162002', '177164001',
        '177167008', '177168003', '177170007', '177173009', '177174003', '177175002', '177176001',
        '177179008', '177180006', '177181005', '177184002', '177185001', '177203002', '177204008',
        '177212000', '17860005', '18625004', '19390001', '22633006', '2321005', '236973005',
        '236974004', '236975003', '236976002', '236977006', '236978001', '236980007', '236981006',
        '236982004', '236983009', '236984003', '236985002', '236986001', '236987005', '236989008',
        '236991000', '236994008', '237311001', '25296001', '25828002', '26313002', '265639000',
        '274130007', '275168001', '275169009', '28542003', '287976008', '287977004', '288193006',
        '28860009', '29613008', '302382009', '302383004', '302384005', '30476003', '306727001',
        '315308008', '33807004', '359940006', '359943008', '384729004', '384730009', '38479009',
        '386622003', '387711001', '398307005', '40219000', '40704000', '40792007', '408819007',
        '41059002', '416055001', '417121007', '4504004', '450483001', '450484007', '450798003',
        '45718005', '46972000', '48204000', '5191001', '54973000', '5556001', '56620000',
        '57271003', '58705005', '61027002', '61586001', '62508004', '62688006', '65243006',
        '66201006', '69162008', '69422002', '69621003', '699999008', '700000006', '71166009',
        '72492007', '75928003', '84195007', '85403009', '89053004', '89346004', '89849000',
        '90438006'
    }


class GonococcalInfectionsAndVenerealDiseases(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1001'
    VALUE_SET_NAME = 'Gonococcal Infections and Venereal Diseases'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'A5001', 'A5002', 'A5003', 'A5004', 'A5005', 'A5006', 'A5007', 'A5008', 'A5030', 'A5032',
        'A5039', 'A5043', 'A5044', 'A5051', 'A5053', 'A5054', 'A5055', 'A5056', 'A5400', 'A5401',
        'A5402', 'A5403', 'A5409', 'A541', 'A5421', 'A5422', 'A5423', 'A5424', 'A5429', 'A5430',
        'A5431', 'A5432', 'A5433', 'A5439', 'A5440', 'A5441', 'A5442', 'A5443', 'A5449', 'A545',
        'A546', 'A5481', 'A5482', 'A5483', 'A5484', 'A5485', 'A5486', 'A5489', 'A549', 'A57',
        'A58', 'A630', 'A638', 'A64', 'A690', 'A691'
    }

    ICD9CM = {
        '0980', '09810', '09811', '09812', '09813', '09814', '09815', '09816', '09817', '09819',
        '0982', '09830', '09831', '09832', '09833', '09834', '09835', '09836', '09837', '09839',
        '09840', '09841', '09842', '09843', '09849', '09850', '09851', '09852', '09853', '09859',
        '0986', '0987', '09881', '09882', '09883', '09884', '09885', '09886', '09889', '0990',
        '0991', '0992', '0993', '09940', '09941', '09949', '09950', '09951', '09952', '09953',
        '09954', '09955', '09956', '09959', '0998', '0999'
    }

    SNOMEDCT = {
        '111806005', '111807001', '11906007', '12373006', '151004', '15628003', '17305005',
        '186915005', '186931002', '186939000', '186946009', '197848003', '197967000', '199161008',
        '199163006', '199164000', '199165004', '199166003', '20943002', '231858009', '235861001',
        '235863003', '236682002', '236687008', '236766009', '236772009', '237038001', '237042003',
        '237046000', '237069002', '237083000', '237095000', '237096004', '238419002', '2390000',
        '23975003', '240039005', '240571007', '240572000', '240573005', '240574004', '240575003',
        '240576002', '240577006', '240578001', '240579009', '240581006', '240582004', '240602008',
        '240603003', '240604009', '24868007', '266138002', '272006008', '272262003', '27681008',
        '28438004', '28572009', '29864006', '30168008', '301990003', '307423008', '31999004',
        '35255008', '35526001', '35876006', '40149008', '402957000', '406581000', '42746002',
        '44412000', '444834005', '44743006', '45377007', '46699001', '5085001', '50970007',
        '53529004', '53664003', '54825009', '60335002', '60893000', '61048000', '65049003',
        '65295003', '74372003', '76802005', '80388004', '80604007', '88813005', '9091006',
        '9241004'
    }


class Syphilis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1002'
    VALUE_SET_NAME = 'Syphilis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'A5009', 'A501', 'A502', 'A5031', 'A5040', 'A5041', 'A5042', 'A5045', 'A5049', 'A5052',
        'A5057', 'A5059', 'A506', 'A507', 'A509', 'A510', 'A511', 'A512', 'A5131', 'A5132',
        'A5139', 'A5141', 'A5142', 'A5143', 'A5144', 'A5145', 'A5146', 'A5149', 'A515', 'A519',
        'A5200', 'A5201', 'A5202', 'A5203', 'A5204', 'A5205', 'A5206', 'A5209', 'A5210', 'A5211',
        'A5212', 'A5213', 'A5214', 'A5215', 'A5216', 'A5217', 'A5219', 'A522', 'A523', 'A5271',
        'A5272', 'A5273', 'A5274', 'A5275', 'A5276', 'A5277', 'A5278', 'A5279', 'A528', 'A529',
        'A530', 'A539'
    }

    ICD9CM = {
        '0900', '0901', '0902', '0903', '09040', '09041', '09042', '09049', '0905', '0906', '0907',
        '0909', '0910', '0911', '0912', '0913', '0914', '09150', '09151', '09152', '09161',
        '09162', '09169', '0917', '09181', '09182', '09189', '0919', '0920', '0929', '0930',
        '0931', '09320', '09321', '09322', '09323', '09324', '09381', '09382', '09389', '0939',
        '0940', '0941', '0942', '0943', '09481', '09482', '09483', '09484', '09485', '09486',
        '09487', '09489', '0949', '0950', '0951', '0952', '0953', '0954', '0955', '0956', '0957',
        '0958', '0959', '096', '0970', '0971', '0979'
    }

    SNOMEDCT = {
        '10345003', '1107004', '11338007', '12232008', '13095005', '13310005', '13731006',
        '16070004', '186833000', '186842007', '186846005', '186847001', '186850003', '186854007',
        '186861006', '186863009', '186867005', '186868000', '186875004', '186877007', '186878002',
        '186899004', '186903006', '192008', '19206003', '192647003', '19290004', '193786000',
        '194907008', '194947001', '197305002', '197347003', '197348008', '197757004', '197966009',
        '198175009', '199154009', '199156006', '199157002', '199158007', '199159004', '202933002',
        '20735004', '21523006', '22386003', '230152000', '230182006', '230563005', '230735006',
        '232313005', '232367004', '233849007', '234017002', '235032001', '235062007', '235064008',
        '235065009', '23550005', '237446005', '237447001', '240552005', '240553000', '240554006',
        '240555007', '240556008', '240557004', '240558009', '240560006', '240562003', '240563008',
        '240564002', '240565001', '240566000', '240567009', '240568004', '240569007', '26039008',
        '26135000', '266125005', '266126006', '266127002', '266128007', '266130009', '266133006',
        '266136003', '27460003', '275376007', '27648007', '276700005', '278480000', '278481001',
        '28198007', '30080002', '302813001', '31015008', '31137003', '312934004', '312955002',
        '314840009', '315826004', '316841006', '32735002', '34242002', '35742006', '3589003',
        '36276008', '37028008', '371237000', '37430004', '37754005', '38523005', '39085002',
        '402940004', '402941000', '402942007', '402943002', '402944008', '402945009', '402946005',
        '402947001', '402949003', '402950003', '402951004', '405635002', '4082005', '410470003',
        '410478005', '42770003', '4359001', '444150000', '44568006', '4483005', '45058001',
        '46235002', '49923008', '50528008', '51928006', '51960003', '52414005', '54069001',
        '54274001', '55768006', '56118002', '58056005', '58227000', '58392004', '59233003',
        '59307008', '59530001', '59721007', '59934002', '60528006', '61612001', '62207008',
        '6267005', '62861003', '63751007', '64102008', '66281009', '66887000', '67125004',
        '67391006', '68764005', '69595007', '713251003', '72083004', '75299005', '76272004',
        '77028001', '77939001', '80770009', '81339006', '82323002', '82355002', '827006',
        '82959004', '83883001', '8555001', '85857008', '86028001', '86443005', '87318008',
        '88943008', '91554004', '9941009'
    }


class Chlamydia(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1003'
    VALUE_SET_NAME = 'Chlamydia'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'A5600', 'A5601', 'A5609'}

    ICD9CM = {'07888', '07988', '07998'}

    SNOMEDCT = {
        '105629000', '179101003', '186729003', '186731007', '188463006', '189312004', '197172005',
        '198176005', '236683007', '237039009', '237043008', '237084006', '237097008', '237106009',
        '240589008', '312099009', '367504009', '420910002', '426165006', '426247003', '428015005',
        '446642005', '446752000', '447353001', '447372001', '447386002', '447402003'
    }


class InflammatoryDiseasesOfFemaleReproductiveOrgans(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.112.12.1004'
    VALUE_SET_NAME = 'Inflammatory Diseases of Female Reproductive Organs'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'A55', 'A5602', 'A5611', 'A5619', 'A562', 'A563', 'A564', 'A568', 'A5900', 'A5901',
        'A5902', 'A5903', 'A5909', 'A598', 'A599', 'N7001', 'N7002', 'N7003', 'N7011', 'N7012',
        'N7013', 'N7091', 'N7092', 'N7093', 'N710', 'N711', 'N719', 'N72', 'N730', 'N731', 'N732',
        'N733', 'N734', 'N735', 'N736', 'N738', 'N739', 'N74', 'N750', 'N751', 'N758', 'N759',
        'N760', 'N761', 'N762', 'N763', 'N764', 'N765', 'N766', 'N7681', 'N7689', 'N770', 'N771'
    }

    ICD9CM = {
        '13100', '13101', '13102', '13103', '13109', '1318', '1319', '6140', '6141', '6142',
        '6143', '6144', '6145', '6146', '6147', '6148', '6149', '6150', '6151', '6159', '6160',
        '61610', '61611', '6162', '6163', '6164', '61650', '61651', '61681', '61689', '6169'
    }

    SNOMEDCT = {
        '109867008', '111418006', '12062007', '123613000', '129670002', '13125003', '14053009',
        '14248008', '14488001', '15363000', '16486000', '172001', '17716001', '186242002',
        '188463006', '19272000', '19372002', '197850006', '198130006', '198133008', '198135001',
        '198136000', '198137009', '198138004', '198141008', '198142001', '198143006', '198156004',
        '198159006', '198160001', '198161002', '198175009', '198176005', '198179003', '198180000',
        '198182008', '198183003', '198184009', '198185005', '198186006', '198188007', '198189004',
        '198199009', '198203009', '198206001', '198212006', '198216009', '198217000', '198218005',
        '198219002', '198220008', '198227006', '198230004', '198231000', '198235009', '198236005',
        '198241002', '198242009', '198824009', '200181000', '200182007', '200185009', '200187001',
        '20932005', '20943002', '21711003', '21955004', '22399000', '22775002', '237037006',
        '237044002', '237045001', '237051006', '237085007', '237091009', '237093007', '237094001',
        '237097008', '237103001', '237104007', '237124006', '238921004', '24520005', '26535009',
        '266581008', '27420004', '27438001', '276877003', '278068003', '279499002', '280483007',
        '280486004', '286985001', '28783002', '289510007', '30406004', '30800001', '30806007',
        '30833006', '31354001', '314630009', '31474007', '31999004', '32582007', '32701000',
        '32923006', '33028007', '34543006', '35585004', '36742000', '371318006', '37610005',
        '37649008', '37830006', '38099005', '387681000', '387682007', '388602007', '388604008',
        '390897008', '39120007', '397810006', '398319002', '40113007', '4022007', '402314003',
        '402375009', '402437008', '402715000', '402828000', '402890001', '402896007', '402935007',
        '403475002', '403477005', '403478000', '403479008', '403480006', '403482003', '403565003',
        '408386002', '419468003', '419760006', '4232007', '427307004', '427537009', '427786008',
        '427788009', '428193004', '428230005', '428252001', '4316006', '442506007', '443769009',
        '45022008', '46536000', '47132003', '48153009', '49249007', '49258000', '49558004',
        '51707007', '52441000', '53098006', '53200002', '53277000', '53529004', '54275000',
        '54672007', '55551005', '56321006', '56728002', '57468008', '58949002', '59211000',
        '60967006', '62394006', '62819009', '63144007', '63922003', '64150007', '65984002',
        '67624004', '67667007', '6815003', '68389001', '68640004', '6887003', '69430001',
        '70120007', '70718000', '713454009', '72605008', '72934000', '73806001', '7415003',
        '74181004', '74945001', '75530006', '75548002', '75585005', '75947000', '75993002',
        '76047005', '76151005', '77106003', '78623009', '7910003', '81521003', '81598001',
        '8258000', '83774001', '84194006', '85051008', '86070006', '8628002', '86709000',
        '87728001', '88027004', '88157006', '88981003', '8912009', '90206003', '91155009',
        '9516007', '95220008'
    }


class UncomplicatedLowBackPain(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1001'
    VALUE_SET_NAME = 'Uncomplicated Low Back Pain'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'M4726', 'M4727', 'M4728', 'M47816', 'M47817', 'M47818', 'M47896', 'M47897', 'M47898',
        'M4806', 'M4807', 'M4808', 'M5116', 'M5117', 'M5126', 'M5127', 'M5136', 'M5137', 'M5186',
        'M5187', 'M532X6', 'M532X7', 'M532X8', 'M533', 'M5386', 'M5387', 'M5388', 'M5416', 'M5417',
        'M5418', 'M5430', 'M5431', 'M5432', 'M5440', 'M5441', 'M5442', 'M545', 'M5489', 'M549',
        'M9903', 'M9904', 'M9923', 'M9933', 'M9943', 'M9953', 'M9963', 'M9973', 'M9983', 'M9984',
        'S33100A', 'S33100D', 'S33100S', 'S33110A', 'S33110D', 'S33110S', 'S33120A', 'S33120D',
        'S33120S', 'S33130A', 'S33130D', 'S33130S', 'S33140A', 'S33140D', 'S33140S', 'S335XXA',
        'S336XXA', 'S338XXA', 'S339XXA', 'S39002A', 'S39002D', 'S39002S', 'S39012A', 'S39012D',
        'S39012S', 'S39092A', 'S39092D', 'S39092S', 'S3982XA', 'S3982XD', 'S3982XS', 'S3992XA',
        'S3992XD', 'S3992XS'
    }

    SNOMEDCT = {
        '161894002', '202794004', '247368002', '267067009', '267982002', '275316003', '278860009',
        '278862001', '279039007', '279040009', '279041008', '279042001', '279063004', '298674008',
        '300957005', '301408007'
    }


class XRayOfLowerSpine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1033'
    VALUE_SET_NAME = 'X-Ray of Lower Spine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '24665-2', '24929-2', '24930-0', '24969-8', '24970-6', '24971-4', '24972-2', '24975-5',
        '24984-7', '30713-2', '30714-0', '30715-7', '30716-5', '30717-3', '30773-6', '30774-4',
        '30775-1', '30776-9', '30777-7', '30778-5', '30797-5', '30883-3', '30884-1', '36332-5',
        '36647-6', '36670-8', '36674-0', '36681-5', '36688-0', '36735-9', '36946-2', '36949-6',
        '36990-0', '36992-6', '37003-1', '37009-8', '37011-4', '37073-4', '37078-3', '37101-3',
        '37105-4', '37132-8', '37172-4', '37208-6', '37256-5', '37257-3', '37259-9', '37260-7',
        '37261-5', '37300-1', '37340-7', '37341-5', '37342-3', '37351-4', '37353-0', '37355-5',
        '37356-3', '37357-1', '37515-4', '37516-2', '37651-7', '37652-5', '37658-2', '37659-0',
        '37660-8', '37974-3', '37975-0', '38008-9', '38121-0', '38123-6', '38124-4', '39049-2',
        '39061-7', '39063-3', '39067-4', '39333-0', '39340-5', '39367-8', '42163-6', '42378-0',
        '42379-8', '42401-0', '42403-6', '42406-9', '42407-7', '42408-5', '42410-1', '42411-9',
        '42413-5', '42424-2', '42425-9', '42426-7', '42427-5', '42428-3', '42429-1', '42472-1',
        '42690-8', '42692-4', '43569-3', '43784-8', '43791-3', '44178-2', '44179-0', '44194-9',
        '44196-4', '44203-8', '44206-1', '46340-6', '47382-7', '47984-0', '48469-1', '48473-3',
        '69264-0', '69273-1'
    }


class MriOfLowerSpine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1034'
    VALUE_SET_NAME = 'MRI of Lower Spine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '24967-2', '24968-0', '24977-1', '30678-7', '30679-5', '30854-4', '30855-1', '36059-4',
        '36060-2', '36100-6', '36111-3', '36246-7', '36247-5', '36391-1', '36392-9', '36521-3',
        '36522-1', '38061-8', '42698-1', '48436-0', '48452-7'
    }


class CtScanOfLowerSpine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1035'
    VALUE_SET_NAME = 'CT Scan of Lower Spine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '24963-1', '24964-9', '24965-6', '30620-9', '36058-6', '36069-3', '36110-5', '36245-9',
        '36390-3', '36402-6', '36520-5', '37232-6', '37288-8', '37509-7', '37653-3', '44114-7',
        '69116-2'
    }


class Trauma(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1036'
    VALUE_SET_NAME = 'Trauma'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'S020XXA', 'S020XXB', 'S020XXD', 'S020XXG', 'S020XXK', 'S020XXS', 'S0210XA', 'S0210XB',
        'S0210XD', 'S0210XG', 'S0210XK', 'S0210XS', 'S02110A', 'S02110B', 'S02110D', 'S02110G',
        'S02110K', 'S02110S', 'S02111A', 'S02111B', 'S02111D', 'S02111G', 'S02111K', 'S02111S',
        'S02112A', 'S02112B', 'S02112D', 'S02112G', 'S02112K', 'S02112S', 'S02113A', 'S02113B',
        'S02113D', 'S02113G', 'S02113K', 'S02113S', 'S02118A', 'S02118B', 'S02118D', 'S02118G',
        'S02118K', 'S02118S', 'S02119A', 'S02119B', 'S02119D', 'S02119G', 'S02119K', 'S02119S',
        'S0219XA', 'S0219XB', 'S0219XD', 'S0219XG', 'S0219XK', 'S0219XS', 'S022XXA', 'S022XXB',
        'S022XXD', 'S022XXG', 'S022XXK', 'S023XXA', 'S023XXB', 'S023XXD', 'S023XXG', 'S023XXK',
        'S023XXS', 'S02400A', 'S02400B', 'S02400D', 'S02400G', 'S02400K', 'S02400S', 'S02401A',
        'S02401B', 'S02401D', 'S02401G', 'S02401K', 'S02401S', 'S02402A', 'S02402B', 'S02402D',
        'S02402G', 'S02402K', 'S02402S', 'S02411A', 'S02411B', 'S02411D', 'S02411G', 'S02411K',
        'S02411S', 'S02412A', 'S02412B', 'S02412D', 'S02412G', 'S02412K', 'S02412S', 'S02413A',
        'S02413B', 'S02413D', 'S02413G', 'S02413K', 'S02413S', 'S0242XA', 'S0242XB', 'S0242XD',
        'S0242XG', 'S0242XK', 'S0242XS', 'S02600A', 'S02600B', 'S02600D', 'S02600G', 'S02600K',
        'S02600S', 'S02609A', 'S02609B', 'S02609D', 'S02609G', 'S02609K', 'S02609S', 'S0261XA',
        'S0261XB', 'S0261XD', 'S0261XG', 'S0261XK', 'S0261XS', 'S0262XA', 'S0262XB', 'S0262XD',
        'S0262XG', 'S0262XK', 'S0262XS', 'S0263XA', 'S0263XB', 'S0263XD', 'S0263XG', 'S0263XK',
        'S0263XS', 'S0264XA', 'S0264XB', 'S0264XD', 'S0264XG', 'S0264XK', 'S0264XS', 'S0265XA',
        'S0265XB', 'S0265XD', 'S0265XG', 'S0265XK', 'S0265XS', 'S0266XA', 'S0266XB', 'S0266XD',
        'S0266XG', 'S0266XK', 'S0266XS', 'S0267XA', 'S0267XB', 'S0267XD', 'S0267XG', 'S0267XK',
        'S0267XS', 'S0269XA', 'S0269XB', 'S0269XD', 'S0269XG', 'S0269XK', 'S0269XS', 'S028XXA',
        'S028XXB', 'S028XXD', 'S028XXG', 'S028XXK', 'S028XXS', 'S0291XA', 'S0291XB', 'S0291XD',
        'S0291XG', 'S0291XK', 'S0291XS', 'S0292XA', 'S0292XB', 'S0292XD', 'S0292XG', 'S0292XK',
        'S0292XS', 'S030XXA', 'S030XXD', 'S030XXS', 'S031XXA', 'S031XXD', 'S031XXS', 'S060X0A',
        'S060X0D', 'S060X0S', 'S060X1A', 'S060X1D', 'S060X1S', 'S060X2A', 'S060X2D', 'S060X2S',
        'S060X3A', 'S060X3D', 'S060X3S', 'S060X4A', 'S060X4D', 'S060X4S', 'S060X5A', 'S060X5D',
        'S060X5S', 'S060X6A', 'S060X6D', 'S060X6S', 'S060X7A', 'S060X7D', 'S060X7S', 'S060X8A',
        'S060X8D', 'S060X8S', 'S060X9A', 'S060X9D', 'S060X9S', 'S061X0A', 'S061X0D', 'S061X0S',
        'S061X1A', 'S061X1D', 'S061X1S', 'S061X2A', 'S061X2D', 'S061X2S', 'S061X3A', 'S061X3D',
        'S061X3S', 'S061X4A', 'S061X4D', 'S061X4S', 'S061X5A', 'S061X5D', 'S061X5S', 'S061X6A',
        'S061X6D', 'S061X6S', 'S061X7A', 'S061X7D', 'S061X7S', 'S061X8A', 'S061X8D', 'S061X8S',
        'S061X9A', 'S061X9D', 'S061X9S', 'S062X0A', 'S062X0D', 'S062X0S', 'S062X1A', 'S062X1D',
        'S062X1S', 'S062X2A', 'S062X2D', 'S062X2S', 'S062X3A', 'S062X3D', 'S062X3S', 'S062X4A',
        'S062X4D', 'S062X4S', 'S062X5A', 'S062X5D', 'S062X5S', 'S062X6A', 'S062X6D', 'S062X6S',
        'S062X7A', 'S062X7D', 'S062X7S', 'S062X8A', 'S062X8D', 'S062X8S', 'S062X9A', 'S062X9D',
        'S062X9S', 'S06300A', 'S06300D', 'S06300S', 'S06301A', 'S06301D', 'S06301S', 'S06302A',
        'S06302D', 'S06302S', 'S06303A', 'S06303D', 'S06303S', 'S06304A', 'S06304D', 'S06304S',
        'S06305A', 'S06305D', 'S06305S', 'S06306A', 'S06306D', 'S06306S', 'S06307A', 'S06307D',
        'S06307S', 'S06308A', 'S06308D', 'S06308S', 'S06309A', 'S06309D', 'S06309S', 'S06310A',
        'S06310D', 'S06310S', 'S06311A', 'S06311D', 'S06311S', 'S06312A', 'S06312D', 'S06312S',
        'S06313A', 'S06313D', 'S06313S', 'S06314A', 'S06314D', 'S06314S', 'S06315A', 'S06315D',
        'S06315S', 'S06316A', 'S06316D', 'S06316S', 'S06317A', 'S06317D', 'S06317S', 'S06318A',
        'S06318D', 'S06318S', 'S06319A', 'S06319D', 'S06319S', 'S06320A', 'S06320D', 'S06320S',
        'S06321A', 'S06321D', 'S06321S', 'S06322A', 'S06322D', 'S06322S', 'S06323A', 'S06323D',
        'S06323S', 'S06324A', 'S06324D', 'S06324S', 'S06325A', 'S06325D', 'S06325S', 'S06326A',
        'S06326D', 'S06326S', 'S06327A', 'S06327D', 'S06327S', 'S06328A', 'S06328D', 'S06328S',
        'S06329A', 'S06329D', 'S06329S', 'S06330A', 'S06330D', 'S06330S', 'S06331A', 'S06331D',
        'S06331S', 'S06332A', 'S06332D', 'S06332S', 'S06333A', 'S06333D', 'S06333S', 'S06334A',
        'S06334D', 'S06334S', 'S06335A', 'S06335D', 'S06335S', 'S06336A', 'S06336D', 'S06336S',
        'S06337A', 'S06337D', 'S06337S', 'S06338A', 'S06338D', 'S06338S', 'S06339A', 'S06339D',
        'S06339S', 'S06340A', 'S06340D', 'S06340S', 'S06341A', 'S06341D', 'S06341S', 'S06342A',
        'S06342D', 'S06342S', 'S06343A', 'S06343D', 'S06343S', 'S06344A', 'S06344D', 'S06344S',
        'S06345A', 'S06345D', 'S06345S', 'S06346A', 'S06346D', 'S06346S', 'S06347A', 'S06347D',
        'S06347S', 'S06348A', 'S06348D', 'S06348S', 'S06349A', 'S06349D', 'S06349S', 'S06350A',
        'S06350D', 'S06350S', 'S06351A', 'S06351D', 'S06351S', 'S06352A', 'S06352D', 'S06352S',
        'S06353A', 'S06353D', 'S06353S', 'S06354A', 'S06354D', 'S06354S', 'S06355A', 'S06355D',
        'S06355S', 'S06356A', 'S06356D', 'S06356S', 'S06357A', 'S06357D', 'S06357S', 'S06358A',
        'S06358D', 'S06358S', 'S06359A', 'S06359D', 'S06359S', 'S06360A', 'S06360D', 'S06360S',
        'S06361A', 'S06361D', 'S06361S', 'S06362A', 'S06362D', 'S06362S', 'S06363A', 'S06363D',
        'S06363S', 'S06364A', 'S06364D', 'S06364S', 'S06365A', 'S06365D', 'S06365S', 'S06366A',
        'S06366D', 'S06366S', 'S06367A', 'S06367D', 'S06367S', 'S06368A', 'S06368D', 'S06368S',
        'S06369A', 'S06369D', 'S06369S', 'S06370A', 'S06370D', 'S06370S', 'S06371A', 'S06371D',
        'S06371S', 'S06372A', 'S06372D', 'S06372S', 'S06373A', 'S06373D', 'S06373S', 'S06374A',
        'S06374D', 'S06374S', 'S06375A', 'S06375D', 'S06375S', 'S06376A', 'S06376D', 'S06376S',
        'S06377A', 'S06377D', 'S06377S', 'S06378A', 'S06378D', 'S06378S', 'S06379A', 'S06379D',
        'S06379S', 'S06380A', 'S06380D', 'S06380S', 'S06381A', 'S06381D', 'S06381S', 'S06382A',
        'S06382D', 'S06382S', 'S06383A', 'S06383D', 'S06383S', 'S06384A', 'S06384D', 'S06384S',
        'S06385A', 'S06385D', 'S06385S', 'S06386A', 'S06386D', 'S06386S', 'S06387A', 'S06387D',
        'S06387S', 'S06388A', 'S06388D', 'S06388S', 'S06389A', 'S06389D', 'S06389S', 'S064X0A',
        'S064X0D', 'S064X0S', 'S064X1A', 'S064X1D', 'S064X1S', 'S064X2A', 'S064X2D', 'S064X2S',
        'S064X3A', 'S064X3D', 'S064X3S', 'S064X4A', 'S064X4D', 'S064X4S', 'S064X5A', 'S064X5D',
        'S064X5S', 'S064X6A', 'S064X6D', 'S064X6S', 'S064X7A', 'S064X7D', 'S064X7S', 'S064X8A',
        'S064X8D', 'S064X8S', 'S064X9A', 'S064X9D', 'S064X9S', 'S065X0A', 'S065X0D', 'S065X0S',
        'S065X1A', 'S065X1D', 'S065X1S', 'S065X2A', 'S065X2D', 'S065X2S', 'S065X3A', 'S065X3D',
        'S065X3S', 'S065X4A', 'S065X4D', 'S065X4S', 'S065X5A', 'S065X5D', 'S065X5S', 'S065X6A',
        'S065X6D', 'S065X6S', 'S065X7A', 'S065X7D', 'S065X7S', 'S065X8A', 'S065X8D', 'S065X8S',
        'S065X9A', 'S065X9D', 'S065X9S', 'S066X0A', 'S066X0D', 'S066X0S', 'S066X1A', 'S066X1D',
        'S066X1S', 'S066X2A', 'S066X2D', 'S066X2S', 'S066X3A', 'S066X3D', 'S066X3S', 'S066X4A',
        'S066X4D', 'S066X4S', 'S066X5A', 'S066X5D', 'S066X5S', 'S066X6A', 'S066X6D', 'S066X6S',
        'S066X7A', 'S066X7D', 'S066X7S', 'S066X8A', 'S066X8D', 'S066X8S', 'S066X9A', 'S066X9D',
        'S066X9S', 'S06810A', 'S06810D', 'S06810S', 'S06811A', 'S06811D', 'S06811S', 'S06812A',
        'S06812D', 'S06812S', 'S06813A', 'S06813D', 'S06813S', 'S06814A', 'S06814D', 'S06814S',
        'S06815A', 'S06815D', 'S06815S', 'S06816A', 'S06816D', 'S06816S', 'S06817A', 'S06817D',
        'S06817S', 'S06818A', 'S06818D', 'S06818S', 'S06819A', 'S06819D', 'S06819S', 'S06820A',
        'S06820D', 'S06820S', 'S06821A', 'S06821D', 'S06821S', 'S06822A', 'S06822D', 'S06822S',
        'S06823A', 'S06823D', 'S06823S', 'S06824A', 'S06824D', 'S06824S', 'S06825A', 'S06825D',
        'S06825S', 'S06826A', 'S06826D', 'S06826S', 'S06827A', 'S06827D', 'S06827S', 'S06828A',
        'S06828D', 'S06828S', 'S06829A', 'S06829D', 'S06829S', 'S06890A', 'S06890D', 'S06890S',
        'S06891A', 'S06891D', 'S06891S', 'S06892A', 'S06892D', 'S06892S', 'S06893A', 'S06893D',
        'S06893S', 'S06894A', 'S06894D', 'S06894S', 'S06895A', 'S06895D', 'S06895S', 'S06896A',
        'S06896D', 'S06896S', 'S06897A', 'S06897D', 'S06897S', 'S06898A', 'S06898D', 'S06898S',
        'S06899A', 'S06899D', 'S06899S', 'S069X0A', 'S069X0D', 'S069X0S', 'S069X1A', 'S069X1D',
        'S069X1S', 'S069X2A', 'S069X2D', 'S069X2S', 'S069X3A', 'S069X3D', 'S069X3S', 'S069X4A',
        'S069X4D', 'S069X4S', 'S069X5A', 'S069X5D', 'S069X5S', 'S069X6A', 'S069X6D', 'S069X6S',
        'S069X7A', 'S069X7D', 'S069X7S', 'S069X8A', 'S069X8D', 'S069X8S', 'S069X9A', 'S069X9D',
        'S069X9S', 'S12000A', 'S12000B', 'S12000D', 'S12000G', 'S12000K', 'S12000S', 'S12001A',
        'S12001B', 'S12001D', 'S12001G', 'S12001K', 'S12001S', 'S1201XA', 'S1201XB', 'S1201XD',
        'S1201XG', 'S1201XK', 'S1201XS', 'S1202XA', 'S1202XB', 'S1202XD', 'S1202XG', 'S1202XK',
        'S1202XS', 'S12030A', 'S12030B', 'S12030D', 'S12030G', 'S12030K', 'S12030S', 'S12031A',
        'S12031B', 'S12031D', 'S12031G', 'S12031K', 'S12031S', 'S12040A', 'S12040B', 'S12040D',
        'S12040G', 'S12040K', 'S12040S', 'S12041A', 'S12041B', 'S12041D', 'S12041G', 'S12041K',
        'S12041S', 'S12090A', 'S12090B', 'S12090D', 'S12090G', 'S12090K', 'S12090S', 'S12091A',
        'S12091B', 'S12091D', 'S12091G', 'S12091K', 'S12091S', 'S12100A', 'S12100B', 'S12100D',
        'S12100G', 'S12100K', 'S12100S', 'S12101A', 'S12101B', 'S12101D', 'S12101G', 'S12101K',
        'S12101S', 'S12110A', 'S12110B', 'S12110D', 'S12110G', 'S12110K', 'S12110S', 'S12111A',
        'S12111B', 'S12111D', 'S12111G', 'S12111K', 'S12111S', 'S12112A', 'S12112B', 'S12112D',
        'S12112G', 'S12112K', 'S12112S', 'S12120A', 'S12120B', 'S12120D', 'S12120G', 'S12120K',
        'S12120S', 'S12121A', 'S12121B', 'S12121D', 'S12121G', 'S12121K', 'S12121S', 'S12130A',
        'S12130B', 'S12130D', 'S12130G', 'S12130K', 'S12130S', 'S12131A', 'S12131B', 'S12131D',
        'S12131G', 'S12131K', 'S12131S', 'S1214XA', 'S1214XB', 'S1214XD', 'S1214XG', 'S1214XK',
        'S1214XS', 'S12150A', 'S12150B', 'S12150D', 'S12150G', 'S12150K', 'S12150S', 'S12151A',
        'S12151B', 'S12151D', 'S12151G', 'S12151K', 'S12151S', 'S12190A', 'S12190B', 'S12190D',
        'S12190G', 'S12190K', 'S12190S', 'S12191A', 'S12191B', 'S12191D', 'S12191G', 'S12191K',
        'S12191S', 'S12200A', 'S12200B', 'S12200D', 'S12200G', 'S12200K', 'S12200S', 'S12201A',
        'S12201B', 'S12201D', 'S12201G', 'S12201K', 'S12201S', 'S12230A', 'S12230B', 'S12230D',
        'S12230G', 'S12230K', 'S12230S', 'S12231A', 'S12231B', 'S12231D', 'S12231G', 'S12231K',
        'S12231S', 'S1224XA', 'S1224XB', 'S1224XD', 'S1224XG', 'S1224XK', 'S1224XS', 'S12250A',
        'S12250B', 'S12250D', 'S12250G', 'S12250K', 'S12250S', 'S12251A', 'S12251B', 'S12251D',
        'S12251G', 'S12251K', 'S12251S', 'S12290A', 'S12290B', 'S12290D', 'S12290G', 'S12290K',
        'S12290S', 'S12291A', 'S12291B', 'S12291D', 'S12291G', 'S12291K', 'S12291S', 'S12300A',
        'S12300B', 'S12300D', 'S12300G', 'S12300K', 'S12300S', 'S12301A', 'S12301B', 'S12301D',
        'S12301G', 'S12301K', 'S12301S', 'S12330A', 'S12330B', 'S12330D', 'S12330G', 'S12330K',
        'S12330S', 'S12331A', 'S12331B', 'S12331D', 'S12331G', 'S12331K', 'S12331S', 'S1234XA',
        'S1234XB', 'S1234XD', 'S1234XG', 'S1234XK', 'S1234XS', 'S12350A', 'S12350B', 'S12350D',
        'S12350G', 'S12350K', 'S12350S', 'S12351A', 'S12351B', 'S12351D', 'S12351G', 'S12351K',
        'S12351S', 'S12390A', 'S12390B', 'S12390D', 'S12390G', 'S12390K', 'S12390S', 'S12391A',
        'S12391B', 'S12391D', 'S12391G', 'S12391K', 'S12391S', 'S12400A', 'S12400B', 'S12400D',
        'S12400G', 'S12400K', 'S12400S', 'S12401A', 'S12401B', 'S12401D', 'S12401G', 'S12401K',
        'S12401S', 'S12430A', 'S12430B', 'S12430D', 'S12430G', 'S12430K', 'S12430S', 'S12431A',
        'S12431B', 'S12431D', 'S12431G', 'S12431K', 'S12431S', 'S1244XA', 'S1244XB', 'S1244XD',
        'S1244XG', 'S1244XK', 'S1244XS', 'S12450A', 'S12450B', 'S12450D', 'S12450G', 'S12450K',
        'S12450S', 'S12451A', 'S12451B', 'S12451D', 'S12451G', 'S12451K', 'S12451S', 'S12490A',
        'S12490B', 'S12490D', 'S12490G', 'S12490K', 'S12490S', 'S12491A', 'S12491B', 'S12491D',
        'S12491G', 'S12491K', 'S12491S', 'S12500A', 'S12500B', 'S12500D', 'S12500G', 'S12500K',
        'S12500S', 'S12501A', 'S12501B', 'S12501D', 'S12501G', 'S12501K', 'S12501S', 'S12530A',
        'S12530B', 'S12530D', 'S12530G', 'S12530K', 'S12530S', 'S12531A', 'S12531B', 'S12531D',
        'S12531G', 'S12531K', 'S12531S', 'S1254XA', 'S1254XB', 'S1254XD', 'S1254XG', 'S1254XK',
        'S1254XS', 'S12550A', 'S12550B', 'S12550D', 'S12550G', 'S12550K', 'S12550S', 'S12551A',
        'S12551B', 'S12551D', 'S12551G', 'S12551K', 'S12551S', 'S12590A', 'S12590B', 'S12590D',
        'S12590G', 'S12590K', 'S12590S', 'S12591A', 'S12591B', 'S12591D', 'S12591G', 'S12591K',
        'S12591S', 'S12600A', 'S12600B', 'S12600D', 'S12600G', 'S12600K', 'S12600S', 'S12601A',
        'S12601B', 'S12601D', 'S12601G', 'S12601K', 'S12601S', 'S12630A', 'S12630B', 'S12630D',
        'S12630G', 'S12630K', 'S12630S', 'S12631A', 'S12631B', 'S12631D', 'S12631G', 'S12631K',
        'S12631S', 'S1264XA', 'S1264XB', 'S1264XD', 'S1264XG', 'S1264XK', 'S1264XS', 'S12650A',
        'S12650B', 'S12650D', 'S12650G', 'S12650K', 'S12650S', 'S12651A', 'S12651B', 'S12651D',
        'S12651G', 'S12651K', 'S12651S', 'S12690A', 'S12690B', 'S12690D', 'S12690G', 'S12690K',
        'S12690S', 'S12691A', 'S12691B', 'S12691D', 'S12691G', 'S12691K', 'S12691S', 'S128XXA',
        'S128XXD', 'S128XXS', 'S129XXA', 'S129XXD', 'S129XXS', 'S130XXA', 'S130XXD', 'S130XXS',
        'S13101A', 'S13101D', 'S13101S', 'S13111A', 'S13111D', 'S13111S', 'S13121A', 'S13121D',
        'S13121S', 'S13131A', 'S13131D', 'S13131S', 'S13141A', 'S13141D', 'S13141S', 'S13151A',
        'S13151D', 'S13151S', 'S13161A', 'S13161D', 'S13161S', 'S13171A', 'S13171D', 'S13171S',
        'S13181A', 'S13181D', 'S13181S', 'S1320XA', 'S1320XD', 'S1320XS', 'S1329XA', 'S1329XD',
        'S1329XS', 'S14111A', 'S14111D', 'S14111S', 'S14112A', 'S14112D', 'S14112S', 'S14113A',
        'S14113D', 'S14113S', 'S14114A', 'S14114D', 'S14114S', 'S14115A', 'S14115D', 'S14115S',
        'S14116A', 'S14116D', 'S14116S', 'S14117A', 'S14117D', 'S14117S', 'S14118A', 'S14118D',
        'S14118S', 'S14119A', 'S14119D', 'S14119S', 'S14121A', 'S14121D', 'S14121S', 'S14122A',
        'S14122D', 'S14122S', 'S14123A', 'S14123D', 'S14123S', 'S14124A', 'S14124D', 'S14124S',
        'S14125A', 'S14125D', 'S14125S', 'S14126A', 'S14126D', 'S14126S', 'S14127A', 'S14127D',
        'S14127S', 'S14128A', 'S14128D', 'S14128S', 'S14129A', 'S14129D', 'S14129S', 'S14131A',
        'S14131D', 'S14131S', 'S14132A', 'S14132D', 'S14132S', 'S14133A', 'S14133D', 'S14133S',
        'S14134A', 'S14134D', 'S14134S', 'S14135A', 'S14135D', 'S14135S', 'S14136A', 'S14136D',
        'S14136S', 'S14137A', 'S14137D', 'S14137S', 'S14138A', 'S14138D', 'S14138S', 'S14139A',
        'S14139D', 'S14139S', 'S14141A', 'S14141D', 'S14141S', 'S14142A', 'S14142D', 'S14142S',
        'S14143A', 'S14143D', 'S14143S', 'S14144A', 'S14144D', 'S14144S', 'S14145A', 'S14145D',
        'S14145S', 'S14146A', 'S14146D', 'S14146S', 'S14147A', 'S14147D', 'S14147S', 'S14148A',
        'S14148D', 'S14148S', 'S14149A', 'S14149D', 'S14149S', 'S14151A', 'S14151D', 'S14151S',
        'S14152A', 'S14152D', 'S14152S', 'S14153A', 'S14153D', 'S14153S', 'S14154A', 'S14154D',
        'S14154S', 'S14155A', 'S14155D', 'S14155S', 'S14156A', 'S14156D', 'S14156S', 'S14157A',
        'S14157D', 'S14157S', 'S14158A', 'S14158D', 'S14158S', 'S14159A', 'S14159D', 'S14159S',
        'S21301A', 'S21301D', 'S21301S', 'S21302A', 'S21302D', 'S21302S', 'S21309A', 'S21309D',
        'S21309S', 'S21311A', 'S21311D', 'S21311S', 'S21312A', 'S21312D', 'S21312S', 'S21319A',
        'S21319D', 'S21319S', 'S21321A', 'S21321D', 'S21321S', 'S21322A', 'S21322D', 'S21322S',
        'S21329A', 'S21329D', 'S21329S', 'S21331A', 'S21331D', 'S21331S', 'S21332A', 'S21332D',
        'S21332S', 'S21339A', 'S21339D', 'S21339S', 'S21341A', 'S21341D', 'S21341S', 'S21342A',
        'S21342D', 'S21342S', 'S21349A', 'S21349D', 'S21349S', 'S21351A', 'S21351D', 'S21351S',
        'S21352A', 'S21352D', 'S21352S', 'S21359A', 'S21359D', 'S21359S', 'S21401A', 'S21401D',
        'S21401S', 'S21402A', 'S21402D', 'S21402S', 'S21409A', 'S21409D', 'S21409S', 'S21411A',
        'S21411D', 'S21411S', 'S21412A', 'S21412D', 'S21412S', 'S21419A', 'S21419D', 'S21419S',
        'S21421A', 'S21421D', 'S21421S', 'S21422A', 'S21422D', 'S21422S', 'S21429A', 'S21429D',
        'S21429S', 'S21431A', 'S21431D', 'S21431S', 'S21432A', 'S21432D', 'S21432S', 'S21439A',
        'S21439D', 'S21439S', 'S21441A', 'S21441D', 'S21441S', 'S21442A', 'S21442D', 'S21442S',
        'S21449A', 'S21449D', 'S21449S', 'S21451A', 'S21451D', 'S21451S', 'S21452A', 'S21452D',
        'S21452S', 'S21459A', 'S21459D', 'S21459S', 'S22000A', 'S22000B', 'S22000D', 'S22000G',
        'S22000K', 'S22000S', 'S22001A', 'S22001B', 'S22001D', 'S22001G', 'S22001K', 'S22001S',
        'S22002A', 'S22002B', 'S22002D', 'S22002G', 'S22002K', 'S22002S', 'S22008A', 'S22008B',
        'S22008D', 'S22008G', 'S22008K', 'S22008S', 'S22009A', 'S22009B', 'S22009D', 'S22009G',
        'S22009K', 'S22009S', 'S22010A', 'S22010B', 'S22010D', 'S22010G', 'S22010K', 'S22010S',
        'S22011A', 'S22011B', 'S22011D', 'S22011G', 'S22011K', 'S22011S', 'S22012A', 'S22012B',
        'S22012D', 'S22012G', 'S22012K', 'S22012S', 'S22018A', 'S22018B', 'S22018D', 'S22018G',
        'S22018K', 'S22018S', 'S22019A', 'S22019B', 'S22019D', 'S22019G', 'S22019K', 'S22019S',
        'S22020A', 'S22020B', 'S22020D', 'S22020G', 'S22020K', 'S22020S', 'S22021A', 'S22021B',
        'S22021D', 'S22021G', 'S22021K', 'S22021S', 'S22022A', 'S22022B', 'S22022D', 'S22022G',
        'S22022K', 'S22022S', 'S22028A', 'S22028B', 'S22028D', 'S22028G', 'S22028K', 'S22028S',
        'S22029A', 'S22029B', 'S22029D', 'S22029G', 'S22029K', 'S22029S', 'S22030A', 'S22030B',
        'S22030D', 'S22030G', 'S22030K', 'S22030S', 'S22031A', 'S22031B', 'S22031D', 'S22031G',
        'S22031K', 'S22031S', 'S22032A', 'S22032B', 'S22032D', 'S22032G', 'S22032K', 'S22032S',
        'S22038A', 'S22038B', 'S22038D', 'S22038G', 'S22038K', 'S22038S', 'S22039A', 'S22039B',
        'S22039D', 'S22039G', 'S22039K', 'S22039S', 'S22040A', 'S22040B', 'S22040D', 'S22040G',
        'S22040K', 'S22040S', 'S22041A', 'S22041B', 'S22041D', 'S22041G', 'S22041K', 'S22041S',
        'S22042A', 'S22042B', 'S22042D', 'S22042G', 'S22042K', 'S22042S', 'S22048A', 'S22048B',
        'S22048D', 'S22048G', 'S22048K', 'S22048S', 'S22049A', 'S22049B', 'S22049D', 'S22049G',
        'S22049K', 'S22049S', 'S22050A', 'S22050B', 'S22050D', 'S22050G', 'S22050K', 'S22050S',
        'S22051A', 'S22051B', 'S22051D', 'S22051G', 'S22051K', 'S22051S', 'S22052A', 'S22052B',
        'S22052D', 'S22052G', 'S22052K', 'S22052S', 'S22058A', 'S22058B', 'S22058D', 'S22058G',
        'S22058K', 'S22058S', 'S22059A', 'S22059B', 'S22059D', 'S22059G', 'S22059K', 'S22059S',
        'S22060A', 'S22060B', 'S22060D', 'S22060G', 'S22060K', 'S22060S', 'S22061A', 'S22061B',
        'S22061D', 'S22061G', 'S22061K', 'S22061S', 'S22062A', 'S22062B', 'S22062D', 'S22062G',
        'S22062K', 'S22062S', 'S22068A', 'S22068B', 'S22068D', 'S22068G', 'S22068K', 'S22068S',
        'S22069A', 'S22069B', 'S22069D', 'S22069G', 'S22069K', 'S22069S', 'S22070A', 'S22070B',
        'S22070D', 'S22070G', 'S22070K', 'S22070S', 'S22071A', 'S22071B', 'S22071D', 'S22071G',
        'S22071K', 'S22071S', 'S22072A', 'S22072B', 'S22072D', 'S22072G', 'S22072K', 'S22072S',
        'S22078A', 'S22078B', 'S22078D', 'S22078G', 'S22078K', 'S22078S', 'S22079A', 'S22079B',
        'S22079D', 'S22079G', 'S22079K', 'S22079S', 'S22080A', 'S22080B', 'S22080D', 'S22080G',
        'S22080K', 'S22080S', 'S22081A', 'S22081B', 'S22081D', 'S22081G', 'S22081K', 'S22081S',
        'S22082A', 'S22082B', 'S22082D', 'S22082G', 'S22082K', 'S22082S', 'S22088A', 'S22088B',
        'S22088D', 'S22088G', 'S22088K', 'S22088S', 'S22089A', 'S22089B', 'S22089D', 'S22089G',
        'S22089K', 'S22089S', 'S2220XA', 'S2220XB', 'S2220XD', 'S2220XG', 'S2220XK', 'S2220XS',
        'S2221XA', 'S2221XB', 'S2221XD', 'S2221XG', 'S2221XK', 'S2221XS', 'S2222XA', 'S2222XB',
        'S2222XD', 'S2222XG', 'S2222XK', 'S2222XS', 'S2223XA', 'S2223XB', 'S2223XD', 'S2223XG',
        'S2223XK', 'S2223XS', 'S2224XA', 'S2224XB', 'S2224XD', 'S2224XG', 'S2224XK', 'S2224XS',
        'S2231XA', 'S2231XB', 'S2231XD', 'S2231XG', 'S2231XK', 'S2231XS', 'S2232XA', 'S2232XB',
        'S2232XD', 'S2232XG', 'S2232XK', 'S2232XS', 'S2239XA', 'S2239XB', 'S2239XD', 'S2239XG',
        'S2239XK', 'S2239XS', 'S2241XA', 'S2241XB', 'S2241XD', 'S2241XG', 'S2241XK', 'S2241XS',
        'S2242XA', 'S2242XB', 'S2242XD', 'S2242XG', 'S2242XK', 'S2242XS', 'S2243XA', 'S2243XB',
        'S2243XD', 'S2243XG', 'S2243XK', 'S2243XS', 'S2249XA', 'S2249XB', 'S2249XD', 'S2249XG',
        'S2249XK', 'S2249XS', 'S225XXA', 'S225XXB', 'S225XXD', 'S225XXG', 'S225XXK', 'S225XXS',
        'S229XXA', 'S229XXB', 'S229XXD', 'S229XXG', 'S229XXK', 'S229XXS', 'S230XXA', 'S230XXD',
        'S230XXS', 'S23101A', 'S23101D', 'S23101S', 'S23111A', 'S23111D', 'S23111S', 'S23121A',
        'S23121D', 'S23121S', 'S23123A', 'S23123D', 'S23123S', 'S23131A', 'S23131D', 'S23131S',
        'S23133A', 'S23133D', 'S23133S', 'S23141A', 'S23141D', 'S23141S', 'S23143A', 'S23143D',
        'S23143S', 'S23151A', 'S23151D', 'S23151S', 'S23153A', 'S23153D', 'S23153S', 'S23161A',
        'S23161D', 'S23161S', 'S23163A', 'S23163D', 'S23163S', 'S23171A', 'S23171D', 'S23171S',
        'S2320XA', 'S2320XD', 'S2320XS', 'S2329XA', 'S2329XD', 'S2329XS', 'S240XXA', 'S240XXD',
        'S240XXS', 'S24111A', 'S24111D', 'S24111S', 'S24112A', 'S24112D', 'S24112S', 'S24113A',
        'S24113D', 'S24113S', 'S24114A', 'S24114D', 'S24114S', 'S24119A', 'S24119D', 'S24119S',
        'S24131A', 'S24131D', 'S24131S', 'S24132A', 'S24132D', 'S24132S', 'S24133A', 'S24133D',
        'S24133S', 'S24134A', 'S24134D', 'S24134S', 'S24139A', 'S24139D', 'S24139S', 'S24141A',
        'S24141D', 'S24141S', 'S24142A', 'S24142D', 'S24142S', 'S24143A', 'S24143D', 'S24143S',
        'S24144A', 'S24144D', 'S24144S', 'S24149A', 'S24149D', 'S24149S', 'S24151A', 'S24151D',
        'S24151S', 'S24152A', 'S24152D', 'S24152S', 'S24153A', 'S24153D', 'S24153S', 'S24154A',
        'S24154D', 'S24154S', 'S24159A', 'S24159D', 'S24159S', 'S2600XA', 'S2600XD', 'S2600XS',
        'S2601XA', 'S2601XD', 'S2601XS', 'S26020A', 'S26020D', 'S26020S', 'S26021A', 'S26021D',
        'S26021S', 'S26022A', 'S26022D', 'S26022S', 'S2609XA', 'S2609XD', 'S2609XS', 'S2610XA',
        'S2610XD', 'S2610XS', 'S2611XA', 'S2611XD', 'S2611XS', 'S2612XA', 'S2612XD', 'S2612XS',
        'S2619XA', 'S2619XD', 'S2619XS', 'S2690XA', 'S2690XD', 'S2690XS', 'S2691XA', 'S2691XD',
        'S2691XS', 'S2692XA', 'S2692XD', 'S2692XS', 'S2699XA', 'S2699XD', 'S2699XS', 'S270XXA',
        'S270XXD', 'S270XXS', 'S271XXA', 'S271XXD', 'S271XXS', 'S272XXA', 'S272XXD', 'S272XXS',
        'S27301A', 'S27301D', 'S27301S', 'S27302A', 'S27302D', 'S27302S', 'S27309A', 'S27309D',
        'S27309S', 'S27311A', 'S27311D', 'S27311S', 'S27312A', 'S27312D', 'S27312S', 'S27319A',
        'S27319D', 'S27319S', 'S27321A', 'S27321D', 'S27321S', 'S27322A', 'S27322D', 'S27322S',
        'S27329A', 'S27329D', 'S27329S', 'S27331A', 'S27331D', 'S27331S', 'S27332A', 'S27332D',
        'S27332S', 'S27339A', 'S27339D', 'S27339S', 'S27391A', 'S27391D', 'S27391S', 'S27392A',
        'S27392D', 'S27392S', 'S27399A', 'S27399D', 'S27399S', 'S27401A', 'S27401D', 'S27401S',
        'S27402A', 'S27402D', 'S27402S', 'S27409A', 'S27409D', 'S27409S', 'S27411A', 'S27411D',
        'S27411S', 'S27412A', 'S27412D', 'S27412S', 'S27419A', 'S27419D', 'S27419S', 'S27421A',
        'S27421D', 'S27421S', 'S27422A', 'S27422D', 'S27422S', 'S27429A', 'S27429D', 'S27429S',
        'S27431A', 'S27431D', 'S27431S', 'S27432A', 'S27432D', 'S27432S', 'S27439A', 'S27439D',
        'S27439S', 'S27491A', 'S27491D', 'S27491S', 'S27492A', 'S27492D', 'S27492S', 'S27499A',
        'S27499D', 'S27499S', 'S2750XA', 'S2750XD', 'S2750XS', 'S2751XA', 'S2751XD', 'S2751XS',
        'S2752XA', 'S2752XD', 'S2752XS', 'S2753XA', 'S2753XD', 'S2753XS', 'S2759XA', 'S2759XD',
        'S2759XS', 'S2760XA', 'S2760XD', 'S2760XS', 'S2763XA', 'S2763XD', 'S2763XS', 'S2769XA',
        'S2769XD', 'S2769XS', 'S27802A', 'S27802D', 'S27802S', 'S27803A', 'S27803D', 'S27803S',
        'S27808A', 'S27808D', 'S27808S', 'S27809A', 'S27809D', 'S27809S', 'S27812A', 'S27812D',
        'S27812S', 'S27813A', 'S27813D', 'S27813S', 'S27818A', 'S27818D', 'S27818S', 'S27819A',
        'S27819D', 'S27819S', 'S27892A', 'S27892D', 'S27892S', 'S27893A', 'S27893D', 'S27893S',
        'S27898A', 'S27898D', 'S27898S', 'S27899A', 'S27899D', 'S27899S', 'S279XXA', 'S279XXD',
        'S279XXS', 'S31001A', 'S31001D', 'S31001S', 'S31011A', 'S31011D', 'S31011S', 'S31021A',
        'S31021D', 'S31021S', 'S31031A', 'S31031D', 'S31031S', 'S31041A', 'S31041D', 'S31041S',
        'S31051A', 'S31051D', 'S31051S', 'S31600A', 'S31600D', 'S31600S', 'S31601A', 'S31601D',
        'S31601S', 'S31602A', 'S31602D', 'S31602S', 'S31603A', 'S31603D', 'S31603S', 'S31604A',
        'S31604D', 'S31604S', 'S31605A', 'S31605D', 'S31605S', 'S31609A', 'S31609D', 'S31609S',
        'S31610A', 'S31610D', 'S31610S', 'S31611A', 'S31611D', 'S31611S', 'S31612A', 'S31612D',
        'S31612S', 'S31613A', 'S31613D', 'S31613S', 'S31614A', 'S31614D', 'S31614S', 'S31615A',
        'S31615D', 'S31615S', 'S31619A', 'S31619D', 'S31619S', 'S31620A', 'S31620D', 'S31620S',
        'S31621A', 'S31621D', 'S31621S', 'S31622A', 'S31622D', 'S31622S', 'S31623A', 'S31623D',
        'S31623S', 'S31624A', 'S31624D', 'S31624S', 'S31625A', 'S31625D', 'S31625S', 'S31629A',
        'S31629D', 'S31629S', 'S31630A', 'S31630D', 'S31630S', 'S31631A', 'S31631D', 'S31631S',
        'S31632A', 'S31632D', 'S31632S', 'S31633A', 'S31633D', 'S31633S', 'S31634A', 'S31634D',
        'S31634S', 'S31635A', 'S31635D', 'S31635S', 'S31639A', 'S31639D', 'S31639S', 'S31640A',
        'S31640D', 'S31640S', 'S31641A', 'S31641D', 'S31641S', 'S31642A', 'S31642D', 'S31642S',
        'S31643A', 'S31643D', 'S31643S', 'S31644A', 'S31644D', 'S31644S', 'S31645A', 'S31645D',
        'S31645S', 'S31649A', 'S31649D', 'S31649S', 'S31650A', 'S31650D', 'S31650S', 'S31651A',
        'S31651D', 'S31651S', 'S31652A', 'S31652D', 'S31652S', 'S31653A', 'S31653D', 'S31653S',
        'S31654A', 'S31654D', 'S31654S', 'S31655A', 'S31655D', 'S31655S', 'S31659A', 'S31659D',
        'S31659S', 'S32000A', 'S32000B', 'S32000D', 'S32000G', 'S32000K', 'S32000S', 'S32001A',
        'S32001B', 'S32001D', 'S32001G', 'S32001K', 'S32001S', 'S32002A', 'S32002B', 'S32002D',
        'S32002G', 'S32002K', 'S32002S', 'S32008A', 'S32008B', 'S32008D', 'S32008G', 'S32008K',
        'S32008S', 'S32009A', 'S32009B', 'S32009D', 'S32009G', 'S32009K', 'S32009S', 'S32010A',
        'S32010B', 'S32010D', 'S32010G', 'S32010K', 'S32010S', 'S32011A', 'S32011B', 'S32011D',
        'S32011G', 'S32011K', 'S32011S', 'S32012A', 'S32012B', 'S32012D', 'S32012G', 'S32012K',
        'S32012S', 'S32018A', 'S32018B', 'S32018D', 'S32018G', 'S32018K', 'S32018S', 'S32019A',
        'S32019B', 'S32019D', 'S32019G', 'S32019K', 'S32019S', 'S32020A', 'S32020B', 'S32020D',
        'S32020G', 'S32020K', 'S32020S', 'S32021A', 'S32021B', 'S32021D', 'S32021G', 'S32021K',
        'S32021S', 'S32022A', 'S32022B', 'S32022D', 'S32022G', 'S32022K', 'S32022S', 'S32028A',
        'S32028B', 'S32028D', 'S32028G', 'S32028K', 'S32028S', 'S32029A', 'S32029B', 'S32029D',
        'S32029G', 'S32029K', 'S32029S', 'S32030A', 'S32030B', 'S32030D', 'S32030G', 'S32030K',
        'S32030S', 'S32031A', 'S32031B', 'S32031D', 'S32031G', 'S32031K', 'S32031S', 'S32032A',
        'S32032B', 'S32032D', 'S32032G', 'S32032K', 'S32032S', 'S32038A', 'S32038B', 'S32038D',
        'S32038G', 'S32038K', 'S32038S', 'S32039A', 'S32039B', 'S32039D', 'S32039G', 'S32039K',
        'S32039S', 'S32040A', 'S32040B', 'S32040D', 'S32040G', 'S32040K', 'S32040S', 'S32041A',
        'S32041B', 'S32041D', 'S32041G', 'S32041K', 'S32041S', 'S32042A', 'S32042B', 'S32042D',
        'S32042G', 'S32042K', 'S32042S', 'S32048A', 'S32048B', 'S32048D', 'S32048G', 'S32048K',
        'S32048S', 'S32049A', 'S32049B', 'S32049D', 'S32049G', 'S32049K', 'S32049S', 'S32050A',
        'S32050B', 'S32050D', 'S32050G', 'S32050K', 'S32050S', 'S32051A', 'S32051B', 'S32051D',
        'S32051G', 'S32051K', 'S32051S', 'S32052A', 'S32052B', 'S32052D', 'S32052G', 'S32052K',
        'S32052S', 'S32058A', 'S32058B', 'S32058D', 'S32058G', 'S32058K', 'S32058S', 'S32059A',
        'S32059B', 'S32059D', 'S32059G', 'S32059K', 'S32059S', 'S3210XA', 'S3210XB', 'S3210XD',
        'S3210XG', 'S3210XK', 'S3210XS', 'S32110A', 'S32110B', 'S32110D', 'S32110G', 'S32110K',
        'S32110S', 'S32111A', 'S32111B', 'S32111D', 'S32111G', 'S32111K', 'S32111S', 'S32112A',
        'S32112B', 'S32112D', 'S32112G', 'S32112K', 'S32112S', 'S32119A', 'S32119B', 'S32119D',
        'S32119G', 'S32119K', 'S32119S', 'S32120A', 'S32120B', 'S32120D', 'S32120G', 'S32120K',
        'S32120S', 'S32121A', 'S32121B', 'S32121D', 'S32121G', 'S32121K', 'S32121S', 'S32122A',
        'S32122B', 'S32122D', 'S32122G', 'S32122K', 'S32122S', 'S32129A', 'S32129B', 'S32129D',
        'S32129G', 'S32129K', 'S32129S', 'S32130A', 'S32130B', 'S32130D', 'S32130G', 'S32130K',
        'S32130S', 'S32131A', 'S32131B', 'S32131D', 'S32131G', 'S32131K', 'S32131S', 'S32132A',
        'S32132B', 'S32132D', 'S32132G', 'S32132K', 'S32132S', 'S32139A', 'S32139B', 'S32139D',
        'S32139G', 'S32139K', 'S32139S', 'S3214XA', 'S3214XB', 'S3214XD', 'S3214XG', 'S3214XK',
        'S3214XS', 'S3215XA', 'S3215XB', 'S3215XD', 'S3215XG', 'S3215XK', 'S3215XS', 'S3216XA',
        'S3216XB', 'S3216XD', 'S3216XG', 'S3216XK', 'S3216XS', 'S3217XA', 'S3217XB', 'S3217XD',
        'S3217XG', 'S3217XK', 'S3217XS', 'S3219XA', 'S3219XB', 'S3219XD', 'S3219XG', 'S3219XK',
        'S3219XS', 'S322XXA', 'S322XXB', 'S322XXD', 'S322XXG', 'S322XXK', 'S322XXS', 'S32301A',
        'S32301B', 'S32301D', 'S32301G', 'S32301K', 'S32301S', 'S32302A', 'S32302B', 'S32302D',
        'S32302G', 'S32302K', 'S32302S', 'S32309A', 'S32309B', 'S32309D', 'S32309G', 'S32309K',
        'S32309S', 'S32311A', 'S32311B', 'S32311D', 'S32311G', 'S32311K', 'S32311S', 'S32312A',
        'S32312B', 'S32312D', 'S32312G', 'S32312K', 'S32312S', 'S32313A', 'S32313B', 'S32313D',
        'S32313G', 'S32313K', 'S32313S', 'S32314A', 'S32314B', 'S32314D', 'S32314G', 'S32314K',
        'S32314S', 'S32315A', 'S32315B', 'S32315D', 'S32315G', 'S32315K', 'S32315S', 'S32316A',
        'S32316B', 'S32316D', 'S32316G', 'S32316K', 'S32316S', 'S32391A', 'S32391B', 'S32391D',
        'S32391G', 'S32391K', 'S32391S', 'S32392A', 'S32392B', 'S32392D', 'S32392G', 'S32392K',
        'S32392S', 'S32399A', 'S32399B', 'S32399D', 'S32399G', 'S32399K', 'S32399S', 'S32401A',
        'S32401B', 'S32401D', 'S32401G', 'S32401K', 'S32401S', 'S32402A', 'S32402B', 'S32402D',
        'S32402G', 'S32402K', 'S32402S', 'S32409A', 'S32409B', 'S32409D', 'S32409G', 'S32409K',
        'S32409S', 'S32411A', 'S32411B', 'S32411D', 'S32411G', 'S32411K', 'S32411S', 'S32412A',
        'S32412B', 'S32412D', 'S32412G', 'S32412K', 'S32412S', 'S32413A', 'S32413B', 'S32413D',
        'S32413G', 'S32413K', 'S32413S', 'S32414A', 'S32414B', 'S32414D', 'S32414G', 'S32414K',
        'S32414S', 'S32415A', 'S32415B', 'S32415D', 'S32415G', 'S32415K', 'S32415S', 'S32416A',
        'S32416B', 'S32416D', 'S32416G', 'S32416K', 'S32416S', 'S32421A', 'S32421B', 'S32421D',
        'S32421G', 'S32421K', 'S32421S', 'S32422A', 'S32422B', 'S32422D', 'S32422G', 'S32422K',
        'S32422S', 'S32423A', 'S32423B', 'S32423D', 'S32423G', 'S32423K', 'S32423S', 'S32424A',
        'S32424B', 'S32424D', 'S32424G', 'S32424K', 'S32424S', 'S32425A', 'S32425B', 'S32425D',
        'S32425G', 'S32425K', 'S32425S', 'S32426A', 'S32426B', 'S32426D', 'S32426G', 'S32426K',
        'S32426S', 'S32431A', 'S32431B', 'S32431D', 'S32431G', 'S32431K', 'S32431S', 'S32432A',
        'S32432B', 'S32432D', 'S32432G', 'S32432K', 'S32432S', 'S32433A', 'S32433B', 'S32433D',
        'S32433G', 'S32433K', 'S32433S', 'S32434A', 'S32434B', 'S32434D', 'S32434G', 'S32434K',
        'S32434S', 'S32435A', 'S32435B', 'S32435D', 'S32435G', 'S32435K', 'S32435S', 'S32436A',
        'S32436B', 'S32436D', 'S32436G', 'S32436K', 'S32436S', 'S32441A', 'S32441B', 'S32441D',
        'S32441G', 'S32441K', 'S32441S', 'S32442A', 'S32442B', 'S32442D', 'S32442G', 'S32442K',
        'S32442S', 'S32443A', 'S32443B', 'S32443D', 'S32443G', 'S32443K', 'S32443S', 'S32444A',
        'S32444B', 'S32444D', 'S32444G', 'S32444K', 'S32444S', 'S32445A', 'S32445B', 'S32445D',
        'S32445G', 'S32445K', 'S32445S', 'S32446A', 'S32446B', 'S32446D', 'S32446G', 'S32446K',
        'S32446S', 'S32451A', 'S32451B', 'S32451D', 'S32451G', 'S32451K', 'S32451S', 'S32452A',
        'S32452B', 'S32452D', 'S32452G', 'S32452K', 'S32452S', 'S32453A', 'S32453B', 'S32453D',
        'S32453G', 'S32453K', 'S32453S', 'S32454A', 'S32454B', 'S32454D', 'S32454G', 'S32454K',
        'S32454S', 'S32455A', 'S32455B', 'S32455D', 'S32455G', 'S32455K', 'S32455S', 'S32456A',
        'S32456B', 'S32456D', 'S32456G', 'S32456K', 'S32456S', 'S32461A', 'S32461B', 'S32461D',
        'S32461G', 'S32461K', 'S32461S', 'S32462A', 'S32462B', 'S32462D', 'S32462G', 'S32462K',
        'S32462S', 'S32463A', 'S32463B', 'S32463D', 'S32463G', 'S32463K', 'S32463S', 'S32464A',
        'S32464B', 'S32464D', 'S32464G', 'S32464K', 'S32464S', 'S32465A', 'S32465B', 'S32465D',
        'S32465G', 'S32465K', 'S32465S', 'S32466A', 'S32466B', 'S32466D', 'S32466G', 'S32466K',
        'S32466S', 'S32471A', 'S32471B', 'S32471D', 'S32471G', 'S32471K', 'S32471S', 'S32472A',
        'S32472B', 'S32472D', 'S32472G', 'S32472K', 'S32472S', 'S32473A', 'S32473B', 'S32473D',
        'S32473G', 'S32473K', 'S32473S', 'S32474A', 'S32474B', 'S32474D', 'S32474G', 'S32474K',
        'S32474S', 'S32475A', 'S32475B', 'S32475D', 'S32475G', 'S32475K', 'S32475S', 'S32476A',
        'S32476B', 'S32476D', 'S32476G', 'S32476K', 'S32476S', 'S32481A', 'S32481B', 'S32481D',
        'S32481G', 'S32481K', 'S32481S', 'S32482A', 'S32482B', 'S32482D', 'S32482G', 'S32482K',
        'S32482S', 'S32483A', 'S32483B', 'S32483D', 'S32483G', 'S32483K', 'S32483S', 'S32484A',
        'S32484B', 'S32484D', 'S32484G', 'S32484K', 'S32484S', 'S32485A', 'S32485B', 'S32485D',
        'S32485G', 'S32485K', 'S32485S', 'S32486A', 'S32486B', 'S32486D', 'S32486G', 'S32486K',
        'S32486S', 'S32491A', 'S32491B', 'S32491D', 'S32491G', 'S32491K', 'S32491S', 'S32492A',
        'S32492B', 'S32492D', 'S32492G', 'S32492K', 'S32492S', 'S32499A', 'S32499B', 'S32499D',
        'S32499G', 'S32499K', 'S32499S', 'S32501A', 'S32501B', 'S32501D', 'S32501G', 'S32501K',
        'S32501S', 'S32502A', 'S32502B', 'S32502D', 'S32502G', 'S32502K', 'S32502S', 'S32509A',
        'S32509B', 'S32509D', 'S32509G', 'S32509K', 'S32509S', 'S32511A', 'S32511B', 'S32511D',
        'S32511G', 'S32511K', 'S32511S', 'S32512A', 'S32512B', 'S32512D', 'S32512G', 'S32512K',
        'S32512S', 'S32519A', 'S32519B', 'S32519D', 'S32519G', 'S32519K', 'S32519S', 'S32591A',
        'S32591B', 'S32591D', 'S32591G', 'S32591K', 'S32591S', 'S32592A', 'S32592B', 'S32592D',
        'S32592G', 'S32592K', 'S32592S', 'S32599A', 'S32599B', 'S32599D', 'S32599G', 'S32599K',
        'S32599S', 'S32601A', 'S32601B', 'S32601D', 'S32601G', 'S32601K', 'S32601S', 'S32602A',
        'S32602B', 'S32602D', 'S32602G', 'S32602K', 'S32602S', 'S32609A', 'S32609B', 'S32609D',
        'S32609G', 'S32609K', 'S32609S', 'S32611A', 'S32611B', 'S32611D', 'S32611G', 'S32611K',
        'S32611S', 'S32612A', 'S32612B', 'S32612D', 'S32612G', 'S32612K', 'S32612S', 'S32613A',
        'S32613B', 'S32613D', 'S32613G', 'S32613K', 'S32613S', 'S32614A', 'S32614B', 'S32614D',
        'S32614G', 'S32614K', 'S32614S', 'S32615A', 'S32615B', 'S32615D', 'S32615G', 'S32615K',
        'S32615S', 'S32616A', 'S32616B', 'S32616D', 'S32616G', 'S32616K', 'S32616S', 'S32691A',
        'S32691B', 'S32691D', 'S32691G', 'S32691K', 'S32691S', 'S32692A', 'S32692B', 'S32692D',
        'S32692G', 'S32692K', 'S32692S', 'S32699A', 'S32699B', 'S32699D', 'S32699G', 'S32699K',
        'S32699S', 'S32810A', 'S32810B', 'S32810D', 'S32810G', 'S32810K', 'S32810S', 'S32811A',
        'S32811B', 'S32811D', 'S32811G', 'S32811K', 'S32811S', 'S3282XA', 'S3282XB', 'S3282XD',
        'S3282XG', 'S3282XK', 'S3282XS', 'S3289XA', 'S3289XB', 'S3289XD', 'S3289XG', 'S3289XK',
        'S3289XS', 'S329XXA', 'S329XXB', 'S329XXD', 'S329XXG', 'S329XXK', 'S329XXS', 'S330XXA',
        'S330XXD', 'S330XXS', 'S33101A', 'S33101D', 'S33101S', 'S33111A', 'S33111D', 'S33111S',
        'S33121A', 'S33121D', 'S33121S', 'S33131A', 'S33131D', 'S33131S', 'S33141A', 'S33141D',
        'S33141S', 'S332XXA', 'S332XXD', 'S332XXS', 'S3330XA', 'S3330XD', 'S3330XS', 'S3339XA',
        'S3339XD', 'S3339XS', 'S334XXA', 'S334XXD', 'S334XXS', 'S3401XA', 'S3401XD', 'S3401XS',
        'S3402XA', 'S3402XD', 'S3402XS', 'S34111A', 'S34111D', 'S34111S', 'S34112A', 'S34112D',
        'S34112S', 'S34113A', 'S34113D', 'S34113S', 'S34114A', 'S34114D', 'S34114S', 'S34115A',
        'S34115D', 'S34115S', 'S34119A', 'S34119D', 'S34119S', 'S34121A', 'S34121D', 'S34121S',
        'S34122A', 'S34122D', 'S34122S', 'S34123A', 'S34123D', 'S34123S', 'S34124A', 'S34124D',
        'S34124S', 'S34125A', 'S34125D', 'S34125S', 'S34129A', 'S34129D', 'S34129S', 'S34131A',
        'S34131D', 'S34131S', 'S34132A', 'S34132D', 'S34132S', 'S3600XA', 'S3600XD', 'S3600XS',
        'S36020A', 'S36020D', 'S36020S', 'S36021A', 'S36021D', 'S36021S', 'S36029A', 'S36029D',
        'S36029S', 'S36030A', 'S36030D', 'S36030S', 'S36031A', 'S36031D', 'S36031S', 'S36032A',
        'S36032D', 'S36032S', 'S36039A', 'S36039D', 'S36039S', 'S3609XA', 'S3609XD', 'S3609XS',
        'S36112A', 'S36112D', 'S36112S', 'S36113A', 'S36113D', 'S36113S', 'S36114A', 'S36114D',
        'S36114S', 'S36115A', 'S36115D', 'S36115S', 'S36116A', 'S36116D', 'S36116S', 'S36118A',
        'S36118D', 'S36118S', 'S36119A', 'S36119D', 'S36119S', 'S36122A', 'S36122D', 'S36122S',
        'S36123A', 'S36123D', 'S36123S', 'S36128A', 'S36128D', 'S36128S', 'S36129A', 'S36129D',
        'S36129S', 'S3613XA', 'S3613XD', 'S3613XS', 'S36200A', 'S36200D', 'S36200S', 'S36201A',
        'S36201D', 'S36201S', 'S36202A', 'S36202D', 'S36202S', 'S36209A', 'S36209D', 'S36209S',
        'S36220A', 'S36220D', 'S36220S', 'S36221A', 'S36221D', 'S36221S', 'S36222A', 'S36222D',
        'S36222S', 'S36229A', 'S36229D', 'S36229S', 'S36230A', 'S36230D', 'S36230S', 'S36231A',
        'S36231D', 'S36231S', 'S36232A', 'S36232D', 'S36232S', 'S36239A', 'S36239D', 'S36239S',
        'S36240A', 'S36240D', 'S36240S', 'S36241A', 'S36241D', 'S36241S', 'S36242A', 'S36242D',
        'S36242S', 'S36249A', 'S36249D', 'S36249S', 'S36250A', 'S36250D', 'S36250S', 'S36251A',
        'S36251D', 'S36251S', 'S36252A', 'S36252D', 'S36252S', 'S36259A', 'S36259D', 'S36259S',
        'S36260A', 'S36260D', 'S36260S', 'S36261A', 'S36261D', 'S36261S', 'S36262A', 'S36262D',
        'S36262S', 'S36269A', 'S36269D', 'S36269S', 'S36290A', 'S36290D', 'S36290S', 'S36291A',
        'S36291D', 'S36291S', 'S36292A', 'S36292D', 'S36292S', 'S36299A', 'S36299D', 'S36299S',
        'S3630XA', 'S3630XD', 'S3630XS', 'S3632XA', 'S3632XD', 'S3632XS', 'S3633XA', 'S3633XD',
        'S3633XS', 'S3639XA', 'S3639XD', 'S3639XS', 'S36400A', 'S36400D', 'S36400S', 'S36408A',
        'S36408D', 'S36408S', 'S36409A', 'S36409D', 'S36409S', 'S36410A', 'S36410D', 'S36410S',
        'S36418A', 'S36418D', 'S36418S', 'S36419A', 'S36419D', 'S36419S', 'S36420A', 'S36420D',
        'S36420S', 'S36428A', 'S36428D', 'S36428S', 'S36429A', 'S36429D', 'S36429S', 'S36430A',
        'S36430D', 'S36430S', 'S36438A', 'S36438D', 'S36438S', 'S36439A', 'S36439D', 'S36439S',
        'S36490A', 'S36490D', 'S36490S', 'S36498A', 'S36498D', 'S36498S', 'S36499A', 'S36499D',
        'S36499S', 'S36500A', 'S36500D', 'S36500S', 'S36501A', 'S36501D', 'S36501S', 'S36502A',
        'S36502D', 'S36502S', 'S36503A', 'S36503D', 'S36503S', 'S36508A', 'S36508D', 'S36508S',
        'S36509A', 'S36509D', 'S36509S', 'S36510A', 'S36510D', 'S36510S', 'S36511A', 'S36511D',
        'S36511S', 'S36512A', 'S36512D', 'S36512S', 'S36513A', 'S36513D', 'S36513S', 'S36518A',
        'S36518D', 'S36518S', 'S36519A', 'S36519D', 'S36519S', 'S36520A', 'S36520D', 'S36520S',
        'S36521A', 'S36521D', 'S36521S', 'S36522A', 'S36522D', 'S36522S', 'S36523A', 'S36523D',
        'S36523S', 'S36528A', 'S36528D', 'S36528S', 'S36529A', 'S36529D', 'S36529S', 'S36530A',
        'S36530D', 'S36530S', 'S36531A', 'S36531D', 'S36531S', 'S36532A', 'S36532D', 'S36532S',
        'S36533A', 'S36533D', 'S36533S', 'S36538A', 'S36538D', 'S36538S', 'S36539A', 'S36539D',
        'S36539S', 'S36590A', 'S36590D', 'S36590S', 'S36591A', 'S36591D', 'S36591S', 'S36592A',
        'S36592D', 'S36592S', 'S36593A', 'S36593D', 'S36593S', 'S36598A', 'S36598D', 'S36598S',
        'S36599A', 'S36599D', 'S36599S', 'S3660XA', 'S3660XD', 'S3660XS', 'S3661XA', 'S3661XD',
        'S3661XS', 'S3662XA', 'S3662XD', 'S3662XS', 'S3663XA', 'S3663XD', 'S3663XS', 'S3669XA',
        'S3669XD', 'S3669XS', 'S3681XA', 'S3681XD', 'S3681XS', 'S36892A', 'S36892D', 'S36892S',
        'S36893A', 'S36893D', 'S36893S', 'S36898A', 'S36898D', 'S36898S', 'S36899A', 'S36899D',
        'S36899S', 'S3690XA', 'S3690XD', 'S3690XS', 'S3692XA', 'S3692XD', 'S3692XS', 'S3693XA',
        'S3693XD', 'S3693XS', 'S3699XA', 'S3699XD', 'S3699XS', 'S37001A', 'S37001D', 'S37001S',
        'S37002A', 'S37002D', 'S37002S', 'S37009A', 'S37009D', 'S37009S', 'S37011A', 'S37011D',
        'S37011S', 'S37012A', 'S37012D', 'S37012S', 'S37019A', 'S37019D', 'S37019S', 'S37021A',
        'S37021D', 'S37021S', 'S37022A', 'S37022D', 'S37022S', 'S37029A', 'S37029D', 'S37029S',
        'S37031A', 'S37031D', 'S37031S', 'S37032A', 'S37032D', 'S37032S', 'S37039A', 'S37039D',
        'S37039S', 'S37041A', 'S37041D', 'S37041S', 'S37042A', 'S37042D', 'S37042S', 'S37049A',
        'S37049D', 'S37049S', 'S37051A', 'S37051D', 'S37051S', 'S37052A', 'S37052D', 'S37052S',
        'S37059A', 'S37059D', 'S37059S', 'S37061A', 'S37061D', 'S37061S', 'S37062A', 'S37062D',
        'S37062S', 'S37069A', 'S37069D', 'S37069S', 'S37091A', 'S37091D', 'S37091S', 'S37092A',
        'S37092D', 'S37092S', 'S37099A', 'S37099D', 'S37099S', 'S3710XA', 'S3710XD', 'S3710XS',
        'S3712XA', 'S3712XD', 'S3712XS', 'S3713XA', 'S3713XD', 'S3713XS', 'S3719XA', 'S3719XD',
        'S3719XS', 'S3720XA', 'S3720XD', 'S3720XS', 'S3722XA', 'S3722XD', 'S3722XS', 'S3723XA',
        'S3723XD', 'S3723XS', 'S3729XA', 'S3729XD', 'S3729XS', 'S3730XA', 'S3730XD', 'S3730XS',
        'S3732XA', 'S3732XD', 'S3732XS', 'S3733XA', 'S3733XD', 'S3733XS', 'S3739XA', 'S3739XD',
        'S3739XS', 'S37401A', 'S37401D', 'S37401S', 'S37402A', 'S37402D', 'S37402S', 'S37409A',
        'S37409D', 'S37409S', 'S37421A', 'S37421D', 'S37421S', 'S37422A', 'S37422D', 'S37422S',
        'S37429A', 'S37429D', 'S37429S', 'S37431A', 'S37431D', 'S37431S', 'S37432A', 'S37432D',
        'S37432S', 'S37439A', 'S37439D', 'S37439S', 'S37491A', 'S37491D', 'S37491S', 'S37492A',
        'S37492D', 'S37492S', 'S37499A', 'S37499D', 'S37499S', 'S37501A', 'S37501D', 'S37501S',
        'S37502A', 'S37502D', 'S37502S', 'S37509A', 'S37509D', 'S37509S', 'S37511A', 'S37511D',
        'S37511S', 'S37512A', 'S37512D', 'S37512S', 'S37519A', 'S37519D', 'S37519S', 'S37521A',
        'S37521D', 'S37521S', 'S37522A', 'S37522D', 'S37522S', 'S37529A', 'S37529D', 'S37529S',
        'S37531A', 'S37531D', 'S37531S', 'S37532A', 'S37532D', 'S37532S', 'S37539A', 'S37539D',
        'S37539S', 'S37591A', 'S37591D', 'S37591S', 'S37592A', 'S37592D', 'S37592S', 'S37599A',
        'S37599D', 'S37599S', 'S3760XA', 'S3760XD', 'S3760XS', 'S3762XA', 'S3762XD', 'S3762XS',
        'S3763XA', 'S3763XD', 'S3763XS', 'S3769XA', 'S3769XD', 'S3769XS', 'S37812A', 'S37812D',
        'S37812S', 'S37813A', 'S37813D', 'S37813S', 'S37818A', 'S37818D', 'S37818S', 'S37819A',
        'S37819D', 'S37819S', 'S37822A', 'S37822D', 'S37822S', 'S37823A', 'S37823D', 'S37823S',
        'S37828A', 'S37828D', 'S37828S', 'S37829A', 'S37829D', 'S37829S', 'S37892A', 'S37892D',
        'S37892S', 'S37893A', 'S37893D', 'S37893S', 'S37898A', 'S37898D', 'S37898S', 'S37899A',
        'S37899D', 'S37899S', 'S3790XA', 'S3790XD', 'S3790XS', 'S3792XA', 'S3792XD', 'S3792XS',
        'S3793XA', 'S3793XD', 'S3793XS', 'S3799XA', 'S3799XD', 'S3799XS', 'S381XXA', 'S381XXD',
        'S381XXS', 'S42001A', 'S42001B', 'S42001D', 'S42001G', 'S42001K', 'S42001P', 'S42001S',
        'S42002A', 'S42002B', 'S42002D', 'S42002G', 'S42002K', 'S42002P', 'S42002S', 'S42009A',
        'S42009B', 'S42009D', 'S42009G', 'S42009K', 'S42009P', 'S42009S', 'S42011A', 'S42011B',
        'S42011D', 'S42011G', 'S42011K', 'S42011P', 'S42011S', 'S42012A', 'S42012B', 'S42012D',
        'S42012G', 'S42012K', 'S42012P', 'S42012S', 'S42013A', 'S42013B', 'S42013D', 'S42013G',
        'S42013K', 'S42013P', 'S42013S', 'S42014A', 'S42014B', 'S42014D', 'S42014G', 'S42014K',
        'S42014P', 'S42014S', 'S42015A', 'S42015B', 'S42015D', 'S42015G', 'S42015K', 'S42015P',
        'S42015S', 'S42016A', 'S42016B', 'S42016D', 'S42016G', 'S42016K', 'S42016P', 'S42016S',
        'S42017A', 'S42017B', 'S42017D', 'S42017G', 'S42017K', 'S42017P', 'S42017S', 'S42018A',
        'S42018B', 'S42018D', 'S42018G', 'S42018K', 'S42018P', 'S42018S', 'S42019A', 'S42019B',
        'S42019D', 'S42019G', 'S42019K', 'S42019P', 'S42019S', 'S42021A', 'S42021B', 'S42021D',
        'S42021G', 'S42021K', 'S42021P', 'S42021S', 'S42022A', 'S42022B', 'S42022D', 'S42022G',
        'S42022K', 'S42022P', 'S42022S', 'S42023A', 'S42023B', 'S42023D', 'S42023G', 'S42023K',
        'S42023P', 'S42023S', 'S42024A', 'S42024B', 'S42024D', 'S42024G', 'S42024K', 'S42024P',
        'S42024S', 'S42025A', 'S42025B', 'S42025D', 'S42025G', 'S42025K', 'S42025P', 'S42025S',
        'S42026A', 'S42026B', 'S42026D', 'S42026G', 'S42026K', 'S42026P', 'S42026S', 'S42031A',
        'S42031B', 'S42031D', 'S42031G', 'S42031K', 'S42031P', 'S42031S', 'S42032A', 'S42032B',
        'S42032D', 'S42032G', 'S42032K', 'S42032P', 'S42032S', 'S42033A', 'S42033B', 'S42033D',
        'S42033G', 'S42033K', 'S42033P', 'S42033S', 'S42034A', 'S42034B', 'S42034D', 'S42034G',
        'S42034K', 'S42034P', 'S42034S', 'S42035A', 'S42035B', 'S42035D', 'S42035G', 'S42035K',
        'S42035P', 'S42035S', 'S42036A', 'S42036B', 'S42036D', 'S42036G', 'S42036K', 'S42036P',
        'S42036S', 'S42101A', 'S42101B', 'S42101D', 'S42101G', 'S42101K', 'S42101P', 'S42101S',
        'S42102A', 'S42102B', 'S42102D', 'S42102G', 'S42102K', 'S42102P', 'S42102S', 'S42109A',
        'S42109B', 'S42109D', 'S42109G', 'S42109K', 'S42109P', 'S42109S', 'S42111A', 'S42111B',
        'S42111D', 'S42111G', 'S42111K', 'S42111P', 'S42111S', 'S42112A', 'S42112B', 'S42112D',
        'S42112G', 'S42112K', 'S42112P', 'S42112S', 'S42113A', 'S42113B', 'S42113D', 'S42113G',
        'S42113K', 'S42113P', 'S42113S', 'S42114A', 'S42114B', 'S42114D', 'S42114G', 'S42114K',
        'S42114P', 'S42114S', 'S42115A', 'S42115B', 'S42115D', 'S42115G', 'S42115K', 'S42115P',
        'S42115S', 'S42116A', 'S42116B', 'S42116D', 'S42116G', 'S42116K', 'S42116P', 'S42116S',
        'S42121A', 'S42121B', 'S42121D', 'S42121G', 'S42121K', 'S42121P', 'S42121S', 'S42122A',
        'S42122B', 'S42122D', 'S42122G', 'S42122K', 'S42122P', 'S42122S', 'S42123A', 'S42123B',
        'S42123D', 'S42123G', 'S42123K', 'S42123P', 'S42123S', 'S42124A', 'S42124B', 'S42124D',
        'S42124G', 'S42124K', 'S42124P', 'S42124S', 'S42125A', 'S42125B', 'S42125D', 'S42125G',
        'S42125K', 'S42125P', 'S42125S', 'S42126A', 'S42126B', 'S42126D', 'S42126G', 'S42126K',
        'S42126P', 'S42126S', 'S42131A', 'S42131B', 'S42131D', 'S42131G', 'S42131K', 'S42131P',
        'S42131S', 'S42132A', 'S42132B', 'S42132D', 'S42132G', 'S42132K', 'S42132P', 'S42132S',
        'S42133A', 'S42133B', 'S42133D', 'S42133G', 'S42133K', 'S42133P', 'S42133S', 'S42134A',
        'S42134B', 'S42134D', 'S42134G', 'S42134K', 'S42134P', 'S42134S', 'S42135A', 'S42135B',
        'S42135D', 'S42135G', 'S42135K', 'S42135P', 'S42135S', 'S42136A', 'S42136B', 'S42136D',
        'S42136G', 'S42136K', 'S42136P', 'S42136S', 'S42141A', 'S42141B', 'S42141D', 'S42141G',
        'S42141K', 'S42141P', 'S42141S', 'S42142A', 'S42142B', 'S42142D', 'S42142G', 'S42142K',
        'S42142P', 'S42142S', 'S42143A', 'S42143B', 'S42143D', 'S42143G', 'S42143K', 'S42143P',
        'S42143S', 'S42144A', 'S42144B', 'S42144D', 'S42144G', 'S42144K', 'S42144P', 'S42144S',
        'S42145A', 'S42145B', 'S42145D', 'S42145G', 'S42145K', 'S42145P', 'S42145S', 'S42146A',
        'S42146B', 'S42146D', 'S42146G', 'S42146K', 'S42146P', 'S42146S', 'S42151A', 'S42151B',
        'S42151D', 'S42151G', 'S42151K', 'S42151P', 'S42151S', 'S42152A', 'S42152B', 'S42152D',
        'S42152G', 'S42152K', 'S42152P', 'S42152S', 'S42153A', 'S42153B', 'S42153D', 'S42153G',
        'S42153K', 'S42153P', 'S42153S', 'S42154A', 'S42154B', 'S42154D', 'S42154G', 'S42154K',
        'S42154P', 'S42154S', 'S42155A', 'S42155B', 'S42155D', 'S42155G', 'S42155K', 'S42155P',
        'S42155S', 'S42156A', 'S42156B', 'S42156D', 'S42156G', 'S42156K', 'S42156P', 'S42156S',
        'S42191A', 'S42191B', 'S42191D', 'S42191G', 'S42191K', 'S42191P', 'S42191S', 'S42192A',
        'S42192B', 'S42192D', 'S42192G', 'S42192K', 'S42192P', 'S42192S', 'S42199A', 'S42199B',
        'S42199D', 'S42199G', 'S42199K', 'S42199P', 'S42199S', 'S42201A', 'S42201B', 'S42201D',
        'S42201G', 'S42201K', 'S42201P', 'S42201S', 'S42202A', 'S42202B', 'S42202D', 'S42202G',
        'S42202K', 'S42202P', 'S42202S', 'S42209A', 'S42209B', 'S42209D', 'S42209G', 'S42209K',
        'S42209P', 'S42209S', 'S42211A', 'S42211B', 'S42211D', 'S42211G', 'S42211K', 'S42211P',
        'S42211S', 'S42212A', 'S42212B', 'S42212D', 'S42212G', 'S42212K', 'S42212P', 'S42212S',
        'S42213A', 'S42213B', 'S42213D', 'S42213G', 'S42213K', 'S42213P', 'S42213S', 'S42214A',
        'S42214B', 'S42214D', 'S42214G', 'S42214K', 'S42214P', 'S42214S', 'S42215A', 'S42215B',
        'S42215D', 'S42215G', 'S42215K', 'S42215P', 'S42215S', 'S42216A', 'S42216B', 'S42216D',
        'S42216G', 'S42216K', 'S42216P', 'S42216S', 'S42221A', 'S42221B', 'S42221D', 'S42221G',
        'S42221K', 'S42221P', 'S42221S', 'S42222A', 'S42222B', 'S42222D', 'S42222G', 'S42222K',
        'S42222P', 'S42222S', 'S42223A', 'S42223B', 'S42223D', 'S42223G', 'S42223K', 'S42223P',
        'S42223S', 'S42224A', 'S42224B', 'S42224D', 'S42224G', 'S42224K', 'S42224P', 'S42224S',
        'S42225A', 'S42225B', 'S42225D', 'S42225G', 'S42225K', 'S42225P', 'S42225S', 'S42226A',
        'S42226B', 'S42226D', 'S42226G', 'S42226K', 'S42226P', 'S42226S', 'S42231A', 'S42231B',
        'S42231D', 'S42231G', 'S42231K', 'S42231P', 'S42231S', 'S42232A', 'S42232B', 'S42232D',
        'S42232G', 'S42232K', 'S42232P', 'S42232S', 'S42239A', 'S42239B', 'S42239D', 'S42239G',
        'S42239K', 'S42239P', 'S42239S', 'S42241A', 'S42241B', 'S42241D', 'S42241G', 'S42241K',
        'S42241P', 'S42241S', 'S42242A', 'S42242B', 'S42242D', 'S42242G', 'S42242K', 'S42242P',
        'S42242S', 'S42249A', 'S42249B', 'S42249D', 'S42249G', 'S42249K', 'S42249P', 'S42249S',
        'S42251A', 'S42251B', 'S42251D', 'S42251G', 'S42251K', 'S42251P', 'S42251S', 'S42252A',
        'S42252B', 'S42252D', 'S42252G', 'S42252K', 'S42252P', 'S42252S', 'S42253A', 'S42253B',
        'S42253D', 'S42253G', 'S42253K', 'S42253P', 'S42253S', 'S42254A', 'S42254B', 'S42254D',
        'S42254G', 'S42254K', 'S42254P', 'S42254S', 'S42255A', 'S42255B', 'S42255D', 'S42255G',
        'S42255K', 'S42255P', 'S42255S', 'S42256A', 'S42256B', 'S42256D', 'S42256G', 'S42256K',
        'S42256P', 'S42256S', 'S42261A', 'S42261B', 'S42261D', 'S42261G', 'S42261K', 'S42261P',
        'S42261S', 'S42262A', 'S42262B', 'S42262D', 'S42262G', 'S42262K', 'S42262P', 'S42262S',
        'S42263A', 'S42263B', 'S42263D', 'S42263G', 'S42263K', 'S42263P', 'S42263S', 'S42264A',
        'S42264B', 'S42264D', 'S42264G', 'S42264K', 'S42264P', 'S42264S', 'S42265A', 'S42265B',
        'S42265D', 'S42265G', 'S42265K', 'S42265P', 'S42265S', 'S42266A', 'S42266B', 'S42266D',
        'S42266G', 'S42266K', 'S42266P', 'S42266S', 'S42271A', 'S42271D', 'S42271G', 'S42271K',
        'S42271P', 'S42271S', 'S42272A', 'S42272D', 'S42272G', 'S42272K', 'S42272P', 'S42272S',
        'S42279A', 'S42279D', 'S42279G', 'S42279K', 'S42279P', 'S42279S', 'S42291A', 'S42291B',
        'S42291D', 'S42291G', 'S42291K', 'S42291P', 'S42291S', 'S42292A', 'S42292B', 'S42292D',
        'S42292G', 'S42292K', 'S42292P', 'S42292S', 'S42293A', 'S42293B', 'S42293D', 'S42293G',
        'S42293K', 'S42293P', 'S42293S', 'S42294A', 'S42294B', 'S42294D', 'S42294G', 'S42294K',
        'S42294P', 'S42294S', 'S42295A', 'S42295B', 'S42295D', 'S42295G', 'S42295K', 'S42295P',
        'S42295S', 'S42296A', 'S42296B', 'S42296D', 'S42296G', 'S42296K', 'S42296P', 'S42296S',
        'S42301A', 'S42301B', 'S42301D', 'S42301G', 'S42301K', 'S42301P', 'S42301S', 'S42302A',
        'S42302B', 'S42302D', 'S42302G', 'S42302K', 'S42302P', 'S42302S', 'S42309A', 'S42309B',
        'S42309D', 'S42309G', 'S42309K', 'S42309P', 'S42309S', 'S42311A', 'S42311D', 'S42311G',
        'S42311K', 'S42311P', 'S42311S', 'S42312A', 'S42312D', 'S42312G', 'S42312K', 'S42312P',
        'S42312S', 'S42319A', 'S42319D', 'S42319G', 'S42319K', 'S42319P', 'S42319S', 'S42321A',
        'S42321B', 'S42321D', 'S42321G', 'S42321K', 'S42321P', 'S42321S', 'S42322A', 'S42322B',
        'S42322D', 'S42322G', 'S42322K', 'S42322P', 'S42322S', 'S42323A', 'S42323B', 'S42323D',
        'S42323G', 'S42323K', 'S42323P', 'S42323S', 'S42324A', 'S42324B', 'S42324D', 'S42324G',
        'S42324K', 'S42324P', 'S42324S', 'S42325A', 'S42325B', 'S42325D', 'S42325G', 'S42325K',
        'S42325P', 'S42325S', 'S42326A', 'S42326B', 'S42326D', 'S42326G', 'S42326K', 'S42326P',
        'S42326S', 'S42331A', 'S42331B', 'S42331D', 'S42331G', 'S42331K', 'S42331P', 'S42331S',
        'S42332A', 'S42332B', 'S42332D', 'S42332G', 'S42332K', 'S42332P', 'S42332S', 'S42333A',
        'S42333B', 'S42333D', 'S42333G', 'S42333K', 'S42333P', 'S42333S', 'S42334A', 'S42334B',
        'S42334D', 'S42334G', 'S42334K', 'S42334P', 'S42334S', 'S42335A', 'S42335B', 'S42335D',
        'S42335G', 'S42335K', 'S42335P', 'S42335S', 'S42336A', 'S42336B', 'S42336D', 'S42336G',
        'S42336K', 'S42336P', 'S42336S', 'S42341A', 'S42341B', 'S42341D', 'S42341G', 'S42341K',
        'S42341P', 'S42341S', 'S42342A', 'S42342B', 'S42342D', 'S42342G', 'S42342K', 'S42342P',
        'S42342S', 'S42343A', 'S42343B', 'S42343D', 'S42343G', 'S42343K', 'S42343P', 'S42343S',
        'S42344A', 'S42344B', 'S42344D', 'S42344G', 'S42344K', 'S42344P', 'S42344S', 'S42345A',
        'S42345B', 'S42345D', 'S42345G', 'S42345K', 'S42345P', 'S42345S', 'S42346A', 'S42346B',
        'S42346D', 'S42346G', 'S42346K', 'S42346P', 'S42346S', 'S42351A', 'S42351B', 'S42351D',
        'S42351G', 'S42351K', 'S42351P', 'S42351S', 'S42352A', 'S42352B', 'S42352D', 'S42352G',
        'S42352K', 'S42352P', 'S42352S', 'S42353A', 'S42353B', 'S42353D', 'S42353G', 'S42353K',
        'S42353P', 'S42353S', 'S42354A', 'S42354B', 'S42354D', 'S42354G', 'S42354K', 'S42354P',
        'S42354S', 'S42355A', 'S42355B', 'S42355D', 'S42355G', 'S42355K', 'S42355P', 'S42355S',
        'S42356A', 'S42356B', 'S42356D', 'S42356G', 'S42356K', 'S42356P', 'S42356S', 'S42361A',
        'S42361B', 'S42361D', 'S42361G', 'S42361K', 'S42361P', 'S42361S', 'S42362A', 'S42362B',
        'S42362D', 'S42362G', 'S42362K', 'S42362P', 'S42362S', 'S42363A', 'S42363B', 'S42363D',
        'S42363G', 'S42363K', 'S42363P', 'S42363S', 'S42364A', 'S42364B', 'S42364D', 'S42364G',
        'S42364K', 'S42364P', 'S42364S', 'S42365A', 'S42365B', 'S42365D', 'S42365G', 'S42365K',
        'S42365P', 'S42365S', 'S42366A', 'S42366B', 'S42366D', 'S42366G', 'S42366K', 'S42366P',
        'S42366S', 'S42391A', 'S42391B', 'S42391D', 'S42391G', 'S42391K', 'S42391P', 'S42391S',
        'S42392A', 'S42392B', 'S42392D', 'S42392G', 'S42392K', 'S42392P', 'S42392S', 'S42399A',
        'S42399B', 'S42399D', 'S42399G', 'S42399K', 'S42399P', 'S42399S', 'S42401A', 'S42401B',
        'S42401D', 'S42401G', 'S42401K', 'S42401P', 'S42401S', 'S42402A', 'S42402B', 'S42402D',
        'S42402G', 'S42402K', 'S42402P', 'S42402S', 'S42409A', 'S42409B', 'S42409D', 'S42409G',
        'S42409K', 'S42409P', 'S42409S', 'S42411A', 'S42411B', 'S42411D', 'S42411G', 'S42411K',
        'S42411P', 'S42411S', 'S42412A', 'S42412B', 'S42412D', 'S42412G', 'S42412K', 'S42412P',
        'S42412S', 'S42413A', 'S42413B', 'S42413D', 'S42413G', 'S42413K', 'S42413P', 'S42413S',
        'S42414A', 'S42414B', 'S42414D', 'S42414G', 'S42414K', 'S42414P', 'S42414S', 'S42415A',
        'S42415B', 'S42415D', 'S42415G', 'S42415K', 'S42415P', 'S42415S', 'S42416A', 'S42416B',
        'S42416D', 'S42416G', 'S42416K', 'S42416P', 'S42416S', 'S42421A', 'S42421B', 'S42421D',
        'S42421G', 'S42421K', 'S42421P', 'S42421S', 'S42422A', 'S42422B', 'S42422D', 'S42422G',
        'S42422K', 'S42422P', 'S42422S', 'S42423A', 'S42423B', 'S42423D', 'S42423G', 'S42423K',
        'S42423P', 'S42423S', 'S42424A', 'S42424B', 'S42424D', 'S42424G', 'S42424K', 'S42424P',
        'S42424S', 'S42425A', 'S42425B', 'S42425D', 'S42425G', 'S42425K', 'S42425P', 'S42425S',
        'S42426A', 'S42426B', 'S42426D', 'S42426G', 'S42426K', 'S42426P', 'S42426S', 'S42431A',
        'S42431B', 'S42431D', 'S42431G', 'S42431K', 'S42431P', 'S42431S', 'S42432A', 'S42432B',
        'S42432D', 'S42432G', 'S42432K', 'S42432P', 'S42432S', 'S42433A', 'S42433B', 'S42433D',
        'S42433G', 'S42433K', 'S42433P', 'S42433S', 'S42434A', 'S42434B', 'S42434D', 'S42434G',
        'S42434K', 'S42434P', 'S42434S', 'S42435A', 'S42435B', 'S42435D', 'S42435G', 'S42435K',
        'S42435P', 'S42435S', 'S42436A', 'S42436B', 'S42436D', 'S42436G', 'S42436K', 'S42436P',
        'S42436S', 'S42441A', 'S42441B', 'S42441D', 'S42441G', 'S42441K', 'S42441P', 'S42441S',
        'S42442A', 'S42442B', 'S42442D', 'S42442G', 'S42442K', 'S42442P', 'S42442S', 'S42443A',
        'S42443B', 'S42443D', 'S42443G', 'S42443K', 'S42443P', 'S42443S', 'S42444A', 'S42444B',
        'S42444D', 'S42444G', 'S42444K', 'S42444P', 'S42444S', 'S42445A', 'S42445B', 'S42445D',
        'S42445G', 'S42445K', 'S42445P', 'S42445S', 'S42446A', 'S42446B', 'S42446D', 'S42446G',
        'S42446K', 'S42446P', 'S42446S', 'S42447A', 'S42447B', 'S42447D', 'S42447G', 'S42447K',
        'S42447P', 'S42447S', 'S42448A', 'S42448B', 'S42448D', 'S42448G', 'S42448K', 'S42448P',
        'S42448S', 'S42449A', 'S42449B', 'S42449D', 'S42449G', 'S42449K', 'S42449P', 'S42449S',
        'S42451A', 'S42451B', 'S42451D', 'S42451G', 'S42451K', 'S42451P', 'S42451S', 'S42452A',
        'S42452B', 'S42452D', 'S42452G', 'S42452K', 'S42452P', 'S42452S', 'S42453A', 'S42453B',
        'S42453D', 'S42453G', 'S42453K', 'S42453P', 'S42453S', 'S42454A', 'S42454B', 'S42454D',
        'S42454G', 'S42454K', 'S42454P', 'S42454S', 'S42455A', 'S42455B', 'S42455D', 'S42455G',
        'S42455K', 'S42455P', 'S42455S', 'S42456A', 'S42456B', 'S42456D', 'S42456G', 'S42456K',
        'S42456P', 'S42456S', 'S42461A', 'S42461B', 'S42461D', 'S42461G', 'S42461K', 'S42461P',
        'S42461S', 'S42462A', 'S42462B', 'S42462D', 'S42462G', 'S42462K', 'S42462P', 'S42462S',
        'S42463A', 'S42463B', 'S42463D', 'S42463G', 'S42463K', 'S42463P', 'S42463S', 'S42464A',
        'S42464B', 'S42464D', 'S42464G', 'S42464K', 'S42464P', 'S42464S', 'S42465A', 'S42465B',
        'S42465D', 'S42465G', 'S42465K', 'S42465P', 'S42465S', 'S42466A', 'S42466B', 'S42466D',
        'S42466G', 'S42466K', 'S42466P', 'S42466S', 'S42471A', 'S42471B', 'S42471D', 'S42471G',
        'S42471K', 'S42471P', 'S42471S', 'S42472A', 'S42472B', 'S42472D', 'S42472G', 'S42472K',
        'S42472P', 'S42472S', 'S42473A', 'S42473B', 'S42473D', 'S42473G', 'S42473K', 'S42473P',
        'S42473S', 'S42474A', 'S42474B', 'S42474D', 'S42474G', 'S42474K', 'S42474P', 'S42474S',
        'S42475A', 'S42475B', 'S42475D', 'S42475G', 'S42475K', 'S42475P', 'S42475S', 'S42476A',
        'S42476B', 'S42476D', 'S42476G', 'S42476K', 'S42476P', 'S42476S', 'S42481A', 'S42481D',
        'S42481G', 'S42481K', 'S42481P', 'S42481S', 'S42482A', 'S42482D', 'S42482G', 'S42482K',
        'S42482P', 'S42482S', 'S42489A', 'S42489D', 'S42489G', 'S42489K', 'S42489P', 'S42489S',
        'S42491A', 'S42491B', 'S42491D', 'S42491G', 'S42491K', 'S42491P', 'S42491S', 'S42492A',
        'S42492B', 'S42492D', 'S42492G', 'S42492K', 'S42492P', 'S42492S', 'S42493A', 'S42493B',
        'S42493D', 'S42493G', 'S42493K', 'S42493P', 'S42493S', 'S42494A', 'S42494B', 'S42494D',
        'S42494G', 'S42494K', 'S42494P', 'S42494S', 'S42495A', 'S42495B', 'S42495D', 'S42495G',
        'S42495K', 'S42495P', 'S42495S', 'S42496A', 'S42496B', 'S42496D', 'S42496G', 'S42496K',
        'S42496P', 'S42496S', 'S4290XA', 'S4290XB', 'S4290XD', 'S4290XG', 'S4290XK', 'S4290XP',
        'S4290XS', 'S4291XA', 'S4291XB', 'S4291XD', 'S4291XG', 'S4291XK', 'S4291XP', 'S4291XS',
        'S4292XA', 'S4292XB', 'S4292XD', 'S4292XG', 'S4292XK', 'S4292XP', 'S4292XS', 'S43004A',
        'S43004D', 'S43004S', 'S43005A', 'S43005D', 'S43005S', 'S43006A', 'S43006D', 'S43006S',
        'S43014A', 'S43014D', 'S43014S', 'S43015A', 'S43015D', 'S43015S', 'S43016A', 'S43016D',
        'S43016S', 'S43024A', 'S43024D', 'S43024S', 'S43025A', 'S43025D', 'S43025S', 'S43026A',
        'S43026D', 'S43026S', 'S43034A', 'S43034D', 'S43034S', 'S43035A', 'S43035D', 'S43035S',
        'S43036A', 'S43036D', 'S43036S', 'S43084A', 'S43084D', 'S43084S', 'S43085A', 'S43085D',
        'S43085S', 'S43086A', 'S43086D', 'S43086S', 'S43101A', 'S43101D', 'S43101S', 'S43102A',
        'S43102D', 'S43102S', 'S43109A', 'S43109D', 'S43109S', 'S43121A', 'S43121D', 'S43121S',
        'S43122A', 'S43122D', 'S43122S', 'S43129A', 'S43129D', 'S43129S', 'S43131A', 'S43131D',
        'S43131S', 'S43132A', 'S43132D', 'S43132S', 'S43139A', 'S43139D', 'S43139S', 'S43141A',
        'S43141D', 'S43141S', 'S43142A', 'S43142D', 'S43142S', 'S43149A', 'S43149D', 'S43149S',
        'S43151A', 'S43151D', 'S43151S', 'S43152A', 'S43152D', 'S43152S', 'S43159A', 'S43159D',
        'S43159S', 'S43204A', 'S43204D', 'S43204S', 'S43205A', 'S43205D', 'S43205S', 'S43206A',
        'S43206D', 'S43206S', 'S43214A', 'S43214D', 'S43214S', 'S43215A', 'S43215D', 'S43215S',
        'S43216A', 'S43216D', 'S43216S', 'S43224A', 'S43224D', 'S43224S', 'S43225A', 'S43225D',
        'S43225S', 'S43226A', 'S43226D', 'S43226S', 'S43304A', 'S43304D', 'S43304S', 'S43305A',
        'S43305D', 'S43305S', 'S43306A', 'S43306D', 'S43306S', 'S43314A', 'S43314D', 'S43314S',
        'S43315A', 'S43315D', 'S43315S', 'S43316A', 'S43316D', 'S43316S', 'S43394A', 'S43394D',
        'S43394S', 'S43395A', 'S43395D', 'S43395S', 'S43396A', 'S43396D', 'S43396S', 'S49001A',
        'S49001D', 'S49001G', 'S49001K', 'S49001P', 'S49001S', 'S49002A', 'S49002D', 'S49002G',
        'S49002K', 'S49002P', 'S49002S', 'S49009A', 'S49009D', 'S49009G', 'S49009K', 'S49009P',
        'S49009S', 'S49011A', 'S49011D', 'S49011G', 'S49011K', 'S49011P', 'S49011S', 'S49012A',
        'S49012D', 'S49012G', 'S49012K', 'S49012P', 'S49012S', 'S49019A', 'S49019D', 'S49019G',
        'S49019K', 'S49019P', 'S49019S', 'S49021A', 'S49021D', 'S49021G', 'S49021K', 'S49021P',
        'S49021S', 'S49022A', 'S49022D', 'S49022G', 'S49022K', 'S49022P', 'S49022S', 'S49029A',
        'S49029D', 'S49029G', 'S49029K', 'S49029P', 'S49029S', 'S49031A', 'S49031D', 'S49031G',
        'S49031K', 'S49031P', 'S49031S', 'S49032A', 'S49032D', 'S49032G', 'S49032K', 'S49032P',
        'S49032S', 'S49039A', 'S49039D', 'S49039G', 'S49039K', 'S49039P', 'S49039S', 'S49041A',
        'S49041D', 'S49041G', 'S49041K', 'S49041P', 'S49041S', 'S49042A', 'S49042D', 'S49042G',
        'S49042K', 'S49042P', 'S49042S', 'S49049A', 'S49049D', 'S49049G', 'S49049K', 'S49049P',
        'S49049S', 'S49091A', 'S49091D', 'S49091G', 'S49091K', 'S49091P', 'S49091S', 'S49092A',
        'S49092D', 'S49092G', 'S49092K', 'S49092P', 'S49092S', 'S49099A', 'S49099D', 'S49099G',
        'S49099K', 'S49099P', 'S49099S', 'S49101A', 'S49101D', 'S49101G', 'S49101K', 'S49101P',
        'S49101S', 'S49102A', 'S49102D', 'S49102G', 'S49102K', 'S49102P', 'S49102S', 'S49109A',
        'S49109D', 'S49109G', 'S49109K', 'S49109P', 'S49109S', 'S49111A', 'S49111D', 'S49111G',
        'S49111K', 'S49111P', 'S49111S', 'S49112A', 'S49112D', 'S49112G', 'S49112K', 'S49112P',
        'S49112S', 'S49119A', 'S49119D', 'S49119G', 'S49119K', 'S49119P', 'S49119S', 'S49121A',
        'S49121D', 'S49121G', 'S49121K', 'S49121P', 'S49121S', 'S49122A', 'S49122D', 'S49122G',
        'S49122K', 'S49122P', 'S49122S', 'S49129A', 'S49129D', 'S49129G', 'S49129K', 'S49129P',
        'S49129S', 'S49131A', 'S49131D', 'S49131G', 'S49131K', 'S49131P', 'S49131S', 'S49132A',
        'S49132D', 'S49132G', 'S49132K', 'S49132P', 'S49132S', 'S49139A', 'S49139D', 'S49139G',
        'S49139K', 'S49139P', 'S49139S', 'S49141A', 'S49141D', 'S49141G', 'S49141K', 'S49141P',
        'S49141S', 'S49142A', 'S49142D', 'S49142G', 'S49142K', 'S49142P', 'S49142S', 'S49149A',
        'S49149D', 'S49149G', 'S49149K', 'S49149P', 'S49149S', 'S49191A', 'S49191D', 'S49191G',
        'S49191K', 'S49191P', 'S49191S', 'S49192A', 'S49192D', 'S49192G', 'S49192K', 'S49192P',
        'S49192S', 'S49199A', 'S49199D', 'S49199G', 'S49199K', 'S49199P', 'S49199S', 'S52001A',
        'S52001B', 'S52001C', 'S52001D', 'S52001E', 'S52001F', 'S52001G', 'S52001H', 'S52001J',
        'S52001K', 'S52001M', 'S52001N', 'S52001P', 'S52001Q', 'S52001R', 'S52001S', 'S52002A',
        'S52002B', 'S52002C', 'S52002D', 'S52002E', 'S52002F', 'S52002G', 'S52002H', 'S52002J',
        'S52002K', 'S52002M', 'S52002N', 'S52002P', 'S52002Q', 'S52002R', 'S52002S', 'S52009A',
        'S52009B', 'S52009C', 'S52009D', 'S52009E', 'S52009F', 'S52009G', 'S52009H', 'S52009J',
        'S52009K', 'S52009M', 'S52009N', 'S52009P', 'S52009Q', 'S52009R', 'S52009S', 'S52011A',
        'S52011D', 'S52011G', 'S52011K', 'S52011P', 'S52011S', 'S52012A', 'S52012D', 'S52012G',
        'S52012K', 'S52012P', 'S52012S', 'S52019A', 'S52019D', 'S52019G', 'S52019K', 'S52019P',
        'S52019S', 'S52021A', 'S52021B', 'S52021C', 'S52021D', 'S52021E', 'S52021F', 'S52021G',
        'S52021H', 'S52021J', 'S52021K', 'S52021M', 'S52021N', 'S52021P', 'S52021Q', 'S52021R',
        'S52021S', 'S52022A', 'S52022B', 'S52022C', 'S52022D', 'S52022E', 'S52022F', 'S52022G',
        'S52022H', 'S52022J', 'S52022K', 'S52022M', 'S52022N', 'S52022P', 'S52022Q', 'S52022R',
        'S52022S', 'S52023A', 'S52023B', 'S52023C', 'S52023D', 'S52023E', 'S52023F', 'S52023G',
        'S52023H', 'S52023J', 'S52023K', 'S52023M', 'S52023N', 'S52023P', 'S52023Q', 'S52023R',
        'S52023S', 'S52024A', 'S52024B', 'S52024C', 'S52024D', 'S52024E', 'S52024F', 'S52024G',
        'S52024H', 'S52024J', 'S52024K', 'S52024M', 'S52024N', 'S52024P', 'S52024Q', 'S52024R',
        'S52024S', 'S52025A', 'S52025B', 'S52025C', 'S52025D', 'S52025E', 'S52025F', 'S52025G',
        'S52025H', 'S52025J', 'S52025K', 'S52025M', 'S52025N', 'S52025P', 'S52025Q', 'S52025R',
        'S52025S', 'S52026A', 'S52026B', 'S52026C', 'S52026D', 'S52026E', 'S52026F', 'S52026G',
        'S52026H', 'S52026J', 'S52026K', 'S52026M', 'S52026N', 'S52026P', 'S52026Q', 'S52026R',
        'S52026S', 'S52031A', 'S52031B', 'S52031C', 'S52031D', 'S52031E', 'S52031F', 'S52031G',
        'S52031H', 'S52031J', 'S52031K', 'S52031M', 'S52031N', 'S52031P', 'S52031Q', 'S52031R',
        'S52031S', 'S52032A', 'S52032B', 'S52032C', 'S52032D', 'S52032E', 'S52032F', 'S52032G',
        'S52032H', 'S52032J', 'S52032K', 'S52032M', 'S52032N', 'S52032P', 'S52032Q', 'S52032R',
        'S52032S', 'S52033A', 'S52033B', 'S52033C', 'S52033D', 'S52033E', 'S52033F', 'S52033G',
        'S52033H', 'S52033J', 'S52033K', 'S52033M', 'S52033N', 'S52033P', 'S52033Q', 'S52033R',
        'S52033S', 'S52034A', 'S52034B', 'S52034C', 'S52034D', 'S52034E', 'S52034F', 'S52034G',
        'S52034H', 'S52034J', 'S52034K', 'S52034M', 'S52034N', 'S52034P', 'S52034Q', 'S52034R',
        'S52034S', 'S52035A', 'S52035B', 'S52035C', 'S52035D', 'S52035E', 'S52035F', 'S52035G',
        'S52035H', 'S52035J', 'S52035K', 'S52035M', 'S52035N', 'S52035P', 'S52035Q', 'S52035R',
        'S52035S', 'S52036A', 'S52036B', 'S52036C', 'S52036D', 'S52036E', 'S52036F', 'S52036G',
        'S52036H', 'S52036J', 'S52036K', 'S52036M', 'S52036N', 'S52036P', 'S52036Q', 'S52036R',
        'S52036S', 'S52041A', 'S52041B', 'S52041C', 'S52041D', 'S52041E', 'S52041F', 'S52041G',
        'S52041H', 'S52041J', 'S52041K', 'S52041M', 'S52041N', 'S52041P', 'S52041Q', 'S52041R',
        'S52041S', 'S52042A', 'S52042B', 'S52042C', 'S52042D', 'S52042E', 'S52042F', 'S52042G',
        'S52042H', 'S52042J', 'S52042K', 'S52042M', 'S52042N', 'S52042P', 'S52042Q', 'S52042R',
        'S52042S', 'S52043A', 'S52043B', 'S52043C', 'S52043D', 'S52043E', 'S52043F', 'S52043G',
        'S52043H', 'S52043J', 'S52043K', 'S52043M', 'S52043N', 'S52043P', 'S52043Q', 'S52043R',
        'S52043S', 'S52044A', 'S52044B', 'S52044C', 'S52044D', 'S52044E', 'S52044F', 'S52044G',
        'S52044H', 'S52044J', 'S52044K', 'S52044M', 'S52044N', 'S52044P', 'S52044Q', 'S52044R',
        'S52044S', 'S52045A', 'S52045B', 'S52045C', 'S52045D', 'S52045E', 'S52045F', 'S52045G',
        'S52045H', 'S52045J', 'S52045K', 'S52045M', 'S52045N', 'S52045P', 'S52045Q', 'S52045R',
        'S52045S', 'S52046A', 'S52046B', 'S52046C', 'S52046D', 'S52046E', 'S52046F', 'S52046G',
        'S52046H', 'S52046J', 'S52046K', 'S52046M', 'S52046N', 'S52046P', 'S52046Q', 'S52046R',
        'S52046S', 'S52091A', 'S52091B', 'S52091C', 'S52091D', 'S52091E', 'S52091F', 'S52091G',
        'S52091H', 'S52091J', 'S52091K', 'S52091M', 'S52091N', 'S52091P', 'S52091Q', 'S52091R',
        'S52091S', 'S52092A', 'S52092B', 'S52092C', 'S52092D', 'S52092E', 'S52092F', 'S52092G',
        'S52092H', 'S52092J', 'S52092K', 'S52092M', 'S52092N', 'S52092P', 'S52092Q', 'S52092R',
        'S52092S', 'S52099A', 'S52099B', 'S52099C', 'S52099D', 'S52099E', 'S52099F', 'S52099G',
        'S52099H', 'S52099J', 'S52099K', 'S52099M', 'S52099N', 'S52099P', 'S52099Q', 'S52099R',
        'S52099S', 'S52101A', 'S52101B', 'S52101C', 'S52101D', 'S52101E', 'S52101F', 'S52101G',
        'S52101H', 'S52101J', 'S52101K', 'S52101M', 'S52101N', 'S52101P', 'S52101Q', 'S52101R',
        'S52101S', 'S52102A', 'S52102B', 'S52102C', 'S52102D', 'S52102E', 'S52102F', 'S52102G',
        'S52102H', 'S52102J', 'S52102K', 'S52102M', 'S52102N', 'S52102P', 'S52102Q', 'S52102R',
        'S52102S', 'S52109A', 'S52109B', 'S52109C', 'S52109D', 'S52109E', 'S52109F', 'S52109G',
        'S52109H', 'S52109J', 'S52109K', 'S52109M', 'S52109N', 'S52109P', 'S52109Q', 'S52109R',
        'S52109S', 'S52111A', 'S52111D', 'S52111G', 'S52111K', 'S52111P', 'S52111S', 'S52112A',
        'S52112D', 'S52112G', 'S52112K', 'S52112P', 'S52112S', 'S52119A', 'S52119D', 'S52119G',
        'S52119K', 'S52119P', 'S52119S', 'S52121A', 'S52121B', 'S52121C', 'S52121D', 'S52121E',
        'S52121F', 'S52121G', 'S52121H', 'S52121J', 'S52121K', 'S52121M', 'S52121N', 'S52121P',
        'S52121Q', 'S52121R', 'S52121S', 'S52122A', 'S52122B', 'S52122C', 'S52122D', 'S52122E',
        'S52122F', 'S52122G', 'S52122H', 'S52122J', 'S52122K', 'S52122M', 'S52122N', 'S52122P',
        'S52122Q', 'S52122R', 'S52122S', 'S52123A', 'S52123B', 'S52123C', 'S52123D', 'S52123E',
        'S52123F', 'S52123G', 'S52123H', 'S52123J', 'S52123K', 'S52123M', 'S52123N', 'S52123P',
        'S52123Q', 'S52123R', 'S52123S', 'S52124A', 'S52124B', 'S52124C', 'S52124D', 'S52124E',
        'S52124F', 'S52124G', 'S52124H', 'S52124J', 'S52124K', 'S52124M', 'S52124N', 'S52124P',
        'S52124Q', 'S52124R', 'S52124S', 'S52125A', 'S52125B', 'S52125C', 'S52125D', 'S52125E',
        'S52125F', 'S52125G', 'S52125H', 'S52125J', 'S52125K', 'S52125M', 'S52125N', 'S52125P',
        'S52125Q', 'S52125R', 'S52125S', 'S52126A', 'S52126B', 'S52126C', 'S52126D', 'S52126E',
        'S52126F', 'S52126G', 'S52126H', 'S52126J', 'S52126K', 'S52126M', 'S52126N', 'S52126P',
        'S52126Q', 'S52126R', 'S52126S', 'S52131A', 'S52131B', 'S52131C', 'S52131D', 'S52131E',
        'S52131F', 'S52131G', 'S52131H', 'S52131J', 'S52131K', 'S52131M', 'S52131N', 'S52131P',
        'S52131Q', 'S52131R', 'S52131S', 'S52132A', 'S52132B', 'S52132C', 'S52132D', 'S52132E',
        'S52132F', 'S52132G', 'S52132H', 'S52132J', 'S52132K', 'S52132M', 'S52132N', 'S52132P',
        'S52132Q', 'S52132R', 'S52132S', 'S52133A', 'S52133B', 'S52133C', 'S52133D', 'S52133E',
        'S52133F', 'S52133G', 'S52133H', 'S52133J', 'S52133K', 'S52133M', 'S52133N', 'S52133P',
        'S52133Q', 'S52133R', 'S52133S', 'S52134A', 'S52134B', 'S52134C', 'S52134D', 'S52134E',
        'S52134F', 'S52134G', 'S52134H', 'S52134J', 'S52134K', 'S52134M', 'S52134N', 'S52134P',
        'S52134Q', 'S52134R', 'S52134S', 'S52135A', 'S52135B', 'S52135C', 'S52135D', 'S52135E',
        'S52135F', 'S52135G', 'S52135H', 'S52135J', 'S52135K', 'S52135M', 'S52135N', 'S52135P',
        'S52135Q', 'S52135R', 'S52135S', 'S52136A', 'S52136B', 'S52136C', 'S52136D', 'S52136E',
        'S52136F', 'S52136G', 'S52136H', 'S52136J', 'S52136K', 'S52136M', 'S52136N', 'S52136P',
        'S52136Q', 'S52136R', 'S52136S', 'S52181A', 'S52181B', 'S52181C', 'S52181D', 'S52181E',
        'S52181F', 'S52181G', 'S52181H', 'S52181J', 'S52181K', 'S52181M', 'S52181N', 'S52181P',
        'S52181Q', 'S52181R', 'S52181S', 'S52182A', 'S52182B', 'S52182C', 'S52182D', 'S52182E',
        'S52182F', 'S52182G', 'S52182H', 'S52182J', 'S52182K', 'S52182M', 'S52182N', 'S52182P',
        'S52182Q', 'S52182R', 'S52182S', 'S52189A', 'S52189B', 'S52189C', 'S52189D', 'S52189E',
        'S52189F', 'S52189G', 'S52189H', 'S52189J', 'S52189K', 'S52189M', 'S52189N', 'S52189P',
        'S52189Q', 'S52189R', 'S52189S', 'S52201A', 'S52201B', 'S52201C', 'S52201D', 'S52201E',
        'S52201F', 'S52201G', 'S52201H', 'S52201J', 'S52201K', 'S52201M', 'S52201N', 'S52201P',
        'S52201Q', 'S52201R', 'S52201S', 'S52202A', 'S52202B', 'S52202C', 'S52202D', 'S52202E',
        'S52202F', 'S52202G', 'S52202H', 'S52202J', 'S52202K', 'S52202M', 'S52202N', 'S52202P',
        'S52202Q', 'S52202R', 'S52202S', 'S52209A', 'S52209B', 'S52209C', 'S52209D', 'S52209E',
        'S52209F', 'S52209G', 'S52209H', 'S52209J', 'S52209K', 'S52209M', 'S52209N', 'S52209P',
        'S52209Q', 'S52209R', 'S52209S', 'S52211A', 'S52211D', 'S52211G', 'S52211K', 'S52211P',
        'S52211S', 'S52212A', 'S52212D', 'S52212G', 'S52212K', 'S52212P', 'S52212S', 'S52219A',
        'S52219D', 'S52219G', 'S52219K', 'S52219P', 'S52219S', 'S52221A', 'S52221B', 'S52221C',
        'S52221D', 'S52221E', 'S52221F', 'S52221G', 'S52221H', 'S52221J', 'S52221K', 'S52221M',
        'S52221N', 'S52221P', 'S52221Q', 'S52221R', 'S52221S', 'S52222A', 'S52222B', 'S52222C',
        'S52222D', 'S52222E', 'S52222F', 'S52222G', 'S52222H', 'S52222J', 'S52222K', 'S52222M',
        'S52222N', 'S52222P', 'S52222Q', 'S52222R', 'S52222S', 'S52223A', 'S52223B', 'S52223C',
        'S52223D', 'S52223E', 'S52223F', 'S52223G', 'S52223H', 'S52223J', 'S52223K', 'S52223M',
        'S52223N', 'S52223P', 'S52223Q', 'S52223R', 'S52223S', 'S52224A', 'S52224B', 'S52224C',
        'S52224D', 'S52224E', 'S52224F', 'S52224G', 'S52224H', 'S52224J', 'S52224K', 'S52224M',
        'S52224N', 'S52224P', 'S52224Q', 'S52224R', 'S52224S', 'S52225A', 'S52225B', 'S52225C',
        'S52225D', 'S52225E', 'S52225F', 'S52225G', 'S52225H', 'S52225J', 'S52225K', 'S52225M',
        'S52225N', 'S52225P', 'S52225Q', 'S52225R', 'S52225S', 'S52226A', 'S52226B', 'S52226C',
        'S52226D', 'S52226E', 'S52226F', 'S52226G', 'S52226H', 'S52226J', 'S52226K', 'S52226M',
        'S52226N', 'S52226P', 'S52226Q', 'S52226R', 'S52226S', 'S52231A', 'S52231B', 'S52231C',
        'S52231D', 'S52231E', 'S52231F', 'S52231G', 'S52231H', 'S52231J', 'S52231K', 'S52231M',
        'S52231N', 'S52231P', 'S52231Q', 'S52231R', 'S52231S', 'S52232A', 'S52232B', 'S52232C',
        'S52232D', 'S52232E', 'S52232F', 'S52232G', 'S52232H', 'S52232J', 'S52232K', 'S52232M',
        'S52232N', 'S52232P', 'S52232Q', 'S52232R', 'S52232S', 'S52233A', 'S52233B', 'S52233C',
        'S52233D', 'S52233E', 'S52233F', 'S52233G', 'S52233H', 'S52233J', 'S52233K', 'S52233M',
        'S52233N', 'S52233P', 'S52233Q', 'S52233R', 'S52233S', 'S52234A', 'S52234B', 'S52234C',
        'S52234D', 'S52234E', 'S52234F', 'S52234G', 'S52234H', 'S52234J', 'S52234K', 'S52234M',
        'S52234N', 'S52234P', 'S52234Q', 'S52234R', 'S52234S', 'S52235A', 'S52235B', 'S52235C',
        'S52235D', 'S52235E', 'S52235F', 'S52235G', 'S52235H', 'S52235J', 'S52235K', 'S52235M',
        'S52235N', 'S52235P', 'S52235Q', 'S52235R', 'S52235S', 'S52236A', 'S52236B', 'S52236C',
        'S52236D', 'S52236E', 'S52236F', 'S52236G', 'S52236H', 'S52236J', 'S52236K', 'S52236M',
        'S52236N', 'S52236P', 'S52236Q', 'S52236R', 'S52236S', 'S52241A', 'S52241B', 'S52241C',
        'S52241D', 'S52241E', 'S52241F', 'S52241G', 'S52241H', 'S52241J', 'S52241K', 'S52241M',
        'S52241N', 'S52241P', 'S52241Q', 'S52241R', 'S52241S', 'S52242A', 'S52242B', 'S52242C',
        'S52242D', 'S52242E', 'S52242F', 'S52242G', 'S52242H', 'S52242J', 'S52242K', 'S52242M',
        'S52242N', 'S52242P', 'S52242Q', 'S52242R', 'S52242S', 'S52243A', 'S52243B', 'S52243C',
        'S52243D', 'S52243E', 'S52243F', 'S52243G', 'S52243H', 'S52243J', 'S52243K', 'S52243M',
        'S52243N', 'S52243P', 'S52243Q', 'S52243R', 'S52243S', 'S52244A', 'S52244B', 'S52244C',
        'S52244D', 'S52244E', 'S52244F', 'S52244G', 'S52244H', 'S52244J', 'S52244K', 'S52244M',
        'S52244N', 'S52244P', 'S52244Q', 'S52244R', 'S52244S', 'S52245A', 'S52245B', 'S52245C',
        'S52245D', 'S52245E', 'S52245F', 'S52245G', 'S52245H', 'S52245J', 'S52245K', 'S52245M',
        'S52245N', 'S52245P', 'S52245Q', 'S52245R', 'S52245S', 'S52246A', 'S52246B', 'S52246C',
        'S52246D', 'S52246E', 'S52246F', 'S52246G', 'S52246H', 'S52246J', 'S52246K', 'S52246M',
        'S52246N', 'S52246P', 'S52246Q', 'S52246R', 'S52246S', 'S52251A', 'S52251B', 'S52251C',
        'S52251D', 'S52251E', 'S52251F', 'S52251G', 'S52251H', 'S52251J', 'S52251K', 'S52251M',
        'S52251N', 'S52251P', 'S52251Q', 'S52251R', 'S52251S', 'S52252A', 'S52252B', 'S52252C',
        'S52252D', 'S52252E', 'S52252F', 'S52252G', 'S52252H', 'S52252J', 'S52252K', 'S52252M',
        'S52252N', 'S52252P', 'S52252Q', 'S52252R', 'S52252S', 'S52253A', 'S52253B', 'S52253C',
        'S52253D', 'S52253E', 'S52253F', 'S52253G', 'S52253H', 'S52253J', 'S52253K', 'S52253M',
        'S52253N', 'S52253P', 'S52253Q', 'S52253R', 'S52253S', 'S52254A', 'S52254B', 'S52254C',
        'S52254D', 'S52254E', 'S52254F', 'S52254G', 'S52254H', 'S52254J', 'S52254K', 'S52254M',
        'S52254N', 'S52254P', 'S52254Q', 'S52254R', 'S52254S', 'S52255A', 'S52255B', 'S52255C',
        'S52255D', 'S52255E', 'S52255F', 'S52255G', 'S52255H', 'S52255J', 'S52255K', 'S52255M',
        'S52255N', 'S52255P', 'S52255Q', 'S52255R', 'S52255S', 'S52256A', 'S52256B', 'S52256C',
        'S52256D', 'S52256E', 'S52256F', 'S52256G', 'S52256H', 'S52256J', 'S52256K', 'S52256M',
        'S52256N', 'S52256P', 'S52256Q', 'S52256R', 'S52256S', 'S52261A', 'S52261B', 'S52261C',
        'S52261D', 'S52261E', 'S52261F', 'S52261G', 'S52261H', 'S52261J', 'S52261K', 'S52261M',
        'S52261N', 'S52261P', 'S52261Q', 'S52261R', 'S52261S', 'S52262A', 'S52262B', 'S52262C',
        'S52262D', 'S52262E', 'S52262F', 'S52262G', 'S52262H', 'S52262J', 'S52262K', 'S52262M',
        'S52262N', 'S52262P', 'S52262Q', 'S52262R', 'S52262S', 'S52263A', 'S52263B', 'S52263C',
        'S52263D', 'S52263E', 'S52263F', 'S52263G', 'S52263H', 'S52263J', 'S52263K', 'S52263M',
        'S52263N', 'S52263P', 'S52263Q', 'S52263R', 'S52263S', 'S52264A', 'S52264B', 'S52264C',
        'S52264D', 'S52264E', 'S52264F', 'S52264G', 'S52264H', 'S52264J', 'S52264K', 'S52264M',
        'S52264N', 'S52264P', 'S52264Q', 'S52264R', 'S52264S', 'S52265A', 'S52265B', 'S52265C',
        'S52265D', 'S52265E', 'S52265F', 'S52265G', 'S52265H', 'S52265J', 'S52265K', 'S52265M',
        'S52265N', 'S52265P', 'S52265Q', 'S52265R', 'S52265S', 'S52266A', 'S52266B', 'S52266C',
        'S52266D', 'S52266E', 'S52266F', 'S52266G', 'S52266H', 'S52266J', 'S52266K', 'S52266M',
        'S52266N', 'S52266P', 'S52266Q', 'S52266R', 'S52266S', 'S52271A', 'S52271B', 'S52271C',
        'S52271D', 'S52271E', 'S52271F', 'S52271G', 'S52271H', 'S52271J', 'S52271K', 'S52271M',
        'S52271N', 'S52271P', 'S52271Q', 'S52271R', 'S52271S', 'S52272A', 'S52272B', 'S52272C',
        'S52272D', 'S52272E', 'S52272F', 'S52272G', 'S52272H', 'S52272J', 'S52272K', 'S52272M',
        'S52272N', 'S52272P', 'S52272Q', 'S52272R', 'S52272S', 'S52279A', 'S52279B', 'S52279C',
        'S52279D', 'S52279E', 'S52279F', 'S52279G', 'S52279H', 'S52279J', 'S52279K', 'S52279M',
        'S52279N', 'S52279P', 'S52279Q', 'S52279R', 'S52279S', 'S52281A', 'S52281B', 'S52281C',
        'S52281D', 'S52281E', 'S52281F', 'S52281G', 'S52281H', 'S52281J', 'S52281K', 'S52281M',
        'S52281N', 'S52281P', 'S52281Q', 'S52281R', 'S52281S', 'S52282A', 'S52282B', 'S52282C',
        'S52282D', 'S52282E', 'S52282F', 'S52282G', 'S52282H', 'S52282J', 'S52282K', 'S52282M',
        'S52282N', 'S52282P', 'S52282Q', 'S52282R', 'S52282S', 'S52283A', 'S52283B', 'S52283C',
        'S52283D', 'S52283E', 'S52283F', 'S52283G', 'S52283H', 'S52283J', 'S52283K', 'S52283M',
        'S52283N', 'S52283P', 'S52283Q', 'S52283R', 'S52283S', 'S52291A', 'S52291B', 'S52291C',
        'S52291D', 'S52291E', 'S52291F', 'S52291G', 'S52291H', 'S52291J', 'S52291K', 'S52291M',
        'S52291N', 'S52291P', 'S52291Q', 'S52291R', 'S52291S', 'S52292A', 'S52292B', 'S52292C',
        'S52292D', 'S52292E', 'S52292F', 'S52292G', 'S52292H', 'S52292J', 'S52292K', 'S52292M',
        'S52292N', 'S52292P', 'S52292Q', 'S52292R', 'S52292S', 'S52299A', 'S52299B', 'S52299C',
        'S52299D', 'S52299E', 'S52299F', 'S52299G', 'S52299H', 'S52299J', 'S52299K', 'S52299M',
        'S52299N', 'S52299P', 'S52299Q', 'S52299R', 'S52299S', 'S52301A', 'S52301B', 'S52301C',
        'S52301D', 'S52301E', 'S52301F', 'S52301G', 'S52301H', 'S52301J', 'S52301K', 'S52301M',
        'S52301N', 'S52301P', 'S52301Q', 'S52301R', 'S52301S', 'S52302A', 'S52302B', 'S52302C',
        'S52302D', 'S52302E', 'S52302F', 'S52302G', 'S52302H', 'S52302J', 'S52302K', 'S52302M',
        'S52302N', 'S52302P', 'S52302Q', 'S52302R', 'S52302S', 'S52309A', 'S52309B', 'S52309C',
        'S52309D', 'S52309E', 'S52309F', 'S52309G', 'S52309H', 'S52309J', 'S52309K', 'S52309M',
        'S52309N', 'S52309P', 'S52309Q', 'S52309R', 'S52309S', 'S52311A', 'S52311D', 'S52311G',
        'S52311K', 'S52311P', 'S52311S', 'S52312A', 'S52312D', 'S52312G', 'S52312K', 'S52312P',
        'S52312S', 'S52319A', 'S52319D', 'S52319G', 'S52319K', 'S52319P', 'S52319S', 'S52321A',
        'S52321B', 'S52321C', 'S52321D', 'S52321E', 'S52321F', 'S52321G', 'S52321H', 'S52321J',
        'S52321K', 'S52321M', 'S52321N', 'S52321P', 'S52321Q', 'S52321R', 'S52321S', 'S52322A',
        'S52322B', 'S52322C', 'S52322D', 'S52322E', 'S52322F', 'S52322G', 'S52322H', 'S52322J',
        'S52322K', 'S52322M', 'S52322N', 'S52322P', 'S52322Q', 'S52322R', 'S52322S', 'S52323A',
        'S52323B', 'S52323C', 'S52323D', 'S52323E', 'S52323F', 'S52323G', 'S52323H', 'S52323J',
        'S52323K', 'S52323M', 'S52323N', 'S52323P', 'S52323Q', 'S52323R', 'S52323S', 'S52324A',
        'S52324B', 'S52324C', 'S52324D', 'S52324E', 'S52324F', 'S52324G', 'S52324H', 'S52324J',
        'S52324K', 'S52324M', 'S52324N', 'S52324P', 'S52324Q', 'S52324R', 'S52324S', 'S52325A',
        'S52325B', 'S52325C', 'S52325D', 'S52325E', 'S52325F', 'S52325G', 'S52325H', 'S52325J',
        'S52325K', 'S52325M', 'S52325N', 'S52325P', 'S52325Q', 'S52325R', 'S52325S', 'S52326A',
        'S52326B', 'S52326C', 'S52326D', 'S52326E', 'S52326F', 'S52326G', 'S52326H', 'S52326J',
        'S52326K', 'S52326M', 'S52326N', 'S52326P', 'S52326Q', 'S52326R', 'S52326S', 'S52331A',
        'S52331B', 'S52331C', 'S52331D', 'S52331E', 'S52331F', 'S52331G', 'S52331H', 'S52331J',
        'S52331K', 'S52331M', 'S52331N', 'S52331P', 'S52331Q', 'S52331R', 'S52331S', 'S52332A',
        'S52332B', 'S52332C', 'S52332D', 'S52332E', 'S52332F', 'S52332G', 'S52332H', 'S52332J',
        'S52332K', 'S52332M', 'S52332N', 'S52332P', 'S52332Q', 'S52332R', 'S52332S', 'S52333A',
        'S52333B', 'S52333C', 'S52333D', 'S52333E', 'S52333F', 'S52333G', 'S52333H', 'S52333J',
        'S52333K', 'S52333M', 'S52333N', 'S52333P', 'S52333Q', 'S52333R', 'S52333S', 'S52334A',
        'S52334B', 'S52334C', 'S52334D', 'S52334E', 'S52334F', 'S52334G', 'S52334H', 'S52334J',
        'S52334K', 'S52334M', 'S52334N', 'S52334P', 'S52334Q', 'S52334R', 'S52334S', 'S52335A',
        'S52335B', 'S52335C', 'S52335D', 'S52335E', 'S52335F', 'S52335G', 'S52335H', 'S52335J',
        'S52335K', 'S52335M', 'S52335N', 'S52335P', 'S52335Q', 'S52335R', 'S52335S', 'S52336A',
        'S52336B', 'S52336C', 'S52336D', 'S52336E', 'S52336F', 'S52336G', 'S52336H', 'S52336J',
        'S52336K', 'S52336M', 'S52336N', 'S52336P', 'S52336Q', 'S52336R', 'S52336S', 'S52341A',
        'S52341B', 'S52341C', 'S52341D', 'S52341E', 'S52341F', 'S52341G', 'S52341H', 'S52341J',
        'S52341K', 'S52341M', 'S52341N', 'S52341P', 'S52341Q', 'S52341R', 'S52341S', 'S52342A',
        'S52342B', 'S52342C', 'S52342D', 'S52342E', 'S52342F', 'S52342G', 'S52342H', 'S52342J',
        'S52342K', 'S52342M', 'S52342N', 'S52342P', 'S52342Q', 'S52342R', 'S52342S', 'S52343A',
        'S52343B', 'S52343C', 'S52343D', 'S52343E', 'S52343F', 'S52343G', 'S52343H', 'S52343J',
        'S52343K', 'S52343M', 'S52343N', 'S52343P', 'S52343Q', 'S52343R', 'S52343S', 'S52344A',
        'S52344B', 'S52344C', 'S52344D', 'S52344E', 'S52344F', 'S52344G', 'S52344H', 'S52344J',
        'S52344K', 'S52344M', 'S52344N', 'S52344P', 'S52344Q', 'S52344R', 'S52344S', 'S52345A',
        'S52345B', 'S52345C', 'S52345D', 'S52345E', 'S52345F', 'S52345G', 'S52345H', 'S52345J',
        'S52345K', 'S52345M', 'S52345N', 'S52345P', 'S52345Q', 'S52345R', 'S52345S', 'S52346A',
        'S52346B', 'S52346C', 'S52346D', 'S52346E', 'S52346F', 'S52346G', 'S52346H', 'S52346J',
        'S52346K', 'S52346M', 'S52346N', 'S52346P', 'S52346Q', 'S52346R', 'S52346S', 'S52351A',
        'S52351B', 'S52351C', 'S52351D', 'S52351E', 'S52351F', 'S52351G', 'S52351H', 'S52351J',
        'S52351K', 'S52351M', 'S52351N', 'S52351P', 'S52351Q', 'S52351R', 'S52351S', 'S52352A',
        'S52352B', 'S52352C', 'S52352D', 'S52352E', 'S52352F', 'S52352G', 'S52352H', 'S52352J',
        'S52352K', 'S52352M', 'S52352N', 'S52352P', 'S52352Q', 'S52352R', 'S52352S', 'S52353A',
        'S52353B', 'S52353C', 'S52353D', 'S52353E', 'S52353F', 'S52353G', 'S52353H', 'S52353J',
        'S52353K', 'S52353M', 'S52353N', 'S52353P', 'S52353Q', 'S52353R', 'S52353S', 'S52354A',
        'S52354B', 'S52354C', 'S52354D', 'S52354E', 'S52354F', 'S52354G', 'S52354H', 'S52354J',
        'S52354K', 'S52354M', 'S52354N', 'S52354P', 'S52354Q', 'S52354R', 'S52354S', 'S52355A',
        'S52355B', 'S52355C', 'S52355D', 'S52355E', 'S52355F', 'S52355G', 'S52355H', 'S52355J',
        'S52355K', 'S52355M', 'S52355N', 'S52355P', 'S52355Q', 'S52355R', 'S52355S', 'S52356A',
        'S52356B', 'S52356C', 'S52356D', 'S52356E', 'S52356F', 'S52356G', 'S52356H', 'S52356J',
        'S52356K', 'S52356M', 'S52356N', 'S52356P', 'S52356Q', 'S52356R', 'S52356S', 'S52361A',
        'S52361B', 'S52361C', 'S52361D', 'S52361E', 'S52361F', 'S52361G', 'S52361H', 'S52361J',
        'S52361K', 'S52361M', 'S52361N', 'S52361P', 'S52361Q', 'S52361R', 'S52361S', 'S52362A',
        'S52362B', 'S52362C', 'S52362D', 'S52362E', 'S52362F', 'S52362G', 'S52362H', 'S52362J',
        'S52362K', 'S52362M', 'S52362N', 'S52362P', 'S52362Q', 'S52362R', 'S52362S', 'S52363A',
        'S52363B', 'S52363C', 'S52363D', 'S52363E', 'S52363F', 'S52363G', 'S52363H', 'S52363J',
        'S52363K', 'S52363M', 'S52363N', 'S52363P', 'S52363Q', 'S52363R', 'S52363S', 'S52364A',
        'S52364B', 'S52364C', 'S52364D', 'S52364E', 'S52364F', 'S52364G', 'S52364H', 'S52364J',
        'S52364K', 'S52364M', 'S52364N', 'S52364P', 'S52364Q', 'S52364R', 'S52364S', 'S52365A',
        'S52365B', 'S52365C', 'S52365D', 'S52365E', 'S52365F', 'S52365G', 'S52365H', 'S52365J',
        'S52365K', 'S52365M', 'S52365N', 'S52365P', 'S52365Q', 'S52365R', 'S52365S', 'S52366A',
        'S52366B', 'S52366C', 'S52366D', 'S52366E', 'S52366F', 'S52366G', 'S52366H', 'S52366J',
        'S52366K', 'S52366M', 'S52366N', 'S52366P', 'S52366Q', 'S52366R', 'S52366S', 'S52371A',
        'S52371B', 'S52371C', 'S52371D', 'S52371E', 'S52371F', 'S52371G', 'S52371H', 'S52371J',
        'S52371K', 'S52371M', 'S52371N', 'S52371P', 'S52371Q', 'S52371R', 'S52371S', 'S52372A',
        'S52372B', 'S52372C', 'S52372D', 'S52372E', 'S52372F', 'S52372G', 'S52372H', 'S52372J',
        'S52372K', 'S52372M', 'S52372N', 'S52372P', 'S52372Q', 'S52372R', 'S52372S', 'S52379A',
        'S52379B', 'S52379C', 'S52379D', 'S52379E', 'S52379F', 'S52379G', 'S52379H', 'S52379J',
        'S52379K', 'S52379M', 'S52379N', 'S52379P', 'S52379Q', 'S52379R', 'S52379S', 'S52381A',
        'S52381B', 'S52381C', 'S52381D', 'S52381E', 'S52381F', 'S52381G', 'S52381H', 'S52381J',
        'S52381K', 'S52381M', 'S52381N', 'S52381P', 'S52381Q', 'S52381R', 'S52381S', 'S52382A',
        'S52382B', 'S52382C', 'S52382D', 'S52382E', 'S52382F', 'S52382G', 'S52382H', 'S52382J',
        'S52382K', 'S52382M', 'S52382N', 'S52382P', 'S52382Q', 'S52382R', 'S52382S', 'S52389A',
        'S52389B', 'S52389C', 'S52389D', 'S52389E', 'S52389F', 'S52389G', 'S52389H', 'S52389J',
        'S52389K', 'S52389M', 'S52389N', 'S52389P', 'S52389Q', 'S52389R', 'S52389S', 'S52391A',
        'S52391B', 'S52391C', 'S52391D', 'S52391E', 'S52391F', 'S52391G', 'S52391H', 'S52391J',
        'S52391K', 'S52391M', 'S52391N', 'S52391P', 'S52391Q', 'S52391R', 'S52391S', 'S52392A',
        'S52392B', 'S52392C', 'S52392D', 'S52392E', 'S52392F', 'S52392G', 'S52392H', 'S52392J',
        'S52392K', 'S52392M', 'S52392N', 'S52392P', 'S52392Q', 'S52392R', 'S52392S', 'S52399A',
        'S52399B', 'S52399C', 'S52399D', 'S52399E', 'S52399F', 'S52399G', 'S52399H', 'S52399J',
        'S52399K', 'S52399M', 'S52399N', 'S52399P', 'S52399Q', 'S52399R', 'S52399S', 'S52501A',
        'S52501B', 'S52501C', 'S52501D', 'S52501E', 'S52501F', 'S52501G', 'S52501H', 'S52501J',
        'S52501K', 'S52501M', 'S52501N', 'S52501P', 'S52501Q', 'S52501R', 'S52501S', 'S52502A',
        'S52502B', 'S52502C', 'S52502D', 'S52502E', 'S52502F', 'S52502G', 'S52502H', 'S52502J',
        'S52502K', 'S52502M', 'S52502N', 'S52502P', 'S52502Q', 'S52502R', 'S52502S', 'S52509A',
        'S52509B', 'S52509C', 'S52509D', 'S52509E', 'S52509F', 'S52509G', 'S52509H', 'S52509J',
        'S52509K', 'S52509M', 'S52509N', 'S52509P', 'S52509Q', 'S52509R', 'S52509S', 'S52511A',
        'S52511B', 'S52511C', 'S52511D', 'S52511E', 'S52511F', 'S52511G', 'S52511H', 'S52511J',
        'S52511K', 'S52511M', 'S52511N', 'S52511P', 'S52511Q', 'S52511R', 'S52511S', 'S52512A',
        'S52512B', 'S52512C', 'S52512D', 'S52512E', 'S52512F', 'S52512G', 'S52512H', 'S52512J',
        'S52512K', 'S52512M', 'S52512N', 'S52512P', 'S52512Q', 'S52512R', 'S52512S', 'S52513A',
        'S52513B', 'S52513C', 'S52513D', 'S52513E', 'S52513F', 'S52513G', 'S52513H', 'S52513J',
        'S52513K', 'S52513M', 'S52513N', 'S52513P', 'S52513Q', 'S52513R', 'S52513S', 'S52514A',
        'S52514B', 'S52514C', 'S52514D', 'S52514E', 'S52514F', 'S52514G', 'S52514H', 'S52514J',
        'S52514K', 'S52514M', 'S52514N', 'S52514P', 'S52514Q', 'S52514R', 'S52514S', 'S52515A',
        'S52515B', 'S52515C', 'S52515D', 'S52515E', 'S52515F', 'S52515G', 'S52515H', 'S52515J',
        'S52515K', 'S52515M', 'S52515N', 'S52515P', 'S52515Q', 'S52515R', 'S52515S', 'S52516A',
        'S52516B', 'S52516C', 'S52516D', 'S52516E', 'S52516F', 'S52516G', 'S52516H', 'S52516J',
        'S52516K', 'S52516M', 'S52516N', 'S52516P', 'S52516Q', 'S52516R', 'S52516S', 'S52521A',
        'S52521D', 'S52521G', 'S52521K', 'S52521P', 'S52521S', 'S52522A', 'S52522D', 'S52522G',
        'S52522K', 'S52522P', 'S52522S', 'S52529A', 'S52529D', 'S52529G', 'S52529K', 'S52529P',
        'S52529S', 'S52531A', 'S52531B', 'S52531C', 'S52531D', 'S52531E', 'S52531F', 'S52531G',
        'S52531H', 'S52531J', 'S52531K', 'S52531M', 'S52531N', 'S52531P', 'S52531Q', 'S52531R',
        'S52531S', 'S52532A', 'S52532B', 'S52532C', 'S52532D', 'S52532E', 'S52532F', 'S52532G',
        'S52532H', 'S52532J', 'S52532K', 'S52532M', 'S52532N', 'S52532P', 'S52532Q', 'S52532R',
        'S52532S', 'S52539A', 'S52539B', 'S52539C', 'S52539D', 'S52539E', 'S52539F', 'S52539G',
        'S52539H', 'S52539J', 'S52539K', 'S52539M', 'S52539N', 'S52539P', 'S52539Q', 'S52539R',
        'S52539S', 'S52541A', 'S52541B', 'S52541C', 'S52541D', 'S52541E', 'S52541F', 'S52541G',
        'S52541H', 'S52541J', 'S52541K', 'S52541M', 'S52541N', 'S52541P', 'S52541Q', 'S52541R',
        'S52541S', 'S52542A', 'S52542B', 'S52542C', 'S52542D', 'S52542E', 'S52542F', 'S52542G',
        'S52542H', 'S52542J', 'S52542K', 'S52542M', 'S52542N', 'S52542P', 'S52542Q', 'S52542R',
        'S52542S', 'S52549A', 'S52549B', 'S52549C', 'S52549D', 'S52549E', 'S52549F', 'S52549G',
        'S52549H', 'S52549J', 'S52549K', 'S52549M', 'S52549N', 'S52549P', 'S52549Q', 'S52549R',
        'S52549S', 'S52551A', 'S52551B', 'S52551C', 'S52551D', 'S52551E', 'S52551F', 'S52551G',
        'S52551H', 'S52551J', 'S52551K', 'S52551M', 'S52551N', 'S52551P', 'S52551Q', 'S52551R',
        'S52551S', 'S52552A', 'S52552B', 'S52552C', 'S52552D', 'S52552E', 'S52552F', 'S52552G',
        'S52552H', 'S52552J', 'S52552K', 'S52552M', 'S52552N', 'S52552P', 'S52552Q', 'S52552R',
        'S52552S', 'S52559A', 'S52559B', 'S52559C', 'S52559D', 'S52559E', 'S52559F', 'S52559G',
        'S52559H', 'S52559J', 'S52559K', 'S52559M', 'S52559N', 'S52559P', 'S52559Q', 'S52559R',
        'S52559S', 'S52561A', 'S52561B', 'S52561C', 'S52561D', 'S52561E', 'S52561F', 'S52561G',
        'S52561H', 'S52561J', 'S52561K', 'S52561M', 'S52561N', 'S52561P', 'S52561Q', 'S52561R',
        'S52561S', 'S52562A', 'S52562B', 'S52562C', 'S52562D', 'S52562E', 'S52562F', 'S52562G',
        'S52562H', 'S52562J', 'S52562K', 'S52562M', 'S52562N', 'S52562P', 'S52562Q', 'S52562R',
        'S52562S', 'S52569A', 'S52569B', 'S52569C', 'S52569D', 'S52569E', 'S52569F', 'S52569G',
        'S52569H', 'S52569J', 'S52569K', 'S52569M', 'S52569N', 'S52569P', 'S52569Q', 'S52569R',
        'S52569S', 'S52571A', 'S52571B', 'S52571C', 'S52571D', 'S52571E', 'S52571F', 'S52571G',
        'S52571H', 'S52571J', 'S52571K', 'S52571M', 'S52571N', 'S52571P', 'S52571Q', 'S52571R',
        'S52571S', 'S52572A', 'S52572B', 'S52572C', 'S52572D', 'S52572E', 'S52572F', 'S52572G',
        'S52572H', 'S52572J', 'S52572K', 'S52572M', 'S52572N', 'S52572P', 'S52572Q', 'S52572R',
        'S52572S', 'S52579A', 'S52579B', 'S52579C', 'S52579D', 'S52579E', 'S52579F', 'S52579G',
        'S52579H', 'S52579J', 'S52579K', 'S52579M', 'S52579N', 'S52579P', 'S52579Q', 'S52579R',
        'S52579S', 'S52591A', 'S52591B', 'S52591C', 'S52591D', 'S52591E', 'S52591F', 'S52591G',
        'S52591H', 'S52591J', 'S52591K', 'S52591M', 'S52591N', 'S52591P', 'S52591Q', 'S52591R',
        'S52591S', 'S52592A', 'S52592B', 'S52592C', 'S52592D', 'S52592E', 'S52592F', 'S52592G',
        'S52592H', 'S52592J', 'S52592K', 'S52592M', 'S52592N', 'S52592P', 'S52592Q', 'S52592R',
        'S52592S', 'S52599A', 'S52599B', 'S52599C', 'S52599D', 'S52599E', 'S52599F', 'S52599G',
        'S52599H', 'S52599J', 'S52599K', 'S52599M', 'S52599N', 'S52599P', 'S52599Q', 'S52599R',
        'S52599S', 'S52601A', 'S52601B', 'S52601C', 'S52601D', 'S52601E', 'S52601F', 'S52601G',
        'S52601H', 'S52601J', 'S52601K', 'S52601M', 'S52601N', 'S52601P', 'S52601Q', 'S52601R',
        'S52601S', 'S52602A', 'S52602B', 'S52602C', 'S52602D', 'S52602E', 'S52602F', 'S52602G',
        'S52602H', 'S52602J', 'S52602K', 'S52602M', 'S52602N', 'S52602P', 'S52602Q', 'S52602R',
        'S52602S', 'S52609A', 'S52609B', 'S52609C', 'S52609D', 'S52609E', 'S52609F', 'S52609G',
        'S52609H', 'S52609J', 'S52609K', 'S52609M', 'S52609N', 'S52609P', 'S52609Q', 'S52609R',
        'S52609S', 'S52611A', 'S52611B', 'S52611C', 'S52611D', 'S52611E', 'S52611F', 'S52611G',
        'S52611H', 'S52611J', 'S52611K', 'S52611M', 'S52611N', 'S52611P', 'S52611Q', 'S52611R',
        'S52611S', 'S52612A', 'S52612B', 'S52612C', 'S52612D', 'S52612E', 'S52612F', 'S52612G',
        'S52612H', 'S52612J', 'S52612K', 'S52612M', 'S52612N', 'S52612P', 'S52612Q', 'S52612R',
        'S52612S', 'S52613A', 'S52613B', 'S52613C', 'S52613D', 'S52613E', 'S52613F', 'S52613G',
        'S52613H', 'S52613J', 'S52613K', 'S52613M', 'S52613N', 'S52613P', 'S52613Q', 'S52613R',
        'S52613S', 'S52614A', 'S52614B', 'S52614C', 'S52614D', 'S52614E', 'S52614F', 'S52614G',
        'S52614H', 'S52614J', 'S52614K', 'S52614M', 'S52614N', 'S52614P', 'S52614Q', 'S52614R',
        'S52614S', 'S52615A', 'S52615B', 'S52615C', 'S52615D', 'S52615E', 'S52615F', 'S52615G',
        'S52615H', 'S52615J', 'S52615K', 'S52615M', 'S52615N', 'S52615P', 'S52615Q', 'S52615R',
        'S52615S', 'S52616A', 'S52616B', 'S52616C', 'S52616D', 'S52616E', 'S52616F', 'S52616G',
        'S52616H', 'S52616J', 'S52616K', 'S52616M', 'S52616N', 'S52616P', 'S52616Q', 'S52616R',
        'S52616S', 'S52621A', 'S52621D', 'S52621G', 'S52621K', 'S52621P', 'S52621S', 'S52622A',
        'S52622D', 'S52622G', 'S52622K', 'S52622P', 'S52622S', 'S52629A', 'S52629D', 'S52629G',
        'S52629K', 'S52629P', 'S52629S', 'S52691A', 'S52691B', 'S52691C', 'S52691D', 'S52691E',
        'S52691F', 'S52691G', 'S52691H', 'S52691J', 'S52691K', 'S52691M', 'S52691N', 'S52691P',
        'S52691Q', 'S52691R', 'S52691S', 'S52692A', 'S52692B', 'S52692C', 'S52692D', 'S52692E',
        'S52692F', 'S52692G', 'S52692H', 'S52692J', 'S52692K', 'S52692M', 'S52692N', 'S52692P',
        'S52692Q', 'S52692R', 'S52692S', 'S52699A', 'S52699B', 'S52699C', 'S52699D', 'S52699E',
        'S52699F', 'S52699G', 'S52699H', 'S52699J', 'S52699K', 'S52699M', 'S52699N', 'S52699P',
        'S52699Q', 'S52699R', 'S52699S', 'S5290XA', 'S5290XB', 'S5290XC', 'S5290XD', 'S5290XE',
        'S5290XF', 'S5290XG', 'S5290XH', 'S5290XJ', 'S5290XK', 'S5290XM', 'S5290XN', 'S5290XP',
        'S5290XQ', 'S5290XR', 'S5290XS', 'S5291XA', 'S5291XB', 'S5291XC', 'S5291XD', 'S5291XE',
        'S5291XF', 'S5291XG', 'S5291XH', 'S5291XJ', 'S5291XK', 'S5291XM', 'S5291XN', 'S5291XP',
        'S5291XQ', 'S5291XR', 'S5291XS', 'S5292XA', 'S5292XB', 'S5292XC', 'S5292XD', 'S5292XE',
        'S5292XF', 'S5292XG', 'S5292XH', 'S5292XJ', 'S5292XK', 'S5292XM', 'S5292XN', 'S5292XP',
        'S5292XQ', 'S5292XR', 'S5292XS', 'S53004A', 'S53004D', 'S53004S', 'S53005A', 'S53005D',
        'S53005S', 'S53006A', 'S53006D', 'S53006S', 'S53014A', 'S53014D', 'S53014S', 'S53015A',
        'S53015D', 'S53015S', 'S53016A', 'S53016D', 'S53016S', 'S53024A', 'S53024D', 'S53024S',
        'S53025A', 'S53025D', 'S53025S', 'S53026A', 'S53026D', 'S53026S', 'S53031A', 'S53031D',
        'S53031S', 'S53032A', 'S53032D', 'S53032S', 'S53033A', 'S53033D', 'S53033S', 'S53094A',
        'S53094D', 'S53094S', 'S53095A', 'S53095D', 'S53095S', 'S53096A', 'S53096D', 'S53096S',
        'S53104A', 'S53104D', 'S53104S', 'S53105A', 'S53105D', 'S53105S', 'S53106A', 'S53106D',
        'S53106S', 'S53114A', 'S53114D', 'S53114S', 'S53115A', 'S53115D', 'S53115S', 'S53116A',
        'S53116D', 'S53116S', 'S53124A', 'S53124D', 'S53124S', 'S53125A', 'S53125D', 'S53125S',
        'S53126A', 'S53126D', 'S53126S', 'S53134A', 'S53134D', 'S53134S', 'S53135A', 'S53135D',
        'S53135S', 'S53136A', 'S53136D', 'S53136S', 'S53144A', 'S53144D', 'S53144S', 'S53145A',
        'S53145D', 'S53145S', 'S53146A', 'S53146D', 'S53146S', 'S53194A', 'S53194D', 'S53194S',
        'S53195A', 'S53195D', 'S53195S', 'S53196A', 'S53196D', 'S53196S', 'S59001A', 'S59001D',
        'S59001G', 'S59001K', 'S59001P', 'S59001S', 'S59002A', 'S59002D', 'S59002G', 'S59002K',
        'S59002P', 'S59002S', 'S59009A', 'S59009D', 'S59009G', 'S59009K', 'S59009P', 'S59009S',
        'S59011A', 'S59011D', 'S59011G', 'S59011K', 'S59011P', 'S59011S', 'S59012A', 'S59012D',
        'S59012G', 'S59012K', 'S59012P', 'S59012S', 'S59019A', 'S59019D', 'S59019G', 'S59019K',
        'S59019P', 'S59019S', 'S59021A', 'S59021D', 'S59021G', 'S59021K', 'S59021P', 'S59021S',
        'S59022A', 'S59022D', 'S59022G', 'S59022K', 'S59022P', 'S59022S', 'S59029A', 'S59029D',
        'S59029G', 'S59029K', 'S59029P', 'S59029S', 'S59031A', 'S59031D', 'S59031G', 'S59031K',
        'S59031P', 'S59031S', 'S59032A', 'S59032D', 'S59032G', 'S59032K', 'S59032P', 'S59032S',
        'S59039A', 'S59039D', 'S59039G', 'S59039K', 'S59039P', 'S59039S', 'S59041A', 'S59041D',
        'S59041G', 'S59041K', 'S59041P', 'S59041S', 'S59042A', 'S59042D', 'S59042G', 'S59042K',
        'S59042P', 'S59042S', 'S59049A', 'S59049D', 'S59049G', 'S59049K', 'S59049P', 'S59049S',
        'S59091A', 'S59091D', 'S59091G', 'S59091K', 'S59091P', 'S59091S', 'S59092A', 'S59092D',
        'S59092G', 'S59092K', 'S59092P', 'S59092S', 'S59099A', 'S59099D', 'S59099G', 'S59099K',
        'S59099P', 'S59099S', 'S59101A', 'S59101D', 'S59101G', 'S59101K', 'S59101P', 'S59101S',
        'S59102A', 'S59102D', 'S59102G', 'S59102K', 'S59102P', 'S59102S', 'S59109A', 'S59109D',
        'S59109G', 'S59109K', 'S59109P', 'S59109S', 'S59111A', 'S59111D', 'S59111G', 'S59111K',
        'S59111P', 'S59111S', 'S59112A', 'S59112D', 'S59112G', 'S59112K', 'S59112P', 'S59112S',
        'S59119A', 'S59119D', 'S59119G', 'S59119K', 'S59119P', 'S59119S', 'S59121A', 'S59121D',
        'S59121G', 'S59121K', 'S59121P', 'S59121S', 'S59122A', 'S59122D', 'S59122G', 'S59122K',
        'S59122P', 'S59122S', 'S59129A', 'S59129D', 'S59129G', 'S59129K', 'S59129P', 'S59129S',
        'S59131A', 'S59131D', 'S59131G', 'S59131K', 'S59131P', 'S59131S', 'S59132A', 'S59132D',
        'S59132G', 'S59132K', 'S59132P', 'S59132S', 'S59139A', 'S59139D', 'S59139G', 'S59139K',
        'S59139P', 'S59139S', 'S59141A', 'S59141D', 'S59141G', 'S59141K', 'S59141P', 'S59141S',
        'S59142A', 'S59142D', 'S59142G', 'S59142K', 'S59142P', 'S59142S', 'S59149A', 'S59149D',
        'S59149G', 'S59149K', 'S59149P', 'S59149S', 'S59191A', 'S59191D', 'S59191G', 'S59191K',
        'S59191P', 'S59191S', 'S59192A', 'S59192D', 'S59192G', 'S59192K', 'S59192P', 'S59192S',
        'S59199A', 'S59199D', 'S59199G', 'S59199K', 'S59199P', 'S59199S', 'S59201A', 'S59201D',
        'S59201G', 'S59201K', 'S59201P', 'S59201S', 'S59202A', 'S59202D', 'S59202G', 'S59202K',
        'S59202P', 'S59202S', 'S59209A', 'S59209D', 'S59209G', 'S59209K', 'S59209P', 'S59209S',
        'S59211A', 'S59211D', 'S59211G', 'S59211K', 'S59211P', 'S59211S', 'S59212A', 'S59212D',
        'S59212G', 'S59212K', 'S59212P', 'S59212S', 'S59219A', 'S59219D', 'S59219G', 'S59219K',
        'S59219P', 'S59219S', 'S59221A', 'S59221D', 'S59221G', 'S59221K', 'S59221P', 'S59221S',
        'S59222A', 'S59222D', 'S59222G', 'S59222K', 'S59222P', 'S59222S', 'S59229A', 'S59229D',
        'S59229G', 'S59229K', 'S59229P', 'S59229S', 'S59231A', 'S59231D', 'S59231G', 'S59231K',
        'S59231P', 'S59231S', 'S59232A', 'S59232D', 'S59232G', 'S59232K', 'S59232P', 'S59232S',
        'S59239A', 'S59239D', 'S59239G', 'S59239K', 'S59239P', 'S59239S', 'S59241A', 'S59241D',
        'S59241G', 'S59241K', 'S59241P', 'S59241S', 'S59242A', 'S59242D', 'S59242G', 'S59242K',
        'S59242P', 'S59242S', 'S59249A', 'S59249D', 'S59249G', 'S59249K', 'S59249P', 'S59249S',
        'S59291A', 'S59291D', 'S59291G', 'S59291K', 'S59291P', 'S59291S', 'S59292A', 'S59292D',
        'S59292G', 'S59292K', 'S59292P', 'S59292S', 'S59299A', 'S59299D', 'S59299G', 'S59299K',
        'S59299P', 'S59299S', 'S62001A', 'S62001B', 'S62001D', 'S62001G', 'S62001K', 'S62001P',
        'S62001S', 'S62002A', 'S62002B', 'S62002D', 'S62002G', 'S62002K', 'S62002P', 'S62002S',
        'S62009A', 'S62009B', 'S62009D', 'S62009G', 'S62009K', 'S62009P', 'S62009S', 'S62011A',
        'S62011B', 'S62011D', 'S62011G', 'S62011K', 'S62011P', 'S62011S', 'S62012A', 'S62012B',
        'S62012D', 'S62012G', 'S62012K', 'S62012P', 'S62012S', 'S62013A', 'S62013B', 'S62013D',
        'S62013G', 'S62013K', 'S62013P', 'S62013S', 'S62014A', 'S62014B', 'S62014D', 'S62014G',
        'S62014K', 'S62014P', 'S62014S', 'S62015A', 'S62015B', 'S62015D', 'S62015G', 'S62015K',
        'S62015P', 'S62015S', 'S62016A', 'S62016B', 'S62016D', 'S62016G', 'S62016K', 'S62016P',
        'S62016S', 'S62021A', 'S62021B', 'S62021D', 'S62021G', 'S62021K', 'S62021P', 'S62021S',
        'S62022A', 'S62022B', 'S62022D', 'S62022G', 'S62022K', 'S62022P', 'S62022S', 'S62023A',
        'S62023B', 'S62023D', 'S62023G', 'S62023K', 'S62023P', 'S62023S', 'S62024A', 'S62024B',
        'S62024D', 'S62024G', 'S62024K', 'S62024P', 'S62024S', 'S62025A', 'S62025B', 'S62025D',
        'S62025G', 'S62025K', 'S62025P', 'S62025S', 'S62026A', 'S62026B', 'S62026D', 'S62026G',
        'S62026K', 'S62026P', 'S62026S', 'S62031A', 'S62031B', 'S62031D', 'S62031G', 'S62031K',
        'S62031P', 'S62031S', 'S62032A', 'S62032B', 'S62032D', 'S62032G', 'S62032K', 'S62032P',
        'S62032S', 'S62033A', 'S62033B', 'S62033D', 'S62033G', 'S62033K', 'S62033P', 'S62033S',
        'S62034A', 'S62034B', 'S62034D', 'S62034G', 'S62034K', 'S62034P', 'S62034S', 'S62035A',
        'S62035B', 'S62035D', 'S62035G', 'S62035K', 'S62035P', 'S62035S', 'S62036A', 'S62036B',
        'S62036D', 'S62036G', 'S62036K', 'S62036P', 'S62036S', 'S62101A', 'S62101B', 'S62101D',
        'S62101G', 'S62101K', 'S62101P', 'S62101S', 'S62102A', 'S62102B', 'S62102D', 'S62102G',
        'S62102K', 'S62102P', 'S62102S', 'S62109A', 'S62109B', 'S62109D', 'S62109G', 'S62109K',
        'S62109P', 'S62109S', 'S62111A', 'S62111B', 'S62111D', 'S62111G', 'S62111K', 'S62111P',
        'S62111S', 'S62112A', 'S62112B', 'S62112D', 'S62112G', 'S62112K', 'S62112P', 'S62112S',
        'S62113A', 'S62113B', 'S62113D', 'S62113G', 'S62113K', 'S62113P', 'S62113S', 'S62114A',
        'S62114B', 'S62114D', 'S62114G', 'S62114K', 'S62114P', 'S62114S', 'S62115A', 'S62115B',
        'S62115D', 'S62115G', 'S62115K', 'S62115P', 'S62115S', 'S62116A', 'S62116B', 'S62116D',
        'S62116G', 'S62116K', 'S62116P', 'S62116S', 'S62121A', 'S62121B', 'S62121D', 'S62121G',
        'S62121K', 'S62121P', 'S62121S', 'S62122A', 'S62122B', 'S62122D', 'S62122G', 'S62122K',
        'S62122P', 'S62122S', 'S62123A', 'S62123B', 'S62123D', 'S62123G', 'S62123K', 'S62123P',
        'S62123S', 'S62124A', 'S62124B', 'S62124D', 'S62124G', 'S62124K', 'S62124P', 'S62124S',
        'S62125A', 'S62125B', 'S62125D', 'S62125G', 'S62125K', 'S62125P', 'S62125S', 'S62126A',
        'S62126B', 'S62126D', 'S62126G', 'S62126K', 'S62126P', 'S62126S', 'S62131A', 'S62131B',
        'S62131D', 'S62131G', 'S62131K', 'S62131P', 'S62131S', 'S62132A', 'S62132B', 'S62132D',
        'S62132G', 'S62132K', 'S62132P', 'S62132S', 'S62133A', 'S62133B', 'S62133D', 'S62133G',
        'S62133K', 'S62133P', 'S62133S', 'S62134A', 'S62134B', 'S62134D', 'S62134G', 'S62134K',
        'S62134P', 'S62134S', 'S62135A', 'S62135B', 'S62135D', 'S62135G', 'S62135K', 'S62135P',
        'S62135S', 'S62136A', 'S62136B', 'S62136D', 'S62136G', 'S62136K', 'S62136P', 'S62136S',
        'S62141A', 'S62141B', 'S62141D', 'S62141G', 'S62141K', 'S62141P', 'S62141S', 'S62142A',
        'S62142B', 'S62142D', 'S62142G', 'S62142K', 'S62142P', 'S62142S', 'S62143A', 'S62143B',
        'S62143D', 'S62143G', 'S62143K', 'S62143P', 'S62143S', 'S62144A', 'S62144B', 'S62144D',
        'S62144G', 'S62144K', 'S62144P', 'S62144S', 'S62145A', 'S62145B', 'S62145D', 'S62145G',
        'S62145K', 'S62145P', 'S62145S', 'S62146A', 'S62146B', 'S62146D', 'S62146G', 'S62146K',
        'S62146P', 'S62146S', 'S62151A', 'S62151B', 'S62151D', 'S62151G', 'S62151K', 'S62151P',
        'S62151S', 'S62152A', 'S62152B', 'S62152D', 'S62152G', 'S62152K', 'S62152P', 'S62152S',
        'S62153A', 'S62153B', 'S62153D', 'S62153G', 'S62153K', 'S62153P', 'S62153S', 'S62154A',
        'S62154B', 'S62154D', 'S62154G', 'S62154K', 'S62154P', 'S62154S', 'S62155A', 'S62155B',
        'S62155D', 'S62155G', 'S62155K', 'S62155P', 'S62155S', 'S62156A', 'S62156B', 'S62156D',
        'S62156G', 'S62156K', 'S62156P', 'S62156S', 'S62161A', 'S62161B', 'S62161D', 'S62161G',
        'S62161K', 'S62161P', 'S62161S', 'S62162A', 'S62162B', 'S62162D', 'S62162G', 'S62162K',
        'S62162P', 'S62162S', 'S62163A', 'S62163B', 'S62163D', 'S62163G', 'S62163K', 'S62163P',
        'S62163S', 'S62164A', 'S62164B', 'S62164D', 'S62164G', 'S62164K', 'S62164P', 'S62164S',
        'S62165A', 'S62165B', 'S62165D', 'S62165G', 'S62165K', 'S62165P', 'S62165S', 'S62166A',
        'S62166B', 'S62166D', 'S62166G', 'S62166K', 'S62166P', 'S62166S', 'S62171A', 'S62171B',
        'S62171D', 'S62171G', 'S62171K', 'S62171P', 'S62171S', 'S62172A', 'S62172B', 'S62172D',
        'S62172G', 'S62172K', 'S62172P', 'S62172S', 'S62173A', 'S62173B', 'S62173D', 'S62173G',
        'S62173K', 'S62173P', 'S62173S', 'S62174A', 'S62174B', 'S62174D', 'S62174G', 'S62174K',
        'S62174P', 'S62174S', 'S62175A', 'S62175B', 'S62175D', 'S62175G', 'S62175K', 'S62175P',
        'S62175S', 'S62176A', 'S62176B', 'S62176D', 'S62176G', 'S62176K', 'S62176P', 'S62176S',
        'S62181A', 'S62181B', 'S62181D', 'S62181G', 'S62181K', 'S62181P', 'S62181S', 'S62182A',
        'S62182B', 'S62182D', 'S62182G', 'S62182K', 'S62182P', 'S62182S', 'S62183A', 'S62183B',
        'S62183D', 'S62183G', 'S62183K', 'S62183P', 'S62183S', 'S62184A', 'S62184B', 'S62184D',
        'S62184G', 'S62184K', 'S62184P', 'S62184S', 'S62185A', 'S62185B', 'S62185D', 'S62185G',
        'S62185K', 'S62185P', 'S62185S', 'S62186A', 'S62186B', 'S62186D', 'S62186G', 'S62186K',
        'S62186P', 'S62186S', 'S62201A', 'S62201B', 'S62201D', 'S62201G', 'S62201K', 'S62201P',
        'S62201S', 'S62202A', 'S62202B', 'S62202D', 'S62202G', 'S62202K', 'S62202P', 'S62202S',
        'S62209A', 'S62209B', 'S62209D', 'S62209G', 'S62209K', 'S62209P', 'S62209S', 'S62211A',
        'S62211B', 'S62211D', 'S62211G', 'S62211K', 'S62211P', 'S62211S', 'S62212A', 'S62212B',
        'S62212D', 'S62212G', 'S62212K', 'S62212P', 'S62212S', 'S62213A', 'S62213B', 'S62213D',
        'S62213G', 'S62213K', 'S62213P', 'S62213S', 'S62221A', 'S62221B', 'S62221D', 'S62221G',
        'S62221K', 'S62221P', 'S62221S', 'S62222A', 'S62222B', 'S62222D', 'S62222G', 'S62222K',
        'S62222P', 'S62222S', 'S62223A', 'S62223B', 'S62223D', 'S62223G', 'S62223K', 'S62223P',
        'S62223S', 'S62224A', 'S62224B', 'S62224D', 'S62224G', 'S62224K', 'S62224P', 'S62224S',
        'S62225A', 'S62225B', 'S62225D', 'S62225G', 'S62225K', 'S62225P', 'S62225S', 'S62226A',
        'S62226B', 'S62226D', 'S62226G', 'S62226K', 'S62226P', 'S62226S', 'S62231A', 'S62231B',
        'S62231D', 'S62231G', 'S62231K', 'S62231P', 'S62231S', 'S62232A', 'S62232B', 'S62232D',
        'S62232G', 'S62232K', 'S62232P', 'S62232S', 'S62233A', 'S62233B', 'S62233D', 'S62233G',
        'S62233K', 'S62233P', 'S62233S', 'S62234A', 'S62234B', 'S62234D', 'S62234G', 'S62234K',
        'S62234P', 'S62234S', 'S62235A', 'S62235B', 'S62235D', 'S62235G', 'S62235K', 'S62235P',
        'S62235S', 'S62236A', 'S62236B', 'S62236D', 'S62236G', 'S62236K', 'S62236P', 'S62236S',
        'S62241A', 'S62241B', 'S62241D', 'S62241G', 'S62241K', 'S62241P', 'S62241S', 'S62242A',
        'S62242B', 'S62242D', 'S62242G', 'S62242K', 'S62242P', 'S62242S', 'S62243A', 'S62243B',
        'S62243D', 'S62243G', 'S62243K', 'S62243P', 'S62243S', 'S62244A', 'S62244B', 'S62244D',
        'S62244G', 'S62244K', 'S62244P', 'S62244S', 'S62245A', 'S62245B', 'S62245D', 'S62245G',
        'S62245K', 'S62245P', 'S62245S', 'S62246A', 'S62246B', 'S62246D', 'S62246G', 'S62246K',
        'S62246P', 'S62246S', 'S62251A', 'S62251B', 'S62251D', 'S62251G', 'S62251K', 'S62251P',
        'S62251S', 'S62252A', 'S62252B', 'S62252D', 'S62252G', 'S62252K', 'S62252P', 'S62252S',
        'S62253A', 'S62253B', 'S62253D', 'S62253G', 'S62253K', 'S62253P', 'S62253S', 'S62254A',
        'S62254B', 'S62254D', 'S62254G', 'S62254K', 'S62254P', 'S62254S', 'S62255A', 'S62255B',
        'S62255D', 'S62255G', 'S62255K', 'S62255P', 'S62255S', 'S62256A', 'S62256B', 'S62256D',
        'S62256G', 'S62256K', 'S62256P', 'S62256S', 'S62291A', 'S62291B', 'S62291D', 'S62291G',
        'S62291K', 'S62291P', 'S62291S', 'S62292A', 'S62292B', 'S62292D', 'S62292G', 'S62292K',
        'S62292P', 'S62292S', 'S62299A', 'S62299B', 'S62299D', 'S62299G', 'S62299K', 'S62299P',
        'S62299S', 'S62300A', 'S62300B', 'S62300D', 'S62300G', 'S62300K', 'S62300P', 'S62300S',
        'S62301A', 'S62301B', 'S62301D', 'S62301G', 'S62301K', 'S62301P', 'S62301S', 'S62302A',
        'S62302B', 'S62302D', 'S62302G', 'S62302K', 'S62302P', 'S62302S', 'S62303A', 'S62303B',
        'S62303D', 'S62303G', 'S62303K', 'S62303P', 'S62303S', 'S62304A', 'S62304B', 'S62304D',
        'S62304G', 'S62304K', 'S62304P', 'S62304S', 'S62305A', 'S62305B', 'S62305D', 'S62305G',
        'S62305K', 'S62305P', 'S62305S', 'S62306A', 'S62306B', 'S62306D', 'S62306G', 'S62306K',
        'S62306P', 'S62306S', 'S62307A', 'S62307B', 'S62307D', 'S62307G', 'S62307K', 'S62307P',
        'S62307S', 'S62308A', 'S62308B', 'S62308D', 'S62308G', 'S62308K', 'S62308P', 'S62308S',
        'S62309A', 'S62309B', 'S62309D', 'S62309G', 'S62309K', 'S62309P', 'S62309S', 'S62310A',
        'S62310B', 'S62310D', 'S62310G', 'S62310K', 'S62310P', 'S62310S', 'S62311A', 'S62311B',
        'S62311D', 'S62311G', 'S62311K', 'S62311P', 'S62311S', 'S62312A', 'S62312B', 'S62312D',
        'S62312G', 'S62312K', 'S62312P', 'S62312S', 'S62313A', 'S62313B', 'S62313D', 'S62313G',
        'S62313K', 'S62313P', 'S62313S', 'S62314A', 'S62314B', 'S62314D', 'S62314G', 'S62314K',
        'S62314P', 'S62314S', 'S62315A', 'S62315B', 'S62315D', 'S62315G', 'S62315K', 'S62315P',
        'S62315S', 'S62316A', 'S62316B', 'S62316D', 'S62316G', 'S62316K', 'S62316P', 'S62316S',
        'S62317A', 'S62317B', 'S62317D', 'S62317G', 'S62317K', 'S62317P', 'S62317S', 'S62318A',
        'S62318B', 'S62318D', 'S62318G', 'S62318K', 'S62318P', 'S62318S', 'S62319A', 'S62319B',
        'S62319D', 'S62319G', 'S62319K', 'S62319P', 'S62319S', 'S62320A', 'S62320B', 'S62320D',
        'S62320G', 'S62320K', 'S62320P', 'S62320S', 'S62321A', 'S62321B', 'S62321D', 'S62321G',
        'S62321K', 'S62321P', 'S62321S', 'S62322A', 'S62322B', 'S62322D', 'S62322G', 'S62322K',
        'S62322P', 'S62322S', 'S62323A', 'S62323B', 'S62323D', 'S62323G', 'S62323K', 'S62323P',
        'S62323S', 'S62324A', 'S62324B', 'S62324D', 'S62324G', 'S62324K', 'S62324P', 'S62324S',
        'S62325A', 'S62325B', 'S62325D', 'S62325G', 'S62325K', 'S62325P', 'S62325S', 'S62326A',
        'S62326B', 'S62326D', 'S62326G', 'S62326K', 'S62326P', 'S62326S', 'S62327A', 'S62327B',
        'S62327D', 'S62327G', 'S62327K', 'S62327P', 'S62327S', 'S62328A', 'S62328B', 'S62328D',
        'S62328G', 'S62328K', 'S62328P', 'S62328S', 'S62329A', 'S62329B', 'S62329D', 'S62329G',
        'S62329K', 'S62329P', 'S62329S', 'S62330A', 'S62330B', 'S62330D', 'S62330G', 'S62330K',
        'S62330P', 'S62330S', 'S62331A', 'S62331B', 'S62331D', 'S62331G', 'S62331K', 'S62331P',
        'S62331S', 'S62332A', 'S62332B', 'S62332D', 'S62332G', 'S62332K', 'S62332P', 'S62332S',
        'S62333A', 'S62333B', 'S62333D', 'S62333G', 'S62333K', 'S62333P', 'S62333S', 'S62334A',
        'S62334B', 'S62334D', 'S62334G', 'S62334K', 'S62334P', 'S62334S', 'S62335A', 'S62335B',
        'S62335D', 'S62335G', 'S62335K', 'S62335P', 'S62335S', 'S62336A', 'S62336B', 'S62336D',
        'S62336G', 'S62336K', 'S62336P', 'S62336S', 'S62337A', 'S62337B', 'S62337D', 'S62337G',
        'S62337K', 'S62337P', 'S62337S', 'S62338A', 'S62338B', 'S62338D', 'S62338G', 'S62338K',
        'S62338P', 'S62338S', 'S62339A', 'S62339B', 'S62339D', 'S62339G', 'S62339K', 'S62339P',
        'S62339S', 'S62340A', 'S62340B', 'S62340D', 'S62340G', 'S62340K', 'S62340P', 'S62340S',
        'S62341A', 'S62341B', 'S62341D', 'S62341G', 'S62341K', 'S62341P', 'S62341S', 'S62342A',
        'S62342B', 'S62342D', 'S62342G', 'S62342K', 'S62342P', 'S62342S', 'S62343A', 'S62343B',
        'S62343D', 'S62343G', 'S62343K', 'S62343P', 'S62343S', 'S62344A', 'S62344B', 'S62344D',
        'S62344G', 'S62344K', 'S62344P', 'S62344S', 'S62345A', 'S62345B', 'S62345D', 'S62345G',
        'S62345K', 'S62345P', 'S62345S', 'S62346A', 'S62346B', 'S62346D', 'S62346G', 'S62346K',
        'S62346P', 'S62346S', 'S62347A', 'S62347B', 'S62347D', 'S62347G', 'S62347K', 'S62347P',
        'S62347S', 'S62348A', 'S62348B', 'S62348D', 'S62348G', 'S62348K', 'S62348P', 'S62348S',
        'S62349A', 'S62349B', 'S62349D', 'S62349G', 'S62349K', 'S62349P', 'S62349S', 'S62350A',
        'S62350B', 'S62350D', 'S62350G', 'S62350K', 'S62350P', 'S62350S', 'S62351A', 'S62351B',
        'S62351D', 'S62351G', 'S62351K', 'S62351P', 'S62351S', 'S62352A', 'S62352B', 'S62352D',
        'S62352G', 'S62352K', 'S62352P', 'S62352S', 'S62353A', 'S62353B', 'S62353D', 'S62353G',
        'S62353K', 'S62353P', 'S62353S', 'S62354A', 'S62354B', 'S62354D', 'S62354G', 'S62354K',
        'S62354P', 'S62354S', 'S62355A', 'S62355B', 'S62355D', 'S62355G', 'S62355K', 'S62355P',
        'S62355S', 'S62356A', 'S62356B', 'S62356D', 'S62356G', 'S62356K', 'S62356P', 'S62356S',
        'S62357A', 'S62357B', 'S62357D', 'S62357G', 'S62357K', 'S62357P', 'S62357S', 'S62358A',
        'S62358B', 'S62358D', 'S62358G', 'S62358K', 'S62358P', 'S62358S', 'S62359A', 'S62359B',
        'S62359D', 'S62359G', 'S62359K', 'S62359P', 'S62359S', 'S62360A', 'S62360B', 'S62360D',
        'S62360G', 'S62360K', 'S62360P', 'S62360S', 'S62361A', 'S62361B', 'S62361D', 'S62361G',
        'S62361K', 'S62361P', 'S62361S', 'S62362A', 'S62362B', 'S62362D', 'S62362G', 'S62362K',
        'S62362P', 'S62362S', 'S62363A', 'S62363B', 'S62363D', 'S62363G', 'S62363K', 'S62363P',
        'S62363S', 'S62364A', 'S62364B', 'S62364D', 'S62364G', 'S62364K', 'S62364P', 'S62364S',
        'S62365A', 'S62365B', 'S62365D', 'S62365G', 'S62365K', 'S62365P', 'S62365S', 'S62366A',
        'S62366B', 'S62366D', 'S62366G', 'S62366K', 'S62366P', 'S62366S', 'S62367A', 'S62367B',
        'S62367D', 'S62367G', 'S62367K', 'S62367P', 'S62367S', 'S62368A', 'S62368B', 'S62368D',
        'S62368G', 'S62368K', 'S62368P', 'S62368S', 'S62369A', 'S62369B', 'S62369D', 'S62369G',
        'S62369K', 'S62369P', 'S62369S', 'S62390A', 'S62390B', 'S62390D', 'S62390G', 'S62390K',
        'S62390P', 'S62390S', 'S62391A', 'S62391B', 'S62391D', 'S62391G', 'S62391K', 'S62391P',
        'S62391S', 'S62392A', 'S62392B', 'S62392D', 'S62392G', 'S62392K', 'S62392P', 'S62392S',
        'S62393A', 'S62393B', 'S62393D', 'S62393G', 'S62393K', 'S62393P', 'S62393S', 'S62394A',
        'S62394B', 'S62394D', 'S62394G', 'S62394K', 'S62394P', 'S62394S', 'S62395A', 'S62395B',
        'S62395D', 'S62395G', 'S62395K', 'S62395P', 'S62395S', 'S62396A', 'S62396B', 'S62396D',
        'S62396G', 'S62396K', 'S62396P', 'S62396S', 'S62397A', 'S62397B', 'S62397D', 'S62397G',
        'S62397K', 'S62397P', 'S62397S', 'S62398A', 'S62398B', 'S62398D', 'S62398G', 'S62398K',
        'S62398P', 'S62398S', 'S62399A', 'S62399B', 'S62399D', 'S62399G', 'S62399K', 'S62399P',
        'S62399S', 'S62501A', 'S62501B', 'S62501D', 'S62501G', 'S62501K', 'S62501P', 'S62501S',
        'S62502A', 'S62502B', 'S62502D', 'S62502G', 'S62502K', 'S62502P', 'S62502S', 'S62509A',
        'S62509B', 'S62509D', 'S62509G', 'S62509K', 'S62509P', 'S62509S', 'S62511A', 'S62511B',
        'S62511D', 'S62511G', 'S62511K', 'S62511P', 'S62511S', 'S62512A', 'S62512B', 'S62512D',
        'S62512G', 'S62512K', 'S62512P', 'S62512S', 'S62513A', 'S62513B', 'S62513D', 'S62513G',
        'S62513K', 'S62513P', 'S62513S', 'S62514A', 'S62514B', 'S62514D', 'S62514G', 'S62514K',
        'S62514P', 'S62514S', 'S62515A', 'S62515B', 'S62515D', 'S62515G', 'S62515K', 'S62515P',
        'S62515S', 'S62516A', 'S62516B', 'S62516D', 'S62516G', 'S62516K', 'S62516P', 'S62516S',
        'S62521A', 'S62521B', 'S62521D', 'S62521G', 'S62521K', 'S62521P', 'S62521S', 'S62522A',
        'S62522B', 'S62522D', 'S62522G', 'S62522K', 'S62522P', 'S62522S', 'S62523A', 'S62523B',
        'S62523D', 'S62523G', 'S62523K', 'S62523P', 'S62523S', 'S62524A', 'S62524B', 'S62524D',
        'S62524G', 'S62524K', 'S62524P', 'S62524S', 'S62525A', 'S62525B', 'S62525D', 'S62525G',
        'S62525K', 'S62525P', 'S62525S', 'S62526A', 'S62526B', 'S62526D', 'S62526G', 'S62526K',
        'S62526P', 'S62526S', 'S62600A', 'S62600B', 'S62600D', 'S62600G', 'S62600K', 'S62600P',
        'S62600S', 'S62601A', 'S62601B', 'S62601D', 'S62601G', 'S62601K', 'S62601P', 'S62601S',
        'S62602A', 'S62602B', 'S62602D', 'S62602G', 'S62602K', 'S62602P', 'S62602S', 'S62603A',
        'S62603B', 'S62603D', 'S62603G', 'S62603K', 'S62603P', 'S62603S', 'S62604A', 'S62604B',
        'S62604D', 'S62604G', 'S62604K', 'S62604P', 'S62604S', 'S62605A', 'S62605B', 'S62605D',
        'S62605G', 'S62605K', 'S62605P', 'S62605S', 'S62606A', 'S62606B', 'S62606D', 'S62606G',
        'S62606K', 'S62606P', 'S62606S', 'S62607A', 'S62607B', 'S62607D', 'S62607G', 'S62607K',
        'S62607P', 'S62607S', 'S62608A', 'S62608B', 'S62608D', 'S62608G', 'S62608K', 'S62608P',
        'S62608S', 'S62609A', 'S62609B', 'S62609D', 'S62609G', 'S62609K', 'S62609P', 'S62609S',
        'S62610A', 'S62610B', 'S62610D', 'S62610G', 'S62610K', 'S62610P', 'S62610S', 'S62611A',
        'S62611B', 'S62611D', 'S62611G', 'S62611K', 'S62611P', 'S62611S', 'S62612A', 'S62612B',
        'S62612D', 'S62612G', 'S62612K', 'S62612P', 'S62612S', 'S62613A', 'S62613B', 'S62613D',
        'S62613G', 'S62613K', 'S62613P', 'S62613S', 'S62614A', 'S62614B', 'S62614D', 'S62614G',
        'S62614K', 'S62614P', 'S62614S', 'S62615A', 'S62615B', 'S62615D', 'S62615G', 'S62615K',
        'S62615P', 'S62615S', 'S62616A', 'S62616B', 'S62616D', 'S62616G', 'S62616K', 'S62616P',
        'S62616S', 'S62617A', 'S62617B', 'S62617D', 'S62617G', 'S62617K', 'S62617P', 'S62617S',
        'S62618A', 'S62618B', 'S62618D', 'S62618G', 'S62618K', 'S62618P', 'S62618S', 'S62619A',
        'S62619B', 'S62619D', 'S62619G', 'S62619K', 'S62619P', 'S62619S', 'S62620A', 'S62620B',
        'S62620D', 'S62620G', 'S62620K', 'S62620P', 'S62620S', 'S62621A', 'S62621B', 'S62621D',
        'S62621G', 'S62621K', 'S62621P', 'S62621S', 'S62622A', 'S62622B', 'S62622D', 'S62622G',
        'S62622K', 'S62622P', 'S62622S', 'S62623A', 'S62623B', 'S62623D', 'S62623G', 'S62623K',
        'S62623P', 'S62623S', 'S62624A', 'S62624B', 'S62624D', 'S62624G', 'S62624K', 'S62624P',
        'S62624S', 'S62625A', 'S62625B', 'S62625D', 'S62625G', 'S62625K', 'S62625P', 'S62625S',
        'S62626A', 'S62626B', 'S62626D', 'S62626G', 'S62626K', 'S62626P', 'S62626S', 'S62627A',
        'S62627B', 'S62627D', 'S62627G', 'S62627K', 'S62627P', 'S62627S', 'S62628A', 'S62628B',
        'S62628D', 'S62628G', 'S62628K', 'S62628P', 'S62628S', 'S62629A', 'S62629B', 'S62629D',
        'S62629G', 'S62629K', 'S62629P', 'S62629S', 'S62630A', 'S62630B', 'S62630D', 'S62630G',
        'S62630K', 'S62630P', 'S62630S', 'S62631A', 'S62631B', 'S62631D', 'S62631G', 'S62631K',
        'S62631P', 'S62631S', 'S62632A', 'S62632B', 'S62632D', 'S62632G', 'S62632K', 'S62632P',
        'S62632S', 'S62633A', 'S62633B', 'S62633D', 'S62633G', 'S62633K', 'S62633P', 'S62633S',
        'S62634A', 'S62634B', 'S62634D', 'S62634G', 'S62634K', 'S62634P', 'S62634S', 'S62635A',
        'S62635B', 'S62635D', 'S62635G', 'S62635K', 'S62635P', 'S62635S', 'S62636A', 'S62636B',
        'S62636D', 'S62636G', 'S62636K', 'S62636P', 'S62636S', 'S62637A', 'S62637B', 'S62637D',
        'S62637G', 'S62637K', 'S62637P', 'S62637S', 'S62638A', 'S62638B', 'S62638D', 'S62638G',
        'S62638K', 'S62638P', 'S62638S', 'S62639A', 'S62639B', 'S62639D', 'S62639G', 'S62639K',
        'S62639P', 'S62639S', 'S62640A', 'S62640B', 'S62640D', 'S62640G', 'S62640K', 'S62640P',
        'S62640S', 'S62641A', 'S62641B', 'S62641D', 'S62641G', 'S62641K', 'S62641P', 'S62641S',
        'S62642A', 'S62642B', 'S62642D', 'S62642G', 'S62642K', 'S62642P', 'S62642S', 'S62643A',
        'S62643B', 'S62643D', 'S62643G', 'S62643K', 'S62643P', 'S62643S', 'S62644A', 'S62644B',
        'S62644D', 'S62644G', 'S62644K', 'S62644P', 'S62644S', 'S62645A', 'S62645B', 'S62645D',
        'S62645G', 'S62645K', 'S62645P', 'S62645S', 'S62646A', 'S62646B', 'S62646D', 'S62646G',
        'S62646K', 'S62646P', 'S62646S', 'S62647A', 'S62647B', 'S62647D', 'S62647G', 'S62647K',
        'S62647P', 'S62647S', 'S62648A', 'S62648B', 'S62648D', 'S62648G', 'S62648K', 'S62648P',
        'S62648S', 'S62649A', 'S62649B', 'S62649D', 'S62649G', 'S62649K', 'S62649P', 'S62649S',
        'S62650A', 'S62650B', 'S62650D', 'S62650G', 'S62650K', 'S62650P', 'S62650S', 'S62651A',
        'S62651B', 'S62651D', 'S62651G', 'S62651K', 'S62651P', 'S62651S', 'S62652A', 'S62652B',
        'S62652D', 'S62652G', 'S62652K', 'S62652P', 'S62652S', 'S62653A', 'S62653B', 'S62653D',
        'S62653G', 'S62653K', 'S62653P', 'S62653S', 'S62654A', 'S62654B', 'S62654D', 'S62654G',
        'S62654K', 'S62654P', 'S62654S', 'S62655A', 'S62655B', 'S62655D', 'S62655G', 'S62655K',
        'S62655P', 'S62655S', 'S62656A', 'S62656B', 'S62656D', 'S62656G', 'S62656K', 'S62656P',
        'S62656S', 'S62657A', 'S62657B', 'S62657D', 'S62657G', 'S62657K', 'S62657P', 'S62657S',
        'S62658A', 'S62658B', 'S62658D', 'S62658G', 'S62658K', 'S62658P', 'S62658S', 'S62659A',
        'S62659B', 'S62659D', 'S62659G', 'S62659K', 'S62659P', 'S62659S', 'S62660A', 'S62660B',
        'S62660D', 'S62660G', 'S62660K', 'S62660P', 'S62660S', 'S62661A', 'S62661B', 'S62661D',
        'S62661G', 'S62661K', 'S62661P', 'S62661S', 'S62662A', 'S62662B', 'S62662D', 'S62662G',
        'S62662K', 'S62662P', 'S62662S', 'S62663A', 'S62663B', 'S62663D', 'S62663G', 'S62663K',
        'S62663P', 'S62663S', 'S62664A', 'S62664B', 'S62664D', 'S62664G', 'S62664K', 'S62664P',
        'S62664S', 'S62665A', 'S62665B', 'S62665D', 'S62665G', 'S62665K', 'S62665P', 'S62665S',
        'S62666A', 'S62666B', 'S62666D', 'S62666G', 'S62666K', 'S62666P', 'S62666S', 'S62667A',
        'S62667B', 'S62667D', 'S62667G', 'S62667K', 'S62667P', 'S62667S', 'S62668A', 'S62668B',
        'S62668D', 'S62668G', 'S62668K', 'S62668P', 'S62668S', 'S62669A', 'S62669B', 'S62669D',
        'S62669G', 'S62669K', 'S62669P', 'S62669S', 'S6290XA', 'S6290XB', 'S6290XD', 'S6290XG',
        'S6290XK', 'S6290XP', 'S6290XS', 'S6291XA', 'S6291XB', 'S6291XD', 'S6291XG', 'S6291XK',
        'S6291XP', 'S6291XS', 'S6292XA', 'S6292XB', 'S6292XD', 'S6292XG', 'S6292XK', 'S6292XP',
        'S6292XS', 'S63004A', 'S63004D', 'S63004S', 'S63005A', 'S63005D', 'S63005S', 'S63006A',
        'S63006D', 'S63006S', 'S63014A', 'S63014D', 'S63014S', 'S63015A', 'S63015D', 'S63015S',
        'S63016A', 'S63016D', 'S63016S', 'S63024A', 'S63024D', 'S63024S', 'S63025A', 'S63025D',
        'S63025S', 'S63026A', 'S63026D', 'S63026S', 'S63034A', 'S63034D', 'S63034S', 'S63035A',
        'S63035D', 'S63035S', 'S63036A', 'S63036D', 'S63036S', 'S63044A', 'S63044D', 'S63044S',
        'S63045A', 'S63045D', 'S63045S', 'S63046A', 'S63046D', 'S63046S', 'S63054A', 'S63054D',
        'S63054S', 'S63055A', 'S63055D', 'S63055S', 'S63056A', 'S63056D', 'S63056S', 'S63064A',
        'S63064D', 'S63064S', 'S63065A', 'S63065D', 'S63065S', 'S63066A', 'S63066D', 'S63066S',
        'S63074A', 'S63074D', 'S63074S', 'S63075A', 'S63075D', 'S63075S', 'S63076A', 'S63076D',
        'S63076S', 'S63094A', 'S63094D', 'S63094S', 'S63095A', 'S63095D', 'S63095S', 'S63096A',
        'S63096D', 'S63096S', 'S63104A', 'S63104D', 'S63104S', 'S63105A', 'S63105D', 'S63105S',
        'S63106A', 'S63106D', 'S63106S', 'S63114A', 'S63114D', 'S63114S', 'S63115A', 'S63115D',
        'S63115S', 'S63116A', 'S63116D', 'S63116S', 'S63124A', 'S63124D', 'S63124S', 'S63125A',
        'S63125D', 'S63125S', 'S63126A', 'S63126D', 'S63126S', 'S63134A', 'S63134D', 'S63134S',
        'S63135A', 'S63135D', 'S63135S', 'S63136A', 'S63136D', 'S63136S', 'S63144A', 'S63144D',
        'S63144S', 'S63145A', 'S63145D', 'S63145S', 'S63146A', 'S63146D', 'S63146S', 'S63250A',
        'S63250D', 'S63250S', 'S63251A', 'S63251D', 'S63251S', 'S63252A', 'S63252D', 'S63252S',
        'S63253A', 'S63253D', 'S63253S', 'S63254A', 'S63254D', 'S63254S', 'S63255A', 'S63255D',
        'S63255S', 'S63256A', 'S63256D', 'S63256S', 'S63257A', 'S63257D', 'S63257S', 'S63258A',
        'S63258D', 'S63258S', 'S63259A', 'S63259D', 'S63259S', 'S63260A', 'S63260D', 'S63260S',
        'S63261A', 'S63261D', 'S63261S', 'S63262A', 'S63262D', 'S63262S', 'S63263A', 'S63263D',
        'S63263S', 'S63264A', 'S63264D', 'S63264S', 'S63265A', 'S63265D', 'S63265S', 'S63266A',
        'S63266D', 'S63266S', 'S63267A', 'S63267D', 'S63267S', 'S63268A', 'S63268D', 'S63268S',
        'S63269A', 'S63269D', 'S63269S', 'S63270A', 'S63270D', 'S63270S', 'S63271A', 'S63271D',
        'S63271S', 'S63272A', 'S63272D', 'S63272S', 'S63273A', 'S63273D', 'S63273S', 'S63274A',
        'S63274D', 'S63274S', 'S63275A', 'S63275D', 'S63275S', 'S63276A', 'S63276D', 'S63276S',
        'S63277A', 'S63277D', 'S63277S', 'S63278A', 'S63278D', 'S63278S', 'S63279A', 'S63279D',
        'S63279S', 'S63280A', 'S63280D', 'S63280S', 'S63281A', 'S63281D', 'S63281S', 'S63282A',
        'S63282D', 'S63282S', 'S63283A', 'S63283D', 'S63283S', 'S63284A', 'S63284D', 'S63284S',
        'S63285A', 'S63285D', 'S63285S', 'S63286A', 'S63286D', 'S63286S', 'S63287A', 'S63287D',
        'S63287S', 'S63288A', 'S63288D', 'S63288S', 'S63289A', 'S63289D', 'S63289S', 'S63290A',
        'S63290D', 'S63290S', 'S63291A', 'S63291D', 'S63291S', 'S63292A', 'S63292D', 'S63292S',
        'S63293A', 'S63293D', 'S63293S', 'S63294A', 'S63294D', 'S63294S', 'S63295A', 'S63295D',
        'S63295S', 'S63296A', 'S63296D', 'S63296S', 'S63297A', 'S63297D', 'S63297S', 'S63298A',
        'S63298D', 'S63298S', 'S63299A', 'S63299D', 'S63299S', 'S72001A', 'S72001B', 'S72001C',
        'S72001D', 'S72001E', 'S72001F', 'S72001G', 'S72001H', 'S72001J', 'S72001K', 'S72001M',
        'S72001N', 'S72001P', 'S72001Q', 'S72001R', 'S72001S', 'S72002A', 'S72002B', 'S72002C',
        'S72002D', 'S72002E', 'S72002F', 'S72002G', 'S72002H', 'S72002J', 'S72002K', 'S72002M',
        'S72002N', 'S72002P', 'S72002Q', 'S72002R', 'S72002S', 'S72009A', 'S72009B', 'S72009C',
        'S72009D', 'S72009E', 'S72009F', 'S72009G', 'S72009H', 'S72009J', 'S72009K', 'S72009M',
        'S72009N', 'S72009P', 'S72009Q', 'S72009R', 'S72009S', 'S72011A', 'S72011B', 'S72011C',
        'S72011D', 'S72011E', 'S72011F', 'S72011G', 'S72011H', 'S72011J', 'S72011K', 'S72011M',
        'S72011N', 'S72011P', 'S72011Q', 'S72011R', 'S72011S', 'S72012A', 'S72012B', 'S72012C',
        'S72012D', 'S72012E', 'S72012F', 'S72012G', 'S72012H', 'S72012J', 'S72012K', 'S72012M',
        'S72012N', 'S72012P', 'S72012Q', 'S72012R', 'S72012S', 'S72019A', 'S72019B', 'S72019C',
        'S72019D', 'S72019E', 'S72019F', 'S72019G', 'S72019H', 'S72019J', 'S72019K', 'S72019M',
        'S72019N', 'S72019P', 'S72019Q', 'S72019R', 'S72019S', 'S72021A', 'S72021B', 'S72021C',
        'S72021D', 'S72021E', 'S72021F', 'S72021G', 'S72021H', 'S72021J', 'S72021K', 'S72021M',
        'S72021N', 'S72021P', 'S72021Q', 'S72021R', 'S72021S', 'S72022A', 'S72022B', 'S72022C',
        'S72022D', 'S72022E', 'S72022F', 'S72022G', 'S72022H', 'S72022J', 'S72022K', 'S72022M',
        'S72022N', 'S72022P', 'S72022Q', 'S72022R', 'S72022S', 'S72023A', 'S72023B', 'S72023C',
        'S72023D', 'S72023E', 'S72023F', 'S72023G', 'S72023H', 'S72023J', 'S72023K', 'S72023M',
        'S72023N', 'S72023P', 'S72023Q', 'S72023R', 'S72023S', 'S72024A', 'S72024B', 'S72024C',
        'S72024D', 'S72024E', 'S72024F', 'S72024G', 'S72024H', 'S72024J', 'S72024K', 'S72024M',
        'S72024N', 'S72024P', 'S72024Q', 'S72024R', 'S72024S', 'S72025A', 'S72025B', 'S72025C',
        'S72025D', 'S72025E', 'S72025F', 'S72025G', 'S72025H', 'S72025J', 'S72025K', 'S72025M',
        'S72025N', 'S72025P', 'S72025Q', 'S72025R', 'S72025S', 'S72026A', 'S72026B', 'S72026C',
        'S72026D', 'S72026E', 'S72026F', 'S72026G', 'S72026H', 'S72026J', 'S72026K', 'S72026M',
        'S72026N', 'S72026P', 'S72026Q', 'S72026R', 'S72026S', 'S72031A', 'S72031B', 'S72031C',
        'S72031D', 'S72031E', 'S72031F', 'S72031G', 'S72031H', 'S72031J', 'S72031K', 'S72031M',
        'S72031N', 'S72031P', 'S72031Q', 'S72031R', 'S72031S', 'S72032A', 'S72032B', 'S72032C',
        'S72032D', 'S72032E', 'S72032F', 'S72032G', 'S72032H', 'S72032J', 'S72032K', 'S72032M',
        'S72032N', 'S72032P', 'S72032Q', 'S72032R', 'S72032S', 'S72033A', 'S72033B', 'S72033C',
        'S72033D', 'S72033E', 'S72033F', 'S72033G', 'S72033H', 'S72033J', 'S72033K', 'S72033M',
        'S72033N', 'S72033P', 'S72033Q', 'S72033R', 'S72033S', 'S72034A', 'S72034B', 'S72034C',
        'S72034D', 'S72034E', 'S72034F', 'S72034G', 'S72034H', 'S72034J', 'S72034K', 'S72034M',
        'S72034N', 'S72034P', 'S72034Q', 'S72034R', 'S72034S', 'S72035A', 'S72035B', 'S72035C',
        'S72035D', 'S72035E', 'S72035F', 'S72035G', 'S72035H', 'S72035J', 'S72035K', 'S72035M',
        'S72035N', 'S72035P', 'S72035Q', 'S72035R', 'S72035S', 'S72036A', 'S72036B', 'S72036C',
        'S72036D', 'S72036E', 'S72036F', 'S72036G', 'S72036H', 'S72036J', 'S72036K', 'S72036M',
        'S72036N', 'S72036P', 'S72036Q', 'S72036R', 'S72036S', 'S72041A', 'S72041B', 'S72041C',
        'S72041D', 'S72041E', 'S72041F', 'S72041G', 'S72041H', 'S72041J', 'S72041K', 'S72041M',
        'S72041N', 'S72041P', 'S72041Q', 'S72041R', 'S72041S', 'S72042A', 'S72042B', 'S72042C',
        'S72042D', 'S72042E', 'S72042F', 'S72042G', 'S72042H', 'S72042J', 'S72042K', 'S72042M',
        'S72042N', 'S72042P', 'S72042Q', 'S72042R', 'S72042S', 'S72043A', 'S72043B', 'S72043C',
        'S72043D', 'S72043E', 'S72043F', 'S72043G', 'S72043H', 'S72043J', 'S72043K', 'S72043M',
        'S72043N', 'S72043P', 'S72043Q', 'S72043R', 'S72043S', 'S72044A', 'S72044B', 'S72044C',
        'S72044D', 'S72044E', 'S72044F', 'S72044G', 'S72044H', 'S72044J', 'S72044K', 'S72044M',
        'S72044N', 'S72044P', 'S72044Q', 'S72044R', 'S72044S', 'S72045A', 'S72045B', 'S72045C',
        'S72045D', 'S72045E', 'S72045F', 'S72045G', 'S72045H', 'S72045J', 'S72045K', 'S72045M',
        'S72045N', 'S72045P', 'S72045Q', 'S72045R', 'S72045S', 'S72046A', 'S72046B', 'S72046C',
        'S72046D', 'S72046E', 'S72046F', 'S72046G', 'S72046H', 'S72046J', 'S72046K', 'S72046M',
        'S72046N', 'S72046P', 'S72046Q', 'S72046R', 'S72046S', 'S72051A', 'S72051B', 'S72051C',
        'S72051D', 'S72051E', 'S72051F', 'S72051G', 'S72051H', 'S72051J', 'S72051K', 'S72051M',
        'S72051N', 'S72051P', 'S72051Q', 'S72051R', 'S72051S', 'S72052A', 'S72052B', 'S72052C',
        'S72052D', 'S72052E', 'S72052F', 'S72052G', 'S72052H', 'S72052J', 'S72052K', 'S72052M',
        'S72052N', 'S72052P', 'S72052Q', 'S72052R', 'S72052S', 'S72059A', 'S72059B', 'S72059C',
        'S72059D', 'S72059E', 'S72059F', 'S72059G', 'S72059H', 'S72059J', 'S72059K', 'S72059M',
        'S72059N', 'S72059P', 'S72059Q', 'S72059R', 'S72059S', 'S72061A', 'S72061B', 'S72061C',
        'S72061D', 'S72061E', 'S72061F', 'S72061G', 'S72061H', 'S72061J', 'S72061K', 'S72061M',
        'S72061N', 'S72061P', 'S72061Q', 'S72061R', 'S72061S', 'S72062A', 'S72062B', 'S72062C',
        'S72062D', 'S72062E', 'S72062F', 'S72062G', 'S72062H', 'S72062J', 'S72062K', 'S72062M',
        'S72062N', 'S72062P', 'S72062Q', 'S72062R', 'S72062S', 'S72063A', 'S72063B', 'S72063C',
        'S72063D', 'S72063E', 'S72063F', 'S72063G', 'S72063H', 'S72063J', 'S72063K', 'S72063M',
        'S72063N', 'S72063P', 'S72063Q', 'S72063R', 'S72063S', 'S72064A', 'S72064B', 'S72064C',
        'S72064D', 'S72064E', 'S72064F', 'S72064G', 'S72064H', 'S72064J', 'S72064K', 'S72064M',
        'S72064N', 'S72064P', 'S72064Q', 'S72064R', 'S72064S', 'S72065A', 'S72065B', 'S72065C',
        'S72065D', 'S72065E', 'S72065F', 'S72065G', 'S72065H', 'S72065J', 'S72065K', 'S72065M',
        'S72065N', 'S72065P', 'S72065Q', 'S72065R', 'S72065S', 'S72066A', 'S72066B', 'S72066C',
        'S72066D', 'S72066E', 'S72066F', 'S72066G', 'S72066H', 'S72066J', 'S72066K', 'S72066M',
        'S72066N', 'S72066P', 'S72066Q', 'S72066R', 'S72066S', 'S72091A', 'S72091B', 'S72091C',
        'S72091D', 'S72091E', 'S72091F', 'S72091G', 'S72091H', 'S72091J', 'S72091K', 'S72091M',
        'S72091N', 'S72091P', 'S72091Q', 'S72091R', 'S72091S', 'S72092A', 'S72092B', 'S72092C',
        'S72092D', 'S72092E', 'S72092F', 'S72092G', 'S72092H', 'S72092J', 'S72092K', 'S72092M',
        'S72092N', 'S72092P', 'S72092Q', 'S72092R', 'S72092S', 'S72099A', 'S72099B', 'S72099C',
        'S72099D', 'S72099E', 'S72099F', 'S72099G', 'S72099H', 'S72099J', 'S72099K', 'S72099M',
        'S72099N', 'S72099P', 'S72099Q', 'S72099R', 'S72099S', 'S72101A', 'S72101B', 'S72101C',
        'S72101D', 'S72101E', 'S72101F', 'S72101G', 'S72101H', 'S72101J', 'S72101K', 'S72101M',
        'S72101N', 'S72101P', 'S72101Q', 'S72101R', 'S72101S', 'S72102A', 'S72102B', 'S72102C',
        'S72102D', 'S72102E', 'S72102F', 'S72102G', 'S72102H', 'S72102J', 'S72102K', 'S72102M',
        'S72102N', 'S72102P', 'S72102Q', 'S72102R', 'S72102S', 'S72109A', 'S72109B', 'S72109C',
        'S72109D', 'S72109E', 'S72109F', 'S72109G', 'S72109H', 'S72109J', 'S72109K', 'S72109M',
        'S72109N', 'S72109P', 'S72109Q', 'S72109R', 'S72109S', 'S72111A', 'S72111B', 'S72111C',
        'S72111D', 'S72111E', 'S72111F', 'S72111G', 'S72111H', 'S72111J', 'S72111K', 'S72111M',
        'S72111N', 'S72111P', 'S72111Q', 'S72111R', 'S72111S', 'S72112A', 'S72112B', 'S72112C',
        'S72112D', 'S72112E', 'S72112F', 'S72112G', 'S72112H', 'S72112J', 'S72112K', 'S72112M',
        'S72112N', 'S72112P', 'S72112Q', 'S72112R', 'S72112S', 'S72113A', 'S72113B', 'S72113C',
        'S72113D', 'S72113E', 'S72113F', 'S72113G', 'S72113H', 'S72113J', 'S72113K', 'S72113M',
        'S72113N', 'S72113P', 'S72113Q', 'S72113R', 'S72113S', 'S72114A', 'S72114B', 'S72114C',
        'S72114D', 'S72114E', 'S72114F', 'S72114G', 'S72114H', 'S72114J', 'S72114K', 'S72114M',
        'S72114N', 'S72114P', 'S72114Q', 'S72114R', 'S72114S', 'S72115A', 'S72115B', 'S72115C',
        'S72115D', 'S72115E', 'S72115F', 'S72115G', 'S72115H', 'S72115J', 'S72115K', 'S72115M',
        'S72115N', 'S72115P', 'S72115Q', 'S72115R', 'S72115S', 'S72116A', 'S72116B', 'S72116C',
        'S72116D', 'S72116E', 'S72116F', 'S72116G', 'S72116H', 'S72116J', 'S72116K', 'S72116M',
        'S72116N', 'S72116P', 'S72116Q', 'S72116R', 'S72116S', 'S72121A', 'S72121B', 'S72121C',
        'S72121D', 'S72121E', 'S72121F', 'S72121G', 'S72121H', 'S72121J', 'S72121K', 'S72121M',
        'S72121N', 'S72121P', 'S72121Q', 'S72121R', 'S72121S', 'S72122A', 'S72122B', 'S72122C',
        'S72122D', 'S72122E', 'S72122F', 'S72122G', 'S72122H', 'S72122J', 'S72122K', 'S72122M',
        'S72122N', 'S72122P', 'S72122Q', 'S72122R', 'S72122S', 'S72123A', 'S72123B', 'S72123C',
        'S72123D', 'S72123E', 'S72123F', 'S72123G', 'S72123H', 'S72123J', 'S72123K', 'S72123M',
        'S72123N', 'S72123P', 'S72123Q', 'S72123R', 'S72123S', 'S72124A', 'S72124B', 'S72124C',
        'S72124D', 'S72124E', 'S72124F', 'S72124G', 'S72124H', 'S72124J', 'S72124K', 'S72124M',
        'S72124N', 'S72124P', 'S72124Q', 'S72124R', 'S72124S', 'S72125A', 'S72125B', 'S72125C',
        'S72125D', 'S72125E', 'S72125F', 'S72125G', 'S72125H', 'S72125J', 'S72125K', 'S72125M',
        'S72125N', 'S72125P', 'S72125Q', 'S72125R', 'S72125S', 'S72126A', 'S72126B', 'S72126C',
        'S72126D', 'S72126E', 'S72126F', 'S72126G', 'S72126H', 'S72126J', 'S72126K', 'S72126M',
        'S72126N', 'S72126P', 'S72126Q', 'S72126R', 'S72126S', 'S72131A', 'S72131B', 'S72131C',
        'S72131D', 'S72131E', 'S72131F', 'S72131G', 'S72131H', 'S72131J', 'S72131K', 'S72131M',
        'S72131N', 'S72131P', 'S72131Q', 'S72131R', 'S72131S', 'S72132A', 'S72132B', 'S72132C',
        'S72132D', 'S72132E', 'S72132F', 'S72132G', 'S72132H', 'S72132J', 'S72132K', 'S72132M',
        'S72132N', 'S72132P', 'S72132Q', 'S72132R', 'S72132S', 'S72133A', 'S72133B', 'S72133C',
        'S72133D', 'S72133E', 'S72133F', 'S72133G', 'S72133H', 'S72133J', 'S72133K', 'S72133M',
        'S72133N', 'S72133P', 'S72133Q', 'S72133R', 'S72133S', 'S72134A', 'S72134B', 'S72134C',
        'S72134D', 'S72134E', 'S72134F', 'S72134G', 'S72134H', 'S72134J', 'S72134K', 'S72134M',
        'S72134N', 'S72134P', 'S72134Q', 'S72134R', 'S72134S', 'S72135A', 'S72135B', 'S72135C',
        'S72135D', 'S72135E', 'S72135F', 'S72135G', 'S72135H', 'S72135J', 'S72135K', 'S72135M',
        'S72135N', 'S72135P', 'S72135Q', 'S72135R', 'S72135S', 'S72136A', 'S72136B', 'S72136C',
        'S72136D', 'S72136E', 'S72136F', 'S72136G', 'S72136H', 'S72136J', 'S72136K', 'S72136M',
        'S72136N', 'S72136P', 'S72136Q', 'S72136R', 'S72136S', 'S72141A', 'S72141B', 'S72141C',
        'S72141D', 'S72141E', 'S72141F', 'S72141G', 'S72141H', 'S72141J', 'S72141K', 'S72141M',
        'S72141N', 'S72141P', 'S72141Q', 'S72141R', 'S72141S', 'S72142A', 'S72142B', 'S72142C',
        'S72142D', 'S72142E', 'S72142F', 'S72142G', 'S72142H', 'S72142J', 'S72142K', 'S72142M',
        'S72142N', 'S72142P', 'S72142Q', 'S72142R', 'S72142S', 'S72143A', 'S72143B', 'S72143C',
        'S72143D', 'S72143E', 'S72143F', 'S72143G', 'S72143H', 'S72143J', 'S72143K', 'S72143M',
        'S72143N', 'S72143P', 'S72143Q', 'S72143R', 'S72143S', 'S72144A', 'S72144B', 'S72144C',
        'S72144D', 'S72144E', 'S72144F', 'S72144G', 'S72144H', 'S72144J', 'S72144K', 'S72144M',
        'S72144N', 'S72144P', 'S72144Q', 'S72144R', 'S72144S', 'S72145A', 'S72145B', 'S72145C',
        'S72145D', 'S72145E', 'S72145F', 'S72145G', 'S72145H', 'S72145J', 'S72145K', 'S72145M',
        'S72145N', 'S72145P', 'S72145Q', 'S72145R', 'S72145S', 'S72146A', 'S72146B', 'S72146C',
        'S72146D', 'S72146E', 'S72146F', 'S72146G', 'S72146H', 'S72146J', 'S72146K', 'S72146M',
        'S72146N', 'S72146P', 'S72146Q', 'S72146R', 'S72146S', 'S7221XA', 'S7221XB', 'S7221XC',
        'S7221XD', 'S7221XE', 'S7221XF', 'S7221XG', 'S7221XH', 'S7221XJ', 'S7221XK', 'S7221XM',
        'S7221XN', 'S7221XP', 'S7221XQ', 'S7221XR', 'S7221XS', 'S7222XA', 'S7222XB', 'S7222XC',
        'S7222XD', 'S7222XE', 'S7222XF', 'S7222XG', 'S7222XH', 'S7222XJ', 'S7222XK', 'S7222XM',
        'S7222XN', 'S7222XP', 'S7222XQ', 'S7222XR', 'S7222XS', 'S7223XA', 'S7223XB', 'S7223XC',
        'S7223XD', 'S7223XE', 'S7223XF', 'S7223XG', 'S7223XH', 'S7223XJ', 'S7223XK', 'S7223XM',
        'S7223XN', 'S7223XP', 'S7223XQ', 'S7223XR', 'S7223XS', 'S7224XA', 'S7224XB', 'S7224XC',
        'S7224XD', 'S7224XE', 'S7224XF', 'S7224XG', 'S7224XH', 'S7224XJ', 'S7224XK', 'S7224XM',
        'S7224XN', 'S7224XP', 'S7224XQ', 'S7224XR', 'S7224XS', 'S7225XA', 'S7225XB', 'S7225XC',
        'S7225XD', 'S7225XE', 'S7225XF', 'S7225XG', 'S7225XH', 'S7225XJ', 'S7225XK', 'S7225XM',
        'S7225XN', 'S7225XP', 'S7225XQ', 'S7225XR', 'S7225XS', 'S7226XA', 'S7226XB', 'S7226XC',
        'S7226XD', 'S7226XE', 'S7226XF', 'S7226XG', 'S7226XH', 'S7226XJ', 'S7226XK', 'S7226XM',
        'S7226XN', 'S7226XP', 'S7226XQ', 'S7226XR', 'S7226XS', 'S72301A', 'S72301B', 'S72301C',
        'S72301D', 'S72301E', 'S72301F', 'S72301G', 'S72301H', 'S72301J', 'S72301K', 'S72301M',
        'S72301N', 'S72301P', 'S72301Q', 'S72301R', 'S72301S', 'S72302A', 'S72302B', 'S72302C',
        'S72302D', 'S72302E', 'S72302F', 'S72302G', 'S72302H', 'S72302J', 'S72302K', 'S72302M',
        'S72302N', 'S72302P', 'S72302Q', 'S72302R', 'S72302S', 'S72309A', 'S72309B', 'S72309C',
        'S72309D', 'S72309E', 'S72309F', 'S72309G', 'S72309H', 'S72309J', 'S72309K', 'S72309M',
        'S72309N', 'S72309P', 'S72309Q', 'S72309R', 'S72309S', 'S72321A', 'S72321B', 'S72321C',
        'S72321D', 'S72321E', 'S72321F', 'S72321G', 'S72321H', 'S72321J', 'S72321K', 'S72321M',
        'S72321N', 'S72321P', 'S72321Q', 'S72321R', 'S72321S', 'S72322A', 'S72322B', 'S72322C',
        'S72322D', 'S72322E', 'S72322F', 'S72322G', 'S72322H', 'S72322J', 'S72322K', 'S72322M',
        'S72322N', 'S72322P', 'S72322Q', 'S72322R', 'S72322S', 'S72323A', 'S72323B', 'S72323C',
        'S72323D', 'S72323E', 'S72323F', 'S72323G', 'S72323H', 'S72323J', 'S72323K', 'S72323M',
        'S72323N', 'S72323P', 'S72323Q', 'S72323R', 'S72323S', 'S72324A', 'S72324B', 'S72324C',
        'S72324D', 'S72324E', 'S72324F', 'S72324G', 'S72324H', 'S72324J', 'S72324K', 'S72324M',
        'S72324N', 'S72324P', 'S72324Q', 'S72324R', 'S72324S', 'S72325A', 'S72325B', 'S72325C',
        'S72325D', 'S72325E', 'S72325F', 'S72325G', 'S72325H', 'S72325J', 'S72325K', 'S72325M',
        'S72325N', 'S72325P', 'S72325Q', 'S72325R', 'S72325S', 'S72326A', 'S72326B', 'S72326C',
        'S72326D', 'S72326E', 'S72326F', 'S72326G', 'S72326H', 'S72326J', 'S72326K', 'S72326M',
        'S72326N', 'S72326P', 'S72326Q', 'S72326R', 'S72326S', 'S72331A', 'S72331B', 'S72331C',
        'S72331D', 'S72331E', 'S72331F', 'S72331G', 'S72331H', 'S72331J', 'S72331K', 'S72331M',
        'S72331N', 'S72331P', 'S72331Q', 'S72331R', 'S72331S', 'S72332A', 'S72332B', 'S72332C',
        'S72332D', 'S72332E', 'S72332F', 'S72332G', 'S72332H', 'S72332J', 'S72332K', 'S72332M',
        'S72332N', 'S72332P', 'S72332Q', 'S72332R', 'S72332S', 'S72333A', 'S72333B', 'S72333C',
        'S72333D', 'S72333E', 'S72333F', 'S72333G', 'S72333H', 'S72333J', 'S72333K', 'S72333M',
        'S72333N', 'S72333P', 'S72333Q', 'S72333R', 'S72333S', 'S72334A', 'S72334B', 'S72334C',
        'S72334D', 'S72334E', 'S72334F', 'S72334G', 'S72334H', 'S72334J', 'S72334K', 'S72334M',
        'S72334N', 'S72334P', 'S72334Q', 'S72334R', 'S72334S', 'S72335A', 'S72335B', 'S72335C',
        'S72335D', 'S72335E', 'S72335F', 'S72335G', 'S72335H', 'S72335J', 'S72335K', 'S72335M',
        'S72335N', 'S72335P', 'S72335Q', 'S72335R', 'S72335S', 'S72336A', 'S72336B', 'S72336C',
        'S72336D', 'S72336E', 'S72336F', 'S72336G', 'S72336H', 'S72336J', 'S72336K', 'S72336M',
        'S72336N', 'S72336P', 'S72336Q', 'S72336R', 'S72336S', 'S72341A', 'S72341B', 'S72341C',
        'S72341D', 'S72341E', 'S72341F', 'S72341G', 'S72341H', 'S72341J', 'S72341K', 'S72341M',
        'S72341N', 'S72341P', 'S72341Q', 'S72341R', 'S72341S', 'S72342A', 'S72342B', 'S72342C',
        'S72342D', 'S72342E', 'S72342F', 'S72342G', 'S72342H', 'S72342J', 'S72342K', 'S72342M',
        'S72342N', 'S72342P', 'S72342Q', 'S72342R', 'S72342S', 'S72343A', 'S72343B', 'S72343C',
        'S72343D', 'S72343E', 'S72343F', 'S72343G', 'S72343H', 'S72343J', 'S72343K', 'S72343M',
        'S72343N', 'S72343P', 'S72343Q', 'S72343R', 'S72343S', 'S72344A', 'S72344B', 'S72344C',
        'S72344D', 'S72344E', 'S72344F', 'S72344G', 'S72344H', 'S72344J', 'S72344K', 'S72344M',
        'S72344N', 'S72344P', 'S72344Q', 'S72344R', 'S72344S', 'S72345A', 'S72345B', 'S72345C',
        'S72345D', 'S72345E', 'S72345F', 'S72345G', 'S72345H', 'S72345J', 'S72345K', 'S72345M',
        'S72345N', 'S72345P', 'S72345Q', 'S72345R', 'S72345S', 'S72346A', 'S72346B', 'S72346C',
        'S72346D', 'S72346E', 'S72346F', 'S72346G', 'S72346H', 'S72346J', 'S72346K', 'S72346M',
        'S72346N', 'S72346P', 'S72346Q', 'S72346R', 'S72346S', 'S72351A', 'S72351B', 'S72351C',
        'S72351D', 'S72351E', 'S72351F', 'S72351G', 'S72351H', 'S72351J', 'S72351K', 'S72351M',
        'S72351N', 'S72351P', 'S72351Q', 'S72351R', 'S72351S', 'S72352A', 'S72352B', 'S72352C',
        'S72352D', 'S72352E', 'S72352F', 'S72352G', 'S72352H', 'S72352J', 'S72352K', 'S72352M',
        'S72352N', 'S72352P', 'S72352Q', 'S72352R', 'S72352S', 'S72353A', 'S72353B', 'S72353C',
        'S72353D', 'S72353E', 'S72353F', 'S72353G', 'S72353H', 'S72353J', 'S72353K', 'S72353M',
        'S72353N', 'S72353P', 'S72353Q', 'S72353R', 'S72353S', 'S72354A', 'S72354B', 'S72354C',
        'S72354D', 'S72354E', 'S72354F', 'S72354G', 'S72354H', 'S72354J', 'S72354K', 'S72354M',
        'S72354N', 'S72354P', 'S72354Q', 'S72354R', 'S72354S', 'S72355A', 'S72355B', 'S72355C',
        'S72355D', 'S72355E', 'S72355F', 'S72355G', 'S72355H', 'S72355J', 'S72355K', 'S72355M',
        'S72355N', 'S72355P', 'S72355Q', 'S72355R', 'S72355S', 'S72356A', 'S72356B', 'S72356C',
        'S72356D', 'S72356E', 'S72356F', 'S72356G', 'S72356H', 'S72356J', 'S72356K', 'S72356M',
        'S72356N', 'S72356P', 'S72356Q', 'S72356R', 'S72356S', 'S72361A', 'S72361B', 'S72361C',
        'S72361D', 'S72361E', 'S72361F', 'S72361G', 'S72361H', 'S72361J', 'S72361K', 'S72361M',
        'S72361N', 'S72361P', 'S72361Q', 'S72361R', 'S72361S', 'S72362A', 'S72362B', 'S72362C',
        'S72362D', 'S72362E', 'S72362F', 'S72362G', 'S72362H', 'S72362J', 'S72362K', 'S72362M',
        'S72362N', 'S72362P', 'S72362Q', 'S72362R', 'S72362S', 'S72363A', 'S72363B', 'S72363C',
        'S72363D', 'S72363E', 'S72363F', 'S72363G', 'S72363H', 'S72363J', 'S72363K', 'S72363M',
        'S72363N', 'S72363P', 'S72363Q', 'S72363R', 'S72363S', 'S72364A', 'S72364B', 'S72364C',
        'S72364D', 'S72364E', 'S72364F', 'S72364G', 'S72364H', 'S72364J', 'S72364K', 'S72364M',
        'S72364N', 'S72364P', 'S72364Q', 'S72364R', 'S72364S', 'S72365A', 'S72365B', 'S72365C',
        'S72365D', 'S72365E', 'S72365F', 'S72365G', 'S72365H', 'S72365J', 'S72365K', 'S72365M',
        'S72365N', 'S72365P', 'S72365Q', 'S72365R', 'S72365S', 'S72366A', 'S72366B', 'S72366C',
        'S72366D', 'S72366E', 'S72366F', 'S72366G', 'S72366H', 'S72366J', 'S72366K', 'S72366M',
        'S72366N', 'S72366P', 'S72366Q', 'S72366R', 'S72366S', 'S72391A', 'S72391B', 'S72391C',
        'S72391D', 'S72391E', 'S72391F', 'S72391G', 'S72391H', 'S72391J', 'S72391K', 'S72391M',
        'S72391N', 'S72391P', 'S72391Q', 'S72391R', 'S72391S', 'S72392A', 'S72392B', 'S72392C',
        'S72392D', 'S72392E', 'S72392F', 'S72392G', 'S72392H', 'S72392J', 'S72392K', 'S72392M',
        'S72392N', 'S72392P', 'S72392Q', 'S72392R', 'S72392S', 'S72399A', 'S72399B', 'S72399C',
        'S72399D', 'S72399E', 'S72399F', 'S72399G', 'S72399H', 'S72399J', 'S72399K', 'S72399M',
        'S72399N', 'S72399P', 'S72399Q', 'S72399R', 'S72399S', 'S72401A', 'S72401B', 'S72401C',
        'S72401D', 'S72401E', 'S72401F', 'S72401G', 'S72401H', 'S72401J', 'S72401K', 'S72401M',
        'S72401N', 'S72401P', 'S72401Q', 'S72401R', 'S72401S', 'S72402A', 'S72402B', 'S72402C',
        'S72402D', 'S72402E', 'S72402F', 'S72402G', 'S72402H', 'S72402J', 'S72402K', 'S72402M',
        'S72402N', 'S72402P', 'S72402Q', 'S72402R', 'S72402S', 'S72409A', 'S72409B', 'S72409C',
        'S72409D', 'S72409E', 'S72409F', 'S72409G', 'S72409H', 'S72409J', 'S72409K', 'S72409M',
        'S72409N', 'S72409P', 'S72409Q', 'S72409R', 'S72409S', 'S72411A', 'S72411B', 'S72411C',
        'S72411D', 'S72411E', 'S72411F', 'S72411G', 'S72411H', 'S72411J', 'S72411K', 'S72411M',
        'S72411N', 'S72411P', 'S72411Q', 'S72411R', 'S72411S', 'S72412A', 'S72412B', 'S72412C',
        'S72412D', 'S72412E', 'S72412F', 'S72412G', 'S72412H', 'S72412J', 'S72412K', 'S72412M',
        'S72412N', 'S72412P', 'S72412Q', 'S72412R', 'S72412S', 'S72413A', 'S72413B', 'S72413C',
        'S72413D', 'S72413E', 'S72413F', 'S72413G', 'S72413H', 'S72413J', 'S72413K', 'S72413M',
        'S72413N', 'S72413P', 'S72413Q', 'S72413R', 'S72413S', 'S72414A', 'S72414B', 'S72414C',
        'S72414D', 'S72414E', 'S72414F', 'S72414G', 'S72414H', 'S72414J', 'S72414K', 'S72414M',
        'S72414N', 'S72414P', 'S72414Q', 'S72414R', 'S72414S', 'S72415A', 'S72415B', 'S72415C',
        'S72415D', 'S72415E', 'S72415F', 'S72415G', 'S72415H', 'S72415J', 'S72415K', 'S72415M',
        'S72415N', 'S72415P', 'S72415Q', 'S72415R', 'S72415S', 'S72416A', 'S72416B', 'S72416C',
        'S72416D', 'S72416E', 'S72416F', 'S72416G', 'S72416H', 'S72416J', 'S72416K', 'S72416M',
        'S72416N', 'S72416P', 'S72416Q', 'S72416R', 'S72416S', 'S72421A', 'S72421B', 'S72421C',
        'S72421D', 'S72421E', 'S72421F', 'S72421G', 'S72421H', 'S72421J', 'S72421K', 'S72421M',
        'S72421N', 'S72421P', 'S72421Q', 'S72421R', 'S72421S', 'S72422A', 'S72422B', 'S72422C',
        'S72422D', 'S72422E', 'S72422F', 'S72422G', 'S72422H', 'S72422J', 'S72422K', 'S72422M',
        'S72422N', 'S72422P', 'S72422Q', 'S72422R', 'S72422S', 'S72423A', 'S72423B', 'S72423C',
        'S72423D', 'S72423E', 'S72423F', 'S72423G', 'S72423H', 'S72423J', 'S72423K', 'S72423M',
        'S72423N', 'S72423P', 'S72423Q', 'S72423R', 'S72423S', 'S72424A', 'S72424B', 'S72424C',
        'S72424D', 'S72424E', 'S72424F', 'S72424G', 'S72424H', 'S72424J', 'S72424K', 'S72424M',
        'S72424N', 'S72424P', 'S72424Q', 'S72424R', 'S72424S', 'S72425A', 'S72425B', 'S72425C',
        'S72425D', 'S72425E', 'S72425F', 'S72425G', 'S72425H', 'S72425J', 'S72425K', 'S72425M',
        'S72425N', 'S72425P', 'S72425Q', 'S72425R', 'S72425S', 'S72426A', 'S72426B', 'S72426C',
        'S72426D', 'S72426E', 'S72426F', 'S72426G', 'S72426H', 'S72426J', 'S72426K', 'S72426M',
        'S72426N', 'S72426P', 'S72426Q', 'S72426R', 'S72426S', 'S72431A', 'S72431B', 'S72431C',
        'S72431D', 'S72431E', 'S72431F', 'S72431G', 'S72431H', 'S72431J', 'S72431K', 'S72431M',
        'S72431N', 'S72431P', 'S72431Q', 'S72431R', 'S72431S', 'S72432A', 'S72432B', 'S72432C',
        'S72432D', 'S72432E', 'S72432F', 'S72432G', 'S72432H', 'S72432J', 'S72432K', 'S72432M',
        'S72432N', 'S72432P', 'S72432Q', 'S72432R', 'S72432S', 'S72433A', 'S72433B', 'S72433C',
        'S72433D', 'S72433E', 'S72433F', 'S72433G', 'S72433H', 'S72433J', 'S72433K', 'S72433M',
        'S72433N', 'S72433P', 'S72433Q', 'S72433R', 'S72433S', 'S72434A', 'S72434B', 'S72434C',
        'S72434D', 'S72434E', 'S72434F', 'S72434G', 'S72434H', 'S72434J', 'S72434K', 'S72434M',
        'S72434N', 'S72434P', 'S72434Q', 'S72434R', 'S72434S', 'S72435A', 'S72435B', 'S72435C',
        'S72435D', 'S72435E', 'S72435F', 'S72435G', 'S72435H', 'S72435J', 'S72435K', 'S72435M',
        'S72435N', 'S72435P', 'S72435Q', 'S72435R', 'S72435S', 'S72436A', 'S72436B', 'S72436C',
        'S72436D', 'S72436E', 'S72436F', 'S72436G', 'S72436H', 'S72436J', 'S72436K', 'S72436M',
        'S72436N', 'S72436P', 'S72436Q', 'S72436R', 'S72436S', 'S72441A', 'S72441B', 'S72441C',
        'S72441D', 'S72441E', 'S72441F', 'S72441G', 'S72441H', 'S72441J', 'S72441K', 'S72441M',
        'S72441N', 'S72441P', 'S72441Q', 'S72441R', 'S72441S', 'S72442A', 'S72442B', 'S72442C',
        'S72442D', 'S72442E', 'S72442F', 'S72442G', 'S72442H', 'S72442J', 'S72442K', 'S72442M',
        'S72442N', 'S72442P', 'S72442Q', 'S72442R', 'S72442S', 'S72443A', 'S72443B', 'S72443C',
        'S72443D', 'S72443E', 'S72443F', 'S72443G', 'S72443H', 'S72443J', 'S72443K', 'S72443M',
        'S72443N', 'S72443P', 'S72443Q', 'S72443R', 'S72443S', 'S72444A', 'S72444B', 'S72444C',
        'S72444D', 'S72444E', 'S72444F', 'S72444G', 'S72444H', 'S72444J', 'S72444K', 'S72444M',
        'S72444N', 'S72444P', 'S72444Q', 'S72444R', 'S72444S', 'S72445A', 'S72445B', 'S72445C',
        'S72445D', 'S72445E', 'S72445F', 'S72445G', 'S72445H', 'S72445J', 'S72445K', 'S72445M',
        'S72445N', 'S72445P', 'S72445Q', 'S72445R', 'S72445S', 'S72446A', 'S72446B', 'S72446C',
        'S72446D', 'S72446E', 'S72446F', 'S72446G', 'S72446H', 'S72446J', 'S72446K', 'S72446M',
        'S72446N', 'S72446P', 'S72446Q', 'S72446R', 'S72446S', 'S72451A', 'S72451B', 'S72451C',
        'S72451D', 'S72451E', 'S72451F', 'S72451G', 'S72451H', 'S72451J', 'S72451K', 'S72451M',
        'S72451N', 'S72451P', 'S72451Q', 'S72451R', 'S72451S', 'S72452A', 'S72452B', 'S72452C',
        'S72452D', 'S72452E', 'S72452F', 'S72452G', 'S72452H', 'S72452J', 'S72452K', 'S72452M',
        'S72452N', 'S72452P', 'S72452Q', 'S72452R', 'S72452S', 'S72453A', 'S72453B', 'S72453C',
        'S72453D', 'S72453E', 'S72453F', 'S72453G', 'S72453H', 'S72453J', 'S72453K', 'S72453M',
        'S72453N', 'S72453P', 'S72453Q', 'S72453R', 'S72453S', 'S72454A', 'S72454B', 'S72454C',
        'S72454D', 'S72454E', 'S72454F', 'S72454G', 'S72454H', 'S72454J', 'S72454K', 'S72454M',
        'S72454N', 'S72454P', 'S72454Q', 'S72454R', 'S72454S', 'S72455A', 'S72455B', 'S72455C',
        'S72455D', 'S72455E', 'S72455F', 'S72455G', 'S72455H', 'S72455J', 'S72455K', 'S72455M',
        'S72455N', 'S72455P', 'S72455Q', 'S72455R', 'S72455S', 'S72456A', 'S72456B', 'S72456C',
        'S72456D', 'S72456E', 'S72456F', 'S72456G', 'S72456H', 'S72456J', 'S72456K', 'S72456M',
        'S72456N', 'S72456P', 'S72456Q', 'S72456R', 'S72456S', 'S72461A', 'S72461B', 'S72461C',
        'S72461D', 'S72461E', 'S72461F', 'S72461G', 'S72461H', 'S72461J', 'S72461K', 'S72461M',
        'S72461N', 'S72461P', 'S72461Q', 'S72461R', 'S72461S', 'S72462A', 'S72462B', 'S72462C',
        'S72462D', 'S72462E', 'S72462F', 'S72462G', 'S72462H', 'S72462J', 'S72462K', 'S72462M',
        'S72462N', 'S72462P', 'S72462Q', 'S72462R', 'S72462S', 'S72463A', 'S72463B', 'S72463C',
        'S72463D', 'S72463E', 'S72463F', 'S72463G', 'S72463H', 'S72463J', 'S72463K', 'S72463M',
        'S72463N', 'S72463P', 'S72463Q', 'S72463R', 'S72463S', 'S72464A', 'S72464B', 'S72464C',
        'S72464D', 'S72464E', 'S72464F', 'S72464G', 'S72464H', 'S72464J', 'S72464K', 'S72464M',
        'S72464N', 'S72464P', 'S72464Q', 'S72464R', 'S72464S', 'S72465A', 'S72465B', 'S72465C',
        'S72465D', 'S72465E', 'S72465F', 'S72465G', 'S72465H', 'S72465J', 'S72465K', 'S72465M',
        'S72465N', 'S72465P', 'S72465Q', 'S72465R', 'S72465S', 'S72466A', 'S72466B', 'S72466C',
        'S72466D', 'S72466E', 'S72466F', 'S72466G', 'S72466H', 'S72466J', 'S72466K', 'S72466M',
        'S72466N', 'S72466P', 'S72466Q', 'S72466R', 'S72466S', 'S72471A', 'S72471D', 'S72471G',
        'S72471K', 'S72471P', 'S72471S', 'S72472A', 'S72472D', 'S72472G', 'S72472K', 'S72472P',
        'S72472S', 'S72479A', 'S72479D', 'S72479G', 'S72479K', 'S72479P', 'S72479S', 'S72491A',
        'S72491B', 'S72491C', 'S72491D', 'S72491E', 'S72491F', 'S72491G', 'S72491H', 'S72491J',
        'S72491K', 'S72491M', 'S72491N', 'S72491P', 'S72491Q', 'S72491R', 'S72491S', 'S72492A',
        'S72492B', 'S72492C', 'S72492D', 'S72492E', 'S72492F', 'S72492G', 'S72492H', 'S72492J',
        'S72492K', 'S72492M', 'S72492N', 'S72492P', 'S72492Q', 'S72492R', 'S72492S', 'S72499A',
        'S72499B', 'S72499C', 'S72499D', 'S72499E', 'S72499F', 'S72499G', 'S72499H', 'S72499J',
        'S72499K', 'S72499M', 'S72499N', 'S72499P', 'S72499Q', 'S72499R', 'S72499S', 'S728X1A',
        'S728X1B', 'S728X1C', 'S728X1D', 'S728X1E', 'S728X1F', 'S728X1G', 'S728X1H', 'S728X1J',
        'S728X1K', 'S728X1M', 'S728X1N', 'S728X1P', 'S728X1Q', 'S728X1R', 'S728X1S', 'S728X2A',
        'S728X2B', 'S728X2C', 'S728X2D', 'S728X2E', 'S728X2F', 'S728X2G', 'S728X2H', 'S728X2J',
        'S728X2K', 'S728X2M', 'S728X2N', 'S728X2P', 'S728X2Q', 'S728X2R', 'S728X2S', 'S728X9A',
        'S728X9B', 'S728X9C', 'S728X9D', 'S728X9E', 'S728X9F', 'S728X9G', 'S728X9H', 'S728X9J',
        'S728X9K', 'S728X9M', 'S728X9N', 'S728X9P', 'S728X9Q', 'S728X9R', 'S728X9S', 'S7290XA',
        'S7290XB', 'S7290XC', 'S7290XD', 'S7290XE', 'S7290XF', 'S7290XG', 'S7290XH', 'S7290XJ',
        'S7290XK', 'S7290XM', 'S7290XN', 'S7290XP', 'S7290XQ', 'S7290XR', 'S7290XS', 'S7291XA',
        'S7291XB', 'S7291XC', 'S7291XD', 'S7291XE', 'S7291XF', 'S7291XG', 'S7291XH', 'S7291XJ',
        'S7291XK', 'S7291XM', 'S7291XN', 'S7291XP', 'S7291XQ', 'S7291XR', 'S7291XS', 'S7292XA',
        'S7292XB', 'S7292XC', 'S7292XD', 'S7292XE', 'S7292XF', 'S7292XG', 'S7292XH', 'S7292XJ',
        'S7292XK', 'S7292XM', 'S7292XN', 'S7292XP', 'S7292XQ', 'S7292XR', 'S7292XS', 'S73004A',
        'S73004D', 'S73004S', 'S73005A', 'S73005D', 'S73005S', 'S73006A', 'S73006D', 'S73006S',
        'S73014A', 'S73014D', 'S73014S', 'S73015A', 'S73015D', 'S73015S', 'S73016A', 'S73016D',
        'S73016S', 'S73024A', 'S73024D', 'S73024S', 'S73025A', 'S73025D', 'S73025S', 'S73026A',
        'S73026D', 'S73026S', 'S73034A', 'S73034D', 'S73034S', 'S73035A', 'S73035D', 'S73035S',
        'S73036A', 'S73036D', 'S73036S', 'S73044A', 'S73044D', 'S73044S', 'S73045A', 'S73045D',
        'S73045S', 'S73046A', 'S73046D', 'S73046S', 'S79001A', 'S79001D', 'S79001G', 'S79001K',
        'S79001P', 'S79001S', 'S79002A', 'S79002D', 'S79002G', 'S79002K', 'S79002P', 'S79002S',
        'S79009A', 'S79009D', 'S79009G', 'S79009K', 'S79009P', 'S79009S', 'S79011A', 'S79011D',
        'S79011G', 'S79011K', 'S79011P', 'S79011S', 'S79012A', 'S79012D', 'S79012G', 'S79012K',
        'S79012P', 'S79012S', 'S79019A', 'S79019D', 'S79019G', 'S79019K', 'S79019P', 'S79019S',
        'S79091A', 'S79091D', 'S79091G', 'S79091K', 'S79091P', 'S79091S', 'S79092A', 'S79092D',
        'S79092G', 'S79092K', 'S79092P', 'S79092S', 'S79099A', 'S79099D', 'S79099G', 'S79099K',
        'S79099P', 'S79099S', 'S79101A', 'S79101D', 'S79101G', 'S79101K', 'S79101P', 'S79101S',
        'S79102A', 'S79102D', 'S79102G', 'S79102K', 'S79102P', 'S79102S', 'S79109A', 'S79109D',
        'S79109G', 'S79109K', 'S79109P', 'S79109S', 'S79111A', 'S79111D', 'S79111G', 'S79111K',
        'S79111P', 'S79111S', 'S79112A', 'S79112D', 'S79112G', 'S79112K', 'S79112P', 'S79112S',
        'S79119A', 'S79119D', 'S79119G', 'S79119K', 'S79119P', 'S79119S', 'S79121A', 'S79121D',
        'S79121G', 'S79121K', 'S79121P', 'S79121S', 'S79122A', 'S79122D', 'S79122G', 'S79122K',
        'S79122P', 'S79122S', 'S79129A', 'S79129D', 'S79129G', 'S79129K', 'S79129P', 'S79129S',
        'S79131A', 'S79131D', 'S79131G', 'S79131K', 'S79131P', 'S79131S', 'S79132A', 'S79132D',
        'S79132G', 'S79132K', 'S79132P', 'S79132S', 'S79139A', 'S79139D', 'S79139G', 'S79139K',
        'S79139P', 'S79139S', 'S79141A', 'S79141D', 'S79141G', 'S79141K', 'S79141P', 'S79141S',
        'S79142A', 'S79142D', 'S79142G', 'S79142K', 'S79142P', 'S79142S', 'S79149A', 'S79149D',
        'S79149G', 'S79149K', 'S79149P', 'S79149S', 'S79191A', 'S79191D', 'S79191G', 'S79191K',
        'S79191P', 'S79191S', 'S79192A', 'S79192D', 'S79192G', 'S79192K', 'S79192P', 'S79192S',
        'S79199A', 'S79199D', 'S79199G', 'S79199K', 'S79199P', 'S79199S', 'S82001A', 'S82001B',
        'S82001C', 'S82001D', 'S82001E', 'S82001F', 'S82001G', 'S82001H', 'S82001J', 'S82001K',
        'S82001M', 'S82001N', 'S82001P', 'S82001Q', 'S82001R', 'S82001S', 'S82002A', 'S82002B',
        'S82002C', 'S82002D', 'S82002E', 'S82002F', 'S82002G', 'S82002H', 'S82002J', 'S82002K',
        'S82002M', 'S82002N', 'S82002P', 'S82002Q', 'S82002R', 'S82002S', 'S82009A', 'S82009B',
        'S82009C', 'S82009D', 'S82009E', 'S82009F', 'S82009G', 'S82009H', 'S82009J', 'S82009K',
        'S82009M', 'S82009N', 'S82009P', 'S82009Q', 'S82009R', 'S82009S', 'S82011A', 'S82011B',
        'S82011C', 'S82011D', 'S82011E', 'S82011F', 'S82011G', 'S82011H', 'S82011J', 'S82011K',
        'S82011M', 'S82011N', 'S82011P', 'S82011Q', 'S82011R', 'S82011S', 'S82012A', 'S82012B',
        'S82012C', 'S82012D', 'S82012E', 'S82012F', 'S82012G', 'S82012H', 'S82012J', 'S82012K',
        'S82012M', 'S82012N', 'S82012P', 'S82012Q', 'S82012R', 'S82012S', 'S82013A', 'S82013B',
        'S82013C', 'S82013D', 'S82013E', 'S82013F', 'S82013G', 'S82013H', 'S82013J', 'S82013K',
        'S82013M', 'S82013N', 'S82013P', 'S82013Q', 'S82013R', 'S82013S', 'S82014A', 'S82014B',
        'S82014C', 'S82014D', 'S82014E', 'S82014F', 'S82014G', 'S82014H', 'S82014J', 'S82014K',
        'S82014M', 'S82014N', 'S82014P', 'S82014Q', 'S82014R', 'S82014S', 'S82015A', 'S82015B',
        'S82015C', 'S82015D', 'S82015E', 'S82015F', 'S82015G', 'S82015H', 'S82015J', 'S82015K',
        'S82015M', 'S82015N', 'S82015P', 'S82015Q', 'S82015R', 'S82015S', 'S82016A', 'S82016B',
        'S82016C', 'S82016D', 'S82016E', 'S82016F', 'S82016G', 'S82016H', 'S82016J', 'S82016K',
        'S82016M', 'S82016N', 'S82016P', 'S82016Q', 'S82016R', 'S82016S', 'S82021A', 'S82021B',
        'S82021C', 'S82021D', 'S82021E', 'S82021F', 'S82021G', 'S82021H', 'S82021J', 'S82021K',
        'S82021M', 'S82021N', 'S82021P', 'S82021Q', 'S82021R', 'S82021S', 'S82022A', 'S82022B',
        'S82022C', 'S82022D', 'S82022E', 'S82022F', 'S82022G', 'S82022H', 'S82022J', 'S82022K',
        'S82022M', 'S82022N', 'S82022P', 'S82022Q', 'S82022R', 'S82022S', 'S82023A', 'S82023B',
        'S82023C', 'S82023D', 'S82023E', 'S82023F', 'S82023G', 'S82023H', 'S82023J', 'S82023K',
        'S82023M', 'S82023N', 'S82023P', 'S82023Q', 'S82023R', 'S82023S', 'S82024A', 'S82024B',
        'S82024C', 'S82024D', 'S82024E', 'S82024F', 'S82024G', 'S82024H', 'S82024J', 'S82024K',
        'S82024M', 'S82024N', 'S82024P', 'S82024Q', 'S82024R', 'S82024S', 'S82025A', 'S82025B',
        'S82025C', 'S82025D', 'S82025E', 'S82025F', 'S82025G', 'S82025H', 'S82025J', 'S82025K',
        'S82025M', 'S82025N', 'S82025P', 'S82025Q', 'S82025R', 'S82025S', 'S82026A', 'S82026B',
        'S82026C', 'S82026D', 'S82026E', 'S82026F', 'S82026G', 'S82026H', 'S82026J', 'S82026K',
        'S82026M', 'S82026N', 'S82026P', 'S82026Q', 'S82026R', 'S82026S', 'S82031A', 'S82031B',
        'S82031C', 'S82031D', 'S82031E', 'S82031F', 'S82031G', 'S82031H', 'S82031J', 'S82031K',
        'S82031M', 'S82031N', 'S82031P', 'S82031Q', 'S82031R', 'S82031S', 'S82032A', 'S82032B',
        'S82032C', 'S82032D', 'S82032E', 'S82032F', 'S82032G', 'S82032H', 'S82032J', 'S82032K',
        'S82032M', 'S82032N', 'S82032P', 'S82032Q', 'S82032R', 'S82032S', 'S82033A', 'S82033B',
        'S82033C', 'S82033D', 'S82033E', 'S82033F', 'S82033G', 'S82033H', 'S82033J', 'S82033K',
        'S82033M', 'S82033N', 'S82033P', 'S82033Q', 'S82033R', 'S82033S', 'S82034A', 'S82034B',
        'S82034C', 'S82034D', 'S82034E', 'S82034F', 'S82034G', 'S82034H', 'S82034J', 'S82034K',
        'S82034M', 'S82034N', 'S82034P', 'S82034Q', 'S82034R', 'S82034S', 'S82035A', 'S82035B',
        'S82035C', 'S82035D', 'S82035E', 'S82035F', 'S82035G', 'S82035H', 'S82035J', 'S82035K',
        'S82035M', 'S82035N', 'S82035P', 'S82035Q', 'S82035R', 'S82035S', 'S82036A', 'S82036B',
        'S82036C', 'S82036D', 'S82036E', 'S82036F', 'S82036G', 'S82036H', 'S82036J', 'S82036K',
        'S82036M', 'S82036N', 'S82036P', 'S82036Q', 'S82036R', 'S82036S', 'S82041A', 'S82041B',
        'S82041C', 'S82041D', 'S82041E', 'S82041F', 'S82041G', 'S82041H', 'S82041J', 'S82041K',
        'S82041M', 'S82041N', 'S82041P', 'S82041Q', 'S82041R', 'S82041S', 'S82042A', 'S82042B',
        'S82042C', 'S82042D', 'S82042E', 'S82042F', 'S82042G', 'S82042H', 'S82042J', 'S82042K',
        'S82042M', 'S82042N', 'S82042P', 'S82042Q', 'S82042R', 'S82042S', 'S82043A', 'S82043B',
        'S82043C', 'S82043D', 'S82043E', 'S82043F', 'S82043G', 'S82043H', 'S82043J', 'S82043K',
        'S82043M', 'S82043N', 'S82043P', 'S82043Q', 'S82043R', 'S82043S', 'S82044A', 'S82044B',
        'S82044C', 'S82044D', 'S82044E', 'S82044F', 'S82044G', 'S82044H', 'S82044J', 'S82044K',
        'S82044M', 'S82044N', 'S82044P', 'S82044Q', 'S82044R', 'S82044S', 'S82045A', 'S82045B',
        'S82045C', 'S82045D', 'S82045E', 'S82045F', 'S82045G', 'S82045H', 'S82045J', 'S82045K',
        'S82045M', 'S82045N', 'S82045P', 'S82045Q', 'S82045R', 'S82045S', 'S82046A', 'S82046B',
        'S82046C', 'S82046D', 'S82046E', 'S82046F', 'S82046G', 'S82046H', 'S82046J', 'S82046K',
        'S82046M', 'S82046N', 'S82046P', 'S82046Q', 'S82046R', 'S82046S', 'S82091A', 'S82091B',
        'S82091C', 'S82091D', 'S82091E', 'S82091F', 'S82091G', 'S82091H', 'S82091J', 'S82091K',
        'S82091M', 'S82091N', 'S82091P', 'S82091Q', 'S82091R', 'S82091S', 'S82092A', 'S82092B',
        'S82092C', 'S82092D', 'S82092E', 'S82092F', 'S82092G', 'S82092H', 'S82092J', 'S82092K',
        'S82092M', 'S82092N', 'S82092P', 'S82092Q', 'S82092R', 'S82092S', 'S82099A', 'S82099B',
        'S82099C', 'S82099D', 'S82099E', 'S82099F', 'S82099G', 'S82099H', 'S82099J', 'S82099K',
        'S82099M', 'S82099N', 'S82099P', 'S82099Q', 'S82099R', 'S82099S', 'S82101A', 'S82101B',
        'S82101C', 'S82101D', 'S82101E', 'S82101F', 'S82101G', 'S82101H', 'S82101J', 'S82101K',
        'S82101M', 'S82101N', 'S82101P', 'S82101Q', 'S82101R', 'S82101S', 'S82102A', 'S82102B',
        'S82102C', 'S82102D', 'S82102E', 'S82102F', 'S82102G', 'S82102H', 'S82102J', 'S82102K',
        'S82102M', 'S82102N', 'S82102P', 'S82102Q', 'S82102R', 'S82102S', 'S82109A', 'S82109B',
        'S82109C', 'S82109D', 'S82109E', 'S82109F', 'S82109G', 'S82109H', 'S82109J', 'S82109K',
        'S82109M', 'S82109N', 'S82109P', 'S82109Q', 'S82109R', 'S82109S', 'S82111A', 'S82111B',
        'S82111C', 'S82111D', 'S82111E', 'S82111F', 'S82111G', 'S82111H', 'S82111J', 'S82111K',
        'S82111M', 'S82111N', 'S82111P', 'S82111Q', 'S82111R', 'S82111S', 'S82112A', 'S82112B',
        'S82112C', 'S82112D', 'S82112E', 'S82112F', 'S82112G', 'S82112H', 'S82112J', 'S82112K',
        'S82112M', 'S82112N', 'S82112P', 'S82112Q', 'S82112R', 'S82112S', 'S82113A', 'S82113B',
        'S82113C', 'S82113D', 'S82113E', 'S82113F', 'S82113G', 'S82113H', 'S82113J', 'S82113K',
        'S82113M', 'S82113N', 'S82113P', 'S82113Q', 'S82113R', 'S82113S', 'S82114A', 'S82114B',
        'S82114C', 'S82114D', 'S82114E', 'S82114F', 'S82114G', 'S82114H', 'S82114J', 'S82114K',
        'S82114M', 'S82114N', 'S82114P', 'S82114Q', 'S82114R', 'S82114S', 'S82115A', 'S82115B',
        'S82115C', 'S82115D', 'S82115E', 'S82115F', 'S82115G', 'S82115H', 'S82115J', 'S82115K',
        'S82115M', 'S82115N', 'S82115P', 'S82115Q', 'S82115R', 'S82115S', 'S82116A', 'S82116B',
        'S82116C', 'S82116D', 'S82116E', 'S82116F', 'S82116G', 'S82116H', 'S82116J', 'S82116K',
        'S82116M', 'S82116N', 'S82116P', 'S82116Q', 'S82116R', 'S82116S', 'S82121A', 'S82121B',
        'S82121C', 'S82121D', 'S82121E', 'S82121F', 'S82121G', 'S82121H', 'S82121J', 'S82121K',
        'S82121M', 'S82121N', 'S82121P', 'S82121Q', 'S82121R', 'S82121S', 'S82122A', 'S82122B',
        'S82122C', 'S82122D', 'S82122E', 'S82122F', 'S82122G', 'S82122H', 'S82122J', 'S82122K',
        'S82122M', 'S82122N', 'S82122P', 'S82122Q', 'S82122R', 'S82122S', 'S82123A', 'S82123B',
        'S82123C', 'S82123D', 'S82123E', 'S82123F', 'S82123G', 'S82123H', 'S82123J', 'S82123K',
        'S82123M', 'S82123N', 'S82123P', 'S82123Q', 'S82123R', 'S82123S', 'S82124A', 'S82124B',
        'S82124C', 'S82124D', 'S82124E', 'S82124F', 'S82124G', 'S82124H', 'S82124J', 'S82124K',
        'S82124M', 'S82124N', 'S82124P', 'S82124Q', 'S82124R', 'S82124S', 'S82125A', 'S82125B',
        'S82125C', 'S82125D', 'S82125E', 'S82125F', 'S82125G', 'S82125H', 'S82125J', 'S82125K',
        'S82125M', 'S82125N', 'S82125P', 'S82125Q', 'S82125R', 'S82125S', 'S82126A', 'S82126B',
        'S82126C', 'S82126D', 'S82126E', 'S82126F', 'S82126G', 'S82126H', 'S82126J', 'S82126K',
        'S82126M', 'S82126N', 'S82126P', 'S82126Q', 'S82126R', 'S82126S', 'S82131A', 'S82131B',
        'S82131C', 'S82131D', 'S82131E', 'S82131F', 'S82131G', 'S82131H', 'S82131J', 'S82131K',
        'S82131M', 'S82131N', 'S82131P', 'S82131Q', 'S82131R', 'S82131S', 'S82132A', 'S82132B',
        'S82132C', 'S82132D', 'S82132E', 'S82132F', 'S82132G', 'S82132H', 'S82132J', 'S82132K',
        'S82132M', 'S82132N', 'S82132P', 'S82132Q', 'S82132R', 'S82132S', 'S82133A', 'S82133B',
        'S82133C', 'S82133D', 'S82133E', 'S82133F', 'S82133G', 'S82133H', 'S82133J', 'S82133K',
        'S82133M', 'S82133N', 'S82133P', 'S82133Q', 'S82133R', 'S82133S', 'S82134A', 'S82134B',
        'S82134C', 'S82134D', 'S82134E', 'S82134F', 'S82134G', 'S82134H', 'S82134J', 'S82134K',
        'S82134M', 'S82134N', 'S82134P', 'S82134Q', 'S82134R', 'S82134S', 'S82135A', 'S82135B',
        'S82135C', 'S82135D', 'S82135E', 'S82135F', 'S82135G', 'S82135H', 'S82135J', 'S82135K',
        'S82135M', 'S82135N', 'S82135P', 'S82135Q', 'S82135R', 'S82135S', 'S82136A', 'S82136B',
        'S82136C', 'S82136D', 'S82136E', 'S82136F', 'S82136G', 'S82136H', 'S82136J', 'S82136K',
        'S82136M', 'S82136N', 'S82136P', 'S82136Q', 'S82136R', 'S82136S', 'S82141A', 'S82141B',
        'S82141C', 'S82141D', 'S82141E', 'S82141F', 'S82141G', 'S82141H', 'S82141J', 'S82141K',
        'S82141M', 'S82141N', 'S82141P', 'S82141Q', 'S82141R', 'S82141S', 'S82142A', 'S82142B',
        'S82142C', 'S82142D', 'S82142E', 'S82142F', 'S82142G', 'S82142H', 'S82142J', 'S82142K',
        'S82142M', 'S82142N', 'S82142P', 'S82142Q', 'S82142R', 'S82142S', 'S82143A', 'S82143B',
        'S82143C', 'S82143D', 'S82143E', 'S82143F', 'S82143G', 'S82143H', 'S82143J', 'S82143K',
        'S82143M', 'S82143N', 'S82143P', 'S82143Q', 'S82143R', 'S82143S', 'S82144A', 'S82144B',
        'S82144C', 'S82144D', 'S82144E', 'S82144F', 'S82144G', 'S82144H', 'S82144J', 'S82144K',
        'S82144M', 'S82144N', 'S82144P', 'S82144Q', 'S82144R', 'S82144S', 'S82145A', 'S82145B',
        'S82145C', 'S82145D', 'S82145E', 'S82145F', 'S82145G', 'S82145H', 'S82145J', 'S82145K',
        'S82145M', 'S82145N', 'S82145P', 'S82145Q', 'S82145R', 'S82145S', 'S82146A', 'S82146B',
        'S82146C', 'S82146D', 'S82146E', 'S82146F', 'S82146G', 'S82146H', 'S82146J', 'S82146K',
        'S82146M', 'S82146N', 'S82146P', 'S82146Q', 'S82146R', 'S82146S', 'S82151A', 'S82151B',
        'S82151C', 'S82151D', 'S82151E', 'S82151F', 'S82151G', 'S82151H', 'S82151J', 'S82151K',
        'S82151M', 'S82151N', 'S82151P', 'S82151Q', 'S82151R', 'S82151S', 'S82152A', 'S82152B',
        'S82152C', 'S82152D', 'S82152E', 'S82152F', 'S82152G', 'S82152H', 'S82152J', 'S82152K',
        'S82152M', 'S82152N', 'S82152P', 'S82152Q', 'S82152R', 'S82152S', 'S82153A', 'S82153B',
        'S82153C', 'S82153D', 'S82153E', 'S82153F', 'S82153G', 'S82153H', 'S82153J', 'S82153K',
        'S82153M', 'S82153N', 'S82153P', 'S82153Q', 'S82153R', 'S82153S', 'S82154A', 'S82154B',
        'S82154C', 'S82154D', 'S82154E', 'S82154F', 'S82154G', 'S82154H', 'S82154J', 'S82154K',
        'S82154M', 'S82154N', 'S82154P', 'S82154Q', 'S82154R', 'S82154S', 'S82155A', 'S82155B',
        'S82155C', 'S82155D', 'S82155E', 'S82155F', 'S82155G', 'S82155H', 'S82155J', 'S82155K',
        'S82155M', 'S82155N', 'S82155P', 'S82155Q', 'S82155R', 'S82155S', 'S82156A', 'S82156B',
        'S82156C', 'S82156D', 'S82156E', 'S82156F', 'S82156G', 'S82156H', 'S82156J', 'S82156K',
        'S82156M', 'S82156N', 'S82156P', 'S82156Q', 'S82156R', 'S82156S', 'S82161A', 'S82161D',
        'S82161G', 'S82161K', 'S82161P', 'S82161S', 'S82162A', 'S82162D', 'S82162G', 'S82162K',
        'S82162P', 'S82162S', 'S82169A', 'S82169D', 'S82169G', 'S82169K', 'S82169P', 'S82169S',
        'S82191A', 'S82191B', 'S82191C', 'S82191D', 'S82191E', 'S82191F', 'S82191G', 'S82191H',
        'S82191J', 'S82191K', 'S82191M', 'S82191N', 'S82191P', 'S82191Q', 'S82191R', 'S82191S',
        'S82192A', 'S82192B', 'S82192C', 'S82192D', 'S82192E', 'S82192F', 'S82192G', 'S82192H',
        'S82192J', 'S82192K', 'S82192M', 'S82192N', 'S82192P', 'S82192Q', 'S82192R', 'S82192S',
        'S82199A', 'S82199B', 'S82199C', 'S82199D', 'S82199E', 'S82199F', 'S82199G', 'S82199H',
        'S82199J', 'S82199K', 'S82199M', 'S82199N', 'S82199P', 'S82199Q', 'S82199R', 'S82199S',
        'S82201A', 'S82201B', 'S82201C', 'S82201D', 'S82201E', 'S82201F', 'S82201G', 'S82201H',
        'S82201J', 'S82201K', 'S82201M', 'S82201N', 'S82201P', 'S82201Q', 'S82201R', 'S82201S',
        'S82202A', 'S82202B', 'S82202C', 'S82202D', 'S82202E', 'S82202F', 'S82202G', 'S82202H',
        'S82202J', 'S82202K', 'S82202M', 'S82202N', 'S82202P', 'S82202Q', 'S82202R', 'S82202S',
        'S82209A', 'S82209B', 'S82209C', 'S82209D', 'S82209E', 'S82209F', 'S82209G', 'S82209H',
        'S82209J', 'S82209K', 'S82209M', 'S82209N', 'S82209P', 'S82209Q', 'S82209R', 'S82209S',
        'S82221A', 'S82221B', 'S82221C', 'S82221D', 'S82221E', 'S82221F', 'S82221G', 'S82221H',
        'S82221J', 'S82221K', 'S82221M', 'S82221N', 'S82221P', 'S82221Q', 'S82221R', 'S82221S',
        'S82222A', 'S82222B', 'S82222C', 'S82222D', 'S82222E', 'S82222F', 'S82222G', 'S82222H',
        'S82222J', 'S82222K', 'S82222M', 'S82222N', 'S82222P', 'S82222Q', 'S82222R', 'S82222S',
        'S82223A', 'S82223B', 'S82223C', 'S82223D', 'S82223E', 'S82223F', 'S82223G', 'S82223H',
        'S82223J', 'S82223K', 'S82223M', 'S82223N', 'S82223P', 'S82223Q', 'S82223R', 'S82223S',
        'S82224A', 'S82224B', 'S82224C', 'S82224D', 'S82224E', 'S82224F', 'S82224G', 'S82224H',
        'S82224J', 'S82224K', 'S82224M', 'S82224N', 'S82224P', 'S82224Q', 'S82224R', 'S82224S',
        'S82225A', 'S82225B', 'S82225C', 'S82225D', 'S82225E', 'S82225F', 'S82225G', 'S82225H',
        'S82225J', 'S82225K', 'S82225M', 'S82225N', 'S82225P', 'S82225Q', 'S82225R', 'S82225S',
        'S82226A', 'S82226B', 'S82226C', 'S82226D', 'S82226E', 'S82226F', 'S82226G', 'S82226H',
        'S82226J', 'S82226K', 'S82226M', 'S82226N', 'S82226P', 'S82226Q', 'S82226R', 'S82226S',
        'S82231A', 'S82231B', 'S82231C', 'S82231D', 'S82231E', 'S82231F', 'S82231G', 'S82231H',
        'S82231J', 'S82231K', 'S82231M', 'S82231N', 'S82231P', 'S82231Q', 'S82231R', 'S82231S',
        'S82232A', 'S82232B', 'S82232C', 'S82232D', 'S82232E', 'S82232F', 'S82232G', 'S82232H',
        'S82232J', 'S82232K', 'S82232M', 'S82232N', 'S82232P', 'S82232Q', 'S82232R', 'S82232S',
        'S82233A', 'S82233B', 'S82233C', 'S82233D', 'S82233E', 'S82233F', 'S82233G', 'S82233H',
        'S82233J', 'S82233K', 'S82233M', 'S82233N', 'S82233P', 'S82233Q', 'S82233R', 'S82233S',
        'S82234A', 'S82234B', 'S82234C', 'S82234D', 'S82234E', 'S82234F', 'S82234G', 'S82234H',
        'S82234J', 'S82234K', 'S82234M', 'S82234N', 'S82234P', 'S82234Q', 'S82234R', 'S82234S',
        'S82235A', 'S82235B', 'S82235C', 'S82235D', 'S82235E', 'S82235F', 'S82235G', 'S82235H',
        'S82235J', 'S82235K', 'S82235M', 'S82235N', 'S82235P', 'S82235Q', 'S82235R', 'S82235S',
        'S82236A', 'S82236B', 'S82236C', 'S82236D', 'S82236E', 'S82236F', 'S82236G', 'S82236H',
        'S82236J', 'S82236K', 'S82236M', 'S82236N', 'S82236P', 'S82236Q', 'S82236R', 'S82236S',
        'S82241A', 'S82241B', 'S82241C', 'S82241D', 'S82241E', 'S82241F', 'S82241G', 'S82241H',
        'S82241J', 'S82241K', 'S82241M', 'S82241N', 'S82241P', 'S82241Q', 'S82241R', 'S82241S',
        'S82242A', 'S82242B', 'S82242C', 'S82242D', 'S82242E', 'S82242F', 'S82242G', 'S82242H',
        'S82242J', 'S82242K', 'S82242M', 'S82242N', 'S82242P', 'S82242Q', 'S82242R', 'S82242S',
        'S82243A', 'S82243B', 'S82243C', 'S82243D', 'S82243E', 'S82243F', 'S82243G', 'S82243H',
        'S82243J', 'S82243K', 'S82243M', 'S82243N', 'S82243P', 'S82243Q', 'S82243R', 'S82243S',
        'S82244A', 'S82244B', 'S82244C', 'S82244D', 'S82244E', 'S82244F', 'S82244G', 'S82244H',
        'S82244J', 'S82244K', 'S82244M', 'S82244N', 'S82244P', 'S82244Q', 'S82244R', 'S82244S',
        'S82245A', 'S82245B', 'S82245C', 'S82245D', 'S82245E', 'S82245F', 'S82245G', 'S82245H',
        'S82245J', 'S82245K', 'S82245M', 'S82245N', 'S82245P', 'S82245Q', 'S82245R', 'S82245S',
        'S82246A', 'S82246B', 'S82246C', 'S82246D', 'S82246E', 'S82246F', 'S82246G', 'S82246H',
        'S82246J', 'S82246K', 'S82246M', 'S82246N', 'S82246P', 'S82246Q', 'S82246R', 'S82246S',
        'S82251A', 'S82251B', 'S82251C', 'S82251D', 'S82251E', 'S82251F', 'S82251G', 'S82251H',
        'S82251J', 'S82251K', 'S82251M', 'S82251N', 'S82251P', 'S82251Q', 'S82251R', 'S82251S',
        'S82252A', 'S82252B', 'S82252C', 'S82252D', 'S82252E', 'S82252F', 'S82252G', 'S82252H',
        'S82252J', 'S82252K', 'S82252M', 'S82252N', 'S82252P', 'S82252Q', 'S82252R', 'S82252S',
        'S82253A', 'S82253B', 'S82253C', 'S82253D', 'S82253E', 'S82253F', 'S82253G', 'S82253H',
        'S82253J', 'S82253K', 'S82253M', 'S82253N', 'S82253P', 'S82253Q', 'S82253R', 'S82253S',
        'S82254A', 'S82254B', 'S82254C', 'S82254D', 'S82254E', 'S82254F', 'S82254G', 'S82254H',
        'S82254J', 'S82254K', 'S82254M', 'S82254N', 'S82254P', 'S82254Q', 'S82254R', 'S82254S',
        'S82255A', 'S82255B', 'S82255C', 'S82255D', 'S82255E', 'S82255F', 'S82255G', 'S82255H',
        'S82255J', 'S82255K', 'S82255M', 'S82255N', 'S82255P', 'S82255Q', 'S82255R', 'S82255S',
        'S82256A', 'S82256B', 'S82256C', 'S82256D', 'S82256E', 'S82256F', 'S82256G', 'S82256H',
        'S82256J', 'S82256K', 'S82256M', 'S82256N', 'S82256P', 'S82256Q', 'S82256R', 'S82256S',
        'S82261A', 'S82261B', 'S82261C', 'S82261D', 'S82261E', 'S82261F', 'S82261G', 'S82261H',
        'S82261J', 'S82261K', 'S82261M', 'S82261N', 'S82261P', 'S82261Q', 'S82261R', 'S82261S',
        'S82262A', 'S82262B', 'S82262C', 'S82262D', 'S82262E', 'S82262F', 'S82262G', 'S82262H',
        'S82262J', 'S82262K', 'S82262M', 'S82262N', 'S82262P', 'S82262Q', 'S82262R', 'S82262S',
        'S82263A', 'S82263B', 'S82263C', 'S82263D', 'S82263E', 'S82263F', 'S82263G', 'S82263H',
        'S82263J', 'S82263K', 'S82263M', 'S82263N', 'S82263P', 'S82263Q', 'S82263R', 'S82263S',
        'S82264A', 'S82264B', 'S82264C', 'S82264D', 'S82264E', 'S82264F', 'S82264G', 'S82264H',
        'S82264J', 'S82264K', 'S82264M', 'S82264N', 'S82264P', 'S82264Q', 'S82264R', 'S82264S',
        'S82265A', 'S82265B', 'S82265C', 'S82265D', 'S82265E', 'S82265F', 'S82265G', 'S82265H',
        'S82265J', 'S82265K', 'S82265M', 'S82265N', 'S82265P', 'S82265Q', 'S82265R', 'S82265S',
        'S82266A', 'S82266B', 'S82266C', 'S82266D', 'S82266E', 'S82266F', 'S82266G', 'S82266H',
        'S82266J', 'S82266K', 'S82266M', 'S82266N', 'S82266P', 'S82266Q', 'S82266R', 'S82266S',
        'S82291A', 'S82291B', 'S82291C', 'S82291D', 'S82291E', 'S82291F', 'S82291G', 'S82291H',
        'S82291J', 'S82291K', 'S82291M', 'S82291N', 'S82291P', 'S82291Q', 'S82291R', 'S82291S',
        'S82292A', 'S82292B', 'S82292C', 'S82292D', 'S82292E', 'S82292F', 'S82292G', 'S82292H',
        'S82292J', 'S82292K', 'S82292M', 'S82292N', 'S82292P', 'S82292Q', 'S82292R', 'S82292S',
        'S82299A', 'S82299B', 'S82299C', 'S82299D', 'S82299E', 'S82299F', 'S82299G', 'S82299H',
        'S82299J', 'S82299K', 'S82299M', 'S82299N', 'S82299P', 'S82299Q', 'S82299R', 'S82299S',
        'S82301A', 'S82301B', 'S82301C', 'S82301D', 'S82301E', 'S82301F', 'S82301G', 'S82301H',
        'S82301J', 'S82301K', 'S82301M', 'S82301N', 'S82301P', 'S82301Q', 'S82301R', 'S82301S',
        'S82302A', 'S82302B', 'S82302C', 'S82302D', 'S82302E', 'S82302F', 'S82302G', 'S82302H',
        'S82302J', 'S82302K', 'S82302M', 'S82302N', 'S82302P', 'S82302Q', 'S82302R', 'S82302S',
        'S82309A', 'S82309B', 'S82309C', 'S82309D', 'S82309E', 'S82309F', 'S82309G', 'S82309H',
        'S82309J', 'S82309K', 'S82309M', 'S82309N', 'S82309P', 'S82309Q', 'S82309R', 'S82309S',
        'S82311A', 'S82311D', 'S82311G', 'S82311K', 'S82311P', 'S82311S', 'S82312A', 'S82312D',
        'S82312G', 'S82312K', 'S82312P', 'S82312S', 'S82319A', 'S82319D', 'S82319G', 'S82319K',
        'S82319P', 'S82319S', 'S82391A', 'S82391B', 'S82391C', 'S82391D', 'S82391E', 'S82391F',
        'S82391G', 'S82391H', 'S82391J', 'S82391K', 'S82391M', 'S82391N', 'S82391P', 'S82391Q',
        'S82391R', 'S82391S', 'S82392A', 'S82392B', 'S82392C', 'S82392D', 'S82392E', 'S82392F',
        'S82392G', 'S82392H', 'S82392J', 'S82392K', 'S82392M', 'S82392N', 'S82392P', 'S82392Q',
        'S82392R', 'S82392S', 'S82399A', 'S82399B', 'S82399C', 'S82399D', 'S82399E', 'S82399F',
        'S82399G', 'S82399H', 'S82399J', 'S82399K', 'S82399M', 'S82399N', 'S82399P', 'S82399Q',
        'S82399R', 'S82399S', 'S82401A', 'S82401B', 'S82401C', 'S82401D', 'S82401E', 'S82401F',
        'S82401G', 'S82401H', 'S82401J', 'S82401K', 'S82401M', 'S82401N', 'S82401P', 'S82401Q',
        'S82401R', 'S82401S', 'S82402A', 'S82402B', 'S82402C', 'S82402D', 'S82402E', 'S82402F',
        'S82402G', 'S82402H', 'S82402J', 'S82402K', 'S82402M', 'S82402N', 'S82402P', 'S82402Q',
        'S82402R', 'S82402S', 'S82409A', 'S82409B', 'S82409C', 'S82409D', 'S82409E', 'S82409F',
        'S82409G', 'S82409H', 'S82409J', 'S82409K', 'S82409M', 'S82409N', 'S82409P', 'S82409Q',
        'S82409R', 'S82409S', 'S82421A', 'S82421B', 'S82421C', 'S82421D', 'S82421E', 'S82421F',
        'S82421G', 'S82421H', 'S82421J', 'S82421K', 'S82421M', 'S82421N', 'S82421P', 'S82421Q',
        'S82421R', 'S82421S', 'S82422A', 'S82422B', 'S82422C', 'S82422D', 'S82422E', 'S82422F',
        'S82422G', 'S82422H', 'S82422J', 'S82422K', 'S82422M', 'S82422N', 'S82422P', 'S82422Q',
        'S82422R', 'S82422S', 'S82423A', 'S82423B', 'S82423C', 'S82423D', 'S82423E', 'S82423F',
        'S82423G', 'S82423H', 'S82423J', 'S82423K', 'S82423M', 'S82423N', 'S82423P', 'S82423Q',
        'S82423R', 'S82423S', 'S82424A', 'S82424B', 'S82424C', 'S82424D', 'S82424E', 'S82424F',
        'S82424G', 'S82424H', 'S82424J', 'S82424K', 'S82424M', 'S82424N', 'S82424P', 'S82424Q',
        'S82424R', 'S82424S', 'S82425A', 'S82425B', 'S82425C', 'S82425D', 'S82425E', 'S82425F',
        'S82425G', 'S82425H', 'S82425J', 'S82425K', 'S82425M', 'S82425N', 'S82425P', 'S82425Q',
        'S82425R', 'S82425S', 'S82426A', 'S82426B', 'S82426C', 'S82426D', 'S82426E', 'S82426F',
        'S82426G', 'S82426H', 'S82426J', 'S82426K', 'S82426M', 'S82426N', 'S82426P', 'S82426Q',
        'S82426R', 'S82426S', 'S82431A', 'S82431B', 'S82431C', 'S82431D', 'S82431E', 'S82431F',
        'S82431G', 'S82431H', 'S82431J', 'S82431K', 'S82431M', 'S82431N', 'S82431P', 'S82431Q',
        'S82431R', 'S82431S', 'S82432A', 'S82432B', 'S82432C', 'S82432D', 'S82432E', 'S82432F',
        'S82432G', 'S82432H', 'S82432J', 'S82432K', 'S82432M', 'S82432N', 'S82432P', 'S82432Q',
        'S82432R', 'S82432S', 'S82433A', 'S82433B', 'S82433C', 'S82433D', 'S82433E', 'S82433F',
        'S82433G', 'S82433H', 'S82433J', 'S82433K', 'S82433M', 'S82433N', 'S82433P', 'S82433Q',
        'S82433R', 'S82433S', 'S82434A', 'S82434B', 'S82434C', 'S82434D', 'S82434E', 'S82434F',
        'S82434G', 'S82434H', 'S82434J', 'S82434K', 'S82434M', 'S82434N', 'S82434P', 'S82434Q',
        'S82434R', 'S82434S', 'S82435A', 'S82435B', 'S82435C', 'S82435D', 'S82435E', 'S82435F',
        'S82435G', 'S82435H', 'S82435J', 'S82435K', 'S82435M', 'S82435N', 'S82435P', 'S82435Q',
        'S82435R', 'S82435S', 'S82436A', 'S82436B', 'S82436C', 'S82436D', 'S82436E', 'S82436F',
        'S82436G', 'S82436H', 'S82436J', 'S82436K', 'S82436M', 'S82436N', 'S82436P', 'S82436Q',
        'S82436R', 'S82436S', 'S82441A', 'S82441B', 'S82441C', 'S82441D', 'S82441E', 'S82441F',
        'S82441G', 'S82441H', 'S82441J', 'S82441K', 'S82441M', 'S82441N', 'S82441P', 'S82441Q',
        'S82441R', 'S82441S', 'S82442A', 'S82442B', 'S82442C', 'S82442D', 'S82442E', 'S82442F',
        'S82442G', 'S82442H', 'S82442J', 'S82442K', 'S82442M', 'S82442N', 'S82442P', 'S82442Q',
        'S82442R', 'S82442S', 'S82443A', 'S82443B', 'S82443C', 'S82443D', 'S82443E', 'S82443F',
        'S82443G', 'S82443H', 'S82443J', 'S82443K', 'S82443M', 'S82443N', 'S82443P', 'S82443Q',
        'S82443R', 'S82443S', 'S82444A', 'S82444B', 'S82444C', 'S82444D', 'S82444E', 'S82444F',
        'S82444G', 'S82444H', 'S82444J', 'S82444K', 'S82444M', 'S82444N', 'S82444P', 'S82444Q',
        'S82444R', 'S82444S', 'S82445A', 'S82445B', 'S82445C', 'S82445D', 'S82445E', 'S82445F',
        'S82445G', 'S82445H', 'S82445J', 'S82445K', 'S82445M', 'S82445N', 'S82445P', 'S82445Q',
        'S82445R', 'S82445S', 'S82446A', 'S82446B', 'S82446C', 'S82446D', 'S82446E', 'S82446F',
        'S82446G', 'S82446H', 'S82446J', 'S82446K', 'S82446M', 'S82446N', 'S82446P', 'S82446Q',
        'S82446R', 'S82446S', 'S82451A', 'S82451B', 'S82451C', 'S82451D', 'S82451E', 'S82451F',
        'S82451G', 'S82451H', 'S82451J', 'S82451K', 'S82451M', 'S82451N', 'S82451P', 'S82451Q',
        'S82451R', 'S82451S', 'S82452A', 'S82452B', 'S82452C', 'S82452D', 'S82452E', 'S82452F',
        'S82452G', 'S82452H', 'S82452J', 'S82452K', 'S82452M', 'S82452N', 'S82452P', 'S82452Q',
        'S82452R', 'S82452S', 'S82453A', 'S82453B', 'S82453C', 'S82453D', 'S82453E', 'S82453F',
        'S82453G', 'S82453H', 'S82453J', 'S82453K', 'S82453M', 'S82453N', 'S82453P', 'S82453Q',
        'S82453R', 'S82453S', 'S82454A', 'S82454B', 'S82454C', 'S82454D', 'S82454E', 'S82454F',
        'S82454G', 'S82454H', 'S82454J', 'S82454K', 'S82454M', 'S82454N', 'S82454P', 'S82454Q',
        'S82454R', 'S82454S', 'S82455A', 'S82455B', 'S82455C', 'S82455D', 'S82455E', 'S82455F',
        'S82455G', 'S82455H', 'S82455J', 'S82455K', 'S82455M', 'S82455N', 'S82455P', 'S82455Q',
        'S82455R', 'S82455S', 'S82456A', 'S82456B', 'S82456C', 'S82456D', 'S82456E', 'S82456F',
        'S82456G', 'S82456H', 'S82456J', 'S82456K', 'S82456M', 'S82456N', 'S82456P', 'S82456Q',
        'S82456R', 'S82456S', 'S82461A', 'S82461B', 'S82461C', 'S82461D', 'S82461E', 'S82461F',
        'S82461G', 'S82461H', 'S82461J', 'S82461K', 'S82461M', 'S82461N', 'S82461P', 'S82461Q',
        'S82461R', 'S82461S', 'S82462A', 'S82462B', 'S82462C', 'S82462D', 'S82462E', 'S82462F',
        'S82462G', 'S82462H', 'S82462J', 'S82462K', 'S82462M', 'S82462N', 'S82462P', 'S82462Q',
        'S82462R', 'S82462S', 'S82463A', 'S82463B', 'S82463C', 'S82463D', 'S82463E', 'S82463F',
        'S82463G', 'S82463H', 'S82463J', 'S82463K', 'S82463M', 'S82463N', 'S82463P', 'S82463Q',
        'S82463R', 'S82463S', 'S82464A', 'S82464B', 'S82464C', 'S82464D', 'S82464E', 'S82464F',
        'S82464G', 'S82464H', 'S82464J', 'S82464K', 'S82464M', 'S82464N', 'S82464P', 'S82464Q',
        'S82464R', 'S82464S', 'S82465A', 'S82465B', 'S82465C', 'S82465D', 'S82465E', 'S82465F',
        'S82465G', 'S82465H', 'S82465J', 'S82465K', 'S82465M', 'S82465N', 'S82465P', 'S82465Q',
        'S82465R', 'S82465S', 'S82466A', 'S82466B', 'S82466C', 'S82466D', 'S82466E', 'S82466F',
        'S82466G', 'S82466H', 'S82466J', 'S82466K', 'S82466M', 'S82466N', 'S82466P', 'S82466Q',
        'S82466R', 'S82466S', 'S82491A', 'S82491B', 'S82491C', 'S82491D', 'S82491E', 'S82491F',
        'S82491G', 'S82491H', 'S82491J', 'S82491K', 'S82491M', 'S82491N', 'S82491P', 'S82491Q',
        'S82491R', 'S82491S', 'S82492A', 'S82492B', 'S82492C', 'S82492D', 'S82492E', 'S82492F',
        'S82492G', 'S82492H', 'S82492J', 'S82492K', 'S82492M', 'S82492N', 'S82492P', 'S82492Q',
        'S82492R', 'S82492S', 'S82499A', 'S82499B', 'S82499C', 'S82499D', 'S82499E', 'S82499F',
        'S82499G', 'S82499H', 'S82499J', 'S82499K', 'S82499M', 'S82499N', 'S82499P', 'S82499Q',
        'S82499R', 'S82499S', 'S8251XA', 'S8251XB', 'S8251XC', 'S8251XD', 'S8251XE', 'S8251XF',
        'S8251XG', 'S8251XH', 'S8251XJ', 'S8251XK', 'S8251XM', 'S8251XN', 'S8251XP', 'S8251XQ',
        'S8251XR', 'S8251XS', 'S8252XA', 'S8252XB', 'S8252XC', 'S8252XD', 'S8252XE', 'S8252XF',
        'S8252XG', 'S8252XH', 'S8252XJ', 'S8252XK', 'S8252XM', 'S8252XN', 'S8252XP', 'S8252XQ',
        'S8252XR', 'S8252XS', 'S8253XA', 'S8253XB', 'S8253XC', 'S8253XD', 'S8253XE', 'S8253XF',
        'S8253XG', 'S8253XH', 'S8253XJ', 'S8253XK', 'S8253XM', 'S8253XN', 'S8253XP', 'S8253XQ',
        'S8253XR', 'S8253XS', 'S8254XA', 'S8254XB', 'S8254XC', 'S8254XD', 'S8254XE', 'S8254XF',
        'S8254XG', 'S8254XH', 'S8254XJ', 'S8254XK', 'S8254XM', 'S8254XN', 'S8254XP', 'S8254XQ',
        'S8254XR', 'S8254XS', 'S8255XA', 'S8255XB', 'S8255XC', 'S8255XD', 'S8255XE', 'S8255XF',
        'S8255XG', 'S8255XH', 'S8255XJ', 'S8255XK', 'S8255XM', 'S8255XN', 'S8255XP', 'S8255XQ',
        'S8255XR', 'S8255XS', 'S8256XA', 'S8256XB', 'S8256XC', 'S8256XD', 'S8256XE', 'S8256XF',
        'S8256XG', 'S8256XH', 'S8256XJ', 'S8256XK', 'S8256XM', 'S8256XN', 'S8256XP', 'S8256XQ',
        'S8256XR', 'S8256XS', 'S8261XA', 'S8261XB', 'S8261XC', 'S8261XD', 'S8261XE', 'S8261XF',
        'S8261XG', 'S8261XH', 'S8261XJ', 'S8261XK', 'S8261XM', 'S8261XN', 'S8261XP', 'S8261XQ',
        'S8261XR', 'S8261XS', 'S8262XA', 'S8262XB', 'S8262XC', 'S8262XD', 'S8262XE', 'S8262XF',
        'S8262XG', 'S8262XH', 'S8262XJ', 'S8262XK', 'S8262XM', 'S8262XN', 'S8262XP', 'S8262XQ',
        'S8262XR', 'S8262XS', 'S8263XA', 'S8263XB', 'S8263XC', 'S8263XD', 'S8263XE', 'S8263XF',
        'S8263XG', 'S8263XH', 'S8263XJ', 'S8263XK', 'S8263XM', 'S8263XN', 'S8263XP', 'S8263XQ',
        'S8263XR', 'S8263XS', 'S8264XA', 'S8264XB', 'S8264XC', 'S8264XD', 'S8264XE', 'S8264XF',
        'S8264XG', 'S8264XH', 'S8264XJ', 'S8264XK', 'S8264XM', 'S8264XN', 'S8264XP', 'S8264XQ',
        'S8264XR', 'S8264XS', 'S8265XA', 'S8265XB', 'S8265XC', 'S8265XD', 'S8265XE', 'S8265XF',
        'S8265XG', 'S8265XH', 'S8265XJ', 'S8265XK', 'S8265XM', 'S8265XN', 'S8265XP', 'S8265XQ',
        'S8265XR', 'S8265XS', 'S8266XA', 'S8266XB', 'S8266XC', 'S8266XD', 'S8266XE', 'S8266XF',
        'S8266XG', 'S8266XH', 'S8266XJ', 'S8266XK', 'S8266XM', 'S8266XN', 'S8266XP', 'S8266XQ',
        'S8266XR', 'S8266XS', 'S82811A', 'S82811D', 'S82811G', 'S82811K', 'S82811P', 'S82811S',
        'S82812A', 'S82812D', 'S82812G', 'S82812K', 'S82812P', 'S82812S', 'S82819A', 'S82819D',
        'S82819G', 'S82819K', 'S82819P', 'S82819S', 'S82821A', 'S82821D', 'S82821G', 'S82821K',
        'S82821P', 'S82821S', 'S82822A', 'S82822D', 'S82822G', 'S82822K', 'S82822P', 'S82822S',
        'S82829A', 'S82829D', 'S82829G', 'S82829K', 'S82829P', 'S82829S', 'S82831A', 'S82831B',
        'S82831C', 'S82831D', 'S82831E', 'S82831F', 'S82831G', 'S82831H', 'S82831J', 'S82831K',
        'S82831M', 'S82831N', 'S82831P', 'S82831Q', 'S82831R', 'S82831S', 'S82832A', 'S82832B',
        'S82832C', 'S82832D', 'S82832E', 'S82832F', 'S82832G', 'S82832H', 'S82832J', 'S82832K',
        'S82832M', 'S82832N', 'S82832P', 'S82832Q', 'S82832R', 'S82832S', 'S82839A', 'S82839B',
        'S82839C', 'S82839D', 'S82839E', 'S82839F', 'S82839G', 'S82839H', 'S82839J', 'S82839K',
        'S82839M', 'S82839N', 'S82839P', 'S82839Q', 'S82839R', 'S82839S', 'S82841A', 'S82841B',
        'S82841C', 'S82841D', 'S82841E', 'S82841F', 'S82841G', 'S82841H', 'S82841J', 'S82841K',
        'S82841M', 'S82841N', 'S82841P', 'S82841Q', 'S82841R', 'S82841S', 'S82842A', 'S82842B',
        'S82842C', 'S82842D', 'S82842E', 'S82842F', 'S82842G', 'S82842H', 'S82842J', 'S82842K',
        'S82842M', 'S82842N', 'S82842P', 'S82842Q', 'S82842R', 'S82842S', 'S82843A', 'S82843B',
        'S82843C', 'S82843D', 'S82843E', 'S82843F', 'S82843G', 'S82843H', 'S82843J', 'S82843K',
        'S82843M', 'S82843N', 'S82843P', 'S82843Q', 'S82843R', 'S82843S', 'S82844A', 'S82844B',
        'S82844C', 'S82844D', 'S82844E', 'S82844F', 'S82844G', 'S82844H', 'S82844J', 'S82844K',
        'S82844M', 'S82844N', 'S82844P', 'S82844Q', 'S82844R', 'S82844S', 'S82845A', 'S82845B',
        'S82845C', 'S82845D', 'S82845E', 'S82845F', 'S82845G', 'S82845H', 'S82845J', 'S82845K',
        'S82845M', 'S82845N', 'S82845P', 'S82845Q', 'S82845R', 'S82845S', 'S82846A', 'S82846B',
        'S82846C', 'S82846D', 'S82846E', 'S82846F', 'S82846G', 'S82846H', 'S82846J', 'S82846K',
        'S82846M', 'S82846N', 'S82846P', 'S82846Q', 'S82846R', 'S82846S', 'S82851A', 'S82851B',
        'S82851C', 'S82851D', 'S82851E', 'S82851F', 'S82851G', 'S82851H', 'S82851J', 'S82851K',
        'S82851M', 'S82851N', 'S82851P', 'S82851Q', 'S82851R', 'S82851S', 'S82852A', 'S82852B',
        'S82852C', 'S82852D', 'S82852E', 'S82852F', 'S82852G', 'S82852H', 'S82852J', 'S82852K',
        'S82852M', 'S82852N', 'S82852P', 'S82852Q', 'S82852R', 'S82852S', 'S82853A', 'S82853B',
        'S82853C', 'S82853D', 'S82853E', 'S82853F', 'S82853G', 'S82853H', 'S82853J', 'S82853K',
        'S82853M', 'S82853N', 'S82853P', 'S82853Q', 'S82853R', 'S82853S', 'S82854A', 'S82854B',
        'S82854C', 'S82854D', 'S82854E', 'S82854F', 'S82854G', 'S82854H', 'S82854J', 'S82854K',
        'S82854M', 'S82854N', 'S82854P', 'S82854Q', 'S82854R', 'S82854S', 'S82855A', 'S82855B',
        'S82855C', 'S82855D', 'S82855E', 'S82855F', 'S82855G', 'S82855H', 'S82855J', 'S82855K',
        'S82855M', 'S82855N', 'S82855P', 'S82855Q', 'S82855R', 'S82855S', 'S82856A', 'S82856B',
        'S82856C', 'S82856D', 'S82856E', 'S82856F', 'S82856G', 'S82856H', 'S82856J', 'S82856K',
        'S82856M', 'S82856N', 'S82856P', 'S82856Q', 'S82856R', 'S82856S', 'S82861A', 'S82861B',
        'S82861C', 'S82861D', 'S82861E', 'S82861F', 'S82861G', 'S82861H', 'S82861J', 'S82861K',
        'S82861M', 'S82861N', 'S82861P', 'S82861Q', 'S82861R', 'S82861S', 'S82862A', 'S82862B',
        'S82862C', 'S82862D', 'S82862E', 'S82862F', 'S82862G', 'S82862H', 'S82862J', 'S82862K',
        'S82862M', 'S82862N', 'S82862P', 'S82862Q', 'S82862R', 'S82862S', 'S82863A', 'S82863B',
        'S82863C', 'S82863D', 'S82863E', 'S82863F', 'S82863G', 'S82863H', 'S82863J', 'S82863K',
        'S82863M', 'S82863N', 'S82863P', 'S82863Q', 'S82863R', 'S82863S', 'S82864A', 'S82864B',
        'S82864C', 'S82864D', 'S82864E', 'S82864F', 'S82864G', 'S82864H', 'S82864J', 'S82864K',
        'S82864M', 'S82864N', 'S82864P', 'S82864Q', 'S82864R', 'S82864S', 'S82865A', 'S82865B',
        'S82865C', 'S82865D', 'S82865E', 'S82865F', 'S82865G', 'S82865H', 'S82865J', 'S82865K',
        'S82865M', 'S82865N', 'S82865P', 'S82865Q', 'S82865R', 'S82865S', 'S82866A', 'S82866B',
        'S82866C', 'S82866D', 'S82866E', 'S82866F', 'S82866G', 'S82866H', 'S82866J', 'S82866K',
        'S82866M', 'S82866N', 'S82866P', 'S82866Q', 'S82866R', 'S82866S', 'S82871A', 'S82871B',
        'S82871C', 'S82871D', 'S82871E', 'S82871F', 'S82871G', 'S82871H', 'S82871J', 'S82871K',
        'S82871M', 'S82871N', 'S82871P', 'S82871Q', 'S82871R', 'S82871S', 'S82872A', 'S82872B',
        'S82872C', 'S82872D', 'S82872E', 'S82872F', 'S82872G', 'S82872H', 'S82872J', 'S82872K',
        'S82872M', 'S82872N', 'S82872P', 'S82872Q', 'S82872R', 'S82872S', 'S82873A', 'S82873B',
        'S82873C', 'S82873D', 'S82873E', 'S82873F', 'S82873G', 'S82873H', 'S82873J', 'S82873K',
        'S82873M', 'S82873N', 'S82873P', 'S82873Q', 'S82873R', 'S82873S', 'S82874A', 'S82874B',
        'S82874C', 'S82874D', 'S82874E', 'S82874F', 'S82874G', 'S82874H', 'S82874J', 'S82874K',
        'S82874M', 'S82874N', 'S82874P', 'S82874Q', 'S82874R', 'S82874S', 'S82875A', 'S82875B',
        'S82875C', 'S82875D', 'S82875E', 'S82875F', 'S82875G', 'S82875H', 'S82875J', 'S82875K',
        'S82875M', 'S82875N', 'S82875P', 'S82875Q', 'S82875R', 'S82875S', 'S82876A', 'S82876B',
        'S82876C', 'S82876D', 'S82876E', 'S82876F', 'S82876G', 'S82876H', 'S82876J', 'S82876K',
        'S82876M', 'S82876N', 'S82876P', 'S82876Q', 'S82876R', 'S82876S', 'S82891A', 'S82891B',
        'S82891C', 'S82891D', 'S82891E', 'S82891F', 'S82891G', 'S82891H', 'S82891J', 'S82891K',
        'S82891M', 'S82891N', 'S82891P', 'S82891Q', 'S82891R', 'S82891S', 'S82892A', 'S82892B',
        'S82892C', 'S82892D', 'S82892E', 'S82892F', 'S82892G', 'S82892H', 'S82892J', 'S82892K',
        'S82892M', 'S82892N', 'S82892P', 'S82892Q', 'S82892R', 'S82892S', 'S82899A', 'S82899B',
        'S82899C', 'S82899D', 'S82899E', 'S82899F', 'S82899G', 'S82899H', 'S82899J', 'S82899K',
        'S82899M', 'S82899N', 'S82899P', 'S82899Q', 'S82899R', 'S82899S', 'S8290XA', 'S8290XB',
        'S8290XC', 'S8290XD', 'S8290XE', 'S8290XF', 'S8290XG', 'S8290XH', 'S8290XJ', 'S8290XK',
        'S8290XM', 'S8290XN', 'S8290XP', 'S8290XQ', 'S8290XR', 'S8290XS', 'S8291XA', 'S8291XB',
        'S8291XC', 'S8291XD', 'S8291XE', 'S8291XF', 'S8291XG', 'S8291XH', 'S8291XJ', 'S8291XK',
        'S8291XM', 'S8291XN', 'S8291XP', 'S8291XQ', 'S8291XR', 'S8291XS', 'S8292XA', 'S8292XB',
        'S8292XC', 'S8292XD', 'S8292XE', 'S8292XF', 'S8292XG', 'S8292XH', 'S8292XJ', 'S8292XK',
        'S8292XM', 'S8292XN', 'S8292XP', 'S8292XQ', 'S8292XR', 'S8292XS', 'S83004A', 'S83004D',
        'S83004S', 'S83005A', 'S83005D', 'S83005S', 'S83006A', 'S83006D', 'S83006S', 'S83014A',
        'S83014D', 'S83014S', 'S83015A', 'S83015D', 'S83015S', 'S83016A', 'S83016D', 'S83016S',
        'S83094A', 'S83094D', 'S83094S', 'S83095A', 'S83095D', 'S83095S', 'S83096A', 'S83096D',
        'S83096S', 'S83104A', 'S83104D', 'S83104S', 'S83105A', 'S83105D', 'S83105S', 'S83106A',
        'S83106D', 'S83106S', 'S83114A', 'S83114D', 'S83114S', 'S83115A', 'S83115D', 'S83115S',
        'S83116A', 'S83116D', 'S83116S', 'S83124A', 'S83124D', 'S83124S', 'S83125A', 'S83125D',
        'S83125S', 'S83126A', 'S83126D', 'S83126S', 'S83134A', 'S83134D', 'S83134S', 'S83135A',
        'S83135D', 'S83135S', 'S83136A', 'S83136D', 'S83136S', 'S83144A', 'S83144D', 'S83144S',
        'S83145A', 'S83145D', 'S83145S', 'S83146A', 'S83146D', 'S83146S', 'S83194A', 'S83194D',
        'S83194S', 'S83195A', 'S83195D', 'S83195S', 'S83196A', 'S83196D', 'S83196S', 'S89001A',
        'S89001D', 'S89001G', 'S89001K', 'S89001P', 'S89001S', 'S89002A', 'S89002D', 'S89002G',
        'S89002K', 'S89002P', 'S89002S', 'S89009A', 'S89009D', 'S89009G', 'S89009K', 'S89009P',
        'S89009S', 'S89011A', 'S89011D', 'S89011G', 'S89011K', 'S89011P', 'S89011S', 'S89012A',
        'S89012D', 'S89012G', 'S89012K', 'S89012P', 'S89012S', 'S89019A', 'S89019D', 'S89019G',
        'S89019K', 'S89019P', 'S89019S', 'S89021A', 'S89021D', 'S89021G', 'S89021K', 'S89021P',
        'S89021S', 'S89022A', 'S89022D', 'S89022G', 'S89022K', 'S89022P', 'S89022S', 'S89029A',
        'S89029D', 'S89029G', 'S89029K', 'S89029P', 'S89029S', 'S89031A', 'S89031D', 'S89031G',
        'S89031K', 'S89031P', 'S89031S', 'S89032A', 'S89032D', 'S89032G', 'S89032K', 'S89032P',
        'S89032S', 'S89039A', 'S89039D', 'S89039G', 'S89039K', 'S89039P', 'S89039S', 'S89041A',
        'S89041D', 'S89041G', 'S89041K', 'S89041P', 'S89041S', 'S89042A', 'S89042D', 'S89042G',
        'S89042K', 'S89042P', 'S89042S', 'S89049A', 'S89049D', 'S89049G', 'S89049K', 'S89049P',
        'S89049S', 'S89091A', 'S89091D', 'S89091G', 'S89091K', 'S89091P', 'S89091S', 'S89092A',
        'S89092D', 'S89092G', 'S89092K', 'S89092P', 'S89092S', 'S89099A', 'S89099D', 'S89099G',
        'S89099K', 'S89099P', 'S89099S', 'S89101A', 'S89101D', 'S89101G', 'S89101K', 'S89101P',
        'S89101S', 'S89102A', 'S89102D', 'S89102G', 'S89102K', 'S89102P', 'S89102S', 'S89109A',
        'S89109D', 'S89109G', 'S89109K', 'S89109P', 'S89109S', 'S89111A', 'S89111D', 'S89111G',
        'S89111K', 'S89111P', 'S89111S', 'S89112A', 'S89112D', 'S89112G', 'S89112K', 'S89112P',
        'S89112S', 'S89119A', 'S89119D', 'S89119G', 'S89119K', 'S89119P', 'S89119S', 'S89121A',
        'S89121D', 'S89121G', 'S89121K', 'S89121P', 'S89121S', 'S89122A', 'S89122D', 'S89122G',
        'S89122K', 'S89122P', 'S89122S', 'S89129A', 'S89129D', 'S89129G', 'S89129K', 'S89129P',
        'S89129S', 'S89131A', 'S89131D', 'S89131G', 'S89131K', 'S89131P', 'S89131S', 'S89132A',
        'S89132D', 'S89132G', 'S89132K', 'S89132P', 'S89132S', 'S89139A', 'S89139D', 'S89139G',
        'S89139K', 'S89139P', 'S89139S', 'S89141A', 'S89141D', 'S89141G', 'S89141K', 'S89141P',
        'S89141S', 'S89142A', 'S89142D', 'S89142G', 'S89142K', 'S89142P', 'S89142S', 'S89149A',
        'S89149D', 'S89149G', 'S89149K', 'S89149P', 'S89149S', 'S89191A', 'S89191D', 'S89191G',
        'S89191K', 'S89191P', 'S89191S', 'S89192A', 'S89192D', 'S89192G', 'S89192K', 'S89192P',
        'S89192S', 'S89199A', 'S89199D', 'S89199G', 'S89199K', 'S89199P', 'S89199S', 'S89201A',
        'S89201D', 'S89201G', 'S89201K', 'S89201P', 'S89201S', 'S89202A', 'S89202D', 'S89202G',
        'S89202K', 'S89202P', 'S89202S', 'S89209A', 'S89209D', 'S89209G', 'S89209K', 'S89209P',
        'S89209S', 'S89211A', 'S89211D', 'S89211G', 'S89211K', 'S89211P', 'S89211S', 'S89212A',
        'S89212D', 'S89212G', 'S89212K', 'S89212P', 'S89212S', 'S89219A', 'S89219D', 'S89219G',
        'S89219K', 'S89219P', 'S89219S', 'S89221A', 'S89221D', 'S89221G', 'S89221K', 'S89221P',
        'S89221S', 'S89222A', 'S89222D', 'S89222G', 'S89222K', 'S89222P', 'S89222S', 'S89229A',
        'S89229D', 'S89229G', 'S89229K', 'S89229P', 'S89229S', 'S89291A', 'S89291D', 'S89291G',
        'S89291K', 'S89291P', 'S89291S', 'S89292A', 'S89292D', 'S89292G', 'S89292K', 'S89292P',
        'S89292S', 'S89299A', 'S89299D', 'S89299G', 'S89299K', 'S89299P', 'S89299S', 'S89301A',
        'S89301D', 'S89301G', 'S89301K', 'S89301P', 'S89301S', 'S89302A', 'S89302D', 'S89302G',
        'S89302K', 'S89302P', 'S89302S', 'S89309A', 'S89309D', 'S89309G', 'S89309K', 'S89309P',
        'S89309S', 'S89311A', 'S89311D', 'S89311G', 'S89311K', 'S89311P', 'S89311S', 'S89312A',
        'S89312D', 'S89312G', 'S89312K', 'S89312P', 'S89312S', 'S89319A', 'S89319D', 'S89319G',
        'S89319K', 'S89319P', 'S89319S', 'S89321A', 'S89321D', 'S89321G', 'S89321K', 'S89321P',
        'S89321S', 'S89322A', 'S89322D', 'S89322G', 'S89322K', 'S89322P', 'S89322S', 'S89329A',
        'S89329D', 'S89329G', 'S89329K', 'S89329P', 'S89329S', 'S89391A', 'S89391D', 'S89391G',
        'S89391K', 'S89391P', 'S89391S', 'S89392A', 'S89392D', 'S89392G', 'S89392K', 'S89392P',
        'S89392S', 'S89399A', 'S89399D', 'S89399G', 'S89399K', 'S89399P', 'S89399S', 'S92001A',
        'S92001B', 'S92001D', 'S92001G', 'S92001K', 'S92001P', 'S92001S', 'S92002A', 'S92002B',
        'S92002D', 'S92002G', 'S92002K', 'S92002P', 'S92002S', 'S92009A', 'S92009B', 'S92009D',
        'S92009G', 'S92009K', 'S92009P', 'S92009S', 'S92011A', 'S92011B', 'S92011D', 'S92011G',
        'S92011K', 'S92011P', 'S92011S', 'S92012A', 'S92012B', 'S92012D', 'S92012G', 'S92012K',
        'S92012P', 'S92012S', 'S92013A', 'S92013B', 'S92013D', 'S92013G', 'S92013K', 'S92013P',
        'S92013S', 'S92014A', 'S92014B', 'S92014D', 'S92014G', 'S92014K', 'S92014P', 'S92014S',
        'S92015A', 'S92015B', 'S92015D', 'S92015G', 'S92015K', 'S92015P', 'S92015S', 'S92016A',
        'S92016B', 'S92016D', 'S92016G', 'S92016K', 'S92016P', 'S92016S', 'S92021A', 'S92021B',
        'S92021D', 'S92021G', 'S92021K', 'S92021P', 'S92021S', 'S92022A', 'S92022B', 'S92022D',
        'S92022G', 'S92022K', 'S92022P', 'S92022S', 'S92023A', 'S92023B', 'S92023D', 'S92023G',
        'S92023K', 'S92023P', 'S92023S', 'S92024A', 'S92024B', 'S92024D', 'S92024G', 'S92024K',
        'S92024P', 'S92024S', 'S92025A', 'S92025B', 'S92025D', 'S92025G', 'S92025K', 'S92025P',
        'S92025S', 'S92026A', 'S92026B', 'S92026D', 'S92026G', 'S92026K', 'S92026P', 'S92026S',
        'S92031A', 'S92031B', 'S92031D', 'S92031G', 'S92031K', 'S92031P', 'S92031S', 'S92032A',
        'S92032B', 'S92032D', 'S92032G', 'S92032K', 'S92032P', 'S92032S', 'S92033A', 'S92033B',
        'S92033D', 'S92033G', 'S92033K', 'S92033P', 'S92033S', 'S92034A', 'S92034B', 'S92034D',
        'S92034G', 'S92034K', 'S92034P', 'S92034S', 'S92035A', 'S92035B', 'S92035D', 'S92035G',
        'S92035K', 'S92035P', 'S92035S', 'S92036A', 'S92036B', 'S92036D', 'S92036G', 'S92036K',
        'S92036P', 'S92036S', 'S92041A', 'S92041B', 'S92041D', 'S92041G', 'S92041K', 'S92041P',
        'S92041S', 'S92042A', 'S92042B', 'S92042D', 'S92042G', 'S92042K', 'S92042P', 'S92042S',
        'S92043A', 'S92043B', 'S92043D', 'S92043G', 'S92043K', 'S92043P', 'S92043S', 'S92044A',
        'S92044B', 'S92044D', 'S92044G', 'S92044K', 'S92044P', 'S92044S', 'S92045A', 'S92045B',
        'S92045D', 'S92045G', 'S92045K', 'S92045P', 'S92045S', 'S92046A', 'S92046B', 'S92046D',
        'S92046G', 'S92046K', 'S92046P', 'S92046S', 'S92051A', 'S92051B', 'S92051D', 'S92051G',
        'S92051K', 'S92051P', 'S92051S', 'S92052A', 'S92052B', 'S92052D', 'S92052G', 'S92052K',
        'S92052P', 'S92052S', 'S92053A', 'S92053B', 'S92053D', 'S92053G', 'S92053K', 'S92053P',
        'S92053S', 'S92054A', 'S92054B', 'S92054D', 'S92054G', 'S92054K', 'S92054P', 'S92054S',
        'S92055A', 'S92055B', 'S92055D', 'S92055G', 'S92055K', 'S92055P', 'S92055S', 'S92056A',
        'S92056B', 'S92056D', 'S92056G', 'S92056K', 'S92056P', 'S92056S', 'S92061A', 'S92061B',
        'S92061D', 'S92061G', 'S92061K', 'S92061P', 'S92061S', 'S92062A', 'S92062B', 'S92062D',
        'S92062G', 'S92062K', 'S92062P', 'S92062S', 'S92063A', 'S92063B', 'S92063D', 'S92063G',
        'S92063K', 'S92063P', 'S92063S', 'S92064A', 'S92064B', 'S92064D', 'S92064G', 'S92064K',
        'S92064P', 'S92064S', 'S92065A', 'S92065B', 'S92065D', 'S92065G', 'S92065K', 'S92065P',
        'S92065S', 'S92066A', 'S92066B', 'S92066D', 'S92066G', 'S92066K', 'S92066P', 'S92066S',
        'S92101A', 'S92101B', 'S92101D', 'S92101G', 'S92101K', 'S92101P', 'S92101S', 'S92102A',
        'S92102B', 'S92102D', 'S92102G', 'S92102K', 'S92102P', 'S92102S', 'S92109A', 'S92109B',
        'S92109D', 'S92109G', 'S92109K', 'S92109P', 'S92109S', 'S92111A', 'S92111B', 'S92111D',
        'S92111G', 'S92111K', 'S92111P', 'S92111S', 'S92112A', 'S92112B', 'S92112D', 'S92112G',
        'S92112K', 'S92112P', 'S92112S', 'S92113A', 'S92113B', 'S92113D', 'S92113G', 'S92113K',
        'S92113P', 'S92113S', 'S92114A', 'S92114B', 'S92114D', 'S92114G', 'S92114K', 'S92114P',
        'S92114S', 'S92115A', 'S92115B', 'S92115D', 'S92115G', 'S92115K', 'S92115P', 'S92115S',
        'S92116A', 'S92116B', 'S92116D', 'S92116G', 'S92116K', 'S92116P', 'S92116S', 'S92121A',
        'S92121B', 'S92121D', 'S92121G', 'S92121K', 'S92121P', 'S92121S', 'S92122A', 'S92122B',
        'S92122D', 'S92122G', 'S92122K', 'S92122P', 'S92122S', 'S92123A', 'S92123B', 'S92123D',
        'S92123G', 'S92123K', 'S92123P', 'S92123S', 'S92124A', 'S92124B', 'S92124D', 'S92124G',
        'S92124K', 'S92124P', 'S92124S', 'S92125A', 'S92125B', 'S92125D', 'S92125G', 'S92125K',
        'S92125P', 'S92125S', 'S92126A', 'S92126B', 'S92126D', 'S92126G', 'S92126K', 'S92126P',
        'S92126S', 'S92131A', 'S92131B', 'S92131D', 'S92131G', 'S92131K', 'S92131P', 'S92131S',
        'S92132A', 'S92132B', 'S92132D', 'S92132G', 'S92132K', 'S92132P', 'S92132S', 'S92133A',
        'S92133B', 'S92133D', 'S92133G', 'S92133K', 'S92133P', 'S92133S', 'S92134A', 'S92134B',
        'S92134D', 'S92134G', 'S92134K', 'S92134P', 'S92134S', 'S92135A', 'S92135B', 'S92135D',
        'S92135G', 'S92135K', 'S92135P', 'S92135S', 'S92136A', 'S92136B', 'S92136D', 'S92136G',
        'S92136K', 'S92136P', 'S92136S', 'S92141A', 'S92141B', 'S92141D', 'S92141G', 'S92141K',
        'S92141P', 'S92141S', 'S92142A', 'S92142B', 'S92142D', 'S92142G', 'S92142K', 'S92142P',
        'S92142S', 'S92143A', 'S92143B', 'S92143D', 'S92143G', 'S92143K', 'S92143P', 'S92143S',
        'S92144A', 'S92144B', 'S92144D', 'S92144G', 'S92144K', 'S92144P', 'S92144S', 'S92145A',
        'S92145B', 'S92145D', 'S92145G', 'S92145K', 'S92145P', 'S92145S', 'S92146A', 'S92146B',
        'S92146D', 'S92146G', 'S92146K', 'S92146P', 'S92146S', 'S92151A', 'S92151B', 'S92151D',
        'S92151G', 'S92151K', 'S92151P', 'S92151S', 'S92152A', 'S92152B', 'S92152D', 'S92152G',
        'S92152K', 'S92152P', 'S92152S', 'S92153A', 'S92153B', 'S92153D', 'S92153G', 'S92153K',
        'S92153P', 'S92153S', 'S92154A', 'S92154B', 'S92154D', 'S92154G', 'S92154K', 'S92154P',
        'S92154S', 'S92155A', 'S92155B', 'S92155D', 'S92155G', 'S92155K', 'S92155P', 'S92155S',
        'S92156A', 'S92156B', 'S92156D', 'S92156G', 'S92156K', 'S92156P', 'S92156S', 'S92191A',
        'S92191B', 'S92191D', 'S92191G', 'S92191K', 'S92191P', 'S92191S', 'S92192A', 'S92192B',
        'S92192D', 'S92192G', 'S92192K', 'S92192P', 'S92192S', 'S92199A', 'S92199B', 'S92199D',
        'S92199G', 'S92199K', 'S92199P', 'S92199S', 'S92201A', 'S92201B', 'S92201D', 'S92201G',
        'S92201K', 'S92201P', 'S92201S', 'S92202A', 'S92202B', 'S92202D', 'S92202G', 'S92202K',
        'S92202P', 'S92202S', 'S92209A', 'S92209B', 'S92209D', 'S92209G', 'S92209K', 'S92209P',
        'S92209S', 'S92211A', 'S92211B', 'S92211D', 'S92211G', 'S92211K', 'S92211P', 'S92211S',
        'S92212A', 'S92212B', 'S92212D', 'S92212G', 'S92212K', 'S92212P', 'S92212S', 'S92213A',
        'S92213B', 'S92213D', 'S92213G', 'S92213K', 'S92213P', 'S92213S', 'S92214A', 'S92214B',
        'S92214D', 'S92214G', 'S92214K', 'S92214P', 'S92214S', 'S92215A', 'S92215B', 'S92215D',
        'S92215G', 'S92215K', 'S92215P', 'S92215S', 'S92216A', 'S92216B', 'S92216D', 'S92216G',
        'S92216K', 'S92216P', 'S92216S', 'S92221A', 'S92221B', 'S92221D', 'S92221G', 'S92221K',
        'S92221P', 'S92221S', 'S92222A', 'S92222B', 'S92222D', 'S92222G', 'S92222K', 'S92222P',
        'S92222S', 'S92223A', 'S92223B', 'S92223D', 'S92223G', 'S92223K', 'S92223P', 'S92223S',
        'S92224A', 'S92224B', 'S92224D', 'S92224G', 'S92224K', 'S92224P', 'S92224S', 'S92225A',
        'S92225B', 'S92225D', 'S92225G', 'S92225K', 'S92225P', 'S92225S', 'S92226A', 'S92226B',
        'S92226D', 'S92226G', 'S92226K', 'S92226P', 'S92226S', 'S92231A', 'S92231B', 'S92231D',
        'S92231G', 'S92231K', 'S92231P', 'S92231S', 'S92232A', 'S92232B', 'S92232D', 'S92232G',
        'S92232K', 'S92232P', 'S92232S', 'S92233A', 'S92233B', 'S92233D', 'S92233G', 'S92233K',
        'S92233P', 'S92233S', 'S92234A', 'S92234B', 'S92234D', 'S92234G', 'S92234K', 'S92234P',
        'S92234S', 'S92235A', 'S92235B', 'S92235D', 'S92235G', 'S92235K', 'S92235P', 'S92235S',
        'S92236A', 'S92236B', 'S92236D', 'S92236G', 'S92236K', 'S92236P', 'S92236S', 'S92241A',
        'S92241B', 'S92241D', 'S92241G', 'S92241K', 'S92241P', 'S92241S', 'S92242A', 'S92242B',
        'S92242D', 'S92242G', 'S92242K', 'S92242P', 'S92242S', 'S92243A', 'S92243B', 'S92243D',
        'S92243G', 'S92243K', 'S92243P', 'S92243S', 'S92244A', 'S92244B', 'S92244D', 'S92244G',
        'S92244K', 'S92244P', 'S92244S', 'S92245A', 'S92245B', 'S92245D', 'S92245G', 'S92245K',
        'S92245P', 'S92245S', 'S92246A', 'S92246B', 'S92246D', 'S92246G', 'S92246K', 'S92246P',
        'S92246S', 'S92251A', 'S92251B', 'S92251D', 'S92251G', 'S92251K', 'S92251P', 'S92251S',
        'S92252A', 'S92252B', 'S92252D', 'S92252G', 'S92252K', 'S92252P', 'S92252S', 'S92253A',
        'S92253B', 'S92253D', 'S92253G', 'S92253K', 'S92253P', 'S92253S', 'S92254A', 'S92254B',
        'S92254D', 'S92254G', 'S92254K', 'S92254P', 'S92254S', 'S92255A', 'S92255B', 'S92255D',
        'S92255G', 'S92255K', 'S92255P', 'S92255S', 'S92256A', 'S92256B', 'S92256D', 'S92256G',
        'S92256K', 'S92256P', 'S92256S', 'S92301A', 'S92301B', 'S92301D', 'S92301G', 'S92301K',
        'S92301P', 'S92301S', 'S92302A', 'S92302B', 'S92302D', 'S92302G', 'S92302K', 'S92302P',
        'S92302S', 'S92309A', 'S92309B', 'S92309D', 'S92309G', 'S92309K', 'S92309P', 'S92309S',
        'S92311A', 'S92311B', 'S92311D', 'S92311G', 'S92311K', 'S92311P', 'S92311S', 'S92312A',
        'S92312B', 'S92312D', 'S92312G', 'S92312K', 'S92312P', 'S92312S', 'S92313A', 'S92313B',
        'S92313D', 'S92313G', 'S92313K', 'S92313P', 'S92313S', 'S92314A', 'S92314B', 'S92314D',
        'S92314G', 'S92314K', 'S92314P', 'S92314S', 'S92315A', 'S92315B', 'S92315D', 'S92315G',
        'S92315K', 'S92315P', 'S92315S', 'S92316A', 'S92316B', 'S92316D', 'S92316G', 'S92316K',
        'S92316P', 'S92316S', 'S92321A', 'S92321B', 'S92321D', 'S92321G', 'S92321K', 'S92321P',
        'S92321S', 'S92322A', 'S92322B', 'S92322D', 'S92322G', 'S92322K', 'S92322P', 'S92322S',
        'S92323A', 'S92323B', 'S92323D', 'S92323G', 'S92323K', 'S92323P', 'S92323S', 'S92324A',
        'S92324B', 'S92324D', 'S92324G', 'S92324K', 'S92324P', 'S92324S', 'S92325A', 'S92325B',
        'S92325D', 'S92325G', 'S92325K', 'S92325P', 'S92325S', 'S92326A', 'S92326B', 'S92326D',
        'S92326G', 'S92326K', 'S92326P', 'S92326S', 'S92331A', 'S92331B', 'S92331D', 'S92331G',
        'S92331K', 'S92331P', 'S92331S', 'S92332A', 'S92332B', 'S92332D', 'S92332G', 'S92332K',
        'S92332P', 'S92332S', 'S92333A', 'S92333B', 'S92333D', 'S92333G', 'S92333K', 'S92333P',
        'S92333S', 'S92334A', 'S92334B', 'S92334D', 'S92334G', 'S92334K', 'S92334P', 'S92334S',
        'S92335A', 'S92335B', 'S92335D', 'S92335G', 'S92335K', 'S92335P', 'S92335S', 'S92336A',
        'S92336B', 'S92336D', 'S92336G', 'S92336K', 'S92336P', 'S92336S', 'S92341A', 'S92341B',
        'S92341D', 'S92341G', 'S92341K', 'S92341P', 'S92341S', 'S92342A', 'S92342B', 'S92342D',
        'S92342G', 'S92342K', 'S92342P', 'S92342S', 'S92343A', 'S92343B', 'S92343D', 'S92343G',
        'S92343K', 'S92343P', 'S92343S', 'S92344A', 'S92344B', 'S92344D', 'S92344G', 'S92344K',
        'S92344P', 'S92344S', 'S92345A', 'S92345B', 'S92345D', 'S92345G', 'S92345K', 'S92345P',
        'S92345S', 'S92346A', 'S92346B', 'S92346D', 'S92346G', 'S92346K', 'S92346P', 'S92346S',
        'S92351A', 'S92351B', 'S92351D', 'S92351G', 'S92351K', 'S92351P', 'S92351S', 'S92352A',
        'S92352B', 'S92352D', 'S92352G', 'S92352K', 'S92352P', 'S92352S', 'S92353A', 'S92353B',
        'S92353D', 'S92353G', 'S92353K', 'S92353P', 'S92353S', 'S92354A', 'S92354B', 'S92354D',
        'S92354G', 'S92354K', 'S92354P', 'S92354S', 'S92355A', 'S92355B', 'S92355D', 'S92355G',
        'S92355K', 'S92355P', 'S92355S', 'S92356A', 'S92356B', 'S92356D', 'S92356G', 'S92356K',
        'S92356P', 'S92356S', 'S92401A', 'S92401B', 'S92401D', 'S92401G', 'S92401K', 'S92401P',
        'S92401S', 'S92402A', 'S92402B', 'S92402D', 'S92402G', 'S92402K', 'S92402P', 'S92402S',
        'S92403A', 'S92403B', 'S92403D', 'S92403G', 'S92403K', 'S92403P', 'S92403S', 'S92404A',
        'S92404B', 'S92404D', 'S92404G', 'S92404K', 'S92404P', 'S92404S', 'S92405A', 'S92405B',
        'S92405D', 'S92405G', 'S92405K', 'S92405P', 'S92405S', 'S92406A', 'S92406B', 'S92406D',
        'S92406G', 'S92406K', 'S92406P', 'S92406S', 'S92411A', 'S92411B', 'S92411D', 'S92411G',
        'S92411K', 'S92411P', 'S92411S', 'S92412A', 'S92412B', 'S92412D', 'S92412G', 'S92412K',
        'S92412P', 'S92412S', 'S92413A', 'S92413B', 'S92413D', 'S92413G', 'S92413K', 'S92413P',
        'S92413S', 'S92414A', 'S92414B', 'S92414D', 'S92414G', 'S92414K', 'S92414P', 'S92414S',
        'S92415A', 'S92415B', 'S92415D', 'S92415G', 'S92415K', 'S92415P', 'S92415S', 'S92416A',
        'S92416B', 'S92416D', 'S92416G', 'S92416K', 'S92416P', 'S92416S', 'S92421A', 'S92421B',
        'S92421D', 'S92421G', 'S92421K', 'S92421P', 'S92421S', 'S92422A', 'S92422B', 'S92422D',
        'S92422G', 'S92422K', 'S92422P', 'S92422S', 'S92423A', 'S92423B', 'S92423D', 'S92423G',
        'S92423K', 'S92423P', 'S92423S', 'S92424A', 'S92424B', 'S92424D', 'S92424G', 'S92424K',
        'S92424P', 'S92424S', 'S92425A', 'S92425B', 'S92425D', 'S92425G', 'S92425K', 'S92425P',
        'S92425S', 'S92426A', 'S92426B', 'S92426D', 'S92426G', 'S92426K', 'S92426P', 'S92426S',
        'S92491A', 'S92491B', 'S92491D', 'S92491G', 'S92491K', 'S92491P', 'S92491S', 'S92492A',
        'S92492B', 'S92492D', 'S92492G', 'S92492K', 'S92492P', 'S92492S', 'S92499A', 'S92499B',
        'S92499D', 'S92499G', 'S92499K', 'S92499P', 'S92499S', 'S92501A', 'S92501B', 'S92501D',
        'S92501G', 'S92501K', 'S92501P', 'S92501S', 'S92502A', 'S92502B', 'S92502D', 'S92502G',
        'S92502K', 'S92502P', 'S92502S', 'S92503A', 'S92503B', 'S92503D', 'S92503G', 'S92503K',
        'S92503P', 'S92503S', 'S92504A', 'S92504B', 'S92504D', 'S92504G', 'S92504K', 'S92504P',
        'S92504S', 'S92505A', 'S92505B', 'S92505D', 'S92505G', 'S92505K', 'S92505P', 'S92505S',
        'S92506A', 'S92506B', 'S92506D', 'S92506G', 'S92506K', 'S92506P', 'S92506S', 'S92511A',
        'S92511B', 'S92511D', 'S92511G', 'S92511K', 'S92511P', 'S92511S', 'S92512A', 'S92512B',
        'S92512D', 'S92512G', 'S92512K', 'S92512P', 'S92512S', 'S92513A', 'S92513B', 'S92513D',
        'S92513G', 'S92513K', 'S92513P', 'S92513S', 'S92514A', 'S92514B', 'S92514D', 'S92514G',
        'S92514K', 'S92514P', 'S92514S', 'S92515A', 'S92515B', 'S92515D', 'S92515G', 'S92515K',
        'S92515P', 'S92515S', 'S92516A', 'S92516B', 'S92516D', 'S92516G', 'S92516K', 'S92516P',
        'S92516S', 'S92521A', 'S92521B', 'S92521D', 'S92521G', 'S92521K', 'S92521P', 'S92521S',
        'S92522A', 'S92522B', 'S92522D', 'S92522G', 'S92522K', 'S92522P', 'S92522S', 'S92523A',
        'S92523B', 'S92523D', 'S92523G', 'S92523K', 'S92523P', 'S92523S', 'S92524A', 'S92524B',
        'S92524D', 'S92524G', 'S92524K', 'S92524P', 'S92524S', 'S92525A', 'S92525B', 'S92525D',
        'S92525G', 'S92525K', 'S92525P', 'S92525S', 'S92526A', 'S92526B', 'S92526D', 'S92526G',
        'S92526K', 'S92526P', 'S92526S', 'S92531A', 'S92531B', 'S92531D', 'S92531G', 'S92531K',
        'S92531P', 'S92531S', 'S92532A', 'S92532B', 'S92532D', 'S92532G', 'S92532K', 'S92532P',
        'S92532S', 'S92533A', 'S92533B', 'S92533D', 'S92533G', 'S92533K', 'S92533P', 'S92533S',
        'S92534A', 'S92534B', 'S92534D', 'S92534G', 'S92534K', 'S92534P', 'S92534S', 'S92535A',
        'S92535B', 'S92535D', 'S92535G', 'S92535K', 'S92535P', 'S92535S', 'S92536A', 'S92536B',
        'S92536D', 'S92536G', 'S92536K', 'S92536P', 'S92536S', 'S92591A', 'S92591B', 'S92591D',
        'S92591G', 'S92591K', 'S92591P', 'S92591S', 'S92592A', 'S92592B', 'S92592D', 'S92592G',
        'S92592K', 'S92592P', 'S92592S', 'S92599A', 'S92599B', 'S92599D', 'S92599G', 'S92599K',
        'S92599P', 'S92599S', 'S92901A', 'S92901B', 'S92901D', 'S92901G', 'S92901K', 'S92901P',
        'S92901S', 'S92902A', 'S92902B', 'S92902D', 'S92902G', 'S92902K', 'S92902P', 'S92902S',
        'S92909A', 'S92909B', 'S92909D', 'S92909G', 'S92909K', 'S92909P', 'S92909S', 'S92911A',
        'S92911B', 'S92911D', 'S92911G', 'S92911K', 'S92911P', 'S92911S', 'S92912A', 'S92912B',
        'S92912D', 'S92912G', 'S92912K', 'S92912P', 'S92912S', 'S92919A', 'S92919B', 'S92919D',
        'S92919G', 'S92919K', 'S92919P', 'S92919S', 'S9304XA', 'S9304XD', 'S9304XS', 'S9305XA',
        'S9305XD', 'S9305XS', 'S9306XA', 'S9306XD', 'S9306XS', 'S93104A', 'S93104D', 'S93104S',
        'S93105A', 'S93105D', 'S93105S', 'S93106A', 'S93106D', 'S93106S', 'S93111A', 'S93111D',
        'S93111S', 'S93112A', 'S93112D', 'S93112S', 'S93113A', 'S93113D', 'S93113S', 'S93114A',
        'S93114D', 'S93114S', 'S93115A', 'S93115D', 'S93115S', 'S93116A', 'S93116D', 'S93116S',
        'S93119A', 'S93119D', 'S93119S', 'S93121A', 'S93121D', 'S93121S', 'S93122A', 'S93122D',
        'S93122S', 'S93123A', 'S93123D', 'S93123S', 'S93124A', 'S93124D', 'S93124S', 'S93125A',
        'S93125D', 'S93125S', 'S93126A', 'S93126D', 'S93126S', 'S93129A', 'S93129D', 'S93129S',
        'S93304A', 'S93304D', 'S93304S', 'S93305A', 'S93305D', 'S93305S', 'S93306A', 'S93306D',
        'S93306S', 'S93314A', 'S93314D', 'S93314S', 'S93315A', 'S93315D', 'S93315S', 'S93316A',
        'S93316D', 'S93316S', 'S93324A', 'S93324D', 'S93324S', 'S93325A', 'S93325D', 'S93325S',
        'S93326A', 'S93326D', 'S93326S', 'S93334A', 'S93334D', 'S93334S', 'S93335A', 'S93335D',
        'S93335S', 'S93336A', 'S93336D', 'S93336S'
    }

    SNOMEDCT = {
        '10061007', '10256000', '10310006', '105606008', '105612003', '105621002', '10568008',
        '10575009', '10771002', '108367008', '109379000', '10998006', '110016007', '110017003',
        '110018008', '110019000', '110020006', '110021005', '110022003', '110023008', '110024002',
        '110025001', '110026000', '110027009', '110028004', '110029007', '110030002', '11008006',
        '110150000', '111245009', '111593004', '111597003', '111601003', '111603000', '111605007',
        '111607004', '111609001', '111611005', '111613008', '111615001', '111617009', '111622009',
        '111633007', '111637008', '111638003', '111639006', '111640008', '111641007', '111642000',
        '111643005', '111644004', '111645003', '111646002', '111647006', '111648001', '111649009',
        '111651008', '111671004', '111673001', '111677000', '111681000', '111683002', '111684008',
        '111691006', '111727008', '111729006', '111731002', '111733004', '11229008', '11254008',
        '11413003', '11782000', '11805005', '11807002', '11920000', '12204004', '12227007',
        '122773008', '123534001', '123535000', '123618009', '123619001', '123971006', '123972004',
        '123973009', '123975002', '12412005', '12462000', '125588009', '125589001', '125591009',
        '125593007', '125594001', '125595000', '125596004', '125597008', '125598003', '125599006',
        '125600009', '125601008', '125602001', '125603006', '125604000', '125605004', '125606003',
        '125607007', '125608002', '125609005', '125610000', '125612008', '125613003', '125614009',
        '125615005', '125616006', '125617002', '125618007', '125619004', '125620005', '125621009',
        '125622002', '125623007', '125625000', '125626004', '125627008', '125628003', '125629006',
        '125630001', '125631002', '125632009', '125633004', '125634005', '125635006', '125636007',
        '125637003', '125638008', '125639000', '125640003', '125641004', '125642006', '125802004',
        '125871005', '125872003', '12588000', '12589008', '1261007', '1264004', '12676007',
        '12694001', '127275008', '127276009', '127278005', '127279002', '127280004', '127281000',
        '127282007', '127283002', '127284008', '127285009', '127286005', '127287001', '127288006',
        '127289003', '127290007', '127291006', '127295002', '127296001', '127297005', '127298000',
        '127299008', '127300000', '127301001', '127302008', '127303003', '127304009', '127305005',
        '127306006', '127307002', '127313006', '12746007', '128069005', '128125000', '128126004',
        '12912004', '129156001', '129157005', '129161004', '129162006', '129163001', '129164007',
        '129165008', '129166009', '13019000', '13047001', '1317001', '13194006', '13289004',
        '134291007', '134424008', '13456001', '13463001', '13498003', '13553006', '13695006',
        '1370007', '13752003', '13891000', '13975002', '1419004', '14434006', '14457000',
        '14493003', '14505003', '14546008', '14584002', '14675005', '14741001', '14817008',
        '14916000', '14950009', '15151004', '15271003', '15385006', '1544005', '15474008',
        '15574005', '15701003', '15724005', '157265008', '15741007', '15929008', '16111009',
        '16114001', '16319002', '1658003', '16695002', '16837005', '16950007', '1705000',
        '1708003', '171008', '17169009', '17194005', '17214002', '17222009', '1734006', '17367000',
        '1739001', '17414004', '17463000', '17498002', '17616007', '17633000', '17667005',
        '17819003', '18147000', '18171007', '18276007', '18296004', '18336000', '18531006',
        '18605003', '18685001', '18724009', '18960007', '19090007', '19210000', '19233004',
        '19234005', '19241004', '19259001', '19491003', '195160000', '19652000', '19856004',
        '1988005', '19936001', '20026002', '20100009', '2012002', '20121009', '20132009',
        '20158009', '20167009', '20213006', '20274005', '20276007', '202974002', '20341008',
        '203709007', '20377001', '20402005', '20433007', '20474007', '20511007', '205254006',
        '2053005', '20580001', '20594000', '206209004', '20714001', '20736003', '207687004',
        '207689001', '207690005', '207691009', '207692002', '207693007', '207696004', '207705002',
        '207707005', '207708000', '207709008', '207710003', '207711004', '207727006', '207728001',
        '207729009', '207730004', '207731000', '207745006', '207746007', '207747003', '207748008',
        '207749000', '207753003', '207755005', '207757002', '207759004', '207760009', '207763006',
        '207767007', '207768002', '207769005', '207771005', '207776000', '207782002', '207785000',
        '207787008', '207788003', '207794006', '207798009', '207800002', '20784007', '207881000',
        '207884008', '207895002', '207896001', '207897005', '207898000', '207899008', '207900003',
        '207901004', '207902006', '207903001', '207904007', '207905008', '207906009', '207907000',
        '207908005', '207909002', '207910007', '207921003', '207922005', '207923000', '207924006',
        '207925007', '207926008', '207927004', '207928009', '207929001', '207930006', '207931005',
        '207932003', '207933008', '207934002', '207935001', '207936000', '207938004', '207939007',
        '207940009', '207941008', '207942001', '207943006', '207944000', '207945004', '207949005',
        '207950005', '207951009', '207952002', '207953007', '207954001', '207955000', '207956004',
        '207957008', '207958003', '207959006', '207960001', '207961002', '207962009', '207963004',
        '207964005', '207965006', '207966007', '207967003', '207968008', '207969000', '207970004',
        '207971000', '207972007', '207974008', '207975009', '207976005', '207977001', '207978006',
        '207979003', '207980000', '207981001', '207983003', '207984009', '207985005', '207986006',
        '207993005', '207998001', '208000003', '208001004', '208002006', '208003001', '208006009',
        '208007000', '208008005', '208009002', '208012004', '208014003', '208015002', '208016001',
        '208017005', '208020002', '208021003', '208022005', '208023000', '208026008', '208028009',
        '208029001', '208030006', '208031005', '208034002', '208035001', '208036000', '208037009',
        '208040009', '208042001', '208043006', '208044000', '208045004', '208048002', '208049005',
        '208050005', '208051009', '208054001', '208056004', '208057008', '208058003', '208059006',
        '208060001', '208061002', '208063004', '208064005', '208065006', '208066007', '208067003',
        '208069000', '208071000', '208076005', '208078006', '208082008', '208084009', '208088007',
        '208090008', '208097006', '208130009', '208131008', '208146001', '208147005', '208148000',
        '208149008', '208150008', '208151007', '208155003', '208156002', '208157006', '208158001',
        '208159009', '208160004', '208164008', '208165009', '208166005', '208168006', '208172005',
        '208173000', '208174006', '208181004', '208182006', '208183001', '208184007', '208185008',
        '208186009', '208192003', '208193008', '208194002', '208195001', '208197009', '208198004',
        '208202002', '208203007', '208204001', '208205000', '208206004', '208207008', '208215006',
        '208225001', '208226000', '208227009', '208228004', '208229007', '208232005', '208233000',
        '208234006', '208235007', '208236008', '208240004', '208241000', '208242007', '208244008',
        '208245009', '208246005', '208250003', '208251004', '208253001', '208254007', '208255008',
        '208256009', '208257000', '208267005', '208270009', '208271008', '208272001', '208273006',
        '208274000', '208281007', '208283005', '208284004', '208285003', '208286002', '208294009',
        '208295005', '208296006', '208298007', '208301006', '208303009', '208304003', '208306001',
        '208309008', '208312006', '208318005', '208321007', '208322000', '208323005', '208324004',
        '208325003', '208326002', '208336005', '208337001', '208340001', '208341002', '208342009',
        '208343004', '208344005', '208345006', '208369005', '208370006', '208371005', '208372003',
        '208373008', '208374002', '208375001', '208379007', '208380005', '208381009', '208382002',
        '208383007', '208384001', '208385000', '208388003', '208390002', '208393000', '208394006',
        '208396008', '208397004', '208399001', '208400008', '208401007', '208402000', '208403005',
        '208404004', '208405003', '208406002', '208408001', '208413002', '208414008', '208416005',
        '208417001', '208418006', '208419003', '208420009', '208421008', '208422001', '208423006',
        '208424000', '208427007', '208428002', '208430000', '208434009', '208435005', '208436006',
        '208437002', '208438007', '208439004', '208440002', '208441003', '208442005', '208443000',
        '208444006', '208445007', '208446008', '208447004', '208448009', '208449001', '208450001',
        '208451002', '208452009', '208453004', '208454005', '208455006', '208456007', '208457003',
        '208458008', '208459000', '208460005', '208461009', '208463007', '208467008', '208468003',
        '208469006', '208470007', '208471006', '208472004', '208473009', '208474003', '208475002',
        '208476001', '208477005', '208478000', '208479008', '208480006', '208481005', '208482003',
        '208483008', '208484002', '208485001', '208486000', '208487009', '208488004', '208489007',
        '208490003', '208491004', '208492006', '208493001', '208494007', '208499002', '208500006',
        '208502003', '208503008', '208505001', '208508004', '208509007', '208510002', '208513000',
        '208514006', '208521006', '208523009', '208524003', '208526001', '208528000', '208529008',
        '208530003', '208531004', '208536009', '208537000', '208540000', '208541001', '208542008',
        '208543003', '208544009', '208548007', '208550004', '208551000', '208552007', '208555009',
        '208557001', '208558006', '208559003', '208562000', '208578003', '208579006', '208580009',
        '208581008', '208582001', '208587007', '208588002', '208589005', '208590001', '208591002',
        '208596007', '208597003', '208598008', '208600002', '208601003', '208602005', '208603000',
        '208604006', '208605007', '208606008', '208610006', '208611005', '208612003', '208613008',
        '208614002', '208615001', '208619007', '208620001', '208621002', '208622009', '208623004',
        '208624005', '208625006', '208627003', '208629000', '208631009', '208632002', '208634001',
        '208635000', '208636004', '208637008', '208638003', '208639006', '208657007', '208658002',
        '208659005', '208660000', '208662008', '208663003', '208664009', '208665005', '208666006',
        '208667002', '208668007', '208669004', '208677000', '208678005', '208679002', '208680004',
        '208684008', '208685009', '208686005', '208687001', '208688006', '208689003', '208690007',
        '208691006', '208692004', '208696001', '208697005', '208698000', '208699008', '208700009',
        '208701008', '208702001', '208703006', '208704000', '208710000', '208711001', '208712008',
        '208713003', '208715005', '208716006', '208717002', '208718007', '208719004', '208731002',
        '208732009', '208733004', '208748005', '208749002', '208750002', '208754006', '208759001',
        '208766000', '208768004', '208769007', '208774004', '208775003', '208778001', '208779009',
        '208782004', '208785002', '208786001', '208787005', '208788000', '208789008', '208790004',
        '208795009', '208796005', '208797001', '208798006', '208799003', '208800004', '208803002',
        '208805009', '208806005', '208808006', '208811007', '208815003', '208816002', '208818001',
        '208819009', '208820003', '208826009', '208827000', '208828005', '208829002', '208830007',
        '208831006', '208832004', '208836001', '208838000', '208839008', '208840005', '208842002',
        '208843007', '208844001', '208846004', '208848003', '208849006', '208850006', '208851005',
        '208852003', '208853008', '208857009', '208859007', '208860002', '208861003', '208862005',
        '208864006', '208866008', '208869001', '208870000', '208871001', '208872008', '208873003',
        '208874009', '208876006', '208878007', '208879004', '208880001', '208881002', '208882009',
        '208883004', '208885006', '208886007', '208887003', '208888008', '208889000', '208892001',
        '208894000', '208895004', '208896003', '208900000', '208901001', '208902008', '208904009',
        '208906006', '208907002', '208908007', '208910009', '208911008', '208929003', '208930008',
        '208931007', '208932000', '208933005', '208934004', '208937006', '208938001', '208939009',
        '208940006', '208941005', '208942003', '208946000', '208947009', '208948004', '208949007',
        '208950007', '208951006', '208953009', '208954003', '208955002', '208956001', '208957005',
        '208958000', '208959008', '208961004', '208962006', '208963001', '208964007', '208965008',
        '208966009', '208967000', '208970001', '208971002', '208972009', '208973004', '208974005',
        '208975006', '208977003', '208981003', '208983000', '208984006', '208986008', '20899000',
        '208990005', '208993007', '208994001', '208995000', '208996004', '208997008', '208998003',
        '209000008', '209003005', '209004004', '209006002', '209007006', '209008001', '209010004',
        '209011000', '209013002', '209016005', '209017001', '209018006', '209019003', '209020009',
        '209021008', '209022001', '209023006', '209024000', '209027007', '209028002', '209029005',
        '209030000', '209031001', '209032008', '209033003', '209034009', '209037002', '209046008',
        '209048009', '209049001', '209050001', '209051002', '209052009', '209054005', '209064001',
        '209066004', '209067008', '209068003', '209069006', '209071006', '209073009', '209074003',
        '209075002', '209077005', '209078000', '209079008', '209080006', '209082003', '209083008',
        '209084002', '209085001', '209086000', '209088004', '209090003', '209092006', '209093001',
        '209094007', '209095008', '209097000', '209098005', '209100005', '209101009', '209102002',
        '209117003', '209118008', '209119000', '209120006', '209121005', '209122003', '209127009',
        '209128004', '209129007', '209131003', '209134006', '209136008', '209137004', '209138009',
        '209139001', '209140004', '209141000', '209142007', '209143002', '209145009', '209146005',
        '209147001', '209148006', '209149003', '209151004', '209153001', '209154007', '209155008',
        '209156009', '209157000', '209158005', '209159002', '209160007', '209162004', '209163009',
        '209164003', '209165002', '209166001', '209168000', '209169008', '209170009', '209173006',
        '209174000', '209175004', '209176003', '209178002', '209179005', '209180008', '209181007',
        '209182000', '209184004', '209185003', '209186002', '209188001', '209189009', '209190000',
        '209191001', '209193003', '209194009', '209195005', '209196006', '209197002', '209201002',
        '209202009', '209206007', '209208008', '209211009', '209212002', '209213007', '209214001',
        '209215000', '209216004', '209217008', '209218003', '209221001', '209222008', '209223003',
        '209224009', '209225005', '209226006', '209227002', '209228007', '209236003', '209238002',
        '209239005', '209242004', '209243009', '209244003', '209245002', '209246001', '209248000',
        '209249008', '209250008', '209252000', '209253005', '209255003', '209256002', '209257006',
        '209258001', '209259009', '209261000', '209262007', '209263002', '209264008', '209265009',
        '209266005', '209267001', '209268006', '209269003', '209270002', '209271003', '209273000',
        '209274006', '209276008', '209277004', '209278009', '209279001', '209280003', '209281004',
        '209283001', '209284007', '209285008', '209286009', '209287000', '209288005', '209289002',
        '209290006', '209292003', '209293008', '209294002', '209295001', '209296000', '209297009',
        '209298004', '209299007', '209301000', '209302007', '209304008', '209306005', '209307001',
        '209308006', '209309003', '209310008', '209312000', '209314004', '209315003', '209316002',
        '209317006', '209318001', '209320003', '209322006', '209323001', '209324007', '209325008',
        '209326009', '209328005', '209330007', '209331006', '209332004', '209333009', '209335002',
        '209336001', '209337005', '209338000', '209339008', '209340005', '209341009', '209342002',
        '209343007', '209344001', '209345000', '209346004', '209347008', '209348003', '209349006',
        '209350006', '209351005', '209352003', '209353008', '209354002', '209355001', '209356000',
        '209357009', '209358004', '209359007', '209360002', '209361003', '209362005', '209363000',
        '209364006', '209365007', '209366008', '209367004', '209368009', '209369001', '209370000',
        '209371001', '209372008', '209373003', '209374009', '209375005', '209377002', '209378007',
        '209379004', '209380001', '209381002', '209382009', '209383004', '209384005', '209385006',
        '209386007', '209390009', '209391008', '209392001', '209394000', '209395004', '209396003',
        '209397007', '209399005', '209400003', '209401004', '209402006', '209404007', '209405008',
        '209406009', '209407000', '209827006', '209828001', '209829009', '209830004', '209834008',
        '209843004', '209845006', '209847003', '209848008', '209849000', '209850000', '209864000',
        '209865004', '209866003', '209867007', '209868002', '209871005', '209881009', '209883007',
        '209884001', '209885000', '209886004', '209887008', '209900006', '209902003', '209903008',
        '209904002', '209905001', '209906000', '209920007', '209921006', '209922004', '209923009',
        '209924003', '209940000', '209956005', '209958006', '209978003', '209987007', '210038008',
        '210039000', '210051003', '210052005', '210060006', '210063008', '210064002', '210067009',
        '210073005', '210076002', '210078001', '210083009', '210084003', '210086001', '210087005',
        '210088000', '210089008', '210093002', '210094008', '210095009', '210104002', '210106000',
        '210114006', '210116008', '210128000', '210130003', '210131004', '210132006', '210133001',
        '210135008', '210150004', '210155009', '210156005', '210157001', '210159003', '210160008',
        '210173007', '210174001', '210175000', '210176004', '210180009', '210188002', '210191002',
        '210192009', '210197003', '210203000', '210205007', '210206008', '210213008', '210216000',
        '210217009', '210220001', '210221002', '210222009', '210229000', '210241007', '210242000',
        '210243005', '210244004', '210245003', '210260000', '210262008', '210263003', '210272006',
        '210679005', '210680008', '210706009', '210782008', '210915008', '210916009', '210931000',
        '210937001', '210942009', '210950000', '210951001', '210952008', '210953003', '210954009',
        '210955005', '210957002', '210958007', '210959004', '210960009', '210961008', '210962001',
        '210963006', '210964000', '210965004', '210966003', '210967007', '210973008', '210974002',
        '210975001', '210976000', '212169004', '212171004', '212172006', '212173001', '212174007',
        '212177000', '212178005', '212179002', '212180004', '212183002', '212185009', '212186005',
        '212187001', '212188006', '212190007', '212194003', '212197005', '212198000', '212199008',
        '212200006', '212201005', '212202003', '212203008', '212205001', '212206000', '212207009',
        '212208004', '212209007', '212210002', '212211003', '212212005', '212213000', '212214006',
        '212215007', '212216008', '212217004', '212218009', '212219001', '212220007', '212221006',
        '212222004', '212223009', '212224003', '212225002', '212226001', '212227005', '212247002',
        '212296007', '212380006', '212381005', '212382003', '212383008', '212384002', '212385001',
        '212386000', '212399002', '212400009', '212421009', '212451003', '212456008', '212467009',
        '212469007', '212470008', '212471007', '212472000', '212473005', '212483009', '212486001',
        '212489008', '213346004', '213347008', '213350006', '213351005', '213354002', '213355001',
        '213358004', '213361003', '213375005', '213387003', '21351003', '21369007', '21419000',
        '21454007', '21573009', '21580006', '21698002', '21763005', '21835004', '21867001',
        '21949009', '21978005', '22000002', '2202000', '22025006', '22095002', '22225000',
        '22234005', '22383006', '22564003', '22682006', '22693008', '22713002', '22724000',
        '22802006', '22819008', '22825007', '22897006', '22911007', '2295008', '22973003',
        '23020007', '23026001', '23039002', '23055009', '230614002', '23123006', '231813003',
        '232265009', '232277004', '232278009', '232279001', '23283004', '23368007', '233975007',
        '23406007', '235627001', '235698003', '235887001', '23589004', '23611004', '236431008',
        '23658007', '2366001', '23697004', '237090005', '23713006', '23741005', '237573009',
        '237660002', '23813004', '23900009', '239750008', '239755003', '239756002', '240037007',
        '240127000', '24056002', '24063002', '24179004', '241989005', '242007009', '24212007',
        '24300005', '24350003', '24380008', '24392008', '24424003', '24850009', '24948002',
        '25110002', '25185004', '25331007', '25345001', '25415003', '25420003', '25424007',
        '25427000', '25529004', '25554004', '25586009', '25689009', '25899002', '26176009',
        '262520005', '262521009', '262522002', '262525000', '262626005', '262675006', '262683000',
        '262687004', '262688009', '262689001', '262691009', '262692002', '262693007', '262696004',
        '262697008', '262700007', '262705002', '262706001', '262707005', '262708000', '262709008',
        '262710003', '262711004', '262712006', '262713001', '262714007', '262717000', '262718005',
        '262719002', '262724004', '262725003', '262726002', '262727006', '262729009', '262730004',
        '262731000', '262732007', '262734008', '262735009', '262736005', '262737001', '262740001',
        '262741002', '262742009', '262743004', '262745006', '262746007', '262747003', '262748008',
        '262768002', '262775001', '262778004', '262780005', '262782002', '262783007', '262784001',
        '262785000', '262787008', '262788003', '262791003', '262792005', '262793000', '262795007',
        '262799001', '262801003', '262802005', '262803000', '262804006', '262805007', '262809001',
        '262810006', '262811005', '262812003', '262813008', '262815001', '262816000', '262820001',
        '262821002', '262822009', '262823004', '262824005', '262827003', '262828008', '262829000',
        '262830005', '262831009', '262833007', '262834001', '262835000', '262836004', '262845003',
        '262849009', '262850009', '262851008', '262853006', '262854000', '262855004', '262856003',
        '262857007', '262859005', '262860000', '262862008', '262863003', '262864009', '262866006',
        '262867002', '262868007', '262869004', '262871004', '262872006', '262873001', '262874007',
        '262875008', '262877000', '262878005', '262879002', '262881000', '262882007', '262883002',
        '262884008', '262885009', '262886005', '262887001', '262888006', '262889003', '262893009',
        '262897005', '262898000', '262900003', '262907000', '262911006', '262912004', '262913009',
        '262914003', '262915002', '262916001', '262918000', '262919008', '262920002', '262926008',
        '262928009', '262931005', '262932003', '262933008', '262952002', '262955000', '263004001',
        '263009006', '263010001', '263011002', '263012009', '263013004', '263014005', '263015006',
        '263017003', '263019000', '263020006', '263021005', '263022003', '263023008', '263024002',
        '263025001', '263026000', '263027009', '263028004', '263029007', '263030002', '263031003',
        '263034006', '263035007', '263036008', '263037004', '263038009', '263039001', '263040004',
        '263041000', '263042007', '263043002', '263044008', '263045009', '263046005', '263047001',
        '263048006', '263049003', '263050003', '263051004', '263052006', '263053001', '263054007',
        '263055008', '263056009', '263057000', '263058005', '263059002', '263060007', '263061006',
        '263062004', '263063009', '263064003', '263065002', '263066001', '263067005', '263068000',
        '263069008', '263070009', '263071008', '263072001', '263073006', '263074000', '263075004',
        '263076003', '263077007', '263078002', '263079005', '263080008', '263081007', '263082000',
        '263083005', '263084004', '263085003', '263086002', '263087006', '263088001', '263089009',
        '263090000', '263091001', '263092008', '263093003', '263094009', '263095005', '263096006',
        '263097002', '263098007', '263099004', '263100007', '263101006', '263102004', '263103009',
        '263104003', '263105002', '263106001', '263108000', '263109008', '263110003', '263111004',
        '263112006', '263113001', '263114007', '263115008', '263116009', '263117000', '263126002',
        '263148008', '263149000', '263150000', '263151001', '263152008', '263153003', '263154009',
        '263155005', '263156006', '263157002', '263158007', '263159004', '263160009', '263161008',
        '263162001', '263163006', '263164000', '263165004', '263166003', '263167007', '263168002',
        '263169005', '263170006', '263171005', '263172003', '263173008', '263174002', '263175001',
        '263176000', '263177009', '263178004', '263179007', '263180005', '263188003', '263189006',
        '263191003', '263192005', '263193000', '263195007', '263196008', '263197004', '263198009',
        '263199001', '263200003', '263201004', '263203001', '263204007', '263205008', '263206009',
        '263207000', '263208005', '263209002', '263210007', '263211006', '263216001', '263217005',
        '263218000', '263219008', '263220002', '263221003', '263222005', '263225007', '263226008',
        '263227004', '263228009', '263229001', '263231005', '263232003', '263233008', '263234002',
        '263235001', '263236000', '263237009', '263238004', '263239007', '263240009', '263241008',
        '263242001', '263244000', '263245004', '263246003', '263247007', '263248002', '263249005',
        '263250005', '263251009', '263252002', '263253007', '263256004', '263257008', '263262009',
        '263263004', '263264005', '263265006', '263266007', '263267003', '263268008', '263269000',
        '263274008', '26442006', '264534009', '2651006', '26646003', '26738009', '269057007',
        '269061001', '269062008', '269063003', '269064009', '269065005', '269066006', '269067002',
        '269068007', '269069004', '269070003', '269071004', '269072006', '269073001', '269074007',
        '269075008', '269076009', '269077000', '269078005', '269080004', '26908008', '269081000',
        '269083002', '269090007', '269100000', '269103003', '269105005', '269106006', '269107002',
        '269108007', '269111008', '269112001', '269114000', '269115004', '269116003', '269117007',
        '269118002', '269119005', '269120004', '269121000', '269122007', '269123002', '269124008',
        '269125009', '269126005', '269127001', '269128006', '269129003', '269144002', '269151006',
        '269160003', '269187004', '269188009', '269191009', '26938002', '269406001', '27094009',
        '271576001', '271577005', '27158007', '271963003', '274153008', '274154002', '274155001',
        '274156000', '274157009', '274158004', '274160002', '274164006', '274174009', '274175005',
        '27477003', '275272006', '275320004', '275329003', '275331007', '275332000', '275333005',
        '275337006', '275338001', '275339009', '275340006', '275341005', '275342003', '275343008',
        '275361004', '275362006', '275380002', '275382005', '275430007', '27644009', '276464002',
        '277326006', '278488007', '278537006', '279057008', '27923006', '27937002', '28012007',
        '28048009', '28078000', '28081005', '281502009', '281503004', '281504005', '281506007',
        '281513007', '281514001', '281515000', '281516004', '281517008', '281518003', '281519006',
        '281525005', '281526006', '281527002', '281528007', '281529004', '281530009', '281531008',
        '281532001', '281533006', '281534000', '281535004', '281536003', '28155008', '28156009',
        '281843000', '28188001', '281907005', '281908000', '281909008', '281910003', '281911004',
        '281912006', '281913001', '281914007', '281915008', '281916009', '281917000', '281918005',
        '281919002', '281920008', '281921007', '281922000', '281923005', '281924004', '281925003',
        '281926002', '281927006', '281928001', '281929009', '281930004', '281931000', '281932007',
        '281933002', '281934008', '281935009', '281936005', '281937001', '281938006', '281940001',
        '281941002', '282007005', '282050000', '282051001', '282053003', '282055005', '282059004',
        '282062001', '282063006', '282064000', '282066003', '282070006', '282072003', '282076000',
        '282077009', '282085000', '282429000', '282430005', '282431009', '282432002', '282434001',
        '282438003', '282439006', '282446002', '282447006', '282448001', '282463003', '282723003',
        '282725005', '282745002', '282749008', '282751007', '282752000', '282754004', '282755003',
        '282756002', '282757006', '282758001', '282759009', '282762007', '282763002', '282764008',
        '282765009', '282766005', '282771003', '282773000', '282783001', '282784007', '282785008',
        '282786009', '282787000', '28359007', '283905005', '283906006', '283908007', '283909004',
        '283915004', '283916003', '283918002', '283920004', '283922007', '283928006', '283930008',
        '283937006', '283939009', '283940006', '283942003', '283956001', '283957005', '283959008',
        '283961004', '283963001', '283964007', '283979000', '283980002', '28398002', '283981003',
        '283985007', '283998003', '283999006', '284000008', '2840008', '284003005', '284005003',
        '284006002', '28425007', '284346004', '285234008', '285235009', '285236005', '285239003',
        '285668009', '28576007', '285806007', '285807003', '285808008', '285830009', '285834000',
        '287093006', '287094000', '287096003', '287101003', '28753006', '288280006', '288281005',
        '288282003', '288283008', '29014003', '29045004', '29264003', '295723007', '29635000',
        '29691006', '297130008', '297131007', '297132000', '297133005', '297158000', '2973002',
        '29749002', '29807001', '29818001', '29880001', '2999009', '299965004', '30031007',
        '30060003', '301032005', '301033000', '301034006', '301035007', '301757009', '3019000',
        '302034009', '302035005', '302036006', '302037002', '302038007', '302222008', '302232001',
        '302964004', '30371007', '304236004', '30489009', '30632004', '307131005', '307137009',
        '307171000', '307172007', '307178006', '307218005', '307712005', '307713000', '307727005',
        '308153009', '30858001', '30905007', '30943005', '309464009', '31033002', '31062001',
        '31103006', '31110000', '311408004', '311409007', '311814002', '311815001', '311816000',
        '311817009', '311819007', '311820001', '311821002', '311822009', '311825006', '311826007',
        '311827003', '311829000', '311831009', '311842000', '311844004', '311847006', '311848001',
        '311849009', '311850009', '311852001', '311853006', '311857007', '311859005', '311862008',
        '311864009', '31187005', '3119002', '31235003', '312660000', '312661001', '312662008',
        '312786001', '312787005', '312788000', '312792007', '312837005', '312838000', '312839008',
        '312844001', '312847008', '314195000', '314197008', '314198003', '314661000', '314662007',
        '314664008', '314667001', '314668006', '315643003', '316358009', '31693001', '31882001',
        '31975004', '31978002', '31984004', '320934008', '32106001', '32144005', '3217005',
        '3228009', '32311009', '32415004', '32497008', '32734003', '32805004', '3291007',
        '32988004', '33041006', '33072005', '33117006', '33118001', '33141009', '33147008',
        '33173003', '33192001', '3331008', '33332005', '33358005', '33737001', '3381004',
        '33829000', '33908005', '33931005', '33955000', '340036002', '34047002', '34135005',
        '342070009', '3421000', '34262005', '34268009', '34432001', '3446000', '34501004',
        '34565006', '34578006', '34622000', '34649000', '34656006', '34663006', '34751006',
        '34798003', '34813004', '34873006', '34996005', '35106007', '35160004', '35171003',
        '35403005', '3542000', '35442005', '35672006', '357009', '35790004', '35899005',
        '359817006', '359820003', '359823001', '361118003', '361119006', '36127009', '363182001',
        '363183006', '363331007', '3640000', '36417005', '36539009', '36716000', '367527001',
        '36758002', '36778005', '36822000', '36838006', '36924003', '36991002', '37027003',
        '371050006', '371065007', '371128008', '371161001', '371162008', '37134004', '371561008',
        '371712009', '37174005', '373410009', '373716002', '37418005', '37449000', '37490002',
        '3759007', '37619006', '37633006', '37655003', '37798005', '38170003', '38278003',
        '38301007', '38306002', '38372004', '38404000', '38532007', '385424001', '38556006',
        '38567007', '3859001', '38761006', '38972005', '39020005', '3903005', '390986009',
        '3913002', '39131004', '39335003', '39400004', '39408006', '397813008', '398313001',
        '39881005', '399240007', '39993000', '40047007', '40095003', '40135004', '40286002',
        '40521006', '405550001', '405551002', '405552009', '405553004', '405561009', '405572004',
        '405754008', '405755009', '405756005', '405757001', '405758006', '405759003', '405760008',
        '405761007', '405762000', '405763005', '405764004', '405765003', '405766002', '405817008',
        '40613008', '40643005', '40795009', '409765008', '410045006', '410046007', '410047003',
        '410048008', '41025001', '41036008', '41061006', '41078002', '41133002', '41191003',
        '41222005', '41359009', '413875004', '413876003', '413877007', '413878002', '41392003',
        '414292006', '414293001', '41455002', '414942001', '414943006', '414944000', '41511005',
        '41547006', '41608004', '416143005', '416176009', '416352009', '416511004', '416568002',
        '416645004', '416709006', '416833005', '416910005', '417039001', '417076003', '417109008',
        '417202006', '417203001', '417349008', '417474005', '417558002', '417580004', '417613000',
        '417675000', '417746004', '41870008', '418764009', '41972004', '41977005', '42019003',
        '4208000', '42109006', '42157000', '42188001', '42206007', '42261000', '42306005',
        '423125000', '424270008', '42434002', '42438004', '42458003', '424648000', '42479003',
        '424817005', '425359009', '42591009', '4260009', '42636007', '426382004', '426467005',
        '426646004', '426679004', '42670008', '426962008', '427207001', '4273008', '427509002',
        '427584009', '42760000', '427688003', '427740006', '427766009', '427773004', '427803007',
        '427826000', '427904000', '427966000', '428000009', '428018007', '428019004', '428020005',
        '428099003', '428150004', '428151000', '42818005', '428213008', '428232002', '428256003',
        '428257007', '428258002', '428357005', '428512002', '428514001', '428704007', '428723000',
        '428730006', '428797006', '428798001', '428799009', '429186005', '429194003', '429339004',
        '429340002', '429341003', '429342005', '42942008', '429433004', '42945005', '429552008',
        '429630006', '429655000', '429656004', '429664005', '429766001', '430936000', '430948002',
        '430974008', '430984009', '431010004', '431032008', '431674004', '43262000', '43295006',
        '4332009', '43337002', '43405004', '4349002', '4354006', '43756009', '43767005',
        '43841005', '43842003', '438479005', '438480008', '438771009', '439022003', '439426005',
        '439987009', '440366004', '44039000', '440631005', '441496000', '441546003', '441886002',
        '44237008', '442448003', '44264009', '443286004', '44333005', '443395009', '44341005',
        '443786003', '44434003', '444867009', '44504005', '445159008', '445311003', '445410003',
        '445493000', '445711000', '445733003', '445734009', '445779008', '445852002', '445875009',
        '445899009', '44599007', '446019002', '446091003', '446121009', '446195009', '446200000',
        '446298003', '446390008', '446391007', '446392000', '446597007', '446644006', '446835008',
        '446979005', '446980008', '446981007', '44701004', '447016004', '447017008', '447018003',
        '447138000', '447139008', '447259000', '447394009', '447395005', '447396006', '447464004',
        '447575003', '4478002', '448355005', '448768004', '448788000', '448838000', '44916009',
        '44932007', '45179004', '45356009', '45387006', '45455009', '45634004', '45659008',
        '45665008', '45678008', '45696004', '45833007', '45910007', '46020007', '46043003',
        '46272008', '46307004', '46328008', '46357007', '46422008', '46549005', '4673003',
        '46758000', '46773004', '46866001', '46931002', '46948005', '46966000', '46995009',
        '47233002', '47402002', '47450003', '47462004', '4750004', '47533003', '47648003',
        '47771009', '47848000', '47864008', '4788002', '47979002', '47983002', '4807003',
        '48125009', '48187004', '48303008', '48407005', '48424004', '48466003', '48518008',
        '48561006', '48653005', '48752009', '48944001', '48956000', '49011004', '49055005',
        '49128003', '49280002', '49346003', '49497005', '496002', '49747005', '49822004',
        '49880009', '49891002', '49898008', '50008003', '50087006', '50397009', '50444002',
        '50448004', '50531009', '50655009', '5073009', '50888000', '50890004', '51000003',
        '51037009', '51101002', '51155003', '5120006', '51258005', '51514006', '51673001',
        '51760006', '51879004', '52011008', '5202009', '52087004', '52271005', '52289006',
        '52450003', '5251007', '5256002', '52603002', '52622006', '52694000', '52784000',
        '52888005', '52902005', '52913008', '52949009', '53256003', '53267002', '53429002',
        '53441009', '53466008', '53627009', '53730006', '53792000', '53810004', '53868003',
        '54013005', '54075005', '54288002', '54317001', '54355006', '54394007', '54420005',
        '54441004', '54494008', '54530004', '54556006', '54567007', '54637009', '54641008',
        '54645004', '5470004', '54748006', '54957006', '55126004', '55600008', '55702009',
        '55716004', '55798004', '55874001', '55885004', '55983005', '56128006', '56299003',
        '56385004', '56472003', '56642004', '56863004', '56906005', '57012007', '5708009',
        '57099002', '57114005', '57360002', '57467003', '57577003', '57739006', '57771004',
        '57772006', '57998008', '58007009', '58020007', '58070005', '58150001', '58154005',
        '58189007', '58320001', '58565006', '58580000', '58722007', '58731007', '5886004',
        '58919004', '5895007', '59029004', '59038002', '5913000', '59190009', '5949004',
        '59556008', '59561005', '59633005', '59639009', '59648004', '59748008', '59918000',
        '59962009', '60214001', '60464005', '60546000', '60667009', '60843004', '61014001',
        '61041006', '61202000', '61386002', '6147005', '61474001', '6163002', '61642003',
        '61653009', '61823004', '62106007', '62125005', '62297002', '62356006', '62564004',
        '63023005', '63141004', '63323000', '6342009', '63456003', '63540005', '63669006',
        '63819001', '63903007', '63948006', '63975004', '63978002', '64042000', '64169002',
        '64213003', '64290004', '64306000', '64323009', '64337000', '64413001', '64438006',
        '64455005', '64469005', '64515006', '64569008', '64617008', '64638002', '64665009',
        '64684007', '64710004', '64789007', '64834002', '649002', '64902007', '65071008',
        '65189006', '65324009', '65354004', '65491009', '65535000', '65595002', '65648007',
        '65752003', '65759007', '65775005', '658009', '65966004', '65978000', '66020004',
        '66023002', '66112004', '66158003', '66246007', '6628008', '66308002', '66393002',
        '66483005', '66517001', '6666006', '66665007', '66691008', '66926007', '66973001',
        '66976009', '6698000', '67016008', '67130000', '67378005', '67394003', '67422008',
        '67447005', '67730008', '67861006', '68076002', '68152007', '68360003', '6836001',
        '68650003', '68734002', '68819003', '68854005', '69029002', '69166006', '69178005',
        '69301007', '69425000', '69427008', '69458009', '6954003', '69593000', '69820004',
        '69830008', '69866009', '69875006', '6990005', '69913007', '69916004', '69976008',
        '70092007', '70204006', '70307002', '70381003', '70437005', '70686002', '71039006',
        '71074007', '71139009', '71220005', '71266000', '71456006', '71555008', '71620000',
        '71642004', '71790003', '72117009', '72224003', '72332008', '72346008', '72435006',
        '72466000', '72497001', '72513001', '72739001', '72758005', '72797002', '72933006',
        '73015009', '73143002', '73244003', '73308006', '73316002', '73387003', '7341005',
        '73413009', '73439007', '7346000', '73477001', '73825003', '74177004', '74297002',
        '74324004', '74355005', '74360009', '74395007', '74465000', '74472004', '75137002',
        '7523003', '75308009', '75507000', '7551007', '75580000', '75591007', '75824002',
        '7585008', '75857000', '76103002', '76174009', '76179004', '76374000', '76382000',
        '76418009', '76435008', '76542006', '76597001', '76675006', '7669008', '76730004',
        '76865005', '7687006', '76877000', '76890007', '76911006', '76974008', '7711006',
        '77165001', '77295000', '77493009', '77498000', '77505009', '77546004', '77551005',
        '77572008', '77598002', '77768006', '77803008', '77890001', '77940004', '78011002',
        '78028004', '78085003', '78157002', '78171005', '7819003', '78211006', '78292000',
        '78396000', '78477003', '78490005', '78516000', '78523004', '78525006', '78687007',
        '78757009', '78849002', '78879009', '78914008', '78968003', '78980006', '79125007',
        '7913001', '79220008', '79228001', '79484004', '79546008', '79626009', '79763005',
        '79858001', '79978005', '80090009', '80192004', '80350001', '80411001', '80597004',
        '80692000', '80756009', '80767005', '80980003', '81193001', '81268009', '8135006',
        '81412002', '81425005', '81442004', '81501004', '81520002', '81576005', '81629009',
        '81639003', '81642009', '81715004', '81813004', '8183009', '81966000', '82065001',
        '82271004', '82344002', '82419009', '82601009', '82637004', '82640004', '8281003',
        '8303001', '83209008', '83276000', '8328009', '83385002', '83401009', '83635002',
        '83716008', '83969004', '83991006', '84030002', '84111004', '84170006', '84320000',
        '84338002', '8459005', '84595002', '84621006', '84803006', '84900008', '84920009',
        '85262003', '85314006', '85341001', '85453003', '85646001', '85870004', '85922006',
        '86006001', '86010003', '86125000', '86144007', '86175003', '86182004', '86357008',
        '86449009', '86488006', '86559007', '86704005', '86731008', '86844009', '86899000',
        '87020000', '87040007', '8704005', '87173003', '87225004', '87253004', '87376003',
        '8758001', '87592007', '87804006', '87888006', '87894003', '87900003', '87905008',
        '88008005', '88116004', '88196000', '8840000', '88405003', '88533001', '88651008',
        '88743001', '88747000', '88835002', '89130002', '89161006', '89294002', '8939001',
        '89581003', '89636007', '89760000', '89801006', '89820008', '89825003', '90070003',
        '90114000', '9015001', '90165008', '90235006', '90289008', '90338005', '90429009',
        '90460009', '9048001', '90584004', '90768003', '90799002', '90863004', '90898001',
        '91012008', '91037003', '91168001', '91216000', '91296001', '91419009', '91589002',
        '91631003', '91641000', '9264002', '9275003', '9327005', '9341001', '9344009', '9468002',
        '9501009', '95306003', '95671001', '95817008', '95847005', '95850008', '95851007',
        '95852000', '95853005', '95854004', '9682006', '9787009', '9808005', '9966008', '9978007'
    }


class FractureLowerBody(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1037'
    VALUE_SET_NAME = 'Fracture - Lower Body'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'S12000A', 'S12000B', 'S12001A', 'S12001B', 'S12030A', 'S12030B', 'S12031A', 'S12031B',
        'S12040A', 'S12040B', 'S12041A', 'S12041B', 'S12090A', 'S12090B', 'S12091A', 'S12091B',
        'S12100A', 'S12100B', 'S12101A', 'S12101B', 'S12110A', 'S12110B', 'S12111A', 'S12111B',
        'S12112A', 'S12112B', 'S12120A', 'S12120B', 'S12121A', 'S12121B', 'S12130A', 'S12130B',
        'S12131A', 'S12131B', 'S1214XA', 'S1214XB', 'S12150A', 'S12150B', 'S12151A', 'S12151B',
        'S12190A', 'S12190B', 'S12191A', 'S12191B', 'S12200A', 'S12200B', 'S12201A', 'S12201B',
        'S12230A', 'S12230B', 'S12231A', 'S12231B', 'S1224XA', 'S1224XB', 'S12250A', 'S12250B',
        'S12251A', 'S12251B', 'S12290A', 'S12290B', 'S12291A', 'S12291B', 'S12300A', 'S12300B',
        'S12301A', 'S12301B', 'S12330A', 'S12330B', 'S12331A', 'S12331B', 'S1234XA', 'S1234XB',
        'S12350A', 'S12350B', 'S12351A', 'S12351B', 'S12390A', 'S12390B', 'S12391A', 'S12391B',
        'S12400A', 'S12400B', 'S12401A', 'S12401B', 'S12430A', 'S12430B', 'S12431A', 'S12431B',
        'S1244XA', 'S1244XB', 'S12450A', 'S12450B', 'S12451A', 'S12451B', 'S12490A', 'S12490B',
        'S12491A', 'S12491B', 'S12500A', 'S12500B', 'S12501A', 'S12501B', 'S12530A', 'S12530B',
        'S12531A', 'S12531B', 'S1254XA', 'S1254XB', 'S12550A', 'S12550B', 'S12551A', 'S12551B',
        'S12590A', 'S12590B', 'S12591A', 'S12591B', 'S12600A', 'S12600B', 'S12601A', 'S12601B',
        'S12630A', 'S12630B', 'S12631A', 'S12631B', 'S1264XA', 'S1264XB', 'S12650A', 'S12650B',
        'S12651A', 'S12651B', 'S12690A', 'S12690B', 'S12691A', 'S12691B', 'S128XXA', 'S129XXA',
        'S2220XA', 'S2220XB', 'S2221XA', 'S2221XB', 'S2222XA', 'S2222XB', 'S2223XA', 'S2223XB',
        'S2224XA', 'S2224XB', 'S2231XA', 'S2231XB', 'S2232XA', 'S2232XB', 'S2239XA', 'S2239XB',
        'S2241XA', 'S2241XB', 'S2242XA', 'S2242XB', 'S2243XA', 'S2243XB', 'S2249XA', 'S2249XB',
        'S225XXA', 'S225XXB', 'S229XXA', 'S229XXB', 'S3210XA', 'S3210XB', 'S32110A', 'S32110B',
        'S32111A', 'S32111B', 'S32112A', 'S32112B', 'S32119A', 'S32119B', 'S32120A', 'S32120B',
        'S32121A', 'S32121B', 'S32122A', 'S32122B', 'S32129A', 'S32129B', 'S32130A', 'S32130B',
        'S32131A', 'S32131B', 'S32132A', 'S32132B', 'S32139A', 'S32139B', 'S3214XA', 'S3214XB',
        'S3215XA', 'S3215XB', 'S3216XA', 'S3216XB', 'S3217XA', 'S3217XB', 'S3219XA', 'S3219XB',
        'S322XXA', 'S322XXB', 'S32301A', 'S32301B', 'S32301D', 'S32301G', 'S32301K', 'S32301S',
        'S32302A', 'S32302B', 'S32302D', 'S32302G', 'S32302K', 'S32302S', 'S32309A', 'S32309B',
        'S32309D', 'S32309G', 'S32309K', 'S32309S', 'S32311A', 'S32311B', 'S32311D', 'S32311G',
        'S32311K', 'S32311S', 'S32312A', 'S32312B', 'S32312D', 'S32312G', 'S32312K', 'S32312S',
        'S32313A', 'S32313B', 'S32313D', 'S32313G', 'S32313K', 'S32313S', 'S32314A', 'S32314B',
        'S32314D', 'S32314G', 'S32314K', 'S32314S', 'S32315A', 'S32315B', 'S32315D', 'S32315G',
        'S32315K', 'S32315S', 'S32316A', 'S32316B', 'S32316D', 'S32316G', 'S32316K', 'S32316S',
        'S32391A', 'S32391B', 'S32391D', 'S32391G', 'S32391K', 'S32391S', 'S32392A', 'S32392B',
        'S32392D', 'S32392G', 'S32392K', 'S32392S', 'S32399A', 'S32399B', 'S32399D', 'S32399G',
        'S32399K', 'S32399S', 'S32401A', 'S32401B', 'S32401D', 'S32401G', 'S32401K', 'S32401S',
        'S32402A', 'S32402B', 'S32402D', 'S32402G', 'S32402K', 'S32402S', 'S32409A', 'S32409B',
        'S32409D', 'S32409G', 'S32409K', 'S32409S', 'S32411A', 'S32411B', 'S32411D', 'S32411G',
        'S32411K', 'S32411S', 'S32412A', 'S32412B', 'S32412D', 'S32412G', 'S32412K', 'S32412S',
        'S32413A', 'S32413B', 'S32413D', 'S32413G', 'S32413K', 'S32413S', 'S32414A', 'S32414B',
        'S32414D', 'S32414G', 'S32414K', 'S32414S', 'S32415A', 'S32415B', 'S32415D', 'S32415G',
        'S32415K', 'S32415S', 'S32416A', 'S32416B', 'S32416D', 'S32416G', 'S32416K', 'S32416S',
        'S32421A', 'S32421B', 'S32421D', 'S32421G', 'S32421K', 'S32421S', 'S32422A', 'S32422B',
        'S32422D', 'S32422G', 'S32422K', 'S32422S', 'S32423A', 'S32423B', 'S32423D', 'S32423G',
        'S32423K', 'S32423S', 'S32424A', 'S32424B', 'S32424D', 'S32424G', 'S32424K', 'S32424S',
        'S32425A', 'S32425B', 'S32425D', 'S32425G', 'S32425K', 'S32425S', 'S32426A', 'S32426B',
        'S32426D', 'S32426G', 'S32426K', 'S32426S', 'S32431A', 'S32431B', 'S32431D', 'S32431G',
        'S32431K', 'S32431S', 'S32432A', 'S32432B', 'S32432D', 'S32432G', 'S32432K', 'S32432S',
        'S32433A', 'S32433B', 'S32433D', 'S32433G', 'S32433K', 'S32433S', 'S32434A', 'S32434B',
        'S32434D', 'S32434G', 'S32434K', 'S32434S', 'S32435A', 'S32435B', 'S32435D', 'S32435G',
        'S32435K', 'S32435S', 'S32436A', 'S32436B', 'S32436D', 'S32436G', 'S32436K', 'S32436S',
        'S32441A', 'S32441B', 'S32441D', 'S32441G', 'S32441K', 'S32441S', 'S32442A', 'S32442B',
        'S32442D', 'S32442G', 'S32442K', 'S32442S', 'S32443A', 'S32443B', 'S32443D', 'S32443G',
        'S32443K', 'S32443S', 'S32444A', 'S32444B', 'S32444D', 'S32444G', 'S32444K', 'S32444S',
        'S32445A', 'S32445B', 'S32445D', 'S32445G', 'S32445K', 'S32445S', 'S32446A', 'S32446B',
        'S32446D', 'S32446G', 'S32446K', 'S32446S', 'S32451A', 'S32451B', 'S32451D', 'S32451G',
        'S32451K', 'S32451S', 'S32452A', 'S32452B', 'S32452D', 'S32452G', 'S32452K', 'S32452S',
        'S32453A', 'S32453B', 'S32453D', 'S32453G', 'S32453K', 'S32453S', 'S32454A', 'S32454B',
        'S32454D', 'S32454G', 'S32454K', 'S32454S', 'S32455A', 'S32455B', 'S32455D', 'S32455G',
        'S32455K', 'S32455S', 'S32456A', 'S32456B', 'S32456D', 'S32456G', 'S32456K', 'S32456S',
        'S32461A', 'S32461B', 'S32461D', 'S32461G', 'S32461K', 'S32461S', 'S32462A', 'S32462B',
        'S32462D', 'S32462G', 'S32462K', 'S32462S', 'S32463A', 'S32463B', 'S32463D', 'S32463G',
        'S32463K', 'S32463S', 'S32464A', 'S32464B', 'S32464D', 'S32464G', 'S32464K', 'S32464S',
        'S32465A', 'S32465B', 'S32465D', 'S32465G', 'S32465K', 'S32465S', 'S32466A', 'S32466B',
        'S32466D', 'S32466G', 'S32466K', 'S32466S', 'S32471A', 'S32471B', 'S32471D', 'S32471G',
        'S32471K', 'S32471S', 'S32472A', 'S32472B', 'S32472D', 'S32472G', 'S32472K', 'S32472S',
        'S32473A', 'S32473B', 'S32473D', 'S32473G', 'S32473K', 'S32473S', 'S32474A', 'S32474B',
        'S32474D', 'S32474G', 'S32474K', 'S32474S', 'S32475A', 'S32475B', 'S32475D', 'S32475G',
        'S32475K', 'S32475S', 'S32476A', 'S32476B', 'S32476D', 'S32476G', 'S32476K', 'S32476S',
        'S32481A', 'S32481B', 'S32481D', 'S32481G', 'S32481K', 'S32481S', 'S32482A', 'S32482B',
        'S32482D', 'S32482G', 'S32482K', 'S32482S', 'S32483A', 'S32483B', 'S32483D', 'S32483G',
        'S32483K', 'S32483S', 'S32484A', 'S32484B', 'S32484D', 'S32484G', 'S32484K', 'S32484S',
        'S32485A', 'S32485B', 'S32485D', 'S32485G', 'S32485K', 'S32485S', 'S32486A', 'S32486B',
        'S32486D', 'S32486G', 'S32486K', 'S32486S', 'S32491A', 'S32491B', 'S32491D', 'S32491G',
        'S32491K', 'S32491S', 'S32492A', 'S32492B', 'S32492D', 'S32492G', 'S32492K', 'S32492S',
        'S32499A', 'S32499B', 'S32499D', 'S32499G', 'S32499K', 'S32499S', 'S32501A', 'S32501B',
        'S32501D', 'S32501G', 'S32501K', 'S32501S', 'S32502A', 'S32502B', 'S32502D', 'S32502G',
        'S32502K', 'S32502S', 'S32509A', 'S32509B', 'S32509D', 'S32509G', 'S32509K', 'S32509S',
        'S32511A', 'S32511B', 'S32511D', 'S32511G', 'S32511K', 'S32511S', 'S32512A', 'S32512B',
        'S32512D', 'S32512G', 'S32512K', 'S32512S', 'S32519A', 'S32519B', 'S32519D', 'S32519G',
        'S32519K', 'S32519S', 'S32591A', 'S32591B', 'S32591D', 'S32591G', 'S32591K', 'S32591S',
        'S32592A', 'S32592B', 'S32592D', 'S32592G', 'S32592K', 'S32592S', 'S32599A', 'S32599B',
        'S32599D', 'S32599G', 'S32599K', 'S32599S', 'S32601A', 'S32601B', 'S32601D', 'S32601G',
        'S32601K', 'S32601S', 'S32602A', 'S32602B', 'S32602D', 'S32602G', 'S32602K', 'S32602S',
        'S32609A', 'S32609B', 'S32609D', 'S32609G', 'S32609K', 'S32609S', 'S32611A', 'S32611B',
        'S32611D', 'S32611G', 'S32611K', 'S32611S', 'S32612A', 'S32612B', 'S32612D', 'S32612G',
        'S32612K', 'S32612S', 'S32613A', 'S32613B', 'S32613D', 'S32613G', 'S32613K', 'S32613S',
        'S32614A', 'S32614B', 'S32614D', 'S32614G', 'S32614K', 'S32614S', 'S32615A', 'S32615B',
        'S32615D', 'S32615G', 'S32615K', 'S32615S', 'S32616A', 'S32616B', 'S32616D', 'S32616G',
        'S32616K', 'S32616S', 'S32691A', 'S32691B', 'S32691D', 'S32691G', 'S32691K', 'S32691S',
        'S32692A', 'S32692B', 'S32692D', 'S32692G', 'S32692K', 'S32692S', 'S32699A', 'S32699B',
        'S32699D', 'S32699G', 'S32699K', 'S32699S', 'S32810A', 'S32810B', 'S32811A', 'S32811B',
        'S3282XA', 'S3282XB', 'S3289XA', 'S3289XB', 'S3289XD', 'S3289XG', 'S3289XK', 'S3289XS',
        'S329XXA', 'S329XXB', 'S329XXD', 'S329XXG', 'S329XXK', 'S329XXS', 'S42001A', 'S42001B',
        'S42002A', 'S42002B', 'S42009A', 'S42009B', 'S42011A', 'S42011B', 'S42012A', 'S42012B',
        'S42013A', 'S42013B', 'S42014A', 'S42014B', 'S42015A', 'S42015B', 'S42016A', 'S42016B',
        'S42017A', 'S42017B', 'S42018A', 'S42018B', 'S42019A', 'S42019B', 'S42021A', 'S42021B',
        'S42022A', 'S42022B', 'S42023A', 'S42023B', 'S42024A', 'S42024B', 'S42025A', 'S42025B',
        'S42026A', 'S42026B', 'S42031A', 'S42031B', 'S42032A', 'S42032B', 'S42033A', 'S42033B',
        'S42034A', 'S42034B', 'S42035A', 'S42035B', 'S42036A', 'S42036B', 'S42101A', 'S42101B',
        'S42102A', 'S42102B', 'S42109A', 'S42109B', 'S42111A', 'S42111B', 'S42112A', 'S42112B',
        'S42113A', 'S42113B', 'S42114A', 'S42114B', 'S42115A', 'S42115B', 'S42116A', 'S42116B',
        'S42121A', 'S42121B', 'S42122A', 'S42122B', 'S42123A', 'S42123B', 'S42124A', 'S42124B',
        'S42125A', 'S42125B', 'S42126A', 'S42126B', 'S42131A', 'S42131B', 'S42132A', 'S42132B',
        'S42133A', 'S42133B', 'S42134A', 'S42134B', 'S42135A', 'S42135B', 'S42136A', 'S42136B',
        'S42141A', 'S42141B', 'S42142A', 'S42142B', 'S42143A', 'S42143B', 'S42144A', 'S42144B',
        'S42145A', 'S42145B', 'S42146A', 'S42146B', 'S42151A', 'S42151B', 'S42152A', 'S42152B',
        'S42153A', 'S42153B', 'S42154A', 'S42154B', 'S42155A', 'S42155B', 'S42156A', 'S42156B',
        'S42191A', 'S42191B', 'S42192A', 'S42192B', 'S42199A', 'S42199B', 'S42201A', 'S42201B',
        'S42202A', 'S42202B', 'S42209A', 'S42209B', 'S42211A', 'S42211B', 'S42212A', 'S42212B',
        'S42213A', 'S42213B', 'S42214A', 'S42214B', 'S42215A', 'S42215B', 'S42216A', 'S42216B',
        'S42221A', 'S42221B', 'S42222A', 'S42222B', 'S42223A', 'S42223B', 'S42224A', 'S42224B',
        'S42225A', 'S42225B', 'S42226A', 'S42226B', 'S42231A', 'S42231B', 'S42232A', 'S42232B',
        'S42239A', 'S42239B', 'S42241A', 'S42241B', 'S42242A', 'S42242B', 'S42249A', 'S42249B',
        'S42251A', 'S42251B', 'S42252A', 'S42252B', 'S42253A', 'S42253B', 'S42254A', 'S42254B',
        'S42255A', 'S42255B', 'S42256A', 'S42256B', 'S42261A', 'S42261B', 'S42262A', 'S42262B',
        'S42263A', 'S42263B', 'S42264A', 'S42264B', 'S42265A', 'S42265B', 'S42266A', 'S42266B',
        'S42271A', 'S42272A', 'S42279A', 'S42291A', 'S42291B', 'S42292A', 'S42292B', 'S42293A',
        'S42293B', 'S42294A', 'S42294B', 'S42295A', 'S42295B', 'S42296A', 'S42296B', 'S42301A',
        'S42301B', 'S42302A', 'S42302B', 'S42309A', 'S42309B', 'S42311A', 'S42312A', 'S42319A',
        'S42321A', 'S42321B', 'S42322A', 'S42322B', 'S42323A', 'S42323B', 'S42324A', 'S42324B',
        'S42325A', 'S42325B', 'S42326A', 'S42326B', 'S42331A', 'S42331B', 'S42332A', 'S42332B',
        'S42333A', 'S42333B', 'S42334A', 'S42334B', 'S42335A', 'S42335B', 'S42336A', 'S42336B',
        'S42341A', 'S42341B', 'S42342A', 'S42342B', 'S42343A', 'S42343B', 'S42344A', 'S42344B',
        'S42345A', 'S42345B', 'S42346A', 'S42346B', 'S42351A', 'S42351B', 'S42352A', 'S42352B',
        'S42353A', 'S42353B', 'S42354A', 'S42354B', 'S42355A', 'S42355B', 'S42356A', 'S42356B',
        'S42361A', 'S42361B', 'S42362A', 'S42362B', 'S42363A', 'S42363B', 'S42364A', 'S42364B',
        'S42365A', 'S42365B', 'S42366A', 'S42366B', 'S42391A', 'S42391B', 'S42392A', 'S42392B',
        'S42399A', 'S42399B', 'S42401A', 'S42401B', 'S42402A', 'S42402B', 'S42409A', 'S42409B',
        'S42411A', 'S42411B', 'S42412A', 'S42412B', 'S42413A', 'S42413B', 'S42414A', 'S42414B',
        'S42415A', 'S42415B', 'S42416A', 'S42416B', 'S42421A', 'S42421B', 'S42422A', 'S42422B',
        'S42423A', 'S42423B', 'S42424A', 'S42424B', 'S42425A', 'S42425B', 'S42426A', 'S42426B',
        'S42431A', 'S42431B', 'S42432A', 'S42432B', 'S42433A', 'S42433B', 'S42434A', 'S42434B',
        'S42435A', 'S42435B', 'S42436A', 'S42436B', 'S42441A', 'S42441B', 'S42442A', 'S42442B',
        'S42443A', 'S42443B', 'S42444A', 'S42444B', 'S42445A', 'S42445B', 'S42446A', 'S42446B',
        'S42447A', 'S42447B', 'S42448A', 'S42448B', 'S42449A', 'S42449B', 'S42451A', 'S42451B',
        'S42452A', 'S42452B', 'S42453A', 'S42453B', 'S42454A', 'S42454B', 'S42455A', 'S42455B',
        'S42456A', 'S42456B', 'S42461A', 'S42461B', 'S42462A', 'S42462B', 'S42463A', 'S42463B',
        'S42464A', 'S42464B', 'S42465A', 'S42465B', 'S42466A', 'S42466B', 'S42471A', 'S42471B',
        'S42472A', 'S42472B', 'S42473A', 'S42473B', 'S42474A', 'S42474B', 'S42475A', 'S42475B',
        'S42476A', 'S42476B', 'S42481A', 'S42482A', 'S42489A', 'S42491A', 'S42491B', 'S42492A',
        'S42492B', 'S42493A', 'S42493B', 'S42494A', 'S42494B', 'S42495A', 'S42495B', 'S42496A',
        'S42496B', 'S4290XA', 'S4290XB', 'S4291XA', 'S4291XB', 'S4292XA', 'S4292XB', 'S49001A',
        'S49002A', 'S49009A', 'S49011A', 'S49012A', 'S49019A', 'S49021A', 'S49022A', 'S49029A',
        'S49031A', 'S49032A', 'S49039A', 'S49041A', 'S49042A', 'S49049A', 'S49091A', 'S49092A',
        'S49099A', 'S49101A', 'S49102A', 'S49109A', 'S49111A', 'S49112A', 'S49119A', 'S49121A',
        'S49122A', 'S49129A', 'S49131A', 'S49132A', 'S49139A', 'S49141A', 'S49142A', 'S49149A',
        'S49191A', 'S49192A', 'S49199A', 'S52001A', 'S52001B', 'S52001C', 'S52002A', 'S52002B',
        'S52002C', 'S52009A', 'S52009B', 'S52009C', 'S52011A', 'S52012A', 'S52019A', 'S52021A',
        'S52021B', 'S52021C', 'S52022A', 'S52022B', 'S52022C', 'S52023A', 'S52023B', 'S52023C',
        'S52024A', 'S52024B', 'S52024C', 'S52025A', 'S52025B', 'S52025C', 'S52026A', 'S52026B',
        'S52026C', 'S52031A', 'S52031B', 'S52031C', 'S52032A', 'S52032B', 'S52032C', 'S52033A',
        'S52033B', 'S52033C', 'S52034A', 'S52034B', 'S52034C', 'S52035A', 'S52035B', 'S52035C',
        'S52036A', 'S52036B', 'S52036C', 'S52041A', 'S52041B', 'S52041C', 'S52042A', 'S52042B',
        'S52042C', 'S52043A', 'S52043B', 'S52043C', 'S52044A', 'S52044B', 'S52044C', 'S52045A',
        'S52045B', 'S52045C', 'S52046A', 'S52046B', 'S52046C', 'S52091A', 'S52091B', 'S52091C',
        'S52092A', 'S52092B', 'S52092C', 'S52099A', 'S52099B', 'S52099C', 'S52101A', 'S52101B',
        'S52101C', 'S52102A', 'S52102B', 'S52102C', 'S52109A', 'S52109B', 'S52109C', 'S52111A',
        'S52112A', 'S52119A', 'S52121A', 'S52121B', 'S52121C', 'S52122A', 'S52122B', 'S52122C',
        'S52123A', 'S52123B', 'S52123C', 'S52124A', 'S52124B', 'S52124C', 'S52125A', 'S52125B',
        'S52125C', 'S52126A', 'S52126B', 'S52126C', 'S52131A', 'S52131B', 'S52131C', 'S52132A',
        'S52132B', 'S52132C', 'S52133A', 'S52133B', 'S52133C', 'S52134A', 'S52134B', 'S52134C',
        'S52135A', 'S52135B', 'S52135C', 'S52136A', 'S52136B', 'S52136C', 'S52181A', 'S52181B',
        'S52181C', 'S52182A', 'S52182B', 'S52182C', 'S52189A', 'S52189B', 'S52189C', 'S52201A',
        'S52201B', 'S52201C', 'S52202A', 'S52202B', 'S52202C', 'S52209A', 'S52209B', 'S52209C',
        'S52211A', 'S52212A', 'S52219A', 'S52221A', 'S52221B', 'S52221C', 'S52222A', 'S52222B',
        'S52222C', 'S52223A', 'S52223B', 'S52223C', 'S52224A', 'S52224B', 'S52224C', 'S52225A',
        'S52225B', 'S52225C', 'S52226A', 'S52226B', 'S52226C', 'S52231A', 'S52231B', 'S52231C',
        'S52232A', 'S52232B', 'S52232C', 'S52233A', 'S52233B', 'S52233C', 'S52234A', 'S52234B',
        'S52234C', 'S52235A', 'S52235B', 'S52235C', 'S52236A', 'S52236B', 'S52236C', 'S52241A',
        'S52241B', 'S52241C', 'S52242A', 'S52242B', 'S52242C', 'S52243A', 'S52243B', 'S52243C',
        'S52244A', 'S52244B', 'S52244C', 'S52245A', 'S52245B', 'S52245C', 'S52246A', 'S52246B',
        'S52246C', 'S52251A', 'S52251B', 'S52251C', 'S52252A', 'S52252B', 'S52252C', 'S52253A',
        'S52253B', 'S52253C', 'S52254A', 'S52254B', 'S52254C', 'S52255A', 'S52255B', 'S52255C',
        'S52256A', 'S52256B', 'S52256C', 'S52261A', 'S52261B', 'S52261C', 'S52262A', 'S52262B',
        'S52262C', 'S52263A', 'S52263B', 'S52263C', 'S52264A', 'S52264B', 'S52264C', 'S52265A',
        'S52265B', 'S52265C', 'S52266A', 'S52266B', 'S52266C', 'S52271A', 'S52271B', 'S52271C',
        'S52272A', 'S52272B', 'S52272C', 'S52279A', 'S52279B', 'S52279C', 'S52281A', 'S52281B',
        'S52281C', 'S52282A', 'S52282B', 'S52282C', 'S52283A', 'S52283B', 'S52283C', 'S52291A',
        'S52291B', 'S52291C', 'S52292A', 'S52292B', 'S52292C', 'S52299A', 'S52299B', 'S52299C',
        'S52301A', 'S52301B', 'S52301C', 'S52302A', 'S52302B', 'S52302C', 'S52309A', 'S52309B',
        'S52309C', 'S52311A', 'S52312A', 'S52319A', 'S52321A', 'S52321B', 'S52321C', 'S52322A',
        'S52322B', 'S52322C', 'S52323A', 'S52323B', 'S52323C', 'S52324A', 'S52324B', 'S52324C',
        'S52325A', 'S52325B', 'S52325C', 'S52326A', 'S52326B', 'S52326C', 'S52331A', 'S52331B',
        'S52331C', 'S52332A', 'S52332B', 'S52332C', 'S52333A', 'S52333B', 'S52333C', 'S52334A',
        'S52334B', 'S52334C', 'S52335A', 'S52335B', 'S52335C', 'S52336A', 'S52336B', 'S52336C',
        'S52341A', 'S52341B', 'S52341C', 'S52342A', 'S52342B', 'S52342C', 'S52343A', 'S52343B',
        'S52343C', 'S52344A', 'S52344B', 'S52344C', 'S52345A', 'S52345B', 'S52345C', 'S52346A',
        'S52346B', 'S52346C', 'S52351A', 'S52351B', 'S52351C', 'S52352A', 'S52352B', 'S52352C',
        'S52353A', 'S52353B', 'S52353C', 'S52354A', 'S52354B', 'S52354C', 'S52355A', 'S52355B',
        'S52355C', 'S52356A', 'S52356B', 'S52356C', 'S52361A', 'S52361B', 'S52361C', 'S52362A',
        'S52362B', 'S52362C', 'S52363A', 'S52363B', 'S52363C', 'S52364A', 'S52364B', 'S52364C',
        'S52365A', 'S52365B', 'S52365C', 'S52366A', 'S52366B', 'S52366C', 'S52371A', 'S52371B',
        'S52371C', 'S52372A', 'S52372B', 'S52372C', 'S52379A', 'S52379B', 'S52379C', 'S52381A',
        'S52381B', 'S52381C', 'S52382A', 'S52382B', 'S52382C', 'S52389A', 'S52389B', 'S52389C',
        'S52391A', 'S52391B', 'S52391C', 'S52392A', 'S52392B', 'S52392C', 'S52399A', 'S52399B',
        'S52399C', 'S52501A', 'S52501B', 'S52501C', 'S52502A', 'S52502B', 'S52502C', 'S52509A',
        'S52509B', 'S52509C', 'S52511A', 'S52511B', 'S52511C', 'S52512A', 'S52512B', 'S52512C',
        'S52513A', 'S52513B', 'S52513C', 'S52514A', 'S52514B', 'S52514C', 'S52515A', 'S52515B',
        'S52515C', 'S52516A', 'S52516B', 'S52516C', 'S52521A', 'S52522A', 'S52529A', 'S52531A',
        'S52531B', 'S52531C', 'S52532A', 'S52532B', 'S52532C', 'S52539A', 'S52539B', 'S52539C',
        'S52541A', 'S52541B', 'S52541C', 'S52542A', 'S52542B', 'S52542C', 'S52549A', 'S52549B',
        'S52549C', 'S52551A', 'S52551B', 'S52551C', 'S52552A', 'S52552B', 'S52552C', 'S52559A',
        'S52559B', 'S52559C', 'S52561A', 'S52561B', 'S52561C', 'S52562A', 'S52562B', 'S52562C',
        'S52569A', 'S52569B', 'S52569C', 'S52571A', 'S52571B', 'S52571C', 'S52572A', 'S52572B',
        'S52572C', 'S52579A', 'S52579B', 'S52579C', 'S52591A', 'S52591B', 'S52591C', 'S52592A',
        'S52592B', 'S52592C', 'S52599A', 'S52599B', 'S52599C', 'S52601A', 'S52601B', 'S52601C',
        'S52602A', 'S52602B', 'S52602C', 'S52609A', 'S52609B', 'S52609C', 'S52611A', 'S52611B',
        'S52611C', 'S52612A', 'S52612B', 'S52612C', 'S52613A', 'S52613B', 'S52613C', 'S52614A',
        'S52614B', 'S52614C', 'S52615A', 'S52615B', 'S52615C', 'S52616A', 'S52616B', 'S52616C',
        'S52621A', 'S52622A', 'S52629A', 'S52691A', 'S52691B', 'S52691C', 'S52692A', 'S52692B',
        'S52692C', 'S52699A', 'S52699B', 'S52699C', 'S5290XA', 'S5290XB', 'S5290XC', 'S5291XA',
        'S5291XB', 'S5291XC', 'S5292XA', 'S5292XB', 'S5292XC', 'S59001A', 'S59002A', 'S59009A',
        'S59011A', 'S59012A', 'S59019A', 'S59021A', 'S59022A', 'S59029A', 'S59031A', 'S59032A',
        'S59039A', 'S59041A', 'S59042A', 'S59049A', 'S59091A', 'S59092A', 'S59099A', 'S59101A',
        'S59102A', 'S59109A', 'S59111A', 'S59112A', 'S59119A', 'S59121A', 'S59122A', 'S59129A',
        'S59131A', 'S59132A', 'S59139A', 'S59141A', 'S59142A', 'S59149A', 'S59191A', 'S59192A',
        'S59199A', 'S59201A', 'S59202A', 'S59209A', 'S59211A', 'S59212A', 'S59219A', 'S59221A',
        'S59222A', 'S59229A', 'S59231A', 'S59232A', 'S59239A', 'S59241A', 'S59242A', 'S59249A',
        'S59291A', 'S59292A', 'S59299A', 'S62001A', 'S62001B', 'S62002A', 'S62002B', 'S62009A',
        'S62009B', 'S62011A', 'S62011B', 'S62012A', 'S62012B', 'S62013A', 'S62013B', 'S62014A',
        'S62014B', 'S62015A', 'S62015B', 'S62016A', 'S62016B', 'S62021A', 'S62021B', 'S62022A',
        'S62022B', 'S62023A', 'S62023B', 'S62024A', 'S62024B', 'S62025A', 'S62025B', 'S62026A',
        'S62026B', 'S62031A', 'S62031B', 'S62032A', 'S62032B', 'S62033A', 'S62033B', 'S62034A',
        'S62034B', 'S62035A', 'S62035B', 'S62036A', 'S62036B', 'S62101A', 'S62101B', 'S62102A',
        'S62102B', 'S62109A', 'S62109B', 'S62111A', 'S62111B', 'S62112A', 'S62112B', 'S62113A',
        'S62113B', 'S62114A', 'S62114B', 'S62115A', 'S62115B', 'S62116A', 'S62116B', 'S62121A',
        'S62121B', 'S62122A', 'S62122B', 'S62123A', 'S62123B', 'S62124A', 'S62124B', 'S62125A',
        'S62125B', 'S62126A', 'S62126B', 'S62131A', 'S62131B', 'S62132A', 'S62132B', 'S62133A',
        'S62133B', 'S62134A', 'S62134B', 'S62135A', 'S62135B', 'S62136A', 'S62136B', 'S62141A',
        'S62141B', 'S62142A', 'S62142B', 'S62143A', 'S62143B', 'S62144A', 'S62144B', 'S62145A',
        'S62145B', 'S62146A', 'S62146B', 'S62151A', 'S62151B', 'S62152A', 'S62152B', 'S62153A',
        'S62153B', 'S62154A', 'S62154B', 'S62155A', 'S62155B', 'S62156A', 'S62156B', 'S62161A',
        'S62161B', 'S62162A', 'S62162B', 'S62163A', 'S62163B', 'S62164A', 'S62164B', 'S62165A',
        'S62165B', 'S62166A', 'S62166B', 'S62171A', 'S62171B', 'S62172A', 'S62172B', 'S62173A',
        'S62173B', 'S62174A', 'S62174B', 'S62175A', 'S62175B', 'S62176A', 'S62176B', 'S62181A',
        'S62181B', 'S62182A', 'S62182B', 'S62183A', 'S62183B', 'S62184A', 'S62184B', 'S62185A',
        'S62185B', 'S62186A', 'S62186B', 'S62201A', 'S62201B', 'S62202A', 'S62202B', 'S62209A',
        'S62209B', 'S62211A', 'S62211B', 'S62212A', 'S62212B', 'S62213A', 'S62213B', 'S62221A',
        'S62221B', 'S62222A', 'S62222B', 'S62223A', 'S62223B', 'S62224A', 'S62224B', 'S62225A',
        'S62225B', 'S62226A', 'S62226B', 'S62231A', 'S62231B', 'S62232A', 'S62232B', 'S62233A',
        'S62233B', 'S62234A', 'S62234B', 'S62235A', 'S62235B', 'S62236A', 'S62236B', 'S62241A',
        'S62241B', 'S62242A', 'S62242B', 'S62243A', 'S62243B', 'S62244A', 'S62244B', 'S62245A',
        'S62245B', 'S62246A', 'S62246B', 'S62251A', 'S62251B', 'S62252A', 'S62252B', 'S62253A',
        'S62253B', 'S62254A', 'S62254B', 'S62255A', 'S62255B', 'S62256A', 'S62256B', 'S62291A',
        'S62291B', 'S62292A', 'S62292B', 'S62299A', 'S62299B', 'S62300A', 'S62300B', 'S62301A',
        'S62301B', 'S62302A', 'S62302B', 'S62303A', 'S62303B', 'S62304A', 'S62304B', 'S62305A',
        'S62305B', 'S62306A', 'S62306B', 'S62307A', 'S62307B', 'S62308A', 'S62308B', 'S62309A',
        'S62309B', 'S62310A', 'S62310B', 'S62311A', 'S62311B', 'S62312A', 'S62312B', 'S62313A',
        'S62313B', 'S62314A', 'S62314B', 'S62315A', 'S62315B', 'S62316A', 'S62316B', 'S62317A',
        'S62317B', 'S62318A', 'S62318B', 'S62319A', 'S62319B', 'S62320A', 'S62320B', 'S62321A',
        'S62321B', 'S62322A', 'S62322B', 'S62323A', 'S62323B', 'S62324A', 'S62324B', 'S62325A',
        'S62325B', 'S62326A', 'S62326B', 'S62327A', 'S62327B', 'S62328A', 'S62328B', 'S62329A',
        'S62329B', 'S62330A', 'S62330B', 'S62331A', 'S62331B', 'S62332A', 'S62332B', 'S62333A',
        'S62333B', 'S62334A', 'S62334B', 'S62335A', 'S62335B', 'S62336A', 'S62336B', 'S62337A',
        'S62337B', 'S62338A', 'S62338B', 'S62339A', 'S62339B', 'S62340A', 'S62340B', 'S62341A',
        'S62341B', 'S62342A', 'S62342B', 'S62343A', 'S62343B', 'S62344A', 'S62344B', 'S62345A',
        'S62345B', 'S62346A', 'S62346B', 'S62347A', 'S62347B', 'S62348A', 'S62348B', 'S62349A',
        'S62349B', 'S62350A', 'S62350B', 'S62351A', 'S62351B', 'S62352A', 'S62352B', 'S62353A',
        'S62353B', 'S62354A', 'S62354B', 'S62355A', 'S62355B', 'S62356A', 'S62356B', 'S62357A',
        'S62357B', 'S62358A', 'S62358B', 'S62359A', 'S62359B', 'S62360A', 'S62360B', 'S62361A',
        'S62361B', 'S62362A', 'S62362B', 'S62363A', 'S62363B', 'S62364A', 'S62364B', 'S62365A',
        'S62365B', 'S62366A', 'S62366B', 'S62367A', 'S62367B', 'S62368A', 'S62368B', 'S62369A',
        'S62369B', 'S62390A', 'S62390B', 'S62391A', 'S62391B', 'S62392A', 'S62392B', 'S62393A',
        'S62393B', 'S62394A', 'S62394B', 'S62395A', 'S62395B', 'S62396A', 'S62396B', 'S62397A',
        'S62397B', 'S62398A', 'S62398B', 'S62399A', 'S62399B', 'S6290XA', 'S6290XB', 'S6291XA',
        'S6291XB', 'S6292XA', 'S6292XB', 'S72001A', 'S72001B', 'S72001C', 'S72001D', 'S72001E',
        'S72001F', 'S72001G', 'S72001H', 'S72001J', 'S72001K', 'S72001M', 'S72001N', 'S72001P',
        'S72001Q', 'S72001R', 'S72001S', 'S72002A', 'S72002B', 'S72002C', 'S72002D', 'S72002E',
        'S72002F', 'S72002G', 'S72002H', 'S72002J', 'S72002K', 'S72002M', 'S72002N', 'S72002P',
        'S72002Q', 'S72002R', 'S72002S', 'S72009A', 'S72009B', 'S72009C', 'S72009D', 'S72009E',
        'S72009F', 'S72009G', 'S72009H', 'S72009J', 'S72009K', 'S72009M', 'S72009N', 'S72009P',
        'S72009Q', 'S72009R', 'S72009S', 'S72011A', 'S72011B', 'S72011C', 'S72011D', 'S72011E',
        'S72011F', 'S72011G', 'S72011H', 'S72011J', 'S72011K', 'S72011M', 'S72011N', 'S72011P',
        'S72011Q', 'S72011R', 'S72011S', 'S72012A', 'S72012B', 'S72012C', 'S72012D', 'S72012E',
        'S72012F', 'S72012G', 'S72012H', 'S72012J', 'S72012K', 'S72012M', 'S72012N', 'S72012P',
        'S72012Q', 'S72012R', 'S72012S', 'S72019A', 'S72019B', 'S72019C', 'S72019D', 'S72019E',
        'S72019F', 'S72019G', 'S72019H', 'S72019J', 'S72019K', 'S72019M', 'S72019N', 'S72019P',
        'S72019Q', 'S72019R', 'S72019S', 'S72021A', 'S72021B', 'S72021C', 'S72021D', 'S72021F',
        'S72021G', 'S72021H', 'S72021J', 'S72021K', 'S72021M', 'S72021N', 'S72021P', 'S72021Q',
        'S72021R', 'S72021S', 'S72022A', 'S72022B', 'S72022C', 'S72022D', 'S72022E', 'S72022F',
        'S72022G', 'S72022H', 'S72022J', 'S72022K', 'S72022M', 'S72022N', 'S72022P', 'S72022Q',
        'S72022R', 'S72022S', 'S72023A', 'S72023B', 'S72023C', 'S72023D', 'S72023E', 'S72023F',
        'S72023G', 'S72023H', 'S72023J', 'S72023K', 'S72023M', 'S72023N', 'S72023P', 'S72023Q',
        'S72023R', 'S72023S', 'S72024A', 'S72024B', 'S72024C', 'S72024D', 'S72024E', 'S72024F',
        'S72024G', 'S72024H', 'S72024J', 'S72024K', 'S72024M', 'S72024N', 'S72024P', 'S72024Q',
        'S72024R', 'S72024S', 'S72025A', 'S72025B', 'S72025C', 'S72025D', 'S72025E', 'S72025F',
        'S72025G', 'S72025H', 'S72025J', 'S72025K', 'S72025M', 'S72025N', 'S72025P', 'S72025Q',
        'S72025R', 'S72025S', 'S72026A', 'S72026B', 'S72026C', 'S72026D', 'S72026E', 'S72026F',
        'S72026G', 'S72026H', 'S72026J', 'S72026K', 'S72026M', 'S72026N', 'S72026P', 'S72026Q',
        'S72026R', 'S72026S', 'S72031A', 'S72031B', 'S72031C', 'S72031D', 'S72031E', 'S72031F',
        'S72031G', 'S72031H', 'S72031J', 'S72031K', 'S72031M', 'S72031N', 'S72031P', 'S72031Q',
        'S72031R', 'S72031S', 'S72032A', 'S72032B', 'S72032C', 'S72032D', 'S72032E', 'S72032F',
        'S72032G', 'S72032H', 'S72032J', 'S72032K', 'S72032M', 'S72032N', 'S72032P', 'S72032Q',
        'S72032R', 'S72032S', 'S72033A', 'S72033B', 'S72033C', 'S72033D', 'S72033E', 'S72033F',
        'S72033G', 'S72033H', 'S72033J', 'S72033K', 'S72033M', 'S72033N', 'S72033P', 'S72033Q',
        'S72033R', 'S72033S', 'S72034A', 'S72034B', 'S72034C', 'S72034D', 'S72034E', 'S72034F',
        'S72034G', 'S72034H', 'S72034J', 'S72034K', 'S72034M', 'S72034N', 'S72034P', 'S72034Q',
        'S72034R', 'S72034S', 'S72035A', 'S72035B', 'S72035C', 'S72035D', 'S72035E', 'S72035F',
        'S72035G', 'S72035H', 'S72035J', 'S72035K', 'S72035M', 'S72035N', 'S72035P', 'S72035Q',
        'S72035R', 'S72035S', 'S72036A', 'S72036B', 'S72036C', 'S72036D', 'S72036E', 'S72036F',
        'S72036G', 'S72036H', 'S72036J', 'S72036K', 'S72036M', 'S72036N', 'S72036P', 'S72036Q',
        'S72036R', 'S72036S', 'S72041A', 'S72041B', 'S72041C', 'S72041D', 'S72041E', 'S72041F',
        'S72041G', 'S72041H', 'S72041J', 'S72041K', 'S72041M', 'S72041N', 'S72041P', 'S72041Q',
        'S72041R', 'S72041S', 'S72042A', 'S72042B', 'S72042C', 'S72042D', 'S72042E', 'S72042F',
        'S72042G', 'S72042H', 'S72042J', 'S72042K', 'S72042M', 'S72042N', 'S72042P', 'S72042Q',
        'S72042R', 'S72042S', 'S72043A', 'S72043B', 'S72043C', 'S72043D', 'S72043E', 'S72043F',
        'S72043G', 'S72043H', 'S72043J', 'S72043K', 'S72043M', 'S72043N', 'S72043P', 'S72043Q',
        'S72043R', 'S72043S', 'S72044A', 'S72044B', 'S72044C', 'S72044D', 'S72044E', 'S72044F',
        'S72044G', 'S72044H', 'S72044J', 'S72044K', 'S72044M', 'S72044N', 'S72044P', 'S72044Q',
        'S72044R', 'S72044S', 'S72045A', 'S72045B', 'S72045C', 'S72045D', 'S72045E', 'S72045F',
        'S72045G', 'S72045H', 'S72045J', 'S72045K', 'S72045M', 'S72045N', 'S72045P', 'S72045Q',
        'S72045R', 'S72045S', 'S72046A', 'S72046B', 'S72046C', 'S72046D', 'S72046E', 'S72046F',
        'S72046G', 'S72046H', 'S72046J', 'S72046K', 'S72046M', 'S72046N', 'S72046P', 'S72046Q',
        'S72046R', 'S72046S', 'S72051A', 'S72051B', 'S72051C', 'S72051D', 'S72051E', 'S72051F',
        'S72051G', 'S72051H', 'S72051J', 'S72051K', 'S72051M', 'S72051N', 'S72051P', 'S72051Q',
        'S72051R', 'S72051S', 'S72052A', 'S72052B', 'S72052C', 'S72052D', 'S72052E', 'S72052F',
        'S72052G', 'S72052H', 'S72052J', 'S72052K', 'S72052M', 'S72052N', 'S72052P', 'S72052Q',
        'S72052R', 'S72052S', 'S72059A', 'S72059B', 'S72059C', 'S72059D', 'S72059E', 'S72059F',
        'S72059G', 'S72059H', 'S72059J', 'S72059K', 'S72059M', 'S72059N', 'S72059P', 'S72059Q',
        'S72059R', 'S72059S', 'S72061A', 'S72061B', 'S72061C', 'S72061D', 'S72061E', 'S72061F',
        'S72061G', 'S72061H', 'S72061J', 'S72061K', 'S72061M', 'S72061N', 'S72061P', 'S72061Q',
        'S72061R', 'S72061S', 'S72062A', 'S72062B', 'S72062C', 'S72062D', 'S72062E', 'S72062F',
        'S72062G', 'S72062H', 'S72062J', 'S72062K', 'S72062M', 'S72062N', 'S72062P', 'S72062Q',
        'S72062R', 'S72062S', 'S72063A', 'S72063B', 'S72063C', 'S72063D', 'S72063E', 'S72063F',
        'S72063G', 'S72063H', 'S72063J', 'S72063K', 'S72063M', 'S72063N', 'S72063P', 'S72063Q',
        'S72063R', 'S72063S', 'S72064A', 'S72064B', 'S72064C', 'S72064D', 'S72064E', 'S72064F',
        'S72064G', 'S72064H', 'S72064J', 'S72064K', 'S72064M', 'S72064N', 'S72064P', 'S72064Q',
        'S72064R', 'S72064S', 'S72065A', 'S72065B', 'S72065C', 'S72065D', 'S72065E', 'S72065F',
        'S72065G', 'S72065H', 'S72065J', 'S72065K', 'S72065M', 'S72065N', 'S72065P', 'S72065Q',
        'S72065R', 'S72065S', 'S72066A', 'S72066B', 'S72066C', 'S72066D', 'S72066E', 'S72066F',
        'S72066G', 'S72066H', 'S72066J', 'S72066K', 'S72066M', 'S72066N', 'S72066P', 'S72066Q',
        'S72066R', 'S72066S', 'S72091A', 'S72091B', 'S72091C', 'S72091D', 'S72091E', 'S72091F',
        'S72091G', 'S72091H', 'S72091J', 'S72091K', 'S72091M', 'S72091N', 'S72091P', 'S72091Q',
        'S72091R', 'S72091S', 'S72092A', 'S72092B', 'S72092C', 'S72092D', 'S72092E', 'S72092F',
        'S72092G', 'S72092H', 'S72092J', 'S72092K', 'S72092M', 'S72092N', 'S72092P', 'S72092Q',
        'S72092R', 'S72092S', 'S72099A', 'S72099B', 'S72099C', 'S72099D', 'S72099E', 'S72099F',
        'S72099G', 'S72099H', 'S72099J', 'S72099K', 'S72099M', 'S72099N', 'S72099P', 'S72099Q',
        'S72099R', 'S72099S', 'S72101A', 'S72101B', 'S72101C', 'S72101D', 'S72101E', 'S72101F',
        'S72101G', 'S72101H', 'S72101J', 'S72101K', 'S72101M', 'S72101N', 'S72101P', 'S72101Q',
        'S72101R', 'S72101S', 'S72102A', 'S72102B', 'S72102C', 'S72102D', 'S72102E', 'S72102F',
        'S72102G', 'S72102H', 'S72102J', 'S72102K', 'S72102M', 'S72102N', 'S72102P', 'S72102Q',
        'S72102R', 'S72102S', 'S72109A', 'S72109B', 'S72109C', 'S72109D', 'S72109E', 'S72109F',
        'S72109G', 'S72109H', 'S72109J', 'S72109K', 'S72109M', 'S72109N', 'S72109P', 'S72109Q',
        'S72109R', 'S72109S', 'S72111A', 'S72111B', 'S72111C', 'S72111D', 'S72111E', 'S72111F',
        'S72111G', 'S72111H', 'S72111J', 'S72111K', 'S72111M', 'S72111N', 'S72111P', 'S72111Q',
        'S72111R', 'S72111S', 'S72112A', 'S72112B', 'S72112C', 'S72112D', 'S72112E', 'S72112F',
        'S72112G', 'S72112H', 'S72112J', 'S72112K', 'S72112M', 'S72112N', 'S72112P', 'S72112Q',
        'S72112R', 'S72112S', 'S72113A', 'S72113B', 'S72113C', 'S72113D', 'S72113E', 'S72113F',
        'S72113G', 'S72113H', 'S72113J', 'S72113K', 'S72113M', 'S72113N', 'S72113P', 'S72113Q',
        'S72113R', 'S72113S', 'S72114A', 'S72114B', 'S72114C', 'S72114D', 'S72114E', 'S72114F',
        'S72114G', 'S72114H', 'S72114J', 'S72114K', 'S72114M', 'S72114N', 'S72114P', 'S72114Q',
        'S72114R', 'S72114S', 'S72115A', 'S72115B', 'S72115C', 'S72115D', 'S72115E', 'S72115F',
        'S72115G', 'S72115H', 'S72115J', 'S72115K', 'S72115M', 'S72115N', 'S72115P', 'S72115Q',
        'S72115R', 'S72115S', 'S72116A', 'S72116B', 'S72116C', 'S72116D', 'S72116E', 'S72116F',
        'S72116G', 'S72116H', 'S72116J', 'S72116K', 'S72116M', 'S72116N', 'S72116P', 'S72116Q',
        'S72116R', 'S72116S', 'S72121A', 'S72121B', 'S72121C', 'S72121D', 'S72121E', 'S72121F',
        'S72121G', 'S72121H', 'S72121J', 'S72121K', 'S72121M', 'S72121N', 'S72121P', 'S72121Q',
        'S72121R', 'S72121S', 'S72122A', 'S72122B', 'S72122C', 'S72122D', 'S72122E', 'S72122F',
        'S72122G', 'S72122H', 'S72122J', 'S72122K', 'S72122M', 'S72122N', 'S72122P', 'S72122Q',
        'S72122R', 'S72122S', 'S72123A', 'S72123B', 'S72123C', 'S72123D', 'S72123E', 'S72123F',
        'S72123G', 'S72123H', 'S72123J', 'S72123K', 'S72123M', 'S72123N', 'S72123P', 'S72123Q',
        'S72123R', 'S72123S', 'S72124A', 'S72124B', 'S72124C', 'S72124D', 'S72124E', 'S72124F',
        'S72124G', 'S72124H', 'S72124J', 'S72124K', 'S72124M', 'S72124N', 'S72124P', 'S72124Q',
        'S72124R', 'S72124S', 'S72125A', 'S72125B', 'S72125C', 'S72125D', 'S72125E', 'S72125F',
        'S72125G', 'S72125H', 'S72125J', 'S72125K', 'S72125M', 'S72125N', 'S72125P', 'S72125Q',
        'S72125R', 'S72125S', 'S72126A', 'S72126B', 'S72126C', 'S72126D', 'S72126E', 'S72126F',
        'S72126G', 'S72126H', 'S72126J', 'S72126K', 'S72126M', 'S72126N', 'S72126P', 'S72126Q',
        'S72126R', 'S72126S', 'S72131A', 'S72131B', 'S72131C', 'S72131D', 'S72131E', 'S72131F',
        'S72131G', 'S72131H', 'S72131J', 'S72131K', 'S72131M', 'S72131N', 'S72131P', 'S72131Q',
        'S72131R', 'S72131S', 'S72132A', 'S72132B', 'S72132C', 'S72132D', 'S72132E', 'S72132F',
        'S72132G', 'S72132H', 'S72132J', 'S72132K', 'S72132M', 'S72132N', 'S72132P', 'S72132Q',
        'S72132R', 'S72132S', 'S72133A', 'S72133B', 'S72133C', 'S72133D', 'S72133E', 'S72133F',
        'S72133G', 'S72133H', 'S72133J', 'S72133K', 'S72133M', 'S72133N', 'S72133P', 'S72133Q',
        'S72133R', 'S72133S', 'S72134A', 'S72134B', 'S72134C', 'S72134D', 'S72134E', 'S72134F',
        'S72134G', 'S72134H', 'S72134J', 'S72134K', 'S72134M', 'S72134N', 'S72134P', 'S72134Q',
        'S72134R', 'S72134S', 'S72135A', 'S72135B', 'S72135C', 'S72135D', 'S72135E', 'S72135F',
        'S72135G', 'S72135H', 'S72135J', 'S72135K', 'S72135M', 'S72135N', 'S72135P', 'S72135Q',
        'S72135R', 'S72135S', 'S72136A', 'S72136B', 'S72136C', 'S72136D', 'S72136E', 'S72136F',
        'S72136G', 'S72136H', 'S72136J', 'S72136K', 'S72136M', 'S72136N', 'S72136P', 'S72136Q',
        'S72136R', 'S72136S', 'S72141A', 'S72141B', 'S72141C', 'S72141D', 'S72141E', 'S72141F',
        'S72141G', 'S72141H', 'S72141J', 'S72141K', 'S72141M', 'S72141N', 'S72141P', 'S72141Q',
        'S72141R', 'S72141S', 'S72142A', 'S72142B', 'S72142C', 'S72142D', 'S72142E', 'S72142F',
        'S72142G', 'S72142H', 'S72142J', 'S72142K', 'S72142M', 'S72142N', 'S72142P', 'S72142Q',
        'S72142R', 'S72142S', 'S72143A', 'S72143B', 'S72143C', 'S72143D', 'S72143E', 'S72143F',
        'S72143G', 'S72143H', 'S72143J', 'S72143K', 'S72143M', 'S72143N', 'S72143P', 'S72143Q',
        'S72143R', 'S72143S', 'S72144A', 'S72144B', 'S72144C', 'S72144D', 'S72144E', 'S72144F',
        'S72144G', 'S72144H', 'S72144J', 'S72144K', 'S72144M', 'S72144N', 'S72144P', 'S72144Q',
        'S72144R', 'S72144S', 'S72145A', 'S72145B', 'S72145C', 'S72145D', 'S72145E', 'S72145F',
        'S72145G', 'S72145H', 'S72145J', 'S72145K', 'S72145M', 'S72145N', 'S72145P', 'S72145Q',
        'S72145R', 'S72145S', 'S72146A', 'S72146B', 'S72146C', 'S72146D', 'S72146E', 'S72146F',
        'S72146G', 'S72146H', 'S72146J', 'S72146K', 'S72146M', 'S72146N', 'S72146P', 'S72146Q',
        'S72146R', 'S72146S', 'S7221XA', 'S7221XB', 'S7221XC', 'S7221XD', 'S7221XE', 'S7221XF',
        'S7221XG', 'S7221XH', 'S7221XJ', 'S7221XK', 'S7221XM', 'S7221XN', 'S7221XP', 'S7221XQ',
        'S7221XR', 'S7221XS', 'S7222XA', 'S7222XB', 'S7222XC', 'S7222XD', 'S7222XE', 'S7222XF',
        'S7222XG', 'S7222XH', 'S7222XJ', 'S7222XK', 'S7222XM', 'S7222XN', 'S7222XP', 'S7222XQ',
        'S7222XR', 'S7222XS', 'S7223XA', 'S7223XB', 'S7223XC', 'S7223XD', 'S7223XE', 'S7223XF',
        'S7223XG', 'S7223XH', 'S7223XJ', 'S7223XK', 'S7223XM', 'S7223XN', 'S7223XP', 'S7223XQ',
        'S7223XR', 'S7223XS', 'S7224XA', 'S7224XB', 'S7224XC', 'S7224XD', 'S7224XE', 'S7224XF',
        'S7224XG', 'S7224XH', 'S7224XJ', 'S7224XK', 'S7224XM', 'S7224XN', 'S7224XP', 'S7224XQ',
        'S7224XR', 'S7224XS', 'S7225XA', 'S7225XB', 'S7225XC', 'S7225XD', 'S7225XE', 'S7225XF',
        'S7225XG', 'S7225XH', 'S7225XJ', 'S7225XK', 'S7225XM', 'S7225XN', 'S7225XP', 'S7225XQ',
        'S7225XR', 'S7225XS', 'S7226XA', 'S7226XB', 'S7226XC', 'S7226XD', 'S7226XE', 'S7226XF',
        'S7226XG', 'S7226XH', 'S7226XJ', 'S7226XK', 'S7226XM', 'S7226XN', 'S7226XP', 'S7226XQ',
        'S7226XR', 'S7226XS', 'S72301A', 'S72301B', 'S72301C', 'S72301D', 'S72301E', 'S72301F',
        'S72301G', 'S72301H', 'S72301J', 'S72301K', 'S72301M', 'S72301N', 'S72301P', 'S72301Q',
        'S72301R', 'S72301S', 'S72302A', 'S72302B', 'S72302C', 'S72302D', 'S72302E', 'S72302F',
        'S72302G', 'S72302H', 'S72302J', 'S72302K', 'S72302M', 'S72302N', 'S72302P', 'S72302Q',
        'S72302R', 'S72302S', 'S72309A', 'S72309B', 'S72309C', 'S72309D', 'S72309E', 'S72309F',
        'S72309G', 'S72309H', 'S72309J', 'S72309K', 'S72309M', 'S72309N', 'S72309P', 'S72309Q',
        'S72309R', 'S72309S', 'S72321A', 'S72321B', 'S72321C', 'S72321D', 'S72321E', 'S72321F',
        'S72321G', 'S72321H', 'S72321J', 'S72321K', 'S72321M', 'S72321N', 'S72321P', 'S72321Q',
        'S72321R', 'S72321S', 'S72322A', 'S72322B', 'S72322C', 'S72322D', 'S72322E', 'S72322F',
        'S72322G', 'S72322H', 'S72322J', 'S72322K', 'S72322M', 'S72322N', 'S72322P', 'S72322Q',
        'S72322R', 'S72322S', 'S72323A', 'S72323B', 'S72323C', 'S72323D', 'S72323E', 'S72323F',
        'S72323G', 'S72323H', 'S72323J', 'S72323K', 'S72323M', 'S72323N', 'S72323P', 'S72323Q',
        'S72323R', 'S72323S', 'S72324A', 'S72324B', 'S72324C', 'S72324D', 'S72324E', 'S72324F',
        'S72324G', 'S72324H', 'S72324J', 'S72324K', 'S72324M', 'S72324N', 'S72324P', 'S72324Q',
        'S72324R', 'S72324S', 'S72325A', 'S72325B', 'S72325C', 'S72325D', 'S72325E', 'S72325F',
        'S72325G', 'S72325H', 'S72325J', 'S72325K', 'S72325M', 'S72325N', 'S72325P', 'S72325Q',
        'S72325R', 'S72325S', 'S72326A', 'S72326B', 'S72326C', 'S72326D', 'S72326E', 'S72326F',
        'S72326G', 'S72326H', 'S72326J', 'S72326K', 'S72326M', 'S72326N', 'S72326P', 'S72326Q',
        'S72326R', 'S72326S', 'S72331A', 'S72331B', 'S72331C', 'S72331D', 'S72331E', 'S72331F',
        'S72331G', 'S72331H', 'S72331J', 'S72331K', 'S72331M', 'S72331N', 'S72331P', 'S72331Q',
        'S72331R', 'S72331S', 'S72332A', 'S72332B', 'S72332C', 'S72332D', 'S72332E', 'S72332F',
        'S72332G', 'S72332H', 'S72332J', 'S72332K', 'S72332M', 'S72332N', 'S72332P', 'S72332Q',
        'S72332R', 'S72332S', 'S72333A', 'S72333B', 'S72333C', 'S72333D', 'S72333E', 'S72333F',
        'S72333G', 'S72333H', 'S72333J', 'S72333K', 'S72333M', 'S72333N', 'S72333P', 'S72333Q',
        'S72333R', 'S72333S', 'S72334A', 'S72334B', 'S72334C', 'S72334D', 'S72334E', 'S72334F',
        'S72334G', 'S72334H', 'S72334J', 'S72334K', 'S72334M', 'S72334N', 'S72334P', 'S72334Q',
        'S72334R', 'S72334S', 'S72335A', 'S72335B', 'S72335C', 'S72335D', 'S72335E', 'S72335F',
        'S72335G', 'S72335H', 'S72335J', 'S72335K', 'S72335M', 'S72335N', 'S72335P', 'S72335Q',
        'S72335R', 'S72335S', 'S72336A', 'S72336B', 'S72336C', 'S72336D', 'S72336E', 'S72336F',
        'S72336G', 'S72336H', 'S72336J', 'S72336K', 'S72336M', 'S72336N', 'S72336P', 'S72336Q',
        'S72336R', 'S72336S', 'S72341A', 'S72341B', 'S72341C', 'S72341D', 'S72341E', 'S72341F',
        'S72341G', 'S72341H', 'S72341J', 'S72341K', 'S72341M', 'S72341N', 'S72341P', 'S72341Q',
        'S72341R', 'S72341S', 'S72342A', 'S72342B', 'S72342C', 'S72342D', 'S72342E', 'S72342F',
        'S72342G', 'S72342H', 'S72342J', 'S72342K', 'S72342M', 'S72342N', 'S72342P', 'S72342Q',
        'S72342R', 'S72342S', 'S72343A', 'S72343B', 'S72343C', 'S72343D', 'S72343E', 'S72343F',
        'S72343G', 'S72343H', 'S72343J', 'S72343K', 'S72343M', 'S72343N', 'S72343P', 'S72343Q',
        'S72343R', 'S72343S', 'S72344A', 'S72344B', 'S72344C', 'S72344D', 'S72344E', 'S72344F',
        'S72344G', 'S72344H', 'S72344J', 'S72344K', 'S72344M', 'S72344N', 'S72344P', 'S72344Q',
        'S72344R', 'S72344S', 'S72345A', 'S72345B', 'S72345C', 'S72345D', 'S72345E', 'S72345F',
        'S72345G', 'S72345H', 'S72345J', 'S72345K', 'S72345M', 'S72345N', 'S72345P', 'S72345Q',
        'S72345R', 'S72345S', 'S72346A', 'S72346B', 'S72346C', 'S72346D', 'S72346E', 'S72346F',
        'S72346G', 'S72346H', 'S72346J', 'S72346K', 'S72346M', 'S72346N', 'S72346P', 'S72346Q',
        'S72346R', 'S72346S', 'S72351A', 'S72351B', 'S72351C', 'S72351D', 'S72351E', 'S72351F',
        'S72351G', 'S72351H', 'S72351J', 'S72351K', 'S72351M', 'S72351N', 'S72351P', 'S72351Q',
        'S72351R', 'S72351S', 'S72352A', 'S72352B', 'S72352C', 'S72352D', 'S72352E', 'S72352F',
        'S72352G', 'S72352H', 'S72352J', 'S72352K', 'S72352M', 'S72352N', 'S72352P', 'S72352Q',
        'S72352R', 'S72352S', 'S72353A', 'S72353B', 'S72353C', 'S72353D', 'S72353E', 'S72353F',
        'S72353G', 'S72353H', 'S72353J', 'S72353K', 'S72353M', 'S72353N', 'S72353P', 'S72353Q',
        'S72353R', 'S72353S', 'S72354A', 'S72354B', 'S72354C', 'S72354D', 'S72354E', 'S72354F',
        'S72354G', 'S72354H', 'S72354J', 'S72354K', 'S72354M', 'S72354N', 'S72354P', 'S72354Q',
        'S72354R', 'S72354S', 'S72355A', 'S72355B', 'S72355C', 'S72355D', 'S72355E', 'S72355F',
        'S72355G', 'S72355H', 'S72355J', 'S72355K', 'S72355M', 'S72355N', 'S72355P', 'S72355Q',
        'S72355R', 'S72355S', 'S72356A', 'S72356B', 'S72356C', 'S72356D', 'S72356E', 'S72356F',
        'S72356G', 'S72356H', 'S72356J', 'S72356K', 'S72356M', 'S72356N', 'S72356P', 'S72356Q',
        'S72356R', 'S72356S', 'S72361A', 'S72361B', 'S72361C', 'S72361D', 'S72361E', 'S72361F',
        'S72361G', 'S72361H', 'S72361J', 'S72361K', 'S72361M', 'S72361N', 'S72361P', 'S72361Q',
        'S72361R', 'S72361S', 'S72362A', 'S72362B', 'S72362C', 'S72362D', 'S72362E', 'S72362F',
        'S72362G', 'S72362H', 'S72362J', 'S72362K', 'S72362M', 'S72362N', 'S72362P', 'S72362Q',
        'S72362R', 'S72362S', 'S72363A', 'S72363B', 'S72363C', 'S72363D', 'S72363E', 'S72363F',
        'S72363G', 'S72363H', 'S72363J', 'S72363K', 'S72363M', 'S72363N', 'S72363P', 'S72363Q',
        'S72363R', 'S72363S', 'S72364A', 'S72364B', 'S72364C', 'S72364D', 'S72364E', 'S72364F',
        'S72364G', 'S72364H', 'S72364J', 'S72364K', 'S72364M', 'S72364N', 'S72364P', 'S72364Q',
        'S72364R', 'S72364S', 'S72365A', 'S72365B', 'S72365C', 'S72365D', 'S72365E', 'S72365F',
        'S72365G', 'S72365H', 'S72365J', 'S72365K', 'S72365M', 'S72365N', 'S72365P', 'S72365Q',
        'S72365R', 'S72365S', 'S72366A', 'S72366B', 'S72366C', 'S72366D', 'S72366E', 'S72366F',
        'S72366G', 'S72366H', 'S72366J', 'S72366K', 'S72366M', 'S72366N', 'S72366P', 'S72366Q',
        'S72366R', 'S72366S', 'S72391A', 'S72391B', 'S72391C', 'S72391D', 'S72391E', 'S72391F',
        'S72391G', 'S72391H', 'S72391J', 'S72391K', 'S72391M', 'S72391N', 'S72391P', 'S72391Q',
        'S72391R', 'S72391S', 'S72392A', 'S72392B', 'S72392C', 'S72392D', 'S72392E', 'S72392F',
        'S72392G', 'S72392H', 'S72392J', 'S72392K', 'S72392M', 'S72392N', 'S72392P', 'S72392Q',
        'S72392R', 'S72392S', 'S72399A', 'S72399B', 'S72399C', 'S72399D', 'S72399E', 'S72399F',
        'S72399G', 'S72399H', 'S72399J', 'S72399K', 'S72399M', 'S72399N', 'S72399P', 'S72399Q',
        'S72399R', 'S72399S', 'S72401A', 'S72401B', 'S72401C', 'S72401D', 'S72401E', 'S72401F',
        'S72401G', 'S72401H', 'S72401J', 'S72401K', 'S72401M', 'S72401N', 'S72401P', 'S72401Q',
        'S72401R', 'S72401S', 'S72402A', 'S72402B', 'S72402C', 'S72402D', 'S72402E', 'S72402F',
        'S72402G', 'S72402H', 'S72402J', 'S72402K', 'S72402M', 'S72402N', 'S72402P', 'S72402Q',
        'S72402R', 'S72402S', 'S72409A', 'S72409B', 'S72409C', 'S72409D', 'S72409E', 'S72409F',
        'S72409G', 'S72409H', 'S72409J', 'S72409K', 'S72409M', 'S72409N', 'S72409P', 'S72409Q',
        'S72409R', 'S72409S', 'S72411A', 'S72411B', 'S72411C', 'S72411D', 'S72411E', 'S72411F',
        'S72411G', 'S72411H', 'S72411J', 'S72411K', 'S72411M', 'S72411N', 'S72411P', 'S72411Q',
        'S72411R', 'S72411S', 'S72412A', 'S72412B', 'S72412C', 'S72412D', 'S72412E', 'S72412F',
        'S72412G', 'S72412H', 'S72412J', 'S72412K', 'S72412M', 'S72412N', 'S72412P', 'S72412Q',
        'S72412R', 'S72412S', 'S72413A', 'S72413B', 'S72413C', 'S72413D', 'S72413E', 'S72413F',
        'S72413G', 'S72413H', 'S72413J', 'S72413K', 'S72413M', 'S72413N', 'S72413P', 'S72413Q',
        'S72413R', 'S72413S', 'S72414A', 'S72414B', 'S72414C', 'S72414D', 'S72414E', 'S72414F',
        'S72414G', 'S72414H', 'S72414J', 'S72414K', 'S72414M', 'S72414N', 'S72414P', 'S72414Q',
        'S72414R', 'S72414S', 'S72415A', 'S72415B', 'S72415C', 'S72415D', 'S72415E', 'S72415F',
        'S72415G', 'S72415H', 'S72415J', 'S72415K', 'S72415M', 'S72415N', 'S72415P', 'S72415Q',
        'S72415R', 'S72415S', 'S72416A', 'S72416B', 'S72416C', 'S72416D', 'S72416E', 'S72416F',
        'S72416G', 'S72416H', 'S72416J', 'S72416K', 'S72416M', 'S72416N', 'S72416P', 'S72416Q',
        'S72416R', 'S72416S', 'S72421A', 'S72421B', 'S72421C', 'S72421D', 'S72421E', 'S72421F',
        'S72421G', 'S72421H', 'S72421J', 'S72421K', 'S72421M', 'S72421N', 'S72421P', 'S72421Q',
        'S72421R', 'S72421S', 'S72422A', 'S72422B', 'S72422C', 'S72422D', 'S72422E', 'S72422F',
        'S72422G', 'S72422H', 'S72422J', 'S72422K', 'S72422M', 'S72422N', 'S72422P', 'S72422Q',
        'S72422R', 'S72422S', 'S72423A', 'S72423B', 'S72423C', 'S72423D', 'S72423E', 'S72423F',
        'S72423G', 'S72423H', 'S72423J', 'S72423K', 'S72423M', 'S72423N', 'S72423P', 'S72423Q',
        'S72423R', 'S72423S', 'S72424A', 'S72424B', 'S72424C', 'S72424D', 'S72424E', 'S72424F',
        'S72424G', 'S72424H', 'S72424J', 'S72424K', 'S72424M', 'S72424N', 'S72424P', 'S72424Q',
        'S72424R', 'S72424S', 'S72425A', 'S72425B', 'S72425C', 'S72425D', 'S72425E', 'S72425F',
        'S72425G', 'S72425H', 'S72425J', 'S72425K', 'S72425M', 'S72425N', 'S72425P', 'S72425Q',
        'S72425R', 'S72425S', 'S72426A', 'S72426B', 'S72426C', 'S72426D', 'S72426E', 'S72426F',
        'S72426G', 'S72426H', 'S72426J', 'S72426K', 'S72426M', 'S72426N', 'S72426P', 'S72426Q',
        'S72426R', 'S72426S', 'S72431A', 'S72431B', 'S72431C', 'S72431D', 'S72431E', 'S72431F',
        'S72431G', 'S72431H', 'S72431J', 'S72431K', 'S72431M', 'S72431N', 'S72431P', 'S72431Q',
        'S72431R', 'S72431S', 'S72432A', 'S72432B', 'S72432C', 'S72432D', 'S72432E', 'S72432F',
        'S72432G', 'S72432H', 'S72432J', 'S72432K', 'S72432M', 'S72432N', 'S72432P', 'S72432Q',
        'S72432R', 'S72432S', 'S72433A', 'S72433B', 'S72433C', 'S72433D', 'S72433E', 'S72433F',
        'S72433G', 'S72433H', 'S72433J', 'S72433K', 'S72433M', 'S72433N', 'S72433P', 'S72433Q',
        'S72433R', 'S72433S', 'S72434A', 'S72434B', 'S72434C', 'S72434D', 'S72434E', 'S72434F',
        'S72434G', 'S72434H', 'S72434J', 'S72434K', 'S72434M', 'S72434N', 'S72434P', 'S72434Q',
        'S72434R', 'S72434S', 'S72435A', 'S72435B', 'S72435C', 'S72435D', 'S72435E', 'S72435F',
        'S72435G', 'S72435H', 'S72435J', 'S72435K', 'S72435M', 'S72435N', 'S72435P', 'S72435Q',
        'S72435R', 'S72435S', 'S72436A', 'S72436B', 'S72436C', 'S72436D', 'S72436E', 'S72436F',
        'S72436G', 'S72436H', 'S72436J', 'S72436K', 'S72436M', 'S72436N', 'S72436P', 'S72436Q',
        'S72436R', 'S72436S', 'S72441A', 'S72441B', 'S72441C', 'S72441D', 'S72441E', 'S72441F',
        'S72441G', 'S72441H', 'S72441J', 'S72441K', 'S72441M', 'S72441N', 'S72441P', 'S72441Q',
        'S72441R', 'S72441S', 'S72442A', 'S72442B', 'S72442C', 'S72442D', 'S72442E', 'S72442F',
        'S72442G', 'S72442H', 'S72442J', 'S72442K', 'S72442M', 'S72442N', 'S72442P', 'S72442Q',
        'S72442R', 'S72442S', 'S72443A', 'S72443B', 'S72443C', 'S72443D', 'S72443E', 'S72443F',
        'S72443G', 'S72443H', 'S72443J', 'S72443K', 'S72443M', 'S72443N', 'S72443P', 'S72443Q',
        'S72443R', 'S72443S', 'S72444A', 'S72444B', 'S72444C', 'S72444D', 'S72444E', 'S72444F',
        'S72444G', 'S72444H', 'S72444J', 'S72444K', 'S72444M', 'S72444N', 'S72444P', 'S72444Q',
        'S72444R', 'S72444S', 'S72445A', 'S72445B', 'S72445C', 'S72445D', 'S72445E', 'S72445F',
        'S72445G', 'S72445H', 'S72445J', 'S72445K', 'S72445M', 'S72445N', 'S72445P', 'S72445Q',
        'S72445R', 'S72445S', 'S72446A', 'S72446B', 'S72446C', 'S72446D', 'S72446E', 'S72446F',
        'S72446G', 'S72446H', 'S72446J', 'S72446K', 'S72446M', 'S72446N', 'S72446P', 'S72446Q',
        'S72446R', 'S72446S', 'S72451A', 'S72451B', 'S72451C', 'S72451D', 'S72451E', 'S72451F',
        'S72451G', 'S72451H', 'S72451J', 'S72451K', 'S72451M', 'S72451N', 'S72451P', 'S72451Q',
        'S72451R', 'S72451S', 'S72452A', 'S72452B', 'S72452C', 'S72452D', 'S72452E', 'S72452F',
        'S72452G', 'S72452H', 'S72452J', 'S72452K', 'S72452M', 'S72452N', 'S72452P', 'S72452Q',
        'S72452R', 'S72452S', 'S72453A', 'S72453B', 'S72453C', 'S72453D', 'S72453E', 'S72453F',
        'S72453G', 'S72453H', 'S72453J', 'S72453K', 'S72453M', 'S72453N', 'S72453P', 'S72453Q',
        'S72453R', 'S72453S', 'S72454A', 'S72454B', 'S72454C', 'S72454D', 'S72454E', 'S72454F',
        'S72454G', 'S72454H', 'S72454J', 'S72454K', 'S72454M', 'S72454N', 'S72454P', 'S72454Q',
        'S72454R', 'S72454S', 'S72455A', 'S72455B', 'S72455C', 'S72455D', 'S72455E', 'S72455F',
        'S72455G', 'S72455H', 'S72455J', 'S72455K', 'S72455M', 'S72455N', 'S72455P', 'S72455Q',
        'S72455R', 'S72455S', 'S72456A', 'S72456B', 'S72456C', 'S72456D', 'S72456E', 'S72456F',
        'S72456G', 'S72456H', 'S72456J', 'S72456K', 'S72456M', 'S72456N', 'S72456P', 'S72456Q',
        'S72456R', 'S72456S', 'S72461A', 'S72461B', 'S72461C', 'S72461D', 'S72461E', 'S72461F',
        'S72461G', 'S72461H', 'S72461J', 'S72461K', 'S72461M', 'S72461N', 'S72461P', 'S72461Q',
        'S72461R', 'S72461S', 'S72462A', 'S72462B', 'S72462C', 'S72462D', 'S72462E', 'S72462F',
        'S72462G', 'S72462H', 'S72462J', 'S72462K', 'S72462M', 'S72462N', 'S72462P', 'S72462Q',
        'S72462R', 'S72462S', 'S72463A', 'S72463B', 'S72463C', 'S72463D', 'S72463E', 'S72463F',
        'S72463G', 'S72463H', 'S72463J', 'S72463K', 'S72463M', 'S72463N', 'S72463P', 'S72463Q',
        'S72463R', 'S72463S', 'S72464A', 'S72464B', 'S72464C', 'S72464D', 'S72464E', 'S72464F',
        'S72464G', 'S72464H', 'S72464J', 'S72464K', 'S72464M', 'S72464N', 'S72464P', 'S72464Q',
        'S72464R', 'S72464S', 'S72465A', 'S72465B', 'S72465C', 'S72465D', 'S72465E', 'S72465F',
        'S72465G', 'S72465H', 'S72465J', 'S72465K', 'S72465M', 'S72465N', 'S72465P', 'S72465Q',
        'S72465R', 'S72465S', 'S72466A', 'S72466B', 'S72466C', 'S72466D', 'S72466E', 'S72466F',
        'S72466G', 'S72466H', 'S72466J', 'S72466K', 'S72466M', 'S72466N', 'S72466P', 'S72466Q',
        'S72466R', 'S72466S', 'S72471A', 'S72471D', 'S72471G', 'S72471K', 'S72471P', 'S72471S',
        'S72472A', 'S72472D', 'S72472G', 'S72472K', 'S72472P', 'S72472S', 'S72479A', 'S72479D',
        'S72479G', 'S72479K', 'S72479P', 'S72479S', 'S72491A', 'S72491B', 'S72491C', 'S72491D',
        'S72491E', 'S72491F', 'S72491G', 'S72491H', 'S72491J', 'S72491K', 'S72491M', 'S72491N',
        'S72491P', 'S72491Q', 'S72491R', 'S72491S', 'S72492A', 'S72492B', 'S72492C', 'S72492D',
        'S72492E', 'S72492F', 'S72492G', 'S72492H', 'S72492J', 'S72492K', 'S72492M', 'S72492N',
        'S72492P', 'S72492Q', 'S72492R', 'S72492S', 'S72499A', 'S72499B', 'S72499C', 'S72499D',
        'S72499E', 'S72499F', 'S72499G', 'S72499H', 'S72499J', 'S72499K', 'S72499M', 'S72499N',
        'S72499P', 'S72499Q', 'S72499R', 'S72499S', 'S728X1A', 'S728X1B', 'S728X1C', 'S728X1D',
        'S728X1E', 'S728X1F', 'S728X1G', 'S728X1H', 'S728X1J', 'S728X1K', 'S728X1M', 'S728X1N',
        'S728X1P', 'S728X1Q', 'S728X1R', 'S728X1S', 'S728X2A', 'S728X2B', 'S728X2C', 'S728X2D',
        'S728X2E', 'S728X2F', 'S728X2G', 'S728X2H', 'S728X2J', 'S728X2K', 'S728X2M', 'S728X2N',
        'S728X2P', 'S728X2Q', 'S728X2R', 'S728X2S', 'S728X9A', 'S728X9B', 'S728X9C', 'S728X9D',
        'S728X9E', 'S728X9F', 'S728X9G', 'S728X9H', 'S728X9J', 'S728X9K', 'S728X9M', 'S728X9N',
        'S728X9P', 'S728X9Q', 'S728X9R', 'S728X9S', 'S7290XA', 'S7290XB', 'S7290XC', 'S7290XD',
        'S7290XE', 'S7290XF', 'S7290XG', 'S7290XH', 'S7290XJ', 'S7290XK', 'S7290XM', 'S7290XN',
        'S7290XP', 'S7290XQ', 'S7290XR', 'S7290XS', 'S7291XA', 'S7291XB', 'S7291XC', 'S7291XD',
        'S7291XE', 'S7291XF', 'S7291XG', 'S7291XH', 'S7291XJ', 'S7291XK', 'S7291XM', 'S7291XN',
        'S7291XP', 'S7291XQ', 'S7291XR', 'S7291XS', 'S7292XA', 'S7292XB', 'S7292XC', 'S7292XD',
        'S7292XE', 'S7292XF', 'S7292XG', 'S7292XH', 'S7292XJ', 'S7292XK', 'S7292XM', 'S7292XN',
        'S7292XP', 'S7292XQ', 'S7292XR', 'S7292XS', 'S79001A', 'S79002A', 'S79009A', 'S79011A',
        'S79012A', 'S79019A', 'S79091A', 'S79092A', 'S79099A', 'S79101A', 'S79102A', 'S79109A',
        'S79111A', 'S79112A', 'S79119A', 'S79121A', 'S79122A', 'S79129A', 'S79131A', 'S79132A',
        'S79139A', 'S79141A', 'S79142A', 'S79149A', 'S79191A', 'S79192A', 'S79199A', 'S82001A',
        'S82001B', 'S82001C', 'S82001D', 'S82001E', 'S82001F', 'S82001G', 'S82001H', 'S82001J',
        'S82001K', 'S82001M', 'S82001N', 'S82001P', 'S82001Q', 'S82001R', 'S82001S', 'S82002A',
        'S82002B', 'S82002C', 'S82002D', 'S82002E', 'S82002F', 'S82002G', 'S82002H', 'S82002J',
        'S82002K', 'S82002M', 'S82002N', 'S82002P', 'S82002Q', 'S82002R', 'S82002S', 'S82009A',
        'S82009B', 'S82009C', 'S82009D', 'S82009E', 'S82009F', 'S82009G', 'S82009H', 'S82009J',
        'S82009K', 'S82009M', 'S82009N', 'S82009P', 'S82009Q', 'S82009R', 'S82009S', 'S82011A',
        'S82011B', 'S82011C', 'S82011D', 'S82011E', 'S82011F', 'S82011G', 'S82011H', 'S82011J',
        'S82011K', 'S82011M', 'S82011N', 'S82011P', 'S82011Q', 'S82011R', 'S82011S', 'S82012A',
        'S82012B', 'S82012C', 'S82012D', 'S82012E', 'S82012F', 'S82012G', 'S82012H', 'S82012J',
        'S82012K', 'S82012M', 'S82012N', 'S82012P', 'S82012Q', 'S82012R', 'S82012S', 'S82013A',
        'S82013B', 'S82013C', 'S82013D', 'S82013E', 'S82013F', 'S82013G', 'S82013H', 'S82013J',
        'S82013K', 'S82013M', 'S82013N', 'S82013P', 'S82013Q', 'S82013R', 'S82013S', 'S82014A',
        'S82014B', 'S82014C', 'S82014D', 'S82014E', 'S82014F', 'S82014G', 'S82014H', 'S82014J',
        'S82014K', 'S82014M', 'S82014N', 'S82014P', 'S82014Q', 'S82014R', 'S82014S', 'S82015A',
        'S82015B', 'S82015C', 'S82015D', 'S82015E', 'S82015F', 'S82015G', 'S82015H', 'S82015J',
        'S82015K', 'S82015M', 'S82015N', 'S82015P', 'S82015Q', 'S82015R', 'S82015S', 'S82016A',
        'S82016B', 'S82016C', 'S82016D', 'S82016E', 'S82016F', 'S82016G', 'S82016H', 'S82016J',
        'S82016K', 'S82016M', 'S82016N', 'S82016P', 'S82016Q', 'S82016R', 'S82016S', 'S82021A',
        'S82021B', 'S82021C', 'S82021D', 'S82021E', 'S82021F', 'S82021G', 'S82021H', 'S82021J',
        'S82021K', 'S82021M', 'S82021N', 'S82021P', 'S82021Q', 'S82021R', 'S82021S', 'S82022A',
        'S82022B', 'S82022C', 'S82022D', 'S82022E', 'S82022F', 'S82022G', 'S82022H', 'S82022J',
        'S82022K', 'S82022M', 'S82022N', 'S82022P', 'S82022Q', 'S82022R', 'S82022S', 'S82023A',
        'S82023B', 'S82023C', 'S82023D', 'S82023E', 'S82023F', 'S82023G', 'S82023H', 'S82023J',
        'S82023K', 'S82023M', 'S82023N', 'S82023P', 'S82023Q', 'S82023R', 'S82023S', 'S82024A',
        'S82024B', 'S82024C', 'S82024D', 'S82024E', 'S82024F', 'S82024G', 'S82024H', 'S82024J',
        'S82024K', 'S82024M', 'S82024N', 'S82024P', 'S82024Q', 'S82024R', 'S82024S', 'S82025A',
        'S82025B', 'S82025C', 'S82025D', 'S82025E', 'S82025F', 'S82025G', 'S82025H', 'S82025J',
        'S82025K', 'S82025M', 'S82025N', 'S82025P', 'S82025Q', 'S82025R', 'S82025S', 'S82026A',
        'S82026B', 'S82026C', 'S82026D', 'S82026E', 'S82026F', 'S82026G', 'S82026H', 'S82026J',
        'S82026K', 'S82026M', 'S82026N', 'S82026P', 'S82026Q', 'S82026R', 'S82026S', 'S82031A',
        'S82031B', 'S82031C', 'S82031D', 'S82031E', 'S82031F', 'S82031G', 'S82031H', 'S82031J',
        'S82031K', 'S82031M', 'S82031N', 'S82031P', 'S82031Q', 'S82031R', 'S82031S', 'S82032A',
        'S82032B', 'S82032C', 'S82032D', 'S82032E', 'S82032F', 'S82032G', 'S82032H', 'S82032J',
        'S82032K', 'S82032M', 'S82032N', 'S82032P', 'S82032Q', 'S82032R', 'S82032S', 'S82033A',
        'S82033B', 'S82033C', 'S82033D', 'S82033E', 'S82033F', 'S82033G', 'S82033H', 'S82033J',
        'S82033K', 'S82033M', 'S82033N', 'S82033P', 'S82033Q', 'S82033R', 'S82033S', 'S82034A',
        'S82034B', 'S82034C', 'S82034D', 'S82034E', 'S82034F', 'S82034G', 'S82034H', 'S82034J',
        'S82034K', 'S82034M', 'S82034N', 'S82034P', 'S82034Q', 'S82034R', 'S82034S', 'S82035A',
        'S82035B', 'S82035C', 'S82035D', 'S82035E', 'S82035F', 'S82035G', 'S82035H', 'S82035J',
        'S82035K', 'S82035M', 'S82035N', 'S82035P', 'S82035Q', 'S82035R', 'S82035S', 'S82036A',
        'S82036B', 'S82036C', 'S82036D', 'S82036E', 'S82036F', 'S82036G', 'S82036H', 'S82036J',
        'S82036K', 'S82036M', 'S82036N', 'S82036P', 'S82036Q', 'S82036R', 'S82036S', 'S82041A',
        'S82041B', 'S82041C', 'S82041D', 'S82041E', 'S82041F', 'S82041G', 'S82041H', 'S82041J',
        'S82041K', 'S82041M', 'S82041N', 'S82041P', 'S82041Q', 'S82041R', 'S82041S', 'S82042A',
        'S82042B', 'S82042C', 'S82042D', 'S82042E', 'S82042F', 'S82042G', 'S82042H', 'S82042J',
        'S82042K', 'S82042M', 'S82042N', 'S82042P', 'S82042Q', 'S82042R', 'S82042S', 'S82043A',
        'S82043B', 'S82043C', 'S82043D', 'S82043E', 'S82043F', 'S82043G', 'S82043H', 'S82043J',
        'S82043K', 'S82043M', 'S82043N', 'S82043P', 'S82043Q', 'S82043R', 'S82043S', 'S82044A',
        'S82044B', 'S82044C', 'S82044D', 'S82044E', 'S82044F', 'S82044G', 'S82044H', 'S82044J',
        'S82044K', 'S82044M', 'S82044N', 'S82044P', 'S82044Q', 'S82044R', 'S82044S', 'S82045A',
        'S82045B', 'S82045C', 'S82045D', 'S82045E', 'S82045F', 'S82045G', 'S82045H', 'S82045J',
        'S82045K', 'S82045M', 'S82045N', 'S82045P', 'S82045Q', 'S82045R', 'S82045S', 'S82046A',
        'S82046B', 'S82046C', 'S82046D', 'S82046E', 'S82046F', 'S82046G', 'S82046H', 'S82046J',
        'S82046K', 'S82046M', 'S82046N', 'S82046P', 'S82046Q', 'S82046R', 'S82046S', 'S82091A',
        'S82091B', 'S82091C', 'S82091D', 'S82091E', 'S82091F', 'S82091G', 'S82091H', 'S82091J',
        'S82091K', 'S82091M', 'S82091N', 'S82091P', 'S82091Q', 'S82091R', 'S82091S', 'S82092A',
        'S82092B', 'S82092C', 'S82092D', 'S82092E', 'S82092F', 'S82092G', 'S82092H', 'S82092J',
        'S82092K', 'S82092M', 'S82092N', 'S82092P', 'S82092Q', 'S82092R', 'S82092S', 'S82099A',
        'S82099B', 'S82099C', 'S82099D', 'S82099E', 'S82099F', 'S82099G', 'S82099H', 'S82099J',
        'S82099K', 'S82099M', 'S82099N', 'S82099P', 'S82099Q', 'S82099R', 'S82099S', 'S82101A',
        'S82101B', 'S82101C', 'S82101D', 'S82101E', 'S82101F', 'S82101G', 'S82101H', 'S82101J',
        'S82101K', 'S82101M', 'S82101N', 'S82101P', 'S82101Q', 'S82101R', 'S82101S', 'S82102A',
        'S82102B', 'S82102C', 'S82102D', 'S82102E', 'S82102F', 'S82102G', 'S82102H', 'S82102J',
        'S82102K', 'S82102M', 'S82102N', 'S82102P', 'S82102Q', 'S82102R', 'S82102S', 'S82109A',
        'S82109B', 'S82109C', 'S82109D', 'S82109E', 'S82109F', 'S82109G', 'S82109H', 'S82109J',
        'S82109K', 'S82109M', 'S82109N', 'S82109P', 'S82109Q', 'S82109R', 'S82109S', 'S82111A',
        'S82111B', 'S82111C', 'S82111D', 'S82111E', 'S82111F', 'S82111G', 'S82111H', 'S82111J',
        'S82111K', 'S82111M', 'S82111N', 'S82111P', 'S82111Q', 'S82111R', 'S82111S', 'S82112A',
        'S82112B', 'S82112C', 'S82112D', 'S82112E', 'S82112F', 'S82112G', 'S82112H', 'S82112J',
        'S82112K', 'S82112M', 'S82112N', 'S82112P', 'S82112Q', 'S82112R', 'S82112S', 'S82113A',
        'S82113B', 'S82113C', 'S82113D', 'S82113E', 'S82113F', 'S82113G', 'S82113H', 'S82113J',
        'S82113K', 'S82113M', 'S82113N', 'S82113P', 'S82113Q', 'S82113R', 'S82113S', 'S82114A',
        'S82114B', 'S82114C', 'S82114D', 'S82114E', 'S82114F', 'S82114G', 'S82114H', 'S82114J',
        'S82114K', 'S82114M', 'S82114N', 'S82114P', 'S82114Q', 'S82114R', 'S82114S', 'S82115A',
        'S82115B', 'S82115C', 'S82115D', 'S82115E', 'S82115F', 'S82115G', 'S82115H', 'S82115J',
        'S82115K', 'S82115M', 'S82115N', 'S82115P', 'S82115Q', 'S82115R', 'S82115S', 'S82116A',
        'S82116B', 'S82116C', 'S82116D', 'S82116E', 'S82116F', 'S82116G', 'S82116H', 'S82116J',
        'S82116K', 'S82116M', 'S82116N', 'S82116P', 'S82116Q', 'S82116R', 'S82116S', 'S82121A',
        'S82121B', 'S82121C', 'S82121D', 'S82121E', 'S82121F', 'S82121G', 'S82121H', 'S82121J',
        'S82121K', 'S82121M', 'S82121N', 'S82121P', 'S82121Q', 'S82121R', 'S82121S', 'S82122A',
        'S82122B', 'S82122C', 'S82122D', 'S82122E', 'S82122F', 'S82122G', 'S82122H', 'S82122J',
        'S82122K', 'S82122M', 'S82122N', 'S82122P', 'S82122Q', 'S82122R', 'S82122S', 'S82123A',
        'S82123B', 'S82123C', 'S82123D', 'S82123E', 'S82123F', 'S82123G', 'S82123H', 'S82123J',
        'S82123K', 'S82123M', 'S82123N', 'S82123P', 'S82123Q', 'S82123R', 'S82123S', 'S82124A',
        'S82124B', 'S82124C', 'S82124D', 'S82124E', 'S82124F', 'S82124G', 'S82124H', 'S82124J',
        'S82124K', 'S82124M', 'S82124N', 'S82124P', 'S82124Q', 'S82124R', 'S82124S', 'S82125A',
        'S82125B', 'S82125C', 'S82125D', 'S82125E', 'S82125F', 'S82125G', 'S82125H', 'S82125J',
        'S82125K', 'S82125M', 'S82125N', 'S82125P', 'S82125Q', 'S82125R', 'S82125S', 'S82126A',
        'S82126B', 'S82126C', 'S82126D', 'S82126E', 'S82126F', 'S82126G', 'S82126H', 'S82126J',
        'S82126K', 'S82126M', 'S82126N', 'S82126P', 'S82126Q', 'S82126R', 'S82126S', 'S82131A',
        'S82131B', 'S82131C', 'S82131D', 'S82131E', 'S82131F', 'S82131G', 'S82131H', 'S82131J',
        'S82131K', 'S82131M', 'S82131N', 'S82131P', 'S82131Q', 'S82131R', 'S82131S', 'S82132A',
        'S82132B', 'S82132C', 'S82132D', 'S82132E', 'S82132F', 'S82132G', 'S82132H', 'S82132J',
        'S82132K', 'S82132M', 'S82132N', 'S82132P', 'S82132Q', 'S82132R', 'S82132S', 'S82133A',
        'S82133B', 'S82133C', 'S82133D', 'S82133E', 'S82133F', 'S82133G', 'S82133H', 'S82133J',
        'S82133K', 'S82133M', 'S82133N', 'S82133P', 'S82133Q', 'S82133R', 'S82133S', 'S82134A',
        'S82134B', 'S82134C', 'S82134D', 'S82134E', 'S82134F', 'S82134G', 'S82134H', 'S82134J',
        'S82134K', 'S82134M', 'S82134N', 'S82134P', 'S82134Q', 'S82134R', 'S82134S', 'S82135A',
        'S82135B', 'S82135C', 'S82135D', 'S82135E', 'S82135F', 'S82135G', 'S82135H', 'S82135J',
        'S82135K', 'S82135M', 'S82135N', 'S82135P', 'S82135Q', 'S82135R', 'S82135S', 'S82136A',
        'S82136B', 'S82136C', 'S82136D', 'S82136E', 'S82136F', 'S82136G', 'S82136H', 'S82136J',
        'S82136K', 'S82136M', 'S82136N', 'S82136P', 'S82136Q', 'S82136R', 'S82136S', 'S82141A',
        'S82141B', 'S82141C', 'S82141D', 'S82141E', 'S82141F', 'S82141G', 'S82141H', 'S82141J',
        'S82141K', 'S82141M', 'S82141N', 'S82141P', 'S82141Q', 'S82141R', 'S82141S', 'S82142A',
        'S82142B', 'S82142C', 'S82142D', 'S82142E', 'S82142F', 'S82142G', 'S82142H', 'S82142J',
        'S82142K', 'S82142M', 'S82142N', 'S82142P', 'S82142Q', 'S82142R', 'S82142S', 'S82143A',
        'S82143B', 'S82143C', 'S82143D', 'S82143E', 'S82143F', 'S82143G', 'S82143H', 'S82143J',
        'S82143K', 'S82143M', 'S82143N', 'S82143P', 'S82143Q', 'S82143R', 'S82143S', 'S82144A',
        'S82144B', 'S82144C', 'S82144D', 'S82144E', 'S82144F', 'S82144G', 'S82144H', 'S82144J',
        'S82144K', 'S82144M', 'S82144N', 'S82144P', 'S82144Q', 'S82144R', 'S82144S', 'S82145A',
        'S82145B', 'S82145C', 'S82145D', 'S82145E', 'S82145F', 'S82145G', 'S82145H', 'S82145J',
        'S82145K', 'S82145M', 'S82145N', 'S82145P', 'S82145Q', 'S82145R', 'S82145S', 'S82146A',
        'S82146B', 'S82146C', 'S82146D', 'S82146E', 'S82146F', 'S82146G', 'S82146H', 'S82146J',
        'S82146K', 'S82146M', 'S82146N', 'S82146P', 'S82146Q', 'S82146R', 'S82146S', 'S82151A',
        'S82151B', 'S82151C', 'S82151D', 'S82151E', 'S82151F', 'S82151G', 'S82151H', 'S82151J',
        'S82151K', 'S82151M', 'S82151N', 'S82151P', 'S82151Q', 'S82151R', 'S82151S', 'S82152A',
        'S82152B', 'S82152C', 'S82152D', 'S82152E', 'S82152F', 'S82152G', 'S82152H', 'S82152J',
        'S82152K', 'S82152M', 'S82152N', 'S82152P', 'S82152Q', 'S82152R', 'S82152S', 'S82153A',
        'S82153B', 'S82153C', 'S82153D', 'S82153E', 'S82153F', 'S82153G', 'S82153H', 'S82153J',
        'S82153K', 'S82153M', 'S82153N', 'S82153P', 'S82153Q', 'S82153R', 'S82153S', 'S82154A',
        'S82154B', 'S82154C', 'S82154D', 'S82154E', 'S82154F', 'S82154G', 'S82154H', 'S82154J',
        'S82154K', 'S82154M', 'S82154N', 'S82154P', 'S82154Q', 'S82154R', 'S82154S', 'S82155A',
        'S82155B', 'S82155C', 'S82155D', 'S82155E', 'S82155F', 'S82155G', 'S82155H', 'S82155J',
        'S82155K', 'S82155M', 'S82155N', 'S82155P', 'S82155Q', 'S82155R', 'S82155S', 'S82156A',
        'S82156B', 'S82156C', 'S82156D', 'S82156E', 'S82156F', 'S82156G', 'S82156H', 'S82156J',
        'S82156K', 'S82156M', 'S82156N', 'S82156P', 'S82156Q', 'S82156R', 'S82156S', 'S82161A',
        'S82161D', 'S82161G', 'S82161K', 'S82161P', 'S82161S', 'S82162A', 'S82162D', 'S82162G',
        'S82162K', 'S82162P', 'S82162S', 'S82169A', 'S82169D', 'S82169G', 'S82169K', 'S82169P',
        'S82169S', 'S82191A', 'S82191B', 'S82191C', 'S82191D', 'S82191E', 'S82191F', 'S82191G',
        'S82191H', 'S82191J', 'S82191K', 'S82191M', 'S82191N', 'S82191P', 'S82191Q', 'S82191R',
        'S82191S', 'S82192A', 'S82192B', 'S82192C', 'S82192D', 'S82192E', 'S82192F', 'S82192G',
        'S82192H', 'S82192J', 'S82192K', 'S82192M', 'S82192N', 'S82192P', 'S82192Q', 'S82192R',
        'S82192S', 'S82199A', 'S82199B', 'S82199C', 'S82199D', 'S82199E', 'S82199F', 'S82199G',
        'S82199H', 'S82199J', 'S82199K', 'S82199M', 'S82199N', 'S82199P', 'S82199Q', 'S82199R',
        'S82199S', 'S82201A', 'S82201B', 'S82201C', 'S82201D', 'S82201E', 'S82201F', 'S82201G',
        'S82201H', 'S82201J', 'S82201K', 'S82201M', 'S82201N', 'S82201P', 'S82201Q', 'S82201R',
        'S82201S', 'S82202A', 'S82202B', 'S82202C', 'S82202D', 'S82202E', 'S82202F', 'S82202G',
        'S82202H', 'S82202J', 'S82202K', 'S82202M', 'S82202N', 'S82202P', 'S82202Q', 'S82202R',
        'S82202S', 'S82209A', 'S82209B', 'S82209C', 'S82209D', 'S82209E', 'S82209F', 'S82209G',
        'S82209H', 'S82209J', 'S82209K', 'S82209M', 'S82209N', 'S82209P', 'S82209Q', 'S82209R',
        'S82209S', 'S82221A', 'S82221B', 'S82221C', 'S82221D', 'S82221E', 'S82221F', 'S82221G',
        'S82221H', 'S82221J', 'S82221K', 'S82221M', 'S82221N', 'S82221P', 'S82221Q', 'S82221R',
        'S82221S', 'S82222A', 'S82222B', 'S82222C', 'S82222D', 'S82222E', 'S82222F', 'S82222G',
        'S82222H', 'S82222J', 'S82222K', 'S82222M', 'S82222N', 'S82222P', 'S82222Q', 'S82222R',
        'S82222S', 'S82223A', 'S82223B', 'S82223C', 'S82223D', 'S82223E', 'S82223F', 'S82223G',
        'S82223H', 'S82223J', 'S82223K', 'S82223M', 'S82223N', 'S82223P', 'S82223Q', 'S82223R',
        'S82223S', 'S82224A', 'S82224B', 'S82224C', 'S82224D', 'S82224E', 'S82224F', 'S82224G',
        'S82224H', 'S82224J', 'S82224K', 'S82224M', 'S82224N', 'S82224P', 'S82224Q', 'S82224R',
        'S82224S', 'S82225A', 'S82225B', 'S82225C', 'S82225D', 'S82225E', 'S82225F', 'S82225G',
        'S82225H', 'S82225J', 'S82225K', 'S82225M', 'S82225N', 'S82225P', 'S82225Q', 'S82225R',
        'S82225S', 'S82226A', 'S82226B', 'S82226C', 'S82226D', 'S82226E', 'S82226F', 'S82226G',
        'S82226H', 'S82226J', 'S82226K', 'S82226M', 'S82226N', 'S82226P', 'S82226Q', 'S82226R',
        'S82226S', 'S82231A', 'S82231B', 'S82231C', 'S82231D', 'S82231E', 'S82231F', 'S82231G',
        'S82231H', 'S82231J', 'S82231K', 'S82231M', 'S82231N', 'S82231P', 'S82231Q', 'S82231R',
        'S82231S', 'S82232A', 'S82232B', 'S82232C', 'S82232D', 'S82232E', 'S82232F', 'S82232G',
        'S82232H', 'S82232J', 'S82232K', 'S82232M', 'S82232N', 'S82232P', 'S82232Q', 'S82232R',
        'S82232S', 'S82233A', 'S82233B', 'S82233C', 'S82233D', 'S82233E', 'S82233F', 'S82233G',
        'S82233H', 'S82233J', 'S82233K', 'S82233M', 'S82233N', 'S82233P', 'S82233Q', 'S82233R',
        'S82233S', 'S82234A', 'S82234B', 'S82234C', 'S82234D', 'S82234E', 'S82234F', 'S82234G',
        'S82234H', 'S82234J', 'S82234K', 'S82234M', 'S82234N', 'S82234P', 'S82234Q', 'S82234R',
        'S82234S', 'S82235A', 'S82235B', 'S82235C', 'S82235D', 'S82235E', 'S82235F', 'S82235G',
        'S82235H', 'S82235J', 'S82235K', 'S82235M', 'S82235N', 'S82235P', 'S82235Q', 'S82235R',
        'S82235S', 'S82236A', 'S82236B', 'S82236C', 'S82236D', 'S82236E', 'S82236F', 'S82236G',
        'S82236H', 'S82236J', 'S82236K', 'S82236M', 'S82236N', 'S82236P', 'S82236Q', 'S82236R',
        'S82236S', 'S82241A', 'S82241B', 'S82241C', 'S82241D', 'S82241E', 'S82241F', 'S82241G',
        'S82241H', 'S82241J', 'S82241K', 'S82241M', 'S82241N', 'S82241P', 'S82241Q', 'S82241R',
        'S82241S', 'S82242A', 'S82242B', 'S82242C', 'S82242D', 'S82242E', 'S82242F', 'S82242G',
        'S82242H', 'S82242J', 'S82242K', 'S82242M', 'S82242N', 'S82242P', 'S82242Q', 'S82242R',
        'S82242S', 'S82243A', 'S82243B', 'S82243C', 'S82243D', 'S82243E', 'S82243F', 'S82243G',
        'S82243H', 'S82243J', 'S82243K', 'S82243M', 'S82243N', 'S82243P', 'S82243Q', 'S82243R',
        'S82243S', 'S82244A', 'S82244B', 'S82244C', 'S82244D', 'S82244E', 'S82244F', 'S82244G',
        'S82244H', 'S82244J', 'S82244K', 'S82244M', 'S82244N', 'S82244P', 'S82244Q', 'S82244R',
        'S82244S', 'S82245A', 'S82245B', 'S82245C', 'S82245D', 'S82245E', 'S82245F', 'S82245G',
        'S82245H', 'S82245J', 'S82245K', 'S82245M', 'S82245N', 'S82245P', 'S82245Q', 'S82245R',
        'S82245S', 'S82246A', 'S82246B', 'S82246C', 'S82246D', 'S82246E', 'S82246F', 'S82246G',
        'S82246H', 'S82246J', 'S82246K', 'S82246M', 'S82246N', 'S82246P', 'S82246Q', 'S82246R',
        'S82246S', 'S82251A', 'S82251B', 'S82251C', 'S82251D', 'S82251E', 'S82251F', 'S82251G',
        'S82251H', 'S82251J', 'S82251K', 'S82251M', 'S82251N', 'S82251P', 'S82251Q', 'S82251R',
        'S82251S', 'S82252A', 'S82252B', 'S82252C', 'S82252D', 'S82252E', 'S82252F', 'S82252G',
        'S82252H', 'S82252J', 'S82252K', 'S82252M', 'S82252N', 'S82252P', 'S82252Q', 'S82252R',
        'S82252S', 'S82253A', 'S82253B', 'S82253C', 'S82253D', 'S82253E', 'S82253F', 'S82253G',
        'S82253H', 'S82253J', 'S82253K', 'S82253M', 'S82253N', 'S82253P', 'S82253Q', 'S82253R',
        'S82253S', 'S82254A', 'S82254B', 'S82254C', 'S82254D', 'S82254E', 'S82254F', 'S82254G',
        'S82254H', 'S82254J', 'S82254K', 'S82254M', 'S82254N', 'S82254P', 'S82254Q', 'S82254R',
        'S82254S', 'S82255A', 'S82255B', 'S82255C', 'S82255D', 'S82255E', 'S82255F', 'S82255G',
        'S82255H', 'S82255J', 'S82255K', 'S82255M', 'S82255N', 'S82255P', 'S82255Q', 'S82255R',
        'S82255S', 'S82256A', 'S82256B', 'S82256C', 'S82256D', 'S82256E', 'S82256F', 'S82256G',
        'S82256H', 'S82256J', 'S82256K', 'S82256M', 'S82256N', 'S82256P', 'S82256Q', 'S82256R',
        'S82256S', 'S82261A', 'S82261B', 'S82261C', 'S82261D', 'S82261E', 'S82261F', 'S82261G',
        'S82261H', 'S82261J', 'S82261K', 'S82261M', 'S82261N', 'S82261P', 'S82261Q', 'S82261R',
        'S82261S', 'S82262A', 'S82262B', 'S82262C', 'S82262D', 'S82262E', 'S82262F', 'S82262G',
        'S82262H', 'S82262J', 'S82262K', 'S82262M', 'S82262N', 'S82262P', 'S82262Q', 'S82262R',
        'S82262S', 'S82263A', 'S82263B', 'S82263C', 'S82263D', 'S82263E', 'S82263F', 'S82263G',
        'S82263H', 'S82263J', 'S82263K', 'S82263M', 'S82263N', 'S82263P', 'S82263Q', 'S82263R',
        'S82263S', 'S82264A', 'S82264B', 'S82264C', 'S82264D', 'S82264E', 'S82264F', 'S82264G',
        'S82264H', 'S82264J', 'S82264K', 'S82264M', 'S82264N', 'S82264P', 'S82264Q', 'S82264R',
        'S82264S', 'S82265A', 'S82265B', 'S82265C', 'S82265D', 'S82265E', 'S82265F', 'S82265G',
        'S82265H', 'S82265J', 'S82265K', 'S82265M', 'S82265N', 'S82265P', 'S82265Q', 'S82265R',
        'S82265S', 'S82266A', 'S82266B', 'S82266C', 'S82266D', 'S82266E', 'S82266F', 'S82266G',
        'S82266H', 'S82266J', 'S82266K', 'S82266M', 'S82266N', 'S82266P', 'S82266Q', 'S82266R',
        'S82266S', 'S82291A', 'S82291B', 'S82291C', 'S82291D', 'S82291E', 'S82291F', 'S82291G',
        'S82291H', 'S82291J', 'S82291K', 'S82291M', 'S82291N', 'S82291P', 'S82291Q', 'S82291R',
        'S82291S', 'S82292A', 'S82292B', 'S82292C', 'S82292D', 'S82292E', 'S82292F', 'S82292G',
        'S82292H', 'S82292J', 'S82292K', 'S82292M', 'S82292N', 'S82292P', 'S82292Q', 'S82292R',
        'S82292S', 'S82299A', 'S82299B', 'S82299C', 'S82299D', 'S82299E', 'S82299F', 'S82299G',
        'S82299H', 'S82299J', 'S82299K', 'S82299M', 'S82299N', 'S82299P', 'S82299Q', 'S82299R',
        'S82299S', 'S82301A', 'S82301B', 'S82301C', 'S82301D', 'S82301E', 'S82301F', 'S82301G',
        'S82301H', 'S82301J', 'S82301K', 'S82301M', 'S82301N', 'S82301P', 'S82301Q', 'S82301R',
        'S82301S', 'S82302A', 'S82302B', 'S82302C', 'S82302D', 'S82302E', 'S82302F', 'S82302G',
        'S82302H', 'S82302J', 'S82302K', 'S82302M', 'S82302N', 'S82302P', 'S82302Q', 'S82302R',
        'S82302S', 'S82309A', 'S82309B', 'S82309C', 'S82309D', 'S82309E', 'S82309F', 'S82309G',
        'S82309H', 'S82309J', 'S82309K', 'S82309M', 'S82309N', 'S82309P', 'S82309Q', 'S82309R',
        'S82309S', 'S82311A', 'S82311D', 'S82311G', 'S82311K', 'S82311P', 'S82311S', 'S82312A',
        'S82312D', 'S82312G', 'S82312K', 'S82312P', 'S82312S', 'S82319A', 'S82319D', 'S82319G',
        'S82319K', 'S82319P', 'S82319S', 'S82391A', 'S82391B', 'S82391C', 'S82391D', 'S82391E',
        'S82391F', 'S82391G', 'S82391H', 'S82391J', 'S82391K', 'S82391M', 'S82391N', 'S82391P',
        'S82391Q', 'S82391R', 'S82391S', 'S82392A', 'S82392B', 'S82392C', 'S82392D', 'S82392E',
        'S82392F', 'S82392G', 'S82392H', 'S82392J', 'S82392K', 'S82392M', 'S82392N', 'S82392P',
        'S82392Q', 'S82392R', 'S82392S', 'S82399A', 'S82399B', 'S82399C', 'S82399D', 'S82399E',
        'S82399F', 'S82399G', 'S82399H', 'S82399J', 'S82399K', 'S82399M', 'S82399N', 'S82399P',
        'S82399Q', 'S82399R', 'S82399S', 'S82401A', 'S82401B', 'S82401C', 'S82401D', 'S82401E',
        'S82401F', 'S82401G', 'S82401H', 'S82401J', 'S82401K', 'S82401M', 'S82401N', 'S82401P',
        'S82401Q', 'S82401R', 'S82401S', 'S82402A', 'S82402B', 'S82402C', 'S82402D', 'S82402E',
        'S82402F', 'S82402G', 'S82402H', 'S82402J', 'S82402K', 'S82402M', 'S82402N', 'S82402P',
        'S82402Q', 'S82402R', 'S82402S', 'S82409A', 'S82409B', 'S82409C', 'S82409D', 'S82409E',
        'S82409F', 'S82409G', 'S82409H', 'S82409J', 'S82409K', 'S82409M', 'S82409N', 'S82409P',
        'S82409Q', 'S82409R', 'S82409S', 'S82421A', 'S82421B', 'S82421C', 'S82421D', 'S82421E',
        'S82421F', 'S82421G', 'S82421H', 'S82421J', 'S82421K', 'S82421M', 'S82421N', 'S82421P',
        'S82421Q', 'S82421R', 'S82421S', 'S82422A', 'S82422B', 'S82422C', 'S82422D', 'S82422E',
        'S82422F', 'S82422G', 'S82422H', 'S82422J', 'S82422K', 'S82422M', 'S82422N', 'S82422P',
        'S82422Q', 'S82422R', 'S82422S', 'S82423A', 'S82423B', 'S82423C', 'S82423D', 'S82423E',
        'S82423F', 'S82423G', 'S82423H', 'S82423J', 'S82423K', 'S82423M', 'S82423N', 'S82423P',
        'S82423Q', 'S82423R', 'S82423S', 'S82424A', 'S82424B', 'S82424C', 'S82424D', 'S82424E',
        'S82424F', 'S82424G', 'S82424H', 'S82424J', 'S82424K', 'S82424M', 'S82424N', 'S82424P',
        'S82424Q', 'S82424R', 'S82424S', 'S82425A', 'S82425B', 'S82425C', 'S82425D', 'S82425E',
        'S82425F', 'S82425G', 'S82425H', 'S82425J', 'S82425K', 'S82425M', 'S82425N', 'S82425P',
        'S82425Q', 'S82425R', 'S82425S', 'S82426A', 'S82426B', 'S82426C', 'S82426D', 'S82426E',
        'S82426F', 'S82426G', 'S82426H', 'S82426J', 'S82426K', 'S82426M', 'S82426N', 'S82426P',
        'S82426Q', 'S82426R', 'S82426S', 'S82431A', 'S82431B', 'S82431C', 'S82431D', 'S82431E',
        'S82431F', 'S82431G', 'S82431H', 'S82431J', 'S82431K', 'S82431M', 'S82431N', 'S82431P',
        'S82431Q', 'S82431R', 'S82431S', 'S82432A', 'S82432B', 'S82432C', 'S82432D', 'S82432E',
        'S82432F', 'S82432G', 'S82432H', 'S82432J', 'S82432K', 'S82432M', 'S82432N', 'S82432P',
        'S82432Q', 'S82432R', 'S82432S', 'S82433A', 'S82433B', 'S82433C', 'S82433D', 'S82433E',
        'S82433F', 'S82433G', 'S82433H', 'S82433J', 'S82433K', 'S82433M', 'S82433N', 'S82433P',
        'S82433Q', 'S82433R', 'S82433S', 'S82434A', 'S82434B', 'S82434C', 'S82434D', 'S82434E',
        'S82434F', 'S82434G', 'S82434H', 'S82434J', 'S82434K', 'S82434M', 'S82434N', 'S82434P',
        'S82434Q', 'S82434R', 'S82434S', 'S82435A', 'S82435B', 'S82435C', 'S82435D', 'S82435E',
        'S82435F', 'S82435G', 'S82435H', 'S82435J', 'S82435K', 'S82435M', 'S82435N', 'S82435P',
        'S82435Q', 'S82435R', 'S82435S', 'S82436A', 'S82436B', 'S82436C', 'S82436D', 'S82436E',
        'S82436F', 'S82436G', 'S82436H', 'S82436J', 'S82436K', 'S82436M', 'S82436N', 'S82436P',
        'S82436Q', 'S82436R', 'S82436S', 'S82441A', 'S82441B', 'S82441C', 'S82441D', 'S82441E',
        'S82441F', 'S82441G', 'S82441H', 'S82441J', 'S82441K', 'S82441M', 'S82441N', 'S82441P',
        'S82441Q', 'S82441R', 'S82441S', 'S82442A', 'S82442B', 'S82442C', 'S82442D', 'S82442E',
        'S82442F', 'S82442G', 'S82442H', 'S82442J', 'S82442K', 'S82442M', 'S82442N', 'S82442P',
        'S82442Q', 'S82442R', 'S82442S', 'S82443A', 'S82443B', 'S82443C', 'S82443D', 'S82443E',
        'S82443F', 'S82443G', 'S82443H', 'S82443J', 'S82443K', 'S82443M', 'S82443N', 'S82443P',
        'S82443Q', 'S82443R', 'S82443S', 'S82444A', 'S82444B', 'S82444C', 'S82444D', 'S82444E',
        'S82444F', 'S82444G', 'S82444H', 'S82444J', 'S82444K', 'S82444M', 'S82444N', 'S82444P',
        'S82444Q', 'S82444R', 'S82444S', 'S82445A', 'S82445B', 'S82445C', 'S82445D', 'S82445E',
        'S82445F', 'S82445G', 'S82445H', 'S82445J', 'S82445K', 'S82445M', 'S82445N', 'S82445P',
        'S82445Q', 'S82445R', 'S82445S', 'S82446A', 'S82446B', 'S82446C', 'S82446D', 'S82446E',
        'S82446F', 'S82446G', 'S82446H', 'S82446J', 'S82446K', 'S82446M', 'S82446N', 'S82446P',
        'S82446Q', 'S82446R', 'S82446S', 'S82451A', 'S82451B', 'S82451C', 'S82451D', 'S82451E',
        'S82451F', 'S82451G', 'S82451H', 'S82451J', 'S82451K', 'S82451M', 'S82451N', 'S82451P',
        'S82451Q', 'S82451R', 'S82451S', 'S82452A', 'S82452B', 'S82452C', 'S82452D', 'S82452E',
        'S82452F', 'S82452G', 'S82452H', 'S82452J', 'S82452K', 'S82452M', 'S82452N', 'S82452P',
        'S82452Q', 'S82452R', 'S82452S', 'S82453A', 'S82453B', 'S82453C', 'S82453D', 'S82453E',
        'S82453F', 'S82453G', 'S82453H', 'S82453J', 'S82453K', 'S82453M', 'S82453N', 'S82453P',
        'S82453Q', 'S82453R', 'S82453S', 'S82454A', 'S82454B', 'S82454C', 'S82454D', 'S82454E',
        'S82454F', 'S82454G', 'S82454H', 'S82454J', 'S82454K', 'S82454M', 'S82454N', 'S82454P',
        'S82454Q', 'S82454R', 'S82454S', 'S82455A', 'S82455B', 'S82455C', 'S82455D', 'S82455E',
        'S82455F', 'S82455G', 'S82455H', 'S82455J', 'S82455K', 'S82455M', 'S82455N', 'S82455P',
        'S82455Q', 'S82455R', 'S82455S', 'S82456A', 'S82456B', 'S82456C', 'S82456D', 'S82456E',
        'S82456F', 'S82456G', 'S82456H', 'S82456J', 'S82456K', 'S82456M', 'S82456N', 'S82456P',
        'S82456Q', 'S82456R', 'S82456S', 'S82461A', 'S82461B', 'S82461C', 'S82461D', 'S82461E',
        'S82461F', 'S82461G', 'S82461H', 'S82461J', 'S82461K', 'S82461M', 'S82461N', 'S82461P',
        'S82461Q', 'S82461R', 'S82461S', 'S82462A', 'S82462B', 'S82462C', 'S82462D', 'S82462E',
        'S82462F', 'S82462G', 'S82462H', 'S82462J', 'S82462K', 'S82462M', 'S82462N', 'S82462P',
        'S82462Q', 'S82462R', 'S82462S', 'S82463A', 'S82463B', 'S82463C', 'S82463D', 'S82463E',
        'S82463F', 'S82463G', 'S82463H', 'S82463J', 'S82463K', 'S82463M', 'S82463N', 'S82463P',
        'S82463Q', 'S82463R', 'S82463S', 'S82464A', 'S82464B', 'S82464C', 'S82464D', 'S82464E',
        'S82464F', 'S82464G', 'S82464H', 'S82464J', 'S82464K', 'S82464M', 'S82464N', 'S82464P',
        'S82464Q', 'S82464R', 'S82464S', 'S82465A', 'S82465B', 'S82465C', 'S82465D', 'S82465E',
        'S82465F', 'S82465G', 'S82465H', 'S82465J', 'S82465K', 'S82465M', 'S82465N', 'S82465P',
        'S82465Q', 'S82465R', 'S82465S', 'S82466A', 'S82466B', 'S82466C', 'S82466D', 'S82466E',
        'S82466F', 'S82466G', 'S82466H', 'S82466J', 'S82466K', 'S82466M', 'S82466N', 'S82466P',
        'S82466Q', 'S82466R', 'S82466S', 'S82491A', 'S82491B', 'S82491C', 'S82491D', 'S82491E',
        'S82491F', 'S82491G', 'S82491H', 'S82491J', 'S82491K', 'S82491M', 'S82491N', 'S82491P',
        'S82491Q', 'S82491R', 'S82491S', 'S82492A', 'S82492B', 'S82492C', 'S82492D', 'S82492E',
        'S82492F', 'S82492G', 'S82492H', 'S82492J', 'S82492K', 'S82492M', 'S82492N', 'S82492P',
        'S82492Q', 'S82492R', 'S82492S', 'S82499A', 'S82499B', 'S82499C', 'S82499D', 'S82499E',
        'S82499F', 'S82499G', 'S82499H', 'S82499J', 'S82499K', 'S82499M', 'S82499N', 'S82499P',
        'S82499Q', 'S82499R', 'S82499S', 'S8251XA', 'S8251XB', 'S8251XC', 'S8252XA', 'S8252XB',
        'S8252XC', 'S8253XA', 'S8253XB', 'S8253XC', 'S8254XA', 'S8254XB', 'S8254XC', 'S8255XA',
        'S8255XB', 'S8255XC', 'S8256XA', 'S8256XB', 'S8256XC', 'S8261XA', 'S8261XB', 'S8261XC',
        'S8262XA', 'S8262XB', 'S8262XC', 'S8263XA', 'S8263XB', 'S8263XC', 'S8264XA', 'S8264XB',
        'S8264XC', 'S8265XA', 'S8265XB', 'S8265XC', 'S8266XA', 'S8266XB', 'S8266XC', 'S82811A',
        'S82812A', 'S82819A', 'S82821A', 'S82822A', 'S82829A', 'S82831A', 'S82831B', 'S82831C',
        'S82832A', 'S82832B', 'S82832C', 'S82839A', 'S82839B', 'S82839C', 'S82841A', 'S82841B',
        'S82841C', 'S82842A', 'S82842B', 'S82842C', 'S82843A', 'S82843B', 'S82843C', 'S82844A',
        'S82844B', 'S82844C', 'S82845A', 'S82845B', 'S82845C', 'S82846A', 'S82846B', 'S82846C',
        'S82851A', 'S82851B', 'S82851C', 'S82852A', 'S82852B', 'S82852C', 'S82853A', 'S82853B',
        'S82853C', 'S82854A', 'S82854B', 'S82854C', 'S82855A', 'S82855B', 'S82855C', 'S82856A',
        'S82856B', 'S82856C', 'S82861A', 'S82861B', 'S82861C', 'S82862A', 'S82862B', 'S82862C',
        'S82863A', 'S82863B', 'S82863C', 'S82864A', 'S82864B', 'S82864C', 'S82865A', 'S82865B',
        'S82865C', 'S82866A', 'S82866B', 'S82866C', 'S82871A', 'S82871B', 'S82871C', 'S82872A',
        'S82872B', 'S82872C', 'S82873A', 'S82873B', 'S82873C', 'S82874A', 'S82874B', 'S82874C',
        'S82875A', 'S82875B', 'S82875C', 'S82876A', 'S82876B', 'S82876C', 'S82891A', 'S82891B',
        'S82891C', 'S82892A', 'S82892B', 'S82892C', 'S82899A', 'S82899B', 'S82899C', 'S8290XA',
        'S8290XB', 'S8290XC', 'S8291XA', 'S8291XB', 'S8291XC', 'S8292XA', 'S8292XB', 'S8292XC',
        'S89001A', 'S89002A', 'S89009A', 'S89011A', 'S89012A', 'S89019A', 'S89021A', 'S89022A',
        'S89029A', 'S89031A', 'S89032A', 'S89039A', 'S89041A', 'S89042A', 'S89049A', 'S89091A',
        'S89092A', 'S89099A', 'S89101A', 'S89102A', 'S89109A', 'S89111A', 'S89112A', 'S89119A',
        'S89121A', 'S89122A', 'S89129A', 'S89131A', 'S89132A', 'S89139A', 'S89141A', 'S89142A',
        'S89149A', 'S89191A', 'S89192A', 'S89199A', 'S89201A', 'S89202A', 'S89209A', 'S89211A',
        'S89212A', 'S89219A', 'S89221A', 'S89222A', 'S89229A', 'S89291A', 'S89292A', 'S89299A',
        'S89301A', 'S89302A', 'S89309A', 'S89311A', 'S89312A', 'S89319A', 'S89321A', 'S89322A',
        'S89329A', 'S89391A', 'S89392A', 'S89399A', 'S92001A', 'S92001B', 'S92002A', 'S92002B',
        'S92009A', 'S92009B', 'S92011A', 'S92011B', 'S92012A', 'S92012B', 'S92013A', 'S92013B',
        'S92014A', 'S92014B', 'S92015A', 'S92015B', 'S92016A', 'S92016B', 'S92021A', 'S92021B',
        'S92022A', 'S92022B', 'S92023A', 'S92023B', 'S92024A', 'S92024B', 'S92025A', 'S92025B',
        'S92026A', 'S92026B', 'S92031A', 'S92031B', 'S92032A', 'S92032B', 'S92033A', 'S92033B',
        'S92034A', 'S92034B', 'S92035A', 'S92035B', 'S92036A', 'S92036B', 'S92041A', 'S92041B',
        'S92042A', 'S92042B', 'S92043A', 'S92043B', 'S92044A', 'S92044B', 'S92045A', 'S92045B',
        'S92046A', 'S92046B', 'S92051A', 'S92051B', 'S92052A', 'S92052B', 'S92053A', 'S92053B',
        'S92054A', 'S92054B', 'S92055A', 'S92055B', 'S92056A', 'S92056B', 'S92061A', 'S92061B',
        'S92062A', 'S92062B', 'S92063A', 'S92063B', 'S92064A', 'S92064B', 'S92065A', 'S92065B',
        'S92066A', 'S92066B', 'S92101A', 'S92101B', 'S92102A', 'S92102B', 'S92109A', 'S92109B',
        'S92111A', 'S92111B', 'S92112A', 'S92112B', 'S92113A', 'S92113B', 'S92114A', 'S92114B',
        'S92115A', 'S92115B', 'S92116A', 'S92116B', 'S92121A', 'S92121B', 'S92122A', 'S92122B',
        'S92123A', 'S92123B', 'S92124A', 'S92124B', 'S92125A', 'S92125B', 'S92126A', 'S92126B',
        'S92131A', 'S92131B', 'S92132A', 'S92132B', 'S92133A', 'S92133B', 'S92134A', 'S92134B',
        'S92135A', 'S92135B', 'S92136A', 'S92136B', 'S92141A', 'S92141B', 'S92142A', 'S92142B',
        'S92143A', 'S92143B', 'S92144A', 'S92144B', 'S92145A', 'S92145B', 'S92146A', 'S92146B',
        'S92151A', 'S92151B', 'S92152A', 'S92152B', 'S92153A', 'S92153B', 'S92154A', 'S92154B',
        'S92155A', 'S92155B', 'S92156A', 'S92156B', 'S92191A', 'S92191B', 'S92192A', 'S92192B',
        'S92199A', 'S92199B', 'S92201A', 'S92201B', 'S92202A', 'S92202B', 'S92209A', 'S92209B',
        'S92211A', 'S92211B', 'S92212A', 'S92212B', 'S92213A', 'S92213B', 'S92214A', 'S92214B',
        'S92215A', 'S92215B', 'S92216A', 'S92216B', 'S92221A', 'S92221B', 'S92222A', 'S92222B',
        'S92223A', 'S92223B', 'S92224A', 'S92224B', 'S92225A', 'S92225B', 'S92226A', 'S92226B',
        'S92231A', 'S92231B', 'S92232A', 'S92232B', 'S92233A', 'S92233B', 'S92234A', 'S92234B',
        'S92235A', 'S92235B', 'S92236A', 'S92236B', 'S92241A', 'S92241B', 'S92242A', 'S92242B',
        'S92243A', 'S92243B', 'S92244A', 'S92244B', 'S92245A', 'S92245B', 'S92246A', 'S92246B',
        'S92251A', 'S92251B', 'S92252A', 'S92252B', 'S92253A', 'S92253B', 'S92254A', 'S92254B',
        'S92255A', 'S92255B', 'S92256A', 'S92256B', 'S92301A', 'S92301B', 'S92302A', 'S92302B',
        'S92309A', 'S92309B', 'S92311A', 'S92311B', 'S92312A', 'S92312B', 'S92313A', 'S92313B',
        'S92314A', 'S92314B', 'S92315A', 'S92315B', 'S92316A', 'S92316B', 'S92321A', 'S92321B',
        'S92322A', 'S92322B', 'S92323A', 'S92323B', 'S92324A', 'S92324B', 'S92325A', 'S92325B',
        'S92326A', 'S92326B', 'S92331A', 'S92331B', 'S92332A', 'S92332B', 'S92333A', 'S92333B',
        'S92334A', 'S92334B', 'S92335A', 'S92335B', 'S92336A', 'S92336B', 'S92341A', 'S92341B',
        'S92342A', 'S92342B', 'S92343A', 'S92343B', 'S92344A', 'S92344B', 'S92345A', 'S92345B',
        'S92346A', 'S92346B', 'S92351A', 'S92351B', 'S92352A', 'S92352B', 'S92353A', 'S92353B',
        'S92354A', 'S92354B', 'S92355A', 'S92355B', 'S92356A', 'S92356B', 'S92901A', 'S92901B',
        'S92902A', 'S92902B', 'S92909A', 'S92909B', 'S99001A', 'S99001B', 'S99001D', 'S99001G',
        'S99001K', 'S99001P', 'S99001S', 'S99002A', 'S99002B', 'S99002D', 'S99002G', 'S99002K',
        'S99002P', 'S99002S', 'S99009A', 'S99009B', 'S99009D', 'S99009G', 'S99009K', 'S99009P',
        'S99009S', 'S99011A', 'S99011B', 'S99011D', 'S99011G', 'S99011K', 'S99011P', 'S99011S',
        'S99012A', 'S99012B', 'S99012D', 'S99012G', 'S99012K', 'S99012P', 'S99012S', 'S99019A',
        'S99019B', 'S99019D', 'S99019G', 'S99019K', 'S99019P', 'S99019S', 'S99021A', 'S99021B',
        'S99021D', 'S99021G', 'S99021K', 'S99021P', 'S99021S', 'S99022A', 'S99022B', 'S99022D',
        'S99022G', 'S99022K', 'S99022P', 'S99022S', 'S99029A', 'S99029B', 'S99029D', 'S99029G',
        'S99029K', 'S99029P', 'S99029S', 'S99031A', 'S99031B', 'S99031D', 'S99031G', 'S99031K',
        'S99031P', 'S99031S', 'S99032A', 'S99032B', 'S99032D', 'S99032G', 'S99032K', 'S99032P',
        'S99032S', 'S99039A', 'S99039B', 'S99039D', 'S99039G', 'S99039K', 'S99039P', 'S99039S',
        'S99041A', 'S99041B', 'S99041D', 'S99041G', 'S99041K', 'S99041P', 'S99041S', 'S99042A',
        'S99042B', 'S99042D', 'S99042G', 'S99042K', 'S99042P', 'S99042S', 'S99049A', 'S99049B',
        'S99049D', 'S99049G', 'S99049K', 'S99049P', 'S99049S', 'S99091A', 'S99091B', 'S99091D',
        'S99091G', 'S99091K', 'S99091P', 'S99091S', 'S99092A', 'S99092B', 'S99092D', 'S99092G',
        'S99092K', 'S99092P', 'S99092S', 'S99099A', 'S99099B', 'S99099D', 'S99099G', 'S99099K',
        'S99099P', 'S99099S', 'S99101A', 'S99101B', 'S99101D', 'S99101G', 'S99101K', 'S99101P',
        'S99101S', 'S99102A', 'S99102B', 'S99102D', 'S99102G', 'S99102K', 'S99102P', 'S99102S',
        'S99109A', 'S99109B', 'S99109D', 'S99109G', 'S99109K', 'S99109P', 'S99109S', 'S99111A',
        'S99111B', 'S99111D', 'S99111G', 'S99111K', 'S99111P', 'S99111S', 'S99112A', 'S99112B',
        'S99112D', 'S99112G', 'S99112K', 'S99112P', 'S99112S', 'S99119A', 'S99119B', 'S99119D',
        'S99119G', 'S99119K', 'S99119P', 'S99119S', 'S99121A', 'S99121B', 'S99121D', 'S99121G',
        'S99121K', 'S99121P', 'S99121S', 'S99122A', 'S99122B', 'S99122D', 'S99122G', 'S99122K',
        'S99122P', 'S99122S', 'S99129A', 'S99129B', 'S99129D', 'S99129G', 'S99129K', 'S99129P',
        'S99129S', 'S99131A', 'S99131B', 'S99131D', 'S99131G', 'S99131K', 'S99131P', 'S99131S',
        'S99132A', 'S99132B', 'S99132D', 'S99132G', 'S99132K', 'S99132P', 'S99132S', 'S99139A',
        'S99139B', 'S99139D', 'S99139G', 'S99139K', 'S99139P', 'S99139S', 'S99141A', 'S99141B',
        'S99141D', 'S99141G', 'S99141K', 'S99141P', 'S99141S', 'S99142A', 'S99142B', 'S99142D',
        'S99142G', 'S99142K', 'S99142P', 'S99142S', 'S99149A', 'S99149B', 'S99149D', 'S99149G',
        'S99149K', 'S99149P', 'S99149S', 'S99191A', 'S99191B', 'S99191D', 'S99191G', 'S99191K',
        'S99191P', 'S99191S', 'S99192A', 'S99192B', 'S99192D', 'S99192G', 'S99192K', 'S99192P',
        'S99192S', 'S99199A', 'S99199B', 'S99199D', 'S99199G', 'S99199K', 'S99199P', 'S99199S'
    }

    SNOMEDCT = {
        '111643005', '111644004', '111645003', '111646002', '127287001', '12746007', '13695006',
        '15474008', '1705000', '17616007', '19652000', '20100009', '208146001', '208147005',
        '208148000', '208149008', '208150008', '208151007', '208155003', '208156002', '208157006',
        '208158001', '208159009', '208160004', '208164008', '208165009', '208166005', '208168006',
        '208172005', '208173000', '208174006', '208181004', '208182006', '208183001', '208184007',
        '208185008', '208192003', '208193008', '208194002', '208195001', '208197009', '208202002',
        '208204001', '208205000', '208207008', '208521006', '208523009', '208524003', '208526001',
        '208528000', '208529008', '208530003', '208531004', '208536009', '208537000', '208540000',
        '208541001', '208542008', '208543003', '208544009', '208548007', '208550004', '208551000',
        '208552007', '208555009', '208557001', '208558006', '208559003', '208562000', '208578003',
        '208579006', '208580009', '208581008', '208582001', '208587007', '208588002', '208589005',
        '208590001', '208591002', '208596007', '208597003', '208598008', '208600002', '208601003',
        '208602005', '208603000', '208604006', '208605007', '208606008', '208610006', '208611005',
        '208612003', '208613008', '208614002', '208615001', '208619007', '208620001', '208621002',
        '208622009', '208623004', '208624005', '208625006', '208627003', '208629000', '208631009',
        '208632002', '208637008', '208731002', '209335002', '209336001', '209337005', '209338000',
        '209344001', '209345000', '209346004', '209347008', '209390009', '209395004', '209405008',
        '22234005', '22802006', '23900009', '25415003', '263067005', '263096006', '263216001',
        '263220002', '263221003', '263222005', '263225007', '263226008', '263227004', '263228009',
        '263229001', '263231005', '263232003', '263233008', '263234002', '263235001', '263236000',
        '263237009', '263238004', '263239007', '26442006', '26938002', '271963003', '275338001',
        '275339009', '275340006', '275341005', '275342003', '275343008', '28012007', '281533006',
        '28359007', '28576007', '30060003', '301034006', '301757009', '302034009', '30489009',
        '307178006', '307727005', '308153009', '30905007', '33118001', '359817006', '359820003',
        '361118003', '361119006', '36127009', '36417005', '39408006', '41191003', '413876003',
        '413877007', '414942001', '414943006', '426382004', '426679004', '426962008', '427509002',
        '427584009', '427688003', '427826000', '428020005', '428232002', '428257007', '428357005',
        '428512002', '428723000', '428797006', '428798001', '429342005', '429766001', '445311003',
        '445410003', '445733003', '445875009', '445899009', '446979005', '446980008', '447017008',
        '447139008', '447394009', '447395005', '45455009', '46272008', '47848000', '51037009',
        '52450003', '54441004', '5913000', '59556008', '59639009', '59962009', '60214001',
        '62125005', '64455005', '6628008', '66483005', '66926007', '69830008', '71220005',
        '71620000', '7687006', '76911006', '77598002', '77803008', '79484004', '79978005',
        '80756009', '82640004', '84320000', '86731008', '87173003', '89820008', '91037003',
        '9344009'
    }


class BilateralAmputationOfLegBelowOrAboveKnee(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1056'
    VALUE_SET_NAME = 'Bilateral amputation of leg below or above knee'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'Q7203', 'Q7223'}

    ICD9CM = {'8976', '8977'}


class RightUnilateralAmputationAboveOrBelowKnee(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1057'
    VALUE_SET_NAME = 'Right Unilateral Amputation Above or Below Knee'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'Q7221', 'S78011A', 'S78011D', 'S78111A', 'S78111D', 'S88011A', 'S88011D', 'S88111A',
        'S88111D', 'S88111S', 'S88911S', 'Z89511', 'Z89521', 'Z89611', 'Z89621'
    }

    SNOMEDCT = {'308095002', '308097005'}


class LeftUnilateralAmputationAboveOrBelowKnee(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1058'
    VALUE_SET_NAME = 'Left Unilateral Amputation Above or Below Knee'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'Q7222', 'S78012A', 'S78012D', 'S78112A', 'S78112D', 'S88012A', 'S88012D', 'S88112A',
        'S88112D', 'S88112S', 'S88912S', 'Z89512', 'Z89522', 'Z89612', 'Z89622'
    }

    SNOMEDCT = {'308096001', '308098000'}


class UnilateralAmputationBelowOrAboveKneeUnspecifiedLaterality(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1059'
    VALUE_SET_NAME = 'Unilateral Amputation Below or Above Knee, Unspecified Laterality'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'Q7220'}

    ICD9CM = {'8970', '8971', '8972', '8973', 'V4975', 'V4976', 'V4977'}

    SNOMEDCT = {
        '110470001', '11228000', '12663001', '265735000', '265736004', '298049006', '298050006',
        '38162008', '397163000', '397164006', '397166008', '397167004', '397168009', '397169001',
        '443025009', '6661001', '76017008', '79733001', '83574003', '87562003', '88312006'
    }


class SpinalInfection(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.113.12.1063'
    VALUE_SET_NAME = 'Spinal Infection'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'A1781', 'G061', 'M4625', 'M4626', 'M4627', 'M4628', 'M4635', 'M4636', 'M4637', 'M4638',
        'M4646', 'M4647', 'M4648'
    }

    SNOMEDCT = {
        '13386009', '1427008', '14405000', '15202009', '192737006', '202744000', '202748002',
        '202752002', '202756004', '203157008', '203158003', '203159006', '203193005', '203194004',
        '203195003', '203217000', '203218005', '203219002', '203241002', '203296008', '203297004',
        '203298009', '213124002', '230216007', '2304001', '281371002', '302935008', '35786001',
        '416265003', '416903004', '422829002', '423064000', '424463006', '430399004', '444760002',
        '445063003', '473429002', '63627007'
    }


class EncephalopathyDueToChildhoodVaccination(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.114.12.1007'
    VALUE_SET_NAME = 'Encephalopathy due to Childhood Vaccination'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'G0432'}

    SNOMEDCT = {
        '192704009', '192710009', '192711008', '192712001', '192717007', '192718002', '192719005',
        '192720004', '192721000', '192722007', '192723002', '192724008', '31367003'
    }


class Narcolepsy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.114.12.1011'
    VALUE_SET_NAME = 'Narcolepsy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'G47411', 'G47419', 'G47421', 'G47429'}

    ICD9CM = {'34700', '34701', '34710', '34711'}

    SNOMEDCT = {
        '193042000', '434241000124107', '434251000124109', '434261000124106', '60380001',
        '91521000119104'
    }


class NeurologicImpairment(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.114.12.1012'
    VALUE_SET_NAME = 'Neurologic impairment'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'G834'}

    ICD9CM = {'34460'}

    SNOMEDCT = {'192970008', '192971007', '8663007'}


class RetinalOrDilatedEyeExam(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.115.12.1088'
    VALUE_SET_NAME = 'Retinal or Dilated Eye Exam'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '252779009', '252780007', '252781006', '252782004', '252783009', '252784003', '252788000',
        '252789008', '252790004', '274795007', '274798009', '308110009', '314971001', '314972008',
        '410451008', '410452001', '410453006', '410455004', '420213007', '425816006', '427478009',
        '6615001'
    }


class PatientNotAmbulatory(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1009'
    VALUE_SET_NAME = 'Patient not ambulatory'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '160684002', '160685001', '165243005', '165244004', '225612007', '282145008', '282147000',
        '282204009', '282206006', '413121008'
    }


class FallsScreening(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1028'
    VALUE_SET_NAME = 'Falls Screening'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'52552-7', '57254-5', '73830-2'}

    SNOMEDCT = {
        '401196007', '408422004', '408423009', '408589008', '414191008', '426938003', '427206005',
        '443731004', '445990009', '711054005'
    }


class FunctionalStatusAssessmentForHipReplacement(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1029'
    VALUE_SET_NAME = 'Functional Status Assessment  for Hip Replacement'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '71969-0', '71970-8', '71971-6', '71972-4', '72009-4', '72010-2', '72011-0', '72012-8',
        '72013-6', '72014-4', '72015-1', '72016-9', '72017-7', '72018-5', '72019-3', '72020-1',
        '72021-9', '72022-7', '72023-5', '72024-3', '72025-0', '72026-8', '72027-6', '72028-4',
        '72093-8', '72094-6', '72095-3', '72096-1', '72097-9'
    }


class FunctionalStatusAssessmentForKneeReplacement(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1030'
    VALUE_SET_NAME = 'Functional Status Assessment for Knee Replacement'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '71969-0', '71970-8', '71971-6', '71972-4', '72009-4', '72010-2', '72011-0', '72012-8',
        '72013-6', '72014-4', '72015-1', '72016-9', '72017-7', '72018-5', '72019-3', '72020-1',
        '72021-9', '72022-7', '72023-5', '72024-3', '72025-0', '72026-8', '72027-6', '72028-4',
        '72098-7', '72099-5', '72100-1', '72101-9', '72102-7'
    }


class FunctionalStatusAssessmentForHeartFailure(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1031'
    VALUE_SET_NAME = 'Functional Status Assessment for Heart Failure'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '71938-5', '71940-1', '71955-9', '71956-7', '71957-5', '71958-3', '71959-1', '71960-9',
        '71961-7', '71962-5', '71963-3', '71964-1', '71965-8', '71966-6', '71967-4', '71968-2',
        '71969-0', '71970-8', '71971-6', '71972-4', '71973-2', '71974-0', '71975-7', '71976-5',
        '71977-3', '71978-1', '71979-9', '71980-7', '71981-5', '71982-3', '71983-1', '71984-9',
        '71985-6', '71986-4', '71987-2', '71988-0', '71989-8', '71990-6', '71991-4', '71992-2',
        '71993-0', '71994-8', '71995-5', '71996-3', '71997-1', '71998-9', '71999-7', '72000-3',
        '72001-1', '72002-9', '72003-7', '72004-5', '72005-2', '72006-0', '72007-8', '72008-6',
        '72009-4', '72010-2', '72011-0', '72012-8', '72013-6', '72014-4', '72015-1', '72016-9',
        '72017-7', '72018-5', '72019-3', '72020-1', '72021-9', '72022-7', '72023-5', '72024-3',
        '72025-0', '72026-8', '72027-6', '72028-4', '72188-6', '72189-4', '72190-2', '72191-0',
        '72192-8', '72193-6', '72194-4', '72195-1', '72196-9'
    }


class CounselingForPhysicalActivity(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1035'
    VALUE_SET_NAME = 'Counseling for Physical Activity'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '103736005', '183075005', '223415003', '223440005', '281090004', '304507003', '304517008',
        '304549008', '304558001', '310882002', '386291006', '386292004', '386463000', '390864007',
        '390893007', '398636004', '398752005', '408289007', '410200000', '410289001', '410335001',
        '426866005', '429095004'
    }


class PhysicalTherapy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.118.12.1039'
    VALUE_SET_NAME = 'Physical Therapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'306166004', '306167008', '390864007', '416790000', '444911000124101'}


class DisordersOfTheImmuneSystem(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.120.12.1001'
    VALUE_SET_NAME = 'Disorders of the Immune System'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'D800', 'D801', 'D802', 'D803', 'D804', 'D805', 'D806', 'D807', 'D808', 'D809', 'D810',
        'D811', 'D812', 'D814', 'D816', 'D817', 'D8189', 'D819', 'D820', 'D821', 'D822', 'D823',
        'D824', 'D828', 'D829', 'D830', 'D831', 'D832', 'D838', 'D839', 'D840', 'D841', 'D848',
        'D849', 'D893', 'D89810', 'D89811', 'D89812', 'D89813', 'D8982', 'D8989', 'D899'
    }

    SNOMEDCT = {
        '103077004', '103078009', '103079001', '103080003', '103081004', '105601003', '105602005',
        '111396008', '111584000', '111585004', '111587007', '116133005', '12631000119106',
        '127067009', '129639005', '129641006', '129642004', '129643009', '14333004', '17182001',
        '18827005', '190979003', '190980000', '190981001', '190993005', '190995003', '190996002',
        '190997006', '190998001', '191001007', '191002000', '191008001', '191018006', '191338000',
        '191345000', '191347008', '203592006', '21527007', '22406001', '23238000', '234416002',
        '234423001', '234424007', '234425008', '234426009', '234433009', '234436001', '234437005',
        '234532001', '234533006', '234534000', '234539005', '234540007', '234541006', '234542004',
        '234543009', '234544003', '234546001', '234547005', '234548000', '234549008', '234550008',
        '234551007', '234552000', '234553005', '234554004', '234555003', '234556002', '234557006',
        '234558001', '234559009', '234560004', '234561000', '234562007', '234563002', '234564008',
        '234565009', '234566005', '234570002', '234571003', '234572005', '234573000', '234574006',
        '234576008', '234577004', '234578009', '234579001', '234580003', '234581004', '234582006',
        '234583001', '234584007', '234585008', '234586009', '234587000', '234588005', '234589002',
        '234590006', '234591005', '234593008', '234594002', '234595001', '234596000', '234597009',
        '234598004', '234599007', '234600005', '234601009', '234602002', '234603007', '234604001',
        '234605000', '234607008', '234608003', '234609006', '234611002', '234612009', '234613004',
        '234614005', '234615006', '234616007', '234617003', '234618008', '234619000', '234620006',
        '234621005', '234622003', '234623008', '234624002', '234625001', '234626000', '234627009',
        '234628004', '234629007', '234630002', '234631003', '234632005', '234633000', '234634006',
        '234635007', '234636008', '234637004', '234638009', '234639001', '234640004', '234641000',
        '234642007', '234643002', '234645009', '24181002', '241955009', '24419001', '24743004',
        '247860002', '248693006', '24974008', '25109007', '26252007', '263661007', '267538002',
        '267540007', '267543009', '276628009', '29260007', '29272001', '302874002', '303011007',
        '31323000', '32092008', '33286000', '3439009', '350353007', '351287008', '359791000',
        '36070007', '36138009', '362993009', '363009005', '363040003', '36980009', '37548006',
        '387759001', '3902000', '39674000', '398250003', '40197009', '402483002', '402791005',
        '402792003', '403837005', '409089005', '414850009', '416729007', '417167007', '41814009',
        '421312009', '425229001', '442459007', '4434006', '44940001', '45390000', '45841007',
        '46359005', '47144000', '47318007', '48119005', '49555001', '50926003', '55444004',
        '55602000', '56918001', '58034007', '58606001', '60743005', '62479008', '63484008',
        '65623009', '65880007', '66876008', '68504005', '70349007', '713530002', '71436005',
        '715982006', '71610005', '716378008', '716871006', '718107000', '718230004', '718232007',
        '71904008', '72050006', '76243000', '77070006', '77121009', '77330006', '77358003',
        '78378009', '7990002', '80369006', '81166004', '82286005', '82317007', '82966003',
        '88714009', '89454001', '89655007', '9893005'
    }


class Hiv(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.120.12.1003'
    VALUE_SET_NAME = 'HIV'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'B20', 'B9735', 'Z21'}

    ICD9CM = {'042', '07953', 'V08'}

    SNOMEDCT = {
        '111880001', '186706006', '186707002', '186708007', '186709004', '186717007', '186718002',
        '186719005', '186721000', '186723002', '186725009', '186726005', '230180003', '230201009',
        '230598008', '235009000', '235726002', '240103002', '276666007', '315019000', '359791000',
        '397763006', '398329009', '402915006', '402916007', '405631006', '40780007', '48794007',
        '52079000', '5810003', '62246005', '62479008', '713260006', '713275003', '713278001',
        '713297001', '713298006', '713299003', '713300006', '713316008', '713318009', '713320007',
        '713325002', '713339002', '713340000', '713341001', '713342008', '713349004', '713444005',
        '713445006', '713446007', '713483007', '713484001', '713487008', '713488003', '713489006',
        '713490002', '713491003', '713497004', '713503007', '713504001', '713505000', '713506004',
        '713507008', '713508003', '713510001', '713511002', '713523008', '713526000', '713527009',
        '713530002', '713531003', '713532005', '713533000', '713543002', '713544008', '713545009',
        '713546005', '713570009', '713571008', '713572001', '713695001', '713696000', '713718006',
        '713722001', '713729005', '713730000', '713731001', '713732008', '713733003', '713734009',
        '713844000', '713845004', '713880000', '713881001', '713887002', '713897006', '713964006',
        '713967004', '714083007', '714464009', '72621000119104', '77070006', '79019005',
        '86406008', '87117006', '91947003', '91948008'
    }


class Hiv1(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.120.12.1004'
    VALUE_SET_NAME = 'HIV 1'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'B20', 'Z21'}

    ICD9CM = {'042', 'V08'}

    SNOMEDCT = {
        '111880001', '186706006', '186707002', '186708007', '186709004', '186717007', '186718002',
        '186719005', '186721000', '186723002', '186725009', '186726005', '230180003', '230201009',
        '230598008', '235009000', '235726002', '240103002', '276666007', '315019000', '359791000',
        '397763006', '398329009', '402915006', '402916007', '405631006', '40780007', '48794007',
        '52079000', '5810003', '62246005', '62479008', '713260006', '713275003', '713278001',
        '713297001', '713298006', '713299003', '713300006', '713316008', '713318009', '713320007',
        '713325002', '713339002', '713340000', '713341001', '713342008', '713349004', '713444005',
        '713445006', '713446007', '713483007', '713484001', '713487008', '713488003', '713489006',
        '713490002', '713491003', '713497004', '713503007', '713504001', '713505000', '713506004',
        '713507008', '713508003', '713510001', '713511002', '713523008', '713526000', '713527009',
        '713530002', '713531003', '713532005', '713533000', '713543002', '713544008', '713545009',
        '713546005', '713570009', '713571008', '713572001', '713695001', '713696000', '713718006',
        '713722001', '713729005', '713730000', '713731001', '713732008', '713733003', '713734009',
        '713844000', '713845004', '713880000', '713881001', '713887002', '713897006', '713964006',
        '713967004', '714083007', '714464009', '77070006', '79019005', '86406008', '87117006',
        '91947003', '91948008'
    }


class SevereCombinedImmunodeficiency(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.120.12.1007'
    VALUE_SET_NAME = 'Severe Combined Immunodeficiency'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'D810', 'D811', 'D812', 'D819'}

    SNOMEDCT = {
        '111584000', '111587007', '190993005', '190996002', '190997006', '190998001', '191001007',
        '191002000', '203592006', '22406001', '234570002', '234571003', '31323000', '3439009',
        '350353007', '351287008', '362993009', '36980009', '44940001', '45390000', '49555001',
        '55602000', '715982006', '716378008', '716871006', '718107000', '71904008'
    }


class Cd4Count(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1004'
    VALUE_SET_NAME = 'CD4+ Count'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'24467-3', '32515-9', '32532-4', '40898-9', '63450-1'}


class Cd4Percentage(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1005'
    VALUE_SET_NAME = 'CD4+ Percentage'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'17822-8', '32516-7', '32533-2', '40623-1', '43970-3', '51300-2', '8123-2'}


class ConsultantReport(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1006'
    VALUE_SET_NAME = 'Consultant Report'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'371530004', '371531000', '371545006'}


class BmiPercentile(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1012'
    VALUE_SET_NAME = 'BMI percentile'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'59574-4', '59575-1', '59576-9'}


class DeltaSystolicBloodPressure(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1013'
    VALUE_SET_NAME = 'Delta systolic blood pressure'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'71789-2'}


class Height(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1014'
    VALUE_SET_NAME = 'Height'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'3137-7', '3138-5', '8302-2', '8306-3', '8307-1', '8308-9'}


class Weight(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1015'
    VALUE_SET_NAME = 'Weight'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'18833-4', '29463-7', '3141-9', '3142-7', '8341-0', '8349-3', '8350-1', '8351-9'}


class PositiveFinding(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1016'
    VALUE_SET_NAME = 'Positive Finding'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'441773004'}


class SexuallyActive(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.121.12.1040'
    VALUE_SET_NAME = 'Sexually Active'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'64728-9'}


class Ambulatory(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.122.12.1003'
    VALUE_SET_NAME = 'Ambulatory'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'255327002', '440655000'}


class Right(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.122.12.1035'
    VALUE_SET_NAME = 'Right'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'24028007', '419465000'}


class Left(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.122.12.1036'
    VALUE_SET_NAME = 'Left'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'419161000', '7771000'}


class YesResponse(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.122.12.1050'
    VALUE_SET_NAME = 'Yes Response'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'373066001'}


class FluorideVarnishApplicationForChildren(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.125.12.1002'
    VALUE_SET_NAME = 'Fluoride Varnish Application for Children'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CDT = {'D1206', 'D1208'}

    CPT = {'99188'}

    SNOMEDCT = {'234723000', '313042009', '35889000', '70468009'}


class ClinicalOralEvaluation(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.125.12.1003'
    VALUE_SET_NAME = 'Clinical Oral Evaluation'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CDT = {'D0120', 'D0140', 'D0145', 'D0150', 'D0160', 'D0170', 'D0180'}


class DentalCaries(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.125.12.1004'
    VALUE_SET_NAME = 'Dental Caries'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'K023', 'K0251', 'K0252', 'K0253', 'K0261', 'K0262', 'K0263', 'K027', 'K029'}

    ICD9CM = {
        '52100', '52101', '52102', '52103', '52104', '52105', '52106', '52107', '52108', '52109'
    }

    SNOMEDCT = {
        '109564008', '109566005', '109568006', '109569003', '109571003', '109572005', '109573000',
        '109574006', '109575007', '109576008', '109577004', '109578009', '109580003', '109581004',
        '15733007', '163152009', '196298000', '196299008', '196301001', '196302008', '196305005',
        '234976000', '30512007', '442231009', '442551007', '699489009', '699490000', '699491001',
        '699492008', '699494009', '699495005', '700046006', '702402003', '80353004', '80753001',
        '80967001', '95246007', '95247003', '95248008', '95249000', '95252008', '95253003',
        '95254009'
    }


class NegativeFinding(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.195.12.1002'
    VALUE_SET_NAME = 'Negative Finding'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'442225006'}


class CounselingForNutrition(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.195.12.1003'
    VALUE_SET_NAME = 'Counseling for Nutrition'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'97802', '97803', '97804'}

    SNOMEDCT = {
        '103699006', '11816003', '183059007', '183060002', '183061003', '183062005', '183063000',
        '183065007', '183066008', '183067004', '183068009', '183069001', '183070000', '183071001',
        '229807004', '229808009', '230089004', '266724001', '284352003', '285390004', '285392007',
        '306163007', '306164001', '306165000', '306353006', '306354000', '313076000', '361232005',
        '370847001', '386264009', '386464006', '386469001', '398752005', '400973003', '408289007',
        '408430003', '410200000', '410270001', '410293007', '410402005', '419155003', '424753004',
        '429095004', '443288003', '61310001'
    }


class AntibioticMedicationsForPharyngitis(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1001'
    VALUE_SET_NAME = 'Antibiotic Medications for Pharyngitis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1013659', '1013662', '1013665', '1043022', '1043027', '1043030', '105171', '108449',
        '1088677', '1148107', '1302650', '1302659', '1302664', '1302669', '1302674', '1373014',
        '141962', '141963', '142118', '1423080', '1649401', '1649405', '1649425', '1649429',
        '1649988', '1649990', '1650030', '1650142', '1650143', '1650444', '1650446', '1652673',
        '1652674', '1653433', '1659592', '1659598', '1665005', '1665021', '1665046', '1665050',
        '1665052', '1665060', '1665210', '1665212', '1665227', '1665229', '1665444', '1665449',
        '1665497', '1665507', '1665515', '1665517', '1665519', '1668238', '1668264', '1721473',
        '1721474', '1721475', '1721476', '1737244', '1737578', '1737581', '1791505', '1801138',
        '1801142', '197449', '197451', '197452', '197453', '197454', '197511', '197512', '197516',
        '197517', '197518', '197595', '197596', '197650', '197984', '197985', '198048', '198049',
        '198050', '198250', '198252', '198332', '198334', '198335', '199332', '199370', '199884',
        '199885', '200346', '204466', '204844', '205964', '207362', '207364', '207390', '207391',
        '226633', '239191', '240741', '240984', '245240', '245242', '246282', '248656', '283535',
        '284215', '308177', '308181', '308182', '308188', '308189', '308191', '308192', '308194',
        '308207', '308210', '308212', '308459', '308460', '309040', '309042', '309043', '309044',
        '309045', '309047', '309048', '309049', '309054', '309058', '309076', '309077', '309078',
        '309079', '309080', '309081', '309085', '309086', '309087', '309090', '309092', '309095',
        '309096', '309097', '309098', '309101', '309110', '309112', '309113', '309114', '309115',
        '309308', '309309', '309310', '309322', '309329', '309335', '309336', '309339', '309860',
        '310026', '310027', '310028', '310154', '310155', '310157', '311296', '311787', '313134',
        '313137', '313797', '313799', '313800', '313850', '313888', '313920', '313926', '314108',
        '315090', '317127', '348869', '348870', '351121', '351127', '351156', '359383', '359385',
        '403840', '403921', '403945', '406524', '406696', '409823', '419849', '434018', '476322',
        '476325', '476327', '476576', '476623', '477391', '487129', '562251', '562253', '562266',
        '562508', '562707', '577378', '597455', '598006', '598025', '617296', '617302', '617304',
        '617309', '617316', '617322', '617423', '617430', '617993', '617995', '629695', '629697',
        '629699', '637173', '645617', '686355', '686383', '686400', '686405', '686406', '686418',
        '700408', '728207', '731538', '731564', '731567', '731570', '745302', '745462', '745560',
        '749780', '749783', '757460', '757464', '757466', '761979', '789980', '799048', '802550',
        '834040', '834046', '834061', '834102', '835341', '835700', '836306', '847360', '848956',
        '858062', '858372', '861416', '863538', '877486', '901399'
    }


class PneumocystisJiroveciPneumoniaPcpProphylaxis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1076'
    VALUE_SET_NAME = 'Pneumocystis Jiroveci Pneumonia (PCP) Prophylaxis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '142118', '197557', '197558', '198229', '198334', '198335', '308429', '313134', '313137',
        '607295', '861597'
    }


class ContraceptiveMedications(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1080'
    VALUE_SET_NAME = 'Contraceptive Medications'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1000126', '1000131', '1000153', '1000156', '1013626', '1013629', '1037183', '1037184',
        '1048440', '1050492', '1050493', '105510', '1090992', '1095224', '1099638', '1251323',
        '1251334', '1251336', '1301016', '1358762', '1358763', '1358776', '1359022', '1359023',
        '1359028', '1359117', '1359130', '1359131', '1359132', '1366343', '1367436', '1373501',
        '1373502', '1373503', '1421459', '1426288', '1435163', '1437769', '197679', '197680',
        '198042', '198043', '204407', '238015', '238019', '240128', '240707', '242297', '245263',
        '246521', '248310', '249357', '259218', '284207', '310228', '310230', '310463', '311359',
        '312033', '312124', '314146', '315096', '348804', '348805', '389221', '392662', '402250',
        '406396', '433718', '483325', '578732', '602598', '630734', '654353', '687424', '722152',
        '729534', '748798', '748800', '748804', '748806', '748832', '748868', '748878', '748961',
        '749155', '749156', '749157', '749736', '749761', '749784', '749786', '749848', '749852',
        '749854', '749856', '749858', '749860', '749862', '749869', '749879', '750242', '751553',
        '751901', '753476', '759741', '759742', '759743', '763088', '810096', '823777', '978944',
        '978946', '978949'
    }


class Isotretinoin(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1143'
    VALUE_SET_NAME = 'Isotretinoin'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1547561', '1547565', '197843', '197844', '197845', '403930'}


class VaricellaZosterVaccineVzv(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1170'
    VALUE_SET_NAME = 'Varicella Zoster Vaccine (VZV)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'21', '94'}


class AdhdMedications(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1171'
    VALUE_SET_NAME = 'ADHD Medications'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1006608', '1009145', '1013930', '1013937', '1087322', '1091133', '1091145', '1091150',
        '1091152', '1091155', '1091170', '1091185', '1091210', '1091225', '1091322', '1091341',
        '1091389', '1091392', '1091497', '1092566', '1101926', '1101932', '1233709', '1310588',
        '1312583', '1425847', '1425854', '1535454', '1535470', '1593856', '1648183', '1727443',
        '1734928', '1734951', '1806177', '1806179', '1806181', '1806183', '1806185', '1806187',
        '1806189', '1806191', '1806193', '1806195', '1806197', '1806200', '1806202', '1806204',
        '1806206', '1806208', '1806210', '197745', '197746', '349591', '349592', '349593',
        '349594', '349595', '541363', '541878', '541892', '577957', '577961', '608139', '608143',
        '687043', '753436', '753438', '753440', '753441', '854830', '854834', '854838', '854842',
        '854846', '854850', '861221', '861223', '861225', '861227', '861232', '861237', '862006',
        '862013', '862019', '862025', '884173', '884185', '884189', '884192', '884198', '884203',
        '884221', '884225', '884385', '884386', '884520', '884522', '884532', '884535', '884684',
        '885878', '885880', '892791', '895018', '895020', '895023', '899439', '899461', '899485',
        '899495', '899511', '899518', '899548', '899557', '977860', '998671', '998675', '998679'
    }


class DapsoneAndPyrimethamine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1202'
    VALUE_SET_NAME = 'Dapsone and pyrimethamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'105337'}


class Leucovorin(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1205'
    VALUE_SET_NAME = 'Leucovorin'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197860', '197861', '197862', '197863', '237788', '311282'}


class AspirinAndOtherAntiplatelets(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1211'
    VALUE_SET_NAME = 'Aspirin and Other Antiplatelets'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1722689', '198466', '198467', '198471', '198475', '199274', '212033', '243670', '259081',
        '308409', '308411', '308414', '308416', '308417', '309362', '313406', '318272', '646434',
        '747211', '749196', '853499', '855812', '855818'
    }


class AntidepressantMedication(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1213'
    VALUE_SET_NAME = 'Antidepressant Medication'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1000048', '1000054', '1000058', '1000064', '1000070', '1000076', '1000097', '104837',
        '1086772', '1086778', '1086784', '1086789', '1098649', '1098666', '1098670', '1098674',
        '1098678', '1099288', '1099292', '1099296', '1099300', '1099304', '1099316', '1190110',
        '1232585', '1298857', '1298861', '1298870', '1430122', '1433217', '1433227', '1433233',
        '1433239', '1433249', '1439808', '1439810', '1439812', '1551468', '1607617', '1653469',
        '1738483', '1738495', '1738503', '1738511', '1738515', '1738519', '1738523', '1738527',
        '1738803', '1738805', '1738807', '1801289', '197363', '197364', '197365', '197366',
        '198045', '198046', '198047', '199283', '199820', '200371', '245373', '248642', '283406',
        '283407', '283485', '283672', '309313', '309314', '310384', '310385', '310386', '311725',
        '311726', '312036', '312242', '312347', '312938', '312940', '312941', '313447', '313496',
        '313497', '313498', '313499', '313580', '313581', '313582', '313583', '313584', '313585',
        '313586', '313989', '313990', '313995', '314111', '314277', '317136', '349332', '351249',
        '351250', '351285', '403969', '403970', '403971', '403972', '476809', '596926', '596930',
        '596934', '616402', '721787', '730440', '730441', '730442', '790264', '790288', '808744',
        '808748', '808751', '808753', '835564', '835568', '835572', '835577', '835589', '835591',
        '835593', '856364', '856369', '856373', '856377', '856706', '856720', '856762', '856769',
        '856773', '856783', '856792', '856797', '856825', '856834', '856840', '856845', '856853',
        '857296', '857297', '857301', '857305', '857315', '861064', '865206', '865210', '865214',
        '898697', '898704', '903873', '903879', '903884', '903887', '903891', '905168', '905172',
        '993503', '993518', '993536', '993541', '993550', '993557', '993567', '993681', '993687',
        '993691'
    }


class DtapVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1214'
    VALUE_SET_NAME = 'DTaP Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'106', '110', '120', '20', '50'}


class HepatitisAVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1215'
    VALUE_SET_NAME = 'Hepatitis A Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'83', '85'}


class HepatitisBVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1216'
    VALUE_SET_NAME = 'Hepatitis B Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'08', '110', '44', '45', '51'}


class HaemophilusInfluenzaeTypeBHibVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1217'
    VALUE_SET_NAME = 'Haemophilus Influenzae Type B (HiB) Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'120', '148', '17', '46', '47', '48', '49', '50', '51'}


class InfluenzaVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1218'
    VALUE_SET_NAME = 'Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'135', '140', '141', '153', '155', '158', '161', '88'}


class InactivatedPolioVaccineIpv(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1219'
    VALUE_SET_NAME = 'Inactivated Polio Vaccine (IPV)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'10', '110', '120', '89'}


class PneumococcalConjugateVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1221'
    VALUE_SET_NAME = 'Pneumococcal Conjugate Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'100', '133'}


class RotavirusVaccine2DoseSchedule(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1222'
    VALUE_SET_NAME = 'Rotavirus Vaccine (2 dose schedule)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'119'}


class RotavirusVaccine3DoseSchedule(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1223'
    VALUE_SET_NAME = 'Rotavirus Vaccine (3 dose schedule)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'116'}


class MeaslesMumpsAndRubellaMmrVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1224'
    VALUE_SET_NAME = 'Measles, Mumps and Rubella (MMR) Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {'03', '94'}


class HighRiskMedicationsForTheElderly(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1253'
    VALUE_SET_NAME = 'High Risk Medications for the Elderly'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1000351', '1000352', '1000355', '1000356', '1000395', '1000398', '1000486', '1000490',
        '1000496', '1010696', '1012904', '1013619', '1014331', '1020477', '1038876', '1041814',
        '1042684', '1042688', '1042693', '1043400', '1046751', '1046781', '1046799', '1046815',
        '1048124', '1049289', '1049630', '1049633', '1049900', '1049904', '1049906', '1049909',
        '1049918', '1052462', '1052467', '1052647', '1052679', '1052928', '1053624', '1085945',
        '1086463', '1086750', '1086991', '1087459', '1087607', '1088934', '1088936', '1089822',
        '1089968', '1090443', '1090463', '1090699', '1092189', '1092373', '1092566', '1093098',
        '1094131', '1094350', '1094355', '1094549', '1098443', '1098496', '1098497', '1098498',
        '1099308', '1099446', '1099659', '1099668', '1099788', '1099872', '1099948', '1101439',
        '1101446', '1101457', '1101555', '1111065', '1112220', '1112864', '1113397', '1113417',
        '1113522', '1114003', '1116173', '1117245', '1117392', '1147619', '1147795', '1148155',
        '1149632', '1190580', '1190600', '1190931', '1192477', '1193293', '1233546', '1233575',
        '1234386', '1234884', '1234941', '1242582', '1244523', '1244951', '1245291', '1245374',
        '1245706', '1248057', '1248354', '1248750', '1250907', '1250983', '1251614', '1251621',
        '1251802', '1251811', '1291711', '1293239', '1293298', '1293344', '1293487', '1294201',
        '1294557', '1294607', '1297288', '1297390', '1297404', '1297517', '1297947', '1298433',
        '1298799', '1298834', '1299646', '1299662', '1300164', '1300195', '1303797', '1304105',
        '1313969', '1356797', '1356800', '1356807', '1356812', '1356815', '1356838', '1356841',
        '1356848', '1357010', '1357553', '1359123', '1359124', '1359126', '1359127', '1363288',
        '1363306', '1363309', '1363513', '1363780', '1366653', '1366825', '1367227', '1368963',
        '1369403', '1369424', '1369971', '1369972', '1370963', '1372265', '1372312', '1373501',
        '1373502', '1373503', '1374770', '1375948', '1421985', '1423711', '1424551', '1424850',
        '1424872', '1428880', '1428927', '1429345', '1440003', '1441376', '1441392', '1441831',
        '1483549', '1483550', '1483552', '1483553', '1486964', '1490671', '1490727', '1491529',
        '1491649', '153444', '1535609', '1535923', '1536840', '1536862', '1536931', '1536999',
        '1537029', '1537767', '1537803', '1537807', '1537811', '1537837', '1540230', '1546700',
        '1546881', '1550957', '1593110', '1595631', '1606291', '1657147', '1659960', '1665459',
        '1665461', '1665675', '1665679', '1665682', '1665685', '1665690', '1665697', '1665699',
        '1665701', '1673791', '1723740', '1723776', '1730190', '1730192', '1794552', '1794554',
        '1797855', '1811473', '197426', '197446', '197447', '197495', '197496', '197502', '197622',
        '197647', '197657', '197658', '197659', '197660', '197661', '197662', '197666', '197667',
        '197668', '197669', '197670', '197737', '197745', '197746', '197817', '197818', '197819',
        '197928', '197929', '197930', '197935', '197943', '197944', '197956', '197958', '197960',
        '197963', '198032', '198033', '198083', '198085', '198086', '198089', '198270', '198274',
        '198275', '198276', '198277', '198278', '198280', '198368', '199164', '199167', '199168',
        '199314', '199329', '199340', '199341', '199549', '199782', '199789', '199820', '200330',
        '200331', '200332', '204407', '205333', '208545', '226597', '238003', '238004', '238006',
        '238019', '238090', '238133', '238134', '238135', '238153', '238154', '239981', '240826',
        '241527', '241946', '242297', '242333', '242891', '242892', '245373', '246521', '248478',
        '250485', '251050', '251098', '284437', '284438', '308169', '308170', '309249', '309952',
        '309953', '309955', '309958', '309960', '310143', '310197', '310204', '310205', '310206',
        '310212', '310213', '310215', '310230', '310534', '310536', '310537', '310539', '310991',
        '310992', '312289', '312357', '312362', '312370', '312914', '313354', '313385', '313386',
        '313387', '313389', '313391', '313393', '313396', '313406', '313496', '313497', '313498',
        '313499', '314000', '314132', '314267', '315234', '315235', '318179', '333833', '346508',
        '346713', '346714', '347151', '348804', '348805', '348906', '349271', '351228', '351254',
        '359281', '359370', '402250', '403849', '403922', '403923', '476540', '477045', '477245',
        '477587', '483169', '577027', '577029', '577154', '618368', '618370', '618376', '618378',
        '636793', '636794', '688240', '700851', '701393', '702519', '722152', '728581', '730794',
        '730878', '731007', '731032', '748832', '748868', '748878', '749761', '749850', '751553',
        '751901', '804145', '810096', '828299', '828320', '828348', '828353', '828358', '834022',
        '835564', '835568', '835572', '835577', '835589', '835591', '835593', '856706', '856720',
        '856762', '856769', '856773', '856783', '856792', '856797', '856825', '856834', '856840',
        '856845', '856853', '857291', '857296', '857297', '857301', '857305', '857315', '857416',
        '857420', '857430', '857461', '857510', '857512', '860092', '860096', '860113', '860114',
        '860115', '860215', '860221', '860225', '860231', '860771', '860792', '861447', '861455',
        '861459', '861463', '861467', '861473', '861476', '861479', '861482', '861493', '861494',
        '861578', '861743', '861748', '861753', '862006', '862013', '862019', '862025', '882504',
        '885205', '885209', '885213', '885219', '889520', '895664', '901814', '905269', '905273',
        '905283', '968670', '978944', '978946', '978948', '991042', '991486', '991528', '992432',
        '992438', '992441', '992447', '992454', '992460', '992475', '992478', '992858', '993943',
        '994226', '994237', '994289', '994402', '994521', '994528', '994535', '994541', '994824',
        '995211', '995214', '995218', '995232', '995235', '995241', '995253', '995258', '995270',
        '995274', '995278', '995281', '995285', '995428', '996640', '996757', '997272', '998254'
    }


class HighRiskMedicationsWithDaysSupplyCriteria(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1254'
    VALUE_SET_NAME = 'High-Risk Medications With Days Supply Criteria'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1232194', '1232202', '1648755', '1648759', '311989', '311991', '311994', '311995',
        '313761', '313762', '485440', '485442', '485465', '828692', '836641', '836647', '854873',
        '854876', '854880', '854894'
    }


class AnticoagulantMedications(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1283'
    VALUE_SET_NAME = 'Anticoagulant Medications'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1037045', '1037179', '1114198', '1232082', '1232086', '1361029', '1361226', '1361568',
        '1361574', '1361577', '1361607', '1361615', '1361853', '1362048', '1362052', '1362054',
        '1362055', '1362057', '1362059', '1362060', '1362061', '1362062', '1362063', '1362065',
        '1362831', '1364435', '1364445', '1549682', '1599543', '1599551', '1599555', '1656760',
        '1658634', '1658637', '1658647', '1658659', '1658690', '1658692', '1658707', '1658717',
        '1658719', '1658720', '1659195', '1659197', '1659260', '1659263', '1723476', '308351',
        '308769', '402248', '854228', '854235', '854238', '854241', '854245', '854248', '854252',
        '854255', '855288', '855296', '855302', '855312', '855318', '855324', '855332', '855338',
        '855344', '861356', '861360', '861363', '861365', '978713', '978725', '978733', '978736',
        '978738', '978740', '978744', '978746', '978755', '978759', '978777'
    }


class Meprobamate(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1284'
    VALUE_SET_NAME = 'Meprobamate'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197928', '197929'}


class Trimipramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1285'
    VALUE_SET_NAME = 'Trimipramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'199820', '245373', '313496', '313497', '313498', '313499'}


class AmitriptylineChlordiazepoxide(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1286'
    VALUE_SET_NAME = 'Amitriptyline  /  Chlordiazepoxide'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'856769', '856792'}


class AcetaminophenDextromethorphanDoxylaminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1287'
    VALUE_SET_NAME = 'Acetaminophen / Dextromethorphan / Doxylamine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1233546', '1297288', '1297404', '1536999', '1546881', '1657147'}


class ErgoloidMesylates(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1288'
    VALUE_SET_NAME = 'Ergoloid Mesylates'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197647', '310143', '318179'}


class AcetaminophenChlorpheniramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1289'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1112864'}


class Doxylamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1290'
    VALUE_SET_NAME = 'Doxylamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1101439', '1101446', '1101457', '1242582'}


class CodeinePhenylephrinePromethazine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1291'
    VALUE_SET_NAME = 'Codeine / Phenylephrine / Promethazine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'996757'}


class DiphenhydramineIbuprofen(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1293'
    VALUE_SET_NAME = 'Diphenhydramine / Ibuprofen'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'895664', '901814'}


class PhenylephrinePromethazine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1294'
    VALUE_SET_NAME = 'Phenylephrine / Promethazine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1248057'}


class ChlorpheniramineDextromethorphan(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1296'
    VALUE_SET_NAME = 'Chlorpheniramine / Dextromethorphan'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1251811', '1421985', '804145'}


class Amobarbital(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1297'
    VALUE_SET_NAME = 'Amobarbital'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'308169', '308170'}


class Secobarbital(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1298'
    VALUE_SET_NAME = 'Secobarbital'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'312914'}


class ChlorpheniramineHydrocodonePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1299'
    VALUE_SET_NAME = 'Chlorpheniramine / Hydrocodone / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1112220'}


class DexchlorpheniramineDextromethorphanPseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1300'
    VALUE_SET_NAME = 'Dexchlorpheniramine / Dextromethorphan / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1298433'}


class ChlorpheniramineCodeine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1301'
    VALUE_SET_NAME = 'Chlorpheniramine / Codeine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'995211', '995214'}


class AspirinCaffeineOrphenadrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1302'
    VALUE_SET_NAME = 'Aspirin / Caffeine / Orphenadrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'994528', '994535'}


class Chlorpropamide(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1303'
    VALUE_SET_NAME = 'Chlorpropamide'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197495', '197496'}


class Ticlopidine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1304'
    VALUE_SET_NAME = 'Ticlopidine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'313406'}


class AspirinCarisoprodolCodeine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1305'
    VALUE_SET_NAME = 'Aspirin / Carisoprodol / Codeine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'994226'}


class Carbinoxamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1306'
    VALUE_SET_NAME = 'Carbinoxamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1010696', '1012904', '1374770'}


class DiphenhydraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1307'
    VALUE_SET_NAME = 'Diphenhydramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1052928'}


class Clemastine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1308'
    VALUE_SET_NAME = 'Clemastine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'857416', '857420', '857430', '857461'}


class ChlorpheniraminePhenylephrinePyrilamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1309'
    VALUE_SET_NAME = 'Chlorpheniramine / Phenylephrine / Pyrilamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'349271', '359370'}


class AcetaminophenChlorpheniramineDextromethorphanPhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1310'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Dextromethorphan / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1042688', '1086991', '1113397', '1357553', '1537029'}


class Disopyramide(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1311'
    VALUE_SET_NAME = 'Disopyramide'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'309958', '309960', '636793', '636794'}


class ChlorpheniramineDextromethorphanPhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1312'
    VALUE_SET_NAME = 'Chlorpheniramine / Dextromethorphan / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1535923', '1536862'}


class AspirinCarisoprodol(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1313'
    VALUE_SET_NAME = 'Aspirin / Carisoprodol'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197447'}


class DextromethorphanPromethazine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1314'
    VALUE_SET_NAME = 'Dextromethorphan / Promethazine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'991528'}


class ChlorpheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1315'
    VALUE_SET_NAME = 'Chlorpheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1053624', '1090699', '1363780', '998254'}


class AcetaminophenChlorpheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1316'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1293344', '1294201'}


class AcetaminophenButalbital(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1317'
    VALUE_SET_NAME = 'Acetaminophen / Butalbital'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197426'}


class AcetaminophenDiphenhydraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1318'
    VALUE_SET_NAME = 'Acetaminophen / Diphenhydramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1046751', '1147619', '1233575', '1428880', '1659960'}


class Estropipate(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1319'
    VALUE_SET_NAME = 'Estropipate'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'310212', '310213', '310215'}


class EsterifiedEstrogensMethyltestosterone(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1320'
    VALUE_SET_NAME = 'Esterified Estrogens / Methyltestosterone'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197670', '238006'}


class AcetaminophenChlorpheniramineDextromethorphanPseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1321'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Dextromethorphan / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1089968', '1147795', '1293298', '1299646', '1299662', '1366825'}


class AspirinButalbitalCaffeineCodeine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1322'
    VALUE_SET_NAME = 'Aspirin / Butalbital / Caffeine / Codeine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'994237'}


class EstradiolNorethindrone(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1323'
    VALUE_SET_NAME = 'Estradiol / Norethindrone'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1359123', '1359124', '1359126', '1359127'}


class ConjugatedEstrogensMedroxyprogesterone(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1324'
    VALUE_SET_NAME = 'Conjugated Estrogens / Medroxyprogesterone'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1000351', '1000352', '1000355', '1000356', '1000395', '1000398', '1000486', '1000490',
        '1000496'
    }


class BrompheniramineDextromethorphanPhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1325'
    VALUE_SET_NAME = 'Brompheniramine / Dextromethorphan / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1090463', '1148155', '1304105', '1486964'}


class AcetaminophenButalbitalCaffeineCodeine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1326'
    VALUE_SET_NAME = 'Acetaminophen / Butalbital / Caffeine / Codeine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'993943'}


class BrompheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1327'
    VALUE_SET_NAME = 'Brompheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1244523', '1251802', '1356815', '1356841', '731007'}


class AcetaminophenChlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1328'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1046781', '1046799', '1052679', '1101555', '1193293', '1244951', '1313969', '1366653',
        '1372312', '1536931'
    }


class AcetaminophenDextromethorphanDoxylaminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1329'
    VALUE_SET_NAME = 'Acetaminophen / Dextromethorphan / Doxylamine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1089822'}


class ChlorpheniramineHydrocodone(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1330'
    VALUE_SET_NAME = 'Chlorpheniramine / Hydrocodone'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1087459', '1372265', '857510', '857512'}


class Methyldopa(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1331'
    VALUE_SET_NAME = 'Methyldopa'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197956', '197958'}


class BrompheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1332'
    VALUE_SET_NAME = 'Brompheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1098498', '1192477'}


class Trihexyphenidyl(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1334'
    VALUE_SET_NAME = 'Trihexyphenidyl'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'905269', '905273', '905283'}


class Trimethobenzamide(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1335'
    VALUE_SET_NAME = 'Trimethobenzamide'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'860771'}


class Clomipramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1336'
    VALUE_SET_NAME = 'Clomipramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'857291', '857296', '857297', '857301', '857305', '857315'}


class ChlorpheniramineDextromethorphanPseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1337'
    VALUE_SET_NAME = 'Chlorpheniramine / Dextromethorphan / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1117392', '1245291', '1423711'}


class AcetaminophenDextromethorphanDoxylamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1338'
    VALUE_SET_NAME = 'Acetaminophen / Dextromethorphan / Doxylamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1042684', '1043400', '1094549'}


class BrompheniramineDextromethorphanPseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1339'
    VALUE_SET_NAME = 'Brompheniramine / Dextromethorphan / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1098497', '1356812', '1356838', '1357010'}


class CodeinePromethazine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1340'
    VALUE_SET_NAME = 'Codeine / Promethazine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'991486'}


class Guanfacine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1341'
    VALUE_SET_NAME = 'Guanfacine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1092566', '197745', '197746', '862006', '862013', '862019', '862025'}


class Megestrol(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1342'
    VALUE_SET_NAME = 'Megestrol'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'577154', '860215', '860221', '860225', '860231'}


class ChlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1343'
    VALUE_SET_NAME = 'Chlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1013619', '1086463', '1090443', '1293487', '1367227', '1429345'}


class Thioridazine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1344'
    VALUE_SET_NAME = 'Thioridazine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'198270', '198274', '198275', '313354', '346713', '346714'}


class PseudoephedrineTriprolidine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1345'
    VALUE_SET_NAME = 'Pseudoephedrine / Triprolidine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1099308', '1099446', '1099668'}


class NaloxonePentazocine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1346'
    VALUE_SET_NAME = 'Naloxone / Pentazocine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'312289'}


class AspirinButalbitalCaffeine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1347'
    VALUE_SET_NAME = 'Aspirin / Butalbital / Caffeine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'238134', '238135'}


class Phenobarbital(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1348'
    VALUE_SET_NAME = 'Phenobarbital'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '198083', '198085', '198086', '198089', '198368', '199164', '199167', '199168', '312357',
        '312362', '312370', '702519'
    }


class Dipyridamole(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1349'
    VALUE_SET_NAME = 'Dipyridamole'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197622', '199314', '309952', '309953', '309955', '333833'}


class AcetaminophenDiphenhydramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1350'
    VALUE_SET_NAME = 'Acetaminophen / Diphenhydramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1052462', '1052467', '1087607', '1092189', '1092373', '1099872', '1117245', '1245374',
        '1294607', '1297947'
    }


class Meperidine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1351'
    VALUE_SET_NAME = 'Meperidine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1665685', '1665690', '1665697', '1665699', '1665701', '860792', '861447', '861455',
        '861459', '861463', '861467', '861473', '861476', '861479', '861482', '861493', '861494'
    }


class Chlorpheniramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1352'
    VALUE_SET_NAME = 'Chlorpheniramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1363288', '1363306', '1363309', '1673791', '239981', '309249', '477045'}


class Nifedipine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1353'
    VALUE_SET_NAME = 'Nifedipine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'198032', '198033', '199329', '199782', '314132'}


class DesiccatedThyroid(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1354'
    VALUE_SET_NAME = 'Desiccated Thyroid'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1041814', '1099948', '1537767', '1537803', '1537807', '1537811', '1537837', '198276',
        '198277', '198278', '198280', '200330', '200331', '200332', '208545', '284437', '284438',
        '313385', '313386', '313387', '313389', '313391', '313393', '313396', '314267', '315234',
        '315235', '347151', '728581'
    }


class AtropineHyoscyaminePhenobarbitalScopolamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1355'
    VALUE_SET_NAME = 'Atropine / Hyoscyamine / Phenobarbital / Scopolamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1046815'}


class Orphenadrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1356'
    VALUE_SET_NAME = 'Orphenadrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'994521', '994541', '994824'}


class ConjugatedEstrogens(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1357'
    VALUE_SET_NAME = 'Conjugated Estrogens'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '197660', '197661', '197662', '310197', '310204', '310205', '310206', '351228', '403849',
        '476540', '618368', '618370', '618376', '618378', '688240', '730878'
    }


class Metaxalone(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1358'
    VALUE_SET_NAME = 'Metaxalone'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197935', '351254'}


class Imipramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1359'
    VALUE_SET_NAME = 'Imipramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'835564', '835568', '835572', '835577', '835589', '835591', '835593'}


class GlyburideMetformin(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1360'
    VALUE_SET_NAME = 'Glyburide / Metformin'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'861743', '861748', '861753'}


class Benztropine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1361'
    VALUE_SET_NAME = 'Benztropine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'885205', '885209', '885213', '885219'}


class Chlorzoxazone(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1362'
    VALUE_SET_NAME = 'Chlorzoxazone'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1088934', '1088936', '197502'}


class AcetaminophenButalbitalCaffeine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1363'
    VALUE_SET_NAME = 'Acetaminophen / Butalbital / Caffeine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'238153', '238154', '889520'}


class KetorolacTromethamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1364'
    VALUE_SET_NAME = 'Ketorolac Tromethamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1540230', '1665459', '1665461', '1665675', '1665679', '1665682', '1797855', '834022',
        '860092', '860096', '860113', '860114', '860115'
    }


class Estradiol(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1365'
    VALUE_SET_NAME = 'Estradiol'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1149632', '153444', '197657', '197658', '197659', '204407', '205333', '226597', '238003',
        '238004', '241527', '241946', '242333', '242891', '242892', '248478', '251098', '403922',
        '403923', '483169', '577027', '577029', '978948'
    }


class Indomethacin(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1366'
    VALUE_SET_NAME = 'Indomethacin'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1490727', '1491529', '197817', '197818', '197819', '199549', '310991', '310992', '346508'
    }


class PromethazineHydrochloride(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1367'
    VALUE_SET_NAME = 'Promethazine Hydrochloride'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '992432', '992438', '992441', '992447', '992454', '992460', '992475', '992478', '992858'
    }


class Glyburide(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1368'
    VALUE_SET_NAME = 'Glyburide'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197737', '310534', '310536', '310537', '310539', '314000'}


class Carisoprodol(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1369'
    VALUE_SET_NAME = 'Carisoprodol'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197446', '730794'}


class Methocarbamol(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1370'
    VALUE_SET_NAME = 'Methocarbamol'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197943', '197944'}


class DiphenhydramineHydrochloride(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1371'
    VALUE_SET_NAME = 'Diphenhydramine Hydrochloride'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1020477', '1049289', '1049630', '1049633', '1049900', '1049904', '1049906', '1049909',
        '1049918', '1085945', '1093098', '1248354', '1723740', '1723776', '477245', '882504'
    }


class CyclobenzaprineHydrochloride(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1372'
    VALUE_SET_NAME = 'Cyclobenzaprine Hydrochloride'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'828299', '828320', '828348', '828353', '828358'}


class AmitriptylineHydrochloride(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1373'
    VALUE_SET_NAME = 'Amitriptyline Hydrochloride'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'856762', '856773', '856783', '856834', '856845', '856853'}


class Hydroxyzine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1374'
    VALUE_SET_NAME = 'Hydroxyzine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1794552', '1794554', '995218', '995232', '995235', '995241', '995253', '995258', '995270',
        '995274', '995278', '995281', '995285', '995428'
    }


class Dexbrompheniramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1375'
    VALUE_SET_NAME = 'Dexbrompheniramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'240826'}


class AspirinDiphenhydramineCitrate(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1376'
    VALUE_SET_NAME = 'Aspirin / Diphenhydramine Citrate'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1250907'}


class AcetaminophenDiphenhydraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1378'
    VALUE_SET_NAME = 'Acetaminophen / Diphenhydramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1291711'}


class DoxylaminePyridoxine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1379'
    VALUE_SET_NAME = 'Doxylamine / Pyridoxine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1375948'}


class AspirinChlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1380'
    VALUE_SET_NAME = 'Aspirin / Chlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1536840'}


class AcetaminophenChlorpheniramineDextromethorphanGuaifenesin(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1383'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Dextromethorphan / Guaifenesin'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1250983'}


class DexbrompheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1384'
    VALUE_SET_NAME = 'Dexbrompheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'968670'}


class PhenylephrineTriprolidine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1385'
    VALUE_SET_NAME = 'Phenylephrine / Triprolidine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1099659'}


class BazedoxifeneConjugatedEstrogens(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1386'
    VALUE_SET_NAME = 'Bazedoxifene / Conjugated Estrogens'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1441392'}


class DoxylaminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1387'
    VALUE_SET_NAME = 'Doxylamine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1441831'}


class AcetaminophenAspirinDiphenhydramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1388'
    VALUE_SET_NAME = 'Acetaminophen / Aspirin / Diphenhydramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1593110'}


class AcetaminophenBrompheniramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1389'
    VALUE_SET_NAME = 'Acetaminophen / Brompheniramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1595631'}


class Dexchlorpheniramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1391'
    VALUE_SET_NAME = 'Dexchlorpheniramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'701393'}


class DiphenhydraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1392'
    VALUE_SET_NAME = 'Diphenhydramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1294557'}


class MeperidinePromethazine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1393'
    VALUE_SET_NAME = 'Meperidine / Promethazine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'861578'}


class AspirinMeprobamate(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1394'
    VALUE_SET_NAME = 'Aspirin / Meprobamate'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197930'}


class DiphenhydramineMagnesiumSalicylate(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1395'
    VALUE_SET_NAME = 'Diphenhydramine / Magnesium Salicylate'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1297517'}


class EstradiolNorgestimateBiphasic(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1396'
    VALUE_SET_NAME = 'Estradiol / Norgestimate Biphasic'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'348906', '749850'}


class DextromethorphanDiphenhydraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1397'
    VALUE_SET_NAME = 'Dextromethorphan / Diphenhydramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1730190'}


class DienogestEstradiolMultiphasic(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1398'
    VALUE_SET_NAME = 'Dienogest / Estradiol Multiphasic'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'978944', '978946'}


class AcetaminophenDextromethorphanDiphenhydraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1399'
    VALUE_SET_NAME = 'Acetaminophen / Dextromethorphan / Diphenhydramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1098443', '1424551', '1424850', '1428880', '1535609', '1606291', '1730192'}


class AcetaminophenDoxylaminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1400'
    VALUE_SET_NAME = 'Acetaminophen / Doxylamine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1052647'}


class Pentobarbital(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1401'
    VALUE_SET_NAME = 'Pentobarbital'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'238090'}


class Butabarbital(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1402'
    VALUE_SET_NAME = 'Butabarbital'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1251614', '1251621'}


class DexchlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1403'
    VALUE_SET_NAME = 'Dexchlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'991042'}


class AcetaminophenDexbrompheniramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1405'
    VALUE_SET_NAME = 'Acetaminophen / Dexbrompheniramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1190931', '1546700'}


class DiphenhydramineNaproxen(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1406'
    VALUE_SET_NAME = 'Diphenhydramine / Naproxen'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1550957'}


class Pentazocine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1407'
    VALUE_SET_NAME = 'Pentazocine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1811473', '199789', '238133', '250485'}


class Triprolidine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1408'
    VALUE_SET_NAME = 'Triprolidine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1099788', '1428927', '1490671', '1491649'}


class BrompheniramineCodeinePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1409'
    VALUE_SET_NAME = 'Brompheniramine / Codeine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1356797'}


class DrospirenoneEstradiol(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1410'
    VALUE_SET_NAME = 'Drospirenone / Estradiol'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1483549', '1483550', '1483552', '1483553'}


class AtropineChlorpheniramineHyoscyaminePseudoephedrineScopolamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1411'
    VALUE_SET_NAME = 'Atropine / Chlorpheniramine / Hyoscyamine / Pseudoephedrine / Scopolamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1048124'}


class ChlophedianolChlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1412'
    VALUE_SET_NAME = 'Chlophedianol / Chlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1245706', '1248750', '1368963', '1424872'}


class Mephobarbital(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1413'
    VALUE_SET_NAME = 'Mephobarbital'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'199340', '199341'}


class HydrochlorothiazideMethyldopa(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1414'
    VALUE_SET_NAME = 'Hydrochlorothiazide / Methyldopa'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197960', '197963'}


class ChlorpheniramineIbuprofenPseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1416'
    VALUE_SET_NAME = 'Chlorpheniramine / Ibuprofen / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1297390'}


class EsterifiedEstrogens(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1419'
    VALUE_SET_NAME = 'Esterified Estrogens'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'197666', '197667', '197668', '197669'}


class CarbetapentaneChlorpheniramineEphedrinePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1420'
    VALUE_SET_NAME = 'Carbetapentane / Chlorpheniramine / Ephedrine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1116173'}


class AcetaminophenChlorpheniramineDextromethorphan(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1421'
    VALUE_SET_NAME = 'Acetaminophen / Chlorpheniramine / Dextromethorphan'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1038876', '1086750', '1098496', '1113522'}


class Isoxsuprine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1422'
    VALUE_SET_NAME = 'Isoxsuprine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1298799', '1298834'}


class DexchlorpheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1425'
    VALUE_SET_NAME = 'Dexchlorpheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1293239'}


class DexbrompheniramineDextromethorphanPhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1426'
    VALUE_SET_NAME = 'Dexbrompheniramine / Dextromethorphan / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1300164', '1300195', '1303797'}


class Brompheniramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1427'
    VALUE_SET_NAME = 'Brompheniramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1356848', '359281', '477587', '700851', '731032'}


class AmitriptylinePerphenazine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1428'
    VALUE_SET_NAME = 'Amitriptyline / Perphenazine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'856706', '856720', '856797', '856825', '856840'}


class DexbrompheniramineMaleatePseudoephedrineHydrochloride(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1429'
    VALUE_SET_NAME = 'Dexbrompheniramine Maleate / Pseudoephedrine Hydrochloride'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1363513'}


class DexbrompheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1430'
    VALUE_SET_NAME = 'Dexbrompheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1370963'}


class CodeinePseudoephedrineTriprolidine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1431'
    VALUE_SET_NAME = 'Codeine / Pseudoephedrine / Triprolidine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'996640', '997272'}


class CodeineDexchlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1433'
    VALUE_SET_NAME = 'Codeine / Dexchlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1440003'}


class ChlorpheniramineDihydrocodeinePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1434'
    VALUE_SET_NAME = 'Chlorpheniramine / Dihydrocodeine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1234884', '1234941'}


class ChlophedianolDexbrompheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1435'
    VALUE_SET_NAME = 'Chlophedianol / Dexbrompheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1369403'}


class CodeineDexbrompheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1437'
    VALUE_SET_NAME = 'Codeine / Dexbrompheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1190580'}


class DexbrompheniramineDextromethorphanPseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1438'
    VALUE_SET_NAME = 'Dexbrompheniramine / Dextromethorphan / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1190600'}


class ChlorpheniramineCodeinePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1439'
    VALUE_SET_NAME = 'Chlorpheniramine / Codeine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1042693'}


class ChlophedianolDexbrompheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1440'
    VALUE_SET_NAME = 'Chlophedianol / Dexbrompheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1441376'}


class AcetaminophenDextromethorphanDiphenhydramine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1441'
    VALUE_SET_NAME = 'Acetaminophen / Dextromethorphan / Diphenhydramine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1094131'}


class BrompheniramineChlophedianolPseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1443'
    VALUE_SET_NAME = 'Brompheniramine / Chlophedianol / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1014331'}


class DextromethorphanDoxylaminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1444'
    VALUE_SET_NAME = 'Dextromethorphan / Doxylamine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1094350'}


class BrompheniramineChlophedianolPhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1445'
    VALUE_SET_NAME = 'Brompheniramine / Chlophedianol / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1111065'}


class ChlorpheniramineCodeinePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1446'
    VALUE_SET_NAME = 'Chlorpheniramine / Codeine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1113417', '1114003'}


class ChlophedianolDexchlorpheniraminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1447'
    VALUE_SET_NAME = 'Chlophedianol / Dexchlorpheniramine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1369424', '1369971', '1369972'}


class DoxylaminePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1448'
    VALUE_SET_NAME = 'Doxylamine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1094355'}


class BrompheniramineCodeinePseudoephedrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1450'
    VALUE_SET_NAME = 'Brompheniramine / Codeine / Pseudoephedrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'994289', '994402'}


class DextromethorphanDoxylamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1452'
    VALUE_SET_NAME = 'Dextromethorphan / Doxylamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1234386'}


class ChlorpheniraminePhenylephrinePhenyltoloxamine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1453'
    VALUE_SET_NAME = 'Chlorpheniramine / Phenylephrine / Phenyltoloxamine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'251050'}


class BrompheniramineCodeine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1455'
    VALUE_SET_NAME = 'Brompheniramine / Codeine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1356800', '1356807'}


class CarbetapentaneChlorpheniraminePhenylephrine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1472'
    VALUE_SET_NAME = 'Carbetapentane / Chlorpheniramine / Phenylephrine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1116173'}


class NonbenzodiazepineHypnotics(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1480'
    VALUE_SET_NAME = 'Nonbenzodiazepine hypnotics'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1232194', '1232202', '313761', '313762', '485440', '485442', '485465', '828692', '836641',
        '836647', '854873', '854876', '854880', '854894'
    }


class AntiInfectivesOther(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1481'
    VALUE_SET_NAME = 'Anti Infectives, other'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {'1648755', '1648759', '311989', '311991', '311994', '311995'}


class Corticosteroids(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1482'
    VALUE_SET_NAME = 'Corticosteroids'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1085750', '1085754', '1085992', '1085996', '1116927', '1303125', '1303132', '1303135',
        '1358510', '1358610', '1738590', '1738594', '1743704', '1743720', '1743726', '1743855',
        '1792144', '1812079', '1812095', '1812194', '197577', '197579', '197580', '197581',
        '197582', '197583', '197782', '197783', '197787', '197969', '197971', '197973', '198142',
        '198144', '198145', '198146', '198148', '238755', '249066', '259966', '283077', '308709',
        '309684', '309686', '309692', '309696', '311659', '312614', '312615', '312617', '315187',
        '328161', '643123', '643125', '643127', '702306', '759481', '759697', '762675', '763179',
        '763181', '763183', '763185', '793099', '794979', '795858', '828248', '846192'
    }


class EstradiolLevonorgestrel(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.196.12.1483'
    VALUE_SET_NAME = 'Estradiol / Levonorgestrel'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1373501', '1373502', '1373503', '238019', '242297', '246521', '310230', '348804',
        '348805', '402250', '722152', '748832', '748868', '748878', '749761', '751553', '751901',
        '810096'
    }


class LdlTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.11.1029'
    VALUE_SET_NAME = 'LDL Test'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '12773-8', '13457-7', '18261-8', '18262-6', '2089-1', '22748-8', '39469-2', '49132-4',
        '55440-2'
    }


class BilateralMastectomy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1005'
    VALUE_SET_NAME = 'Bilateral Mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '14693006', '14714006', '17086001', '22418005', '27865001', '456903003', '52314009',
        '60633004', '76468001'
    }


class PrimaryThaProcedure(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1006'
    VALUE_SET_NAME = 'Primary THA Procedure'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'27130'}

    HCPCS = {'S2118'}

    SNOMEDCT = {
        '15163009', '179294005', '179304004', '179305003', '19954002', '265157000', '265158005',
        '265160007', '314489006', '314491003', '33788003', '425443008', '426618001', '426904006',
        '427728006', '429156003', '443435007', '450813004', '52734007', '53081006', '55423004',
        '57589001', '76915002'
    }


class PrimaryTkaProcedure(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1007'
    VALUE_SET_NAME = 'Primary TKA Procedure'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'27447'}

    SNOMEDCT = {
        '179344006', '179345007', '179351002', '179352009', '265170009', '265172001', '392237008',
        '430698003', '443681002', '443682009'
    }


class FlexibleSigmoidoscopy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1010'
    VALUE_SET_NAME = 'Flexible Sigmoidoscopy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '45330', '45331', '45332', '45333', '45334', '45335', '45337', '45338', '45339', '45340',
        '45341', '45342', '45345', '45346', '45347', '45349', '45350'
    }

    HCPCS = {'G0104'}

    SNOMEDCT = {'112870002', '396226005', '425634007', '44441009'}


class FecalOccultBloodTestFobt(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1011'
    VALUE_SET_NAME = 'Fecal Occult Blood Test (FOBT)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '12503-9', '12504-7', '14563-1', '14564-9', '14565-6', '2335-8', '27396-1', '27401-9',
        '27925-7', '27926-5', '29771-3', '56490-6', '56491-4', '57905-2', '58453-2', '80372-6'
    }


class GroupAStreptococcusTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1012'
    VALUE_SET_NAME = 'Group A Streptococcus Test'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '11268-0', '17656-0', '18481-2', '31971-5', '49610-9', '5036-9', '60489-2', '626-2',
        '6557-3', '6558-1', '6559-9', '68954-7'
    }


class Hba1CLaboratoryTest(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1013'
    VALUE_SET_NAME = 'HbA1c Laboratory Test'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'17856-6', '4548-4', '4549-2'}


class HysterectomyWithNoResidualCervix(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1014'
    VALUE_SET_NAME = 'Hysterectomy with No Residual Cervix'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '51925', '57540', '57545', '57550', '57555', '57556', '58150', '58152', '58200', '58210',
        '58240', '58260', '58262', '58263', '58267', '58270', '58275', '58280', '58285', '58290',
        '58291', '58292', '58293', '58294', '58548', '58550', '58552', '58553', '58554', '58570',
        '58571', '58572', '58573', '58951', '58953', '58954', '58956', '59135'
    }

    SNOMEDCT = {
        '112918004', '116140006', '116142003', '116143008', '116144002', '236888001', '236891001',
        '24293001', '265056007', '27185000', '27950001', '287924009', '30160001', '307771009',
        '309880009', '31545000', '35955002', '359971002', '359974005', '359977003', '359983000',
        '361222003', '361223008', '413145007', '414575003', '41566006', '43791001', '441820006',
        '446446002', '446679008', '447771005', '448539002', '54490004', '59750000', '63516002',
        '708877008', '708878003', '75835007', '77902002', '86477000', '88144003'
    }


class TotalColectomy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1019'
    VALUE_SET_NAME = 'Total Colectomy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '44150', '44151', '44152', '44153', '44155', '44156', '44157', '44158', '44210', '44211',
        '44212'
    }

    SNOMEDCT = {
        '235331003', '26390003', '303401008', '307666008', '307667004', '307669001', '31130001',
        '36192008', '44751009', '456004', '80294005'
    }


class UnilateralMastectomy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1020'
    VALUE_SET_NAME = 'Unilateral Mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'19180', '19200', '19220', '19240', '19303', '19304', '19305', '19306', '19307'}

    SNOMEDCT = {
        '172043006', '237367009', '237368004', '274957008', '287653007', '287654001', '318190001',
        '359728003', '359731002', '359734005', '359740003', '384723003', '395702000', '406505007',
        '428564008', '428571003', '429400009', '446109005', '446420001', '447135002', '447421006',
        '66398006', '70183006'
    }


class AntiHepatitisAIggAntigenTest(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1033'
    VALUE_SET_NAME = 'Anti Hepatitis A IgG Antigen Test'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'32018-4', '40724-7', '51913-2'}


class XRayStudyAllInclusive(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1034'
    VALUE_SET_NAME = 'X-Ray Study (all inclusive)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '24533-2', '24535-7', '24536-5', '24540-7', '24541-5', '24543-1', '24546-4', '24549-8',
        '24550-6', '24551-4', '24552-2', '24553-0', '24554-8', '24555-5', '24560-5', '24561-3',
        '24562-1', '24563-9', '24564-7', '24568-8', '24569-6', '24570-4', '24573-8', '24574-6',
        '24575-3', '24576-1', '24577-9', '24579-5', '24580-3', '24581-1', '24584-5', '24593-6',
        '24613-2', '24614-0', '24615-7', '24617-3', '24619-9', '24620-7', '24621-5', '24622-3',
        '24624-9', '24625-6', '24626-4', '24631-4', '24632-2', '24634-8', '24635-5', '24636-3',
        '24637-1', '24638-9', '24639-7', '24640-5', '24641-3', '24642-1', '24643-9', '24644-7',
        '24645-4', '24646-2', '24647-0', '24648-8', '24649-6', '24650-4', '24651-2', '24652-0',
        '24653-8', '24654-6', '24655-3', '24656-1', '24657-9', '24658-7', '24659-5', '24660-3',
        '24661-1', '24664-5', '24665-2', '24666-0', '24667-8', '24668-6', '24669-4', '24671-0',
        '24673-6', '24676-9', '24678-5', '24679-3', '24680-1', '24681-9', '24682-7', '24684-3',
        '24685-0', '24686-8', '24689-2', '24695-9', '24698-3', '24699-1', '24700-7', '24704-9',
        '24706-4', '24708-0', '24709-8', '24712-2', '24713-0', '24715-5', '24716-3', '24717-1',
        '24718-9', '24721-3', '24722-1', '24723-9', '24724-7', '24745-2', '24752-8', '24755-1',
        '24756-9', '24761-9', '24762-7', '24764-3', '24765-0', '24766-8', '24767-6', '24771-8',
        '24778-3', '24779-1', '24780-9', '24781-7', '24782-5', '24783-3', '24784-1', '24787-4',
        '24788-2', '24789-0', '24790-8', '24792-4', '24793-2', '24794-0', '24795-7', '24796-5',
        '24797-3', '24798-1', '24799-9', '24800-5', '24801-3', '24805-4', '24806-2', '24807-0',
        '24808-8', '24809-6', '24820-3', '24825-2', '24827-8', '24828-6', '24829-4', '24830-2',
        '24832-8', '24833-6', '24834-4', '24843-5', '24844-3', '24845-0', '24846-8', '24854-2',
        '24855-9', '24860-9', '24861-7', '24862-5', '24871-6', '24873-2', '24874-0', '24882-3',
        '24887-2', '24891-4', '24893-0', '24894-8', '24899-7', '24900-3', '24902-9', '24903-7',
        '24908-6', '24909-4', '24910-2', '24911-0', '24912-8', '24913-6', '24916-9', '24917-7',
        '24918-5', '24919-3', '24920-1', '24921-9', '24922-7', '24923-5', '24924-3', '24925-0',
        '24929-2', '24930-0', '24931-8', '24939-1', '24940-9', '24941-7', '24942-5', '24943-3',
        '24944-1', '24945-8', '24946-6', '24947-4', '24948-2', '24969-8', '24970-6', '24971-4',
        '24972-2', '24973-0', '24974-8', '24975-5', '24983-9', '24984-7', '24985-4', '24991-2',
        '24992-0', '24993-8', '24994-6', '24995-3', '24996-1', '24998-7', '25000-1', '25003-5',
        '25006-8', '25011-8', '25012-6', '25013-4', '25016-7', '25017-5', '25020-9', '25022-5',
        '25023-3', '25024-1', '25025-8', '25026-6', '25028-2', '25029-0', '25030-8', '25034-0',
        '25039-9', '25058-9', '25062-1', '25063-9', '25064-7', '25065-4', '25066-2', '25067-0',
        '25068-8', '25069-6', '25070-4', '25071-2', '25073-8', '25074-6', '25076-1', '25077-9',
        '25078-7', '25079-5', '25080-3', '25081-1', '26064-6', '26065-3', '26066-1', '26067-9',
        '26068-7', '26069-5', '26070-3', '26071-1', '26072-9', '26073-7', '26074-5', '26075-2',
        '26076-0', '26077-8', '26078-6', '26079-4', '26080-2', '26081-0', '26082-8', '26083-6',
        '26084-4', '26085-1', '26086-9', '26087-7', '26094-3', '26095-0', '26096-8', '26097-6',
        '26098-4', '26099-2', '26106-5', '26107-3', '26108-1', '26109-9', '26110-7', '26111-5',
        '26112-3', '26113-1', '26114-9', '26115-6', '26116-4', '26117-2', '26118-0', '26120-6',
        '26122-2', '26124-8', '26125-5', '26126-3', '26127-1', '26128-9', '26129-7', '26130-5',
        '26131-3', '26132-1', '26133-9', '26134-7', '26135-4', '26136-2', '26137-0', '26138-8',
        '26139-6', '26140-4', '26141-2', '26142-0', '26143-8', '26144-6', '26146-1', '26148-7',
        '26150-3', '26151-1', '26152-9', '26153-7', '26154-5', '26155-2', '26156-0', '26157-8',
        '26158-6', '26159-4', '26160-2', '26161-0', '26162-8', '26163-6', '26164-4', '26165-1',
        '26166-9', '26167-7', '26168-5', '26169-3', '26170-1', '26171-9', '26172-7', '26173-5',
        '26174-3', '26178-4', '26179-2', '26180-0', '26181-8', '26182-6', '26183-4', '26220-4',
        '26238-6', '26241-0', '26247-7', '26253-5', '26254-3', '26255-0', '26283-2', '26284-0',
        '26285-7', '26295-6', '26296-4', '26297-2', '26298-0', '26299-8', '26300-4', '26301-2',
        '26302-0', '26303-8', '26304-6', '26305-3', '26306-1', '26310-3', '26311-1', '26312-9',
        '26322-8', '26323-6', '26324-4', '26331-9', '26332-7', '26333-5', '26352-5', '26353-3',
        '26354-1', '26355-8', '26356-6', '26357-4', '26358-2', '26359-0', '26360-8', '26361-6',
        '26362-4', '26363-2', '26364-0', '26365-7', '26366-5', '26370-7', '26371-5', '26372-3',
        '26373-1', '26374-9', '26375-6', '26379-8', '26380-6', '26381-4', '26382-2', '26383-0',
        '26384-8', '26385-5', '26386-3', '26387-1', '26388-9', '26389-7', '26390-5', '26391-3',
        '26392-1', '26393-9', '26394-7', '26395-4', '26396-2', '26397-0', '26398-8', '26399-6',
        '26400-2', '26401-0', '26402-8', '28561-9', '28564-3', '28565-0', '28567-6', '28582-5',
        '30593-8', '30594-6', '30623-3', '30628-2', '30629-0', '30630-8', '30631-6', '30632-4',
        '30633-2', '30634-0', '30635-7', '30636-5', '30637-3', '30638-1', '30639-9', '30640-7',
        '30641-5', '30642-3', '30645-6', '30646-4', '30647-2', '30648-0', '30649-8', '30650-6',
        '30713-2', '30714-0', '30715-7', '30716-5', '30717-3', '30719-9', '30720-7', '30721-5',
        '30722-3', '30723-1', '30724-9', '30725-6', '30726-4', '30727-2', '30729-8', '30730-6',
        '30731-4', '30733-0', '30734-8', '30735-5', '30736-3', '30737-1', '30738-9', '30739-7',
        '30740-5', '30741-3', '30742-1', '30743-9', '30744-7', '30745-4', '30746-2', '30747-0',
        '30748-8', '30749-6', '30750-4', '30751-2', '30752-0', '30753-8', '30754-6', '30755-3',
        '30756-1', '30757-9', '30758-7', '30759-5', '30760-3', '30761-1', '30762-9', '30763-7',
        '30764-5', '30765-2', '30766-0', '30767-8', '30768-6', '30769-4', '30770-2', '30771-0',
        '30772-8', '30773-6', '30774-4', '30775-1', '30776-9', '30777-7', '30778-5', '30779-3',
        '30780-1', '30781-9', '30782-7', '30783-5', '30784-3', '30785-0', '30786-8', '30787-6',
        '30788-4', '30789-2', '30790-0', '30791-8', '30792-6', '30793-4', '30797-5', '30804-9',
        '30805-6', '30807-2', '30808-0', '30809-8', '30810-6', '30811-4', '30812-2', '30813-0',
        '30814-8', '30815-5', '30816-3', '30817-1', '30818-9', '30819-7', '30820-5', '30821-3',
        '30822-1', '30823-9', '30824-7', '30825-4', '30828-8', '30829-6', '30830-4', '30831-2',
        '30832-0', '30833-8', '30834-6', '30836-1', '30837-9', '30838-7', '30839-5', '30840-3',
        '30841-1', '30842-9', '30843-7', '30844-5', '30845-2', '30846-0', '30847-8', '30848-6',
        '30849-4', '30850-2', '30851-0', '30852-8', '30856-9', '30858-5', '30859-3', '30861-9',
        '30862-7', '30864-3', '30865-0', '30867-6', '30868-4', '30871-8', '30872-6', '30873-4',
        '30874-2', '30876-7', '30883-3', '30884-1', '30885-8', '30887-4', '30888-2', '30889-0',
        '30890-8', '30891-6', '30892-4', '35881-2', '35882-0', '35883-8', '35885-3', '35888-7',
        '35889-5', '35890-3', '35894-5', '35899-4', '35900-0', '35902-6', '35907-5', '35912-5',
        '35925-7', '35926-5', '35927-3', '35939-8', '35943-0', '35946-3', '35948-9', '35951-3',
        '35959-6', '35963-8', '35964-6', '35965-3', '35967-9', '35969-5', '35970-3', '35972-9',
        '35974-5', '35977-8', '35985-1', '35986-9', '35988-5', '35992-7', '35993-5', '35995-0',
        '36001-6', '36003-2', '36004-0', '36006-5', '36009-9', '36012-3', '36015-6', '36019-8',
        '36024-8', '36032-1', '36038-8', '36039-6', '36040-4', '36041-2', '36042-0', '36043-8',
        '36044-6', '36048-7', '36065-1', '36068-5', '36069-3', '36077-6', '36078-4', '36079-2',
        '36080-0', '36081-8', '36082-6', '36084-2', '36085-9', '36086-7', '36087-5', '36089-1',
        '36090-9', '36092-5', '36095-8', '36097-4', '36098-2', '36099-0', '36102-2', '36103-0',
        '36104-8', '36106-3', '36108-9', '36109-7', '36110-5', '36141-0', '36143-6', '36144-4',
        '36146-9', '36147-7', '36234-3', '36266-5', '36267-3', '36271-5', '36272-3', '36274-9',
        '36275-6', '36293-9', '36294-7', '36295-4', '36296-2', '36297-0', '36298-8', '36299-6',
        '36300-2', '36301-0', '36302-8', '36303-6', '36304-4', '36305-1', '36306-9', '36307-7',
        '36308-5', '36309-3', '36310-1', '36311-9', '36312-7', '36313-5', '36314-3', '36315-0',
        '36316-8', '36317-6', '36318-4', '36320-0', '36321-8', '36322-6', '36323-4', '36324-2',
        '36325-9', '36326-7', '36327-5', '36328-3', '36329-1', '36330-9', '36331-7', '36332-5',
        '36414-1', '36415-8', '36416-6', '36417-4', '36420-8', '36421-6', '36422-4', '36423-2',
        '36424-0', '36431-5', '36432-3', '36433-1', '36450-5', '36496-8', '36543-7', '36544-5',
        '36547-8', '36548-6', '36549-4', '36550-2', '36551-0', '36554-4', '36555-1', '36556-9',
        '36557-7', '36558-5', '36559-3', '36560-1', '36561-9', '36563-5', '36565-0', '36566-8',
        '36567-6', '36568-4', '36569-2', '36570-0', '36571-8', '36572-6', '36573-4', '36574-2',
        '36575-9', '36576-7', '36577-5', '36578-3', '36579-1', '36580-9', '36581-7', '36582-5',
        '36583-3', '36584-1', '36585-8', '36586-6', '36587-4', '36588-2', '36589-0', '36590-8',
        '36591-6', '36592-4', '36593-2', '36594-0', '36595-7', '36596-5', '36597-3', '36598-1',
        '36599-9', '36600-5', '36601-3', '36602-1', '36603-9', '36604-7', '36605-4', '36606-2',
        '36607-0', '36608-8', '36609-6', '36610-4', '36611-2', '36612-0', '36613-8', '36614-6',
        '36615-3', '36616-1', '36617-9', '36618-7', '36619-5', '36620-3', '36621-1', '36622-9',
        '36623-7', '36624-5', '36628-6', '36629-4', '36630-2', '36631-0', '36632-8', '36633-6',
        '36634-4', '36635-1', '36636-9', '36637-7', '36638-5', '36639-3', '36640-1', '36641-9',
        '36643-5', '36644-3', '36645-0', '36646-8', '36647-6', '36648-4', '36649-2', '36650-0',
        '36651-8', '36652-6', '36653-4', '36654-2', '36655-9', '36656-7', '36657-5', '36658-3',
        '36659-1', '36660-9', '36663-3', '36664-1', '36665-8', '36666-6', '36667-4', '36668-2',
        '36669-0', '36670-8', '36671-6', '36672-4', '36673-2', '36674-0', '36675-7', '36676-5',
        '36677-3', '36678-1', '36679-9', '36680-7', '36681-5', '36682-3', '36683-1', '36684-9',
        '36685-6', '36687-2', '36688-0', '36689-8', '36690-6', '36691-4', '36692-2', '36693-0',
        '36694-8', '36695-5', '36696-3', '36697-1', '36698-9', '36699-7', '36700-3', '36702-9',
        '36703-7', '36704-5', '36705-2', '36706-0', '36707-8', '36708-6', '36709-4', '36710-2',
        '36711-0', '36712-8', '36713-6', '36714-4', '36715-1', '36716-9', '36717-7', '36718-5',
        '36719-3', '36720-1', '36721-9', '36722-7', '36723-5', '36724-3', '36725-0', '36726-8',
        '36727-6', '36728-4', '36729-2', '36730-0', '36732-6', '36733-4', '36734-2', '36735-9',
        '36736-7', '36737-5', '36738-3', '36739-1', '36740-9', '36741-7', '36742-5', '36743-3',
        '36744-1', '36745-8', '36746-6', '36747-4', '36748-2', '36749-0', '36750-8', '36751-6',
        '36752-4', '36753-2', '36754-0', '36755-7', '36756-5', '36757-3', '36758-1', '36759-9',
        '36760-7', '36761-5', '36762-3', '36763-1', '36764-9', '36765-6', '36766-4', '36771-4',
        '36776-3', '36781-3', '36782-1', '36783-9', '36784-7', '36785-4', '36786-2', '36787-0',
        '36788-8', '36789-6', '36790-4', '36791-2', '36792-0', '36794-6', '36795-3', '36796-1',
        '36797-9', '36798-7', '36799-5', '36800-1', '36801-9', '36802-7', '36803-5', '36804-3',
        '36805-0', '36806-8', '36807-6', '36808-4', '36809-2', '36813-4', '36814-2', '36826-6',
        '36827-4', '36828-2', '36830-8', '36831-6', '36832-4', '36833-2', '36834-0', '36838-1',
        '36839-9', '36846-4', '36847-2', '36848-0', '36849-8', '36850-6', '36851-4', '36852-2',
        '36853-0', '36854-8', '36855-5', '36857-1', '36858-9', '36859-7', '36860-5', '36861-3',
        '36862-1', '36863-9', '36864-7', '36865-4', '36876-1', '36877-9', '36878-7', '36879-5',
        '36881-1', '36882-9', '36883-7', '36886-0', '36887-8', '36890-2', '36893-6', '36894-4',
        '36937-1', '36938-9', '36945-4', '36946-2', '36947-0', '36948-8', '36949-6', '36952-0',
        '36958-7', '36959-5', '36960-3', '36961-1', '36963-7', '36964-5', '36965-2', '36966-0',
        '36967-8', '36968-6', '36971-0', '36972-8', '36973-6', '36974-4', '36976-9', '36978-5',
        '36979-3', '36980-1', '36981-9', '36982-7', '36983-5', '36984-3', '36985-0', '36986-8',
        '36987-6', '36988-4', '36989-2', '36990-0', '36991-8', '36992-6', '36993-4', '36994-2',
        '36995-9', '36996-7', '36997-5', '36998-3', '36999-1', '37000-7', '37001-5', '37002-3',
        '37003-1', '37004-9', '37007-2', '37008-0', '37009-8', '37010-6', '37011-4', '37012-2',
        '37013-0', '37014-8', '37015-5', '37018-9', '37019-7', '37020-5', '37024-7', '37025-4',
        '37026-2', '37027-0', '37031-2', '37032-0', '37033-8', '37034-6', '37035-3', '37039-5',
        '37040-3', '37041-1', '37042-9', '37043-7', '37044-5', '37045-2', '37046-0', '37047-8',
        '37048-6', '37049-4', '37050-2', '37051-0', '37054-4', '37055-1', '37056-9', '37057-7',
        '37059-3', '37060-1', '37062-7', '37063-5', '37064-3', '37066-8', '37067-6', '37068-4',
        '37069-2', '37070-0', '37071-8', '37072-6', '37073-4', '37074-2', '37075-9', '37076-7',
        '37077-5', '37078-3', '37079-1', '37080-9', '37081-7', '37082-5', '37083-3', '37084-1',
        '37085-8', '37086-6', '37087-4', '37088-2', '37089-0', '37090-8', '37091-6', '37092-4',
        '37093-2', '37094-0', '37095-7', '37096-5', '37097-3', '37098-1', '37099-9', '37100-5',
        '37101-3', '37102-1', '37103-9', '37104-7', '37105-4', '37106-2', '37107-0', '37108-8',
        '37109-6', '37110-4', '37111-2', '37112-0', '37113-8', '37114-6', '37115-3', '37116-1',
        '37117-9', '37118-7', '37119-5', '37120-3', '37121-1', '37122-9', '37123-7', '37124-5',
        '37125-2', '37126-0', '37127-8', '37128-6', '37131-0', '37132-8', '37133-6', '37134-4',
        '37135-1', '37136-9', '37137-7', '37138-5', '37139-3', '37140-1', '37141-9', '37142-7',
        '37143-5', '37144-3', '37145-0', '37146-8', '37147-6', '37148-4', '37149-2', '37150-0',
        '37151-8', '37152-6', '37153-4', '37154-2', '37155-9', '37156-7', '37157-5', '37158-3',
        '37159-1', '37160-9', '37161-7', '37162-5', '37163-3', '37164-1', '37165-8', '37166-6',
        '37167-4', '37168-2', '37169-0', '37170-8', '37171-6', '37172-4', '37173-2', '37174-0',
        '37175-7', '37176-5', '37177-3', '37178-1', '37179-9', '37180-7', '37181-5', '37182-3',
        '37183-1', '37184-9', '37185-6', '37186-4', '37187-2', '37188-0', '37189-8', '37190-6',
        '37191-4', '37192-2', '37193-0', '37195-5', '37196-3', '37197-1', '37198-9', '37199-7',
        '37200-3', '37201-1', '37202-9', '37203-7', '37204-5', '37207-8', '37208-6', '37209-4',
        '37219-3', '37227-6', '37229-2', '37233-4', '37235-9', '37254-0', '37256-5', '37257-3',
        '37259-9', '37260-7', '37261-5', '37277-1', '37297-9', '37298-7', '37299-5', '37300-1',
        '37302-7', '37303-5', '37304-3', '37319-1', '37320-9', '37321-7', '37323-3', '37324-1',
        '37325-8', '37332-4', '37338-1', '37340-7', '37341-5', '37342-3', '37348-0', '37350-6',
        '37351-4', '37353-0', '37355-5', '37356-3', '37357-1', '37361-3', '37362-1', '37364-7',
        '37365-4', '37366-2', '37379-5', '37380-3', '37381-1', '37382-9', '37383-7', '37384-5',
        '37385-2', '37386-0', '37387-8', '37388-6', '37389-4', '37390-2', '37391-0', '37392-8',
        '37393-6', '37394-4', '37395-1', '37396-9', '37397-7', '37398-5', '37399-3', '37401-7',
        '37402-5', '37403-3', '37404-1', '37405-8', '37406-6', '37407-4', '37409-0', '37410-8',
        '37411-6', '37412-4', '37413-2', '37414-0', '37415-7', '37416-5', '37419-9', '37420-7',
        '37421-5', '37422-3', '37423-1', '37426-4', '37429-8', '37432-2', '37442-1', '37443-9',
        '37454-6', '37455-3', '37467-8', '37468-6', '37469-4', '37470-2', '37471-0', '37472-8',
        '37473-6', '37474-4', '37475-1', '37476-9', '37477-7', '37481-9', '37482-7', '37483-5',
        '37484-3', '37485-0', '37486-8', '37487-6', '37488-4', '37489-2', '37490-0', '37494-2',
        '37497-5', '37498-3', '37500-6', '37501-4', '37502-2', '37503-0', '37505-5', '37506-3',
        '37507-1', '37508-9', '37510-5', '37511-3', '37512-1', '37513-9', '37514-7', '37515-4',
        '37516-2', '37517-0', '37518-8', '37519-6', '37520-4', '37521-2', '37522-0', '37523-8',
        '37524-6', '37530-3', '37531-1', '37532-9', '37533-7', '37534-5', '37535-2', '37538-6',
        '37540-2', '37541-0', '37544-4', '37545-1', '37546-9', '37547-7', '37548-5', '37549-3',
        '37550-1', '37555-0', '37556-8', '37557-6', '37558-4', '37559-2', '37560-0', '37561-8',
        '37562-6', '37563-4', '37564-2', '37565-9', '37566-7', '37567-5', '37568-3', '37569-1',
        '37570-9', '37571-7', '37574-1', '37575-8', '37576-6', '37577-4', '37578-2', '37579-0',
        '37580-8', '37581-6', '37582-4', '37583-2', '37584-0', '37585-7', '37586-5', '37587-3',
        '37588-1', '37589-9', '37590-7', '37591-5', '37592-3', '37593-1', '37594-9', '37595-6',
        '37596-4', '37597-2', '37598-0', '37599-8', '37600-4', '37601-2', '37602-0', '37603-8',
        '37604-6', '37605-3', '37606-1', '37607-9', '37609-5', '37611-1', '37612-9', '37613-7',
        '37614-5', '37615-2', '37616-0', '37617-8', '37618-6', '37619-4', '37620-2', '37621-0',
        '37622-8', '37623-6', '37624-4', '37625-1', '37626-9', '37627-7', '37628-5', '37629-3',
        '37630-1', '37631-9', '37632-7', '37633-5', '37634-3', '37635-0', '37636-8', '37637-6',
        '37639-2', '37640-0', '37641-8', '37642-6', '37643-4', '37644-2', '37645-9', '37646-7',
        '37647-5', '37648-3', '37649-1', '37650-9', '37651-7', '37652-5', '37653-3', '37654-1',
        '37655-8', '37656-6', '37658-2', '37659-0', '37660-8', '37661-6', '37662-4', '37663-2',
        '37664-0', '37665-7', '37666-5', '37667-3', '37668-1', '37669-9', '37670-7', '37671-5',
        '37672-3', '37673-1', '37674-9', '37675-6', '37676-4', '37677-2', '37678-0', '37679-8',
        '37680-6', '37681-4', '37682-2', '37683-0', '37684-8', '37685-5', '37686-3', '37687-1',
        '37688-9', '37689-7', '37690-5', '37691-3', '37692-1', '37693-9', '37694-7', '37695-4',
        '37696-2', '37697-0', '37698-8', '37699-6', '37700-2', '37701-0', '37702-8', '37703-6',
        '37704-4', '37705-1', '37706-9', '37707-7', '37708-5', '37709-3', '37710-1', '37711-9',
        '37712-7', '37713-5', '37714-3', '37715-0', '37716-8', '37717-6', '37721-8', '37722-6',
        '37723-4', '37724-2', '37725-9', '37726-7', '37727-5', '37728-3', '37729-1', '37730-9',
        '37731-7', '37732-5', '37733-3', '37734-1', '37735-8', '37736-6', '37737-4', '37738-2',
        '37739-0', '37740-8', '37741-6', '37742-4', '37743-2', '37744-0', '37745-7', '37746-5',
        '37747-3', '37748-1', '37749-9', '37750-7', '37751-5', '37752-3', '37753-1', '37754-9',
        '37755-6', '37756-4', '37757-2', '37758-0', '37759-8', '37760-6', '37761-4', '37762-2',
        '37763-0', '37764-8', '37765-5', '37766-3', '37767-1', '37776-2', '37777-0', '37778-8',
        '37779-6', '37780-4', '37781-2', '37782-0', '37783-8', '37784-6', '37785-3', '37786-1',
        '37787-9', '37788-7', '37789-5', '37790-3', '37791-1', '37792-9', '37793-7', '37794-5',
        '37795-2', '37796-0', '37797-8', '37798-6', '37799-4', '37800-0', '37801-8', '37802-6',
        '37803-4', '37804-2', '37805-9', '37806-7', '37807-5', '37808-3', '37809-1', '37810-9',
        '37811-7', '37812-5', '37813-3', '37814-1', '37815-8', '37816-6', '37817-4', '37818-2',
        '37819-0', '37820-8', '37821-6', '37822-4', '37823-2', '37824-0', '37825-7', '37826-5',
        '37827-3', '37828-1', '37829-9', '37830-7', '37831-5', '37832-3', '37833-1', '37834-9',
        '37835-6', '37836-4', '37839-8', '37840-6', '37841-4', '37842-2', '37843-0', '37844-8',
        '37845-5', '37846-3', '37847-1', '37848-9', '37849-7', '37850-5', '37851-3', '37852-1',
        '37853-9', '37854-7', '37855-4', '37856-2', '37857-0', '37858-8', '37859-6', '37860-4',
        '37861-2', '37862-0', '37863-8', '37864-6', '37866-1', '37867-9', '37868-7', '37869-5',
        '37870-3', '37871-1', '37872-9', '37874-5', '37880-2', '37881-0', '37882-8', '37883-6',
        '37884-4', '37885-1', '37886-9', '37887-7', '37888-5', '37889-3', '37890-1', '37891-9',
        '37892-7', '37893-5', '37894-3', '37895-0', '37896-8', '37897-6', '37898-4', '37899-2',
        '37900-8', '37901-6', '37902-4', '37903-2', '37904-0', '37905-7', '37906-5', '37907-3',
        '37908-1', '37909-9', '37910-7', '37911-5', '37922-2', '37923-0', '37924-8', '37925-5',
        '37926-3', '37927-1', '37928-9', '37929-7', '37930-5', '37931-3', '37932-1', '37933-9',
        '37934-7', '37935-4', '37936-2', '37937-0', '37938-8', '37939-6', '37940-4', '37941-2',
        '37942-0', '37943-8', '37944-6', '37945-3', '37947-9', '37948-7', '37949-5', '37950-3',
        '37952-9', '37953-7', '37954-5', '37958-6', '37959-4', '37960-2', '37961-0', '37962-8',
        '37963-6', '37964-4', '37965-1', '37966-9', '37967-7', '37968-5', '37969-3', '37970-1',
        '37971-9', '37972-7', '37973-5', '37974-3', '37975-0', '37976-8', '37977-6', '37979-2',
        '37980-0', '37981-8', '37994-1', '37998-2', '37999-0', '38000-6', '38001-4', '38002-2',
        '38003-0', '38004-8', '38006-3', '38007-1', '38008-9', '38009-7', '38010-5', '38065-9',
        '38066-7', '38068-3', '38069-1', '38073-3', '38074-1', '38082-4', '38083-2', '38084-0',
        '38086-5', '38087-3', '38088-1', '38089-9', '38092-3', '38093-1', '38094-9', '38097-2',
        '38098-0', '38099-8', '38100-4', '38101-2', '38102-0', '38103-8', '38104-6', '38105-3',
        '38107-9', '38108-7', '38112-9', '38113-7', '38114-5', '38115-2', '38116-0', '38117-8',
        '38118-6', '38119-4', '38120-2', '38121-0', '38123-6', '38124-4', '38125-1', '38144-2',
        '38145-9', '38146-7', '38147-5', '38148-3', '38149-1', '38150-9', '38151-7', '38152-5',
        '38153-3', '38154-1', '38155-8', '38156-6', '38181-4', '38768-8', '38771-2', '38772-0',
        '38773-8', '38774-6', '38775-3', '38777-9', '38779-5', '38780-3', '38781-1', '38782-9',
        '38783-7', '38784-5', '38785-2', '38786-0', '38787-8', '38788-6', '38789-4', '38790-2',
        '38791-0', '38792-8', '38793-6', '38794-4', '38795-1', '38796-9', '38797-7', '38798-5',
        '38799-3', '38800-9', '38801-7', '38803-3', '38804-1', '38805-8', '38806-6', '38808-2',
        '38810-8', '38811-6', '38812-4', '38813-2', '38815-7', '38816-5', '38818-1', '38819-9',
        '38822-3', '38824-9', '38826-4', '38827-2', '38837-1', '38838-9', '38839-7', '38840-5',
        '38841-3', '38842-1', '38843-9', '38844-7', '38845-4', '38846-2', '38847-0', '38848-8',
        '38849-6', '38850-4', '38851-2', '38852-0', '38853-8', '38856-1', '38857-9', '38858-7',
        '38859-5', '38860-3', '38861-1', '38862-9', '38863-7', '38864-5', '38865-2', '38866-0',
        '38867-8', '38868-6', '38869-4', '38871-0', '38872-8', '38873-6', '38874-4', '39027-8',
        '39046-8', '39047-6', '39048-4', '39049-2', '39050-0', '39051-8', '39053-4', '39055-9',
        '39056-7', '39057-5', '39058-3', '39059-1', '39060-9', '39061-7', '39062-5', '39063-3',
        '39064-1', '39065-8', '39066-6', '39067-4', '39068-2', '39069-0', '39070-8', '39071-6',
        '39072-4', '39073-2', '39074-0', '39075-7', '39076-5', '39077-3', '39078-1', '39079-9',
        '39093-0', '39094-8', '39095-5', '39096-3', '39097-1', '39098-9', '39099-7', '39100-3',
        '39101-1', '39138-3', '39144-1', '39149-0', '39151-6', '39321-5', '39323-1', '39324-9',
        '39325-6', '39326-4', '39327-2', '39328-0', '39329-8', '39330-6', '39331-4', '39332-2',
        '39333-0', '39334-8', '39335-5', '39336-3', '39337-1', '39338-9', '39339-7', '39340-5',
        '39341-3', '39343-9', '39344-7', '39345-4', '39346-2', '39347-0', '39348-8', '39349-6',
        '39350-4', '39351-2', '39352-0', '39353-8', '39359-5', '39360-3', '39361-1', '39362-9',
        '39363-7', '39364-5', '39365-2', '39366-0', '39367-8', '39368-6', '39369-4', '39370-2',
        '39371-0', '39372-8', '39373-6', '39374-4', '39375-1', '39376-9', '39377-7', '39378-5',
        '39379-3', '39380-1', '39381-9', '39382-7', '39383-5', '39384-3', '39385-0', '39386-8',
        '39387-6', '39388-4', '39389-2', '39390-0', '39391-8', '39392-6', '39393-4', '39394-2',
        '39395-9', '39396-7', '39397-5', '39398-3', '39399-1', '39400-7', '39401-5', '39402-3',
        '39403-1', '39404-9', '39405-6', '39406-4', '39407-2', '39408-0', '39409-8', '39410-6',
        '39411-4', '39412-2', '39413-0', '39414-8', '39489-0', '39490-8', '39491-6', '39492-4',
        '39493-2', '39510-3', '39511-1', '39512-9', '39513-7', '39514-5', '39515-2', '39516-0',
        '39517-8', '39518-6', '39519-4', '39520-2', '39521-0', '41773-3', '41774-1', '41775-8',
        '41776-6', '41777-4', '41778-2', '41779-0', '41782-4', '41783-2', '41784-0', '41785-7',
        '41786-5', '41787-3', '41788-1', '41789-9', '41790-7', '41791-5', '41792-3', '41793-1',
        '41797-2', '41799-8', '41800-4', '41801-2', '41802-0', '41803-8', '41811-1', '41817-8',
        '41818-6', '41819-4', '41820-2', '41823-6', '41824-4', '41825-1', '41826-9', '41827-7',
        '41828-5', '41829-3', '41830-1', '41831-9', '41832-7', '42007-5', '42008-3', '42009-1',
        '42010-9', '42011-7', '42012-5', '42014-1', '42017-4', '42019-0', '42153-7', '42156-0',
        '42157-8', '42159-4', '42160-2', '42162-8', '42163-6', '42164-4', '42165-1', '42167-7',
        '42269-1', '42272-5', '42273-3', '42274-1', '42291-5', '42293-1', '42294-9', '42295-6',
        '42304-6', '42311-1', '42312-9', '42313-7', '42314-5', '42334-3', '42335-0', '42378-0',
        '42379-8', '42380-6', '42381-4', '42382-2', '42383-0', '42395-4', '42396-2', '42397-0',
        '42398-8', '42399-6', '42400-2', '42401-0', '42402-8', '42403-6', '42404-4', '42405-1',
        '42406-9', '42407-7', '42408-5', '42409-3', '42410-1', '42411-9', '42412-7', '42413-5',
        '42414-3', '42417-6', '42418-4', '42419-2', '42420-0', '42421-8', '42422-6', '42423-4',
        '42424-2', '42425-9', '42426-7', '42427-5', '42428-3', '42429-1', '42430-9', '42431-7',
        '42432-5', '42434-1', '42435-8', '42436-6', '42437-4', '42438-2', '42439-0', '42441-6',
        '42443-2', '42444-0', '42445-7', '42446-5', '42459-8', '42460-6', '42469-7', '42470-5',
        '42471-3', '42472-1', '42473-9', '42474-7', '42681-7', '42683-3', '42684-1', '42685-8',
        '42686-6', '42687-4', '42690-8', '42691-6', '42692-4', '42699-9', '42702-1', '42703-9',
        '42710-4', '42811-0', '42812-8', '42813-6', '42814-4', '43458-9', '43463-9', '43464-7',
        '43466-2', '43467-0', '43468-8', '43469-6', '43470-4', '43471-2', '43472-0', '43473-8',
        '43474-6', '43475-3', '43476-1', '43477-9', '43478-7', '43479-5', '43480-3', '43481-1',
        '43482-9', '43483-7', '43485-2', '43486-0', '43488-6', '43489-4', '43490-2', '43491-0',
        '43492-8', '43493-6', '43494-4', '43495-1', '43496-9', '43497-7', '43498-5', '43499-3',
        '43512-3', '43513-1', '43514-9', '43515-6', '43516-4', '43517-2', '43518-0', '43519-8',
        '43521-4', '43522-2', '43523-0', '43524-8', '43529-7', '43532-1', '43536-2', '43537-0',
        '43538-8', '43539-6', '43543-8', '43554-5', '43556-0', '43558-6', '43559-4', '43561-0',
        '43569-3', '43570-1', '43574-3', '43641-0', '43761-6', '43762-4', '43763-2', '43764-0',
        '43778-0', '43779-8', '43780-6', '43781-4', '43782-2', '43783-0', '43784-8', '43785-5',
        '43787-1', '43788-9', '43790-5', '43791-3', '43792-1', '43793-9', '43794-7', '43795-4',
        '43796-2', '44115-4', '44116-2', '44128-7', '44129-5', '44130-3', '44131-1', '44132-9',
        '44133-7', '44134-5', '44135-2', '44176-6', '44177-4', '44178-2', '44179-0', '44181-6',
        '44182-4', '44183-2', '44184-0', '44185-7', '44186-5', '44187-3', '44188-1', '44189-9',
        '44190-7', '44191-5', '44192-3', '44193-1', '44194-9', '44195-6', '44196-4', '44197-2',
        '44198-0', '44199-8', '44201-2', '44202-0', '44203-8', '44204-6', '44205-3', '44206-1',
        '44208-7', '44209-5', '44210-3', '44211-1', '44212-9', '44213-7', '44214-5', '44215-2',
        '44216-0', '44217-8', '44218-6', '44219-4', '44220-2', '44221-0', '44222-8', '44223-6',
        '44224-4', '44225-1', '44226-9', '44227-7', '44229-3', '44230-1', '44231-9', '44239-2',
        '44240-0', '46294-5', '46304-2', '46307-5', '46308-3', '46309-1', '46312-5', '46324-0',
        '46340-6', '46341-4', '46343-0', '46344-8', '46345-5', '46346-3', '46347-1', '46348-9',
        '46349-7', '46357-0', '46359-6', '46360-4', '46371-1', '46372-9', '46376-0', '46377-8',
        '46378-6', '46381-0', '46386-9', '46389-3', '46390-1', '46391-9', '46392-7', '47366-0',
        '47367-8', '47368-6', '47370-2', '47371-0', '47372-8', '47373-6', '47374-4', '47375-1',
        '47376-9', '47377-7', '47379-3', '47380-1', '47381-9', '47382-7', '47983-2', '47984-0',
        '47986-5', '47987-3', '48435-2', '48462-6', '48463-4', '48464-2', '48465-9', '48466-7',
        '48467-5', '48468-3', '48469-1', '48470-9', '48471-7', '48472-5', '48473-3', '48474-1',
        '48476-6', '48477-4', '48478-2', '48479-0', '48480-8', '48481-6', '48482-4', '48483-2',
        '48484-0', '48485-7', '48486-5', '48487-3', '48488-1', '48489-9', '48490-7', '48491-5',
        '48695-1', '48696-9', '48697-7', '48698-5', '48699-3', '48737-1', '48738-9', '48743-9',
        '48746-2', '48747-0', '48749-6', '49511-9', '49512-7', '49565-5', '49570-5', '51387-9',
        '51388-7', '51391-1', '51392-9', '51394-5', '51395-2', '58746-9', '62446-0', '62447-8',
        '62448-6', '62449-4', '62450-2', '62491-6', '62492-4', '64140-7', '64141-5', '64995-4',
        '64996-2', '64997-0', '64998-8', '64999-6', '65000-2', '65797-3', '65798-1', '65799-9',
        '65800-5', '65801-3', '69054-5', '69055-2', '69056-0', '69057-8', '69058-6', '69059-4',
        '69060-2', '69061-0', '69062-8', '69063-6', '69064-4', '69065-1', '69066-9', '69067-7',
        '69069-3', '69070-1', '69071-9', '69072-7', '69073-5', '69074-3', '69075-0', '69076-8',
        '69077-6', '69078-4', '69079-2', '69080-0', '69081-8', '69084-2', '69096-6', '69119-6',
        '69120-4', '69121-2', '69122-0', '69123-8', '69124-6', '69125-3', '69126-1', '69127-9',
        '69128-7', '69129-5', '69130-3', '69131-1', '69132-9', '69133-7', '69134-5', '69135-2',
        '69136-0', '69137-8', '69138-6', '69139-4', '69140-2', '69141-0', '69142-8', '69143-6',
        '69144-4', '69145-1', '69146-9', '69147-7', '69148-5', '69149-3', '69151-9', '69152-7',
        '69153-5', '69154-3', '69155-0', '69156-8', '69157-6', '69158-4', '69159-2', '69161-8',
        '69162-6', '69224-4', '69225-1', '69226-9', '69228-5', '69239-2', '69240-0', '69241-8',
        '69242-6', '69243-4', '69244-2', '69245-9', '69246-7', '69247-5', '69248-3', '69249-1',
        '69250-9', '69252-5', '69253-3', '69254-1', '69255-8', '69256-6', '69257-4', '69258-2',
        '69260-8', '69261-6', '69262-4', '69263-2', '69264-0', '69265-7', '69266-5', '69267-3',
        '69269-9', '69270-7', '69271-5', '69272-3', '69273-1', '69274-9', '69275-6', '69301-0',
        '69302-8', '69303-6', '69304-4', '69305-1', '69306-9', '69307-7', '69308-5', '69309-3',
        '69310-1', '69312-7', '69313-5', '69314-3', '69315-0', '69316-8', '69317-6', '69318-4',
        '69320-0', '69321-8', '70918-8', '70919-6', '70920-4', '70923-8', '70924-6', '70925-3',
        '70933-7', '8294-1', '8295-8', '8296-6'
    }


class MeaslesAntibodyTestIggAntibodyTiter(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1059'
    VALUE_SET_NAME = 'Measles Antibody Test (IgG Antibody Titer)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'21500-4', '21501-2', '22501-1', '22502-9'}


class MeaslesAntibodyTestIggAntibodyPresence(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1060'
    VALUE_SET_NAME = 'Measles Antibody Test (IgG Antibody presence)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'20479-2', '35275-7', '40648-8', '41132-2', '53536-9'}


class MumpsAntibodyTestIggAntibodyTiter(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1061'
    VALUE_SET_NAME = 'Mumps Antibody Test (IgG Antibody Titer)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'21401-5', '22416-2', '22417-0', '6477-4'}


class MumpsAntibodyTestIggAntibodyPresence(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1062'
    VALUE_SET_NAME = 'Mumps Antibody Test (IgG Antibody presence)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'22415-4', '39011-2', '40737-9', '6476-6', '74422-7'}


class RubellaAntibodyTestIggAntibodyTiter(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1063'
    VALUE_SET_NAME = 'Rubella Antibody Test (IgG Antibody Titer)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'41763-4', '46110-3'}


class RubellaAntibodyTestIggAntibodyPresence(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1064'
    VALUE_SET_NAME = 'Rubella Antibody Test (IgG Antibody presence)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'25514-1', '39013-8', '40667-8', '40668-6', '63462-6', '74415-1'}


class VaricellaZosterAntibodyTestIggAntibodyTiter(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1066'
    VALUE_SET_NAME = 'Varicella Zoster Antibody Test (IgG Antibody Titer)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'21595-4', '22601-9', '22602-7', '6569-8'}


class VaricellaZosterAntibodyTestIggAntibodyPresence(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1067'
    VALUE_SET_NAME = 'Varicella Zoster Antibody Test (IgG Antibody Presence)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'15410-4', '19162-7', '41512-5', '42537-1', '53534-4'}


class HistoryOfBilateralMastectomy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1068'
    VALUE_SET_NAME = 'History of bilateral mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'Z9013'}

    SNOMEDCT = {'428529004'}


class StatusPostLeftMastectomy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1069'
    VALUE_SET_NAME = 'Status Post Left Mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'Z9012'}

    SNOMEDCT = {'429009003'}


class StatusPostRightMastectomy(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1070'
    VALUE_SET_NAME = 'Status Post Right Mastectomy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'Z9011'}

    SNOMEDCT = {'429242008'}


class UnilateralMastectomyUnspecifiedLaterality(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1071'
    VALUE_SET_NAME = 'Unilateral Mastectomy, Unspecified Laterality'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'Z9010'}

    ICD9CM = {'V4571'}

    SNOMEDCT = {'22964006', '248802009', '72269009', '73359007', '8115005', '88764002'}


class AntiHepatitisBVirusSurfaceAb(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1073'
    VALUE_SET_NAME = 'Anti Hepatitis B Virus Surface Ab'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'10900-9', '22322-2', '39535-0', '48070-7', '49177-9', '75409-3'}


class MajorOrganTransplantOtherThanKidney(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.198.12.1075'
    VALUE_SET_NAME = 'Major Organ Transplant Other Than Kidney'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '32850', '32851', '32852', '32853', '32854', '32855', '32856', '33930', '33933', '33935',
        '33940', '33944', '33945', '44132', '44133', '44135', '44136', '44137', '44715', '44720',
        '44721', '47133', '47135', '47140', '47141', '47142', '47143', '47144', '47145', '47146',
        '47147', '48160', '48550', '48551', '48552', '48554', '48556'
    }

    HCPCS = {'S2053', 'S2054', 'S2055', 'S2060', 'S2061', 'S2152'}


class AnaphylacticReactionToRotavirusVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1021'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Rotavirus Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428331000124103'}


class AnaphylacticReactionToInfluenzaVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1022'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'420113004'}


class AnaphylacticReactionToInactivatedPolioVaccineIpv(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1023'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Inactivated Polio Vaccine (IPV)'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'293117006'}


class AnaphylacticReactionToNeomycin(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1024'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Neomycin'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'292927007'}


class AnaphylacticReactionToPolymyxin(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1025'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Polymyxin'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'292992006'}


class AnaphylacticReactionToHepatitisAVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1026'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Hepatitis A Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'293126009'}


class AnaphylacticReactionToPneumococcalConjugateVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1027'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Pneumococcal Conjugate Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'293116002'}


class AnaphylacticReactionToStreptomycin(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1028'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Streptomycin'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'292925004'}


class AnaphylacticReactionToHepatitisBVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1029'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Hepatitis B Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428321000124101'}


class AnaphylacticReactionToHemophilusInfluenzaBHibVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1030'
    VALUE_SET_NAME = 'Anaphylactic Reaction to Hemophilus Influenza B (HiB) Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'433621000124101'}


class AnaphylacticReactionToDtapVaccine(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1031'
    VALUE_SET_NAME = 'Anaphylactic Reaction to DTaP Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'219084006', '293108006', '428281000124107', '428291000124105'}


class AnaphylacticReactionToCommonBakersYeast(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1032'
    VALUE_SET_NAME = "Anaphylactic Reaction to Common Baker's Yeast"
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'34015007', '419447004'}


class Intussusception(ValueSet):
    """

    Clinical Focus:
    Data Element Scope:
    Inclusion Criteria:
    Exclusion Criteria:
    """

    OID = '2.16.840.1.113883.3.464.1003.199.12.1056'
    VALUE_SET_NAME = 'Intussusception'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'K561'}

    SNOMEDCT = {
        '111361008', '11578004', '17186003', '197046003', '197047007', '197048002', '197049005',
        '197050005', '197051009', '197052002', '197053007', '197054001', '24610009', '27673007',
        '313326008', '313327004', '405558008', '49723003', '91446004'
    }


class AnnualWellnessVisit(ValueSet):
    """

    Clinical Focus: This value set contains concepts related to annual wellness visits.
    Data Element Scope: The intent of this data element is to identify patients who have had an annual wellness visit. Using the Quality Data Model, this particular data element would be classified under the 'Encounter' category.
    Inclusion Criteria: Includes encounters specific to annual wellness visits.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.526.2.1363'
    VALUE_SET_NAME = 'Annual Wellness Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    HCPCS = {'G0438', 'G0439'}


class ChronicKidneyDiseaseStage5(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1002'
    VALUE_SET_NAME = 'Chronic Kidney Disease, Stage 5'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'N185'}

    ICD9CM = {'5855'}

    SNOMEDCT = {'433146000'}


class Proteinuria(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1003'
    VALUE_SET_NAME = 'Proteinuria'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'R801', 'R808', 'R809'}

    ICD9CM = {'7910'}

    SNOMEDCT = {
        '12178007', '167582007', '263808002', '264867001', '274769005', '29738008', '312975006',
        '34993002'
    }


class DementiaMentalDegenerations(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1005'
    VALUE_SET_NAME = 'Dementia & Mental Degenerations'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'A5217', 'F0150', 'F0151', 'F0280', 'F0281', 'F0390', 'F0391', 'F05', 'F068', 'G300',
        'G301', 'G308', 'G309', 'G3101', 'G3109', 'G3183'
    }

    ICD9CM = {
        '0941', '2900', '29010', '29011', '29012', '29013', '29020', '29021', '2903', '29040',
        '29041', '29042', '29043', '2908', '2909', '29410', '29411', '29420', '29421', '2948',
        '3310', '33111', '33119', '33182'
    }

    SNOMEDCT = {
        '10349009', '10532003', '111480006', '12348006', '14070001', '15662003', '191449005',
        '191451009', '191452002', '191454001', '191455000', '191457008', '191458003', '191459006',
        '191461002', '191463004', '191464005', '191465006', '191466007', '191493005', '230270009',
        '230283005', '230286002', '230287006', '230288001', '230290000', '25772007', '26852004',
        '278857002', '279982005', '281004', '312991009', '32875003', '371024007', '371026009',
        '416780008', '420614009', '421023003', '421529006', '425390006', '429998004', '442344002',
        '4817008', '51928006', '52448006', '54502004', '55009008', '56267009', '59651006',
        '62239001', '6475002', '65096006', '66108005', '70936005', '82959004', '90099008'
    }


class StandardizedToolsForAssessmentOfCognition(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1006'
    VALUE_SET_NAME = 'Standardized Tools for Assessment of Cognition'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '58151-2', '71492-3', '71493-1', '71722-3', '72106-8', '72172-0', '72173-8', '72233-0'
    }


class MedicalReason(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1007'
    VALUE_SET_NAME = 'Medical Reason'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '183932001', '183964008', '183966005', '216952002', '266721009', '269191009', '274512008',
        '31438003', '35688006', '371133007', '397745006', '407563006', '410534003', '410536001',
        '416098002', '416406003', '428119001', '445528004', '59037007', '62014003', '79899007'
    }


class PatientReason(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1008'
    VALUE_SET_NAME = 'Patient Reason'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '105480006', '160932005', '160934006', '182890002', '182895007', '182897004', '182900006',
        '182902003', '183944003', '183945002', '184081006', '185479006', '185481008', '224187001',
        '225928004', '266710000', '266966009', '275694009', '275936005', '281399006', '310343007',
        '373787003', '385648002', '406149000', '408367005', '413310006', '413311005', '413312003',
        '416432009', '423656007', '424739004', '443390004', '713247000'
    }


class SystemReason(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1009'
    VALUE_SET_NAME = 'System Reason'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '107724000', '182856006', '182857002', '185335007', '224194003', '224198000', '224199008',
        '242990004', '266756008', '270459005', '309017000', '309846006', '419808006', '424553001'
    }


class Cancer(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1010'
    VALUE_SET_NAME = 'Cancer'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'C000', 'C001', 'C002', 'C003', 'C004', 'C005', 'C006', 'C008', 'C009', 'C01', 'C020',
        'C021', 'C022', 'C023', 'C024', 'C028', 'C029', 'C030', 'C031', 'C039', 'C040', 'C041',
        'C048', 'C049', 'C050', 'C051', 'C052', 'C058', 'C059', 'C060', 'C061', 'C062', 'C0680',
        'C0689', 'C069', 'C07', 'C080', 'C081', 'C089', 'C090', 'C091', 'C098', 'C099', 'C100',
        'C101', 'C102', 'C103', 'C104', 'C108', 'C109', 'C110', 'C111', 'C112', 'C113', 'C118',
        'C119', 'C12', 'C130', 'C131', 'C132', 'C138', 'C139', 'C140', 'C142', 'C148', 'C153',
        'C154', 'C155', 'C158', 'C159', 'C160', 'C161', 'C162', 'C163', 'C164', 'C165', 'C166',
        'C168', 'C169', 'C170', 'C171', 'C172', 'C173', 'C178', 'C179', 'C180', 'C181', 'C182',
        'C183', 'C184', 'C185', 'C186', 'C187', 'C188', 'C189', 'C19', 'C20', 'C210', 'C211',
        'C212', 'C218', 'C220', 'C221', 'C222', 'C223', 'C224', 'C227', 'C228', 'C229', 'C23',
        'C240', 'C241', 'C248', 'C249', 'C250', 'C251', 'C252', 'C253', 'C254', 'C257', 'C258',
        'C259', 'C260', 'C261', 'C269', 'C300', 'C301', 'C310', 'C311', 'C312', 'C313', 'C318',
        'C319', 'C320', 'C321', 'C322', 'C323', 'C328', 'C329', 'C33', 'C3400', 'C3401', 'C3402',
        'C3410', 'C3411', 'C3412', 'C342', 'C3430', 'C3431', 'C3432', 'C3480', 'C3481', 'C3482',
        'C3490', 'C3491', 'C3492', 'C37', 'C380', 'C381', 'C382', 'C383', 'C384', 'C388', 'C390',
        'C399', 'C4000', 'C4001', 'C4002', 'C4010', 'C4011', 'C4012', 'C4020', 'C4021', 'C4022',
        'C4030', 'C4031', 'C4032', 'C4080', 'C4081', 'C4082', 'C4090', 'C4091', 'C4092', 'C410',
        'C411', 'C412', 'C413', 'C414', 'C419', 'C430', 'C4310', 'C4311', 'C4312', 'C4320',
        'C4321', 'C4322', 'C4330', 'C4331', 'C4339', 'C434', 'C4351', 'C4352', 'C4359', 'C4360',
        'C4361', 'C4362', 'C4370', 'C4371', 'C4372', 'C438', 'C439', 'C4400', 'C4401', 'C4402',
        'C4409', 'C44101', 'C44102', 'C44109', 'C44111', 'C44112', 'C44119', 'C44121', 'C44122',
        'C44129', 'C44191', 'C44192', 'C44199', 'C44201', 'C44202', 'C44209', 'C44211', 'C44212',
        'C44219', 'C44221', 'C44222', 'C44229', 'C44291', 'C44292', 'C44299', 'C44300', 'C44301',
        'C44309', 'C44310', 'C44311', 'C44319', 'C44320', 'C44321', 'C44329', 'C44390', 'C44391',
        'C44399', 'C4440', 'C4441', 'C4442', 'C4449', 'C44500', 'C44501', 'C44509', 'C44510',
        'C44511', 'C44519', 'C44520', 'C44521', 'C44529', 'C44590', 'C44591', 'C44599', 'C44601',
        'C44602', 'C44609', 'C44611', 'C44612', 'C44619', 'C44621', 'C44622', 'C44629', 'C44691',
        'C44692', 'C44699', 'C44701', 'C44702', 'C44709', 'C44711', 'C44712', 'C44719', 'C44721',
        'C44722', 'C44729', 'C44791', 'C44792', 'C44799', 'C4480', 'C4481', 'C4482', 'C4489',
        'C4490', 'C4491', 'C4492', 'C4499', 'C450', 'C451', 'C452', 'C457', 'C459', 'C460', 'C461',
        'C462', 'C463', 'C464', 'C4650', 'C4651', 'C4652', 'C467', 'C469', 'C470', 'C4710',
        'C4711', 'C4712', 'C4720', 'C4721', 'C4722', 'C473', 'C474', 'C475', 'C476', 'C478',
        'C479', 'C480', 'C481', 'C482', 'C488', 'C490', 'C4910', 'C4911', 'C4912', 'C4920',
        'C4921', 'C4922', 'C493', 'C494', 'C495', 'C496', 'C498', 'C499', 'C49A0', 'C49A1',
        'C49A2', 'C49A3', 'C49A4', 'C49A5', 'C49A9', 'C4A0', 'C4A10', 'C4A11', 'C4A12', 'C4A20',
        'C4A21', 'C4A22', 'C4A30', 'C4A31', 'C4A39', 'C4A4', 'C4A51', 'C4A52', 'C4A59', 'C4A60',
        'C4A61', 'C4A62', 'C4A70', 'C4A71', 'C4A72', 'C4A8', 'C4A9', 'C50011', 'C50012', 'C50019',
        'C50021', 'C50022', 'C50029', 'C50111', 'C50112', 'C50119', 'C50121', 'C50122', 'C50129',
        'C50211', 'C50212', 'C50219', 'C50221', 'C50222', 'C50229', 'C50311', 'C50312', 'C50319',
        'C50321', 'C50322', 'C50329', 'C50411', 'C50412', 'C50419', 'C50421', 'C50422', 'C50429',
        'C50511', 'C50512', 'C50519', 'C50521', 'C50522', 'C50529', 'C50611', 'C50612', 'C50619',
        'C50621', 'C50622', 'C50629', 'C50811', 'C50812', 'C50819', 'C50821', 'C50822', 'C50829',
        'C50911', 'C50912', 'C50919', 'C50921', 'C50922', 'C50929', 'C510', 'C511', 'C512', 'C518',
        'C519', 'C52', 'C530', 'C531', 'C538', 'C539', 'C540', 'C541', 'C542', 'C543', 'C548',
        'C549', 'C55', 'C561', 'C562', 'C569', 'C5700', 'C5701', 'C5702', 'C5710', 'C5711',
        'C5712', 'C5720', 'C5721', 'C5722', 'C573', 'C574', 'C577', 'C578', 'C579', 'C58', 'C600',
        'C601', 'C602', 'C608', 'C609', 'C61', 'C6200', 'C6201', 'C6202', 'C6210', 'C6211',
        'C6212', 'C6290', 'C6291', 'C6292', 'C6300', 'C6301', 'C6302', 'C6310', 'C6311', 'C6312',
        'C632', 'C637', 'C638', 'C639', 'C641', 'C642', 'C649', 'C651', 'C652', 'C659', 'C661',
        'C662', 'C669', 'C670', 'C671', 'C672', 'C673', 'C674', 'C675', 'C676', 'C677', 'C678',
        'C679', 'C680', 'C681', 'C688', 'C689', 'C6900', 'C6901', 'C6902', 'C6910', 'C6911',
        'C6912', 'C6920', 'C6921', 'C6922', 'C6930', 'C6931', 'C6932', 'C6940', 'C6941', 'C6942',
        'C6950', 'C6951', 'C6952', 'C6960', 'C6961', 'C6962', 'C6980', 'C6981', 'C6982', 'C6990',
        'C6991', 'C6992', 'C700', 'C701', 'C709', 'C710', 'C711', 'C712', 'C713', 'C714', 'C715',
        'C716', 'C717', 'C718', 'C719', 'C720', 'C721', 'C7220', 'C7221', 'C7222', 'C7230',
        'C7231', 'C7232', 'C7240', 'C7241', 'C7242', 'C7250', 'C7259', 'C729', 'C73', 'C7400',
        'C7401', 'C7402', 'C7410', 'C7411', 'C7412', 'C7490', 'C7491', 'C7492', 'C750', 'C751',
        'C752', 'C753', 'C754', 'C755', 'C758', 'C759', 'C760', 'C761', 'C762', 'C763', 'C7640',
        'C7641', 'C7642', 'C7650', 'C7651', 'C7652', 'C768', 'C770', 'C771', 'C772', 'C773',
        'C774', 'C775', 'C778', 'C779', 'C7800', 'C7801', 'C7802', 'C781', 'C782', 'C7830',
        'C7839', 'C784', 'C785', 'C786', 'C787', 'C7880', 'C7889', 'C7900', 'C7901', 'C7902',
        'C7910', 'C7911', 'C7919', 'C792', 'C7931', 'C7932', 'C7940', 'C7949', 'C7951', 'C7952',
        'C7960', 'C7961', 'C7962', 'C7970', 'C7971', 'C7972', 'C7981', 'C7982', 'C7989', 'C799',
        'C7A00', 'C7A010', 'C7A011', 'C7A012', 'C7A019', 'C7A020', 'C7A021', 'C7A022', 'C7A023',
        'C7A024', 'C7A025', 'C7A026', 'C7A029', 'C7A090', 'C7A091', 'C7A092', 'C7A093', 'C7A094',
        'C7A095', 'C7A096', 'C7A098', 'C7A1', 'C7A8', 'C7B00', 'C7B01', 'C7B02', 'C7B03', 'C7B04',
        'C7B09', 'C7B1', 'C7B8', 'C800', 'C801', 'C802', 'C8100', 'C8101', 'C8102', 'C8103',
        'C8104', 'C8105', 'C8106', 'C8107', 'C8108', 'C8109', 'C8110', 'C8111', 'C8112', 'C8113',
        'C8114', 'C8115', 'C8116', 'C8117', 'C8118', 'C8119', 'C8120', 'C8121', 'C8122', 'C8123',
        'C8124', 'C8125', 'C8126', 'C8127', 'C8128', 'C8129', 'C8130', 'C8131', 'C8132', 'C8133',
        'C8134', 'C8135', 'C8136', 'C8137', 'C8138', 'C8139', 'C8140', 'C8141', 'C8142', 'C8143',
        'C8144', 'C8145', 'C8146', 'C8147', 'C8148', 'C8149', 'C8170', 'C8171', 'C8172', 'C8173',
        'C8174', 'C8175', 'C8176', 'C8177', 'C8178', 'C8179', 'C8190', 'C8191', 'C8192', 'C8193',
        'C8194', 'C8195', 'C8196', 'C8197', 'C8198', 'C8199', 'C8200', 'C8201', 'C8202', 'C8203',
        'C8204', 'C8205', 'C8206', 'C8207', 'C8208', 'C8209', 'C8210', 'C8211', 'C8212', 'C8213',
        'C8214', 'C8215', 'C8216', 'C8217', 'C8218', 'C8219', 'C8220', 'C8221', 'C8222', 'C8223',
        'C8224', 'C8225', 'C8226', 'C8227', 'C8228', 'C8229', 'C8230', 'C8231', 'C8232', 'C8233',
        'C8234', 'C8235', 'C8236', 'C8237', 'C8238', 'C8239', 'C8240', 'C8241', 'C8242', 'C8243',
        'C8244', 'C8245', 'C8246', 'C8247', 'C8248', 'C8249', 'C8250', 'C8251', 'C8252', 'C8253',
        'C8254', 'C8255', 'C8256', 'C8257', 'C8258', 'C8259', 'C8260', 'C8261', 'C8262', 'C8263',
        'C8264', 'C8265', 'C8266', 'C8267', 'C8268', 'C8269', 'C8280', 'C8281', 'C8282', 'C8283',
        'C8284', 'C8285', 'C8286', 'C8287', 'C8288', 'C8289', 'C8290', 'C8291', 'C8292', 'C8293',
        'C8294', 'C8295', 'C8296', 'C8297', 'C8298', 'C8299', 'C8300', 'C8301', 'C8302', 'C8303',
        'C8304', 'C8305', 'C8306', 'C8307', 'C8308', 'C8309', 'C8310', 'C8311', 'C8312', 'C8313',
        'C8314', 'C8315', 'C8316', 'C8317', 'C8318', 'C8319', 'C8330', 'C8331', 'C8332', 'C8333',
        'C8334', 'C8335', 'C8336', 'C8337', 'C8338', 'C8339', 'C8350', 'C8351', 'C8352', 'C8353',
        'C8354', 'C8355', 'C8356', 'C8357', 'C8358', 'C8359', 'C8370', 'C8371', 'C8372', 'C8373',
        'C8374', 'C8375', 'C8376', 'C8377', 'C8378', 'C8379', 'C8380', 'C8381', 'C8382', 'C8383',
        'C8384', 'C8385', 'C8386', 'C8387', 'C8388', 'C8389', 'C8390', 'C8391', 'C8392', 'C8393',
        'C8394', 'C8395', 'C8396', 'C8397', 'C8398', 'C8399', 'C8400', 'C8401', 'C8402', 'C8403',
        'C8404', 'C8405', 'C8406', 'C8407', 'C8408', 'C8409', 'C8410', 'C8411', 'C8412', 'C8413',
        'C8414', 'C8415', 'C8416', 'C8417', 'C8418', 'C8419', 'C8440', 'C8441', 'C8442', 'C8443',
        'C8444', 'C8445', 'C8446', 'C8447', 'C8448', 'C8449', 'C8460', 'C8461', 'C8462', 'C8463',
        'C8464', 'C8465', 'C8466', 'C8467', 'C8468', 'C8469', 'C8470', 'C8471', 'C8472', 'C8473',
        'C8474', 'C8475', 'C8476', 'C8477', 'C8478', 'C8479', 'C8490', 'C8491', 'C8492', 'C8493',
        'C8494', 'C8495', 'C8496', 'C8497', 'C8498', 'C8499', 'C84A0', 'C84A1', 'C84A2', 'C84A3',
        'C84A4', 'C84A5', 'C84A6', 'C84A7', 'C84A8', 'C84A9', 'C84Z0', 'C84Z1', 'C84Z2', 'C84Z3',
        'C84Z4', 'C84Z5', 'C84Z6', 'C84Z7', 'C84Z8', 'C84Z9', 'C8510', 'C8511', 'C8512', 'C8513',
        'C8514', 'C8515', 'C8516', 'C8517', 'C8518', 'C8519', 'C8520', 'C8521', 'C8522', 'C8523',
        'C8524', 'C8525', 'C8526', 'C8527', 'C8528', 'C8529', 'C8580', 'C8581', 'C8582', 'C8583',
        'C8584', 'C8585', 'C8586', 'C8587', 'C8588', 'C8589', 'C8590', 'C8591', 'C8592', 'C8593',
        'C8594', 'C8595', 'C8596', 'C8597', 'C8598', 'C8599', 'C860', 'C861', 'C862', 'C863',
        'C864', 'C865', 'C866', 'C880', 'C882', 'C883', 'C884', 'C888', 'C889', 'C9000', 'C9001',
        'C9002', 'C9010', 'C9011', 'C9012', 'C9020', 'C9021', 'C9022', 'C9030', 'C9031', 'C9032',
        'C9100', 'C9101', 'C9102', 'C9110', 'C9111', 'C9112', 'C9130', 'C9131', 'C9132', 'C9140',
        'C9141', 'C9142', 'C9150', 'C9151', 'C9152', 'C9160', 'C9161', 'C9162', 'C9190', 'C9191',
        'C9192', 'C91A0', 'C91A1', 'C91A2', 'C91Z0', 'C91Z1', 'C91Z2', 'C9200', 'C9201', 'C9202',
        'C9210', 'C9211', 'C9212', 'C9220', 'C9221', 'C9222', 'C9230', 'C9231', 'C9232', 'C9240',
        'C9241', 'C9242', 'C9250', 'C9251', 'C9252', 'C9260', 'C9261', 'C9262', 'C9290', 'C9291',
        'C9292', 'C92A0', 'C92A1', 'C92A2', 'C92Z0', 'C92Z1', 'C92Z2', 'C9300', 'C9301', 'C9302',
        'C9310', 'C9311', 'C9312', 'C9330', 'C9331', 'C9332', 'C9390', 'C9391', 'C9392', 'C93Z0',
        'C93Z1', 'C93Z2', 'C9400', 'C9401', 'C9402', 'C9420', 'C9421', 'C9422', 'C9430', 'C9431',
        'C9432', 'C9440', 'C9441', 'C9442', 'C946', 'C9480', 'C9481', 'C9482', 'C9500', 'C9501',
        'C9502', 'C9510', 'C9511', 'C9512', 'C9590', 'C9591', 'C9592', 'C960', 'C962', 'C964',
        'C965', 'C966', 'C969', 'C96A', 'C96Z', 'D3701', 'D3702', 'D37030', 'D37031', 'D37032',
        'D37039', 'D3704', 'D3705', 'D3709', 'D371', 'D372', 'D373', 'D374', 'D375', 'D376',
        'D378', 'D379', 'D380', 'D381', 'D382', 'D383', 'D384', 'D385', 'D386', 'D390', 'D3910',
        'D3911', 'D3912', 'D392', 'D398', 'D399', 'D400', 'D4010', 'D4011', 'D4012', 'D408',
        'D409', 'D4100', 'D4101', 'D4102', 'D4110', 'D4111', 'D4112', 'D4120', 'D4121', 'D4122',
        'D413', 'D414', 'D418', 'D419', 'D420', 'D421', 'D429', 'D430', 'D431', 'D432', 'D433',
        'D434', 'D438', 'D439', 'D440', 'D4410', 'D4411', 'D4412', 'D442', 'D443', 'D444', 'D445',
        'D446', 'D447', 'D449', 'D45', 'D460', 'D461', 'D4620', 'D4621', 'D4622', 'D464', 'D469',
        'D46A', 'D46B', 'D46C', 'D46Z', 'D470', 'D471', 'D472', 'D473', 'D474', 'D479', 'D47Z1',
        'D47Z2', 'D47Z9', 'D480', 'D481', 'D482', 'D483', 'D484', 'D485', 'D4860', 'D4861',
        'D4862', 'D487', 'D489', 'D490', 'D491', 'D492', 'D493', 'D494', 'D495', 'D49511',
        'D49512', 'D49519', 'D4959', 'D496', 'D497', 'D4981', 'D4989', 'D499', 'Q8500', 'Q8501',
        'Q8502', 'Q8503', 'Q8509'
    }

    ICD9CM = {
        '1400', '1401', '1403', '1404', '1405', '1406', '1408', '1409', '1410', '1411', '1412',
        '1413', '1414', '1415', '1416', '1418', '1419', '1420', '1421', '1422', '1428', '1429',
        '1430', '1431', '1438', '1439', '1440', '1441', '1448', '1449', '1450', '1451', '1452',
        '1453', '1454', '1455', '1456', '1458', '1459', '1460', '1461', '1462', '1463', '1464',
        '1465', '1466', '1467', '1468', '1469', '1470', '1471', '1472', '1473', '1478', '1479',
        '1480', '1481', '1482', '1483', '1488', '1489', '1490', '1491', '1498', '1499', '1500',
        '1501', '1502', '1503', '1504', '1505', '1508', '1509', '1510', '1511', '1512', '1513',
        '1514', '1515', '1516', '1518', '1519', '1520', '1521', '1522', '1523', '1528', '1529',
        '1530', '1531', '1532', '1533', '1534', '1535', '1536', '1537', '1538', '1539', '1540',
        '1541', '1542', '1543', '1548', '1550', '1551', '1552', '1560', '1561', '1562', '1568',
        '1569', '1570', '1571', '1572', '1573', '1574', '1578', '1579', '1580', '1588', '1589',
        '1590', '1591', '1598', '1599', '1600', '1601', '1602', '1603', '1604', '1605', '1608',
        '1609', '1610', '1611', '1612', '1613', '1618', '1619', '1620', '1622', '1623', '1624',
        '1625', '1628', '1629', '1630', '1631', '1638', '1639', '1640', '1641', '1642', '1643',
        '1648', '1649', '1650', '1658', '1659', '1700', '1701', '1702', '1703', '1704', '1705',
        '1706', '1707', '1708', '1709', '1710', '1712', '1713', '1714', '1715', '1716', '1717',
        '1718', '1719', '1720', '1721', '1722', '1723', '1724', '1725', '1726', '1727', '1728',
        '1729', '17300', '17301', '17302', '17309', '17310', '17311', '17312', '17319', '17320',
        '17321', '17322', '17329', '17330', '17331', '17332', '17339', '17340', '17341', '17342',
        '17349', '17350', '17351', '17352', '17359', '17360', '17361', '17362', '17369', '17370',
        '17371', '17372', '17379', '17380', '17381', '17382', '17389', '17390', '17391', '17392',
        '17399', '1740', '1741', '1742', '1743', '1744', '1745', '1746', '1748', '1749', '1750',
        '1759', '1760', '1761', '1762', '1763', '1764', '1765', '1768', '1769', '179', '1800',
        '1801', '1808', '1809', '181', '1820', '1821', '1828', '1830', '1832', '1833', '1834',
        '1835', '1838', '1839', '1840', '1841', '1842', '1843', '1844', '1848', '1849', '185',
        '1860', '1869', '1871', '1872', '1873', '1874', '1875', '1876', '1877', '1878', '1879',
        '1880', '1881', '1882', '1883', '1884', '1885', '1886', '1887', '1888', '1889', '1890',
        '1891', '1892', '1893', '1894', '1898', '1899', '1900', '1901', '1902', '1903', '1904',
        '1905', '1906', '1907', '1908', '1909', '1910', '1911', '1912', '1913', '1914', '1915',
        '1916', '1917', '1918', '1919', '1920', '1921', '1922', '1923', '1928', '1929', '193',
        '1940', '1941', '1943', '1944', '1945', '1946', '1948', '1949', '1950', '1951', '1952',
        '1953', '1954', '1955', '1958', '1960', '1961', '1962', '1963', '1965', '1966', '1968',
        '1969', '1970', '1971', '1972', '1973', '1974', '1975', '1976', '1977', '1978', '1980',
        '1981', '1982', '1983', '1984', '1985', '1986', '1987', '19881', '19882', '19889', '1990',
        '1991', '1992', '20000', '20001', '20002', '20003', '20004', '20005', '20006', '20007',
        '20008', '20010', '20011', '20012', '20013', '20014', '20015', '20016', '20017', '20018',
        '20020', '20021', '20022', '20023', '20024', '20025', '20026', '20027', '20028', '20030',
        '20031', '20032', '20033', '20034', '20035', '20036', '20037', '20038', '20040', '20041',
        '20042', '20043', '20044', '20045', '20046', '20047', '20048', '20050', '20051', '20052',
        '20053', '20054', '20055', '20056', '20057', '20058', '20060', '20061', '20062', '20063',
        '20064', '20065', '20066', '20067', '20068', '20070', '20071', '20072', '20073', '20074',
        '20075', '20076', '20077', '20078', '20080', '20081', '20082', '20083', '20084', '20085',
        '20086', '20087', '20088', '20100', '20101', '20102', '20103', '20104', '20105', '20106',
        '20107', '20108', '20110', '20111', '20112', '20113', '20114', '20115', '20116', '20117',
        '20118', '20120', '20121', '20122', '20123', '20124', '20125', '20126', '20127', '20128',
        '20140', '20141', '20142', '20143', '20144', '20145', '20146', '20147', '20148', '20150',
        '20151', '20152', '20153', '20154', '20155', '20156', '20157', '20158', '20160', '20161',
        '20162', '20163', '20164', '20165', '20166', '20167', '20168', '20170', '20171', '20172',
        '20173', '20174', '20175', '20176', '20177', '20178', '20190', '20191', '20192', '20193',
        '20194', '20195', '20196', '20197', '20198', '20200', '20201', '20202', '20203', '20204',
        '20205', '20206', '20207', '20208', '20210', '20211', '20212', '20213', '20214', '20215',
        '20216', '20217', '20218', '20220', '20221', '20222', '20223', '20224', '20225', '20226',
        '20227', '20228', '20230', '20231', '20232', '20233', '20234', '20235', '20236', '20237',
        '20238', '20240', '20241', '20242', '20243', '20244', '20245', '20246', '20247', '20248',
        '20250', '20251', '20252', '20253', '20254', '20255', '20256', '20257', '20258', '20260',
        '20261', '20262', '20263', '20264', '20265', '20266', '20267', '20268', '20270', '20271',
        '20272', '20273', '20274', '20275', '20276', '20277', '20278', '20280', '20281', '20282',
        '20283', '20284', '20285', '20286', '20287', '20288', '20290', '20291', '20292', '20293',
        '20294', '20295', '20296', '20297', '20298', '20300', '20301', '20302', '20310', '20311',
        '20312', '20380', '20381', '20382', '20400', '20401', '20402', '20410', '20411', '20412',
        '20420', '20421', '20422', '20480', '20481', '20482', '20490', '20491', '20492', '20500',
        '20501', '20502', '20510', '20511', '20512', '20520', '20521', '20522', '20530', '20531',
        '20532', '20580', '20581', '20582', '20590', '20591', '20592', '20600', '20601', '20602',
        '20610', '20611', '20612', '20620', '20621', '20622', '20680', '20681', '20682', '20690',
        '20691', '20692', '20700', '20701', '20702', '20710', '20711', '20712', '20720', '20721',
        '20722', '20780', '20781', '20782', '20800', '20801', '20802', '20810', '20811', '20812',
        '20820', '20821', '20822', '20880', '20881', '20882', '20890', '20891', '20892', '20900',
        '20901', '20902', '20903', '20910', '20911', '20912', '20913', '20914', '20915', '20916',
        '20917', '20920', '20921', '20922', '20923', '20924', '20925', '20926', '20927', '20929',
        '20930', '20931', '20932', '20933', '20934', '20935', '20936', '20970', '20971', '20972',
        '20973', '20974', '20975', '20979', '2350', '2351', '2352', '2353', '2354', '2355', '2356',
        '2357', '2358', '2359', '2360', '2361', '2362', '2363', '2364', '2365', '2366', '2367',
        '23690', '23691', '23699', '2370', '2371', '2372', '2373', '2374', '2375', '2376', '23770',
        '23771', '23772', '23773', '23779', '2379', '2380', '2381', '2382', '2383', '2384', '2385',
        '2386', '23871', '23872', '23873', '23874', '23875', '23876', '23877', '23879', '2388',
        '2389', '2390', '2391', '2392', '2393', '2394', '2395', '2396', '2397', '23981', '23989',
        '2399'
    }

    SNOMEDCT = {
        '107691000119101', '109264009', '109267002', '109347009', '109348004', '109349007',
        '109356001', '109357005', '109358000', '109359008', '109366009', '109367000', '109368005',
        '109369002', '109370001', '109371002', '109374005', '109378008', '109383000', '109384006',
        '109385007', '109386008', '109388009', '109389001', '109390005', '109391009', '109392002',
        '109821008', '109822001', '109823006', '109824000', '109826003', '109828002', '109830000',
        '109831001', '109832008', '109833003', '109834009', '109835005', '109836006', '109837002',
        '109838007', '109839004', '109840002', '109841003', '109842005', '109843000', '109844006',
        '109847004', '109848009', '109851002', '109853004', '109854005', '109855006', '109856007',
        '109857003', '109858008', '109870007', '109874003', '109875002', '109876001', '109878000',
        '109879008', '109880006', '109882003', '109885001', '109886000', '109887009', '109911004',
        '109912006', '109914007', '109915008', '109917000', '109918005', '109919002', '109921007',
        '109923005', '109925003', '109927006', '109931000', '109933002', '109937001', '109939003',
        '109941002', '109943004', '109945006', '109947003', '109948008', '109951001', '109958007',
        '109962001', '109964000', '109965004', '109966003', '109967007', '109968002', '109969005',
        '109970006', '109971005', '109972003', '109975001', '109976000', '109977009', '109978004',
        '109979007', '109980005', '109982002', '109984001', '109985000', '109988003', '109989006',
        '109991003', '109994006', '109995007', '109996008', '109998009', '110000005', '110002002',
        '110004001', '110005000', '110006004', '110007008', '110013004', '118599009', '118600007',
        '118601006', '118602004', '118605002', '118606001', '118607005', '118608000', '118609008',
        '118610003', '118611004', '118612006', '118613001', '118614007', '118615008', '118616009',
        '118617000', '118618005', '123313007', '123842006', '123845008', '126667002', '127070008',
        '127220001', '127225006', '128462008', '128465005', '128466006', '128467002', '128874001',
        '128875000', '13048006', '134335004', '186709004', '186723002', '186725009', '187601000',
        '187604008', '187606005', '187608006', '187613005', '187614004', '187622006', '187624007',
        '187631006', '187634003', '187635002', '187637005', '187640005', '187641009', '187644001',
        '187652003', '187653008', '187658004', '187659007', '187660002', '187661003', '187662005',
        '187666008', '187675005', '187681002', '187682009', '187683004', '187685006', '187688008',
        '187692001', '187693006', '187694000', '187697007', '187698002', '187700006', '187701005',
        '187702003', '187708004', '187709007', '187716008', '187722004', '187723009', '187724003',
        '187725002', '187726001', '187727005', '187732006', '187733001', '187734007', '187736009',
        '187738005', '187740000', '187741001', '187742008', '187752007', '187757001', '187760008',
        '187767006', '187769009', '187773007', '187776004', '187777008', '187784000', '187786003',
        '187791002', '187792009', '187793004', '187794005', '187798008', '187801002', '187803004',
        '187804005', '187807003', '187808008', '187809000', '187810005', '187811009', '187814001',
        '187821001', '187822008', '187824009', '187828007', '187829004', '187830009', '187831008',
        '187833006', '187834000', '187835004', '187836003', '187838002', '187841006', '187842004',
        '187843009', '187844003', '187845002', '187846001', '187853005', '187854004', '187857006',
        '187861000', '187862007', '187864008', '187865009', '187866005', '187868006', '187869003',
        '187870002', '187881004', '187900002', '187903000', '187906008', '187916000', '187917009',
        '187918004', '187920001', '187925006', '187926007', '187927003', '187929000', '187932002',
        '187937008', '187938003', '187939006', '187940008', '187941007', '187942000', '187943005',
        '187944004', '187945003', '187946002', '187947006', '187948001', '187949009', '187950009',
        '187952001', '187956003', '187957007', '187967002', '187968007', '187969004', '187970003',
        '187972006', '187973001', '187974007', '187975008', '187976009', '187977000', '187978005',
        '187987001', '187988006', '187989003', '187991006', '187992004', '187993009', '187994003',
        '187995002', '187996001', '187997005', '187999008', '188000002', '188001003', '188002005',
        '188003000', '188004006', '188005007', '188006008', '188010006', '188013008', '188015001',
        '188016000', '188017009', '188019007', '188020001', '188021002', '188022009', '188023004',
        '188029000', '188030005', '188032002', '188033007', '188034001', '188038003', '188040008',
        '188042000', '188044004', '188045003', '188046002', '188049009', '188050009', '188051008',
        '188052001', '188054000', '188055004', '188060000', '188061001', '188062008', '188063003',
        '188064009', '188065005', '188067002', '188068007', '188069004', '188070003', '188071004',
        '188072006', '188073001', '188074007', '188075008', '188076009', '188077000', '188089003',
        '188090007', '188091006', '188095002', '188099008', '188100000', '188102008', '188103003',
        '188107002', '188110009', '188119005', '188121000', '188122007', '188125009', '188127001',
        '188132000', '188133005', '188135003', '188138001', '188147009', '188151006', '188152004',
        '188153009', '188154003', '188155002', '188156001', '188157005', '188159008', '188163001',
        '188168005', '188176007', '188177003', '188180002', '188183000', '188184006', '188188009',
        '188189001', '188190005', '188191009', '188192002', '188193007', '188195000', '188196004',
        '188198003', '188204000', '188208002', '188209005', '188211001', '188219004', '188220005',
        '188230001', '188234005', '188235006', '188239000', '188240003', '188241004', '188242006',
        '188243001', '188244007', '188245008', '188247000', '188250002', '188251003', '188252005',
        '188253000', '188256008', '188261005', '188263008', '188264002', '188265001', '188266000',
        '188268004', '188269007', '188272000', '188273005', '188274004', '188280007', '188281006',
        '188282004', '188283009', '188285002', '188286001', '188287005', '188289008', '188290004',
        '188292007', '188293002', '188295009', '188296005', '188297001', '188298006', '188301005',
        '188302003', '188307009', '188308004', '188312005', '188313000', '188315007', '188317004',
        '188318009', '188319001', '188321006', '188322004', '188323009', '188324003', '188325002',
        '188326001', '188327005', '188339002', '188340000', '188353002', '188361007', '188366002',
        '188445006', '188454009', '188458007', '188459004', '188462001', '188469005', '188471005',
        '188478004', '188487008', '188489006', '188492005', '188493000', '188498009', '188500005',
        '188501009', '188502002', '188503007', '188504001', '188505000', '188506004', '188507008',
        '188510001', '188511002', '188512009', '188513004', '188514005', '188515006', '188516007',
        '188517003', '188524002', '188526000', '188529007', '188531003', '188534006', '188536008',
        '188537004', '188538009', '188541000', '188544008', '188547001', '188548006', '188551004',
        '188554007', '188558005', '188559002', '188562004', '188565002', '188566001', '188567005',
        '188568000', '188569008', '188570009', '188572001', '188575004', '188576003', '188577007',
        '188578002', '188579005', '188580008', '188582000', '188585003', '188586002', '188587006',
        '188589009', '188590000', '188591001', '188592008', '188593003', '188609000', '188612002',
        '188613007', '188627002', '188630009', '188631008', '188632001', '188633006', '188634000',
        '188635004', '188637007', '188640007', '188641006', '188642004', '188645002', '188648000',
        '188649008', '188660004', '188662007', '188663002', '188664008', '188665009', '188666005',
        '188667001', '188668006', '188669003', '188672005', '188674006', '188675007', '188676008',
        '188679001', '188691005', '188718006', '188725004', '188726003', '188728002', '188729005',
        '188732008', '188733003', '188734009', '188736006', '188737002', '188738007', '188741003',
        '188744006', '188745007', '188746008', '188748009', '188754005', '188768003', '188770007',
        '189179009', '189361002', '189362009', '189365006', '189371000', '189392000', '189397006',
        '189399009', '189401003', '189406008', '189410006', '189412003', '189414002', '189415001',
        '189416000', '189417009', '189432002', '189433007', '189435000', '189441007', '189473001',
        '189484008', '189487001', '189488006', '189494003', '190030009', '20224008', '230156002',
        '231829006', '231831002', '231832009', '231833004', '231834005', '231835006', '232075002',
        '233717003', '233719000', '235965006', '235966007', '236512004', '236513009', '237252008',
        '237833006', '237865009', '238476000', '238863004', '238864005', '238865006', '239147000',
        '240163000', '240531002', '241861008', '242862004', '25050002', '253000007', '253001006',
        '253003009', '253006001', '253008000', '253017000', '253018005', '253029009', '253030004',
        '253031000', '253042009', '253096008', '254146000', '254389005', '254390001', '254393004',
        '254398008', '254402004', '254404003', '254408000', '254412006', '254417000', '254423005',
        '254424004', '254425003', '254427006', '254431000', '254434008', '254435009', '254436005',
        '254437001', '254441002', '254445006', '254450000', '254454009', '254457002', '254459004',
        '254462001', '254465004', '254466003', '254474002', '254478004', '254481009', '254484001',
        '254503007', '254509006', '254513004', '254517003', '254520006', '254526000', '254530002',
        '254535007', '254539001', '254543002', '254547001', '254549003', '254551004', '254553001',
        '254555008', '254557000', '254559002', '254561006', '254563009', '254567005', '254570009',
        '254574000', '254582000', '254586002', '254601002', '254609000', '254611009', '254612002',
        '254619006', '254620000', '254622008', '254625005', '254626006', '254628007', '254629004',
        '254631008', '254632001', '254633006', '254634000', '254635004', '254637007', '254638002',
        '254643009', '254645002', '254650008', '254651007', '254652000', '254653005', '254654004',
        '254655003', '254662007', '254663002', '254664008', '254701007', '254702000', '254703005',
        '254707006', '254708001', '254709009', '254710004', '254711000', '254712007', '254713002',
        '254714008', '254726003', '254727007', '254729005', '254730000', '254731001', '254732008',
        '254733003', '254734009', '254748009', '254754005', '254764001', '254771006', '254792006',
        '254794007', '254796009', '254797000', '254798005', '254799002', '254800003', '254820002',
        '254824006', '254828009', '254829001', '254837009', '254838004', '254839007', '254840009',
        '254841008', '254843006', '254844000', '254849005', '254850005', '254851009', '254852002',
        '254854001', '254855000', '254856004', '254860001', '254861002', '254863004', '254867003',
        '254869000', '254870004', '254871000', '254872007', '254874008', '254876005', '254877001',
        '254878006', '254883003', '254886006', '254887002', '254888007', '254889004', '254893005',
        '254895003', '254896002', '254897006', '254898001', '254900004', '254904008', '254908006',
        '254909003', '254912000', '254915003', '254916002', '254917006', '254918001', '254934003',
        '254938000', '254939008', '254940005', '254945000', '254948003', '254949006', '254950006',
        '254954002', '254955001', '254969001', '254972008', '254973003', '254974009', '254975005',
        '254976006', '254980001', '254983004', '254986007', '254987003', '254988008', '254989000',
        '254990009', '254993006', '254994000', '254995004', '254996003', '255003007', '255004001',
        '255008003', '255012009', '255015006', '255016007', '255017003', '255021005', '255028004',
        '255029007', '255030002', '255031003', '255032005', '255035007', '255037004', '255044008',
        '255052006', '255056009', '255062004', '255064003', '255066001', '255067005', '255068000',
        '255069008', '255071008', '255072001', '255073006', '255074000', '255075004', '255077007',
        '255078002', '255081007', '255083005', '255084004', '255086002', '255087006', '255088001',
        '255090000', '255091001', '255093003', '255096006', '255101006', '255102004', '255107005',
        '255108000', '255109008', '255110003', '255111004', '255112006', '255114007', '255115008',
        '255116009', '255118005', '255119002', '255121007', '255123005', '255124004', '255128001',
        '255129009', '255191003', '269459004', '269460009', '269463006', '269464000', '269467007',
        '269469005', '269473008', '269475001', '269476000', '269496008', '269497004', '269515006',
        '269516007', '269533000', '269544008', '269578002', '269579005', '269580008', '269581007',
        '269616004', '269617008', '271323007', '271326004', '271467005', '271468000', '271482000',
        '271568003', '271943005', '274084007', '274085008', '274087000', '274088005', '274902006',
        '274905008', '275265005', '275266006', '275394001', '275395000', '275396004', '275397008',
        '275399006', '275419009', '275490009', '276419004', '276420005', '276738009', '276750003',
        '276751004', '276797002', '276799004', '276803003', '276804009', '276809004', '276810009',
        '276811008', '276815004', '276821000', '276822007', '276826005', '276827001', '276828006',
        '276829003', '276836002', '276860003', '276870001', '276876007', '276952000', '276953005',
        '276954004', '276962007', '276975007', '277156006', '277461004', '277473004', '277474005',
        '277505007', '277507004', '277530005', '277543005', '277545003', '277549009', '277550009',
        '277551008', '277567002', '277568007', '277569004', '277570003', '277571004', '277572006',
        '277573001', '277574007', '277575008', '277577000', '277579002', '277580004', '277587001',
        '277589003', '277597005', '277601005', '277602003', '277604002', '277609007', '277610002',
        '277611003', '277612005', '277613000', '277614006', '277615007', '277616008', '277617004',
        '277618009', '277619001', '277622004', '277623009', '277624003', '277625002', '277626001',
        '277627005', '277628000', '277629008', '277632006', '277637000', '277641001', '277642008',
        '277643003', '277651000', '277653002', '277654008', '277664004', '277782009', '278024000',
        '278042005', '278043000', '278044006', '278046008', '278050001', '278051002', '278052009',
        '278053004', '278054005', '278055006', '278057003', '278060005', '278189009', '278433008',
        '278453007', '278491007', '280959007', '281560004', '281561000', '281562007', '281563002',
        '281564008', '281565009', '281566005', '281702006', '285307007', '285308002', '285309005',
        '285310000', '285312008', '285420006', '285421005', '285422003', '285432005', '285598005',
        '285603002', '285604008', '285605009', '285606005', '285607001', '285608006', '285609003',
        '285610008', '285611007', '285612000', '285613005', '285614004', '285615003', '285616002',
        '285617006', '285618001', '285619009', '285631006', '285633009', '285634003', '285635002',
        '285637005', '285638000', '285639008', '285640005', '285641009', '285642002', '285643007',
        '285644001', '285645000', '285769009', '285776004', '285839005', '286887005', '286889008',
        '286890004', '286891000', '286893002', '286894008', '286895009', '286896005', '286897001',
        '286899003', '286900008', '286902000', '300988009', '301756000', '302815008', '302816009',
        '302817000', '302833002', '302834008', '302837001', '302841002', '302842009', '302845006',
        '302847003', '302848008', '302849000', '302851001', '302855005', '302856006', '303012000',
        '303017006', '303055001', '303056000', '303057009', '303194003', '303201005', '304545002',
        '30664006', '307216009', '307219002', '307226002', '307340003', '307341004', '307501007',
        '307502000', '307576001', '307592006', '307593001', '307599002', '307601000', '307603002',
        '307604008', '307608006', '307609003', '307610008', '307617006', '307622006', '307623001',
        '307624007', '307625008', '307633009', '307634003', '307635002', '307636001', '307637005',
        '307646004', '307647008', '307649006', '307650006', '307651005', '308121000', '309245001',
        '31047003', '310498001', '310504009', '310526005', '310599006', '311779007', '312104005',
        '312111009', '312112002', '312113007', '312114001', '312115000', '312949007', '313248004',
        '313249007', '313250007', '313353007', '313354001', '313355000', '313356004', '313357008',
        '313427003', '313428008', '313429000', '314191009', '314408000', '314418005', '314419002',
        '314951005', '314952003', '314953008', '314954002', '314955001', '314960002', '314961003',
        '314962005', '314963000', '314964006', '314965007', '314966008', '314967004', '314968009',
        '314969001', '314970000', '314973003', '314974009', '314975005', '314976006', '314987003',
        '314988008', '314989000', '314990009', '314991008', '314992001', '314993006', '314994000',
        '314995004', '314996003', '314997007', '314998002', '314999005', '315000005', '315001009',
        '315002002', '315003007', '315004001', '315005000', '315006004', '315007008', '315008003',
        '315009006', '315058005', '326072005', '35868009', '359619007', '359631009', '359640008',
        '359648001', '359780007', '359782004', '359785002', '359987004', '363346000', '363348004',
        '363349007', '363350007', '363351006', '363352004', '363353009', '363354003', '363355002',
        '363357005', '363358000', '363359008', '363360003', '363363001', '363364007', '363365008',
        '363366009', '363367000', '363368005', '363369002', '363370001', '363372009', '363373004',
        '363374005', '363375006', '363376007', '363377003', '363378008', '363379000', '363380002',
        '363381003', '363382005', '363383000', '363384006', '363385007', '363386008', '363387004',
        '363388009', '363389001', '363390005', '363391009', '363392002', '363393007', '363394001',
        '363395000', '363396004', '363397008', '363398003', '363399006', '363400004', '363401000',
        '363402007', '363403002', '363404008', '363405009', '363406005', '363407001', '363408006',
        '363409003', '363410008', '363411007', '363412000', '363413005', '363414004', '363415003',
        '363416002', '363417006', '363418001', '363419009', '363420003', '363421004', '363422006',
        '363423001', '363424007', '363425008', '363426009', '363427000', '363428005', '363429002',
        '363430007', '363431006', '363432004', '363433009', '363434003', '363435002', '363436001',
        '363437005', '363438000', '363439008', '363440005', '363441009', '363443007', '363444001',
        '363445000', '363446004', '363447008', '363449006', '363450006', '363451005', '363452003',
        '363453008', '363454002', '363456000', '363457009', '363458004', '363459007', '363460002',
        '363461003', '363462005', '363463000', '363464006', '363465007', '363466008', '363467004',
        '363468009', '363469001', '363470000', '363471001', '363473003', '363474009', '363475005',
        '363476006', '363477002', '363478007', '363481002', '363482009', '363483004', '363484005',
        '363485006', '363486007', '363487003', '363488008', '363489000', '363490009', '363491008',
        '363492001', '363493006', '363494000', '363495004', '363496003', '363497007', '363498002',
        '363499005', '363500001', '363501002', '363502009', '363503004', '363504005', '363505006',
        '363506007', '363507003', '363508008', '363509000', '363510005', '363514001', '363515000',
        '363516004', '363517008', '363518003', '363745004', '369448007', '369449004', '369450004',
        '369451000', '369452007', '369453002', '369454008', '369455009', '369456005', '369457001',
        '369458006', '369459003', '369460008', '369461007', '369463005', '369464004', '369465003',
        '369466002', '369467006', '369468001', '369469009', '369470005', '369471009', '369472002',
        '369473007', '369474001', '369475000', '369476004', '369477008', '369478003', '369479006',
        '369480009', '369481008', '369482001', '369483006', '369484000', '369485004', '369486003',
        '369487007', '369488002', '369489005', '369490001', '369491002', '369492009', '369493004',
        '369494005', '369495006', '369496007', '369497003', '369498008', '369499000', '369500009',
        '369501008', '369502001', '369503006', '369504000', '369505004', '369506003', '369507007',
        '369508002', '369509005', '369510000', '369511001', '369512008', '369513003', '369514009',
        '369515005', '369516006', '369517002', '369518007', '369519004', '369520005', '369521009',
        '369522002', '369523007', '369524001', '369525000', '369526004', '369527008', '369528003',
        '369529006', '369530001', '369531002', '369532009', '369533004', '369534005', '369535006',
        '369536007', '369538008', '369540003', '369541004', '369542006', '369543001', '369544007',
        '369545008', '369546009', '369547000', '369548005', '369549002', '369550002', '369551003',
        '369552005', '369553000', '369554006', '369555007', '369556008', '369557004', '369558009',
        '369559001', '369560006', '369561005', '369562003', '369563008', '369564002', '369565001',
        '369566000', '369567009', '369568004', '369569007', '369570008', '369571007', '369572000',
        '369573005', '369574004', '369575003', '369576002', '369577006', '369578001', '369579009',
        '369580007', '369581006', '369582004', '369583009', '369584003', '369585002', '369586001',
        '369587005', '369588000', '369589008', '369590004', '369591000', '369592007', '369593002',
        '369594008', '369595009', '369596005', '369597001', '369598006', '369599003', '369600000',
        '369601001', '369602008', '369603003', '369604009', '369605005', '369606006', '369607002',
        '369608007', '369609004', '369610009', '370511006', '370967009', '370987005', '371012000',
        '371134001', '371962007', '371963002', '371964008', '371965009', '371966005', '371967001',
        '371968006', '371969003', '371970002', '371971003', '371972005', '371973000', '371974006',
        '371975007', '371976008', '371977004', '371978009', '371979001', '371980003', '371981004',
        '371982006', '371983001', '371984007', '371986009', '371987000', '371988005', '371989002',
        '371990006', '371991005', '371992003', '371993008', '371994002', '371995001', '371996000',
        '371997009', '371998004', '371999007', '372000001', '372001002', '372002009', '372003004',
        '372004005', '372005006', '372006007', '372007003', '372008008', '372009000', '372010005',
        '372011009', '372012002', '372013007', '372014001', '372015000', '372016004', '372017008',
        '372018003', '372019006', '372020000', '372021001', '372022008', '372023003', '372024009',
        '372025005', '372026006', '372027002', '372028007', '372030009', '372062007', '372063002',
        '372064008', '372065009', '372087000', '372092003', '372093008', '372094002', '372095001',
        '372096000', '372097009', '372098004', '372099007', '372100004', '372101000', '372103002',
        '372104008', '372105009', '372106005', '372107001', '372108006', '372110008', '372111007',
        '372112000', '372113005', '372115003', '372116002', '372119009', '372120003', '372121004',
        '372122006', '372123001', '372124007', '372125008', '372126009', '372127000', '372128005',
        '372129002', '372130007', '372131006', '372133009', '372135002', '372136001', '372137005',
        '372138000', '372139008', '372140005', '372141009', '372142002', '372143007', '372244006',
        '373080008', '373081007', '373082000', '373083005', '373088001', '373089009', '373090000',
        '373091001', '373168002', '373627005', '373888000', '385478001', '389216001', '393563007',
        '396198006', '397008008', '397009000', '397011009', '397013007', '397015000', '398623004',
        '398670003', '398903003', '399068003', '399326009', '399490008', '399590005', '399660006',
        '399884001', '399897004', '399934007', '399954008', '399967006', '399969009', '399994005',
        '400001003', '400055004', '400057007', '400058002', '400074007', '400122007', '400129003',
        '400153009', '400173004', '400174005', '400175006', '402494003', '402495002', '402496001',
        '402497005', '402498000', '402499008', '402500004', '402501000', '402502007', '402503002',
        '402504008', '402505009', '402506005', '402507001', '402508006', '402509003', '402510008',
        '402511007', '402512000', '402513005', '402514004', '402515003', '402516002', '402517006',
        '402518001', '402519009', '402520003', '402521004', '402522006', '402523001', '402524007',
        '402525008', '402526009', '402527000', '402528005', '402529002', '402530007', '402531006',
        '402532004', '402533009', '402534003', '402536001', '402537005', '402538000', '402539008',
        '402540005', '402541009', '402542002', '402543007', '402544001', '402545000', '402546004',
        '402547008', '402558004', '402559007', '402560002', '402561003', '402562005', '402563000',
        '402564006', '402636006', '402652009', '402815007', '402816008', '402817004', '402818009',
        '402819001', '402820007', '402871009', '402873007', '402876004', '402879006', '402880009',
        '402881008', '402882001', '402910001', '402912009', '403409009', '403410004', '403411000',
        '403458008', '403468003', '403711001', '403712008', '403713003', '403714009', '403729006',
        '403742006', '403815003', '403816002', '403817006', '403889000', '403890009', '403891008',
        '403892001', '403893006', '403894000', '403895004', '403896003', '403897007', '403898002',
        '403899005', '403900000', '403901001', '403902008', '403903003', '403904009', '403905005',
        '403906006', '403907002', '403908007', '403909004', '403910009', '403911008', '403912001',
        '403913006', '403914000', '403915004', '403916003', '403917007', '403918002', '403919005',
        '403920004', '403921000', '403922007', '403923002', '403924008', '403925009', '403926005',
        '403927001', '403929003', '403939009', '403940006', '403941005', '403942003', '403943008',
        '403944002', '403946000', '403947009', '403949007', '403950007', '403951006', '403954003',
        '403955002', '403977003', '403978008', '403979000', '403980002', '403981003', '403982005',
        '403983000', '403984006', '403985007', '403986008', '403996004', '404008001', '404009009',
        '404010004', '404011000', '404012007', '404013002', '404014008', '404015009', '404016005',
        '404017001', '404037002', '404038007', '404039004', '404040002', '404041003', '404045007',
        '404046008', '404047004', '404051002', '404052009', '404053004', '404054005', '404055006',
        '404056007', '404067008', '404068003', '404069006', '404070007', '404071006', '404072004',
        '404073009', '404077005', '404079008', '404080006', '404083008', '404084002', '404085001',
        '404087009', '404088004', '404089007', '404090003', '404091004', '404092006', '404093001',
        '404094007', '404103007', '404104001', '404105000', '404106004', '404107008', '404108003',
        '404109006', '404110001', '404111002', '404112009', '404113004', '404114005', '404115006',
        '404116007', '404117003', '404118008', '404119000', '404120006', '404121005', '404122003',
        '404123008', '404124002', '404125001', '404126000', '404127009', '404128004', '404129007',
        '404130002', '404131003', '404132005', '404133000', '404134006', '404135007', '404136008',
        '404137004', '404138009', '404139001', '404140004', '404141000', '404142007', '404143002',
        '404144008', '404145009', '404146005', '404147001', '404148006', '404149003', '404150003',
        '404151004', '404152006', '404153001', '404154007', '404155008', '404156009', '404157000',
        '404169008', '404653000', '404664002', '405546008', '405822008', '405843009', '405945003',
        '408642003', '408643008', '408644002', '408645001', '408646000', '408647009', '408648004',
        '408649007', '413389003', '413441006', '413442004', '413445002', '413446001', '4135001',
        '413537009', '413587002', '413656006', '413842007', '413843002', '413847001', '414166008',
        '414553000', '414676007', '414780005', '414785000', '414791003', '414950005', '415110002',
        '415112005', '415177008', '415283002', '415284008', '415285009', '415286005', '415287001',
        '416274001', '416351002', '416669000', '416769008', '416842003', '416901002', '417181009',
        '417264005', '417417007', '417554000', '417570003', '417619001', '418040002', '418372008',
        '418529003', '419052002', '419240004', '419317000', '419842002', '420302007', '420519005',
        '420524008', '420788006', '420890002', '421246008', '421249001', '421283008', '421835000',
        '422052002', '422282000', '422378004', '422541001', '422572002', '422599000', '422676009',
        '422691006', '422736007', '422758009', '422782004', '422833009', '422853008', '422886007',
        '423005002', '423032007', '423038006', '423050000', '423106003', '423158009', '423189008',
        '423195009', '423280002', '423284006', '423294001', '423318000', '423325007', '423349005',
        '423384009', '423424005', '423425006', '423447006', '423463003', '423464009', '423494003',
        '423506005', '423535002', '423595004', '423600008', '423607006', '423610004', '423615009',
        '423627007', '423673009', '423691004', '423700001', '423708008', '423746001', '423793008',
        '423807009', '423812005', '423829008', '423896007', '423973006', '423987006', '424052001',
        '424151006', '424190005', '424260006', '424276002', '424302003', '424334007', '424408000',
        '424413001', '424440001', '424487008', '424549003', '424666005', '424779008', '424849005',
        '424887002', '424938000', '424952003', '424954002', '424970000', '425066001', '425127006',
        '425148008', '425178004', '425225007', '425231005', '425303004', '425607009', '425657001',
        '425688002', '425749006', '425869007', '425941003', '426071002', '426124006', '426217000',
        '426248008', '426336007', '426370008', '426642002', '426885008', '426964009', '427038005',
        '427056005', '427141003', '427285006', '427492003', '427642009', '427658007', '427685000',
        '427744002', '427942006', '428061005', '428100006', '428281000', '428322007', '428905002',
        '429033009', '429114002', '429176009', '429570006', '430338009', '430556008', '430621000',
        '431396003', '432082001', '432328008', '433067002', '438946002', '439478008', '440173001',
        '440397000', '440422002', '440501006', '440525003', '440527006', '441313008', '441535001',
        '441559006', '441962003', '442537007', '443042003', '443136000', '443144000', '443250000',
        '443261008', '443333004', '443439001', '443487006', '443488001', '443493003', '443520009',
        '443643007', '443648003', '443675005', '443679004', '443719001', '443936004', '443937008',
        '443961001', '444596001', '444597005', '444604002', '444712000', '444910004', '444911000',
        '445227008', '445269007', '445406001', '445448008', '446022000', '446189008', '446241005',
        '446807009', '446939001', '447100004', '447109003', '447266004', '447389009', '447390000',
        '447416008', '449628003', '449629006', '449630001', '449631002', '449632009', '449633004',
        '449634005', '449635006', '449636007', '449637003', '46724008', '4752007', '53132006',
        '58961005', '60620005', '609519004', '61493004', '61530001', '61808009', '62497000',
        '63175003', '68979007', '69408002', '708921005', '70910003', '711414003', '712525007',
        '713718006', '713897006', '80914001', '81000119104', '82546001', '86406008', '91854005',
        '91855006', '91856007', '91857003', '91858008', '91860005', '91861009', '92508006',
        '92509003', '92510008', '92511007', '92512000', '92513005', '92514004', '92515003',
        '92516002', '92811003', '92812005', '92813000', '92814006', '92817004', '92818009',
        '92824003', '93133006', '93134000', '93135004', '93136003', '93137007', '93138002',
        '93139005', '93140007', '93141006', '93142004', '93143009', '93144003', '93145002',
        '93146001', '93147005', '93148000', '93149008', '93150008', '93151007', '93152000',
        '93169003', '93182006', '93183001', '93184007', '93185008', '93186009', '93187000',
        '93188005', '93189002', '93190006', '93191005', '93192003', '93193008', '93194002',
        '93195001', '93196000', '93197009', '93198004', '93199007', '93200005', '93201009',
        '93202002', '93203007', '93204001', '93205000', '93206004', '93207008', '93208003',
        '93209006', '93210001', '93211002', '93213004', '93214005', '93215006', '93216007',
        '93217003', '93218008', '93219000', '93220006', '93221005', '93222003', '93223008',
        '93224002', '93225001', '93226000', '93227009', '93228004', '93229007', '93230002',
        '93450001', '93451002', '93487009', '93488004', '93489007', '93492006', '93493001',
        '93494007', '93495008', '93496009', '93497000', '93498005', '93500006', '93501005',
        '93505001', '93506000', '93507009', '93509007', '93510002', '93514006', '93515007',
        '93516008', '93518009', '93519001', '93520007', '93521006', '93522004', '93523009',
        '93524003', '93525002', '93526001', '93527005', '93528000', '93530003', '93531004',
        '93532006', '93533001', '93534007', '93536009', '93537000', '93541001', '93542008',
        '93543003', '93545005', '93546006', '93547002', '93548007', '93549004', '93550004',
        '93551000', '93552007', '93554008', '93555009', '93636004', '93637008', '93638003',
        '93640008', '93641007', '93642000', '93643005', '93644004', '93645003', '93646002',
        '93647006', '93648001', '93649009', '93650009', '93651008', '93652001', '93653006',
        '93654000', '93655004', '93657007', '93658002', '93659005', '93660000', '93661001',
        '93662008', '93663003', '93665005', '93667002', '93669004', '93670003', '93671004',
        '93672006', '93674007', '93676009', '93677000', '93679002', '93680004', '93681000',
        '93682007', '93683002', '93684008', '93686005', '93687001', '93689003', '93690007',
        '93692004', '93693009', '93694003', '93695002', '93696001', '93697005', '93698000',
        '93699008', '93700009', '93701008', '93703006', '93704000', '93705004', '93706003',
        '93707007', '93708002', '93709005', '93710000', '93711001', '93712008', '93713003',
        '93714009', '93715005', '93716006', '93717002', '93720005', '93721009', '93722002',
        '93723007', '93724001', '93725000', '93726004', '93727008', '93728003', '93729006',
        '93730001', '93731002', '93732009', '93733004', '93734005', '93737003', '93738008',
        '93739000', '93740003', '93741004', '93742006', '93743001', '93744007', '93745008',
        '93746009', '93747000', '93748005', '93749002', '93751003', '93753000', '93754006',
        '93755007', '93756008', '93757004', '93759001', '93760006', '93761005', '93763008',
        '93764002', '93766000', '93767009', '93768004', '93769007', '93770008', '93771007',
        '93772000', '93773005', '93775003', '93776002', '93777006', '93778001', '93779009',
        '93781006', '93782004', '93783009', '93784003', '93786001', '93787005', '93788000',
        '93789008', '93792007', '93793002', '93796005', '93797001', '93798006', '93799003',
        '93800004', '93801000', '93802007', '93803002', '93804008', '93806005', '93807001',
        '93808006', '93809003', '93812000', '93814004', '93815003', '93816002', '93817006',
        '93818001', '93820003', '93821004', '93824007', '93825008', '93826009', '93827000',
        '93828005', '93829002', '93830007', '93831006', '93832004', '93833009', '93834003',
        '93835002', '93836001', '93837005', '93839008', '93841009', '93842002', '93843007',
        '93844001', '93845000', '93846004', '93848003', '93849006', '93850006', '93851005',
        '93854002', '93857009', '93858004', '93860002', '93861003', '93862005', '93864006',
        '93865007', '93867004', '93868009', '93870000', '93871001', '93872008', '93874009',
        '93875005', '93876006', '93878007', '93879004', '93880001', '93882009', '93883004',
        '93884005', '93885006', '93886007', '93887003', '93888008', '93889000', '93890009',
        '93891008', '93892001', '93893006', '93894000', '93898002', '93899005', '93900000',
        '93901001', '93902008', '93903003', '93904009', '93905005', '93906006', '93907002',
        '93908007', '93909004', '93910009', '93911008', '93912001', '93913006', '93914000',
        '93915004', '93916003', '93917007', '93918002', '93920004', '93922007', '93923002',
        '93924008', '93925009', '93926005', '93927001', '93928006', '93929003', '93930008',
        '93931007', '93932000', '93933005', '93934004', '93936002', '93939009', '93940006',
        '93941005', '93942003', '93943008', '93944002', '93945001', '93946000', '93947009',
        '93948004', '93950007', '93951006', '93952004', '93953009', '93955002', '93956001',
        '93957005', '93958000', '93959008', '93960003', '93961004', '93962006', '93963001',
        '93964007', '93966009', '93967000', '93968005', '93969002', '93970001', '93971002',
        '93973004', '93974005', '93975006', '93976007', '93977003', '93978008', '93979000',
        '93980002', '93981003', '93982005', '93983000', '93984006', '93985007', '93986008',
        '93987004', '93989001', '93990005', '93991009', '93992002', '93993007', '93994001',
        '93995000', '93996004', '93997008', '93998003', '94000008', '94001007', '94002000',
        '94003005', '94004004', '94005003', '94006002', '94007006', '94008001', '94010004',
        '94011000', '94012007', '94013002', '94014008', '94015009', '94016005', '94017001',
        '94018006', '94019003', '94020009', '94021008', '94022001', '94023006', '94024000',
        '94025004', '94026003', '94027007', '94028002', '94029005', '94030000', '94032008',
        '94033003', '94034009', '94035005', '94036006', '94037002', '94038007', '94039004',
        '94040002', '94041003', '94042005', '94043000', '94044006', '94045007', '94046008',
        '94047004', '94048009', '94049001', '94050001', '94051002', '94052009', '94053004',
        '94054005', '94055006', '94056007', '94057003', '94058008', '94059000', '94060005',
        '94061009', '94062002', '94063007', '94066004', '94067008', '94068003', '94069006',
        '94071006', '94072004', '94073009', '94075002', '94076001', '94077005', '94078000',
        '94079008', '94080006', '94081005', '94082003', '94083008', '94084002', '94085001',
        '94086000', '94087009', '94089007', '94090003', '94092006', '94093001', '94094007',
        '94096009', '94097000', '94098005', '94099002', '94101009', '94102002', '94103007',
        '94104001', '94105000', '94107008', '94108003', '94109006', '94110001', '94111002',
        '94112009', '94113004', '94115006', '94116007', '94117003', '94118008', '94120006',
        '94121005', '94122003', '94123008', '94124002', '94125001', '94126000', '94128004',
        '94129007', '94131003', '94132005', '94133000', '94134006', '94135007', '94138009',
        '94139001', '94140004', '94142007', '94143002', '94144008', '94145009', '94148006',
        '94152006', '94153001', '94154007', '94155008', '94156009', '94157000', '94158005',
        '94159002', '94160007', '94161006', '94162004', '94163009', '94164003', '94165002',
        '94166001', '94167005', '94168000', '94169008', '94170009', '94171008', '94172001',
        '94173006', '94175004', '94176003', '94177007', '94179005', '94180008', '94181007',
        '94182000', '94183005', '94184004', '94185003', '94186002', '94187006', '94189009',
        '94190000', '94191001', '94192008', '94193003', '94194009', '94195005', '94196006',
        '94197002', '94198007', '94200001', '94201002', '94202009', '94203004', '94204005',
        '94205006', '94206007', '94207003', '94208008', '94209000', '94210005', '94211009',
        '94212002', '94213007', '94214001', '94215000', '94217008', '94218003', '94219006',
        '94220000', '94221001', '94222008', '94224009', '94225005', '94226006', '94227002',
        '94228007', '94229004', '94230009', '94231008', '94232001', '94233006', '94234000',
        '94235004', '94236003', '94237007', '94238002', '94239005', '94240007', '94241006',
        '94242004', '94243009', '94244003', '94245002', '94246001', '94247005', '94248000',
        '94249008', '94250008', '94252000', '94253005', '94254004', '94255003', '94256002',
        '94257006', '94258001', '94259009', '94260004', '94261000', '94262007', '94263002',
        '94264008', '94265009', '94266005', '94267001', '94268006', '94269003', '94270002',
        '94271003', '94272005', '94273000', '94274006', '94275007', '94276008', '94277004',
        '94278009', '94279001', '94280003', '94281004', '94282006', '94283001', '94284007',
        '94285008', '94286009', '94287000', '94288005', '94289002', '94290006', '94291005',
        '94292003', '94293008', '94294002', '94295001', '94296000', '94297009', '94298004',
        '94299007', '94300004', '94301000', '94302007', '94303002', '94304008', '94305009',
        '94306005', '94307001', '94308006', '94309003', '94310008', '94311007', '94312000',
        '94313005', '94314004', '94315003', '94316002', '94317006', '94318001', '94319009',
        '94320003', '94321004', '94322006', '94323001', '94324007', '94325008', '94326009',
        '94327000', '94328005', '94329002', '94330007', '94331006', '94332004', '94333009',
        '94334003', '94335002', '94336001', '94337005', '94338000', '94339008', '94340005',
        '94341009', '94342002', '94343007', '94344001', '94345000', '94346004', '94347008',
        '94348003', '94349006', '94350006', '94351005', '94352003', '94353008', '94354002',
        '94355001', '94356000', '94357009', '94358004', '94359007', '94360002', '94361003',
        '94362005', '94364006', '94365007', '94366008', '94367004', '94368009', '94369001',
        '94370000', '94371001', '94372008', '94373003', '94374009', '94375005', '94376006',
        '94378007', '94379004', '94380001', '94381002', '94382009', '94383004', '94384005',
        '94385006', '94386007', '94387003', '94388008', '94389000', '94390009', '94391008',
        '94392001', '94393006', '94394000', '94395004', '94396003', '94397007', '94398002',
        '94399005', '94400003', '94401004', '94402006', '94403001', '94404007', '94405008',
        '94406009', '94407000', '94408005', '94409002', '94410007', '94411006', '94412004',
        '94413009', '94414003', '94415002', '94416001', '94417005', '94418000', '94419008',
        '94420002', '94421003', '94422005', '94423000', '94424006', '94425007', '94426008',
        '94427004', '94428009', '94429001', '94430006', '94431005', '94432003', '94433008',
        '94434002', '94435001', '94436000', '94437009', '94439007', '94440009', '94441008',
        '94442001', '94443006', '94444000', '94445004', '94446003', '94447007', '94448002',
        '94449005', '94450005', '94451009', '94452002', '94453007', '94454001', '94455000',
        '94456004', '94457008', '94458003', '94459006', '94460001', '94461002', '94462009',
        '94463004', '94464005', '94465006', '94466007', '94467003', '94468008', '94469000',
        '94470004', '94471000', '94472007', '94473002', '94474008', '94475009', '94476005',
        '94477001', '94478006', '94479003', '94480000', '94481001', '94482008', '94483003',
        '94484009', '94485005', '94486006', '94487002', '94488007', '94489004', '94490008',
        '94491007', '94492000', '94493005', '94494004', '94495003', '94496002', '94497006',
        '94498001', '94499009', '94500000', '94501001', '94502008', '94503003', '94504009',
        '94505005', '94506006', '94507002', '94508007', '94509004', '94510009', '94511008',
        '94512001', '94513006', '94514000', '94515004', '94516003', '94517007', '94518002',
        '94519005', '94520004', '94521000', '94522007', '94523002', '94524008', '94525009',
        '94526005', '94527001', '94528006', '94529003', '94530008', '94531007', '94532000',
        '94533005', '94534004', '94535003', '94536002', '94537006', '94538001', '94539009',
        '94540006', '94542003', '94543008', '94544002', '94545001', '94546000', '94547009',
        '94548004', '94549007', '94550007', '94551006', '94552004', '94553009', '94554003',
        '94555002', '94556001', '94557005', '94558000', '94559008', '94560003', '94561004',
        '94562006', '94564007', '94565008', '94566009', '94567000', '94568005', '94569002',
        '94570001', '94571002', '94572009', '94573004', '94574005', '94575006', '94576007',
        '94577003', '94578008', '94579000', '94580002', '94581003', '94582005', '94583000',
        '94584006', '94585007', '94586008', '94587004', '94588009', '94589001', '94590005',
        '94591009', '94592002', '94593007', '94594001', '94595000', '94596004', '94597008',
        '94598003', '94599006', '94600009', '94601008', '94602001', '94603006', '94604000',
        '94605004', '94606003', '94607007', '94608002', '94609005', '94610000', '94611001',
        '94612008', '94613003', '94614009', '94615005', '94616006', '94617002', '94618007',
        '94619004', '94620005', '94621009', '94622002', '94623007', '94624001', '94625000',
        '94626004', '94627008', '94628003', '94629006', '94630001', '94631002', '94632009',
        '94633004', '94634005', '94635006', '94636007', '94637003', '94638008', '94639000',
        '94640003', '94641004', '94642006', '94643001', '94644007', '94645008', '94646009',
        '94647000', '94648005', '94649002', '94650002', '94651003', '94652005', '94653000',
        '94654006', '94655007', '94656008', '94657004', '94658009', '94659001', '94660006',
        '94661005', '94662003', '94663008', '94664002', '94665001', '94666000', '94667009',
        '94668004', '94669007', '94670008', '94671007', '94672000', '94673005', '94674004',
        '94675003', '94676002', '94677006', '94678001', '94679009', '94680007', '94681006',
        '94682004', '94683009', '94686001', '94687005', '94688000', '94690004', '94704006',
        '94707004', '94708009', '94709001', '94710006', '94711005', '94712003', '94714002',
        '94715001', '94716000', '94718004', '94719007', '94721002', '94722009', '94723004',
        '94724005', '94725006', '94726007', '94727003', '94728008', '94729000', '94730005',
        '94731009', '94732002', '94733007', '94734001', '94735000', '94736004', '94737008',
        '94738003', '94739006', '94740008', '94741007', '94742000', '94743005', '94744004',
        '94745003', '94746002', '94747006', '94748001', '94749009', '94750009', '94751008',
        '94752001', '94754000', '94755004', '94756003', '94757007', '94758002', '94759005',
        '94761001', '94762008', '94763003', '94764009', '94765005', '94766006', '94767002',
        '94768007', '94769004', '94770003', '94771004', '94772006', '94773001', '94774007',
        '94775008', '94776009', '94777000', '94778005', '94779002', '94780004', '94781000',
        '94782007', '94783002', '94784008', '94785009', '94786005', '94787001', '94788006',
        '94789003', '94790007', '94791006', '94792004', '94793009', '94794003', '94795002',
        '94796001', '94797005', '94798000', '94799008', '94800007', '94801006', '94802004',
        '94803009', '94804003', '94805002', '94806001', '94807005', '94808000', '94809008',
        '94810003', '94811004', '94812006', '94813001', '94814007', '94815008', '94816009',
        '94817000', '94818005', '94819002', '94820008', '94821007', '94822000', '94823005',
        '94824004', '94825003', '94826002', '94827006', '94828001', '94829009', '94830004',
        '94831000', '94832007', '94833002', '94834008', '94835009', '94836005', '94837001',
        '94838006', '94839003', '94840001', '94841002', '94842009', '94843004', '94844005',
        '94845006', '94846007', '94847003', '94848008', '94849000', '94850000', '94851001',
        '94852008', '94853003', '94854009', '94855005', '94856006', '94857002', '94858007',
        '94860009', '94861008', '94862001', '94863006', '94864000', '94865004', '94866003',
        '94867007', '94868002', '94869005', '94870006', '94871005', '94872003', '94873008',
        '94874002', '94875001', '94876000', '94877009', '94878004', '94879007', '94880005',
        '94881009', '94882002', '94883007', '94884001', '94885000', '94886004', '94887008',
        '94888003', '94889006', '94890002', '94891003', '94893000', '94894006', '94895007',
        '94896008', '94897004', '94898009', '94899001', '94900006', '94901005', '94902003',
        '94903008', '94904002', '94905001', '94907009', '94908004', '94909007', '94910002',
        '94911003', '94912005', '94913000', '94914006', '94915007', '94916008', '94917004',
        '94918009', '94919001', '94920007', '94921006', '94922004', '94924003', '94925002',
        '94926001', '94928000', '94929008', '94930003', '94931004', '94932006', '94933001',
        '94934007', '94935008', '94936009', '94937000', '94938005', '94939002', '94940000',
        '94941001', '94942008', '94943003', '94944009', '94945005', '94946006', '94947002',
        '94948007', '94949004', '94950004', '94951000', '94952007', '94953002', '94954008',
        '94955009', '94956005', '94957001', '94958006', '94959003', '94960008', '94961007',
        '94962000', '94963005', '94964004', '94965003', '94966002', '94967006', '94968001',
        '94969009', '94970005', '94971009', '94972002', '94973007', '94974001', '94975000',
        '94976004', '94977008', '94978003', '94979006', '94980009', '94982001', '94983006',
        '94984000', '94985004', '94986003', '94987007', '94988002', '94989005', '94990001',
        '94991002', '94992009', '94993004', '94994005', '94995006', '94996007', '94997003',
        '94998008', '94999000', '95000000', '95001001', '95002008', '95003003', '95004009',
        '95005005', '95006006', '95007002', '95008007', '95009004', '95010009', '95011008',
        '95012001', '95013006', '95014000', '95015004', '95016003', '95017007', '95018002',
        '95019005', '95020004', '95021000', '95022007', '95023002', '95024008', '95025009',
        '95026005', '95027001', '95028006', '95029003', '95030008', '95031007', '95032000',
        '95033005', '95034004', '95035003', '95036002', '95037006', '95038001', '95039009',
        '95040006', '95041005', '95042003', '95043008', '95044002', '95045001', '95046000',
        '95047009', '95048004', '95049007', '95050007', '95051006', '95052004', '95053009',
        '95054003', '95055002', '95056001', '95057005', '95058000', '95059008', '95060003',
        '95061004', '95062006', '95063001', '95064007', '95065008', '95066009', '95067000',
        '95068005', '95069002', '95070001', '95071002', '95072009', '95073004', '95074005',
        '95075006', '95076007', '95077003', '95078008', '95079000', '95080002', '95081003',
        '95082005', '95083000', '95084006', '95085007', '95086008', '95087004', '95088009',
        '95089001', '95090005', '95091009', '95092002', '95093007', '95094001', '95095000',
        '95096004', '95097008', '95098003', '95099006', '95100003', '95101004', '95102006',
        '95103001', '95104007', '95105008', '95106009', '95107000', '95108005', '95109002',
        '95110007', '95111006', '95112004', '95113009', '95115002', '95116001', '95118000',
        '95119008', '95120002', '95121003', '95122005', '95123000', '95124006', '95125007',
        '95126008', '95127004', '95128009', '95129001', '95130006', '95131005', '95132003',
        '95133008', '95134002', '95135001', '95136000', '95137009', '95138004', '95139007',
        '95140009', '95141008', '95142001', '95143006', '95144000', '95145004', '95146003',
        '95147007', '95148002', '95149005', '95150005', '95151009', '95152002', '95153007',
        '95154001', '95155000', '95156004', '95157008', '95158003', '95159006', '95160001',
        '95161002', '95162009', '95163004', '95164005', '95165006', '95166007', '95167003',
        '95168008', '95169000', '95170004', '95171000', '95172007', '95173002', '95174008',
        '95175009', '95176005', '95177001', '95178006', '95179003', '95180000', '95181001',
        '95182008', '95183003', '95184009', '95185005', '95186006', '95187002', '95188007',
        '95192000', '95193005', '95194004', '95209008', '95210003', '95214007', '95224004',
        '95225003', '95226002', '95230004', '95231000', '95260009', '95261008', '95263006', '95264000'
    }


class OccupationalTherapyEvaluation(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1011'
    VALUE_SET_NAME = 'Occupational Therapy Evaluation'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'97003', '97004'}


class PatientProviderInteraction(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1012'
    VALUE_SET_NAME = 'Patient Provider Interaction'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '11797002', '12843005', '18170008', '185316007', '185317003', '185318008', '185320006',
        '185321005', '185349003', '185463005', '185465003', '19681004', '207195004', '270424005',
        '270427003', '270430005', '308335008', '308720009', '386473003', '390906007', '401267002',
        '401271004', '406547006', '438515009', '438516005', '439708006', '445450000', '448337001',
        '4525004', '87790002', '90526000'
    }


class PsychVisitFamilyPsychotherapy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1018'
    VALUE_SET_NAME = 'Psych Visit - Family Psychotherapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90846', '90847'}


class HealthBehavioralAssessmentIndividual(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1020'
    VALUE_SET_NAME = 'Health & Behavioral Assessment - Individual'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'96152'}


class BehavioralneuropsychAssessment(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1023'
    VALUE_SET_NAME = 'Behavioral/Neuropsych Assessment'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'96116', '96118', '96119', '96120'}


class SevereDementia(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1025'
    VALUE_SET_NAME = 'Severe Dementia'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428351000124105'}


class RadiationTreatmentManagement(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1026'
    VALUE_SET_NAME = 'Radiation Treatment Management'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'77427', '77431', '77432', '77435', '77470'}

    SNOMEDCT = {'84755001'}


class ChemotherapyAdministration(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1027'
    VALUE_SET_NAME = 'Chemotherapy Administration'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '51720', '96401', '96402', '96405', '96406', '96409', '96411', '96413', '96415', '96416',
        '96417', '96420', '96422', '96423', '96425', '96440', '96446', '96450', '96521', '96522',
        '96523', '96542', '96549'
    }

    SNOMEDCT = {
        '169396008', '24977001', '265760000', '265761001', '265762008', '266719004', '268500004',
        '315601005', '31652009', '367336001', '38216008', '394894008', '394895009', '394935005',
        '4114003', '51534007', '6872008', '716872004', '77738002'
    }


class StandardizedPainAssessmentTool(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1028'
    VALUE_SET_NAME = 'Standardized Pain Assessment Tool'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'38208-5', '38214-3', '38221-8', '72514-3', '77565-0'}


class SystolicBloodPressure(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1032'
    VALUE_SET_NAME = 'Systolic Blood Pressure'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'8480-6'}


class DiastolicBloodPressure(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1033'
    VALUE_SET_NAME = 'Diastolic Blood Pressure'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'8462-4'}


class Hemodialysis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1083'
    VALUE_SET_NAME = 'Hemodialysis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '90951', '90952', '90953', '90954', '90955', '90956', '90957', '90958', '90959', '90960',
        '90961', '90962', '90963', '90964', '90965', '90966', '90967', '90968', '90969', '90970',
        '99512'
    }

    SNOMEDCT = {'302497006'}


class PeritonealDialysis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1084'
    VALUE_SET_NAME = 'Peritoneal Dialysis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '90945', '90947', '90951', '90952', '90953', '90954', '90955', '90956', '90957', '90958',
        '90959', '90960', '90961', '90962', '90963', '90964', '90965', '90966', '90967', '90968',
        '90969', '90970'
    }

    SNOMEDCT = {
        '14684005', '225230008', '238318009', '238319001', '238321006', '238322004', '238323009',
        '428648006', '676002', '71192002'
    }


class ModerateOrSevereLvsd(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1090'
    VALUE_SET_NAME = 'Moderate or Severe LVSD'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'981000124106', '991000124109'}


class LeftVentricularSystolicDysfunction(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1091'
    VALUE_SET_NAME = 'Left Ventricular Systolic Dysfunction'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'134401001'}


class ModerateOrSevere(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1092'
    VALUE_SET_NAME = 'Moderate or Severe'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'24484000', '6736007'}


class EjectionFraction(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1134'
    VALUE_SET_NAME = 'Ejection Fraction'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {
        '10230-1', '18043-0', '18044-8', '18045-5', '18046-3', '18047-1', '18048-9', '18049-7',
        '77889-4', '77890-2', '77891-0', '77892-8', '79990-8', '79991-6', '79992-4', '79993-2',
        '8806-2', '8807-0', '8808-8', '8809-6', '8810-4', '8811-2', '8812-0'
    }


class AceInhibitorOrArb(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1139'
    VALUE_SET_NAME = 'ACE Inhibitor or ARB'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1000001', '1011718', '1011729', '1091646', '1091652', '1235144', '1235151', '1299859',
        '1299871', '1299890', '1299896', '1299897', '1435624', '153822', '153823', '1600716',
        '1600724', '1600728', '1656340', '1656349', '1656354', '197436', '197437', '197438',
        '197439', '197884', '197885', '197886', '197887', '198188', '198189', '199351', '199352',
        '199353', '199622', '199707', '199708', '199709', '199816', '199817', '199850', '199919',
        '199937', '200094', '200095', '200096', '200284', '200285', '205304', '205305', '205326',
        '247516', '249851', '251856', '261962', '282755', '283316', '283317', '308962', '308963',
        '308964', '310139', '310140', '310792', '310793', '310796', '310797', '310809', '311353',
        '311354', '312748', '312749', '312750', '314076', '314077', '314203', '317173', '349199',
        '349200', '349201', '349353', '349373', '349401', '349405', '349483', '351292', '351293',
        '401965', '401968', '403853', '403854', '403855', '411434', '477130', '485471', '577776',
        '578325', '578330', '636042', '636045', '639537', '722126', '722131', '722134', '722137',
        '730861', '730866', '730869', '730872', '802749', '845488', '848131', '848135', '848140',
        '848145', '848151', '854925', '854984', '854988', '857166', '857169', '857174', '857183',
        '857187', '858618', '858621', '858804', '858810', '858813', '858817', '858824', '858828',
        '858921', '876514', '876519', '876524', '876529', '897781', '897783', '897844', '897853',
        '898342', '898346', '898350', '898353', '898356', '898359', '898362', '898367', '898372',
        '898378', '898687', '898690', '898719', '898723', '979464', '979468', '979471', '979480',
        '979485', '979492', '999967', '999986', '999991', '999996'
    }


class PatientReasonForAceInhibitorOrArbDecline(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1140'
    VALUE_SET_NAME = 'Patient Reason for ACE Inhibitor or ARB Decline'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'134397009', '401084003'}


class Psychoanalysis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1141'
    VALUE_SET_NAME = 'Psychoanalysis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90845'}


class RenalFailureDueToAceInhibitor(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1151'
    VALUE_SET_NAME = 'Renal Failure Due to ACE Inhibitor'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'236429004', '422593004'}


class TobaccoUser(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1170'
    VALUE_SET_NAME = 'Tobacco User'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '160603005', '160604004', '160605003', '160606002', '160619003', '228494002', '228504007',
        '228514003', '228515002', '228516001', '228517005', '228518000', '230059006', '230060001',
        '230062009', '230063004', '230064005', '230065006', '266920004', '428041000124106',
        '428061000124105', '428071000124103', '449868002', '59978006', '65568007', '77176002',
        '81703003', '82302008'
    }


class BetaBlockerTherapy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1174'
    VALUE_SET_NAME = 'Beta Blocker Therapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1191185', '1297753', '1297757', '1495058', '152916', '1593725', '197379', '197380',
        '197381', '197382', '197383', '198000', '198001', '198006', '198007', '198008', '198104',
        '198105', '198284', '198285', '198286', '199277', '199494', '199495', '199717', '199786',
        '199787', '200031', '200032', '200033', '245854', '245855', '310811', '387013', '686924',
        '751612', '751618', '827073', '854901', '854905', '854908', '854916', '854919', '856422',
        '856429', '856448', '856457', '856460', '856481', '856519', '856535', '856556', '856569',
        '856578', '856713', '856724', '856733', '860510', '860516', '860522', '860532', '866412',
        '866419', '866427', '866436', '866452', '866461', '866472', '866479', '866482', '866491',
        '866511', '866514', '866924', '896758', '896762', '896766', '896983', '896987', '904561',
        '904567', '904579', '904589', '904601', '978577', '978581', '998685', '998689', '998693',
        '998694', '998695'
    }


class HeartRate(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1176'
    VALUE_SET_NAME = 'Heart Rate'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'8867-4'}


class AllergyToBetaBlockerTherapy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1177'
    VALUE_SET_NAME = 'Allergy to Beta Blocker Therapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '293962009', '293963004', '293964005', '293965006', '293966007', '293967003', '293968008',
        '293969000', '293970004', '293971000', '293972007', '293973002', '293974008', '293975009',
        '293976005', '293977001', '293978006', '293979003', '293980000', '293981001', '293982008',
        '293983003', '293984009'
    }


class IntoleranceToBetaBlockerTherapy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1178'
    VALUE_SET_NAME = 'Intolerance to Beta Blocker Therapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '292419005', '292420004', '292421000', '292424008', '292425009', '292426005', '292427001',
        '292428006', '292429003', '292430008', '292431007', '292432000', '292433005', '292434004',
        '292435003', '292436002', '292437006', '292438001', '292439009', '292440006', '292441005',
        '292442003', '418370000'
    }


class BetaBlockerTherapyForLvsd(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1184'
    VALUE_SET_NAME = 'Beta Blocker Therapy for LVSD'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '200031', '200032', '200033', '686924', '854901', '854905', '854908', '854916', '854919',
        '860510', '860516', '860522', '860532', '866412', '866419', '866427', '866436', '866452',
        '866461', '866472'
    }


class PreviousReceiptOfInfluenzaVaccine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1185'
    VALUE_SET_NAME = 'Previous Receipt of Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'185900003', '185901004', '185902006', '416928007'}


class GroupPsychotherapy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1187'
    VALUE_SET_NAME = 'Group Psychotherapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'90853'}


class TobaccoNonUser(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1189'
    VALUE_SET_NAME = 'Tobacco Non-User'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '105539002', '105540000', '105541001', '160618006', '160620009', '160621008', '228501004',
        '228502006', '228503001', '228512004', '266919005', '266921000', '266922007', '266923002',
        '266924008', '266925009', '266928006', '281018007', '360890004', '360900008', '360918006',
        '360929005', '405746006', '53896009', '8392000', '8517006', '87739003'
    }


class TobaccoUseCessationPharmacotherapy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1190'
    VALUE_SET_NAME = 'Tobacco Use Cessation Pharmacotherapy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    RXNORM = {
        '1232585', '151226', '1551468', '1797886', '1801289', '198029', '198030', '198031',
        '198045', '198046', '198047', '199283', '199888', '199889', '199890', '205315', '205316',
        '250983', '311975', '312036', '314119', '317136', '359817', '359818', '636671', '636676',
        '749289', '749788', '892244', '993503', '993518', '993536', '993541', '993550', '993557',
        '993567', '993681', '993687', '993691', '998671', '998675', '998679'
    }


class CardiacPacer(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1193'
    VALUE_SET_NAME = 'Cardiac Pacer'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'14106009', '360127006', '360128001', '424921004', '56961003'}


class AllergyToAceInhibitorOrArb(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1211'
    VALUE_SET_NAME = 'Allergy to ACE Inhibitor or ARB'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '295050005', '609537003', '609538008', '609539000', '609540003', '609541004', '609542006',
        '609543001', '609544007', '609545008', '609546009', '609549002', '609550002'
    }


class IntoleranceToAceInhibitorOrArb(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1212'
    VALUE_SET_NAME = 'Intolerance to ACE Inhibitor or ARB'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '293500009', '293501008', '293502001', '293503006', '293504000', '293505004', '293506003',
        '293507007', '293508002', '293509005', '293513003', '371627004', '407564000', '407565004',
        '407590002', '422593004'
    }


class AnnualWellnessVisit_1240(ValueSet):
    """

    Clinical Focus: This value set contains concepts related to annual wellness visits.
    Data Element Scope: The intent of this data element is to identify patients who have had an annual wellness visit. Using the Quality Data Model, this particular data element would be classified under the 'Encounter' category.
    Inclusion Criteria: Includes encounters specific to annual wellness visits.
    Exclusion Criteria: None
    """

    OID = '2.16.840.1.113883.3.526.3.1240'
    VALUE_SET_NAME = 'Annual Wellness Visit'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    HCPCS = {'G0438', 'G0439'}


class AcuteAndSubacuteIridocyclitis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1241'
    VALUE_SET_NAME = 'Acute and Subacute Iridocyclitis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H2000', 'H20011', 'H20012', 'H20013', 'H20019', 'H20021', 'H20022', 'H20023', 'H20029',
        'H20031', 'H20032', 'H20033', 'H20039', 'H20041', 'H20042', 'H20043', 'H20049', 'H20051',
        'H20052', 'H20053', 'H20059'
    }

    ICD9CM = {'36400', '36401', '36402', '36403', '36404', '36405'}

    SNOMEDCT = {
        '10698009', '11226001', '12630008', '13608004', '14427009', '186266008', '193487008',
        '193488003', '193493000', '23798003', '267618008', '29538005', '30080002', '416449002',
        '420485005', '46916006', '6869001', '70461003', '77971008', '89114005', '9091006'
    }


class HealthAndBehavioralAssessmentInitial(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1245'
    VALUE_SET_NAME = 'Health and Behavioral Assessment - Initial'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'96150'}


class MacularExam(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1251'
    VALUE_SET_NAME = 'Macular Exam'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'32451-7'}


class EncounterInfluenza(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1252'
    VALUE_SET_NAME = 'Encounter-Influenza'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {
        '99201', '99202', '99203', '99204', '99205', '99212', '99213', '99214', '99215', '99241',
        '99242', '99243', '99244', '99245', '99304', '99305', '99306', '99307', '99308', '99309',
        '99310', '99315', '99316', '99324', '99325', '99326', '99327', '99328', '99334', '99335',
        '99336', '99337', '99341', '99342', '99343', '99344', '99345', '99347', '99348', '99349',
        '99350', '99381', '99382', '99383', '99384', '99385', '99386', '99387', '99391', '99392',
        '99393', '99394', '99395', '99396', '99397', '99401', '99402', '99403', '99404', '99411',
        '99412', '99420', '99429'
    }

    HCPCS = {'G0438', 'G0439'}

    SNOMEDCT = {
        '12843005', '18170008', '185349003', '185463005', '185465003', '19681004', '207195004',
        '270427003', '270430005', '308335008', '390906007', '406547006', '439708006', '87790002',
        '90526000'
    }


class AllergyToEggs(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1253'
    VALUE_SET_NAME = 'Allergy to Eggs'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'T7808XA', 'T7808XD', 'T7808XS', 'Z91012'}

    ICD9CM = {'99568', 'V1503'}

    SNOMEDCT = {'213020009', '91930004'}


class InfluenzaVaccine_1254(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1254'
    VALUE_SET_NAME = 'Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CVX = {
        '135', '140', '141', '144', '150', '153', '155', '158', '161', '166', '168', '171', '88'
    }


class InfluenzaVaccinationDeclined(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1255'
    VALUE_SET_NAME = 'Influenza Vaccination Declined'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'315640000'}


class AllergyToInfluenzaVaccine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1256'
    VALUE_SET_NAME = 'Allergy to Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'294647003', '294648008', '294649000'}


class IntoleranceToInfluenzaVaccine(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1257'
    VALUE_SET_NAME = 'Intolerance to Influenza Vaccine'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'293112000', '293113005', '390796006', '420113004'}


class LimitedLifeExpectancy(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1259'
    VALUE_SET_NAME = 'Limited Life Expectancy'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'162607003', '162608008', '170969009', '27143004', '300936002'}


class TobaccoUseScreening(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1278'
    VALUE_SET_NAME = 'Tobacco Use Screening'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'39240-7', '68535-4', '68536-2', '72166-2'}


class LevelOfSeverityOfRetinopathyFindings(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1283'
    VALUE_SET_NAME = 'Level of Severity of Retinopathy Findings'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'312903003', '312904009', '312905005', '399876000', '59276001'}


class MacularEdemaFindingsAbsent(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1284'
    VALUE_SET_NAME = 'Macular Edema Findings Absent'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'428341000124108'}


class OphthalmologicalServices(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1285'
    VALUE_SET_NAME = 'Ophthalmological Services'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'92002', '92004', '92012', '92014'}


class MacularEdemaFindingsPresent(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1320'
    VALUE_SET_NAME = 'Macular Edema Findings Present'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {
        '193350004', '193387007', '232020009', '312911008', '312912001', '312920004', '312921000',
        '312922007', '314010006', '314011005', '314014002', '314015001', '37231002', '399864000',
        '420486006', '421779007', '432789001'
    }


class ProstateCancerPrimaryTumorSizeT1C(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1325'
    VALUE_SET_NAME = 'Prostate Cancer Primary Tumor Size T1c'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'433351000124101'}


class ProstateCancerPrimaryTumorSizeT2A(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1326'
    VALUE_SET_NAME = 'Prostate Cancer Primary Tumor Size T2a'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'433361000124104'}


class CognitiveAssessment(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1332'
    VALUE_SET_NAME = 'Cognitive Assessment'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    SNOMEDCT = {'113024001', '4719001'}


class CupToDiscRatio(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1333'
    VALUE_SET_NAME = 'Cup to Disc Ratio'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'71484-0', '71485-7'}


class OpticDiscExamForStructuralAbnormalities(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1334'
    VALUE_SET_NAME = 'Optic Disc Exam for Structural Abnormalities'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    LOINC = {'71486-5', '71487-3'}


class AdhesionsAndDisruptionsOfIrisAndCiliaryBody(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1405'
    VALUE_SET_NAME = 'Adhesions and Disruptions of Iris and Ciliary Body'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H2140', 'H2141', 'H2142', 'H2143', 'H21501', 'H21502', 'H21503', 'H21509', 'H21511',
        'H21512', 'H21513', 'H21519', 'H21521', 'H21522', 'H21523', 'H21529', 'H21531', 'H21532',
        'H21533', 'H21539', 'H21541', 'H21542', 'H21543', 'H21549', 'H21551', 'H21552', 'H21553',
        'H21559', 'H21561', 'H21562', 'H21563', 'H21569', 'H2181', 'H2182', 'H2189', 'H22'
    }

    ICD9CM = {
        '36470', '36471', '36472', '36473', '36474', '36475', '36476', '36477', '36481', '36482',
        '36489'
    }

    SNOMEDCT = {
        '111512005', '1869002', '193507008', '193525001', '247034002', '247041008', '247043006',
        '251730004', '251731000', '253231007', '253232000', '253233005', '253240006', '267624002',
        '28900006', '302217008', '303019009', '370504007', '404633004', '410556000', '418106004',
        '419237004', '45953007', '55828000', '57286009', '6640008', '70992005', '75895005',
        '78778007', '95710002', '95712005', '95716008'
    }


class AnomaliesOfPupillaryFunction(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1406'
    VALUE_SET_NAME = 'Anomalies of Pupillary Function'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'H5703'}

    ICD9CM = {'37942'}

    SNOMEDCT = {'247013009', '271608006', '301939004', '419340001', '63251006'}


class AphakiaAndOtherDisordersOfLens(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1407'
    VALUE_SET_NAME = 'Aphakia and Other Disorders of Lens'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H2710', 'H27111', 'H27112', 'H27113', 'H27119', 'H27121', 'H27122', 'H27123', 'H27129',
        'H27131', 'H27132', 'H27133', 'H27139'
    }

    ICD9CM = {'37932', '37933', '37934'}

    SNOMEDCT = {
        '14169000', '231977005', '231978000', '231979008', '231980006', '37283009', '424416009',
        '65814009'
    }


class AspirationAndInjectionProcedures(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1408'
    VALUE_SET_NAME = 'Aspiration and Injection Procedures'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'66030'}

    SNOMEDCT = {'2536007', '30246007', '4143006', '416773006', '49789002'}


class BurnConfinedToEyeAndAdnexa(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1409'
    VALUE_SET_NAME = 'Burn Confined to Eye and Adnexa'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'T2600XA', 'T2601XA', 'T2602XA', 'T2610XA', 'T2611XA', 'T2612XA', 'T2620XA', 'T2621XA',
        'T2622XA', 'T2630XA', 'T2631XA', 'T2632XA', 'T2640XA', 'T2641XA', 'T2642XA', 'T2650XA',
        'T2651XA', 'T2652XA', 'T2660XA', 'T2661XA', 'T2662XA', 'T2670XA', 'T2671XA', 'T2672XA',
        'T2680XA', 'T2681XA', 'T2682XA', 'T2690XA', 'T2691XA', 'T2692XA'
    }

    ICD9CM = {'9400', '9401', '9402', '9403', '9404', '9405', '9409'}

    SNOMEDCT = {
        '110170006', '110171005', '110172003', '110173008', '16096002', '211659009', '211661000',
        '211662007', '211665009', '211666005', '211686009', '211704004', '211717001', '211725004',
        '211738007', '231819004', '231844007', '231867009', '231869007', '231884003', '231943000',
        '231945007', '232028002', '269232009', '269234005', '274204004', '274205003', '284199004',
        '284537006', '284541005', '284542003', '287132002', '287133007', '287134001', '287137008',
        '287138003', '312646002', '314531003', '38916004', '418591009', '423838005', '445832003',
        '445850005', '446234004', '446556000', '446856005', '447094002', '447095001', '447333000',
        '53642007', '63542002', '66526003', '71157005', '88552007'
    }


class CataractSecondaryToOcularDisorders(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1410'
    VALUE_SET_NAME = 'Cataract Secondary to Ocular Disorders'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'H26211', 'H26212', 'H26213', 'H26219', 'H26221', 'H26222', 'H26223', 'H26229'}

    ICD9CM = {'36632', '36633'}

    SNOMEDCT = {'193600001', '193602009', '21818003', '23273003', '67733005', '76309006'}


class CataractSurgery(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1411'
    VALUE_SET_NAME = 'Cataract Surgery'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'66840', '66850', '66852', '66920', '66930', '66940', '66982', '66983', '66984'}

    SNOMEDCT = {
        '10178000', '110473004', '112963003', '112964009', '12163000', '231744001', '308694002',
        '308695001', '313999004', '31705006', '335636001', '336651000', '35717002', '361191005',
        '385468004', '39243005', '397544007', '404628003', '415089008', '417493007', '418430006',
        '419767009', '420260004', '420526005', '424945000', '446548003', '46309001', '46426006',
        '46562009', '50538003', '5130002', '51839008', '54885007', '65812008', '67760003',
        '69360005', '74490003', '75814005', '79611007', '82155009', '84149000', '85622008',
        '88282000', '89153001', '9137006'
    }


class CataractCongenital(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1412'
    VALUE_SET_NAME = 'Cataract, Congenital'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'Q120'}

    ICD9CM = {'74330'}

    SNOMEDCT = {
        '204128001', '204130004', '204138006', '204139003', '21590003', '253223002', '253224008',
        '253225009', '253226005', '253227001', '268159001', '28550007', '29590001', '63912009',
        '66499004', '76562003', '79410001'
    }


class CataractMatureOrHypermature(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1413'
    VALUE_SET_NAME = 'Cataract, Mature or Hypermature'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'H269'}

    ICD9CM = {'3669'}

    SNOMEDCT = {'193590000', '264443002', '267626000', '849000', '8656007', '95724003'}


class CataractPosteriorPolar(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1414'
    VALUE_SET_NAME = 'Cataract, Posterior Polar'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'Q120'}

    ICD9CM = {'74331'}

    SNOMEDCT = {
        '111515007', '1412008', '204124004', '204125003', '315353005', '34533008', '5318001',
        '95723009'
    }


class CertainTypesOfIridocyclitis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1415'
    VALUE_SET_NAME = 'Certain Types of Iridocyclitis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H2020', 'H2021', 'H2022', 'H2023', 'H20811', 'H20812', 'H20813', 'H20819', 'H20821',
        'H20822', 'H20823', 'H20829', 'H209', 'H4040X0'
    }

    ICD9CM = {'36421', '36422', '36423', '36424', '3643'}

    SNOMEDCT = {
        '10698009', '11226001', '12630008', '13608004', '193487008', '193488003', '23798003',
        '267619000', '29538005', '30080002', '420485005', '46916006', '6869001', '70461003',
        '77971008', '89114005', '9091006'
    }


class ChronicIridocyclitis(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1416'
    VALUE_SET_NAME = 'Chronic Iridocyclitis'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {'A1854', 'H2010', 'H2011', 'H2012', 'H2013', 'H209'}

    ICD9CM = {'36410', '36411'}

    SNOMEDCT = {'186266008', '193493000', '416449002'}


class CloudyCornea(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1417'
    VALUE_SET_NAME = 'Cloudy Cornea'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H1700', 'H1701', 'H1702', 'H1703', 'H1710', 'H1711', 'H1712', 'H1713', 'H17811', 'H17812',
        'H17813', 'H17819', 'H17821', 'H17822', 'H17823', 'H17829'
    }

    ICD9CM = {'37101', '37102', '37103', '37104'}

    SNOMEDCT = {
        '204149000', '22135003', '30337003', '413921009', '424353002', '425961009', '54359000',
        '55713007', '56530002', '66104007', '72494008'
    }


class CornealEdema(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1418'
    VALUE_SET_NAME = 'Corneal Edema'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H1810', 'H1811', 'H1812', 'H1813', 'H1820', 'H18221', 'H18222', 'H18223', 'H18229',
        'H18231', 'H18232', 'H18233', 'H18239', 'H18421', 'H18422', 'H18423', 'H18429', 'H1843'
    }

    ICD9CM = {'37120', '37121', '37122', '37123', '37143', '37144'}

    SNOMEDCT = {
        '129627002', '1794009', '231921008', '231922001', '231923006', '248503005', '27194006',
        '27536004', '49362009', '57207003'
    }


class CornealOpacityAndOtherDisordersOfCornea(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1419'
    VALUE_SET_NAME = 'Corneal Opacity and Other Disorders of Cornea'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H1700', 'H1701', 'H1702', 'H1703', 'H1710', 'H1711', 'H1712', 'H1713', 'H1789', 'H179'
    }

    ICD9CM = {'37100', '37103', '37104'}

    SNOMEDCT = {
        '13282008', '16350000', '204149000', '22135003', '268160006', '30337003', '413921009',
        '419496009', '424353002', '425961009', '54359000', '55713007', '56530002', '64634000',
        '66104007', '72494008', '95479005'
    }


class CystsOfIrisCiliaryBodyAndAnteriorChamber(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1420'
    VALUE_SET_NAME = 'Cysts of Iris, Ciliary Body, and Anterior Chamber'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H21301', 'H21302', 'H21303', 'H21309', 'H21311', 'H21312', 'H21313', 'H21319', 'H21321',
        'H21322', 'H21323', 'H21329', 'H21331', 'H21332', 'H21333', 'H21339', 'H21341', 'H21342',
        'H21343', 'H21349', 'H21351', 'H21352', 'H21353', 'H21359'
    }

    ICD9CM = {'36460', '36461', '36462', '36463', '36464'}

    SNOMEDCT = {'193511002', '193515006', '267621005', '47269005', '63317005'}


class Enophthalmos(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1421'
    VALUE_SET_NAME = 'Enophthalmos'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H05401', 'H05402', 'H05403', 'H05409', 'H05411', 'H05412', 'H05413', 'H05419', 'H05421',
        'H05422', 'H05423', 'H05429'
    }

    ICD9CM = {'37650', '37651', '37652'}

    SNOMEDCT = {'14858001', '194029009', '52102006', '80093006', '95773007'}


class ExcisionOfAdhesions(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1422'
    VALUE_SET_NAME = 'Excision of Adhesions'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    CPT = {'65860', '65880'}

    SNOMEDCT = {'438601000', '76240002'}


class Glaucoma(ValueSet):
    """

    Clinical Focus: Under Development
    Data Element Scope: Under Development
    Inclusion Criteria: Under Development
    Exclusion Criteria: Under Development
    """

    OID = '2.16.840.1.113883.3.526.3.1423'
    VALUE_SET_NAME = 'Glaucoma'
    EXPANSION_VERSION = 'eCQM Update 2017-05-05'

    ICD10CM = {
        'H4010X0', 'H4010X1', 'H4010X2', 'H4010X3', 'H4010X4', 'H401110', 'H401111', 'H401112',
        'H401113', 'H401114', 'H401120', 'H401121', 'H401122', 'H401123', 'H401124', 'H401130',
        'H401131', 'H401132', 'H401133', 'H401134', 'H401190', 'H401191', 'H401192', 'H401193',
        'H401194', 'H4011X0', 'H4011X1', 'H4011X2', 'H4011X3', 'H4011X4', 'H401210', 'H401211',
        'H401212', 'H401213', 'H401214', 'H401220', 'H401221', 'H401222', 'H401223', 'H401224',
        'H401230', 'H401231', 'H401232', 'H401233', 'H401234', 'H401290', 'H401291', 'H401292',
        'H401293', 'H401294', 'H401310', 'H401311', 'H401312', 'H401313', 'H401314', 'H401320',
        'H401321', 'H401322', 'H401323', 'H401324', 'H401330', 'H401331', 'H401332', 'H401333',
        'H401334', 'H401390', 'H401391', 'H401392', 'H401393', 'H401394', 'H401410', 'H401411',
        'H401412', 'H401413', 'H401414', 'H401420', 'H401421', 'H401422', 'H401423', 'H401424',
        'H401430', 'H401431', 'H401432', 'H401433', 'H401434', 'H401490', 'H401491', 'H401492',
        'H401493', 'H401494', 'H40151', 'H40152', 'H40153', 'H40159', 'H4020X0', 'H4020X1',
        'H4020X2', 'H4020X3', 'H4020X4', 'H40211', 'H40212', 'H40213', 'H40219', 'H402210',
        'H402211', 'H402212', 'H402213', 'H402214', 'H402220', 'H402221', 'H402222', 'H402223',
        'H402224', 'H402230', 'H402231', 'H402232', 'H402233', 'H402234', 'H402290', 'H402291',
        'H402292', 'H402293', 'H402294', 'H40231', 'H40232', 'H40233', 'H40239', 'H40241',
        'H40242', 'H40243', 'H40249', 'H4030X0', 'H4030X1', 'H4030X2', 'H4030X3', 'H4030X4',
        'H4031X0', 'H4031X1', 'H4031X2', 'H4031X3', 'H4031X4', 'H4032X0', 'H4032X1', 'H4032X2',
        'H4032X3', 'H4032X4', 'H4033X0', 'H4033X1', 'H4033X2', 'H4033X3', 'H4033X4', 'H4040X0',
        'H4040X1', 'H4040X2', 'H4040X3', 'H4040X4', 'H4041X0', 'H4041X1', 'H4041X2', 'H4041X3',
        'H4041X4', 'H4042X0', 'H4042X1', 'H4042X2', 'H4042X3', 'H4042X4', 'H4043X0', 'H4043X1',
        'H4043X2', 'H4043X3', 'H4043X4', 'H4050X0', 'H4050X1', 'H4050X2', 'H4050X3', 'H4050X4',
        'H4051X0', 'H4051X1', 'H4051X2', 'H4051X3', 'H4051X4', 'H4052X0', 'H4052X1', 'H4052X2',
        'H4052X3', 'H4052X4', 'H4053X0', 'H4053X1', 'H4053X2', 'H4053X3', 'H4053X4', 'H4060X0',
        'H4060X1', 'H4060X2', 'H4060X3', 'H4060X4', 'H4061X0', 'H4061X1', 'H4061X2', 'H4061X3',
        'H4061X4', 'H4062X0', 'H4062