"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Endpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Connection endpoint of a redshift cluster
 *
 * Consists of a combination of hostname and port.
 */
class Endpoint {
    constructor(address, port) {
        this.hostname = address;
        this.port = port;
        const portDesc = aws_cdk_lib_1.Token.isUnresolved(port) ? aws_cdk_lib_1.Token.asString(port) : port;
        this.socketAddress = `${address}:${portDesc}`;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Endpoint[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.Endpoint", version: "2.72.1-alpha.0" };
exports.Endpoint = Endpoint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5kcG9pbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbmRwb2ludC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFvQztBQUVwQzs7OztHQUlHO0FBQ0gsTUFBYSxRQUFRO0lBZ0JuQixZQUFZLE9BQWUsRUFBRSxJQUFZO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsT0FBTyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLG1CQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxtQkFBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ3hFLElBQUksQ0FBQyxhQUFhLEdBQUcsR0FBRyxPQUFPLElBQUksUUFBUSxFQUFFLENBQUM7S0FDL0M7Ozs7QUF0QlUsNEJBQVEiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBUb2tlbiB9IGZyb20gJ2F3cy1jZGstbGliJztcblxuLyoqXG4gKiBDb25uZWN0aW9uIGVuZHBvaW50IG9mIGEgcmVkc2hpZnQgY2x1c3RlclxuICpcbiAqIENvbnNpc3RzIG9mIGEgY29tYmluYXRpb24gb2YgaG9zdG5hbWUgYW5kIHBvcnQuXG4gKi9cbmV4cG9ydCBjbGFzcyBFbmRwb2ludCB7XG4gIC8qKlxuICAgKiBUaGUgaG9zdG5hbWUgb2YgdGhlIGVuZHBvaW50XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgaG9zdG5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHBvcnQgb2YgdGhlIGVuZHBvaW50XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgcG9ydDogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBUaGUgY29tYmluYXRpb24gb2YgXCJIT1NUTkFNRTpQT1JUXCIgZm9yIHRoaXMgZW5kcG9pbnRcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzb2NrZXRBZGRyZXNzOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IoYWRkcmVzczogc3RyaW5nLCBwb3J0OiBudW1iZXIpIHtcbiAgICB0aGlzLmhvc3RuYW1lID0gYWRkcmVzcztcbiAgICB0aGlzLnBvcnQgPSBwb3J0O1xuXG4gICAgY29uc3QgcG9ydERlc2MgPSBUb2tlbi5pc1VucmVzb2x2ZWQocG9ydCkgPyBUb2tlbi5hc1N0cmluZyhwb3J0KSA6IHBvcnQ7XG4gICAgdGhpcy5zb2NrZXRBZGRyZXNzID0gYCR7YWRkcmVzc306JHtwb3J0RGVzY31gO1xuICB9XG59Il19