"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const aws_sdk_1 = require("aws-sdk");
const redshift = new aws_sdk_1.Redshift();
async function handler(event) {
    if (event.RequestType !== 'Delete') {
        return rebootClusterIfRequired(event.ResourceProperties?.ClusterId, event.ResourceProperties?.ParameterGroupName);
    }
    else {
        return;
    }
}
exports.handler = handler;
async function rebootClusterIfRequired(clusterId, parameterGroupName) {
    return executeActionForStatus(await getApplyStatus());
    // https://docs.aws.amazon.com/redshift/latest/APIReference/API_ClusterParameterStatus.html
    async function executeActionForStatus(status, retryDurationMs) {
        await sleep(retryDurationMs ?? 0);
        if (['pending-reboot', 'apply-deferred', 'apply-error'].includes(status)) {
            try {
                await redshift.rebootCluster({ ClusterIdentifier: clusterId }).promise();
            }
            catch (err) {
                if (err.code === 'InvalidClusterState') {
                    return await executeActionForStatus(status, 30000);
                }
                else {
                    throw err;
                }
            }
            return;
        }
        else if (['applying', 'retry'].includes(status)) {
            return executeActionForStatus(await getApplyStatus(), 30000);
        }
        return;
    }
    async function getApplyStatus() {
        const clusterDetails = await redshift.describeClusters({ ClusterIdentifier: clusterId }).promise();
        if (clusterDetails.Clusters?.[0].ClusterParameterGroups === undefined) {
            throw new Error(`Unable to find any Parameter Groups associated with ClusterId "${clusterId}".`);
        }
        for (const group of clusterDetails.Clusters?.[0].ClusterParameterGroups) {
            if (group.ParameterGroupName === parameterGroupName) {
                return group.ParameterApplyStatus ?? 'retry';
            }
        }
        throw new Error(`Unable to find Parameter Group named "${parameterGroupName}" associated with ClusterId "${clusterId}".`);
    }
}
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
//# sourceMappingURL=data:application/json;base64,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