import * as ec2 from '@aws-cdk/aws-ec2';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
import * as patterns from './index';
export interface WordPressProps {
    readonly vpc?: ec2.IVpc;
    /**
     * VPC subnets for database
     *
     * @default - VPC isolated subnets
     */
    readonly databaseSubnets?: ec2.SubnetSelection;
    /**
     * Database instance type
     *
     * @default r5.large
     */
    readonly databaseInstanceType?: ec2.InstanceType;
    /**
     * The database instance engine
     *
     * @default - MySQL 8.0.21
     */
    readonly instanceEngine?: rds.IInstanceEngine;
    /**
     * The database cluster engine
     *
     * @default rds.AuroraMysqlEngineVersion.VER_2_09_1
     */
    readonly clusterEngine?: rds.IClusterEngine;
    /**
     * Whether to use aurora serverless. When enabled, the `databaseInstanceType` and
     * `engine` will be ignored. The `rds.DatabaseClusterEngine.AURORA_MYSQL` will be used as
     * the default cluster engine instead.
     *
     * @default false
     */
    readonly auroraServerless?: boolean;
    /**
     * Whether to use single RDS instance rather than RDS cluster. Not recommended for production.
     *
     * @default false
     */
    readonly singleDbInstance?: boolean;
    /**
     * database backup retension
     *
     * @default - 7 days
     */
    readonly backupRetention?: cdk.Duration;
    /**
     * task options for the WordPress fargate service
     */
    readonly serviceProps?: patterns.FargateTaskProps;
    /**
     * enable fargate spot
     */
    readonly spot?: boolean;
    /**
     * enable ECS Exec
     */
    readonly enableExecuteCommand?: boolean;
}
export declare class WordPress extends cdk.Construct {
    readonly vpc: ec2.IVpc;
    readonly db?: Database;
    readonly svc: patterns.DualAlbFargateService;
    constructor(scope: cdk.Construct, id: string, props?: WordPressProps);
    private addDatabase;
}
export interface DatabaseProps {
    /**
     * The VPC for the database
     */
    readonly vpc: ec2.IVpc;
    /**
     * VPC subnets for database
     */
    readonly databaseSubnets?: ec2.SubnetSelection;
    /**
     * The database instance type
     *
     * @default r5.large
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * The database instance engine
     *
     * @default - MySQL 8.0.21
     */
    readonly instanceEngine?: rds.IInstanceEngine;
    /**
     * The database cluster engine
     *
     * @default rds.AuroraMysqlEngineVersion.VER_2_09_1
     */
    readonly clusterEngine?: rds.IClusterEngine;
    /**
     * enable aurora serverless
     *
     * @default false
     */
    readonly auroraServerless?: boolean;
    /**
     * Whether to use single RDS instance rather than RDS cluster. Not recommended for production.
     *
     * @default false
     */
    readonly singleDbInstance?: boolean;
    /**
     * database backup retension
     *
     * @default - 7 days
     */
    readonly backupRetention?: cdk.Duration;
    /**
     * Allow database connection.
     * @default - the whole VPC CIDR
     */
    readonly allowFrom?: ec2.IConnectable;
}
/**
 * Database configuration
 */
export interface DatabaseCofig {
    /**
     * The database secret.
     */
    readonly secret: secretsmanager.ISecret;
    /**
     * The database connnections.
     */
    readonly connections: ec2.Connections;
    /**
     * The endpoint address for the database.
     */
    readonly endpoint: string;
    /**
     * The databasae identifier.
     */
    readonly identifier: string;
}
/**
 * Represents the database instance or database cluster
 */
export declare class Database extends cdk.Construct {
    readonly vpc: ec2.IVpc;
    readonly clusterEndpointHostname: string;
    readonly clusterIdentifier: string;
    readonly secret: secretsmanager.ISecret;
    readonly connections: ec2.Connections;
    private readonly _mysqlListenerPort;
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
    private _createRdsInstance;
    private _createRdsCluster;
    private _createServerlessCluster;
}
