from os import error
from typing import Any
from fastapi import FastAPI
from fastapi import APIRouter, Request
from fastapi.logger import logger
from fastapi.staticfiles import StaticFiles
from starlette.responses import JSONResponse, FileResponse
from starlette.middleware.cors import CORSMiddleware
from starlette.datastructures import URL

import logging

from beastiary.api.endpoints import traces, samples

api = FastAPI()

gunicorn_logger = logging.getLogger("gunicorn.error")
logger.handlers = gunicorn_logger.handlers
logger.setLevel(gunicorn_logger.level)


@api.get("/")
async def index():
    return FileResponse("beastiary/webapp-dist/index.html")


@api.get("/api/security/token", tags=["security"])
async def test_token() -> Any:
    return {"token": api.token}


api_router = APIRouter(prefix="/api")
api_router.include_router(samples.router, prefix="/samples", tags=["samples"])
api_router.include_router(traces.router, prefix="/traces", tags=["traces"])
api.include_router(api_router)

api.mount("/", StaticFiles(directory="beastiary/webapp-dist"))

# replace with https://tiangolo.medium.com/nice-a6eafd9a7bca
# probably need some switch to run it off
# auto_error: bool = False
@api.middleware("http")
async def auth_check(request: Request, call_next):
    if "/api/" in request.url.path and request.app.security == True:
        token = request.headers.get("Authorization")
        if not token:
            return JSONResponse(
                content={"detail": "Authorization header not provided!"},
                status_code=401,
            )
        else:
            token = token.split()[1]
        if token != request.app.token:
            return JSONResponse(content={"detail": "Invalid token!"}, status_code=401)
    response = await call_next(request)
    return response


@api.middleware("http")
async def add_custom_header(request: Request, call_next):
    response = await call_next(request)
    if response.status_code == 404 and "/api/" not in request.url.path:
        return FileResponse("beastiary/webapp-dist/index.html")
    return response


api.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)
