_CONTENT = {
	'bootstrap': '''#!/bin/bash
set -e
set -x

which python3 || which python
#which virtualenv
which poetry

poetry install''',

	'console': '''#!/bin/bash
set -e
set -x

poetry run python manage.py shell''',

	'server': '''#!/bin/bash
set -e
set -x

poetry run python manage.py runserver 0.0.0.0:8000''',

	'setup': '''#!/bin/bash
set -e
set -x

script/bootstrap

# Create .env if not present
MAIN_FOLDER={{ name }}
if [ ! -e $MAIN_FOLDER/.env ]; then
	# Copy template
	cp $MAIN_FOLDER/.env.example $MAIN_FOLDER/.env
	# Create secret key (TODO: find a crypto-safer way like /dev/random)
	SECRET=$(mcookie)
	sed -i 's|DJANGO_SECRET_KEY=""|DJANGO_SECRET_KEY="'$SECRET'"|g' $MAIN_FOLDER/.env
	# Show
	cat $MAIN_FOLDER/.env
	echo ".env has been autogenerated, to edit: $ nano $MAIN_FOLDER/.env"
fi
# Clear SQLite database if present
if [ -e db.sqlite3 ]; then
        mv db.sqlite3 db.sqlite3~
fi
# Run migrations
poetry run python manage.py migrate''',

	'test': '''#!/bin/bash
set -e
set -x


lint() {
	poetry run flake8 --select=C,F,E101,E112,E502,E72,E73,E74,E9,W291,W6 --exclude=.cache,migrations
}


case $# in 
	0)
		lint
		poetry run pytest
		poetry run ./manage.py makemigrations --check --dry-run
		;;
	1)
		case $1 in 
			'--lint')
				lint
				;;
			*)
				printf 'Incorrect arg: %s\n' $1 >&2
				exit 2
				;;
		esac
		;;
	*)
		echo 'Incorrect count of args' >&2
		exit 2
		;;
esac''',

	'update': '''#!/bin/bash
set -e
set -x

script/bootstrap
poetry run python manage.py migrate''',

	'cibuild': '''#!/bin/bash
set -e
set -x

export CI=true
script/test''',

	'x-clean': '''#!/bin/bash
set -e
set -x

find -depth -name '__pycache__' -exec rm -rfv '{}' ';'
'''
}
_SYMLINKS = {
	'shell': 'console',
	'run': 'server',
}
