"""
Copyright 2018-2020 Skyscanner Ltd

Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
"""
from enum import Enum


class RuleMode(str, Enum):
    # Rule modes
    BLOCKING = "BLOCKING"
    MONITOR = "MONITOR"
    DEBUG = "DEBUG"
    WHITELISTED = "WHITELISTED"
    DISABLED = "DISABLED"


class RuleRisk(str, Enum):
    # Rule risk severity
    LOW = "LOW"
    MEDIUM = "MEDIUM"
    HIGH = "HIGH"


class RuleGranularity(str, Enum):
    # Rule
    ACTION = "ACTION"
    RESOURCE = "RESOURCE"
    STACK = "STACK"
