"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderAmazon = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cognito_generated_1 = require("../cognito.generated");
const user_pool_idp_base_1 = require("./private/user-pool-idp-base");
/**
 * Represents a identity provider that integrates with 'Login with Amazon'
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderAmazon extends user_pool_idp_base_1.UserPoolIdentityProviderBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_UserPoolIdentityProviderAmazonProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const scopes = (_b = props.scopes) !== null && _b !== void 0 ? _b : ['profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'LoginWithAmazon',
            providerType: 'LoginWithAmazon',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
            },
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderAmazon = UserPoolIdentityProviderAmazon;
_a = JSII_RTTI_SYMBOL_1;
UserPoolIdentityProviderAmazon[_a] = { fqn: "@aws-cdk/aws-cognito.UserPoolIdentityProviderAmazon", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,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