import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "aws-solutions-constructs.aws-cloudfront-s3",
    "version": "1.59.0",
    "description": "CDK Constructs for AWS Cloudfront to AWS S3 integration.",
    "license": "Apache-2.0",
    "url": "https://github.com/awslabs/aws-solutions-constructs.git",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/awslabs/aws-solutions-constructs.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_solutions_constructs.aws_cloudfront_s3",
        "aws_solutions_constructs.aws_cloudfront_s3._jsii"
    ],
    "package_data": {
        "aws_solutions_constructs.aws_cloudfront_s3._jsii": [
            "aws-cloudfront-s3@1.59.0.jsii.tgz"
        ],
        "aws_solutions_constructs.aws_cloudfront_s3": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "aws-cdk.aws-cloudfront>=1.59.0, <1.60.0",
        "aws-cdk.aws-lambda>=1.59.0, <1.60.0",
        "aws-cdk.aws-s3>=1.59.0, <1.60.0",
        "aws-cdk.core>=1.59.0, <1.60.0",
        "aws-solutions-constructs.core>=1.59.0, <1.60.0",
        "constructs>=3.0.2, <4.0.0",
        "jsii>=1.11.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "License :: OSI Approved"
    ]
}
"""
)

with open("README.md") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
