<img align="right" src="https://assinews-assinformdalcine.netdna-ssl.com/wp-content/uploads/2017/02/facileit.png" alt="mypy logo" width="180"/>
</p>
<img align="left" src=https://img.shields.io/badge/pylint-9.88-green alt="my_badge" width="60px" />
</p>

# Facile GitLab Helper

This library provides help to microservices inside gitLab C.I pipelines, integrating different repositories within different pipelines and projects.

## Getting Started

Open the terminal and install the given library:

```python
pip install facile-gitlab-trigger
```

Execute the command below to make sure the library has been installed correctly:

```python
facile-trigger --help
```

The list of commands below should be displayed:

```shell
usage: facile-trigger -a GITLAB_API_TOKEN [-h GIT_LAB_HOST] [--help] [-t TARGET_BRANCH] -p PROJECT_ID -b
                      REF_NAME -f YAML_FILE

Gilab trigger helper

optional arguments:
  -a GITLAB_API_TOKEN, --api-token GITLAB_API_TOKEN
                        personal access token (not required when running detached)
  -h GIT_LAB_HOST, --host GIT_LAB_HOST
  --help                show this help message and exit
  -t TARGET_BRANCH, --target-ref TARGET_BRANCH
                        target ref (branch, tag, commit)
  -p PROJECT_ID, --project-id PROJECT_ID
                        repository id found on settings
  -b REF_NAME, --branch-merged REF_NAME
                        filled by git COMMIT_REF_NAME
  -f YAML_FILE, --yaml-file YAML_FILE
                        filled by git COMMIT_REF_NAME
```

## Usage

Running a pipeline with Facile GitLab Helper requires only few steps.
Use the arguments below in order to run a pipeline:

##### Branch Title

This argument can be dynamically filled using gitlab variables, like $CI_COMMIT_TITLE. In this case, Facile GitLab Helper will get the string provided by the given variable and will match it with the running rules lists - which are stored in the .yaml file. So, tests will run a specific path, based on the ID provided in the string. E.g. let's say our variable "$CI_COMMIT_TITLE" contains "PROJECT_NAME", tests will only run the specific path to the project, accordingly with the running rules lists.

##### Project ID

It's the ID shown on gitLab Project Root>>Settings>>Geral.

##### API Key

This can be generated by going on user Profile >> Access Tokens >> Add a personal access token. Use the generated value for this argument.

##### Gitlab Host Domain

Here goes the gitlab domain: "https://gitlab.domain_name/". For example, facile.it domain would be "https://gitlab.facile.it/".

##### Target Branch

This should be the branch we want the tests to run against. It could be "master", "develop" and so on.

##### Yaml File

This should be the .yaml file (or files) which provides the rules based on the "ID"s:

```yaml
NLT: Tests/noleggio.robot
ABC: Tests/abc.robot
```

For instance, if the branch title contains "NTL", test automation will run the test path Tests/noleggio.robot if it contains "ABC", then Tests/abc.robot will run. So, -f should be the path to where you created your .yaml rules file.
Below you can find an example of a full command to run a pipeline:

```shell
facile-trigger -b <branch_title> -p <project_id> -a <api_key> -h <gitlab_host_domain> -t <target_branch> -f <yaml_file>
```