"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynchronousPromise = void 0;
const worker_threads_1 = require("worker_threads");
/**
 * Blocks the main thread to wait for Promise to complete.
 * Granted this is an anti-pattern in TypeScript, but if you dare to block the main thread this will do it.
 * This is usefull in JSII export languages can use this library directly wihtout having to deal with callbacks.
 */
class SynchronousPromise {
    /**
       * You must prepare a file with a class that implements AsyncRunner.
       * AsyncRunner returns a Promise which this class will wait on to complete.
       * Note: The inputs and outputs from this method must be serializable.
       * @param classFile The file which will be "require"ed.
       * @param className The name of the class which implements AsyncRunner.
       * @param funcArgs The args to pass to the AsyncRunner implementation
       * @param timeout The amount of time in seconds after which this function will stop waiting and return.
       * @returns The result of the Promise upon completion.
       */
    wait(classFile, className, funcArgs, timeout = 10000) {
        const fullClassFile = require.resolve(classFile);
        console.log('Found full class file: ' + fullClassFile);
        const args = [...funcArgs, className, fullClassFile];
        const worker = new worker_threads_1.Worker(require.resolve('./worker.js'));
        const signal = new Int32Array(new SharedArrayBuffer(4));
        signal[0] = 0;
        try {
            const subChannel = new worker_threads_1.MessageChannel();
            worker.postMessage({ signal, port: subChannel.port1, args }, [
                subChannel.port1,
            ]);
            // Sleep until the other thread sets signal[0] to 1
            Atomics.wait(signal, 0, 0, timeout);
            // Read the message (result) from the worker synchronously
            return worker_threads_1.receiveMessageOnPort(subChannel.port2)?.message.result;
        }
        finally {
            worker.unref();
        }
    }
}
exports.SynchronousPromise = SynchronousPromise;
//# sourceMappingURL=data:application/json;base64,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