import { AsyncRunner } from './async-runner';
/**
 * Runs the Python execution and returns a promise with the Python result.
 * This is used with SynchronousPromise to wait for the result from the Python execution synchronously.
 */
export declare class PythonAsyncRunner implements AsyncRunner {
    /**
       * Expect args to be a list with 3 values:
       * 1. The path of the python script.
       * 2. The function name to execute in the above script.
       * 3. The arguments to deliver to the above function.
       */
    runAsync(args: any[]): Promise<any>;
}
