"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const __1 = require("../..");
const automation_document_1 = require("../../document/automation-document");
// eslint-disable-next-line
const yaml = require('js-yaml');
/**
 * This AutomationDocument supports declaring your document from an existing document (JSON/YAML String/File).
 * Importing an existing file allows for benefiting from the simulated execution.
 * The simulated execution will run locally in the same fashion that SSM Execution would run the document.
 * You can supply mocks to the simulator and validate the calls and the flow of the document without running via SSM execution.
 */
class StringDocument {
    /**
       * Create an AutomationDocument from an existing AutomationDocument yaml or json file.
       * Note: This function will deduce whether the file is written in yaml or json based on whether it has a .yaml or .yml extention.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromFile(stack, id, documentFilePath) {
        const contents = fs.readFileSync(documentFilePath, 'utf8');
        if (documentFilePath.endsWith('yaml') || documentFilePath.endsWith('yml')) {
            return StringDocument.fromYaml(stack, id, contents);
        }
        else {
            return StringDocument.fromJson(stack, id, contents);
        }
    }
    /**
       * Create an AutomationDocument from an existing yaml string.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromYaml(stack, id, documentYaml) {
        return StringDocument.toAutomationDoc(stack, id, { ...yaml.load(documentYaml), documentFormat: __1.DocumentFormat.YAML });
    }
    /**
       * Create an AutomationDocument from an existing json string.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromJson(stack, id, documentJson) {
        return StringDocument.toAutomationDoc(stack, id, { ...JSON.parse(documentJson), documentFormat: __1.DocumentFormat.JSON });
    }
    // This must be static because it is called prior to the super call in the constructor
    static toDocProps(id, params) {
        return {
            documentName: id,
            docInputs: this.toDocInputs(params.parameters),
            ...params,
        };
    }
    static toDocInputs(parameters) {
        return Object.entries(parameters).map(entry => this.toDocInput(entry[0], entry[1]));
    }
    static toDocInput(inputName, inputData) {
        return {
            name: inputName,
            inputType: __1.DataType.fromDataType(inputData.type).dataTypeEnum,
            defaultValue: inputData.default,
            ...inputData,
        };
    }
    static toAutomationDoc(stack, id, params) {
        const docProps = StringDocument.toDocProps(id, params);
        const doc = new automation_document_1.AutomationDocument(stack, id, docProps);
        const steps = params.mainSteps;
        steps.forEach(step => {
            doc.addStep(__1.StringStep.fromObject(stack, step));
        });
        return doc;
    }
}
exports.StringDocument = StringDocument;
_a = JSII_RTTI_SYMBOL_1;
StringDocument[_a] = { fqn: "@cdklabs/cdk-ssm-documents.StringDocument", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RyaW5nLWRvY3VtZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3BhdHRlcm5zL2RvY3VtZW50L3N0cmluZy1kb2N1bWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHlCQUF5QjtBQUV6Qiw2QkFBb0U7QUFDcEUsNEVBQWlHO0FBQ2pHLDJCQUEyQjtBQUMzQixNQUFNLElBQUksR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDLENBQUM7QUFFaEM7Ozs7O0dBS0c7QUFDSCxNQUFhLGNBQWM7SUFFekI7Ozs7U0FJSztJQUNFLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsZ0JBQXdCO1FBQzNFLE1BQU0sUUFBUSxHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQUMsZ0JBQWdCLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDM0QsSUFBSSxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLElBQUksZ0JBQWdCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3pFLE9BQU8sY0FBYyxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1NBQ3JEO2FBQU07WUFDTCxPQUFPLGNBQWMsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxRQUFRLENBQUMsQ0FBQztTQUNyRDtJQUNILENBQUM7SUFFRDs7O1NBR0s7SUFDRSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFlBQW9CO1FBQ3ZFLE9BQU8sY0FBYyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLGNBQWMsRUFBRSxrQkFBYyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7SUFDeEgsQ0FBQztJQUVEOzs7U0FHSztJQUNFLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsWUFBb0I7UUFDdkUsT0FBTyxjQUFjLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLEVBQUUsY0FBYyxFQUFFLGtCQUFjLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUN6SCxDQUFDO0lBRUQsc0ZBQXNGO0lBQzlFLE1BQU0sQ0FBQyxVQUFVLENBQUMsRUFBVSxFQUFFLE1BQTZCO1FBQ2pFLE9BQU87WUFDTCxZQUFZLEVBQUUsRUFBRTtZQUNoQixTQUFTLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDO1lBQzlDLEdBQUcsTUFBTTtTQUNWLENBQUM7SUFDSixDQUFDO0lBRU8sTUFBTSxDQUFDLFdBQVcsQ0FBQyxVQUFpQztRQUMxRCxPQUFPLE1BQU0sQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN0RixDQUFDO0lBRU8sTUFBTSxDQUFDLFVBQVUsQ0FBQyxTQUFpQixFQUFFLFNBQW1DO1FBQzlFLE9BQU87WUFDTCxJQUFJLEVBQUUsU0FBUztZQUNmLFNBQVMsRUFBRSxZQUFRLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxZQUFZO1lBQzdELFlBQVksRUFBRSxTQUFTLENBQUMsT0FBTztZQUMvQixHQUFHLFNBQVM7U0FDYixDQUFDO0lBQ0osQ0FBQztJQUVPLE1BQU0sQ0FBQyxlQUFlLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBNkI7UUFDeEYsTUFBTSxRQUFRLEdBQUcsY0FBYyxDQUFDLFVBQVUsQ0FBQyxFQUFFLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDdkQsTUFBTSxHQUFHLEdBQUcsSUFBSSx3Q0FBa0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQ3hELE1BQU0sS0FBSyxHQUE0QixNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ3hELEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDbkIsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFVLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQyxDQUFDO1FBQ2xELENBQUMsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDOztBQTlESCx3Q0FnRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmcyBmcm9tICdmcyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IERhdGFUeXBlLCBEb2N1bWVudEZvcm1hdCwgSW5wdXQsIFN0cmluZ1N0ZXAgfSBmcm9tICcuLi8uLic7XG5pbXBvcnQgeyBBdXRvbWF0aW9uRG9jdW1lbnQsIEF1dG9tYXRpb25Eb2N1bWVudFByb3BzIH0gZnJvbSAnLi4vLi4vZG9jdW1lbnQvYXV0b21hdGlvbi1kb2N1bWVudCc7XG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmVcbmNvbnN0IHlhbWwgPSByZXF1aXJlKCdqcy15YW1sJyk7XG5cbi8qKlxuICogVGhpcyBBdXRvbWF0aW9uRG9jdW1lbnQgc3VwcG9ydHMgZGVjbGFyaW5nIHlvdXIgZG9jdW1lbnQgZnJvbSBhbiBleGlzdGluZyBkb2N1bWVudCAoSlNPTi9ZQU1MIFN0cmluZy9GaWxlKS5cbiAqIEltcG9ydGluZyBhbiBleGlzdGluZyBmaWxlIGFsbG93cyBmb3IgYmVuZWZpdGluZyBmcm9tIHRoZSBzaW11bGF0ZWQgZXhlY3V0aW9uLlxuICogVGhlIHNpbXVsYXRlZCBleGVjdXRpb24gd2lsbCBydW4gbG9jYWxseSBpbiB0aGUgc2FtZSBmYXNoaW9uIHRoYXQgU1NNIEV4ZWN1dGlvbiB3b3VsZCBydW4gdGhlIGRvY3VtZW50LlxuICogWW91IGNhbiBzdXBwbHkgbW9ja3MgdG8gdGhlIHNpbXVsYXRvciBhbmQgdmFsaWRhdGUgdGhlIGNhbGxzIGFuZCB0aGUgZmxvdyBvZiB0aGUgZG9jdW1lbnQgd2l0aG91dCBydW5uaW5nIHZpYSBTU00gZXhlY3V0aW9uLlxuICovXG5leHBvcnQgY2xhc3MgU3RyaW5nRG9jdW1lbnQge1xuXG4gIC8qKlxuICAgICAqIENyZWF0ZSBhbiBBdXRvbWF0aW9uRG9jdW1lbnQgZnJvbSBhbiBleGlzdGluZyBBdXRvbWF0aW9uRG9jdW1lbnQgeWFtbCBvciBqc29uIGZpbGUuXG4gICAgICogTm90ZTogVGhpcyBmdW5jdGlvbiB3aWxsIGRlZHVjZSB3aGV0aGVyIHRoZSBmaWxlIGlzIHdyaXR0ZW4gaW4geWFtbCBvciBqc29uIGJhc2VkIG9uIHdoZXRoZXIgaXQgaGFzIGEgLnlhbWwgb3IgLnltbCBleHRlbnRpb24uXG4gICAgICogWW91IGNhbiB1c2UgdGhlIHJldHVybmVkIEF1dG9tYXRpb25Eb2N1bWVudCB0byBydW4gc2ltdWxhdGlvbnMgYXMgeW91IHdvdWxkIG90aGVyIGRvY3VtZW50cyBjcmVhdGVkIHVzaW5nIHRoaXMgbGlicmFyeS5cbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRmlsZShzdGFjazogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBkb2N1bWVudEZpbGVQYXRoOiBzdHJpbmcpIHtcbiAgICBjb25zdCBjb250ZW50cyA9IGZzLnJlYWRGaWxlU3luYyhkb2N1bWVudEZpbGVQYXRoLCAndXRmOCcpO1xuICAgIGlmIChkb2N1bWVudEZpbGVQYXRoLmVuZHNXaXRoKCd5YW1sJykgfHwgZG9jdW1lbnRGaWxlUGF0aC5lbmRzV2l0aCgneW1sJykpIHtcbiAgICAgIHJldHVybiBTdHJpbmdEb2N1bWVudC5mcm9tWWFtbChzdGFjaywgaWQsIGNvbnRlbnRzKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIFN0cmluZ0RvY3VtZW50LmZyb21Kc29uKHN0YWNrLCBpZCwgY29udGVudHMpO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgICAqIENyZWF0ZSBhbiBBdXRvbWF0aW9uRG9jdW1lbnQgZnJvbSBhbiBleGlzdGluZyB5YW1sIHN0cmluZy5cbiAgICAgKiBZb3UgY2FuIHVzZSB0aGUgcmV0dXJuZWQgQXV0b21hdGlvbkRvY3VtZW50IHRvIHJ1biBzaW11bGF0aW9ucyBhcyB5b3Ugd291bGQgb3RoZXIgZG9jdW1lbnRzIGNyZWF0ZWQgdXNpbmcgdGhpcyBsaWJyYXJ5LlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21ZYW1sKHN0YWNrOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGRvY3VtZW50WWFtbDogc3RyaW5nKSB7XG4gICAgcmV0dXJuIFN0cmluZ0RvY3VtZW50LnRvQXV0b21hdGlvbkRvYyhzdGFjaywgaWQsIHsgLi4ueWFtbC5sb2FkKGRvY3VtZW50WWFtbCksIGRvY3VtZW50Rm9ybWF0OiBEb2N1bWVudEZvcm1hdC5ZQU1MIH0pO1xuICB9XG5cbiAgLyoqXG4gICAgICogQ3JlYXRlIGFuIEF1dG9tYXRpb25Eb2N1bWVudCBmcm9tIGFuIGV4aXN0aW5nIGpzb24gc3RyaW5nLlxuICAgICAqIFlvdSBjYW4gdXNlIHRoZSByZXR1cm5lZCBBdXRvbWF0aW9uRG9jdW1lbnQgdG8gcnVuIHNpbXVsYXRpb25zIGFzIHlvdSB3b3VsZCBvdGhlciBkb2N1bWVudHMgY3JlYXRlZCB1c2luZyB0aGlzIGxpYnJhcnkuXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUpzb24oc3RhY2s6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgZG9jdW1lbnRKc29uOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gU3RyaW5nRG9jdW1lbnQudG9BdXRvbWF0aW9uRG9jKHN0YWNrLCBpZCwgeyAuLi5KU09OLnBhcnNlKGRvY3VtZW50SnNvbiksIGRvY3VtZW50Rm9ybWF0OiBEb2N1bWVudEZvcm1hdC5KU09OIH0pO1xuICB9XG5cbiAgLy8gVGhpcyBtdXN0IGJlIHN0YXRpYyBiZWNhdXNlIGl0IGlzIGNhbGxlZCBwcmlvciB0byB0aGUgc3VwZXIgY2FsbCBpbiB0aGUgY29uc3RydWN0b3JcbiAgcHJpdmF0ZSBzdGF0aWMgdG9Eb2NQcm9wcyhpZDogc3RyaW5nLCBwYXJhbXM6IHtbbmFtZTogc3RyaW5nXTogYW55fSk6IEF1dG9tYXRpb25Eb2N1bWVudFByb3BzIHtcbiAgICByZXR1cm4ge1xuICAgICAgZG9jdW1lbnROYW1lOiBpZCxcbiAgICAgIGRvY0lucHV0czogdGhpcy50b0RvY0lucHV0cyhwYXJhbXMucGFyYW1ldGVycyksXG4gICAgICAuLi5wYXJhbXMsXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIHRvRG9jSW5wdXRzKHBhcmFtZXRlcnM6IHtbbmFtZTogc3RyaW5nXTogYW55fSk6IElucHV0W10ge1xuICAgIHJldHVybiBPYmplY3QuZW50cmllcyhwYXJhbWV0ZXJzKS5tYXAoZW50cnkgPT4gdGhpcy50b0RvY0lucHV0KGVudHJ5WzBdLCBlbnRyeVsxXSkpO1xuICB9XG5cbiAgcHJpdmF0ZSBzdGF0aWMgdG9Eb2NJbnB1dChpbnB1dE5hbWU6IHN0cmluZywgaW5wdXREYXRhOiB7W25hbWU6IHN0cmluZ106IHN0cmluZ30pOiBJbnB1dCB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5hbWU6IGlucHV0TmFtZSxcbiAgICAgIGlucHV0VHlwZTogRGF0YVR5cGUuZnJvbURhdGFUeXBlKGlucHV0RGF0YS50eXBlKS5kYXRhVHlwZUVudW0sXG4gICAgICBkZWZhdWx0VmFsdWU6IGlucHV0RGF0YS5kZWZhdWx0LFxuICAgICAgLi4uaW5wdXREYXRhLFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyB0b0F1dG9tYXRpb25Eb2Moc3RhY2s6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcGFyYW1zOiB7W25hbWU6IHN0cmluZ106IGFueX0pIHtcbiAgICBjb25zdCBkb2NQcm9wcyA9IFN0cmluZ0RvY3VtZW50LnRvRG9jUHJvcHMoaWQsIHBhcmFtcyk7XG4gICAgY29uc3QgZG9jID0gbmV3IEF1dG9tYXRpb25Eb2N1bWVudChzdGFjaywgaWQsIGRvY1Byb3BzKTtcbiAgICBjb25zdCBzdGVwczoge1tuYW1lOiBzdHJpbmddOiBhbnl9W10gPSBwYXJhbXMubWFpblN0ZXBzO1xuICAgIHN0ZXBzLmZvckVhY2goc3RlcCA9PiB7XG4gICAgICBkb2MuYWRkU3RlcChTdHJpbmdTdGVwLmZyb21PYmplY3Qoc3RhY2ssIHN0ZXApKTtcbiAgICB9KTtcbiAgICByZXR1cm4gZG9jO1xuICB9XG5cbn1cbiJdfQ==