import { Construct } from 'constructs';
import { AutomationDocument } from '../../document/automation-document';
/**
 * This AutomationDocument supports declaring your document from an existing document (JSON/YAML String/File).
 * Importing an existing file allows for benefiting from the simulated execution.
 * The simulated execution will run locally in the same fashion that SSM Execution would run the document.
 * You can supply mocks to the simulator and validate the calls and the flow of the document without running via SSM execution.
 */
export declare class StringDocument {
    /**
       * Create an AutomationDocument from an existing AutomationDocument yaml or json file.
       * Note: This function will deduce whether the file is written in yaml or json based on whether it has a .yaml or .yml extention.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromFile(stack: Construct, id: string, documentFilePath: string): AutomationDocument;
    /**
       * Create an AutomationDocument from an existing yaml string.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromYaml(stack: Construct, id: string, documentYaml: string): AutomationDocument;
    /**
       * Create an AutomationDocument from an existing json string.
       * You can use the returned AutomationDocument to run simulations as you would other documents created using this library.
       */
    static fromJson(stack: Construct, id: string, documentJson: string): AutomationDocument;
    private static toDocProps;
    private static toDocInputs;
    private static toDocInput;
    private static toAutomationDoc;
}
