import { Construct } from 'constructs';
import { AutomationDocumentBuilder } from '../../document/document-builder';
import { AutomationStep } from '../../parent-steps/automation-step';
import { AssertAwsResourceStepProps } from '../../parent-steps/automation/assert-aws-resource-step';
import { CompositeAutomationStep } from './composite-step';
/**
 * Properties of WaitForAndAssertResource
 */
export interface WaitForAndAssertResourceProps extends AssertAwsResourceStepProps {
    /**
     * (Required) Value extracted from AWS response must be one of these values before asserting the desired value.
     */
    waitForValues: string[];
}
/**
 * Waits for resource value and asserts that the value is one of the desired values.
 */
export declare class WaitForAndAssertResource extends CompositeAutomationStep {
    readonly waitForValues: AutomationStep;
    readonly assertDesired: AutomationStep;
    constructor(scope: Construct, id: string, props: WaitForAndAssertResourceProps);
    addToDocument(doc: AutomationDocumentBuilder): void;
}
