"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateAgentStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const string_variable_1 = require("../../interface/variables/string-variable");
const command_step_1 = require("../command-step");
/**
 * CommandStep implementation for aws:UpdateAgent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-updateagent
 */
class UpdateAgentStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS];
        this.action = 'aws:updateAgent';
        this.agentName = props.agentName ?? new string_variable_1.HardCodedString('EC2Config');
        this.allowDowngrade = props.allowDowngrade;
        if ((props.source == undefined) == (props.sourceRegion == undefined)) {
            throw new Error('One and only one of source and sourceRegion must be provided.');
        }
        this.source = props.source ?? new string_variable_1.HardCodedString(`https://s3.${props.sourceRegion}.amazonaws.com/aws-ssm-${props.sourceRegion}/manifest.json`);
        this.targetVersion = props.targetVersion;
    }
    /**
     * Inputs required for this command include agentName allowDowngrade source and targetVersion if version other than latest is desired
     */
    listInputs() {
        const inputs = [
            this.agentName,
            this.allowDowngrade,
            this.source,
            this.targetVersion,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = {
            agentName: this.agentName,
            source: this.source,
        };
        if (this.allowDowngrade != undefined) {
            inputs.allowDowngrade = this.allowDowngrade;
        }
        if (this.targetVersion != undefined) {
            inputs.targetVersion = this.targetVersion;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.UpdateAgentStep = UpdateAgentStep;
_a = JSII_RTTI_SYMBOL_1;
UpdateAgentStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.UpdateAgentStep", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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