import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * Properties for sleep step.
 */
export interface SleepStepProps extends AutomationStepProps {
    /**
       * (Required) The amount of seconds to sleep for. May not exceed 604800.
       * This will be used in the SSM doc as well as how long to indicate sleep to the sleepHook.
       */
    readonly sleepSeconds: number;
}
/**
 * AutomationStep implemenation for aws:sleep
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-sleep.html
 */
export declare class SleepStep extends AutomationStep {
    readonly sleepSeconds: number;
    readonly action: string;
    constructor(scope: Construct, id: string, props: SleepStepProps);
    /**
       * No outputs emitted from Sleep step
       * @returns []
       */
    listOutputs(): Output[];
    /**
       * No inputs required for Sleep step
       * @returns []
       */
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
