"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunCommandStep = exports.DocumentHashTypeVariable = exports.HardCodedDocumentHashType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
class HardCodedDocumentHashType extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedDocumentHashType = HardCodedDocumentHashType;
_a = JSII_RTTI_SYMBOL_1;
HardCodedDocumentHashType[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedDocumentHashType", version: "0.0.15" };
HardCodedDocumentHashType.SHA256 = new HardCodedDocumentHashType('Sha256');
HardCodedDocumentHashType.SHA1 = new HardCodedDocumentHashType('Sha1');
class DocumentHashTypeVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['Sha256', 'Sha1'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.DocumentHashTypeVariable = DocumentHashTypeVariable;
_b = JSII_RTTI_SYMBOL_1;
DocumentHashTypeVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.DocumentHashTypeVariable", version: "0.0.15" };
/**
 * AutomationStep implementation of [aws:runCommand](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runcommand.html)
 */
class RunCommandStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:runCommand';
        this.documentName = props.documentName;
        this.targets = props.targets;
        this.parameters = props.parameters;
        this.cloudWatchOutputConfig = props.cloudWatchOutputConfig;
        this.comment = props.comment;
        this.documentHash = props.documentHash;
        this.documentHashType = props.documentHashType;
        this.notificationConfig = props.notificationConfig;
        this.outputS3BucketName = props.outputS3BucketName;
        this.outputS3KeyPrefix = props.outputS3KeyPrefix;
        this.serviceRoleArn = props.serviceRoleArn;
        this.commandTimeoutSeconds = props.commandTimeoutSeconds;
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
    }
    listOutputs() {
        return [{
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.CommandId',
                name: 'CommandId',
            }, {
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.Status',
                name: 'Status',
            }, {
                outputType: __1.DataTypeEnum.INTEGER,
                selector: '$.ResponseCode',
                name: 'ResponseCode',
            }, {
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.Output',
                name: 'Output',
            }];
    }
    listInputs() {
        const inputs = [
            this.documentName,
            this.targets,
            this.parameters,
            this.cloudWatchOutputConfig,
            this.comment,
            this.documentHash,
            this.documentHashType,
            this.notificationConfig,
            this.outputS3BucketName,
            this.outputS3KeyPrefix,
            this.serviceRoleArn,
            this.commandTimeoutSeconds,
            this.maxConcurrency,
            this.maxErrors,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const entryMap = {
            DocumentName: this.documentName,
            Parameters: this.parameters,
            CloudWatchOutputConfig: this.cloudWatchOutputConfig,
            Comment: this.comment,
            DocumentHash: this.documentHash,
            DocumentHashType: this.documentHashType,
            NotificationConfig: this.notificationConfig,
            OutputS3BucketName: this.outputS3BucketName,
            OutputS3KeyPrefix: this.outputS3KeyPrefix,
            ServiceRoleArn: this.serviceRoleArn,
            TimeoutSeconds: this.commandTimeoutSeconds,
            MaxConcurrency: this.maxConcurrency,
            MaxErrors: this.maxErrors,
        };
        if (this.targets?.resolveToStringList) {
            entryMap.InstanceIds = this.targets;
        }
        else {
            entryMap.Targets = this.targets;
        }
        return super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print()));
    }
}
exports.RunCommandStep = RunCommandStep;
_c = JSII_RTTI_SYMBOL_1;
RunCommandStep[_c] = { fqn: "@cdklabs/cdk-ssm-documents.RunCommandStep", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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