import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IBooleanVariable } from '../../interface/variables/boolean-variable';
import { IStringListVariable } from '../../interface/variables/string-list-variable';
import { HardCodedString, IStringVariable, StringVariable } from '../../interface/variables/string-variable';
import { AutomationStepProps, AutomationStep } from '../automation-step';
/**
 * Properties for ChangeInstanceStateStep
 */
export interface ChangeInstanceStateStepProps extends AutomationStepProps {
    /**
     * The IDs of the instances.
     */
    readonly instanceIds: IStringListVariable;
    /**
     * The desired state. When set to running, this action waits for the Amazon EC2 state to be Running, the Instance Status to be OK,
     * and the System Status to be OK before completing.
     */
    readonly desiredState: IDesiredStateVariable;
    /**
     * (Optional) If false, sets the instance state to the desired state. If true, asserts the desired state using polling.
     * @default false
     */
    readonly checkStateOnly?: IBooleanVariable;
    /**
     * (Optional) If set, forces the instances to stop. The instances don't have an opportunity to flush file system caches or file system metadata.
     * If you use this option, you must perform file system check and repair procedures.
     * This option isn't recommended for EC2 instances for Windows Server.
     */
    readonly force?: IBooleanVariable;
    /**
     * (Optional) Reserved.
     */
    readonly additionalInfo?: IStringVariable;
}
export interface IDesiredStateVariable extends IStringVariable {
}
export declare class HardCodedDesiredState extends HardCodedString implements IDesiredStateVariable {
    static readonly RUNNING: HardCodedDesiredState;
    static readonly STOPPED: HardCodedDesiredState;
    static readonly TERMINATED: HardCodedDesiredState;
    private constructor();
}
export declare class DesiredStateVariable extends StringVariable implements IDesiredStateVariable {
    readonly validValues: string[];
    protected assertType(value: any): void;
}
/**
 * AutomationStep implemenation for aws:changeInstanceState
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-changestate.html
 */
export declare class ChangeInstanceStateStep extends AutomationStep {
    readonly action: string;
    readonly instanceIds: IStringListVariable;
    readonly desiredState: IDesiredStateVariable;
    readonly checkStateOnly?: IBooleanVariable;
    readonly force?: IBooleanVariable;
    readonly additionalInfo?: IStringVariable;
    constructor(scope: Construct, id: string, props: ChangeInstanceStateStepProps);
    /**
       * This step has no outputs.
       */
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): Record<string, any>;
}
