"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation of aws:executeAwsApi
 */
class AwsApiStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:executeAwsApi';
        this.service = props.service;
        this.pascalCaseApi = props.pascalCaseApi;
        this.apiParams = new __1.DictFormat(props.apiParams);
        this.outputs = props.outputs;
        this.javaScriptApi = props.javaScriptApi ??
            (this.pascalCaseApi.charAt(0).toLowerCase() + this.pascalCaseApi.slice(1));
    }
    /**
       * @returns Outputs as specified in params
       */
    listOutputs() {
        return this.outputs;
    }
    /**
       * Derives the inputs by parsing the apiParams to find matches for inputs in double circle braces ("{{INPUT}}").
       * @returns list of required inputs.
       */
    listInputs() {
        return this.apiParams.requiredInputs();
    }
    toSsmEntry() {
        return super.prepareSsmEntry({
            ...{
                Service: this.service,
                Api: this.pascalCaseApi,
            },
            ...this.apiParams.format,
        });
    }
}
exports.AwsApiStep = AwsApiStep;
_a = JSII_RTTI_SYMBOL_1;
AwsApiStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AwsApiStep", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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