"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutomationStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const data_type_1 = require("../domain/data-type");
const step_1 = require("./step");
/**
 * Parent class for AutomationSteps. These steps are using in an AutomationDocument.
 * You can instantiate steps using the AutomationBuilder for convenience.
 * You can use these steps to simulate their execution (mimics the SSM run) AND to build their yaml/json declaration.
 * Control flow of the subsequent step is determined by the currently executing step.
 * The flow of the execution therefore follows a chain-of-responsibility pattern.
 * The inputs received into a step AND the outputs of previous steps are merged to form inputs of subsequent steps.
 */
class AutomationStep extends step_1.Step {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.maxAttempts = props.maxAttempts ?? AutomationStep.DEFAULT_MAX_ATTEMPTS;
        this.timeoutSeconds = props.timeoutSeconds ?? AutomationStep.DEFAULT_TIMEOUT;
        this.isEnd = props.isEnd ?? false;
        this.onFailure = props.onFailure;
        this.onCancel = props.onCancel ?? undefined;
    }
    addToDocument(doc) {
        doc.addStep(this);
    }
    prepareSsmEntry(inputs) {
        // Maps maintain insertion order
        const ssmDef = new Map();
        if (this.description) {
            ssmDef.set('description', this.description);
        }
        ssmDef.set('name', this.name);
        ssmDef.set('action', this.action);
        ssmDef.set('inputs', inputs);
        const formattedOutputs = this.listOutputs().map(output => this.formatOutput(output));
        if (this.listOutputs().length > 0) {
            ssmDef.set('outputs', formattedOutputs);
        }
        if (this.isEnd) {
            ssmDef.set('isEnd', true);
        }
        if (this.maxAttempts != AutomationStep.DEFAULT_MAX_ATTEMPTS) {
            ssmDef.set('maxAttempts', this.maxAttempts);
        }
        if (this.timeoutSeconds != AutomationStep.DEFAULT_TIMEOUT) {
            ssmDef.set('maxAttempts', this.timeoutSeconds);
        }
        if (this.onCancel) {
            ssmDef.set('onCancel', 'step:' + this.onCancel.name);
        }
        if (this.onFailure) {
            ssmDef.set('onCancel', 'step:' + this.onFailure.name);
        }
        const ssmDict = {};
        ssmDef.forEach((value, key) => {
            ssmDict[key] = value;
        });
        return ssmDict;
    }
    /**
       * Formats the provided output into an object that can be used to generate the SSM yaml/json representation.
       */
    formatOutput(output) {
        return {
            Name: output.name,
            Selector: output.selector,
            Type: new data_type_1.DataType(output.outputType).toSsmString(),
        };
    }
    variables() {
        return Object.assign({}, ...this.listOutputs()
            .map(out => ({ [out.name]: new __1.StringVariable(`${this.name}.${out.name}`) })));
    }
}
exports.AutomationStep = AutomationStep;
_a = JSII_RTTI_SYMBOL_1;
AutomationStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AutomationStep", version: "0.0.15" };
AutomationStep.DEFAULT_TIMEOUT = 3600;
AutomationStep.DEFAULT_MAX_ATTEMPTS = 1;
//# sourceMappingURL=data:application/json;base64,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