import { IGenericVariable } from './variable';
/**
 * A secure string variable. Only supported by Command documents (only supported in downloadContent plugin).
 */
export declare abstract class SecureVariable implements IGenericVariable {
    static ofSecureToken(secureToken: string): SsmSecureVariable;
    static ofParameter(reference: string): NonSecureVariable;
    static ofValue(value: string): HardCodedSecureVariable;
    abstract print(): any;
    abstract requiredInputs(): string[];
    abstract resolve(inputs: Record<string, any>): any;
    toJSON(): any;
}
/**
 * A hard-coded string variable.
 * Used when not dependent on step inputs.
 */
export declare class HardCodedSecureVariable extends SecureVariable {
    readonly val: string;
    constructor(val: string);
    print(): any;
    requiredInputs(): string[];
    resolve(_inputs: Record<string, any>): any;
}
/**
 * A string variable reference.
 * Used to resolve the value from step inputs.
 */
export declare class NonSecureVariable extends SecureVariable {
    readonly reference: string;
    constructor(reference: string);
    resolve(inputs: Record<string, any>): any;
    print(): string | any;
    requiredInputs(): string[];
}
export declare class SsmSecureVariable extends SecureVariable {
    readonly secureToken: string;
    constructor(secureToken: string);
    resolve(_inputs: Record<string, any>): any;
    print(): string | any;
    requiredInputs(): string[];
}
