"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockAwsInvoker = exports.ReflectiveAwsInvoker = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const immutable_1 = require("immutable");
const synchronous_promise_1 = require("../sync/synchronous-promise");
/**
 * Implementation of IAwsInvoker that executes the AWS api for real.
 * If using this implementation, be sure that AWS credentials are available to the execution.
 */
class ReflectiveAwsInvoker {
    invoke(invocation) {
        const wrappedAwsResponse = new synchronous_promise_1.SynchronousPromise().wait('../../lib/sync/aws-async-invoker', 'AwsAsyncInvoker', [invocation.service, invocation.awsApi, invocation.awsParams]);
        if (wrappedAwsResponse.status == 'FAILURE') {
            console.error(`Exception occurred calling AWS API with ${JSON.stringify(invocation)}: ${wrappedAwsResponse.Payload}`);
            throw new Error(wrappedAwsResponse.Payload);
        }
        else {
            return wrappedAwsResponse.Payload;
        }
    }
}
exports.ReflectiveAwsInvoker = ReflectiveAwsInvoker;
_a = JSII_RTTI_SYMBOL_1;
ReflectiveAwsInvoker[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ReflectiveAwsInvoker", version: "0.0.15" };
/**
 * Mock implementation of IAwsInvoker.
 * This class can be reused for testing in exported JSII languages.
 */
class MockAwsInvoker {
    constructor() {
        /**
           * All of the invocations that have been submitted to this invoker until present.
           */
        this.previousInvocations = [];
        this.mockReturn = [];
        // @ts-ignore
        this.mockResponses = new immutable_1.Map({});
    }
    /**
       * Saves the invocation to be retieved using getInvocations().
       * @returns the next result as set by the setReturn function
       */
    invoke(invocation) {
        this.previousInvocations.push(invocation);
        if (this.mockResponses.has(immutable_1.fromJS(invocation))) {
            return this.mockResponses.get(immutable_1.fromJS(invocation));
        }
        return this.mockReturn.shift() || this.lastReturn;
    }
    /**
       * Set the next return value. This function can be chained to return subsequent return values.
       * Values are read in order they were inserted.
       * The last value is used as a default if there are no other values retrieved.
       * In that way this function behaves the same way as Mockito .thenReturn(val).
       */
    nextReturn(awsResult) {
        this.mockReturn.push(awsResult);
        this.lastReturn = awsResult;
        return this;
    }
    /**
       * Allows developers to mock out responses from the AwsInvoker depending on the input that it receives.
       * @param when defines the invocation to match and return the then
       * @param then is the value that should be returned if the above when Invocation is matched
       */
    whenThen(when, then) {
        this.mockResponses = this.mockResponses.set(immutable_1.fromJS(when), then);
    }
}
exports.MockAwsInvoker = MockAwsInvoker;
_b = JSII_RTTI_SYMBOL_1;
MockAwsInvoker[_b] = { fqn: "@cdklabs/cdk-ssm-documents.MockAwsInvoker", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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