"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Precondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_variable_1 = require("../interface/variables/string-variable");
const operation_1 = require("./operation");
const PLATFORM_TYPE = 'platformType';
class Precondition {
    constructor(props) {
        this.operationType = props.operationType;
        this.variable1 = props.variable1;
        this.variable2 = props.variable2;
    }
    /**
       * Returns a new Precondition
       * @param platform The platform the preconditions tests against
       * @returns new Precondition with platformType EnvironmentVariable, operation and a constant
       */
    static newPlatformPrecondition(platform) {
        return new Precondition({
            operationType: operation_1.Operation.STRING_EQUALS,
            variable1: new PlatformTypeStringVariable(PLATFORM_TYPE),
            variable2: new string_variable_1.HardCodedString(platform),
        });
    }
    /**
       * Evaluates if the precondition is met, by comparing the variable with the constant using the operator.
       * @returns true if the evaluation is true. False otherwise.
       */
    evaluate(inputs) {
        const value1 = inputs[Precondition.INJECTED_PLAYFORM_TYPE_KEY];
        const value2 = this.variable2.resolve(inputs);
        return new operation_1.OperationEvaluator(this.operationType).evaluate(value1, value2);
    }
    /**
       * @returns an object that can be used to print this choice into yaml/json format.
       */
    asSsmEntry() {
        const variable1Entry = this.variable1.print();
        const variable2Entry = this.variable2.print();
        return {
            [new operation_1.OperationEvaluator(this.operationType).toOperationName()]: [
                variable1Entry,
                variable2Entry,
            ],
        };
    }
}
exports.Precondition = Precondition;
_a = JSII_RTTI_SYMBOL_1;
Precondition[_a] = { fqn: "@cdklabs/cdk-ssm-documents.Precondition", version: "0.0.15" };
Precondition.INJECTED_PLAYFORM_TYPE_KEY = 'injected_platform_type';
/**
 * These string variables are being set by SSM agent during execution. For example; platformType.
 * Variables are printed as using with brackets, e.g, myVariable instead of {{ myVariable }}.
 * To resolve a variable, you must supply the available inputs and the variable will resolve the value.
 */
class PlatformTypeStringVariable extends string_variable_1.StringVariable {
    constructor(reference) {
        super(reference);
        this.reference = reference;
    }
    print() {
        return `${this.reference}`;
    }
    toJSON() {
        return this.print();
    }
}
//# sourceMappingURL=data:application/json;base64,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