"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Platforms = exports.Platform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Command steps are not all applicable to all platforms.
 * Each command step declares which Platforms it supports.
 * That allows customers to validate their CommandDocument against a given platform prior to execution.
 */
var Platform;
(function (Platform) {
    Platform["LINUX"] = "Linux";
    Platform["WINDOWS"] = "Windows";
    Platform["MAC_OS"] = "MacOs";
})(Platform = exports.Platform || (exports.Platform = {}));
class Platforms {
    constructor() { }
    /**
       * Converts a string to Platform
       * @param platformString a platform name to return its Platform type
       * @returns a Platform
       * @throws if platofrmString is not supported
       */
    static toPlatform(platformString) {
        const platform = this.STRING_TO_PLATFORM[platformString];
        if (platform != undefined) {
            return platform;
        }
        else {
            throw new Error(`Runtime ${platform} not supported.`);
        }
    }
}
exports.Platforms = Platforms;
_a = JSII_RTTI_SYMBOL_1;
Platforms[_a] = { fqn: "@cdklabs/cdk-ssm-documents.Platforms", version: "0.0.15" };
Platforms.STRING_TO_PLATFORM = {
    Linux: Platform.LINUX,
    Windows: Platform.WINDOWS,
    MacOs: Platform.MAC_OS,
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGxhdGZvcm0uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZG9tYWluL3BsYXRmb3JtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7Ozs7R0FJRztBQUNILElBQVksUUFJWDtBQUpELFdBQVksUUFBUTtJQUNsQiwyQkFBZSxDQUFBO0lBQ2YsK0JBQW1CLENBQUE7SUFDbkIsNEJBQWdCLENBQUE7QUFDbEIsQ0FBQyxFQUpXLFFBQVEsR0FBUixnQkFBUSxLQUFSLGdCQUFRLFFBSW5CO0FBRUQsTUFBYSxTQUFTO0lBdUJwQixnQkFBdUIsQ0FBQztJQWZ4Qjs7Ozs7U0FLSztJQUNFLE1BQU0sQ0FBQyxVQUFVLENBQUMsY0FBc0I7UUFDN0MsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ3pELElBQUksUUFBUSxJQUFJLFNBQVMsRUFBRTtZQUN6QixPQUFPLFFBQVEsQ0FBQztTQUNqQjthQUFNO1lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQyxXQUFXLFFBQVEsaUJBQWlCLENBQUMsQ0FBQztTQUN2RDtJQUNILENBQUM7O0FBckJILDhCQXlCQzs7O0FBdkJ3Qiw0QkFBa0IsR0FBaUM7SUFDeEUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxLQUFLO0lBQ3JCLE9BQU8sRUFBRSxRQUFRLENBQUMsT0FBTztJQUN6QixLQUFLLEVBQUUsUUFBUSxDQUFDLE1BQU07Q0FDdkIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29tbWFuZCBzdGVwcyBhcmUgbm90IGFsbCBhcHBsaWNhYmxlIHRvIGFsbCBwbGF0Zm9ybXMuXG4gKiBFYWNoIGNvbW1hbmQgc3RlcCBkZWNsYXJlcyB3aGljaCBQbGF0Zm9ybXMgaXQgc3VwcG9ydHMuXG4gKiBUaGF0IGFsbG93cyBjdXN0b21lcnMgdG8gdmFsaWRhdGUgdGhlaXIgQ29tbWFuZERvY3VtZW50IGFnYWluc3QgYSBnaXZlbiBwbGF0Zm9ybSBwcmlvciB0byBleGVjdXRpb24uXG4gKi9cbmV4cG9ydCBlbnVtIFBsYXRmb3JtIHtcbiAgTElOVVggPSAnTGludXgnLFxuICBXSU5ET1dTID0gJ1dpbmRvd3MnLFxuICBNQUNfT1MgPSAnTWFjT3MnXG59XG5cbmV4cG9ydCBjbGFzcyBQbGF0Zm9ybXMge1xuXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1RSSU5HX1RPX1BMQVRGT1JNOiB7IFtuYW1lOiBzdHJpbmddOiBQbGF0Zm9ybSB9ID0ge1xuICAgIExpbnV4OiBQbGF0Zm9ybS5MSU5VWCxcbiAgICBXaW5kb3dzOiBQbGF0Zm9ybS5XSU5ET1dTLFxuICAgIE1hY09zOiBQbGF0Zm9ybS5NQUNfT1MsXG4gIH07XG5cbiAgLyoqXG4gICAgICogQ29udmVydHMgYSBzdHJpbmcgdG8gUGxhdGZvcm1cbiAgICAgKiBAcGFyYW0gcGxhdGZvcm1TdHJpbmcgYSBwbGF0Zm9ybSBuYW1lIHRvIHJldHVybiBpdHMgUGxhdGZvcm0gdHlwZVxuICAgICAqIEByZXR1cm5zIGEgUGxhdGZvcm1cbiAgICAgKiBAdGhyb3dzIGlmIHBsYXRvZnJtU3RyaW5nIGlzIG5vdCBzdXBwb3J0ZWRcbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyB0b1BsYXRmb3JtKHBsYXRmb3JtU3RyaW5nOiBzdHJpbmcpOiBQbGF0Zm9ybSB7XG4gICAgY29uc3QgcGxhdGZvcm0gPSB0aGlzLlNUUklOR19UT19QTEFURk9STVtwbGF0Zm9ybVN0cmluZ107XG4gICAgaWYgKHBsYXRmb3JtICE9IHVuZGVmaW5lZCkge1xuICAgICAgcmV0dXJuIHBsYXRmb3JtO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYFJ1bnRpbWUgJHtwbGF0Zm9ybX0gbm90IHN1cHBvcnRlZC5gKTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKCkge31cblxufVxuIl19