"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const document_builder_1 = require("./document-builder");
const ssm_document_1 = require("./ssm-document");
/**
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html
 * The CommandDocument will delegate execution responsibility to the CammandSteps that it receives.
 * The SsmDocument parent class contains methods to runSimulation() as well as print().
 */
class CommandDocument extends ssm_document_1.SsmDocument {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.builder = new document_builder_1.CommandDocumentBuilder();
    }
    addStep(component) {
        component.addToDocument(this.builder);
    }
    buildSsmDocument() {
        const runCommandSteps = this.collectedSteps().map(step => step.toSsmEntry());
        const root = {
            description: this.description,
            schemaVersion: '2.2',
            parameters: this.formatInputs(),
        };
        if (this.assumeRole) {
            root.assumeRole = this.assumeRole;
        }
        if (this.docOutputs.length > 0) {
            root.outputs = this.docOutputs;
        }
        root.mainSteps = runCommandSteps;
        return root;
    }
    collectedSteps() {
        if (this.builder.steps.length == 0) {
            throw new Error('No Steps found. Either you did not declare steps or did not synthesize CDK. ' +
                'Be sure to run cdk.SynthUtils.synthesize(stack) prior to printing or running simulation');
        }
        return this.builder.steps;
    }
    documentType() {
        return 'Command';
    }
}
exports.CommandDocument = CommandDocument;
_a = JSII_RTTI_SYMBOL_1;
CommandDocument[_a] = { fqn: "@cdklabs/cdk-ssm-documents.CommandDocument", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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