# Do not edit this file; it was automatically generated.

import ctypes
import deprecation

from nidaqmx._lib import lib_importer, ctypes_byte_str
from nidaqmx.errors import (
    check_for_error, is_string_buffer_too_small, is_array_buffer_too_small)
from nidaqmx.constants import (
    Level, WatchdogAOExpirState, WatchdogCOExpirState)


class ExpirationState:
    """
    Represents a DAQmx Watchdog expiration state.
    """
    def __init__(self, task_handle, physical_channel):
        self._handle = task_handle
        self._physical_channel = physical_channel

    def __eq__(self, other):
        if isinstance(other, self.__class__):
            return (self._handle == other._handle and
                    self._physical_channel == other._physical_channel)
        return False

    def __hash__(self):
        return hash((self._handle.value, self._physical_channel))

    def __ne__(self, other):
        return not self.__eq__(other)

    @property
    def ao_output_type(self):
        """
        :class:`nidaqmx.constants.WatchdogAOExpirState`: Specifies the
            output type of the analog output physical channels when the
            watchdog task expires.
        """
        val = ctypes.c_int()

        cfunc = lib_importer.windll.DAQmxGetWatchdogAOOutputType
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str,
                        ctypes.POINTER(ctypes.c_int)]

        error_code = cfunc(
            self._handle, self._physical_channel, ctypes.byref(val))
        check_for_error(error_code)

        return WatchdogAOExpirState(val.value)

    @ao_output_type.setter
    def ao_output_type(self, val):
        val = val.value
        cfunc = lib_importer.windll.DAQmxSetWatchdogAOOutputType
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str,
                        ctypes.c_int]

        error_code = cfunc(
            self._handle, self._physical_channel, val)
        check_for_error(error_code)

    @ao_output_type.deleter
    def ao_output_type(self):
        cfunc = lib_importer.windll.DAQmxResetWatchdogAOOutputType
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str]

        error_code = cfunc(
            self._handle, self._physical_channel)
        check_for_error(error_code)

    @property
    def ao_state(self):
        """
        float: Specifies the state to set the analog output physical
            channels when the watchdog task expires.
        """
        val = ctypes.c_double()

        cfunc = lib_importer.windll.DAQmxGetWatchdogAOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str,
                        ctypes.POINTER(ctypes.c_double)]

        error_code = cfunc(
            self._handle, self._physical_channel, ctypes.byref(val))
        check_for_error(error_code)

        return val.value

    @ao_state.setter
    def ao_state(self, val):
        cfunc = lib_importer.windll.DAQmxSetWatchdogAOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str,
                        ctypes.c_double]

        error_code = cfunc(
            self._handle, self._physical_channel, val)
        check_for_error(error_code)

    @ao_state.deleter
    def ao_state(self):
        cfunc = lib_importer.windll.DAQmxResetWatchdogAOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str]

        error_code = cfunc(
            self._handle, self._physical_channel)
        check_for_error(error_code)

    @property
    def co_state(self):
        """
        :class:`nidaqmx.constants.WatchdogCOExpirState`: Specifies the
            state to set the counter output channel terminal when the
            watchdog task expires.
        """
        val = ctypes.c_int()

        cfunc = lib_importer.windll.DAQmxGetWatchdogCOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str,
                        ctypes.POINTER(ctypes.c_int)]

        error_code = cfunc(
            self._handle, self._physical_channel, ctypes.byref(val))
        check_for_error(error_code)

        return WatchdogCOExpirState(val.value)

    @co_state.setter
    def co_state(self, val):
        val = val.value
        cfunc = lib_importer.windll.DAQmxSetWatchdogCOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str,
                        ctypes.c_int]

        error_code = cfunc(
            self._handle, self._physical_channel, val)
        check_for_error(error_code)

    @co_state.deleter
    def co_state(self):
        cfunc = lib_importer.windll.DAQmxResetWatchdogCOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str]

        error_code = cfunc(
            self._handle, self._physical_channel)
        check_for_error(error_code)

    @property
    def do_state(self):
        """
        :class:`nidaqmx.constants.Level`: Specifies the state to which
            to set the digital physical channels when the watchdog task
            expires.  You cannot modify the expiration state of
            dedicated digital input physical channels.
        """
        val = ctypes.c_int()

        cfunc = lib_importer.windll.DAQmxGetWatchdogDOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str,
                        ctypes.POINTER(ctypes.c_int)]

        error_code = cfunc(
            self._handle, self._physical_channel, ctypes.byref(val))
        check_for_error(error_code)

        return Level(val.value)

    @do_state.setter
    def do_state(self, val):
        val = val.value
        cfunc = lib_importer.windll.DAQmxSetWatchdogDOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str,
                        ctypes.c_int]

        error_code = cfunc(
            self._handle, self._physical_channel, val)
        check_for_error(error_code)

    @do_state.deleter
    def do_state(self):
        cfunc = lib_importer.windll.DAQmxResetWatchdogDOExpirState
        if cfunc.argtypes is None:
            with cfunc.arglock:
                if cfunc.argtypes is None:
                    cfunc.argtypes = [
                        lib_importer.task_handle, ctypes_byte_str]

        error_code = cfunc(
            self._handle, self._physical_channel)
        check_for_error(error_code)

    @property
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use ao_output_type instead.")
    def expir_states_ao_type(self):
        return self.ao_output_type

    @expir_states_ao_type.setter
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use ao_output_type instead.")
    def expir_states_ao_type(self, val):
        self.ao_output_type = val

    @expir_states_ao_type.deleter
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use ao_output_type instead.")
    def expir_states_ao_type(self):
        del self.ao_output_type

    @property
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use co_state instead.")
    def expir_states_co_state(self):
        return self.co_state

    @expir_states_co_state.setter
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use co_state instead.")
    def expir_states_co_state(self, val):
        self.co_state = val

    @expir_states_co_state.deleter
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use co_state instead.")
    def expir_states_co_state(self):
        del self.co_state

    @property
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use do_state instead.")
    def expir_states_do_state(self):
        return self.do_state

    @expir_states_do_state.setter
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use do_state instead.")
    def expir_states_do_state(self, val):
        self.do_state = val

    @expir_states_do_state.deleter
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use do_state instead.")
    def expir_states_do_state(self):
        del self.do_state

    @property
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use ao_state instead.")
    def expir_states_ao_state(self):
        return self.ao_state

    @expir_states_ao_state.setter
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use ao_state instead.")
    def expir_states_ao_state(self, val):
        self.ao_state = val

    @expir_states_ao_state.deleter
    @deprecation.deprecated(deprecated_in="0.7.0", details="Use ao_state instead.")
    def expir_states_ao_state(self):
        del self.ao_state

