# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.face_verifys = FaceVerifyService(self)
        



class FaceVerifyService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def crop_face_image(self, tenant_key=None, timeout=None):
        # type: (str, int) -> FaceVerifyCropFaceImageReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return FaceVerifyCropFaceImageReqCall(self, request_opts=request_opts)

    def query_auth_result(self, tenant_key=None, timeout=None):
        # type: (str, int) -> FaceVerifyQueryAuthResultReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return FaceVerifyQueryAuthResultReqCall(self, request_opts=request_opts)

    def upload_face_image(self, tenant_key=None, timeout=None):
        # type: (str, int) -> FaceVerifyUploadFaceImageReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return FaceVerifyUploadFaceImageReqCall(self, request_opts=request_opts)



class FaceVerifyCropFaceImageReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FaceVerifyService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_raw_image(self, rawImage):
        # type: (IO[Any]) -> FaceVerifyCropFaceImageReqCall
        self.body.add_file('raw_image', FormDataFile(rawImage))
        return self

    def do(self):
        # type: () -> Response[FaceVerifyCropFaceImageResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('face_verify/v1/crop_face_image', 'POST', [ACCESS_TOKEN_TYPE_TENANT], self.body, output_class=FaceVerifyCropFaceImageResult , request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FaceVerifyQueryAuthResultReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FaceVerifyService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_req_order_no(self, reqOrderNo):
        # type: (str) -> FaceVerifyQueryAuthResultReqCall
        self.query_params['req_order_no'] = reqOrderNo
        return self

    def set_open_id(self, openId):
        # type: (str) -> FaceVerifyQueryAuthResultReqCall
        self.query_params['open_id'] = openId
        return self

    def set_employee_id(self, employeeId):
        # type: (str) -> FaceVerifyQueryAuthResultReqCall
        self.query_params['employee_id'] = employeeId
        return self

    def do(self):
        # type: () -> Response[FaceVerifyQueryAuthResultResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('face_verify/v1/query_auth_result', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=FaceVerifyQueryAuthResultResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FaceVerifyUploadFaceImageReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FaceVerifyService, List[Any]) -> None

        self.service = service
        self.body = FormData()
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_image(self, image):
        # type: (IO[Any]) -> FaceVerifyUploadFaceImageReqCall
        self.body.add_file('image', FormDataFile(image))
        return self

    def set_open_id(self, openId):
        # type: (str) -> FaceVerifyUploadFaceImageReqCall
        self.query_params['open_id'] = openId
        return self

    def set_employee_id(self, employeeId):
        # type: (str) -> FaceVerifyUploadFaceImageReqCall
        self.query_params['employee_id'] = employeeId
        return self

    def do(self):
        # type: () -> Response[FaceVerifyUploadFaceImageResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('face_verify/v1/upload_face_image', 'POST', [ACCESS_TOKEN_TYPE_TENANT], self.body, output_class=FaceVerifyUploadFaceImageResult , request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

