import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type FreyrAIM::ImpactApi::ApiHandle::MODULE
 *
 * @schema CfnApiHandleModuleProps
 */
export interface CfnApiHandleModuleProps {
    /**
     * @schema CfnApiHandleModuleProps#Parameters
     */
    readonly parameters?: CfnApiHandleModulePropsParameters;
    /**
     * @schema CfnApiHandleModuleProps#Resources
     */
    readonly resources?: CfnApiHandleModulePropsResources;
}
/**
 * Converts an object of type 'CfnApiHandleModuleProps' to JSON representation.
 */
export declare function toJson_CfnApiHandleModuleProps(obj: CfnApiHandleModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsParameters
 */
export interface CfnApiHandleModulePropsParameters {
    /**
     * The lambda function`s Image URI
     *
     * @schema CfnApiHandleModulePropsParameters#ImageUri
     */
    readonly imageUri?: CfnApiHandleModulePropsParametersImageUri;
    /**
     * The lambda function`s name
     *
     * @schema CfnApiHandleModulePropsParameters#FunctionName
     */
    readonly functionName?: CfnApiHandleModulePropsParametersFunctionName;
    /**
     * The endpoint name
     *
     * @schema CfnApiHandleModulePropsParameters#EndpointName
     */
    readonly endpointName?: CfnApiHandleModulePropsParametersEndpointName;
    /**
     * The similarity url
     *
     * @schema CfnApiHandleModulePropsParameters#SimilarityUrl
     */
    readonly similarityUrl?: CfnApiHandleModulePropsParametersSimilarityUrl;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsParameters(obj: CfnApiHandleModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResources
 */
export interface CfnApiHandleModulePropsResources {
    /**
     * @schema CfnApiHandleModulePropsResources#DocContentPostMethod
     */
    readonly docContentPostMethod?: CfnApiHandleModulePropsResourcesDocContentPostMethod;
    /**
     * @schema CfnApiHandleModulePropsResources#DocContentResource
     */
    readonly docContentResource?: CfnApiHandleModulePropsResourcesDocContentResource;
    /**
     * @schema CfnApiHandleModulePropsResources#ImpactApi
     */
    readonly impactApi?: CfnApiHandleModulePropsResourcesImpactApi;
    /**
     * @schema CfnApiHandleModulePropsResources#ClassifierResource
     */
    readonly classifierResource?: CfnApiHandleModulePropsResourcesClassifierResource;
    /**
     * @schema CfnApiHandleModulePropsResources#ApiGatewayCloudWatchLogsRole
     */
    readonly apiGatewayCloudWatchLogsRole?: CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsRole;
    /**
     * @schema CfnApiHandleModulePropsResources#ApiGatewayCloudWatchLogsAccount
     */
    readonly apiGatewayCloudWatchLogsAccount?: CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsAccount;
    /**
     * @schema CfnApiHandleModulePropsResources#DeploymentDocContentPost
     */
    readonly deploymentDocContentPost?: CfnApiHandleModulePropsResourcesDeploymentDocContentPost;
    /**
     * @schema CfnApiHandleModulePropsResources#LambdaPermission
     */
    readonly lambdaPermission?: CfnApiHandleModulePropsResourcesLambdaPermission;
    /**
     * @schema CfnApiHandleModulePropsResources#ImpactApiHandleLambdaFunction
     */
    readonly impactApiHandleLambdaFunction?: CfnApiHandleModulePropsResourcesImpactApiHandleLambdaFunction;
    /**
     * @schema CfnApiHandleModulePropsResources#LambdaFunctionCreateRole
     */
    readonly lambdaFunctionCreateRole?: CfnApiHandleModulePropsResourcesLambdaFunctionCreateRole;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResources(obj: CfnApiHandleModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The lambda function`s Image URI
 *
 * @schema CfnApiHandleModulePropsParametersImageUri
 */
export interface CfnApiHandleModulePropsParametersImageUri {
    /**
     * @schema CfnApiHandleModulePropsParametersImageUri#Type
     */
    readonly type: string;
    /**
     * @schema CfnApiHandleModulePropsParametersImageUri#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsParametersImageUri' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsParametersImageUri(obj: CfnApiHandleModulePropsParametersImageUri | undefined): Record<string, any> | undefined;
/**
 * The lambda function`s name
 *
 * @schema CfnApiHandleModulePropsParametersFunctionName
 */
export interface CfnApiHandleModulePropsParametersFunctionName {
    /**
     * @schema CfnApiHandleModulePropsParametersFunctionName#Type
     */
    readonly type: string;
    /**
     * @schema CfnApiHandleModulePropsParametersFunctionName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsParametersFunctionName' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsParametersFunctionName(obj: CfnApiHandleModulePropsParametersFunctionName | undefined): Record<string, any> | undefined;
/**
 * The endpoint name
 *
 * @schema CfnApiHandleModulePropsParametersEndpointName
 */
export interface CfnApiHandleModulePropsParametersEndpointName {
    /**
     * @schema CfnApiHandleModulePropsParametersEndpointName#Type
     */
    readonly type: string;
    /**
     * @schema CfnApiHandleModulePropsParametersEndpointName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsParametersEndpointName' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsParametersEndpointName(obj: CfnApiHandleModulePropsParametersEndpointName | undefined): Record<string, any> | undefined;
/**
 * The similarity url
 *
 * @schema CfnApiHandleModulePropsParametersSimilarityUrl
 */
export interface CfnApiHandleModulePropsParametersSimilarityUrl {
    /**
     * @schema CfnApiHandleModulePropsParametersSimilarityUrl#Type
     */
    readonly type: string;
    /**
     * @schema CfnApiHandleModulePropsParametersSimilarityUrl#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsParametersSimilarityUrl' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsParametersSimilarityUrl(obj: CfnApiHandleModulePropsParametersSimilarityUrl | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesDocContentPostMethod
 */
export interface CfnApiHandleModulePropsResourcesDocContentPostMethod {
    /**
     * @schema CfnApiHandleModulePropsResourcesDocContentPostMethod#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesDocContentPostMethod#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesDocContentPostMethod' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesDocContentPostMethod(obj: CfnApiHandleModulePropsResourcesDocContentPostMethod | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesDocContentResource
 */
export interface CfnApiHandleModulePropsResourcesDocContentResource {
    /**
     * @schema CfnApiHandleModulePropsResourcesDocContentResource#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesDocContentResource#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesDocContentResource' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesDocContentResource(obj: CfnApiHandleModulePropsResourcesDocContentResource | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesImpactApi
 */
export interface CfnApiHandleModulePropsResourcesImpactApi {
    /**
     * @schema CfnApiHandleModulePropsResourcesImpactApi#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesImpactApi#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesImpactApi' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesImpactApi(obj: CfnApiHandleModulePropsResourcesImpactApi | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesClassifierResource
 */
export interface CfnApiHandleModulePropsResourcesClassifierResource {
    /**
     * @schema CfnApiHandleModulePropsResourcesClassifierResource#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesClassifierResource#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesClassifierResource' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesClassifierResource(obj: CfnApiHandleModulePropsResourcesClassifierResource | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsRole
 */
export interface CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsRole {
    /**
     * @schema CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsRole' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsRole(obj: CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsAccount
 */
export interface CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsAccount {
    /**
     * @schema CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsAccount#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsAccount#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsAccount' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsAccount(obj: CfnApiHandleModulePropsResourcesApiGatewayCloudWatchLogsAccount | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesDeploymentDocContentPost
 */
export interface CfnApiHandleModulePropsResourcesDeploymentDocContentPost {
    /**
     * @schema CfnApiHandleModulePropsResourcesDeploymentDocContentPost#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesDeploymentDocContentPost#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesDeploymentDocContentPost' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesDeploymentDocContentPost(obj: CfnApiHandleModulePropsResourcesDeploymentDocContentPost | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesLambdaPermission
 */
export interface CfnApiHandleModulePropsResourcesLambdaPermission {
    /**
     * @schema CfnApiHandleModulePropsResourcesLambdaPermission#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesLambdaPermission#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesLambdaPermission' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesLambdaPermission(obj: CfnApiHandleModulePropsResourcesLambdaPermission | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesImpactApiHandleLambdaFunction
 */
export interface CfnApiHandleModulePropsResourcesImpactApiHandleLambdaFunction {
    /**
     * @schema CfnApiHandleModulePropsResourcesImpactApiHandleLambdaFunction#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesImpactApiHandleLambdaFunction#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesImpactApiHandleLambdaFunction' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesImpactApiHandleLambdaFunction(obj: CfnApiHandleModulePropsResourcesImpactApiHandleLambdaFunction | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiHandleModulePropsResourcesLambdaFunctionCreateRole
 */
export interface CfnApiHandleModulePropsResourcesLambdaFunctionCreateRole {
    /**
     * @schema CfnApiHandleModulePropsResourcesLambdaFunctionCreateRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiHandleModulePropsResourcesLambdaFunctionCreateRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiHandleModulePropsResourcesLambdaFunctionCreateRole' to JSON representation.
 */
export declare function toJson_CfnApiHandleModulePropsResourcesLambdaFunctionCreateRole(obj: CfnApiHandleModulePropsResourcesLambdaFunctionCreateRole | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `FreyrAIM::ImpactApi::ApiHandle::MODULE`
 *
 * @cloudformationResource FreyrAIM::ImpactApi::ApiHandle::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnApiHandleModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "FreyrAIM::ImpactApi::ApiHandle::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnApiHandleModuleProps;
    /**
     * Create a new `FreyrAIM::ImpactApi::ApiHandle::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnApiHandleModuleProps);
}
