"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kafka_generated_1 = require("./kafka.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return kafka_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::KAFKA::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::KAFKA::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new kafka_generated_1.RosInstance(this, id, {
            deployType: props.deployType,
            diskType: props.diskType,
            deployOption: props.deployOption,
            eipMax: props.eipMax,
            specType: props.specType,
            ioMax: props.ioMax,
            ioMaxSpec: props.ioMaxSpec,
            diskSize: props.diskSize,
            topicQuota: props.topicQuota,
            payType: props.payType === undefined || props.payType === null ? 'Hour' : props.payType,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrName = rosInstance.attrName;
        this.attrOrderId = rosInstance.attrOrderId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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