# Generated by Django 3.1.5 on 2021-02-18 10:30

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('ingress', '0006_endpoint_parser_enabled'),
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'name',
                    models.SlugField(
                        help_text="The end of the url and also the key with which it can be retrieved from the queue. For example, in the url /ingress/example, the string 'example' is the name of the collection.",
                        max_length=255,
                        unique=True,
                    ),
                ),
                ('ingress_enabled', models.BooleanField(default=True)),
                ('consumer_enabled', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='FailedMessage',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                (
                    'raw_data',
                    models.TextField(
                        help_text='To store raw received data to be consumed by a separate consumer'
                    ),
                ),
                ('consume_started_at', models.DateTimeField(db_index=True, null=True)),
                (
                    'consume_succeeded_at',
                    models.DateTimeField(db_index=True, null=True),
                ),
                ('consume_failed_at', models.DateTimeField(null=True)),
                (
                    'consume_fail_info',
                    models.TextField(
                        help_text='To store stack traces or other info about the fail',
                        null=True,
                    ),
                ),
                (
                    'collection',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='ingress.collection',
                    ),
                ),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                (
                    'raw_data',
                    models.TextField(
                        help_text='To store raw received data to be consumed by a separate consumer'
                    ),
                ),
                ('consume_started_at', models.DateTimeField(db_index=True, null=True)),
                (
                    'consume_succeeded_at',
                    models.DateTimeField(db_index=True, null=True),
                ),
                (
                    'collection',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='ingress.collection',
                    ),
                ),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='failedingressqueue',
            name='endpoint',
        ),
        migrations.RemoveField(
            model_name='ingressqueue',
            name='endpoint',
        ),
        migrations.DeleteModel(
            name='Endpoint',
        ),
        migrations.DeleteModel(
            name='FailedIngressQueue',
        ),
        migrations.DeleteModel(
            name='IngressQueue',
        ),
    ]
