::: src.render_engine.collection.Collection

# Passing Collection Variables to a Rendered Page

You can access attributes from the `Collection` class inside all of its rendered pages.

To do so, you must create an attribute called `template_vars` and populate it with a dictionary of key:value pairs.

In turn, each `Page` in the collection will have a `collection` attribute, similar to `Page.template_vars`. The dictionary includes any additional attributes you have defined within the `Collection` class.

```
from render_engine import Site, Collection

site = Site()

@site.collection
class BasicCollection(Collection):
    content_path = "content/pages"
    template_vars = {
        "some_value": "42"
    }

```

You can access `some_value` in your template like this:

```
{{collection.some_value}}
```

## Collection Archives

Collection archives are a special type of page that is automatically generated for each collection.

You can have archives generated by setting the `has_archive` to True.

If you call `archives` from your collection and neither `has_archive` nor `items_per_page` is set, an error will be raised and an archive containing all pages will be generated.

For more information, see [Collection Archives](./archive.md).
